/* GtkBalls
 * Copyright (C) 1998-1999 Eugene V. Morozov
 * Modifyed in 2001 by drF_ckoff
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <unistd.h>
#include <time.h>
#include <gtk/gtk.h>

#include "gtkballs.h"
#include "gtkutils.h"
#include "interface.h"
#include "preferences.h"
#include "gfx.h"

#define BUFFER_SIZE 1024
#define CONFIG_FILE_NAME ".gtkballsrc"

static GtkWidget *dialog;
static GtkWidget *show_hints_button,*show_path_button,*show_footprints_button,*show_destroy_button;
static GtkWidget *enable_time_limit_button, *time_limit_value_button;
gboolean Enable_time_limit;

gchar  **Available_Themes;
gint   Available_Themes_Number=0;
gint   SelectedTheme=0;

void theme_selection_made(GtkTreeSelection *selection, GtkTreeModel *model);
void preferences_ok(GtkWidget *widget, gpointer data);
void preferences_cancel(GtkWidget *widget, gpointer data);
void preferences_apply(GtkWidget *widget, gpointer data);
gint get_available_themes();

/* find gtkballsrc file location. returns NULL on out of memory =) */
gchar *find_rc_file(void) {
        gchar *rc_file, *err;

  	if(getenv("HOME")) {
		rc_file=g_strdup_printf("%s/" CONFIG_FILE_NAME, getenv ("HOME"));
    	} else { /* unable to read $HOME, assuming current directory */
    		rc_file=g_strdup(CONFIG_FILE_NAME);
        }
        if(!rc_file) {
        	err=g_strdup_printf(_("Cannot determine rc file name. ($HOME is toooooo long?)"));
                simple_message_box(err);
                g_free(err);
                return NULL;
        }
        return rc_file;
}

/* converts string to TRUE/FALSE. "true", "yes" or "1" is TRUE, otherwise - FALSE */
gboolean pref_str_to_bool(gchar *val) {
        if(!g_ascii_strcasecmp(val, "true") || !g_ascii_strcasecmp(val, "yes") || !g_ascii_strcasecmp(val, "1")) {
                return TRUE;
        }
        return FALSE;
}

/* converts boolean to string
   returns _pointer_ to "yes" or "no". returned string should NOT be free()'d! */
gchar *pref_bool_to_str(gboolean val) {
        return val ? "yes" : "no";
}

/* we use very lame preferences file format: ``property=value\n''.
   so - there must be no whitespaces on begin/end of line =) */
void load_preferences(void) {
  	FILE *fp;
        gchar *rc_file;
  	gchar buffer[BUFFER_SIZE];
        gchar **prop_val;

        if(!(rc_file=find_rc_file())) return;
  	if((fp=fopen(rc_file, "r"))) {
      		while(fgets(buffer, BUFFER_SIZE, fp)) {
                        g_strchomp(buffer);
                        prop_val=g_strsplit(buffer,"=",2);
                        if(prop_val[0] && prop_val[0][0] && prop_val[1] && prop_val[1][0]) {
                                if(!g_ascii_strcasecmp(prop_val[0],"show_hints")) {
                                        Show_next_colors=pref_str_to_bool(prop_val[1]);
                                } else if(!g_ascii_strcasecmp(prop_val[0],"show_path")) {
                                        Show_path=pref_str_to_bool(prop_val[1]);
                                } else if(!g_ascii_strcasecmp(prop_val[0],"show_footprints")) {
                                        Show_footprints=pref_str_to_bool(prop_val[1]);
                                } else if(!g_ascii_strcasecmp(prop_val[0],"show_destroy")) {
                                        Show_destroy=pref_str_to_bool(prop_val[1]);
                                } else if(!g_ascii_strcasecmp(prop_val[0],"theme_name")) {
                                        if(Current_theme_name) g_free(Current_theme_name);
                                        Current_theme_name=g_strdup(prop_val[1]);
                                        Theme_name=Current_theme_name;
                                } else if(!g_ascii_strcasecmp(prop_val[0],"rules_xsize")) {
                			Rules.xsize=atoi(prop_val[1]);
                                } else if(!g_ascii_strcasecmp(prop_val[0],"rules_ysize")) {
                			Rules.ysize=atoi(prop_val[1]);
                                } else if(!g_ascii_strcasecmp(prop_val[0],"rules_colors")) {
                			Rules.colors=atoi(prop_val[1]);
                                } else if(!g_ascii_strcasecmp(prop_val[0],"rules_next")) {
                			Rules.next=atoi(prop_val[1]);
                                } else if(!g_ascii_strcasecmp(prop_val[0],"rules_destroy")) {
                			Rules.destroy=atoi(prop_val[1]);
                                } else if(!g_ascii_strcasecmp(prop_val[0],"time_limit")) {
                			Timer_limit=atoi(prop_val[1]);
                                }
                        }
                        g_strfreev(prop_val);
		}
      		fclose(fp);
    	}
        g_free(rc_file);
}

/* writes ``property=value\n'' to fp.
   why i made it separate function? for "feature purposes" =) */
void write_pref_string(FILE *fp, gchar *property, gchar *value) {
	fprintf(fp, "%s=%s\n", property, value);
}

void write_pref_int(FILE *fp, gchar *property, gint value) {
	fprintf(fp, "%s=%d\n", property, value);
}

void save_preferences(void) {
  	FILE *fp;
  	gchar *rc_file, *err;

        if(!(rc_file=find_rc_file())) return;
  	if((fp=fopen(rc_file, "w"))) {
                write_pref_string(fp, "show_hints", pref_bool_to_str(Show_next_colors));
                write_pref_string(fp, "show_path", pref_bool_to_str(Show_path));
                write_pref_string(fp, "show_footprints", pref_bool_to_str(Show_footprints));
                write_pref_string(fp, "show_destroy", pref_bool_to_str(Show_destroy));
                write_pref_string(fp, "theme_name", Theme_name);
                write_pref_int(fp, "rules_xsize", Rules.xsize);
                write_pref_int(fp, "rules_ysize", Rules.ysize);
                write_pref_int(fp, "rules_colors", Rules.colors);
                write_pref_int(fp, "rules_next", Rules.next);
                write_pref_int(fp, "rules_destroy", Rules.destroy);
                write_pref_int(fp, "time_limit", Timer_limit);
        	fclose(fp);
    	} else {
        	err=g_strdup_printf(_("Can't write to %s: %s"), rc_file, strerror(errno));
                simple_message_box(err);
                g_free(err);
    	}
        g_free(rc_file);
}

void enable_time_limit_toggled(GtkToggleButton *togglebutton, gpointer user_data) {
        gboolean mode = gtk_toggle_button_get_active(togglebutton);

        Enable_time_limit = mode;
        gtk_widget_set_sensitive(time_limit_value_button, Enable_time_limit);
}

void preferences_dialog(void) {
  	GtkWidget *frame;
  	GtkWidget *big_vbox,*vbox,*buttons_box;
  	GtkWidget *theme_scrolled_window;
  	GtkWidget *separator;
  	GtkWidget *ok_button,*cancel_button,*apply_button;
  	gint      i;
        GtkListStore *store;
        GtkTreeIter iter;
	GtkWidget *treeview;
        GtkTreePath *path;
        GtkCellRenderer *renderer;
        GtkTreeViewColumn *column;
        gchar *pathstr;

	dialog=ut_window_new(_("Preferences"), "GtkBalls_Preferences", "GtkBalls", TRUE, TRUE, TRUE, 5);

  	big_vbox=gtk_vbox_new(FALSE, 0);
  	gtk_container_add(GTK_CONTAINER(dialog), big_vbox);

  	frame=gtk_frame_new(_("Preferences"));
  	gtk_box_pack_start(GTK_BOX(big_vbox), frame, FALSE, FALSE, 0);

	vbox=gtk_vbox_new(FALSE, 0);
  	gtk_container_add(GTK_CONTAINER(frame), vbox);

        show_hints_button=ut_check_button_new(_("Show colors that will appear on next turn"), Show_next_colors, vbox);
        show_path_button=ut_check_button_new(_("Show path of the ball"), Show_path, vbox);
        show_footprints_button=ut_check_button_new(_("Show footprints of the ball"), Show_footprints, vbox);
        show_destroy_button=ut_check_button_new(_("Show animation of disappearing of the ball"), Show_destroy, vbox);

        if(Timer_limit > 0) {
		Enable_time_limit=1;
        } else {
		Enable_time_limit=0;
        }
        enable_time_limit_button=ut_check_button_new(_("Enable time limit"), Enable_time_limit, vbox);
        g_signal_connect(G_OBJECT(enable_time_limit_button), "toggled", G_CALLBACK(enable_time_limit_toggled), NULL);
        time_limit_value_button=ut_spin_button_start_new(_("Time limit (seconds): "), 1, 3600, Timer_limit > 0 ? Timer_limit : 60, vbox);
        gtk_widget_set_sensitive(time_limit_value_button, Enable_time_limit);

  	theme_scrolled_window=gtk_scrolled_window_new(NULL, NULL);
        gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(theme_scrolled_window), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
        gtk_scrolled_window_set_shadow_type(GTK_SCROLLED_WINDOW(theme_scrolled_window), GTK_SHADOW_ETCHED_IN);
  	gtk_box_pack_start(GTK_BOX(vbox), theme_scrolled_window, FALSE, FALSE, 0);

        store=gtk_list_store_new(1, G_TYPE_STRING);

  	Available_Themes_Number=get_available_themes();
  	if(!Available_Themes_Number) {
                simple_message_box(_("No themes available! =(\n"));
                exit(1);
  	}

        SelectedTheme=0;
  	for(i=0;i<Available_Themes_Number;i++) {
                gtk_list_store_append(store, &iter);
                gtk_list_store_set(store, &iter, 0, (GValue *)Available_Themes[i], -1);
        	if(!strcmp(Available_Themes[i], Theme_name)) {
                	SelectedTheme=i;
        	}
  	}

        pathstr=g_strdup_printf("%u", SelectedTheme);
	path=gtk_tree_path_new_from_string(pathstr);
        g_free(pathstr);

      	treeview=gtk_tree_view_new_with_model(GTK_TREE_MODEL(store));
	gtk_widget_set_size_request(treeview, -1, 150);
      	g_object_unref(G_OBJECT(store));
      	gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(treeview), TRUE);
      	gtk_tree_view_set_search_column(GTK_TREE_VIEW(treeview), 0);
        gtk_tree_selection_set_mode(gtk_tree_view_get_selection(GTK_TREE_VIEW(treeview)), GTK_SELECTION_BROWSE);
  	g_signal_connect(G_OBJECT(gtk_tree_view_get_selection(GTK_TREE_VIEW(treeview))), "changed", G_CALLBACK(theme_selection_made), store);

  	gtk_container_add(GTK_CONTAINER(theme_scrolled_window), treeview);

        renderer=gtk_cell_renderer_text_new();
        column=gtk_tree_view_column_new_with_attributes(_("Select Theme"), renderer, "text", 0, NULL);
        gtk_tree_view_column_set_sort_column_id(column, 0);
        gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), column);

        if(path) {
		gtk_tree_selection_select_path(gtk_tree_view_get_selection(GTK_TREE_VIEW(treeview)), path);
                gtk_tree_view_set_cursor(GTK_TREE_VIEW(treeview), path, NULL, FALSE);
                gtk_tree_view_scroll_to_cell(GTK_TREE_VIEW(treeview), path, NULL, TRUE, 0, 0);
        	gtk_tree_path_free(path);
        }

  	separator=gtk_hseparator_new();
  	gtk_box_pack_start(GTK_BOX(big_vbox), separator, FALSE, FALSE, 5);

  	buttons_box=gtk_hbutton_box_new();
        gtk_button_box_set_layout(GTK_BUTTON_BOX(buttons_box), GTK_BUTTONBOX_SPREAD);
  	gtk_box_pack_start(GTK_BOX(big_vbox), buttons_box, TRUE, TRUE, 0);

	ok_button=ut_button_new_stock(GTK_STOCK_OK, preferences_ok, NULL, buttons_box);
	cancel_button=ut_button_new_stock(GTK_STOCK_CANCEL, preferences_cancel, dialog, buttons_box);
	apply_button=ut_button_new_stock(GTK_STOCK_APPLY, preferences_apply, NULL, buttons_box);

  	gtk_widget_show_all(dialog);
        gtk_widget_grab_default(ok_button);
  	gtk_grab_add(dialog);
}

/* find all available themes. if some of *alloc() fails - abort... stupid, heh? */
gint get_available_themes(void) {
  	DIR *directory;
  	struct dirent *dir_entry;
  	struct stat entry_stat;
  	gchar *entry,*currdir,*homedir,*rcentry,*err;
  	gint i,j,num,flag;

  	for(i=0;i<Available_Themes_Number;i++) free(Available_Themes[i]);
  	if(Available_Themes_Number) free(Available_Themes);
  	Available_Themes=NULL;
  	num=0;
  	currdir=installpath;
  	for(j=0;j<2;j++) {
        	if((directory=opendir(currdir))) {
                	while((dir_entry=readdir(directory))) {
                        	if(strncmp(dir_entry->d_name,".",2) && strncmp(dir_entry->d_name,"..",3)
				   && (entry=g_strconcat(currdir,dir_entry->d_name,NULL))) {
                                	if(!stat(entry,&entry_stat) && S_ISDIR(entry_stat.st_mode) && (rcentry=g_strconcat(entry,"/","themerc",NULL)) && !stat(rcentry,&entry_stat)) {
                                        	flag=0;
                                        	for(i=0;i<num && !flag;i++) {
                                                	if(!strcmp(Available_Themes[i],dir_entry->d_name)) {
								flag++;
                                                        }
                                        	}
                                        	if(!flag) {
                                                	num++;
                                                	Available_Themes=g_realloc(Available_Themes,num*sizeof(gchar *));
                                                        if(!(Available_Themes[num-1]=g_strdup(dir_entry->d_name))) {
        							err=g_strdup_printf(_("Cannot allocate %d bytes!"),strlen(dir_entry->d_name));
                						simple_message_box(err);
                						g_free(err);
                                                            	exit(1);
                                                        }
                                                }
                                        	g_free(rcentry);
                                        	g_free(entry);
                                	}
                        	}
                	}
                	closedir(directory);
        	}
        	if(!(homedir=getenv("HOME")) || !(currdir=g_strconcat(homedir,themeprefix,NULL))) {
                	return num;
        	}
  	}
	g_free(currdir);
  	return num;
}

void theme_selection_made(GtkTreeSelection *selection, GtkTreeModel *model) {
        GtkTreeIter iter;
        GtkTreePath *path;
        gchar *pathstr;

        if(gtk_tree_selection_get_selected(selection, NULL, &iter)) {
                path=gtk_tree_model_get_path(model, &iter);
                pathstr=gtk_tree_path_to_string(path);
                gtk_tree_path_free(path);
                SelectedTheme=atoi(pathstr);
                g_free(pathstr);
        }
}

void preferences_ok(GtkWidget *widget, gpointer data) {
  	preferences_apply(NULL, NULL);
  	gtk_widget_destroy(dialog);
}

void preferences_cancel(GtkWidget *widget, gpointer data) {
  	gtk_widget_destroy(dialog);
}

void preferences_apply(GtkWidget *widget, gpointer data) {
        gchar *msg, *save;

        if(strcmp(Available_Themes[SelectedTheme],Theme_name)!=0) {
                save=g_strdup(Theme_name);
                if(Current_theme_name) {
                        g_free(Current_theme_name);
                }
                Current_theme_name=g_strdup(Available_Themes[SelectedTheme]);
  		if(!load_theme(Current_theme_name)) {
                        msg=g_strconcat(_("Failed loading theme \""), Current_theme_name, "\"!\n", NULL);
                        simple_message_box(msg);
                        g_free(msg);
                        g_free(Current_theme_name);
                	Current_theme_name=g_strdup(save);
        	} else {
                	phase=0;
                	draw_board(DrawingArea, Pixmap);
                	draw_next_balls();
                }
  		Theme_name=Current_theme_name;
                g_free(save);
        }

        show_hide_next_balls((Show_next_colors=GTK_TOGGLE_BUTTON(show_hints_button)->active));
        Show_path=GTK_TOGGLE_BUTTON(show_path_button)->active;
        Show_footprints=GTK_TOGGLE_BUTTON(show_footprints_button)->active;
        Show_destroy=GTK_TOGGLE_BUTTON(show_destroy_button)->active;
        if(Enable_time_limit) {
        	Timer_start_time=time(NULL);
                Timer_limit=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(time_limit_value_button));
        } else {
                Timer_limit=-1;
        	gtk_label_set_text(GTK_LABEL(Timer_label), _("Time is unlimited"));
        }
  	save_preferences();
}
