/*
 *     gtkatlantic - the gtk+ monopd client, enjoy network monopoly games
 *
 *
 *  Copyright (C) 2002-2003 Rochet Sylvain
 *
 *  gtkatlantic is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <glib.h>
#include <png.h>

typedef struct {

	guint16 width;
	guint16 height;
	guint32 rowbytes;
	guint8 channels;

	guint32 bit_depth;
	guint32 color_type;

	guint32 size;
	guint32 size_image;
	guint32 size_alpha;
	gboolean have_alpha;
	gboolean available_alpha;
	guint32 nb_pixel;

	guchar *image;
	gboolean image_allocated;
	gboolean image_need;
	guchar *alpha;
	gboolean alpha_allocated;
	gboolean alpha_need;

	guchar *part_image;
	guchar *part_alpha;

} _png_imagedata;


gboolean readpng_init(FILE *infile, png_structp *png_struct, png_infop *png_info, _png_imagedata *png_imagedata);
gboolean readpng_decode_image(png_structp *png_struct, png_infop *png_info, _png_imagedata *png_imagedata, gboolean get_alpha);
guchar *readpng_get_image(_png_imagedata *png_imagedata);
guchar *readpng_get_alpha(_png_imagedata *png_imagedata);
guchar *readpng_get_image_zone(_png_imagedata *png_imagedata, guint16 x, guint16 y, guint16 width, guint16 height);
guchar *readpng_get_alpha_zone(_png_imagedata *png_imagedata, guint16 x, guint16 y, guint16 width, guint16 height);
void readpng_cleanup(png_structp *png_struct, png_infop *png_info, _png_imagedata *png_imagedata);
