/*
 *     gtkatlantic - the gtk+ monopd client, enjoy network monopoly games
 *
 *
 *  Copyright (C) 2002-2003 Rochet Sylvain
 *
 *  gtkatlantic is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <gtk/gtk.h>
#include <gdk/gdkrgb.h>

#include "config.h"

#include "global.h"
#include "interface.h"
#include "main.h"
#include "load.h"
#include "client.h"
#include "game.h"

#include "engine.h"

#include "parser.h"


int main(int argc, char **argv)  {

	global = g_malloc0( sizeof(_global) );
	data = g_malloc0( sizeof(_data) );
	config = g_malloc0( sizeof(_config) );

	create_home_directory();
	read_config_files();

	gtk_init(&argc, &argv);
	gdk_rgb_init();

	engine_init();
	engine_minimize_memory_usage();

	if(! xmlparse_file_interface() ) exit(-1);
	if(! intro_load_pngs() ) exit(-1);
	init_prototype_gtk_style();

	interface_create_mainwindow();
	interface_create_menubar();  
	interface_create_logo();

	/* ---- add timeout */

	/* I think gtk use gettimeofday() or a methode like this to determine   *
	 * elapsed time, this is quite imprecise. In result if you set timeout  *
	 * to 40 ms you have only 20 hertz and not 25 ...                       */
	gtk_timeout_add(90, client_fonct, NULL);     // 10 hertz
	gtk_timeout_add(40, update_display, NULL);   // 20 hertz


	gtk_main();
	return FALSE;
}



#include <sys/time.h>
int timea, timeb, elp, old, fps;
struct timeval tv;

gboolean test_frequency() {

	gettimeofday(&tv, NULL);
	timeb = tv.tv_usec;
	elp = timeb - timea;
	if(elp < 0) elp = 1000000 - timea + timeb;

//	printf("time elapsed = %d\n", elp);
	timea = tv.tv_usec;

	if(old != tv.tv_sec)  {

		printf("====> fps = %d\n", fps);
		fps = 0;
		old = tv.tv_sec;
	}
	fps++;

	return(TRUE);
}



