/*
 *     gtkatlantic - the gtk+ monopd client, enjoy network monopoly games
 *
 *
 *  Copyright (C) 2002-2003 Rochet Sylvain
 *
 *  gtkatlantic is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* ** contain global variables */

#include <gtk/gtk.h>
#include <time.h>
#include <sys/time.h>


/* -- hierarchy
 *
 *  connection[]             > connections status
 *  game[]                   > game data
 *    |-> estate[]           > estate game data
 *    |-> group[]            > group game data
 *    |-> player[]           > player game data
 *    |-> card[]             > card removed from stack (needed for trade)
 *    |-> trade[]            > current trades data
 *    `-> command[]          > command game data
 *  data                     > interface datas
 *    |-> estate[]           > interface estates data (tablepos, sizes, ...)
 *    |-> playerlist_card[]  > interface playerlist cards data (tablepos, sizes, ...)
 *    `-> theme[]            > themes database
 *  global                   > main data
 *  config                   > config data
 */

/* -- game data */
#define MAX_ESTATES 50
#define MAX_GROUPS 50
#define MAX_PLAYERS 10
#define MAX_CARDS 16
#define MAX_TRADES 64
#define MAX_COMMANDS 20
#define MAX_LENGTH_NICK 16
#define MAX_PLAYERLIST_CARDS 30

/* -- player data */
typedef struct {

	guint32  playerid;
	gint32   game;
	guchar   *image;
	guchar   *name;
	guchar   *host;
	gboolean master;
	gint32   money;
	guint16  location;
	gboolean jailed;
	gboolean directmove;
	gboolean bankrupt;
	gboolean hasturn;
	gboolean can_roll;
	gboolean can_buyestate;

	guint16 location_to;

	/* playerlist */
	GtkWidget *playerlist_AlignementNamePlayer;
	GtkWidget *playerlist_LabelNamePlayer;
	GtkWidget *playerlist_AlignementMoneyPlayer;
	GtkWidget *playerlist_LabelMoneyPlayer;

	GtkWidget *playerlist_cards_gdkrgb;
	gboolean   playerlist_cards_redraw;
	guint16    playerlist_cards_frame;
	guint16    playerlist_cards_pic[MAX_PLAYERLIST_CARDS];

	GtkWidget *playerlist_token_gdkrgb;
	gboolean   playerlist_token_redraw;
	guint16    playerlist_token_frame;
	guint16    playerlist_token_pic;
	guint16    playerlist_token_alpha;

	/* playerlistt2 */
	

	/* board */
	guint32 buffer_token;
	guint32 buffer_star;

	guint16 token_pic;
	guint16 token_alpha;

} _player;


/* -- estate data */
typedef struct {

	guchar   *name;
	guint8   color[3];   // R, G, B
	guint8   bgcolor[3]; // R, G, B
	gint32   owner;
	guint8   houses;
	guint32  houseprice;
	guint32  sellhouseprice;
	gint32   mortgageprice;
	gint32   unmortgageprice;
	gboolean mortgaged;
	gint16   group;
	gboolean can_be_owned;
	gboolean can_toggle_mortgage;
	gboolean can_buy_houses;
	gboolean can_sell_houses;
	guint32  money;
	guint32  price;
	guint32  rent[6];

	/* board */
	GtkWidget *gdkrgb;
	gboolean   redraw;
	guint16    pic;

	guint16 star_alpha;
	guint16 star_pic;

	guint16 house_alpha;
	guint16 house_pic;

} _estate;


/* -- group data */
typedef struct {

	guchar *name;

} _group;


/* -- card data */
typedef struct {

	gint32 cardid;
	gint32 owner;

} _card;


#define TRADE_CURRENT_COMPONENT_MONEY 0
#define TRADE_CURRENT_COMPONENT_ESTATE 1
#define TRADE_CURRENT_COMPONENT_CARD 2

#define TRADE_PLAYER_PARTICIPATE 0
#define TRADE_PLAYER_ACCEPT 1

#define TRADE_SELECT_MONEY 1
#define TRADE_SELECT_ESTATE 2
#define TRADE_SELECT_CARD 3
/* -- trade data */
typedef struct {

	gboolean open;

	gint32 tradeid;
	gboolean player[MAX_PLAYERS][2];
	guint8 current_component;

	GtkWidget *TradeWin;
	GtkWidget *PlayerCList;
	GtkWidget *FrameComponent;
	GtkWidget *ProposalCList;
	GtkWidget *ComponentBox;
	GtkWidget *SubComponentBox;

	guint8  select_type;  // money, estate, card
	guint32 select_from;
	guint32 select_to;
	guint32 select_value;  // estateid, cardid

} _trade;


/* -- command data */
typedef struct {

	gboolean open;

	GtkWidget *Frame;
	GtkWidget *gdkrgb;
	gboolean   redraw;

	guchar *command;

} _command;


#define GAME_STATUS_NONE 0
#define GAME_STATUS_CONFIG 1
#define GAME_STATUS_INIT 2
#define GAME_STATUS_RUN 3
#define GAME_STATUS_END 4
#define GAME_TYPE_CREATE 1
#define GAME_TYPE_JOIN 2
typedef struct {

	guint8 status, type;
	gint32 gameid;

	_estate estate[MAX_ESTATES];
	_group group[MAX_GROUPS];
	_player player[MAX_PLAYERS];
	_card card[MAX_CARDS];
	_trade trade[MAX_TRADES];
	_command command[MAX_COMMANDS];

	guint16 connectid;
	time_t start_time;
	guint16 board_frame;
	guint8 nb_players;

	guint32 my_playerid;
	gboolean i_am_the_master;

	GtkWidget *PlayerCList;

	GtkWidget *BoxMessageAndChat;
	gboolean   chat_float, message_float; // 0 = fixed, 1 = float
	GtkWidget *ChatFrame, *ChatWindow, *ChatBox, *Chat;
	guint32    chat_nb_lines;

	GtkWidget *GameConfigBox;
	GtkWidget *CommandsBox;
	GtkWidget *BoardCenter;
	GtkWidget *WinEstateTree;

	guint32 timeout_token;

} _game;

_game *game;



/* -- connect data */
#define MAX_CONNECTION 128
#define CONNECT_TYPE_MONOPD_GETGAME 1
#define CONNECT_TYPE_MONOPD_GAME 2
#define CONNECT_TYPE_META_GETLIST 3
#define CONNECT_TYPE_META_GETGAME 4
typedef struct {

	// connection setting
	guint8   type;  // type of connection
	gboolean connected;

	gchar   *host;
	gint32  port;
	guint32 socket;
	guchar  *server_version;

	guchar *buffer_in;

} _connect;

gboolean connection_is_open[MAX_CONNECTION];
_connect *connection[MAX_CONNECTION];



/* interface card */
typedef struct  {

	guint16 x;
	guint16 y;
	guint8  z;

	guint8  buffer_card;
	guint8  estateid;

} _interface_playerlist_card;


/* interface estate */
#define TYPE_HOUSE_NONE 0
#define TYPE_HOUSE_HORIZONTAL 1
#define TYPE_HOUSE_VERTICAL 2
typedef struct  {

	guint16 x;
	guint16 y;

	guint8  buffer_board;

	guint16 x1token;
	guint16 y1token;
	guint16 x2token;
	guint16 y2token;

	guint16 x1jail;
	guint16 y1jail;
	guint16 x2jail;
	guint16 y2jail;

	guint16 xstar;
	guint16 ystar;

	guint16 xhouse;
	guint16 yhouse;
	guint8  type_house;

} _interface_estate;


/* themes database */
typedef struct {

	gboolean open;

	guchar *path;
	guchar *path_preview;
	guchar *path_conf;

	guchar *name;
	guchar *type;
	guchar *version;
	guchar *author;
	guchar *email;

} _theme;


/* interface / pngfiles */
#define MAX_COMMANDS 20
#define MAX_HOUSES 10
#define MAX_THEMES 256
typedef struct  {

	/* pngfile logo */
	guchar  *pngfile_logo_filename;
	gboolean pngfile_logo_need_alpha;
	guchar  *pngfile_logo_image, *pngfile_logo_alpha;

	/* pngfile board */
	guchar  *pngfile_board_filename;
	gboolean pngfile_board_need_alpha;
	guint16  pngfile_board_x[MAX_ESTATES],     pngfile_board_y[MAX_ESTATES];
	guint16  pngfile_board_width[MAX_ESTATES], pngfile_board_height[MAX_ESTATES];
	guchar  *pngfile_board_image[MAX_ESTATES];

	/* pngfile_tokens */
	guchar  *pngfile_token_filename;
	gboolean pngfile_token_need_alpha;
	guint16  pngfile_token_x[MAX_PLAYERS],      pngfile_token_y[MAX_PLAYERS];
	guint16  pngfile_token_width[MAX_PLAYERS],  pngfile_token_height[MAX_PLAYERS];
	guchar  *pngfile_token_image[MAX_PLAYERS], *pngfile_token_alpha[MAX_PLAYERS];

	/* pngfile_stars */
	guchar  *pngfile_star_filename;
	gboolean pngfile_star_need_alpha;
	guint16  pngfile_star_x[MAX_PLAYERS],      pngfile_star_y[MAX_PLAYERS];
	guint16  pngfile_star_width[MAX_PLAYERS],  pngfile_star_height[MAX_PLAYERS];
	guchar  *pngfile_star_image[MAX_PLAYERS], *pngfile_star_alpha[MAX_PLAYERS];

	/* pngfile_stars_m (mortgaged) */
	guchar  *pngfile_star_m_filename;
	gboolean pngfile_star_m_need_alpha;
	guint16  pngfile_star_m_x[MAX_PLAYERS],      pngfile_star_m_y[MAX_PLAYERS];
	guint16  pngfile_star_m_width[MAX_PLAYERS],  pngfile_star_m_height[MAX_PLAYERS];
	guchar  *pngfile_star_m_image[MAX_PLAYERS], *pngfile_star_m_alpha[MAX_PLAYERS];

	/* pngfile_cards */
	guchar  *pngfile_card_filename;
	gboolean pngfile_card_need_alpha;
	guint16  pngfile_card_x[MAX_PLAYERLIST_CARDS],     pngfile_card_y[MAX_PLAYERLIST_CARDS];
	guint16  pngfile_card_width[MAX_PLAYERLIST_CARDS], pngfile_card_height[MAX_PLAYERLIST_CARDS];
	guchar  *pngfile_card_image[MAX_PLAYERLIST_CARDS];

	/* pngfile_commands */
	guchar  *pngfile_command_filename;
	gboolean pngfile_command_need_alpha;
	guint16  pngfile_command_x[MAX_COMMANDS],      pngfile_command_y[MAX_COMMANDS];
	guint16  pngfile_command_width[MAX_COMMANDS],  pngfile_command_height[MAX_COMMANDS];
	guchar  *pngfile_command_image[MAX_COMMANDS], *pngfile_command_alpha[MAX_COMMANDS];

	/* pngfile_horiz_houses */
	guchar  *pngfile_horiz_house_filename;
	gboolean pngfile_horiz_house_need_alpha;
	guint16  pngfile_horiz_house_x[MAX_HOUSES],      pngfile_horiz_house_y[MAX_HOUSES];
	guint16  pngfile_horiz_house_width[MAX_HOUSES],  pngfile_horiz_house_height[MAX_HOUSES];
	guchar  *pngfile_horiz_house_image[MAX_HOUSES], *pngfile_horiz_house_alpha[MAX_HOUSES];

	/* pngfile_vert_houses */
	guchar  *pngfile_vert_house_filename;
	gboolean pngfile_vert_house_need_alpha;
	guint16  pngfile_vert_house_x[MAX_HOUSES],      pngfile_vert_house_y[MAX_HOUSES];
	guint16  pngfile_vert_house_width[MAX_HOUSES],  pngfile_vert_house_height[MAX_HOUSES];
	guchar  *pngfile_vert_house_image[MAX_HOUSES], *pngfile_vert_house_alpha[MAX_HOUSES];


	/* load flags */
	gboolean png_intro_loaded;
	gboolean png_game_loaded;


	/* interface logo */
	guint16  logo_width, logo_height;

	/* interface estate */
	guint16 board_height, board_width;
	guint8  number_estates;
	_interface_estate estate[MAX_ESTATES];

	/* interface playerlist token */
	guint16 playerlist_token_width, playerlist_token_height;
	gint32  playerlist_token_bgcolor;

	/* interface playerlist cards */
	guint16 playerlist_cards_width, playerlist_cards_height;
	guint8  playerlist_cards_alphaunowned, playerlist_cards_alphaowned, playerlist_cards_alphamortgage;
	gint32  playerlist_cards_cardbgcolor, playerlist_cards_cardbgcolormortgage, playerlist_cards_bgcolor;
	guint8  number_playerlist_card;
	_interface_playerlist_card playerlist_card[MAX_PLAYERLIST_CARDS];


	/* themes database */
	_theme theme[MAX_THEMES];

} _data;

_data *data;


/* -- main data */
#define GAMECLIST_MODE_SERVERLIST 1
#define GAMECLIST_MODE_GAMELIST   2
#define PHASE_LOGO       1
#define PHASE_GETGAMES   2
#define PHASE_GAMECREATE 3
#define PHASE_GAMEINIT   4
#define PHASE_GAMEPLAY   5
typedef struct  {

	guchar *path_home;

	guint8 phase;

	GtkWidget *MainWin;
	GtkWidget *MainBox;
	GtkWidget *MainVerticalBox;

	GdkPixmap *icon_pixmap;
	GdkBitmap *icon_mask;

	GtkWidget *GameCList;
	guint8     mode_gameclist;  // serverlist or gamelist ?
	gchar     *selected_host;
	guint32    selected_port;
	gchar     *selected_gametype;
	gint32     selected_gameid;

	GtkWidget *ConfigWin;
	GtkWidget *HelpWin;

	GtkWidget *ThemeWin;
	gboolean   theme_redraw;

	GtkWidget *Trick;  //used for reparent some widgets shouldn't be displayed

	GtkWidget *MessageFrame, *MessageWindow, *MessageBox, *Message;
	guint32    message_nb_lines;

	/* logo */
	GtkWidget *gdkrgb_logo;
	guint16    logo_frame, logo_pic, logo_alpha;
	gboolean   logo_redraw;

	/* gtk styles */
	GtkStyle *style_normal;
	GtkStyle *style_player_normal;
	GtkStyle *style_player_turn;
	GtkStyle *style_estate_title;

} _global;

_global *global;


/* all configuration */
#define GAME_PLAYERLIST_POS_LEFT  0
#define GAME_PLAYERLIST_POS_RIGHT 1
typedef struct  {

	guchar   *nickname;

	guchar   *metaserver_host;
	guint32   metaserver_port;
	gboolean  metaserver_autogetlist;
	gboolean  metaserver_autogetgames;
	gboolean  metaserver_sendclientversion;

	guchar   *getgames_host;
	guint32   getgames_port;
	gboolean  getgames_autogetgames;

	guint32   message_max_lines;
	guint32   chat_max_lines;

	guint8    game_playerlist_position;
	guint32   game_token_animation_speed;
	gboolean  game_token_transparency;

} _config;

_config *config;
