/*
 *     gtkatlantic - the gtk+ monopd client, enjoy network monopoly games
 *
 *
 *  Copyright (C) 2002-2003 Rochet Sylvain
 *
 *  gtkatlantic is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <glib.h>

/* -- prototypes for eng_frame.c -- */

void eng_create_frame_all();
void eng_create_frame     (guint16 frame_id);
void pic_get_zone_update  (guint16 frame_id, guint16 pic_id, gint * x1, gint * y1, gint * x2, gint * y2);
void pic_get_zone_old     (guint16 frame_id, guint16 pic_id, gint * x1, gint * y1, gint * x2, gint * y2);
void pic_get_zone_new     (guint16 frame_id, guint16 pic_id, gint * x1, gint * y1, gint * x2, gint * y2);

void eng_update_bufout    (guint16 frame_id, guint16 x1, guint16 y1, guint16 x2, guint16 y2);
void eng_set_bg_bufout    (guint16 frame_id, guint16 x1, guint16 y1, guint16 x2, guint16 y2);

gboolean eng_zone_is_modified(guint16 frame_id, guint16 x1, guint16 y1, guint16 x2, guint16 y2);
gpointer eng_get_zone     (guint16 frame_id, guint16 x1, guint16 y1, guint16 x2, guint16 y2);
gpointer eng_get_next_zone(guint16 frame_id, guint16 * x, guint16 * y, guint16 * width, guint16 * height);

/* -- end of prototypes -- */
