/******************************************************************************/
/* smooth_gtk1_engine.h - Declarations for GTK1 Engine                        */
/******************************************************************************/
/* Smooth Theme Engine                                                        */
/* Copyright (C) 2002-2004 Andrew Johnson                                     */
/*                                                                            */
/* This library is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU Lesser General Public                 */
/* License as published by the Free Software Foundation; either               */
/* version 2.1 of the License, or (at your option) any later version.         */
/*                                                                            */
/* This library is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          */
/* Lesser General Public License for more details.                            */
/*                                                                            */
/* You should have received a copy of the GNU Lesser General Public           */
/* License along with this library; if not, write to the Free Software        */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  */
/*                                                                            */
/* Author(s): Andrew Johnson <ajgenius@ajgenius.us>                           */
/******************************************************************************/
/* Portions Based on the EnGradient Engine                                    */
/*   Andrew Cattau                                                            */
/******************************************************************************/
#ifndef SMOOTH_GTK_ENGINE_H
#define SMOOTH_GTK_ENGINE_H

#include <gmodule.h>
#include <gtk/gtk.h>
#include <gtk/gtkstyle.h>

#include <math.h>

#include <utils/smooth_parts.h>
#include <interfaces/gdk1/gdk1_drawing_interface.h>

#define SMOOTH_RC_DATA(rc_style)          ((SmoothRcStyle *) ((rc_style)->engine_data))

#define THEME_DATA(style)                 ((SmoothRcStyle *) (((GtkStyle *)style)->engine_data))
#define NEW_THEME_DATA(rc_style)          ((SmoothRcStyle *) (g_new0 (SmoothRcStyle, 1)))
#define SET_THEME_DATA(rc_style, data)    (rc_style->engine_data=data)

typedef struct
{
} SmoothStyle;

typedef struct
{
} SmoothStyleClass;

#endif /* SMOOTH_GTK_ENGINE_H */
