/*  gtk-imonc - imond client for fli4l
 *  Copyright (C) 2001 Stefan Strigler <zeank@x-berg.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>

#define TIMEOUT_MSEC		1000		/* alter this to change refresh rate */
#define RECON_TIMEOUT		1 			/* seconds to wait until next reconnect is tried */
#define RECON_TRIES			5

#define ROW_LENGTH			10
#define IMONDLOG_CLIST_COLS 13

gchar pass[64];

GtkWidget *traffic_info;

struct TrafficInfoData {
	guint *cells;
	gint width;
	gint head;
	guint max;
};

gint timeout_tag;
gint imond_versionnr;
gint pppoe;
gint channels;
gint circuits;
gint admintab_pos;
gint new_call; /* set to 1 if new call arrived */
gboolean show_status, show_status_old, init_show_status;
gboolean is_online;
gboolean was_online;
gboolean imond_log;
gboolean news_init;
gboolean is_admin;
gboolean telmond_popup;
gboolean use_trayicon;
gchar *call_notification;

/* use news panel ? */
gboolean use_news_tab;

/* for connection-list remember its state */
gint con_rows;
gfloat ibytes, obytes;

guint charge, onltime;

/* globals for traffic info */
struct TrafficInfoData *chan_data[6]; /* data structures */
GdkGC *gc[6]; /* colors for graphs and rates */
gboolean chan_online[3];

gint traffic_info_width, traffic_info_height;
GdkColor *color_black, *color_green;
GdkGC *gcb, *gcg;
GdkFont *gf;


/* phonebook */
GHashTable* phonebook;

/* functions */
void 
imonc_init															(gpointer window);

void 
imonc_auth_update												(gpointer window);

gint 
imonc_update														(gpointer window);

void
status_display_update										(gpointer window);

void 
fli4l_reconnect													(int signo);

void
get_timetable														(GtkCList *timetable_clist, 
																				 GtkCList *circuits_clist);

void 
get_calls																(GtkCList *calls_clist);

void
get_connections													(GtkCList *imondlog_clist);

/* void  */
/* get_news																(GtkText *news_text); */

gchar *
get_bytes																(unsigned long int bytes, gchar *buf);

gchar *
get_fbytes															(gfloat bytes, gchar *buf);

gchar *
get_timestr															(gint time, gchar *buf);

gchar *
get_datestr															(gint time, gchar *buf);

void
csv_dump_clist													(GtkCList *clist, FILE *fd);

/* traffic info */
struct TrafficInfoData *
createTrafficInfoData										();

void
traffic_info_insert											(struct TrafficInfoData *tData, guint val);

void 
traffic_info_clear											(struct TrafficInfoData *tData);

void
traffic_info_update											(gpointer window);

void 
traffic_info_set_max										(struct TrafficInfoData *tData, guint max);

void
get_bytes_64														(gchar * reply, gchar *in, gchar *out);

void fill_phonebook(GHashTable* phonebook, const gchar *filename);

void fli4l_disconnect();

gboolean fli4l_connect();

void imonc_clear(GtkWidget *widget);
