/*
 * Copyright (c) 2014 Raphael Manfredi
 *
 *----------------------------------------------------------------------
 * This file is part of gtk-gnutella.
 *
 *  gtk-gnutella is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  gtk-gnutella is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with gtk-gnutella; if not, write to the Free Software
 *  Foundation, Inc.:
 *      59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *----------------------------------------------------------------------
 */

/**
 * @ingroup lib
 * @file
 *
 * Sort routine that does not rely on xmalloc() nor zalloc(), only on VMM.
 *
 * @author Raphael Manfredi
 * @date 2014
 */

#ifndef _xsort_data_h_
#define _xsort_data_h_

/*
 * Public interface.
 */

void xsort_with_data(void *b, size_t n, size_t s, cmp_data_fn_t cmp, void *d);
void xqsort_with_data(void *b, size_t n, size_t s, cmp_data_fn_t cmp, void *d);

#endif /* _xsort_data_h_ */

/* vi: set ts=4 sw=4 cindent: */
