/*
 * Copyright (c) 2004 Danny Milosavljevic <danny_milo@yahoo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; You may only use version 2 of the License,
 * you have no option to use any other version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif

#include <gtk/gtk.h>

#include <libxfce4mcs/mcs-manager.h>

#include <libxfce4util/libxfce4util.h>
#include <libxfcegui4/libxfcegui4.h>

#include <xfce-mcs-manager/manager-plugin.h>

#define GSYNAPTICS_EXE "gsynaptics"
#define GSYNAPTICS_ICON "gsynaptics-mcs-plugin"

/* static prototypes */
static void run_dialog (McsPlugin *);

/*
 */
McsPluginInitResult
mcs_plugin_init (McsPlugin * plugin)
{
  gchar *where;
  GError *error = NULL;

  xfce_textdomain (GETTEXT_PACKAGE, LOCALEDIR, "UTF-8");

  plugin->plugin_name = g_strdup ("gsynaptics");
  /* the button label in the xfce-mcs-manager dialog */
  plugin->caption = g_strdup (Q_ ("Button Label|Synaptics settings"));
  plugin->run_dialog = run_dialog;
  plugin->icon = xfce_themed_icon_load (GSYNAPTICS_ICON, 48);
  if (plugin->icon) {
    g_object_set_data_full (G_OBJECT (plugin->icon), "mcs-plugin-icon-name",
			    g_strdup (GSYNAPTICS_ICON), g_free);
  }

  where = g_find_program_in_path (GSYNAPTICS_EXE);
  if (where) {
    gchar *argv[] = {
      "gsynaptics-init",
      NULL
    };

    g_free (where);

    if (g_spawn_async
	(NULL, argv, NULL,
	 G_SPAWN_SEARCH_PATH | G_SPAWN_STDOUT_TO_DEV_NULL |
	 G_SPAWN_STDERR_TO_DEV_NULL, NULL, NULL, NULL, &error) == FALSE) {
      g_error ("Could not start gsynaptics-init: %s", error->message);
      g_error_free (error);
      return (MCS_PLUGIN_INIT_ERROR);
    }

    return (MCS_PLUGIN_INIT_OK);
  } else {
    g_error ("Could not find gsynaptics executable on your system");
    return (MCS_PLUGIN_INIT_ERROR);
  }
}

/*
 */
static void
run_dialog (McsPlugin * plugin)
{
  gchar *argv[] = {
    GSYNAPTICS_EXE,
    NULL
  };
  GError *error = NULL;

  if (g_spawn_async
      (NULL, argv, NULL,
       G_SPAWN_SEARCH_PATH | G_SPAWN_STDOUT_TO_DEV_NULL |
       G_SPAWN_STDERR_TO_DEV_NULL, NULL, NULL, NULL, &error) == FALSE) {
    g_error ("Could not start gsynaptics: %s", error->message);
    g_error_free (error);
  }
}

/* */
MCS_PLUGIN_CHECK_INIT
