/* Farsight
 * Copyright (C) <2005> Philippe Khalaf <burger@speedy.org> 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gst/gst.h>

#include <gstr263depayload.h>

GST_DEBUG_CATEGORY (r263depayload_debug);
#define GST_CAT_DEFAULT (r263depayload_debug)

/* Filter signals and args */
enum {
    /* FILL ME */
    LAST_SIGNAL
};

enum {
    ARG_0,
};

static GstStaticPadTemplate src_factory =
GST_STATIC_PAD_TEMPLATE (
        "src",
        GST_PAD_SRC,
        GST_PAD_ALWAYS,
        GST_STATIC_CAPS ("video/x-h263 ,"
            "framerate = (double) 30" )
//        GST_STATIC_CAPS("ANY")
        );

static void	gst_r263depayload_class_init (GstR263DepayloadClass *klass);
static void	gst_r263depayload_base_init (GstR263DepayloadClass *klass);
static void	gst_r263depayload_init (GstR263Depayload *filter);
static void gst_r263depayload_finalize (GObject * object);
static void	gst_r263depayload_set_property (GObject *object, guint prop_id,
        const GValue *value,
        GParamSpec *pspec);
static void	gst_r263depayload_get_property (GObject *object, guint prop_id,
        GValue *value,
        GParamSpec *pspec);

static GstBuffer *gst_r263depayload_process (GstBaseRTPDepayload *base, 
        GstBuffer *in);

static GstElementClass *parent_class = NULL;

GType
gst_r263depayload_get_type (void)
{
    static GType plugin_type = 0;

    if (!plugin_type)
    {
        static const GTypeInfo plugin_info =
        {
            sizeof (GstR263DepayloadClass),
            (GBaseInitFunc) gst_r263depayload_base_init,
            NULL,
            (GClassInitFunc) gst_r263depayload_class_init,
            NULL,
            NULL,
            sizeof (GstR263Depayload),
            0,
            (GInstanceInitFunc) gst_r263depayload_init,
        };
        plugin_type = g_type_register_static (GST_TYPE_BASE_RTP_DEPAYLOAD,
                "GstR263Depayload",
                &plugin_info, 0);
    }
    return plugin_type;
}

static void
gst_r263depayload_base_init (GstR263DepayloadClass *klass)
{
    static GstElementDetails plugin_details = {
        "h.263 video RTP Depayloader",
        "Codec/Depayr/Network",
        "Depayloader for H263 RTP streams using GstBaseRTPDepayload",
        "Philippe Khalaf <burger@speedy.org>"
    };
    GstElementClass *element_class = GST_ELEMENT_CLASS (klass);

    gst_element_class_add_pad_template (element_class,
            gst_static_pad_template_get (&src_factory));

    gst_element_class_set_details (element_class, &plugin_details);
}

/* initialize the plugin's class */
static void
gst_r263depayload_class_init (GstR263DepayloadClass *klass)
{
    GObjectClass *gobject_class;
    GstElementClass *gstelement_class;
    GstBaseRTPDepayloadClass *gstbasertpdepayload_class;

    gobject_class = (GObjectClass*) klass;
    gstelement_class = (GstElementClass*) klass;
    gstbasertpdepayload_class = (GstBaseRTPDepayloadClass*) klass;

    parent_class = g_type_class_ref (GST_TYPE_ELEMENT);

    gobject_class->set_property = gst_r263depayload_set_property;
    gobject_class->get_property = gst_r263depayload_get_property;

    gobject_class->finalize = gst_r263depayload_finalize;

    gstbasertpdepayload_class->process = gst_r263depayload_process;

    GST_DEBUG_CATEGORY_INIT (r263depayload_debug, "r263depayload", 0, "R263 RTP Depayloader");
}

/* initialize the new element
 * instantiate pads and add them to element
 * set functions
 * initialize structure
 */
static void
gst_r263depayload_init (GstR263Depayload *filter)
{
//    GstElementClass *klass = GST_ELEMENT_GET_CLASS (filter);
    GstBaseRTPDepayload *base = GST_BASE_RTP_DEPAYLOAD (filter);

    // clock rate for this payload type
    base->clock_rate = 90000;
}

static void gst_r263depayload_finalize (GObject * object)
{
    if (G_OBJECT_CLASS (parent_class)->finalize)
        G_OBJECT_CLASS (parent_class)->finalize (object);
}

static GstBuffer *gst_r263depayload_process (GstBaseRTPDepayload *base, GstBuffer *in)
{
    static GstBuffer *collector = NULL;
    GstBuffer *ret = NULL;
    GstBuffer *sub_buf;

    GstBuffer *buf = in;

    // If it's an H263 payload, put all the peaces together
    // Remove payload/rtp header
    //gst_util_dump_mem (GST_BUFFER_DATA(buf), 32);
    // TODO : make it check the mode, and remove correct size
    // for now we assume mode A (4 bytes)
    // rtp header 12 bytes + mode A 4 bytes = 16 bytes
    sub_buf = gst_buffer_create_sub(GST_BUFFER(buf), 16, GST_BUFFER_SIZE(buf)-16);
    //gst_util_dump_mem (GST_BUFFER_DATA(sub_buf), 32);

    GST_DEBUG ("process : got %d %d bytes, mark %d ts %u seqn %d", 
            GST_BUFFER_SIZE (buf), GST_BUFFER_SIZE(sub_buf), 
            gst_rtp_buffer_get_marker (buf),
            gst_rtp_buffer_get_timestamp (buf),
            gst_rtp_buffer_get_seq (buf));

    // Assemble packets into a frame
    if(collector == NULL)
    {
        GST_DEBUG ("Got first part");
        collector = sub_buf;
    }
    else
    {
        collector = gst_buffer_join(collector, GST_BUFFER(sub_buf));
    }

    if (gst_rtp_buffer_get_marker (buf))
    {
        //gst_util_dump_mem (GST_BUFFER_DATA(collector), 32);
        GST_DEBUG("Got mark, Pushing collector now size %d", GST_BUFFER_SIZE(collector));
        ret = collector;
        collector = NULL;
    }
    return ret;
}

static void
gst_r263depayload_set_property (GObject *object, guint prop_id,
        const GValue *value, GParamSpec *pspec)
{
    switch (prop_id)
    {
        default:
            G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
            break;
    }
}

static void
gst_r263depayload_get_property (GObject *object, guint prop_id,
        GValue *value, GParamSpec *pspec)
{
    switch (prop_id) 
    {
        default:
            G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
            break;
    }
}

gboolean
gst_r263depayload_plugin_init (GstPlugin * plugin)
{
  return gst_element_register (plugin, "r263depayloader",
      GST_RANK_NONE, GST_TYPE_R263DEPAYLOAD);
}
