//*****************************************************************************
//                                 DlgGenCfg.hpp                              *
//                                ---------------                             *
//  Description : This dialogue is used to enter values associated with a     *
//                GNU-Cap generator command line. It is used for Transient    *
//                and Fourier analysis.                                       *
//  Started     : 27/02/2004                                                  *
//  Last Update : 14/09/2007                                                  *
//  Copyright   : (C) 2004 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef DLGSIGGENCFG_HPP
#define DLGSIGGENCFG_HPP

// System Includes

#include <climits>

// wxWidgets Includes

#include <wx/wx.h>
#include <wx/tokenzr.h>

// Application Includes

#include "utility/PnlValue.hpp"

// Local Constant Declarations


//*****************************************************************************

class DlgSigGenCfg : public wxDialog
{
  private:

    // Value panel controls for overall source characteristics
    PnlValue  m_oPnlTotAmp;
    PnlValue  m_oPnlTotOffset;

    // Value panel controls for a sinusoidal source
    PnlValue  m_oPnlSinFreq;
    PnlValue  m_oPnlSinPhase;

    // Value panel controls for a pulse source
    PnlValue  m_oPnlPulInitV;
    PnlValue  m_oPnlPulMinV;
    PnlValue  m_oPnlPulMaxV;
    PnlValue  m_oPnlPulDelay;
    PnlValue  m_oPnlPulRise;
    PnlValue  m_oPnlPulWidth;
    PnlValue  m_oPnlPulFall;
    PnlValue  m_oPnlPulPeriod;

    // Button controls
    wxButton  m_oBtnOk;
    wxButton  m_oBtnClear;
    wxButton  m_oBtnCancel;

    // Generator command string
    wxString  m_osGenCmd;

    // Object initialization functions
    void  Initialize( void );
    void  Create    ( void );
    void  ToolTips  ( void );
    void  DoLayout  ( void );

    PnlValue & roGetPanel( int iPnlID );

    void  SetValues( void );
    void  GetValues( void );

    bool  bValidate( void );

  public:

    DlgSigGenCfg( wxWindow * poWin );
   ~DlgSigGenCfg( );

    bool  bClear( void );
    bool  bEnablePanel( int iPnlID, bool bState ); 

    bool     bSetDefaults( void );
    bool     bSetValue   ( int iPnlID, float fValue,
                           const wxString & rosUnits=wxT("") );
    double  dfGetValue   ( int iPnlID )
                              { return( roGetPanel( iPnlID ).dfGetValue( ) ); }

          bool         bSetGenCmd( const wxString & rosCmd );
    const wxString & rosGetGenCmd( void );

    // Event handlers
    void  OnBtnOk    ( wxCommandEvent & roEvtCmd );
    void  OnBtnClear ( wxCommandEvent & roEvtCmd );
    void  OnBtnCancel( wxCommandEvent & roEvtCmd );

    // In order to be able to react to a menu command, it must be given a
    // unique identifier such as a const or an enum.
    enum eDlgItemID
    {
      ID_PNL_TOT_AMP = 0,
      ID_PNL_TOT_OFFSET,
      ID_PNL_SIN_FREQ,
      ID_PNL_SIN_PHASE,
      ID_PNL_PUL_INITV,
      ID_PNL_PUL_MINV,
      ID_PNL_PUL_MAXV,
      ID_PNL_PUL_DELAY,
      ID_PNL_PUL_RISE,
      ID_PNL_PUL_WIDTH,
      ID_PNL_PUL_FALL,
      ID_PNL_PUL_PERIOD,

      ID_BTN_OK,
      ID_BTN_CLEAR,
      ID_BTN_CANCEL,

      ID_UNUSED,      // Assigned to controls for which events are not used

      ID_PNL_FST = ID_PNL_TOT_AMP,
      ID_PNL_LST = ID_PNL_PUL_PERIOD,

      ID_FST = ID_PNL_TOT_AMP,
      ID_LST = ID_BTN_CANCEL
    };

  private:

    // Temporary storage for original spin control values until Ok pressed
    double  m_dfPnlValue[ ID_PNL_LST+1 ];

  public:

    // Leave this as the last line as private access is envoked by macro
    DECLARE_EVENT_TABLE( )
};

//*****************************************************************************

#endif // DLGSIGGENCFG_HPP
