//*****************************************************************************
//                                Component.hpp                               *
//                               ---------------                              *
//  Description : This class processes a component definition line from a net *
//                list. The line is parsed into it's constituant parts.       *
//  Started     : 14/05/2004                                                  *
//  Last Update : 15/05/2007                                                  *
//  Copyright   : (C) 2004 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef COMPONENT_HPP
#define COMPONENT_HPP

// System Includes

#include <iostream>

// wxWindows Includes

#include <wx/wx.h>
#include <wx/tokenzr.h>

// Application Includes


// Local Constant Declarations


//*****************************************************************************

class Component
{
  public:

    enum  eTypeCpnt
    {
      eCPNT_NONE = 0, // None type selected
      eCPNT_CAP,      // Capacitor
      eCPNT_RES,      // Resistor
      eCPNT_ADM,      // Admittance
      eCPNT_IND,      // Inductor
      eCPNT_DIODE,    // Diode
      eCPNT_BJT,      // Bipolar Junction Transistor
      eCPNT_JFET,     // Junction Field-Effect Transistor
      eCPNT_MOS,      // Metal-Oxide Semiconductor Field-Effect Transistor
      eCPNT_VCVS,     // Voltage Controlled Voltage Source
      eCPNT_CCCS,     // Current Controlled Current Source
      eCPNT_VCCS,     // Voltage Controlled Current Source
      eCPNT_CCVS,     // Current Controlled Voltage Source
      eCPNT_CIND,     // Coupled (Mutual) Inductors
      eCPNT_TLINE,    // Transmission Line
      eCPNT_LOGIC,    // Logic Device
      eCPNT_ICS,      // Independent Current Source
      eCPNT_IVS,      // Independent Voltage Source
      eCPNT_CCSW,     // Current Controlled Switch
      eCPNT_VCSW,     // Voltage Controlled Switch
      eCPNT_SUBCKT    // Sub-Circuit
    };

  private:

    wxString       m_osDefn;
    wxString       m_osName;
    wxArrayString  m_oasNodes;
    wxString       m_osValue;

    eTypeCpnt      m_eType;
//  wxArrayString  m_oasPorts;  ??? 15/05/2004
//  int            m_iPolarity; ??? 15/05/2004
    bool           m_bIsOk;

    bool  bParse( const wxChar * psDefn );

  public:

    Component( const wxChar * psDefn=NULL );
    ~Component( );

    void  Clear( void );
    bool  bIsOk( void ) { return( m_bIsOk ); }

    bool  bSetDefn( const wxChar * psDefn );

    const wxString      &  rosGetDefn ( void ) { return( m_osDefn   ); }
    const wxString      &  rosGetName ( void ) { return( m_osName   ); }
    const wxArrayString & roasGetNodes( void ) { return( m_oasNodes ); }
    const wxString      &  rosGetValue( void ) { return( m_osValue  ); }
    eTypeCpnt                eGetType ( void ) { return( m_eType    ); }

    // This function is intended for development
    void  Print( const wxChar * psPrefix=NULL );
};

//*****************************************************************************

#endif // COMPONENT_HPP
