/* wsdlC.cpp
   Generated by gSOAP 2.8.3 from wsdl.h

Copyright(C) 2000-2011, Robert van Engelen, Genivia Inc. All Rights Reserved.
The generated code is released under one of the following licenses:
1) GPL or 2) Genivia's license for commercial use.
This program is released under the GPL with the additional exemption that
compiling, linking, and/or using OpenSSL is allowed.
*/

#if defined(__BORLANDC__)
#pragma option push -w-8060
#pragma option push -w-8004
#endif

#include "wsdlH.h"

SOAP_SOURCE_STAMP("@(#) wsdlC.cpp ver 2.8.3 2011-06-24 18:39:49 GMT")


#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
{
	if (soap->header)
		soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
{
	if (soap->header)
	{	soap->part = SOAP_IN_HEADER;
		if (soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, NULL))
			return soap->error;
		soap->part = SOAP_END_HEADER;
	}
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", NULL, NULL);
	soap->part = SOAP_END_HEADER;
	return soap->header == NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_header(struct soap *soap)
{
	if (!soap->header)
	{	if ((soap->header = soap_new_SOAP_ENV__Header(soap, -1)))
			soap_default_SOAP_ENV__Header(soap, soap->header);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
{
	if (!soap->fault)
	{	soap->fault = soap_new_SOAP_ENV__Fault(soap, -1);
		if (!soap->fault)
			return;
		soap_default_SOAP_ENV__Fault(soap, soap->fault);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Code)
	{	soap->fault->SOAP_ENV__Code = soap_new_SOAP_ENV__Code(soap, -1);
		soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Reason)
	{	soap->fault->SOAP_ENV__Reason = soap_new_SOAP_ENV__Reason(soap, -1);
		soap_default_SOAP_ENV__Reason(soap, soap->fault->SOAP_ENV__Reason);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
{
	soap_fault(soap);
	if (soap->fault)
		soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
{
	if (soap->fault)
		return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", NULL);
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
{
	return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (!soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
		{	soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode = soap_new_SOAP_ENV__Code(soap, -1);
			soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode);
		}
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
	}
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Reason->SOAP_ENV__Text;
	return (const char**)&soap->fault->faultstring;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 1)
	{	if (!soap->fault->detail)
		{	soap->fault->detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
			soap_default_SOAP_ENV__Detail(soap, soap->fault->detail);
		}
		return (const char**)&soap->fault->detail->__any;
	}
	if (!soap->fault->SOAP_ENV__Detail)
	{	soap->fault->SOAP_ENV__Detail = soap_new_SOAP_ENV__Detail(soap, -1);
		soap_default_SOAP_ENV__Detail(soap, soap->fault->SOAP_ENV__Detail);
	}
	return (const char**)&soap->fault->SOAP_ENV__Detail->__any;
}

#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
{
	int t;
	if (soap->version == 1)
	{	for (;;)
		{	if (!soap_getelement(soap, &t))
				if (soap->error || soap_ignore_element(soap))
					break;
		}
	}
	if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
		soap->error = SOAP_OK;
	return soap->error;
}
#endif

#ifndef WITH_NOIDREF

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, int *type)
{
	if (soap_peek_element(soap))
		return NULL;
	if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
		*type = soap_lookup_type(soap, soap->href);
	switch (*type)
	{
	case SOAP_TYPE_byte:
		return soap_in_byte(soap, NULL, NULL, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_in_int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_sd__mutability:
		return soap_in_sd__mutability(soap, NULL, NULL, "sd:mutability");
	case SOAP_TYPE_soap__useChoice:
		return soap_in_soap__useChoice(soap, NULL, NULL, "soap:useChoice");
	case SOAP_TYPE_soap__styleChoice:
		return soap_in_soap__styleChoice(soap, NULL, NULL, "soap:styleChoice");
	case SOAP_TYPE_xs__processContents:
		return soap_in_xs__processContents(soap, NULL, NULL, "xs:processContents");
	case SOAP_TYPE_xs__attribute_use:
		return soap_in_xs__attribute_use(soap, NULL, NULL, "xs:attribute-use");
	case SOAP_TYPE_xs__formChoice:
		return soap_in_xs__formChoice(soap, NULL, NULL, "xs:formChoice");
	case SOAP_TYPE_xsd__boolean:
		return soap_in_xsd__boolean(soap, NULL, NULL, "xsd:boolean");
	case SOAP_TYPE_bool:
		return soap_in_bool(soap, NULL, NULL, "xsd:boolean");
	case SOAP_TYPE_wsdl__service:
		return soap_in_wsdl__service(soap, NULL, NULL, "wsdl:service");
	case SOAP_TYPE_wsdl__port:
		return soap_in_wsdl__port(soap, NULL, NULL, "wsdl:port");
	case SOAP_TYPE_wsdl__binding:
		return soap_in_wsdl__binding(soap, NULL, NULL, "wsdl:binding");
	case SOAP_TYPE_wsdl__binding_operation:
		return soap_in_wsdl__binding_operation(soap, NULL, NULL, "wsdl:binding-operation");
	case SOAP_TYPE_wsdl__ext_fault:
		return soap_in_wsdl__ext_fault(soap, NULL, NULL, "wsdl:ext-fault");
	case SOAP_TYPE_wsdl__ext_output:
		return soap_in_wsdl__ext_output(soap, NULL, NULL, "wsdl:ext-output");
	case SOAP_TYPE_wsdl__ext_input:
		return soap_in_wsdl__ext_input(soap, NULL, NULL, "wsdl:ext-input");
	case SOAP_TYPE_wsdl__portType:
		return soap_in_wsdl__portType(soap, NULL, NULL, "wsdl:portType");
	case SOAP_TYPE_wsdl__fault:
		return soap_in_wsdl__fault(soap, NULL, NULL, "wsdl:fault");
	case SOAP_TYPE_wsdl__output:
		return soap_in_wsdl__output(soap, NULL, NULL, "wsdl:output");
	case SOAP_TYPE_wsdl__input:
		return soap_in_wsdl__input(soap, NULL, NULL, "wsdl:input");
	case SOAP_TYPE_wsdl__types:
		return soap_in_wsdl__types(soap, NULL, NULL, "wsdl:types");
	case SOAP_TYPE_wsdl__import:
		return soap_in_wsdl__import(soap, NULL, NULL, "wsdl:import");
	case SOAP_TYPE_wsp__PolicyAttachment:
		return soap_in_wsp__PolicyAttachment(soap, NULL, NULL, "wsp:PolicyAttachment");
	case SOAP_TYPE_wsp__AppliesTo:
		return soap_in_wsp__AppliesTo(soap, NULL, NULL, "wsp:AppliesTo");
	case SOAP_TYPE_wsp__Attachment:
		return soap_in_wsp__Attachment(soap, NULL, NULL, "wsp:Attachment");
	case SOAP_TYPE_wsrmp__RMAssertion:
		return soap_in_wsrmp__RMAssertion(soap, NULL, NULL, "wsrmp:RMAssertion");
	case SOAP_TYPE_sp__Token:
		return soap_in_sp__Token(soap, NULL, NULL, "sp:Token");
	case SOAP_TYPE_sp__Elements:
		return soap_in_sp__Elements(soap, NULL, NULL, "sp:Elements");
	case SOAP_TYPE_sp__Parts:
		return soap_in_sp__Parts(soap, NULL, NULL, "sp:Parts");
	case SOAP_TYPE_sp__Header:
		return soap_in_sp__Header(soap, NULL, NULL, "sp:Header");
	case SOAP_TYPE_wst__Claims:
		return soap_in_wst__Claims(soap, NULL, NULL, "wst:Claims");
	case SOAP_TYPE_wsp__Assertion:
		return soap_in_wsp__Assertion(soap, NULL, NULL, "wsp:Assertion");
	case SOAP_TYPE_wsp__PolicyReference:
		return soap_in_wsp__PolicyReference(soap, NULL, NULL, "wsp:PolicyReference");
	case SOAP_TYPE_wsp__Content:
		return soap_in_wsp__Content(soap, NULL, NULL, "wsp:Content");
	case SOAP_TYPE_wsp__Policy:
		return soap_in_wsp__Policy(soap, NULL, NULL, "wsp:Policy");
	case SOAP_TYPE_wsa__EndpointReferenceType:
		return soap_in_wsa__EndpointReferenceType(soap, NULL, NULL, "wsa:EndpointReferenceType");
	case SOAP_TYPE_gwsdl__portType:
		return soap_in_gwsdl__portType(soap, NULL, NULL, "gwsdl:portType");
	case SOAP_TYPE_sd__staticServiceDataValues:
		return soap_in_sd__staticServiceDataValues(soap, NULL, NULL, "sd:staticServiceDataValues");
	case SOAP_TYPE_sd__serviceData:
		return soap_in_sd__serviceData(soap, NULL, NULL, "sd:serviceData");
	case SOAP_TYPE_wsdl__operation:
		return soap_in_wsdl__operation(soap, NULL, NULL, "wsdl:operation");
	case SOAP_TYPE_http__operation:
		return soap_in_http__operation(soap, NULL, NULL, "http:operation");
	case SOAP_TYPE_http__binding:
		return soap_in_http__binding(soap, NULL, NULL, "http:binding");
	case SOAP_TYPE_http__address:
		return soap_in_http__address(soap, NULL, NULL, "http:address");
	case SOAP_TYPE_dime__message:
		return soap_in_dime__message(soap, NULL, NULL, "dime:message");
	case SOAP_TYPE_mime__mimeXml:
		return soap_in_mime__mimeXml(soap, NULL, NULL, "mime:mimeXml");
	case SOAP_TYPE_mime__multipartRelated:
		return soap_in_mime__multipartRelated(soap, NULL, NULL, "mime:multipartRelated");
	case SOAP_TYPE_mime__part:
		return soap_in_mime__part(soap, NULL, NULL, "mime:part");
	case SOAP_TYPE_mime__content:
		return soap_in_mime__content(soap, NULL, NULL, "mime:content");
	case SOAP_TYPE_soap__address:
		return soap_in_soap__address(soap, NULL, NULL, "soap:address");
	case SOAP_TYPE_soap__header:
		return soap_in_soap__header(soap, NULL, NULL, "soap:header");
	case SOAP_TYPE_soap__headerfault:
		return soap_in_soap__headerfault(soap, NULL, NULL, "soap:headerfault");
	case SOAP_TYPE_soap__fault:
		return soap_in_soap__fault(soap, NULL, NULL, "soap:fault");
	case SOAP_TYPE_soap__body:
		return soap_in_soap__body(soap, NULL, NULL, "soap:body");
	case SOAP_TYPE_soap__operation:
		return soap_in_soap__operation(soap, NULL, NULL, "soap:operation");
	case SOAP_TYPE_soap__binding:
		return soap_in_soap__binding(soap, NULL, NULL, "soap:binding");
	case SOAP_TYPE_wsdl__part:
		return soap_in_wsdl__part(soap, NULL, NULL, "wsdl:part");
	case SOAP_TYPE_wsdl__message:
		return soap_in_wsdl__message(soap, NULL, NULL, "wsdl:message");
	case SOAP_TYPE_wsdl__definitions:
		return soap_in_wsdl__definitions(soap, NULL, NULL, "wsdl:definitions");
	case SOAP_TYPE_xs__redefine:
		return soap_in_xs__redefine(soap, NULL, NULL, "xs:redefine");
	case SOAP_TYPE_xs__include:
		return soap_in_xs__include(soap, NULL, NULL, "xs:include");
	case SOAP_TYPE_xs__import:
		return soap_in_xs__import(soap, NULL, NULL, "xs:import");
	case SOAP_TYPE_xs__complexContent:
		return soap_in_xs__complexContent(soap, NULL, NULL, "xs:complexContent");
	case SOAP_TYPE_xs__whiteSpace:
		return soap_in_xs__whiteSpace(soap, NULL, NULL, "xs:whiteSpace");
	case SOAP_TYPE_xs__length:
		return soap_in_xs__length(soap, NULL, NULL, "xs:length");
	case SOAP_TYPE_xs__simpleContent:
		return soap_in_xs__simpleContent(soap, NULL, NULL, "xs:simpleContent");
	case SOAP_TYPE_xs__pattern:
		return soap_in_xs__pattern(soap, NULL, NULL, "xs:pattern");
	case SOAP_TYPE_xs__enumeration:
		return soap_in_xs__enumeration(soap, NULL, NULL, "xs:enumeration");
	case SOAP_TYPE_xs__attributeGroup:
		return soap_in_xs__attributeGroup(soap, NULL, NULL, "xs:attributeGroup");
	case SOAP_TYPE_xs__anyAttribute:
		return soap_in_xs__anyAttribute(soap, NULL, NULL, "xs:anyAttribute");
	case SOAP_TYPE_xs__contents:
		return soap_in_xs__contents(soap, NULL, NULL, "xs:contents");
	case SOAP_TYPE_xs__any:
		return soap_in_xs__any(soap, NULL, NULL, "xs:any");
	case SOAP_TYPE_xs__all:
		return soap_in_xs__all(soap, NULL, NULL, "xs:all");
	case SOAP_TYPE_xs__attribute:
		return soap_in_xs__attribute(soap, NULL, NULL, "xs:attribute");
	case SOAP_TYPE_xs__element:
		return soap_in_xs__element(soap, NULL, NULL, "xs:element");
	case SOAP_TYPE_xs__annotation:
		return soap_in_xs__annotation(soap, NULL, NULL, "xs:annotation");
	case SOAP_TYPE_xs__union:
		return soap_in_xs__union(soap, NULL, NULL, "xs:union");
	case SOAP_TYPE_xs__list:
		return soap_in_xs__list(soap, NULL, NULL, "xs:list");
	case SOAP_TYPE_xs__group:
		return soap_in_xs__group(soap, NULL, NULL, "xs:group");
	case SOAP_TYPE_xs__seqchoice:
		return soap_in_xs__seqchoice(soap, NULL, NULL, "xs:seqchoice");
	case SOAP_TYPE_xs__restriction:
		return soap_in_xs__restriction(soap, NULL, NULL, "xs:restriction");
	case SOAP_TYPE_xs__extension:
		return soap_in_xs__extension(soap, NULL, NULL, "xs:extension");
	case SOAP_TYPE_xs__complexType:
		return soap_in_xs__complexType(soap, NULL, NULL, "xs:complexType");
	case SOAP_TYPE_xs__simpleType:
		return soap_in_xs__simpleType(soap, NULL, NULL, "xs:simpleType");
	case SOAP_TYPE_xs__schema:
		return soap_in_xs__schema(soap, NULL, NULL, "xs:schema");
	case SOAP_TYPE_PointerTowsdl__types:
		return soap_in_PointerTowsdl__types(soap, NULL, NULL, "wsdl:types");
	case SOAP_TYPE_PointerTowsdl__binding:
		return soap_in_PointerTowsdl__binding(soap, NULL, NULL, "wsdl:binding");
	case SOAP_TYPE_PointerTohttp__address:
		return soap_in_PointerTohttp__address(soap, NULL, NULL, "http:address");
	case SOAP_TYPE_PointerTosoap__address:
		return soap_in_PointerTosoap__address(soap, NULL, NULL, "soap:address");
	case SOAP_TYPE_PointerTowsdl__portType:
		return soap_in_PointerTowsdl__portType(soap, NULL, NULL, "wsdl:portType");
	case SOAP_TYPE_PointerTohttp__binding:
		return soap_in_PointerTohttp__binding(soap, NULL, NULL, "http:binding");
	case SOAP_TYPE_PointerTosoap__binding:
		return soap_in_PointerTosoap__binding(soap, NULL, NULL, "soap:binding");
	case SOAP_TYPE_PointerTowsdl__ext_output:
		return soap_in_PointerTowsdl__ext_output(soap, NULL, NULL, "wsdl:ext-output");
	case SOAP_TYPE_PointerTowsdl__ext_input:
		return soap_in_PointerTowsdl__ext_input(soap, NULL, NULL, "wsdl:ext-input");
	case SOAP_TYPE_PointerTohttp__operation:
		return soap_in_PointerTohttp__operation(soap, NULL, NULL, "http:operation");
	case SOAP_TYPE_PointerTosoap__operation:
		return soap_in_PointerTosoap__operation(soap, NULL, NULL, "soap:operation");
	case SOAP_TYPE_PointerTosoap__fault:
		return soap_in_PointerTosoap__fault(soap, NULL, NULL, "soap:fault");
	case SOAP_TYPE_PointerTomime__mimeXml:
		return soap_in_PointerTomime__mimeXml(soap, NULL, NULL, "mime:mimeXml");
	case SOAP_TYPE_PointerTomime__content:
		return soap_in_PointerTomime__content(soap, NULL, NULL, "mime:content");
	case SOAP_TYPE_PointerTomime__multipartRelated:
		return soap_in_PointerTomime__multipartRelated(soap, NULL, NULL, "mime:multipartRelated");
	case SOAP_TYPE_PointerTodime__message:
		return soap_in_PointerTodime__message(soap, NULL, NULL, "dime:message");
	case SOAP_TYPE_PointerTowsdl__output:
		return soap_in_PointerTowsdl__output(soap, NULL, NULL, "wsdl:output");
	case SOAP_TYPE_PointerTowsdl__input:
		return soap_in_PointerTowsdl__input(soap, NULL, NULL, "wsdl:input");
	case SOAP_TYPE_PointerTowsdl__definitions:
		return soap_in_PointerTowsdl__definitions(soap, NULL, NULL, "wsdl:definitions");
	case SOAP_TYPE_PointerTowsp__AppliesTo:
		return soap_in_PointerTowsp__AppliesTo(soap, NULL, NULL, "wsp:AppliesTo");
	case SOAP_TYPE_PointerTowsrmp__RMAssertion:
		return soap_in_PointerTowsrmp__RMAssertion(soap, NULL, NULL, "wsrmp:RMAssertion");
	case SOAP_TYPE_PointerTowsp__Assertion:
		return soap_in_PointerTowsp__Assertion(soap, NULL, NULL, "wsp:Assertion");
	case SOAP_TYPE_PointerTosp__Token:
		return soap_in_PointerTosp__Token(soap, NULL, NULL, "sp:Token");
	case SOAP_TYPE_PointerTosp__Elements:
		return soap_in_PointerTosp__Elements(soap, NULL, NULL, "sp:Elements");
	case SOAP_TYPE_PointerTowsp__PolicyReference:
		return soap_in_PointerTowsp__PolicyReference(soap, NULL, NULL, "wsp:PolicyReference");
	case SOAP_TYPE_PointerTowst__Claims:
		return soap_in_PointerTowst__Claims(soap, NULL, NULL, "wst:Claims");
	case SOAP_TYPE_PointerTowsa__EndpointReferenceType:
		return soap_in_PointerTowsa__EndpointReferenceType(soap, NULL, NULL, "wsa:EndpointReferenceType");
	case SOAP_TYPE_PointerTowsp__Content:
		return soap_in_PointerTowsp__Content(soap, NULL, NULL, "wsp:Content");
	case SOAP_TYPE_PointerTowsp__Policy:
		return soap_in_PointerTowsp__Policy(soap, NULL, NULL, "wsp:Policy");
	case SOAP_TYPE_PointerTosd__staticServiceDataValues:
		return soap_in_PointerTosd__staticServiceDataValues(soap, NULL, NULL, "sd:staticServiceDataValues");
	case SOAP_TYPE_PointerTowsdl__operation:
		return soap_in_PointerTowsdl__operation(soap, NULL, NULL, "wsdl:operation");
	case SOAP_TYPE_PointerTosoap__body:
		return soap_in_PointerTosoap__body(soap, NULL, NULL, "soap:body");
	case SOAP_TYPE_PointerTowsdl__part:
		return soap_in_PointerTowsdl__part(soap, NULL, NULL, "wsdl:part");
	case SOAP_TYPE_PointerTowsdl__message:
		return soap_in_PointerTowsdl__message(soap, NULL, NULL, "wsdl:message");
	case SOAP_TYPE_PointerTosoap__styleChoice:
		return soap_in_PointerTosoap__styleChoice(soap, NULL, NULL, "soap:styleChoice");
	case SOAP_TYPE_PointerToxs__complexContent:
		return soap_in_PointerToxs__complexContent(soap, NULL, NULL, "xs:complexContent");
	case SOAP_TYPE_PointerToxs__simpleContent:
		return soap_in_PointerToxs__simpleContent(soap, NULL, NULL, "xs:simpleContent");
	case SOAP_TYPE_PointerToxs__length:
		return soap_in_PointerToxs__length(soap, NULL, NULL, "xs:length");
	case SOAP_TYPE_PointerToxs__whiteSpace:
		return soap_in_PointerToxs__whiteSpace(soap, NULL, NULL, "xs:whiteSpace");
	case SOAP_TYPE_PointerToxs__union:
		return soap_in_PointerToxs__union(soap, NULL, NULL, "xs:union");
	case SOAP_TYPE_PointerToxs__list:
		return soap_in_PointerToxs__list(soap, NULL, NULL, "xs:list");
	case SOAP_TYPE_PointerToxs__restriction:
		return soap_in_PointerToxs__restriction(soap, NULL, NULL, "xs:restriction");
	case SOAP_TYPE_PointerToxs__extension:
		return soap_in_PointerToxs__extension(soap, NULL, NULL, "xs:extension");
	case SOAP_TYPE_PointerToxs__attributeGroup:
		return soap_in_PointerToxs__attributeGroup(soap, NULL, NULL, "xs:attributeGroup");
	case SOAP_TYPE_PointerToxs__anyAttribute:
		return soap_in_PointerToxs__anyAttribute(soap, NULL, NULL, "xs:anyAttribute");
	case SOAP_TYPE_PointerToxs__all:
		return soap_in_PointerToxs__all(soap, NULL, NULL, "xs:all");
	case SOAP_TYPE_PointerToxs__any:
		return soap_in_PointerToxs__any(soap, NULL, NULL, "xs:any");
	case SOAP_TYPE_PointerToxs__seqchoice:
		return soap_in_PointerToxs__seqchoice(soap, NULL, NULL, "xs:seqchoice");
	case SOAP_TYPE_PointerToxs__group:
		return soap_in_PointerToxs__group(soap, NULL, NULL, "xs:group");
	case SOAP_TYPE_xs__namespaceList:
	{	char **s;
		s = soap_in_xs__namespaceList(soap, NULL, NULL, "xs:namespaceList");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_PointerToxs__attribute:
		return soap_in_PointerToxs__attribute(soap, NULL, NULL, "xs:attribute");
	case SOAP_TYPE_PointerToxs__element:
		return soap_in_PointerToxs__element(soap, NULL, NULL, "xs:element");
	case SOAP_TYPE_PointerToxs__schema:
		return soap_in_PointerToxs__schema(soap, NULL, NULL, "xs:schema");
	case SOAP_TYPE_PointerToxs__complexType:
		return soap_in_PointerToxs__complexType(soap, NULL, NULL, "xs:complexType");
	case SOAP_TYPE_PointerToxs__simpleType:
		return soap_in_PointerToxs__simpleType(soap, NULL, NULL, "xs:simpleType");
	case SOAP_TYPE_PointerToxs__annotation:
		return soap_in_PointerToxs__annotation(soap, NULL, NULL, "xs:annotation");
	case SOAP_TYPE_PointerToxs__formChoice:
		return soap_in_PointerToxs__formChoice(soap, NULL, NULL, "xs:formChoice");
	case SOAP_TYPE_xsd__string:
	{	char **s;
		s = soap_in_xsd__string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_xsd__QName:
	{	char **s;
		s = soap_in_xsd__QName(soap, NULL, NULL, "xsd:QName");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_xsd__NMTOKENS:
	{	char **s;
		s = soap_in_xsd__NMTOKENS(soap, NULL, NULL, "xsd:NMTOKENS");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_xsd__NMTOKEN:
	{	char **s;
		s = soap_in_xsd__NMTOKEN(soap, NULL, NULL, "xsd:NMTOKEN");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_xsd__NCName:
	{	char **s;
		s = soap_in_xsd__NCName(soap, NULL, NULL, "xsd:NCName");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_xsd__ID:
	{	char **s;
		s = soap_in_xsd__ID(soap, NULL, NULL, "xsd:ID");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_xsd__anyURI:
	{	char **s;
		s = soap_in_xsd__anyURI(soap, NULL, NULL, "xsd:anyURI");
		return s ? *s : NULL;
	}
	case SOAP_TYPE__QName:
	{	char **s;
		s = soap_in__QName(soap, NULL, NULL, "xsd:QName");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_string:
	{	char **s;
		s = soap_in_string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	default:
	{	const char *t = soap->type;
		if (!*t)
			t = soap->tag;
		if (!soap_match_tag(soap, t, "wsdl:service"))
		{	*type = SOAP_TYPE_wsdl__service;
			return soap_in_wsdl__service(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsdl:port"))
		{	*type = SOAP_TYPE_wsdl__port;
			return soap_in_wsdl__port(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsdl:binding"))
		{	*type = SOAP_TYPE_wsdl__binding;
			return soap_in_wsdl__binding(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsdl:binding-operation"))
		{	*type = SOAP_TYPE_wsdl__binding_operation;
			return soap_in_wsdl__binding_operation(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsdl:ext-fault"))
		{	*type = SOAP_TYPE_wsdl__ext_fault;
			return soap_in_wsdl__ext_fault(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsdl:ext-output"))
		{	*type = SOAP_TYPE_wsdl__ext_output;
			return soap_in_wsdl__ext_output(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsdl:ext-input"))
		{	*type = SOAP_TYPE_wsdl__ext_input;
			return soap_in_wsdl__ext_input(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsdl:portType"))
		{	*type = SOAP_TYPE_wsdl__portType;
			return soap_in_wsdl__portType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsdl:fault"))
		{	*type = SOAP_TYPE_wsdl__fault;
			return soap_in_wsdl__fault(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsdl:output"))
		{	*type = SOAP_TYPE_wsdl__output;
			return soap_in_wsdl__output(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsdl:input"))
		{	*type = SOAP_TYPE_wsdl__input;
			return soap_in_wsdl__input(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsdl:types"))
		{	*type = SOAP_TYPE_wsdl__types;
			return soap_in_wsdl__types(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsdl:import"))
		{	*type = SOAP_TYPE_wsdl__import;
			return soap_in_wsdl__import(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsp:PolicyAttachment"))
		{	*type = SOAP_TYPE_wsp__PolicyAttachment;
			return soap_in_wsp__PolicyAttachment(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsp:AppliesTo"))
		{	*type = SOAP_TYPE_wsp__AppliesTo;
			return soap_in_wsp__AppliesTo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsp:Attachment"))
		{	*type = SOAP_TYPE_wsp__Attachment;
			return soap_in_wsp__Attachment(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsrmp:RMAssertion"))
		{	*type = SOAP_TYPE_wsrmp__RMAssertion;
			return soap_in_wsrmp__RMAssertion(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sp:Token"))
		{	*type = SOAP_TYPE_sp__Token;
			return soap_in_sp__Token(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sp:Elements"))
		{	*type = SOAP_TYPE_sp__Elements;
			return soap_in_sp__Elements(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sp:Parts"))
		{	*type = SOAP_TYPE_sp__Parts;
			return soap_in_sp__Parts(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sp:Header"))
		{	*type = SOAP_TYPE_sp__Header;
			return soap_in_sp__Header(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wst:Claims"))
		{	*type = SOAP_TYPE_wst__Claims;
			return soap_in_wst__Claims(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsp:Assertion"))
		{	*type = SOAP_TYPE_wsp__Assertion;
			return soap_in_wsp__Assertion(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsp:PolicyReference"))
		{	*type = SOAP_TYPE_wsp__PolicyReference;
			return soap_in_wsp__PolicyReference(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsp:Content"))
		{	*type = SOAP_TYPE_wsp__Content;
			return soap_in_wsp__Content(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsp:Policy"))
		{	*type = SOAP_TYPE_wsp__Policy;
			return soap_in_wsp__Policy(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:EndpointReferenceType"))
		{	*type = SOAP_TYPE_wsa__EndpointReferenceType;
			return soap_in_wsa__EndpointReferenceType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "gwsdl:portType"))
		{	*type = SOAP_TYPE_gwsdl__portType;
			return soap_in_gwsdl__portType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sd:staticServiceDataValues"))
		{	*type = SOAP_TYPE_sd__staticServiceDataValues;
			return soap_in_sd__staticServiceDataValues(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sd:serviceData"))
		{	*type = SOAP_TYPE_sd__serviceData;
			return soap_in_sd__serviceData(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsdl:operation"))
		{	*type = SOAP_TYPE_wsdl__operation;
			return soap_in_wsdl__operation(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "http:operation"))
		{	*type = SOAP_TYPE_http__operation;
			return soap_in_http__operation(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "http:binding"))
		{	*type = SOAP_TYPE_http__binding;
			return soap_in_http__binding(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "http:address"))
		{	*type = SOAP_TYPE_http__address;
			return soap_in_http__address(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "dime:message"))
		{	*type = SOAP_TYPE_dime__message;
			return soap_in_dime__message(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mime:mimeXml"))
		{	*type = SOAP_TYPE_mime__mimeXml;
			return soap_in_mime__mimeXml(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mime:multipartRelated"))
		{	*type = SOAP_TYPE_mime__multipartRelated;
			return soap_in_mime__multipartRelated(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mime:part"))
		{	*type = SOAP_TYPE_mime__part;
			return soap_in_mime__part(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mime:content"))
		{	*type = SOAP_TYPE_mime__content;
			return soap_in_mime__content(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "soap:address"))
		{	*type = SOAP_TYPE_soap__address;
			return soap_in_soap__address(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "soap:header"))
		{	*type = SOAP_TYPE_soap__header;
			return soap_in_soap__header(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "soap:headerfault"))
		{	*type = SOAP_TYPE_soap__headerfault;
			return soap_in_soap__headerfault(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "soap:fault"))
		{	*type = SOAP_TYPE_soap__fault;
			return soap_in_soap__fault(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "soap:body"))
		{	*type = SOAP_TYPE_soap__body;
			return soap_in_soap__body(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "soap:operation"))
		{	*type = SOAP_TYPE_soap__operation;
			return soap_in_soap__operation(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "soap:binding"))
		{	*type = SOAP_TYPE_soap__binding;
			return soap_in_soap__binding(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsdl:part"))
		{	*type = SOAP_TYPE_wsdl__part;
			return soap_in_wsdl__part(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsdl:message"))
		{	*type = SOAP_TYPE_wsdl__message;
			return soap_in_wsdl__message(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsdl:definitions"))
		{	*type = SOAP_TYPE_wsdl__definitions;
			return soap_in_wsdl__definitions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xs:redefine"))
		{	*type = SOAP_TYPE_xs__redefine;
			return soap_in_xs__redefine(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xs:include"))
		{	*type = SOAP_TYPE_xs__include;
			return soap_in_xs__include(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xs:import"))
		{	*type = SOAP_TYPE_xs__import;
			return soap_in_xs__import(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xs:complexContent"))
		{	*type = SOAP_TYPE_xs__complexContent;
			return soap_in_xs__complexContent(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xs:whiteSpace"))
		{	*type = SOAP_TYPE_xs__whiteSpace;
			return soap_in_xs__whiteSpace(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xs:length"))
		{	*type = SOAP_TYPE_xs__length;
			return soap_in_xs__length(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xs:simpleContent"))
		{	*type = SOAP_TYPE_xs__simpleContent;
			return soap_in_xs__simpleContent(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xs:pattern"))
		{	*type = SOAP_TYPE_xs__pattern;
			return soap_in_xs__pattern(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xs:enumeration"))
		{	*type = SOAP_TYPE_xs__enumeration;
			return soap_in_xs__enumeration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xs:attributeGroup"))
		{	*type = SOAP_TYPE_xs__attributeGroup;
			return soap_in_xs__attributeGroup(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xs:anyAttribute"))
		{	*type = SOAP_TYPE_xs__anyAttribute;
			return soap_in_xs__anyAttribute(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xs:contents"))
		{	*type = SOAP_TYPE_xs__contents;
			return soap_in_xs__contents(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xs:any"))
		{	*type = SOAP_TYPE_xs__any;
			return soap_in_xs__any(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xs:all"))
		{	*type = SOAP_TYPE_xs__all;
			return soap_in_xs__all(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xs:attribute"))
		{	*type = SOAP_TYPE_xs__attribute;
			return soap_in_xs__attribute(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xs:element"))
		{	*type = SOAP_TYPE_xs__element;
			return soap_in_xs__element(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xs:annotation"))
		{	*type = SOAP_TYPE_xs__annotation;
			return soap_in_xs__annotation(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xs:union"))
		{	*type = SOAP_TYPE_xs__union;
			return soap_in_xs__union(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xs:list"))
		{	*type = SOAP_TYPE_xs__list;
			return soap_in_xs__list(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xs:group"))
		{	*type = SOAP_TYPE_xs__group;
			return soap_in_xs__group(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xs:seqchoice"))
		{	*type = SOAP_TYPE_xs__seqchoice;
			return soap_in_xs__seqchoice(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xs:restriction"))
		{	*type = SOAP_TYPE_xs__restriction;
			return soap_in_xs__restriction(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xs:extension"))
		{	*type = SOAP_TYPE_xs__extension;
			return soap_in_xs__extension(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xs:complexType"))
		{	*type = SOAP_TYPE_xs__complexType;
			return soap_in_xs__complexType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xs:simpleType"))
		{	*type = SOAP_TYPE_xs__simpleType;
			return soap_in_xs__simpleType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xs:schema"))
		{	*type = SOAP_TYPE_xs__schema;
			return soap_in_xs__schema(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:byte"))
		{	*type = SOAP_TYPE_byte;
			return soap_in_byte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_int;
			return soap_in_int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "sd:mutability"))
		{	*type = SOAP_TYPE_sd__mutability;
			return soap_in_sd__mutability(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "soap:useChoice"))
		{	*type = SOAP_TYPE_soap__useChoice;
			return soap_in_soap__useChoice(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "soap:styleChoice"))
		{	*type = SOAP_TYPE_soap__styleChoice;
			return soap_in_soap__styleChoice(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xs:processContents"))
		{	*type = SOAP_TYPE_xs__processContents;
			return soap_in_xs__processContents(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xs:attribute-use"))
		{	*type = SOAP_TYPE_xs__attribute_use;
			return soap_in_xs__attribute_use(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xs:formChoice"))
		{	*type = SOAP_TYPE_xs__formChoice;
			return soap_in_xs__formChoice(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:boolean"))
		{	*type = SOAP_TYPE_xsd__boolean;
			return soap_in_xsd__boolean(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:boolean"))
		{	*type = SOAP_TYPE_bool;
			return soap_in_bool(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_string;
			s = soap_in_string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xs:namespaceList"))
		{	char **s;
			*type = SOAP_TYPE_xs__namespaceList;
			s = soap_in_xs__namespaceList(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_xsd__string;
			s = soap_in_xsd__string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:QName"))
		{	char **s;
			*type = SOAP_TYPE_xsd__QName;
			s = soap_in_xsd__QName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:NMTOKENS"))
		{	char **s;
			*type = SOAP_TYPE_xsd__NMTOKENS;
			s = soap_in_xsd__NMTOKENS(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:NMTOKEN"))
		{	char **s;
			*type = SOAP_TYPE_xsd__NMTOKEN;
			s = soap_in_xsd__NMTOKEN(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:NCName"))
		{	char **s;
			*type = SOAP_TYPE_xsd__NCName;
			s = soap_in_xsd__NCName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:ID"))
		{	char **s;
			*type = SOAP_TYPE_xsd__ID;
			s = soap_in_xsd__ID(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:anyURI"))
		{	char **s;
			*type = SOAP_TYPE_xsd__anyURI;
			s = soap_in_xsd__anyURI(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:QName"))
		{	char **s;
			*type = SOAP_TYPE__QName;
			s = soap_in__QName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_string;
			s = soap_in_string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		t = soap->tag;
	}
	}
	soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}

#ifdef __cplusplus
}
#endif
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
{
	if (!soap_peek_element(soap))
	{	int t;
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unexpected element '%s' in input (level=%u, %d)\n", soap->tag, soap->level, soap->body));
		if (soap->mustUnderstand && !soap->other)
			return soap->error = SOAP_MUSTUNDERSTAND;
		if (((soap->mode & SOAP_XML_STRICT) && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
		{	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "REJECTING element '%s'\n", soap->tag));
			return soap->error = SOAP_TAG_MISMATCH;
		}
		if (!*soap->id || !soap_getelement(soap, &t))
		{	soap->peeked = 0;
			if (soap->fignore)
				soap->error = soap->fignore(soap, soap->tag);
			else
				soap->error = SOAP_OK;
			DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
			if (!soap->error && soap->body)
			{	soap->level++;
				while (!soap_ignore_element(soap))
					;
				if (soap->error == SOAP_NO_TAG)
					soap->error = soap_element_end_in(soap, NULL);
			}
		}
	}
	return soap->error;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
		for (i = 0; i < SOAP_PTRHASH; i++)
			for (pp = soap->pht[i]; pp; pp = pp->next)
				if (pp->mark1 == 2 || pp->mark2 == 2)
					if (soap_putelement(soap, pp->ptr, "id", pp->id, pp->type))
						return soap->error;
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
{
	switch (type)
	{
	case SOAP_TYPE_byte:
		return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
	case SOAP_TYPE_sd__mutability:
		return soap_out_sd__mutability(soap, tag, id, (const enum sd__mutability *)ptr, "sd:mutability");
	case SOAP_TYPE_soap__useChoice:
		return soap_out_soap__useChoice(soap, tag, id, (const enum soap__useChoice *)ptr, "soap:useChoice");
	case SOAP_TYPE_soap__styleChoice:
		return soap_out_soap__styleChoice(soap, tag, id, (const enum soap__styleChoice *)ptr, "soap:styleChoice");
	case SOAP_TYPE_xs__processContents:
		return soap_out_xs__processContents(soap, tag, id, (const enum xs__processContents *)ptr, "xs:processContents");
	case SOAP_TYPE_xs__attribute_use:
		return soap_out_xs__attribute_use(soap, tag, id, (const enum xs__attribute_use *)ptr, "xs:attribute-use");
	case SOAP_TYPE_xs__formChoice:
		return soap_out_xs__formChoice(soap, tag, id, (const enum xs__formChoice *)ptr, "xs:formChoice");
	case SOAP_TYPE_xsd__boolean:
		return soap_out_xsd__boolean(soap, tag, id, (const bool *)ptr, "xsd:boolean");
	case SOAP_TYPE_bool:
		return soap_out_bool(soap, tag, id, (const bool *)ptr, "xsd:boolean");
	case SOAP_TYPE_wsdl__service:
		return ((wsdl__service *)ptr)->soap_out(soap, tag, id, "wsdl:service");
	case SOAP_TYPE_wsdl__port:
		return ((wsdl__port *)ptr)->soap_out(soap, tag, id, "wsdl:port");
	case SOAP_TYPE_wsdl__binding:
		return ((wsdl__binding *)ptr)->soap_out(soap, tag, id, "wsdl:binding");
	case SOAP_TYPE_wsdl__binding_operation:
		return ((wsdl__binding_operation *)ptr)->soap_out(soap, tag, id, "wsdl:binding-operation");
	case SOAP_TYPE_wsdl__ext_fault:
		return ((wsdl__ext_fault *)ptr)->soap_out(soap, tag, id, "wsdl:ext-fault");
	case SOAP_TYPE_wsdl__ext_output:
		return ((wsdl__ext_output *)ptr)->soap_out(soap, tag, id, "wsdl:ext-output");
	case SOAP_TYPE_wsdl__ext_input:
		return ((wsdl__ext_input *)ptr)->soap_out(soap, tag, id, "wsdl:ext-input");
	case SOAP_TYPE_wsdl__portType:
		return ((wsdl__portType *)ptr)->soap_out(soap, tag, id, "wsdl:portType");
	case SOAP_TYPE_wsdl__fault:
		return ((wsdl__fault *)ptr)->soap_out(soap, tag, id, "wsdl:fault");
	case SOAP_TYPE_wsdl__output:
		return ((wsdl__output *)ptr)->soap_out(soap, tag, id, "wsdl:output");
	case SOAP_TYPE_wsdl__input:
		return ((wsdl__input *)ptr)->soap_out(soap, tag, id, "wsdl:input");
	case SOAP_TYPE_wsdl__types:
		return ((wsdl__types *)ptr)->soap_out(soap, tag, id, "wsdl:types");
	case SOAP_TYPE_wsdl__import:
		return ((wsdl__import *)ptr)->soap_out(soap, tag, id, "wsdl:import");
	case SOAP_TYPE_wsp__PolicyAttachment:
		return ((wsp__PolicyAttachment *)ptr)->soap_out(soap, tag, id, "wsp:PolicyAttachment");
	case SOAP_TYPE_wsp__AppliesTo:
		return ((wsp__AppliesTo *)ptr)->soap_out(soap, tag, id, "wsp:AppliesTo");
	case SOAP_TYPE_wsp__Attachment:
		return ((wsp__Attachment *)ptr)->soap_out(soap, tag, id, "wsp:Attachment");
	case SOAP_TYPE_wsrmp__RMAssertion:
		return ((wsrmp__RMAssertion *)ptr)->soap_out(soap, tag, id, "wsrmp:RMAssertion");
	case SOAP_TYPE_sp__Token:
		return ((sp__Token *)ptr)->soap_out(soap, tag, id, "sp:Token");
	case SOAP_TYPE_sp__Elements:
		return ((sp__Elements *)ptr)->soap_out(soap, tag, id, "sp:Elements");
	case SOAP_TYPE_sp__Parts:
		return ((sp__Parts *)ptr)->soap_out(soap, tag, id, "sp:Parts");
	case SOAP_TYPE_sp__Header:
		return ((sp__Header *)ptr)->soap_out(soap, tag, id, "sp:Header");
	case SOAP_TYPE_wst__Claims:
		return ((wst__Claims *)ptr)->soap_out(soap, tag, id, "wst:Claims");
	case SOAP_TYPE_wsp__Assertion:
		return ((wsp__Assertion *)ptr)->soap_out(soap, tag, id, "wsp:Assertion");
	case SOAP_TYPE_wsp__PolicyReference:
		return ((wsp__PolicyReference *)ptr)->soap_out(soap, tag, id, "wsp:PolicyReference");
	case SOAP_TYPE_wsp__Content:
		return ((wsp__Content *)ptr)->soap_out(soap, tag, id, "wsp:Content");
	case SOAP_TYPE_wsp__Policy:
		return ((wsp__Policy *)ptr)->soap_out(soap, tag, id, "wsp:Policy");
	case SOAP_TYPE_wsa__EndpointReferenceType:
		return ((wsa__EndpointReferenceType *)ptr)->soap_out(soap, tag, id, "wsa:EndpointReferenceType");
	case SOAP_TYPE_gwsdl__portType:
		return ((gwsdl__portType *)ptr)->soap_out(soap, tag, id, "gwsdl:portType");
	case SOAP_TYPE_sd__staticServiceDataValues:
		return ((sd__staticServiceDataValues *)ptr)->soap_out(soap, tag, id, "sd:staticServiceDataValues");
	case SOAP_TYPE_sd__serviceData:
		return ((sd__serviceData *)ptr)->soap_out(soap, tag, id, "sd:serviceData");
	case SOAP_TYPE_wsdl__operation:
		return ((wsdl__operation *)ptr)->soap_out(soap, tag, id, "wsdl:operation");
	case SOAP_TYPE_http__operation:
		return ((http__operation *)ptr)->soap_out(soap, tag, id, "http:operation");
	case SOAP_TYPE_http__binding:
		return ((http__binding *)ptr)->soap_out(soap, tag, id, "http:binding");
	case SOAP_TYPE_http__address:
		return ((http__address *)ptr)->soap_out(soap, tag, id, "http:address");
	case SOAP_TYPE_dime__message:
		return ((dime__message *)ptr)->soap_out(soap, tag, id, "dime:message");
	case SOAP_TYPE_mime__mimeXml:
		return ((mime__mimeXml *)ptr)->soap_out(soap, tag, id, "mime:mimeXml");
	case SOAP_TYPE_mime__multipartRelated:
		return ((mime__multipartRelated *)ptr)->soap_out(soap, tag, id, "mime:multipartRelated");
	case SOAP_TYPE_mime__part:
		return ((mime__part *)ptr)->soap_out(soap, tag, id, "mime:part");
	case SOAP_TYPE_mime__content:
		return ((mime__content *)ptr)->soap_out(soap, tag, id, "mime:content");
	case SOAP_TYPE_soap__address:
		return ((soap__address *)ptr)->soap_out(soap, tag, id, "soap:address");
	case SOAP_TYPE_soap__header:
		return ((soap__header *)ptr)->soap_out(soap, tag, id, "soap:header");
	case SOAP_TYPE_soap__headerfault:
		return ((soap__headerfault *)ptr)->soap_out(soap, tag, id, "soap:headerfault");
	case SOAP_TYPE_soap__fault:
		return ((soap__fault *)ptr)->soap_out(soap, tag, id, "soap:fault");
	case SOAP_TYPE_soap__body:
		return ((soap__body *)ptr)->soap_out(soap, tag, id, "soap:body");
	case SOAP_TYPE_soap__operation:
		return ((soap__operation *)ptr)->soap_out(soap, tag, id, "soap:operation");
	case SOAP_TYPE_soap__binding:
		return ((soap__binding *)ptr)->soap_out(soap, tag, id, "soap:binding");
	case SOAP_TYPE_wsdl__part:
		return ((wsdl__part *)ptr)->soap_out(soap, tag, id, "wsdl:part");
	case SOAP_TYPE_wsdl__message:
		return ((wsdl__message *)ptr)->soap_out(soap, tag, id, "wsdl:message");
	case SOAP_TYPE_wsdl__definitions:
		return ((wsdl__definitions *)ptr)->soap_out(soap, tag, id, "wsdl:definitions");
	case SOAP_TYPE_xs__redefine:
		return ((xs__redefine *)ptr)->soap_out(soap, tag, id, "xs:redefine");
	case SOAP_TYPE_xs__include:
		return ((xs__include *)ptr)->soap_out(soap, tag, id, "xs:include");
	case SOAP_TYPE_xs__import:
		return ((xs__import *)ptr)->soap_out(soap, tag, id, "xs:import");
	case SOAP_TYPE_xs__complexContent:
		return ((xs__complexContent *)ptr)->soap_out(soap, tag, id, "xs:complexContent");
	case SOAP_TYPE_xs__whiteSpace:
		return ((xs__whiteSpace *)ptr)->soap_out(soap, tag, id, "xs:whiteSpace");
	case SOAP_TYPE_xs__length:
		return ((xs__length *)ptr)->soap_out(soap, tag, id, "xs:length");
	case SOAP_TYPE_xs__simpleContent:
		return ((xs__simpleContent *)ptr)->soap_out(soap, tag, id, "xs:simpleContent");
	case SOAP_TYPE_xs__pattern:
		return ((xs__pattern *)ptr)->soap_out(soap, tag, id, "xs:pattern");
	case SOAP_TYPE_xs__enumeration:
		return ((xs__enumeration *)ptr)->soap_out(soap, tag, id, "xs:enumeration");
	case SOAP_TYPE_xs__attributeGroup:
		return ((xs__attributeGroup *)ptr)->soap_out(soap, tag, id, "xs:attributeGroup");
	case SOAP_TYPE_xs__anyAttribute:
		return ((xs__anyAttribute *)ptr)->soap_out(soap, tag, id, "xs:anyAttribute");
	case SOAP_TYPE_xs__contents:
		return ((xs__contents *)ptr)->soap_out(soap, tag, id, "xs:contents");
	case SOAP_TYPE_xs__any:
		return ((xs__any *)ptr)->soap_out(soap, tag, id, "xs:any");
	case SOAP_TYPE_xs__all:
		return ((xs__all *)ptr)->soap_out(soap, tag, id, "xs:all");
	case SOAP_TYPE_xs__attribute:
		return ((xs__attribute *)ptr)->soap_out(soap, tag, id, "xs:attribute");
	case SOAP_TYPE_xs__element:
		return ((xs__element *)ptr)->soap_out(soap, tag, id, "xs:element");
	case SOAP_TYPE_xs__annotation:
		return ((xs__annotation *)ptr)->soap_out(soap, tag, id, "xs:annotation");
	case SOAP_TYPE_xs__union:
		return ((xs__union *)ptr)->soap_out(soap, tag, id, "xs:union");
	case SOAP_TYPE_xs__list:
		return ((xs__list *)ptr)->soap_out(soap, tag, id, "xs:list");
	case SOAP_TYPE_xs__group:
		return ((xs__group *)ptr)->soap_out(soap, tag, id, "xs:group");
	case SOAP_TYPE_xs__seqchoice:
		return ((xs__seqchoice *)ptr)->soap_out(soap, tag, id, "xs:seqchoice");
	case SOAP_TYPE_xs__restriction:
		return ((xs__restriction *)ptr)->soap_out(soap, tag, id, "xs:restriction");
	case SOAP_TYPE_xs__extension:
		return ((xs__extension *)ptr)->soap_out(soap, tag, id, "xs:extension");
	case SOAP_TYPE_xs__complexType:
		return ((xs__complexType *)ptr)->soap_out(soap, tag, id, "xs:complexType");
	case SOAP_TYPE_xs__simpleType:
		return ((xs__simpleType *)ptr)->soap_out(soap, tag, id, "xs:simpleType");
	case SOAP_TYPE_xs__schema:
		return ((xs__schema *)ptr)->soap_out(soap, tag, id, "xs:schema");
	case SOAP_TYPE_PointerTowsdl__types:
		return soap_out_PointerTowsdl__types(soap, tag, id, (wsdl__types *const*)ptr, "wsdl:types");
	case SOAP_TYPE_PointerTowsdl__binding:
		return soap_out_PointerTowsdl__binding(soap, tag, id, (wsdl__binding *const*)ptr, "wsdl:binding");
	case SOAP_TYPE_PointerTohttp__address:
		return soap_out_PointerTohttp__address(soap, tag, id, (http__address *const*)ptr, "http:address");
	case SOAP_TYPE_PointerTosoap__address:
		return soap_out_PointerTosoap__address(soap, tag, id, (soap__address *const*)ptr, "soap:address");
	case SOAP_TYPE_PointerTowsdl__portType:
		return soap_out_PointerTowsdl__portType(soap, tag, id, (wsdl__portType *const*)ptr, "wsdl:portType");
	case SOAP_TYPE_PointerTohttp__binding:
		return soap_out_PointerTohttp__binding(soap, tag, id, (http__binding *const*)ptr, "http:binding");
	case SOAP_TYPE_PointerTosoap__binding:
		return soap_out_PointerTosoap__binding(soap, tag, id, (soap__binding *const*)ptr, "soap:binding");
	case SOAP_TYPE_PointerTowsdl__ext_output:
		return soap_out_PointerTowsdl__ext_output(soap, tag, id, (wsdl__ext_output *const*)ptr, "wsdl:ext-output");
	case SOAP_TYPE_PointerTowsdl__ext_input:
		return soap_out_PointerTowsdl__ext_input(soap, tag, id, (wsdl__ext_input *const*)ptr, "wsdl:ext-input");
	case SOAP_TYPE_PointerTohttp__operation:
		return soap_out_PointerTohttp__operation(soap, tag, id, (http__operation *const*)ptr, "http:operation");
	case SOAP_TYPE_PointerTosoap__operation:
		return soap_out_PointerTosoap__operation(soap, tag, id, (soap__operation *const*)ptr, "soap:operation");
	case SOAP_TYPE_PointerTosoap__fault:
		return soap_out_PointerTosoap__fault(soap, tag, id, (soap__fault *const*)ptr, "soap:fault");
	case SOAP_TYPE_PointerTomime__mimeXml:
		return soap_out_PointerTomime__mimeXml(soap, tag, id, (mime__mimeXml *const*)ptr, "mime:mimeXml");
	case SOAP_TYPE_PointerTomime__content:
		return soap_out_PointerTomime__content(soap, tag, id, (mime__content *const*)ptr, "mime:content");
	case SOAP_TYPE_PointerTomime__multipartRelated:
		return soap_out_PointerTomime__multipartRelated(soap, tag, id, (mime__multipartRelated *const*)ptr, "mime:multipartRelated");
	case SOAP_TYPE_PointerTodime__message:
		return soap_out_PointerTodime__message(soap, tag, id, (dime__message *const*)ptr, "dime:message");
	case SOAP_TYPE_PointerTowsdl__output:
		return soap_out_PointerTowsdl__output(soap, tag, id, (wsdl__output *const*)ptr, "wsdl:output");
	case SOAP_TYPE_PointerTowsdl__input:
		return soap_out_PointerTowsdl__input(soap, tag, id, (wsdl__input *const*)ptr, "wsdl:input");
	case SOAP_TYPE_PointerTowsdl__definitions:
		return soap_out_PointerTowsdl__definitions(soap, tag, id, (wsdl__definitions *const*)ptr, "wsdl:definitions");
	case SOAP_TYPE_PointerTowsp__AppliesTo:
		return soap_out_PointerTowsp__AppliesTo(soap, tag, id, (wsp__AppliesTo *const*)ptr, "wsp:AppliesTo");
	case SOAP_TYPE_PointerTowsrmp__RMAssertion:
		return soap_out_PointerTowsrmp__RMAssertion(soap, tag, id, (wsrmp__RMAssertion *const*)ptr, "wsrmp:RMAssertion");
	case SOAP_TYPE_PointerTowsp__Assertion:
		return soap_out_PointerTowsp__Assertion(soap, tag, id, (wsp__Assertion *const*)ptr, "wsp:Assertion");
	case SOAP_TYPE_PointerTosp__Token:
		return soap_out_PointerTosp__Token(soap, tag, id, (sp__Token *const*)ptr, "sp:Token");
	case SOAP_TYPE_PointerTosp__Elements:
		return soap_out_PointerTosp__Elements(soap, tag, id, (sp__Elements *const*)ptr, "sp:Elements");
	case SOAP_TYPE_PointerTowsp__PolicyReference:
		return soap_out_PointerTowsp__PolicyReference(soap, tag, id, (wsp__PolicyReference *const*)ptr, "wsp:PolicyReference");
	case SOAP_TYPE_PointerTowst__Claims:
		return soap_out_PointerTowst__Claims(soap, tag, id, (wst__Claims *const*)ptr, "wst:Claims");
	case SOAP_TYPE_PointerTowsa__EndpointReferenceType:
		return soap_out_PointerTowsa__EndpointReferenceType(soap, tag, id, (wsa__EndpointReferenceType *const*)ptr, "wsa:EndpointReferenceType");
	case SOAP_TYPE_PointerTowsp__Content:
		return soap_out_PointerTowsp__Content(soap, tag, id, (wsp__Content *const*)ptr, "wsp:Content");
	case SOAP_TYPE_PointerTowsp__Policy:
		return soap_out_PointerTowsp__Policy(soap, tag, id, (wsp__Policy *const*)ptr, "wsp:Policy");
	case SOAP_TYPE_PointerTosd__staticServiceDataValues:
		return soap_out_PointerTosd__staticServiceDataValues(soap, tag, id, (sd__staticServiceDataValues *const*)ptr, "sd:staticServiceDataValues");
	case SOAP_TYPE_PointerTowsdl__operation:
		return soap_out_PointerTowsdl__operation(soap, tag, id, (wsdl__operation *const*)ptr, "wsdl:operation");
	case SOAP_TYPE_PointerTosoap__body:
		return soap_out_PointerTosoap__body(soap, tag, id, (soap__body *const*)ptr, "soap:body");
	case SOAP_TYPE_PointerTowsdl__part:
		return soap_out_PointerTowsdl__part(soap, tag, id, (wsdl__part *const*)ptr, "wsdl:part");
	case SOAP_TYPE_PointerTowsdl__message:
		return soap_out_PointerTowsdl__message(soap, tag, id, (wsdl__message *const*)ptr, "wsdl:message");
	case SOAP_TYPE_PointerTosoap__styleChoice:
		return soap_out_PointerTosoap__styleChoice(soap, tag, id, (enum soap__styleChoice *const*)ptr, "soap:styleChoice");
	case SOAP_TYPE_PointerToxs__complexContent:
		return soap_out_PointerToxs__complexContent(soap, tag, id, (xs__complexContent *const*)ptr, "xs:complexContent");
	case SOAP_TYPE_PointerToxs__simpleContent:
		return soap_out_PointerToxs__simpleContent(soap, tag, id, (xs__simpleContent *const*)ptr, "xs:simpleContent");
	case SOAP_TYPE_PointerToxs__length:
		return soap_out_PointerToxs__length(soap, tag, id, (xs__length *const*)ptr, "xs:length");
	case SOAP_TYPE_PointerToxs__whiteSpace:
		return soap_out_PointerToxs__whiteSpace(soap, tag, id, (xs__whiteSpace *const*)ptr, "xs:whiteSpace");
	case SOAP_TYPE_PointerToxs__union:
		return soap_out_PointerToxs__union(soap, tag, id, (xs__union *const*)ptr, "xs:union");
	case SOAP_TYPE_PointerToxs__list:
		return soap_out_PointerToxs__list(soap, tag, id, (xs__list *const*)ptr, "xs:list");
	case SOAP_TYPE_PointerToxs__restriction:
		return soap_out_PointerToxs__restriction(soap, tag, id, (xs__restriction *const*)ptr, "xs:restriction");
	case SOAP_TYPE_PointerToxs__extension:
		return soap_out_PointerToxs__extension(soap, tag, id, (xs__extension *const*)ptr, "xs:extension");
	case SOAP_TYPE_PointerToxs__attributeGroup:
		return soap_out_PointerToxs__attributeGroup(soap, tag, id, (xs__attributeGroup *const*)ptr, "xs:attributeGroup");
	case SOAP_TYPE_PointerToxs__anyAttribute:
		return soap_out_PointerToxs__anyAttribute(soap, tag, id, (xs__anyAttribute *const*)ptr, "xs:anyAttribute");
	case SOAP_TYPE_PointerToxs__all:
		return soap_out_PointerToxs__all(soap, tag, id, (xs__all *const*)ptr, "xs:all");
	case SOAP_TYPE_PointerToxs__any:
		return soap_out_PointerToxs__any(soap, tag, id, (xs__any *const*)ptr, "xs:any");
	case SOAP_TYPE_PointerToxs__seqchoice:
		return soap_out_PointerToxs__seqchoice(soap, tag, id, (xs__seqchoice *const*)ptr, "xs:seqchoice");
	case SOAP_TYPE_PointerToxs__group:
		return soap_out_PointerToxs__group(soap, tag, id, (xs__group *const*)ptr, "xs:group");
	case SOAP_TYPE_xs__namespaceList:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xs:namespaceList");
	case SOAP_TYPE_PointerToxs__attribute:
		return soap_out_PointerToxs__attribute(soap, tag, id, (xs__attribute *const*)ptr, "xs:attribute");
	case SOAP_TYPE_PointerToxs__element:
		return soap_out_PointerToxs__element(soap, tag, id, (xs__element *const*)ptr, "xs:element");
	case SOAP_TYPE_PointerToxs__schema:
		return soap_out_PointerToxs__schema(soap, tag, id, (xs__schema *const*)ptr, "xs:schema");
	case SOAP_TYPE_PointerToxs__complexType:
		return soap_out_PointerToxs__complexType(soap, tag, id, (xs__complexType *const*)ptr, "xs:complexType");
	case SOAP_TYPE_PointerToxs__simpleType:
		return soap_out_PointerToxs__simpleType(soap, tag, id, (xs__simpleType *const*)ptr, "xs:simpleType");
	case SOAP_TYPE_PointerToxs__annotation:
		return soap_out_PointerToxs__annotation(soap, tag, id, (xs__annotation *const*)ptr, "xs:annotation");
	case SOAP_TYPE_PointerToxs__formChoice:
		return soap_out_PointerToxs__formChoice(soap, tag, id, (enum xs__formChoice *const*)ptr, "xs:formChoice");
	case SOAP_TYPE_xsd__string:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:string");
	case SOAP_TYPE_xsd__QName:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:QName");
	case SOAP_TYPE_xsd__NMTOKENS:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:NMTOKENS");
	case SOAP_TYPE_xsd__NMTOKEN:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:NMTOKEN");
	case SOAP_TYPE_xsd__NCName:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:NCName");
	case SOAP_TYPE_xsd__ID:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:ID");
	case SOAP_TYPE_xsd__anyURI:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:anyURI");
	case SOAP_TYPE__QName:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:QName");
	case SOAP_TYPE_string:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:string");
	}
	return SOAP_OK;
}

#ifdef __cplusplus
}
#endif
#endif

#ifndef WITH_NOIDREF

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
{
	(void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
	switch (type)
	{
	case SOAP_TYPE_wsdl__service:
		((wsdl__service *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_wsdl__port:
		((wsdl__port *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_wsdl__binding:
		((wsdl__binding *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_wsdl__binding_operation:
		((wsdl__binding_operation *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_wsdl__ext_fault:
		((wsdl__ext_fault *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_wsdl__ext_output:
		((wsdl__ext_output *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_wsdl__ext_input:
		((wsdl__ext_input *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_wsdl__portType:
		((wsdl__portType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_wsdl__fault:
		((wsdl__fault *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_wsdl__output:
		((wsdl__output *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_wsdl__input:
		((wsdl__input *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_wsdl__types:
		((wsdl__types *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_wsdl__import:
		((wsdl__import *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_wsp__PolicyAttachment:
		((wsp__PolicyAttachment *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_wsp__AppliesTo:
		((wsp__AppliesTo *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_wsp__Attachment:
		((wsp__Attachment *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_wsrmp__RMAssertion:
		((wsrmp__RMAssertion *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_sp__Token:
		((sp__Token *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_sp__Elements:
		((sp__Elements *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_sp__Parts:
		((sp__Parts *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_sp__Header:
		((sp__Header *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_wst__Claims:
		((wst__Claims *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_wsp__Assertion:
		((wsp__Assertion *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_wsp__PolicyReference:
		((wsp__PolicyReference *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_wsp__Content:
		((wsp__Content *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_wsp__Policy:
		((wsp__Policy *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_wsa__EndpointReferenceType:
		((wsa__EndpointReferenceType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_gwsdl__portType:
		((gwsdl__portType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_sd__staticServiceDataValues:
		((sd__staticServiceDataValues *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_sd__serviceData:
		((sd__serviceData *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_wsdl__operation:
		((wsdl__operation *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_http__operation:
		((http__operation *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_http__binding:
		((http__binding *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_http__address:
		((http__address *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_dime__message:
		((dime__message *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_mime__mimeXml:
		((mime__mimeXml *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_mime__multipartRelated:
		((mime__multipartRelated *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_mime__part:
		((mime__part *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_mime__content:
		((mime__content *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_soap__address:
		((soap__address *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_soap__header:
		((soap__header *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_soap__headerfault:
		((soap__headerfault *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_soap__fault:
		((soap__fault *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_soap__body:
		((soap__body *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_soap__operation:
		((soap__operation *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_soap__binding:
		((soap__binding *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_wsdl__part:
		((wsdl__part *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_wsdl__message:
		((wsdl__message *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_wsdl__definitions:
		((wsdl__definitions *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_xs__redefine:
		((xs__redefine *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_xs__include:
		((xs__include *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_xs__import:
		((xs__import *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_xs__complexContent:
		((xs__complexContent *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_xs__whiteSpace:
		((xs__whiteSpace *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_xs__length:
		((xs__length *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_xs__simpleContent:
		((xs__simpleContent *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_xs__pattern:
		((xs__pattern *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_xs__enumeration:
		((xs__enumeration *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_xs__attributeGroup:
		((xs__attributeGroup *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_xs__anyAttribute:
		((xs__anyAttribute *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_xs__contents:
		((xs__contents *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_xs__any:
		((xs__any *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_xs__all:
		((xs__all *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_xs__attribute:
		((xs__attribute *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_xs__element:
		((xs__element *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_xs__annotation:
		((xs__annotation *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_xs__union:
		((xs__union *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_xs__list:
		((xs__list *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_xs__group:
		((xs__group *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_xs__seqchoice:
		((xs__seqchoice *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_xs__restriction:
		((xs__restriction *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_xs__extension:
		((xs__extension *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_xs__complexType:
		((xs__complexType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_xs__simpleType:
		((xs__simpleType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_xs__schema:
		((xs__schema *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_PointerTowsdl__types:
		soap_serialize_PointerTowsdl__types(soap, (wsdl__types *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsdl__binding:
		soap_serialize_PointerTowsdl__binding(soap, (wsdl__binding *const*)ptr);
		break;
	case SOAP_TYPE_PointerTohttp__address:
		soap_serialize_PointerTohttp__address(soap, (http__address *const*)ptr);
		break;
	case SOAP_TYPE_PointerTosoap__address:
		soap_serialize_PointerTosoap__address(soap, (soap__address *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsdl__portType:
		soap_serialize_PointerTowsdl__portType(soap, (wsdl__portType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTohttp__binding:
		soap_serialize_PointerTohttp__binding(soap, (http__binding *const*)ptr);
		break;
	case SOAP_TYPE_PointerTosoap__binding:
		soap_serialize_PointerTosoap__binding(soap, (soap__binding *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsdl__ext_output:
		soap_serialize_PointerTowsdl__ext_output(soap, (wsdl__ext_output *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsdl__ext_input:
		soap_serialize_PointerTowsdl__ext_input(soap, (wsdl__ext_input *const*)ptr);
		break;
	case SOAP_TYPE_PointerTohttp__operation:
		soap_serialize_PointerTohttp__operation(soap, (http__operation *const*)ptr);
		break;
	case SOAP_TYPE_PointerTosoap__operation:
		soap_serialize_PointerTosoap__operation(soap, (soap__operation *const*)ptr);
		break;
	case SOAP_TYPE_PointerTosoap__fault:
		soap_serialize_PointerTosoap__fault(soap, (soap__fault *const*)ptr);
		break;
	case SOAP_TYPE_PointerTomime__mimeXml:
		soap_serialize_PointerTomime__mimeXml(soap, (mime__mimeXml *const*)ptr);
		break;
	case SOAP_TYPE_PointerTomime__content:
		soap_serialize_PointerTomime__content(soap, (mime__content *const*)ptr);
		break;
	case SOAP_TYPE_PointerTomime__multipartRelated:
		soap_serialize_PointerTomime__multipartRelated(soap, (mime__multipartRelated *const*)ptr);
		break;
	case SOAP_TYPE_PointerTodime__message:
		soap_serialize_PointerTodime__message(soap, (dime__message *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsdl__output:
		soap_serialize_PointerTowsdl__output(soap, (wsdl__output *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsdl__input:
		soap_serialize_PointerTowsdl__input(soap, (wsdl__input *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsdl__definitions:
		soap_serialize_PointerTowsdl__definitions(soap, (wsdl__definitions *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsp__AppliesTo:
		soap_serialize_PointerTowsp__AppliesTo(soap, (wsp__AppliesTo *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsrmp__RMAssertion:
		soap_serialize_PointerTowsrmp__RMAssertion(soap, (wsrmp__RMAssertion *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsp__Assertion:
		soap_serialize_PointerTowsp__Assertion(soap, (wsp__Assertion *const*)ptr);
		break;
	case SOAP_TYPE_PointerTosp__Token:
		soap_serialize_PointerTosp__Token(soap, (sp__Token *const*)ptr);
		break;
	case SOAP_TYPE_PointerTosp__Elements:
		soap_serialize_PointerTosp__Elements(soap, (sp__Elements *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsp__PolicyReference:
		soap_serialize_PointerTowsp__PolicyReference(soap, (wsp__PolicyReference *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowst__Claims:
		soap_serialize_PointerTowst__Claims(soap, (wst__Claims *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsa__EndpointReferenceType:
		soap_serialize_PointerTowsa__EndpointReferenceType(soap, (wsa__EndpointReferenceType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsp__Content:
		soap_serialize_PointerTowsp__Content(soap, (wsp__Content *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsp__Policy:
		soap_serialize_PointerTowsp__Policy(soap, (wsp__Policy *const*)ptr);
		break;
	case SOAP_TYPE_PointerTosd__staticServiceDataValues:
		soap_serialize_PointerTosd__staticServiceDataValues(soap, (sd__staticServiceDataValues *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsdl__operation:
		soap_serialize_PointerTowsdl__operation(soap, (wsdl__operation *const*)ptr);
		break;
	case SOAP_TYPE_PointerTosoap__body:
		soap_serialize_PointerTosoap__body(soap, (soap__body *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsdl__part:
		soap_serialize_PointerTowsdl__part(soap, (wsdl__part *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsdl__message:
		soap_serialize_PointerTowsdl__message(soap, (wsdl__message *const*)ptr);
		break;
	case SOAP_TYPE_PointerTosoap__styleChoice:
		soap_serialize_PointerTosoap__styleChoice(soap, (enum soap__styleChoice *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxs__complexContent:
		soap_serialize_PointerToxs__complexContent(soap, (xs__complexContent *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxs__simpleContent:
		soap_serialize_PointerToxs__simpleContent(soap, (xs__simpleContent *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxs__length:
		soap_serialize_PointerToxs__length(soap, (xs__length *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxs__whiteSpace:
		soap_serialize_PointerToxs__whiteSpace(soap, (xs__whiteSpace *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxs__union:
		soap_serialize_PointerToxs__union(soap, (xs__union *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxs__list:
		soap_serialize_PointerToxs__list(soap, (xs__list *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxs__restriction:
		soap_serialize_PointerToxs__restriction(soap, (xs__restriction *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxs__extension:
		soap_serialize_PointerToxs__extension(soap, (xs__extension *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxs__attributeGroup:
		soap_serialize_PointerToxs__attributeGroup(soap, (xs__attributeGroup *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxs__anyAttribute:
		soap_serialize_PointerToxs__anyAttribute(soap, (xs__anyAttribute *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxs__all:
		soap_serialize_PointerToxs__all(soap, (xs__all *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxs__any:
		soap_serialize_PointerToxs__any(soap, (xs__any *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxs__seqchoice:
		soap_serialize_PointerToxs__seqchoice(soap, (xs__seqchoice *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxs__group:
		soap_serialize_PointerToxs__group(soap, (xs__group *const*)ptr);
		break;
	case SOAP_TYPE_xs__namespaceList:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_PointerToxs__attribute:
		soap_serialize_PointerToxs__attribute(soap, (xs__attribute *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxs__element:
		soap_serialize_PointerToxs__element(soap, (xs__element *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxs__schema:
		soap_serialize_PointerToxs__schema(soap, (xs__schema *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxs__complexType:
		soap_serialize_PointerToxs__complexType(soap, (xs__complexType *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxs__simpleType:
		soap_serialize_PointerToxs__simpleType(soap, (xs__simpleType *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxs__annotation:
		soap_serialize_PointerToxs__annotation(soap, (xs__annotation *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxs__formChoice:
		soap_serialize_PointerToxs__formChoice(soap, (enum xs__formChoice *const*)ptr);
		break;
	case SOAP_TYPE_xsd__string:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_xsd__QName:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_xsd__NMTOKENS:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_xsd__NMTOKEN:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_xsd__NCName:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_xsd__ID:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_xsd__anyURI:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE__QName:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_string:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	}
}

#ifdef __cplusplus
}
#endif
#endif

SOAP_FMAC3 void * SOAP_FMAC4 wsdl_instantiate(struct soap *soap, int t, const char *type, const char *arrayType, size_t *n)
{
	switch (t)
	{
	case SOAP_TYPE_xs__annotation:
		return (void*)soap_instantiate_xs__annotation(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xs__element:
		return (void*)soap_instantiate_xs__element(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xs__attribute:
		return (void*)soap_instantiate_xs__attribute(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xs__all:
		return (void*)soap_instantiate_xs__all(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xs__any:
		return (void*)soap_instantiate_xs__any(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xs__contents:
		return (void*)soap_instantiate_xs__contents(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xs__seqchoice:
		return (void*)soap_instantiate_xs__seqchoice(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xs__group:
		return (void*)soap_instantiate_xs__group(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xs__anyAttribute:
		return (void*)soap_instantiate_xs__anyAttribute(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xs__attributeGroup:
		return (void*)soap_instantiate_xs__attributeGroup(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xs__enumeration:
		return (void*)soap_instantiate_xs__enumeration(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xs__pattern:
		return (void*)soap_instantiate_xs__pattern(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xs__simpleContent:
		return (void*)soap_instantiate_xs__simpleContent(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xs__simpleType:
		return (void*)soap_instantiate_xs__simpleType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xs__extension:
		return (void*)soap_instantiate_xs__extension(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xs__length:
		return (void*)soap_instantiate_xs__length(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xs__whiteSpace:
		return (void*)soap_instantiate_xs__whiteSpace(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xs__restriction:
		return (void*)soap_instantiate_xs__restriction(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xs__list:
		return (void*)soap_instantiate_xs__list(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xs__union:
		return (void*)soap_instantiate_xs__union(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xs__complexContent:
		return (void*)soap_instantiate_xs__complexContent(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xs__complexType:
		return (void*)soap_instantiate_xs__complexType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xs__import:
		return (void*)soap_instantiate_xs__import(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xs__include:
		return (void*)soap_instantiate_xs__include(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xs__redefine:
		return (void*)soap_instantiate_xs__redefine(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xs__schema:
		return (void*)soap_instantiate_xs__schema(soap, -1, type, arrayType, n);
	case SOAP_TYPE_soap__binding:
		return (void*)soap_instantiate_soap__binding(soap, -1, type, arrayType, n);
	case SOAP_TYPE_soap__operation:
		return (void*)soap_instantiate_soap__operation(soap, -1, type, arrayType, n);
	case SOAP_TYPE_soap__body:
		return (void*)soap_instantiate_soap__body(soap, -1, type, arrayType, n);
	case SOAP_TYPE_soap__fault:
		return (void*)soap_instantiate_soap__fault(soap, -1, type, arrayType, n);
	case SOAP_TYPE_soap__headerfault:
		return (void*)soap_instantiate_soap__headerfault(soap, -1, type, arrayType, n);
	case SOAP_TYPE_soap__header:
		return (void*)soap_instantiate_soap__header(soap, -1, type, arrayType, n);
	case SOAP_TYPE_soap__address:
		return (void*)soap_instantiate_soap__address(soap, -1, type, arrayType, n);
	case SOAP_TYPE_mime__content:
		return (void*)soap_instantiate_mime__content(soap, -1, type, arrayType, n);
	case SOAP_TYPE_mime__part:
		return (void*)soap_instantiate_mime__part(soap, -1, type, arrayType, n);
	case SOAP_TYPE_mime__multipartRelated:
		return (void*)soap_instantiate_mime__multipartRelated(soap, -1, type, arrayType, n);
	case SOAP_TYPE_mime__mimeXml:
		return (void*)soap_instantiate_mime__mimeXml(soap, -1, type, arrayType, n);
	case SOAP_TYPE_dime__message:
		return (void*)soap_instantiate_dime__message(soap, -1, type, arrayType, n);
	case SOAP_TYPE_http__address:
		return (void*)soap_instantiate_http__address(soap, -1, type, arrayType, n);
	case SOAP_TYPE_http__binding:
		return (void*)soap_instantiate_http__binding(soap, -1, type, arrayType, n);
	case SOAP_TYPE_http__operation:
		return (void*)soap_instantiate_http__operation(soap, -1, type, arrayType, n);
	case SOAP_TYPE_sd__serviceData:
		return (void*)soap_instantiate_sd__serviceData(soap, -1, type, arrayType, n);
	case SOAP_TYPE_sd__staticServiceDataValues:
		return (void*)soap_instantiate_sd__staticServiceDataValues(soap, -1, type, arrayType, n);
	case SOAP_TYPE_gwsdl__portType:
		return (void*)soap_instantiate_gwsdl__portType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsa__EndpointReferenceType:
		return (void*)soap_instantiate_wsa__EndpointReferenceType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsp__PolicyReference:
		return (void*)soap_instantiate_wsp__PolicyReference(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsp__Assertion:
		return (void*)soap_instantiate_wsp__Assertion(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wst__Claims:
		return (void*)soap_instantiate_wst__Claims(soap, -1, type, arrayType, n);
	case SOAP_TYPE_sp__Header:
		return (void*)soap_instantiate_sp__Header(soap, -1, type, arrayType, n);
	case SOAP_TYPE_sp__Parts:
		return (void*)soap_instantiate_sp__Parts(soap, -1, type, arrayType, n);
	case SOAP_TYPE_sp__Elements:
		return (void*)soap_instantiate_sp__Elements(soap, -1, type, arrayType, n);
	case SOAP_TYPE_sp__Token:
		return (void*)soap_instantiate_sp__Token(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsrmp__RMAssertion:
		return (void*)soap_instantiate_wsrmp__RMAssertion(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsp__Content:
		return (void*)soap_instantiate_wsp__Content(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsp__Policy:
		return (void*)soap_instantiate_wsp__Policy(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsp__Attachment:
		return (void*)soap_instantiate_wsp__Attachment(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsp__AppliesTo:
		return (void*)soap_instantiate_wsp__AppliesTo(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsp__PolicyAttachment:
		return (void*)soap_instantiate_wsp__PolicyAttachment(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsdl__import:
		return (void*)soap_instantiate_wsdl__import(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsdl__types:
		return (void*)soap_instantiate_wsdl__types(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsdl__part:
		return (void*)soap_instantiate_wsdl__part(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsdl__message:
		return (void*)soap_instantiate_wsdl__message(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsdl__input:
		return (void*)soap_instantiate_wsdl__input(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsdl__output:
		return (void*)soap_instantiate_wsdl__output(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsdl__fault:
		return (void*)soap_instantiate_wsdl__fault(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsdl__operation:
		return (void*)soap_instantiate_wsdl__operation(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsdl__portType:
		return (void*)soap_instantiate_wsdl__portType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsdl__ext_input:
		return (void*)soap_instantiate_wsdl__ext_input(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsdl__ext_output:
		return (void*)soap_instantiate_wsdl__ext_output(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsdl__ext_fault:
		return (void*)soap_instantiate_wsdl__ext_fault(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsdl__binding_operation:
		return (void*)soap_instantiate_wsdl__binding_operation(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsdl__binding:
		return (void*)soap_instantiate_wsdl__binding(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsdl__port:
		return (void*)soap_instantiate_wsdl__port(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsdl__service:
		return (void*)soap_instantiate_wsdl__service(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsdl__definitions:
		return (void*)soap_instantiate_wsdl__definitions(soap, -1, type, arrayType, n);
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Header:
		return (void*)soap_instantiate_SOAP_ENV__Header(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Code:
		return (void*)soap_instantiate_SOAP_ENV__Code(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Detail:
		return (void*)soap_instantiate_SOAP_ENV__Detail(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Reason:
		return (void*)soap_instantiate_SOAP_ENV__Reason(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Fault:
		return (void*)soap_instantiate_SOAP_ENV__Fault(soap, -1, type, arrayType, n);
#endif
	case SOAP_TYPE_std__vectorTemplateOfgwsdl__portType:
		return (void*)soap_instantiate_std__vectorTemplateOfgwsdl__portType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfwsdl__service:
		return (void*)soap_instantiate_std__vectorTemplateOfwsdl__service(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfwsdl__binding:
		return (void*)soap_instantiate_std__vectorTemplateOfwsdl__binding(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfwsdl__portType:
		return (void*)soap_instantiate_std__vectorTemplateOfwsdl__portType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfwsdl__message:
		return (void*)soap_instantiate_std__vectorTemplateOfwsdl__message(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfwsdl__import:
		return (void*)soap_instantiate_std__vectorTemplateOfwsdl__import(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfwsdl__port:
		return (void*)soap_instantiate_std__vectorTemplateOfwsdl__port(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfwsdl__binding_operation:
		return (void*)soap_instantiate_std__vectorTemplateOfwsdl__binding_operation(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfwsdl__ext_fault:
		return (void*)soap_instantiate_std__vectorTemplateOfwsdl__ext_fault(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfwsdl__operation:
		return (void*)soap_instantiate_std__vectorTemplateOfwsdl__operation(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfwsdl__fault:
		return (void*)soap_instantiate_std__vectorTemplateOfwsdl__fault(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfwsdl__part:
		return (void*)soap_instantiate_std__vectorTemplateOfwsdl__part(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfwsp__PolicyReference:
		return (void*)soap_instantiate_std__vectorTemplateOfwsp__PolicyReference(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfwsp__Policy:
		return (void*)soap_instantiate_std__vectorTemplateOfwsp__Policy(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerToxs__schema:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerToxs__schema(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfwsp__Attachment:
		return (void*)soap_instantiate_std__vectorTemplateOfwsp__Attachment(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOf_XML:
		return (void*)soap_instantiate_std__vectorTemplateOf_XML(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfsp__Parts:
		return (void*)soap_instantiate_std__vectorTemplateOfsp__Parts(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTowsp__Content:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTowsp__Content(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfxsd__string:
		return (void*)soap_instantiate_std__vectorTemplateOfxsd__string(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfsp__Header:
		return (void*)soap_instantiate_std__vectorTemplateOfsp__Header(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfsd__serviceData:
		return (void*)soap_instantiate_std__vectorTemplateOfsd__serviceData(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTowsdl__operation:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTowsdl__operation(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfmime__part:
		return (void*)soap_instantiate_std__vectorTemplateOfmime__part(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfmime__content:
		return (void*)soap_instantiate_std__vectorTemplateOfmime__content(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfsoap__header:
		return (void*)soap_instantiate_std__vectorTemplateOfsoap__header(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfsoap__headerfault:
		return (void*)soap_instantiate_std__vectorTemplateOfsoap__headerfault(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfxs__import:
		return (void*)soap_instantiate_std__vectorTemplateOfxs__import(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfxs__redefine:
		return (void*)soap_instantiate_std__vectorTemplateOfxs__redefine(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfxs__include:
		return (void*)soap_instantiate_std__vectorTemplateOfxs__include(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfxs__complexType:
		return (void*)soap_instantiate_std__vectorTemplateOfxs__complexType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfxs__group:
		return (void*)soap_instantiate_std__vectorTemplateOfxs__group(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfxs__simpleType:
		return (void*)soap_instantiate_std__vectorTemplateOfxs__simpleType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfxs__pattern:
		return (void*)soap_instantiate_std__vectorTemplateOfxs__pattern(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfxs__enumeration:
		return (void*)soap_instantiate_std__vectorTemplateOfxs__enumeration(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfxs__attributeGroup:
		return (void*)soap_instantiate_std__vectorTemplateOfxs__attributeGroup(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfxs__attribute:
		return (void*)soap_instantiate_std__vectorTemplateOfxs__attribute(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfxs__contents:
		return (void*)soap_instantiate_std__vectorTemplateOfxs__contents(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfxs__element:
		return (void*)soap_instantiate_std__vectorTemplateOfxs__element(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerToxs__element:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerToxs__element(soap, -1, type, arrayType, n);
	}
	return NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 wsdl_fdelete(struct soap_clist *p)
{	switch (p->type)
	{
	case SOAP_TYPE_xs__annotation:
		if (p->size < 0)
			SOAP_DELETE((xs__annotation*)p->ptr);
		else
			SOAP_DELETE_ARRAY((xs__annotation*)p->ptr);
		break;
	case SOAP_TYPE_xs__element:
		if (p->size < 0)
			SOAP_DELETE((xs__element*)p->ptr);
		else
			SOAP_DELETE_ARRAY((xs__element*)p->ptr);
		break;
	case SOAP_TYPE_xs__attribute:
		if (p->size < 0)
			SOAP_DELETE((xs__attribute*)p->ptr);
		else
			SOAP_DELETE_ARRAY((xs__attribute*)p->ptr);
		break;
	case SOAP_TYPE_xs__all:
		if (p->size < 0)
			SOAP_DELETE((xs__all*)p->ptr);
		else
			SOAP_DELETE_ARRAY((xs__all*)p->ptr);
		break;
	case SOAP_TYPE_xs__any:
		if (p->size < 0)
			SOAP_DELETE((xs__any*)p->ptr);
		else
			SOAP_DELETE_ARRAY((xs__any*)p->ptr);
		break;
	case SOAP_TYPE_xs__contents:
		if (p->size < 0)
			SOAP_DELETE((xs__contents*)p->ptr);
		else
			SOAP_DELETE_ARRAY((xs__contents*)p->ptr);
		break;
	case SOAP_TYPE_xs__seqchoice:
		if (p->size < 0)
			SOAP_DELETE((xs__seqchoice*)p->ptr);
		else
			SOAP_DELETE_ARRAY((xs__seqchoice*)p->ptr);
		break;
	case SOAP_TYPE_xs__group:
		if (p->size < 0)
			SOAP_DELETE((xs__group*)p->ptr);
		else
			SOAP_DELETE_ARRAY((xs__group*)p->ptr);
		break;
	case SOAP_TYPE_xs__anyAttribute:
		if (p->size < 0)
			SOAP_DELETE((xs__anyAttribute*)p->ptr);
		else
			SOAP_DELETE_ARRAY((xs__anyAttribute*)p->ptr);
		break;
	case SOAP_TYPE_xs__attributeGroup:
		if (p->size < 0)
			SOAP_DELETE((xs__attributeGroup*)p->ptr);
		else
			SOAP_DELETE_ARRAY((xs__attributeGroup*)p->ptr);
		break;
	case SOAP_TYPE_xs__enumeration:
		if (p->size < 0)
			SOAP_DELETE((xs__enumeration*)p->ptr);
		else
			SOAP_DELETE_ARRAY((xs__enumeration*)p->ptr);
		break;
	case SOAP_TYPE_xs__pattern:
		if (p->size < 0)
			SOAP_DELETE((xs__pattern*)p->ptr);
		else
			SOAP_DELETE_ARRAY((xs__pattern*)p->ptr);
		break;
	case SOAP_TYPE_xs__simpleContent:
		if (p->size < 0)
			SOAP_DELETE((xs__simpleContent*)p->ptr);
		else
			SOAP_DELETE_ARRAY((xs__simpleContent*)p->ptr);
		break;
	case SOAP_TYPE_xs__simpleType:
		if (p->size < 0)
			SOAP_DELETE((xs__simpleType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((xs__simpleType*)p->ptr);
		break;
	case SOAP_TYPE_xs__extension:
		if (p->size < 0)
			SOAP_DELETE((xs__extension*)p->ptr);
		else
			SOAP_DELETE_ARRAY((xs__extension*)p->ptr);
		break;
	case SOAP_TYPE_xs__length:
		if (p->size < 0)
			SOAP_DELETE((xs__length*)p->ptr);
		else
			SOAP_DELETE_ARRAY((xs__length*)p->ptr);
		break;
	case SOAP_TYPE_xs__whiteSpace:
		if (p->size < 0)
			SOAP_DELETE((xs__whiteSpace*)p->ptr);
		else
			SOAP_DELETE_ARRAY((xs__whiteSpace*)p->ptr);
		break;
	case SOAP_TYPE_xs__restriction:
		if (p->size < 0)
			SOAP_DELETE((xs__restriction*)p->ptr);
		else
			SOAP_DELETE_ARRAY((xs__restriction*)p->ptr);
		break;
	case SOAP_TYPE_xs__list:
		if (p->size < 0)
			SOAP_DELETE((xs__list*)p->ptr);
		else
			SOAP_DELETE_ARRAY((xs__list*)p->ptr);
		break;
	case SOAP_TYPE_xs__union:
		if (p->size < 0)
			SOAP_DELETE((xs__union*)p->ptr);
		else
			SOAP_DELETE_ARRAY((xs__union*)p->ptr);
		break;
	case SOAP_TYPE_xs__complexContent:
		if (p->size < 0)
			SOAP_DELETE((xs__complexContent*)p->ptr);
		else
			SOAP_DELETE_ARRAY((xs__complexContent*)p->ptr);
		break;
	case SOAP_TYPE_xs__complexType:
		if (p->size < 0)
			SOAP_DELETE((xs__complexType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((xs__complexType*)p->ptr);
		break;
	case SOAP_TYPE_xs__import:
		if (p->size < 0)
			SOAP_DELETE((xs__import*)p->ptr);
		else
			SOAP_DELETE_ARRAY((xs__import*)p->ptr);
		break;
	case SOAP_TYPE_xs__include:
		if (p->size < 0)
			SOAP_DELETE((xs__include*)p->ptr);
		else
			SOAP_DELETE_ARRAY((xs__include*)p->ptr);
		break;
	case SOAP_TYPE_xs__redefine:
		if (p->size < 0)
			SOAP_DELETE((xs__redefine*)p->ptr);
		else
			SOAP_DELETE_ARRAY((xs__redefine*)p->ptr);
		break;
	case SOAP_TYPE_xs__schema:
		if (p->size < 0)
			SOAP_DELETE((xs__schema*)p->ptr);
		else
			SOAP_DELETE_ARRAY((xs__schema*)p->ptr);
		break;
	case SOAP_TYPE_soap__binding:
		if (p->size < 0)
			SOAP_DELETE((soap__binding*)p->ptr);
		else
			SOAP_DELETE_ARRAY((soap__binding*)p->ptr);
		break;
	case SOAP_TYPE_soap__operation:
		if (p->size < 0)
			SOAP_DELETE((soap__operation*)p->ptr);
		else
			SOAP_DELETE_ARRAY((soap__operation*)p->ptr);
		break;
	case SOAP_TYPE_soap__body:
		if (p->size < 0)
			SOAP_DELETE((soap__body*)p->ptr);
		else
			SOAP_DELETE_ARRAY((soap__body*)p->ptr);
		break;
	case SOAP_TYPE_soap__fault:
		if (p->size < 0)
			SOAP_DELETE((soap__fault*)p->ptr);
		else
			SOAP_DELETE_ARRAY((soap__fault*)p->ptr);
		break;
	case SOAP_TYPE_soap__headerfault:
		if (p->size < 0)
			SOAP_DELETE((soap__headerfault*)p->ptr);
		else
			SOAP_DELETE_ARRAY((soap__headerfault*)p->ptr);
		break;
	case SOAP_TYPE_soap__header:
		if (p->size < 0)
			SOAP_DELETE((soap__header*)p->ptr);
		else
			SOAP_DELETE_ARRAY((soap__header*)p->ptr);
		break;
	case SOAP_TYPE_soap__address:
		if (p->size < 0)
			SOAP_DELETE((soap__address*)p->ptr);
		else
			SOAP_DELETE_ARRAY((soap__address*)p->ptr);
		break;
	case SOAP_TYPE_mime__content:
		if (p->size < 0)
			SOAP_DELETE((mime__content*)p->ptr);
		else
			SOAP_DELETE_ARRAY((mime__content*)p->ptr);
		break;
	case SOAP_TYPE_mime__part:
		if (p->size < 0)
			SOAP_DELETE((mime__part*)p->ptr);
		else
			SOAP_DELETE_ARRAY((mime__part*)p->ptr);
		break;
	case SOAP_TYPE_mime__multipartRelated:
		if (p->size < 0)
			SOAP_DELETE((mime__multipartRelated*)p->ptr);
		else
			SOAP_DELETE_ARRAY((mime__multipartRelated*)p->ptr);
		break;
	case SOAP_TYPE_mime__mimeXml:
		if (p->size < 0)
			SOAP_DELETE((mime__mimeXml*)p->ptr);
		else
			SOAP_DELETE_ARRAY((mime__mimeXml*)p->ptr);
		break;
	case SOAP_TYPE_dime__message:
		if (p->size < 0)
			SOAP_DELETE((dime__message*)p->ptr);
		else
			SOAP_DELETE_ARRAY((dime__message*)p->ptr);
		break;
	case SOAP_TYPE_http__address:
		if (p->size < 0)
			SOAP_DELETE((http__address*)p->ptr);
		else
			SOAP_DELETE_ARRAY((http__address*)p->ptr);
		break;
	case SOAP_TYPE_http__binding:
		if (p->size < 0)
			SOAP_DELETE((http__binding*)p->ptr);
		else
			SOAP_DELETE_ARRAY((http__binding*)p->ptr);
		break;
	case SOAP_TYPE_http__operation:
		if (p->size < 0)
			SOAP_DELETE((http__operation*)p->ptr);
		else
			SOAP_DELETE_ARRAY((http__operation*)p->ptr);
		break;
	case SOAP_TYPE_sd__serviceData:
		if (p->size < 0)
			SOAP_DELETE((sd__serviceData*)p->ptr);
		else
			SOAP_DELETE_ARRAY((sd__serviceData*)p->ptr);
		break;
	case SOAP_TYPE_sd__staticServiceDataValues:
		if (p->size < 0)
			SOAP_DELETE((sd__staticServiceDataValues*)p->ptr);
		else
			SOAP_DELETE_ARRAY((sd__staticServiceDataValues*)p->ptr);
		break;
	case SOAP_TYPE_gwsdl__portType:
		if (p->size < 0)
			SOAP_DELETE((gwsdl__portType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((gwsdl__portType*)p->ptr);
		break;
	case SOAP_TYPE_wsa__EndpointReferenceType:
		if (p->size < 0)
			SOAP_DELETE((wsa__EndpointReferenceType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((wsa__EndpointReferenceType*)p->ptr);
		break;
	case SOAP_TYPE_wsp__PolicyReference:
		if (p->size < 0)
			SOAP_DELETE((wsp__PolicyReference*)p->ptr);
		else
			SOAP_DELETE_ARRAY((wsp__PolicyReference*)p->ptr);
		break;
	case SOAP_TYPE_wsp__Assertion:
		if (p->size < 0)
			SOAP_DELETE((wsp__Assertion*)p->ptr);
		else
			SOAP_DELETE_ARRAY((wsp__Assertion*)p->ptr);
		break;
	case SOAP_TYPE_wst__Claims:
		if (p->size < 0)
			SOAP_DELETE((wst__Claims*)p->ptr);
		else
			SOAP_DELETE_ARRAY((wst__Claims*)p->ptr);
		break;
	case SOAP_TYPE_sp__Header:
		if (p->size < 0)
			SOAP_DELETE((sp__Header*)p->ptr);
		else
			SOAP_DELETE_ARRAY((sp__Header*)p->ptr);
		break;
	case SOAP_TYPE_sp__Parts:
		if (p->size < 0)
			SOAP_DELETE((sp__Parts*)p->ptr);
		else
			SOAP_DELETE_ARRAY((sp__Parts*)p->ptr);
		break;
	case SOAP_TYPE_sp__Elements:
		if (p->size < 0)
			SOAP_DELETE((sp__Elements*)p->ptr);
		else
			SOAP_DELETE_ARRAY((sp__Elements*)p->ptr);
		break;
	case SOAP_TYPE_sp__Token:
		if (p->size < 0)
			SOAP_DELETE((sp__Token*)p->ptr);
		else
			SOAP_DELETE_ARRAY((sp__Token*)p->ptr);
		break;
	case SOAP_TYPE_wsrmp__RMAssertion:
		if (p->size < 0)
			SOAP_DELETE((wsrmp__RMAssertion*)p->ptr);
		else
			SOAP_DELETE_ARRAY((wsrmp__RMAssertion*)p->ptr);
		break;
	case SOAP_TYPE_wsp__Content:
		if (p->size < 0)
			SOAP_DELETE((wsp__Content*)p->ptr);
		else
			SOAP_DELETE_ARRAY((wsp__Content*)p->ptr);
		break;
	case SOAP_TYPE_wsp__Policy:
		if (p->size < 0)
			SOAP_DELETE((wsp__Policy*)p->ptr);
		else
			SOAP_DELETE_ARRAY((wsp__Policy*)p->ptr);
		break;
	case SOAP_TYPE_wsp__Attachment:
		if (p->size < 0)
			SOAP_DELETE((wsp__Attachment*)p->ptr);
		else
			SOAP_DELETE_ARRAY((wsp__Attachment*)p->ptr);
		break;
	case SOAP_TYPE_wsp__AppliesTo:
		if (p->size < 0)
			SOAP_DELETE((wsp__AppliesTo*)p->ptr);
		else
			SOAP_DELETE_ARRAY((wsp__AppliesTo*)p->ptr);
		break;
	case SOAP_TYPE_wsp__PolicyAttachment:
		if (p->size < 0)
			SOAP_DELETE((wsp__PolicyAttachment*)p->ptr);
		else
			SOAP_DELETE_ARRAY((wsp__PolicyAttachment*)p->ptr);
		break;
	case SOAP_TYPE_wsdl__import:
		if (p->size < 0)
			SOAP_DELETE((wsdl__import*)p->ptr);
		else
			SOAP_DELETE_ARRAY((wsdl__import*)p->ptr);
		break;
	case SOAP_TYPE_wsdl__types:
		if (p->size < 0)
			SOAP_DELETE((wsdl__types*)p->ptr);
		else
			SOAP_DELETE_ARRAY((wsdl__types*)p->ptr);
		break;
	case SOAP_TYPE_wsdl__part:
		if (p->size < 0)
			SOAP_DELETE((wsdl__part*)p->ptr);
		else
			SOAP_DELETE_ARRAY((wsdl__part*)p->ptr);
		break;
	case SOAP_TYPE_wsdl__message:
		if (p->size < 0)
			SOAP_DELETE((wsdl__message*)p->ptr);
		else
			SOAP_DELETE_ARRAY((wsdl__message*)p->ptr);
		break;
	case SOAP_TYPE_wsdl__input:
		if (p->size < 0)
			SOAP_DELETE((wsdl__input*)p->ptr);
		else
			SOAP_DELETE_ARRAY((wsdl__input*)p->ptr);
		break;
	case SOAP_TYPE_wsdl__output:
		if (p->size < 0)
			SOAP_DELETE((wsdl__output*)p->ptr);
		else
			SOAP_DELETE_ARRAY((wsdl__output*)p->ptr);
		break;
	case SOAP_TYPE_wsdl__fault:
		if (p->size < 0)
			SOAP_DELETE((wsdl__fault*)p->ptr);
		else
			SOAP_DELETE_ARRAY((wsdl__fault*)p->ptr);
		break;
	case SOAP_TYPE_wsdl__operation:
		if (p->size < 0)
			SOAP_DELETE((wsdl__operation*)p->ptr);
		else
			SOAP_DELETE_ARRAY((wsdl__operation*)p->ptr);
		break;
	case SOAP_TYPE_wsdl__portType:
		if (p->size < 0)
			SOAP_DELETE((wsdl__portType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((wsdl__portType*)p->ptr);
		break;
	case SOAP_TYPE_wsdl__ext_input:
		if (p->size < 0)
			SOAP_DELETE((wsdl__ext_input*)p->ptr);
		else
			SOAP_DELETE_ARRAY((wsdl__ext_input*)p->ptr);
		break;
	case SOAP_TYPE_wsdl__ext_output:
		if (p->size < 0)
			SOAP_DELETE((wsdl__ext_output*)p->ptr);
		else
			SOAP_DELETE_ARRAY((wsdl__ext_output*)p->ptr);
		break;
	case SOAP_TYPE_wsdl__ext_fault:
		if (p->size < 0)
			SOAP_DELETE((wsdl__ext_fault*)p->ptr);
		else
			SOAP_DELETE_ARRAY((wsdl__ext_fault*)p->ptr);
		break;
	case SOAP_TYPE_wsdl__binding_operation:
		if (p->size < 0)
			SOAP_DELETE((wsdl__binding_operation*)p->ptr);
		else
			SOAP_DELETE_ARRAY((wsdl__binding_operation*)p->ptr);
		break;
	case SOAP_TYPE_wsdl__binding:
		if (p->size < 0)
			SOAP_DELETE((wsdl__binding*)p->ptr);
		else
			SOAP_DELETE_ARRAY((wsdl__binding*)p->ptr);
		break;
	case SOAP_TYPE_wsdl__port:
		if (p->size < 0)
			SOAP_DELETE((wsdl__port*)p->ptr);
		else
			SOAP_DELETE_ARRAY((wsdl__port*)p->ptr);
		break;
	case SOAP_TYPE_wsdl__service:
		if (p->size < 0)
			SOAP_DELETE((wsdl__service*)p->ptr);
		else
			SOAP_DELETE_ARRAY((wsdl__service*)p->ptr);
		break;
	case SOAP_TYPE_wsdl__definitions:
		if (p->size < 0)
			SOAP_DELETE((wsdl__definitions*)p->ptr);
		else
			SOAP_DELETE_ARRAY((wsdl__definitions*)p->ptr);
		break;
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Header:
		if (p->size < 0)
			SOAP_DELETE((struct SOAP_ENV__Header*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct SOAP_ENV__Header*)p->ptr);
		break;
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Code:
		if (p->size < 0)
			SOAP_DELETE((struct SOAP_ENV__Code*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct SOAP_ENV__Code*)p->ptr);
		break;
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Detail:
		if (p->size < 0)
			SOAP_DELETE((struct SOAP_ENV__Detail*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct SOAP_ENV__Detail*)p->ptr);
		break;
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Reason:
		if (p->size < 0)
			SOAP_DELETE((struct SOAP_ENV__Reason*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct SOAP_ENV__Reason*)p->ptr);
		break;
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Fault:
		if (p->size < 0)
			SOAP_DELETE((struct SOAP_ENV__Fault*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct SOAP_ENV__Fault*)p->ptr);
		break;
#endif
	case SOAP_TYPE_std__vectorTemplateOfgwsdl__portType:
		if (p->size < 0)
			SOAP_DELETE((std::vector<gwsdl__portType >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<gwsdl__portType >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfwsdl__service:
		if (p->size < 0)
			SOAP_DELETE((std::vector<wsdl__service >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<wsdl__service >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfwsdl__binding:
		if (p->size < 0)
			SOAP_DELETE((std::vector<wsdl__binding >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<wsdl__binding >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfwsdl__portType:
		if (p->size < 0)
			SOAP_DELETE((std::vector<wsdl__portType >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<wsdl__portType >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfwsdl__message:
		if (p->size < 0)
			SOAP_DELETE((std::vector<wsdl__message >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<wsdl__message >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfwsdl__import:
		if (p->size < 0)
			SOAP_DELETE((std::vector<wsdl__import >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<wsdl__import >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfwsdl__port:
		if (p->size < 0)
			SOAP_DELETE((std::vector<wsdl__port >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<wsdl__port >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfwsdl__binding_operation:
		if (p->size < 0)
			SOAP_DELETE((std::vector<wsdl__binding_operation >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<wsdl__binding_operation >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfwsdl__ext_fault:
		if (p->size < 0)
			SOAP_DELETE((std::vector<wsdl__ext_fault >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<wsdl__ext_fault >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfwsdl__operation:
		if (p->size < 0)
			SOAP_DELETE((std::vector<wsdl__operation >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<wsdl__operation >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfwsdl__fault:
		if (p->size < 0)
			SOAP_DELETE((std::vector<wsdl__fault >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<wsdl__fault >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfwsdl__part:
		if (p->size < 0)
			SOAP_DELETE((std::vector<wsdl__part >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<wsdl__part >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfwsp__PolicyReference:
		if (p->size < 0)
			SOAP_DELETE((std::vector<wsp__PolicyReference >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<wsp__PolicyReference >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfwsp__Policy:
		if (p->size < 0)
			SOAP_DELETE((std::vector<wsp__Policy >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<wsp__Policy >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerToxs__schema:
		if (p->size < 0)
			SOAP_DELETE((std::vector<xs__schema * >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<xs__schema * >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfwsp__Attachment:
		if (p->size < 0)
			SOAP_DELETE((std::vector<wsp__Attachment >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<wsp__Attachment >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOf_XML:
		if (p->size < 0)
			SOAP_DELETE((std::vector<char * >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<char * >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfsp__Parts:
		if (p->size < 0)
			SOAP_DELETE((std::vector<sp__Parts >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<sp__Parts >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTowsp__Content:
		if (p->size < 0)
			SOAP_DELETE((std::vector<wsp__Content * >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<wsp__Content * >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfxsd__string:
		if (p->size < 0)
			SOAP_DELETE((std::vector<char * >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<char * >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfsp__Header:
		if (p->size < 0)
			SOAP_DELETE((std::vector<sp__Header >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<sp__Header >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfsd__serviceData:
		if (p->size < 0)
			SOAP_DELETE((std::vector<sd__serviceData >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<sd__serviceData >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTowsdl__operation:
		if (p->size < 0)
			SOAP_DELETE((std::vector<wsdl__operation * >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<wsdl__operation * >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfmime__part:
		if (p->size < 0)
			SOAP_DELETE((std::vector<mime__part >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<mime__part >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfmime__content:
		if (p->size < 0)
			SOAP_DELETE((std::vector<mime__content >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<mime__content >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfsoap__header:
		if (p->size < 0)
			SOAP_DELETE((std::vector<soap__header >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<soap__header >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfsoap__headerfault:
		if (p->size < 0)
			SOAP_DELETE((std::vector<soap__headerfault >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<soap__headerfault >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfxs__import:
		if (p->size < 0)
			SOAP_DELETE((std::vector<xs__import >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<xs__import >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfxs__redefine:
		if (p->size < 0)
			SOAP_DELETE((std::vector<xs__redefine >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<xs__redefine >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfxs__include:
		if (p->size < 0)
			SOAP_DELETE((std::vector<xs__include >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<xs__include >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfxs__complexType:
		if (p->size < 0)
			SOAP_DELETE((std::vector<xs__complexType >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<xs__complexType >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfxs__group:
		if (p->size < 0)
			SOAP_DELETE((std::vector<xs__group >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<xs__group >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfxs__simpleType:
		if (p->size < 0)
			SOAP_DELETE((std::vector<xs__simpleType >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<xs__simpleType >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfxs__pattern:
		if (p->size < 0)
			SOAP_DELETE((std::vector<xs__pattern >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<xs__pattern >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfxs__enumeration:
		if (p->size < 0)
			SOAP_DELETE((std::vector<xs__enumeration >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<xs__enumeration >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfxs__attributeGroup:
		if (p->size < 0)
			SOAP_DELETE((std::vector<xs__attributeGroup >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<xs__attributeGroup >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfxs__attribute:
		if (p->size < 0)
			SOAP_DELETE((std::vector<xs__attribute >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<xs__attribute >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfxs__contents:
		if (p->size < 0)
			SOAP_DELETE((std::vector<xs__contents >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<xs__contents >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfxs__element:
		if (p->size < 0)
			SOAP_DELETE((std::vector<xs__element >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<xs__element >*)p->ptr);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerToxs__element:
		if (p->size < 0)
			SOAP_DELETE((std::vector<xs__element * >*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::vector<xs__element * >*)p->ptr);
		break;
	default:	return SOAP_ERR;
	}
	return SOAP_OK;
}

SOAP_FMAC3 void* SOAP_FMAC4 soap_class_id_enter(struct soap *soap, const char *id, void *p, int t, size_t n, const char *type, const char *arrayType)
{	return soap_id_enter(soap, id, p, t, n, 0, type, arrayType, wsdl_instantiate);
}

SOAP_FMAC3 void* SOAP_FMAC4 soap_container_id_forward(struct soap *soap, const char *href, void *p, size_t len, int st, int tt, size_t n, unsigned int k)
{	return soap_id_forward(soap, href, p, len, st, tt, n, k, wsdl_container_insert);
}

SOAP_FMAC3 void SOAP_FMAC4 wsdl_container_insert(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
#ifdef WIN32
#pragma warning(push)
#pragma warning(disable:4065)
#endif
{
	(void)soap; (void)st; (void)p; (void)len; (void)q; (void)n; /* appease -Wall -Werror */
	switch (tt)
	{
	case SOAP_TYPE_std__vectorTemplateOfgwsdl__portType:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container wsdl_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<gwsdl__portType >*)p)[len] = *(gwsdl__portType *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfwsdl__service:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container wsdl_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<wsdl__service >*)p)[len] = *(wsdl__service *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfwsdl__binding:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container wsdl_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<wsdl__binding >*)p)[len] = *(wsdl__binding *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfwsdl__portType:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container wsdl_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<wsdl__portType >*)p)[len] = *(wsdl__portType *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfwsdl__message:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container wsdl_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<wsdl__message >*)p)[len] = *(wsdl__message *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfwsdl__import:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container wsdl_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<wsdl__import >*)p)[len] = *(wsdl__import *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfwsdl__port:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container wsdl_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<wsdl__port >*)p)[len] = *(wsdl__port *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfwsdl__binding_operation:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container wsdl_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<wsdl__binding_operation >*)p)[len] = *(wsdl__binding_operation *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfwsdl__ext_fault:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container wsdl_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<wsdl__ext_fault >*)p)[len] = *(wsdl__ext_fault *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfwsdl__operation:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container wsdl_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<wsdl__operation >*)p)[len] = *(wsdl__operation *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfwsdl__fault:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container wsdl_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<wsdl__fault >*)p)[len] = *(wsdl__fault *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfwsdl__part:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container wsdl_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<wsdl__part >*)p)[len] = *(wsdl__part *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfwsp__PolicyReference:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container wsdl_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<wsp__PolicyReference >*)p)[len] = *(wsp__PolicyReference *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfwsp__Policy:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container wsdl_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<wsp__Policy >*)p)[len] = *(wsp__Policy *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerToxs__schema:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container wsdl_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<xs__schema * >*)p)[len] = *(xs__schema **)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfwsp__Attachment:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container wsdl_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<wsp__Attachment >*)p)[len] = *(wsp__Attachment *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOf_XML:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container wsdl_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<char * >*)p)[len] = *(char **)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfsp__Parts:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container wsdl_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<sp__Parts >*)p)[len] = *(sp__Parts *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTowsp__Content:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container wsdl_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<wsp__Content * >*)p)[len] = *(wsp__Content **)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfxsd__string:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container wsdl_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<char * >*)p)[len] = *(char **)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfsp__Header:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container wsdl_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<sp__Header >*)p)[len] = *(sp__Header *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfsd__serviceData:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container wsdl_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<sd__serviceData >*)p)[len] = *(sd__serviceData *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTowsdl__operation:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container wsdl_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<wsdl__operation * >*)p)[len] = *(wsdl__operation **)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfmime__part:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container wsdl_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<mime__part >*)p)[len] = *(mime__part *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfmime__content:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container wsdl_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<mime__content >*)p)[len] = *(mime__content *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfsoap__header:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container wsdl_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<soap__header >*)p)[len] = *(soap__header *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfsoap__headerfault:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container wsdl_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<soap__headerfault >*)p)[len] = *(soap__headerfault *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfxs__import:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container wsdl_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<xs__import >*)p)[len] = *(xs__import *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfxs__redefine:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container wsdl_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<xs__redefine >*)p)[len] = *(xs__redefine *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfxs__include:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container wsdl_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<xs__include >*)p)[len] = *(xs__include *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfxs__complexType:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container wsdl_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<xs__complexType >*)p)[len] = *(xs__complexType *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfxs__group:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container wsdl_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<xs__group >*)p)[len] = *(xs__group *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfxs__simpleType:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container wsdl_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<xs__simpleType >*)p)[len] = *(xs__simpleType *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfxs__pattern:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container wsdl_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<xs__pattern >*)p)[len] = *(xs__pattern *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfxs__enumeration:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container wsdl_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<xs__enumeration >*)p)[len] = *(xs__enumeration *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfxs__attributeGroup:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container wsdl_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<xs__attributeGroup >*)p)[len] = *(xs__attributeGroup *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfxs__attribute:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container wsdl_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<xs__attribute >*)p)[len] = *(xs__attribute *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfxs__contents:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container wsdl_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<xs__contents >*)p)[len] = *(xs__contents *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfxs__element:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container wsdl_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<xs__element >*)p)[len] = *(xs__element *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerToxs__element:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container wsdl_container_insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<xs__element * >*)p)[len] = *(xs__element **)q;
		break;
	default:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Could not insert type=%d in %d\n", st, tt));
	}
#ifdef WIN32
#pragma warning(pop)
#endif
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_byte(struct soap *soap, char *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_byte
	*a = SOAP_DEFAULT_byte;
#else
	*a = (char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{	char *p;
	p = soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_byte);
	if (soap_out_byte(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_int(struct soap *soap, int *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_int
	*a = SOAP_DEFAULT_int;
#else
	*a = (int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{	int *p;
	p = soap_inint(soap, tag, a, type, SOAP_TYPE_int);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_int);
	if (soap_out_int(soap, tag?tag:"int", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_sd__mutability(struct soap *soap, enum sd__mutability *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_sd__mutability
	*a = SOAP_DEFAULT_sd__mutability;
#else
	*a = (enum sd__mutability)0;
#endif
}

static const struct soap_code_map soap_codes_sd__mutability[] =
{	{ (long)static_, "static" },
	{ (long)constant, "constant" },
	{ (long)extendable, "extendable" },
	{ (long)mutable_, "mutable" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_sd__mutability2s(struct soap *soap, enum sd__mutability n)
{	const char *s = soap_code_str(soap_codes_sd__mutability, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sd__mutability(struct soap *soap, const char *tag, int id, const enum sd__mutability *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sd__mutability), type) || soap_send(soap, soap_sd__mutability2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2sd__mutability(struct soap *soap, const char *s, enum sd__mutability *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_sd__mutability, s);
	if (map)
		*a = (enum sd__mutability)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 3)))
			return soap->error = SOAP_TYPE;
		*a = (enum sd__mutability)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum sd__mutability * SOAP_FMAC4 soap_in_sd__mutability(struct soap *soap, const char *tag, enum sd__mutability *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum sd__mutability *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_sd__mutability, sizeof(enum sd__mutability), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2sd__mutability(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum sd__mutability *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sd__mutability, 0, sizeof(enum sd__mutability), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_sd__mutability(struct soap *soap, const enum sd__mutability *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_sd__mutability);
	if (soap_out_sd__mutability(soap, tag?tag:"sd:mutability", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum sd__mutability * SOAP_FMAC4 soap_get_sd__mutability(struct soap *soap, enum sd__mutability *p, const char *tag, const char *type)
{
	if ((p = soap_in_sd__mutability(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_soap__useChoice(struct soap *soap, enum soap__useChoice *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_soap__useChoice
	*a = SOAP_DEFAULT_soap__useChoice;
#else
	*a = (enum soap__useChoice)0;
#endif
}

static const struct soap_code_map soap_codes_soap__useChoice[] =
{	{ (long)literal, "literal" },
	{ (long)encoded, "encoded" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_soap__useChoice2s(struct soap *soap, enum soap__useChoice n)
{	const char *s = soap_code_str(soap_codes_soap__useChoice, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_soap__useChoice(struct soap *soap, const char *tag, int id, const enum soap__useChoice *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_soap__useChoice), type) || soap_send(soap, soap_soap__useChoice2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2soap__useChoice(struct soap *soap, const char *s, enum soap__useChoice *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_soap__useChoice, s);
	if (map)
		*a = (enum soap__useChoice)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum soap__useChoice)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum soap__useChoice * SOAP_FMAC4 soap_in_soap__useChoice(struct soap *soap, const char *tag, enum soap__useChoice *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum soap__useChoice *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_soap__useChoice, sizeof(enum soap__useChoice), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2soap__useChoice(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum soap__useChoice *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_soap__useChoice, 0, sizeof(enum soap__useChoice), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_soap__useChoice(struct soap *soap, const enum soap__useChoice *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_soap__useChoice);
	if (soap_out_soap__useChoice(soap, tag?tag:"soap:useChoice", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum soap__useChoice * SOAP_FMAC4 soap_get_soap__useChoice(struct soap *soap, enum soap__useChoice *p, const char *tag, const char *type)
{
	if ((p = soap_in_soap__useChoice(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_soap__styleChoice(struct soap *soap, enum soap__styleChoice *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_soap__styleChoice
	*a = SOAP_DEFAULT_soap__styleChoice;
#else
	*a = (enum soap__styleChoice)0;
#endif
}

static const struct soap_code_map soap_codes_soap__styleChoice[] =
{	{ (long)rpc, "rpc" },
	{ (long)document, "document" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_soap__styleChoice2s(struct soap *soap, enum soap__styleChoice n)
{	const char *s = soap_code_str(soap_codes_soap__styleChoice, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_soap__styleChoice(struct soap *soap, const char *tag, int id, const enum soap__styleChoice *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_soap__styleChoice), type) || soap_send(soap, soap_soap__styleChoice2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2soap__styleChoice(struct soap *soap, const char *s, enum soap__styleChoice *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_soap__styleChoice, s);
	if (map)
		*a = (enum soap__styleChoice)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum soap__styleChoice)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum soap__styleChoice * SOAP_FMAC4 soap_in_soap__styleChoice(struct soap *soap, const char *tag, enum soap__styleChoice *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum soap__styleChoice *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_soap__styleChoice, sizeof(enum soap__styleChoice), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2soap__styleChoice(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum soap__styleChoice *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_soap__styleChoice, 0, sizeof(enum soap__styleChoice), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_soap__styleChoice(struct soap *soap, const enum soap__styleChoice *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_soap__styleChoice);
	if (soap_out_soap__styleChoice(soap, tag?tag:"soap:styleChoice", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum soap__styleChoice * SOAP_FMAC4 soap_get_soap__styleChoice(struct soap *soap, enum soap__styleChoice *p, const char *tag, const char *type)
{
	if ((p = soap_in_soap__styleChoice(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xs__processContents(struct soap *soap, enum xs__processContents *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_xs__processContents
	*a = SOAP_DEFAULT_xs__processContents;
#else
	*a = (enum xs__processContents)0;
#endif
}

static const struct soap_code_map soap_codes_xs__processContents[] =
{	{ (long)strict, "strict" },
	{ (long)skip, "skip" },
	{ (long)lax, "lax" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_xs__processContents2s(struct soap *soap, enum xs__processContents n)
{	const char *s = soap_code_str(soap_codes_xs__processContents, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xs__processContents(struct soap *soap, const char *tag, int id, const enum xs__processContents *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xs__processContents), type) || soap_send(soap, soap_xs__processContents2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2xs__processContents(struct soap *soap, const char *s, enum xs__processContents *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_xs__processContents, s);
	if (map)
		*a = (enum xs__processContents)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 2)))
			return soap->error = SOAP_TYPE;
		*a = (enum xs__processContents)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum xs__processContents * SOAP_FMAC4 soap_in_xs__processContents(struct soap *soap, const char *tag, enum xs__processContents *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum xs__processContents *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_xs__processContents, sizeof(enum xs__processContents), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2xs__processContents(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum xs__processContents *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xs__processContents, 0, sizeof(enum xs__processContents), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xs__processContents(struct soap *soap, const enum xs__processContents *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xs__processContents);
	if (soap_out_xs__processContents(soap, tag?tag:"xs:processContents", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum xs__processContents * SOAP_FMAC4 soap_get_xs__processContents(struct soap *soap, enum xs__processContents *p, const char *tag, const char *type)
{
	if ((p = soap_in_xs__processContents(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xs__attribute_use(struct soap *soap, enum xs__attribute_use *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_xs__attribute_use
	*a = SOAP_DEFAULT_xs__attribute_use;
#else
	*a = (enum xs__attribute_use)0;
#endif
}

static const struct soap_code_map soap_codes_xs__attribute_use[] =
{	{ (long)optional, "optional" },
	{ (long)prohibited, "prohibited" },
	{ (long)required, "required" },
	{ (long)default_, "default" },
	{ (long)fixed_, "fixed" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_xs__attribute_use2s(struct soap *soap, enum xs__attribute_use n)
{	const char *s = soap_code_str(soap_codes_xs__attribute_use, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xs__attribute_use(struct soap *soap, const char *tag, int id, const enum xs__attribute_use *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xs__attribute_use), type) || soap_send(soap, soap_xs__attribute_use2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2xs__attribute_use(struct soap *soap, const char *s, enum xs__attribute_use *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_xs__attribute_use, s);
	if (map)
		*a = (enum xs__attribute_use)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 4)))
			return soap->error = SOAP_TYPE;
		*a = (enum xs__attribute_use)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum xs__attribute_use * SOAP_FMAC4 soap_in_xs__attribute_use(struct soap *soap, const char *tag, enum xs__attribute_use *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum xs__attribute_use *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_xs__attribute_use, sizeof(enum xs__attribute_use), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2xs__attribute_use(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum xs__attribute_use *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xs__attribute_use, 0, sizeof(enum xs__attribute_use), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xs__attribute_use(struct soap *soap, const enum xs__attribute_use *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xs__attribute_use);
	if (soap_out_xs__attribute_use(soap, tag?tag:"xs:attribute-use", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum xs__attribute_use * SOAP_FMAC4 soap_get_xs__attribute_use(struct soap *soap, enum xs__attribute_use *p, const char *tag, const char *type)
{
	if ((p = soap_in_xs__attribute_use(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xs__formChoice(struct soap *soap, enum xs__formChoice *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_xs__formChoice
	*a = SOAP_DEFAULT_xs__formChoice;
#else
	*a = (enum xs__formChoice)0;
#endif
}

static const struct soap_code_map soap_codes_xs__formChoice[] =
{	{ (long)unqualified, "unqualified" },
	{ (long)qualified, "qualified" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_xs__formChoice2s(struct soap *soap, enum xs__formChoice n)
{	const char *s = soap_code_str(soap_codes_xs__formChoice, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xs__formChoice(struct soap *soap, const char *tag, int id, const enum xs__formChoice *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xs__formChoice), type) || soap_send(soap, soap_xs__formChoice2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2xs__formChoice(struct soap *soap, const char *s, enum xs__formChoice *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_xs__formChoice, s);
	if (map)
		*a = (enum xs__formChoice)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum xs__formChoice)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum xs__formChoice * SOAP_FMAC4 soap_in_xs__formChoice(struct soap *soap, const char *tag, enum xs__formChoice *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum xs__formChoice *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_xs__formChoice, sizeof(enum xs__formChoice), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2xs__formChoice(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum xs__formChoice *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xs__formChoice, 0, sizeof(enum xs__formChoice), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xs__formChoice(struct soap *soap, const enum xs__formChoice *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xs__formChoice);
	if (soap_out_xs__formChoice(soap, tag?tag:"xs:formChoice", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum xs__formChoice * SOAP_FMAC4 soap_get_xs__formChoice(struct soap *soap, enum xs__formChoice *p, const char *tag, const char *type)
{
	if ((p = soap_in_xs__formChoice(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3S const char* SOAP_FMAC4S soap_xsd__boolean2s(struct soap *soap, bool n)
{	return soap_bool2s(soap, n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__boolean(struct soap *soap, const char *tag, int id, const bool *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xsd__boolean), type) || soap_send(soap, soap_xsd__boolean2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2xsd__boolean(struct soap *soap, const char *s, bool *a)
{
	return soap_s2bool(soap, s, a);
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_in_xsd__boolean(struct soap *soap, const char *tag, bool *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type) && soap_match_tag(soap, soap->type, ":boolean"))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (bool *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__boolean, sizeof(bool), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2xsd__boolean(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (bool *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xsd__boolean, 0, sizeof(bool), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__boolean(struct soap *soap, const bool *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__boolean);
	if (soap_out_xsd__boolean(soap, tag?tag:"xsd:boolean", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_get_xsd__boolean(struct soap *soap, bool *p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__boolean(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_bool(struct soap *soap, bool *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_bool
	*a = SOAP_DEFAULT_bool;
#else
	*a = (bool)0;
#endif
}

static const struct soap_code_map soap_codes_bool[] =
{	{ (long)false, "false" },
	{ (long)true, "true" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_bool2s(struct soap *soap, bool n)
{
	(void)soap; /* appease -Wall -Werror */
return soap_code_str(soap_codes_bool, n!=0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_bool(struct soap *soap, const char *tag, int id, const bool *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_bool), type) || soap_send(soap, soap_bool2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2bool(struct soap *soap, const char *s, bool *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_bool, s);
	if (map)
		*a = (bool)(map->code != 0);
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || n < 0 || n > 1)
			return soap->error = SOAP_TYPE;
		*a = (bool)(n != 0);
	}
	return SOAP_OK;
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_in_bool(struct soap *soap, const char *tag, bool *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type) && soap_match_tag(soap, soap->type, ":boolean"))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (bool *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_bool, sizeof(bool), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2bool(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (bool *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_bool, 0, sizeof(bool), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_bool(struct soap *soap, const bool *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_bool);
	if (soap_out_bool(soap, tag?tag:"boolean", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_get_bool(struct soap *soap, bool *p, const char *tag, const char *type)
{
	if ((p = soap_in_bool(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

void wsdl__service::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__NMTOKEN(soap, &this->wsdl__service::name);
	soap_default_xsd__string(soap, &this->wsdl__service::documentation);
	soap_default_std__vectorTemplateOfwsp__Policy(soap, &this->wsdl__service::wsp__Policy_);
	soap_default_std__vectorTemplateOfwsp__PolicyReference(soap, &this->wsdl__service::wsp__PolicyReference_);
	soap_default_std__vectorTemplateOfwsdl__port(soap, &this->wsdl__service::port);
}

void wsdl__service::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &this->wsdl__service::documentation);
	soap_serialize_std__vectorTemplateOfwsp__Policy(soap, &this->wsdl__service::wsp__Policy_);
	soap_serialize_std__vectorTemplateOfwsp__PolicyReference(soap, &this->wsdl__service::wsp__PolicyReference_);
	soap_serialize_std__vectorTemplateOfwsdl__port(soap, &this->wsdl__service::port);
	/* transient traverse skipped */
}

int wsdl__service::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_wsdl__service(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsdl__service(struct soap *soap, const char *tag, int id, const wsdl__service *a, const char *type)
{
	if (((wsdl__service*)a)->name)
		soap_set_attr(soap, "name", ((wsdl__service*)a)->name, 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsdl__service), type))
		return soap->error;
	if (soap_out_xsd__string(soap, "wsdl:documentation", -1, &(a->wsdl__service::documentation), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfwsp__Policy(soap, "wsp:Policy", -1, &(a->wsdl__service::wsp__Policy_), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfwsp__PolicyReference(soap, "wsp:PolicyReference", -1, &(a->wsdl__service::wsp__PolicyReference_), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfwsdl__port(soap, "wsdl:port", -1, &(a->wsdl__service::port), ""))
		return soap->error;
	/* transient traverse skipped */
	return soap_element_end_out(soap, tag);
}

void *wsdl__service::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_wsdl__service(soap, tag, this, type);
}

SOAP_FMAC3 wsdl__service * SOAP_FMAC4 soap_in_wsdl__service(struct soap *soap, const char *tag, wsdl__service *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (wsdl__service *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_wsdl__service, sizeof(wsdl__service), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_wsdl__service)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (wsdl__service *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "name", 0), &((wsdl__service*)a)->name, 0, -1))
		return NULL;
	size_t soap_flag_documentation1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_documentation1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "wsdl:documentation", &(a->wsdl__service::documentation), "xsd:string"))
				{	soap_flag_documentation1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfwsp__Policy(soap, "wsp:Policy", &(a->wsdl__service::wsp__Policy_), "wsp:Policy"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfwsp__PolicyReference(soap, "wsp:PolicyReference", &(a->wsdl__service::wsp__PolicyReference_), "wsp:PolicyReference"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfwsdl__port(soap, "wsdl:port", &(a->wsdl__service::port), "wsdl:port"))
					continue;
			/* transient traverse skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (wsdl__service *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsdl__service, 0, sizeof(wsdl__service), 0, soap_copy_wsdl__service);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int wsdl__service::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_wsdl__service);
	if (this->soap_out(soap, tag?tag:"wsdl:service", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *wsdl__service::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_wsdl__service(soap, this, tag, type);
}

SOAP_FMAC3 wsdl__service * SOAP_FMAC4 soap_get_wsdl__service(struct soap *soap, wsdl__service *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsdl__service(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 wsdl__service * SOAP_FMAC2 soap_instantiate_wsdl__service(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsdl__service(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsdl__service, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(wsdl__service);
		if (size)
			*size = sizeof(wsdl__service);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(wsdl__service[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(wsdl__service);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (wsdl__service*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsdl__service(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying wsdl__service %p -> %p\n", q, p));
	*(wsdl__service*)p = *(wsdl__service*)q;
}

void wsdl__port::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__NMTOKEN(soap, &this->wsdl__port::name);
	soap_default_xsd__QName(soap, &this->wsdl__port::binding);
	soap_default_xsd__string(soap, &this->wsdl__port::documentation);
	this->wsdl__port::wsp__Policy_ = NULL;
	this->wsdl__port::wsp__PolicyReference_ = NULL;
	this->wsdl__port::wsa__EndpointReference = NULL;
	this->wsdl__port::soap__address_ = NULL;
	this->wsdl__port::http__address_ = NULL;
	this->wsdl__port::bindingRef = NULL;
}

void wsdl__port::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &this->wsdl__port::documentation);
	soap_serialize_PointerTowsp__Policy(soap, &this->wsdl__port::wsp__Policy_);
	soap_serialize_PointerTowsp__PolicyReference(soap, &this->wsdl__port::wsp__PolicyReference_);
	soap_serialize_PointerTowsa__EndpointReferenceType(soap, &this->wsdl__port::wsa__EndpointReference);
	soap_serialize_PointerTosoap__address(soap, &this->wsdl__port::soap__address_);
	soap_serialize_PointerTohttp__address(soap, &this->wsdl__port::http__address_);
	/* non-serializable bindingRef skipped */
	/* transient wsdl__port skipped */
	/* transient traverse skipped */
	/* transient bindingPtr skipped */
	/* transient bindingPtr skipped */
}

int wsdl__port::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_wsdl__port(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsdl__port(struct soap *soap, const char *tag, int id, const wsdl__port *a, const char *type)
{
	if (((wsdl__port*)a)->name)
		soap_set_attr(soap, "name", ((wsdl__port*)a)->name, 1);
	if (((wsdl__port*)a)->binding)
		soap_set_attr(soap, "binding", soap_QName2s(soap, ((wsdl__port*)a)->binding), 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsdl__port), type))
		return soap->error;
	if (soap_out_xsd__string(soap, "wsdl:documentation", -1, &(a->wsdl__port::documentation), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Policy(soap, "wsp:Policy", -1, &(a->wsdl__port::wsp__Policy_), ""))
		return soap->error;
	if (soap_out_PointerTowsp__PolicyReference(soap, "wsp:PolicyReference", -1, &(a->wsdl__port::wsp__PolicyReference_), ""))
		return soap->error;
	if (soap_out_PointerTowsa__EndpointReferenceType(soap, "wsa:EndpointReference", -1, &(a->wsdl__port::wsa__EndpointReference), ""))
		return soap->error;
	if (soap_out_PointerTosoap__address(soap, "soap:address", -1, &(a->wsdl__port::soap__address_), ""))
		return soap->error;
	if (soap_out_PointerTohttp__address(soap, "http:address", -1, &(a->wsdl__port::http__address_), ""))
		return soap->error;
	/* non-serializable bindingRef skipped */
	/* transient wsdl__port skipped */
	/* transient traverse skipped */
	/* transient bindingPtr skipped */
	/* transient bindingPtr skipped */
	return soap_element_end_out(soap, tag);
}

void *wsdl__port::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_wsdl__port(soap, tag, this, type);
}

SOAP_FMAC3 wsdl__port * SOAP_FMAC4 soap_in_wsdl__port(struct soap *soap, const char *tag, wsdl__port *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (wsdl__port *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_wsdl__port, sizeof(wsdl__port), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_wsdl__port)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (wsdl__port *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "name", 0), &((wsdl__port*)a)->name, 0, -1))
		return NULL;
	if (soap_s2QName(soap, soap_attr_value(soap, "binding", 0), &((wsdl__port*)a)->binding, 0, -1))
		return NULL;
	size_t soap_flag_documentation1 = 1;
	size_t soap_flag_wsp__Policy_1 = 1;
	size_t soap_flag_wsp__PolicyReference_1 = 1;
	size_t soap_flag_wsa__EndpointReference1 = 1;
	size_t soap_flag_soap__address_1 = 1;
	size_t soap_flag_http__address_1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_documentation1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "wsdl:documentation", &(a->wsdl__port::documentation), "xsd:string"))
				{	soap_flag_documentation1--;
					continue;
				}
			if (soap_flag_wsp__Policy_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Policy(soap, "wsp:Policy", &(a->wsdl__port::wsp__Policy_), "wsp:Policy"))
				{	soap_flag_wsp__Policy_1--;
					continue;
				}
			if (soap_flag_wsp__PolicyReference_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__PolicyReference(soap, "wsp:PolicyReference", &(a->wsdl__port::wsp__PolicyReference_), "wsp:PolicyReference"))
				{	soap_flag_wsp__PolicyReference_1--;
					continue;
				}
			if (soap_flag_wsa__EndpointReference1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsa__EndpointReferenceType(soap, "wsa:EndpointReference", &(a->wsdl__port::wsa__EndpointReference), "wsa:EndpointReferenceType"))
				{	soap_flag_wsa__EndpointReference1--;
					continue;
				}
			if (soap_flag_soap__address_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosoap__address(soap, "soap:address", &(a->wsdl__port::soap__address_), "soap:address"))
				{	soap_flag_soap__address_1--;
					continue;
				}
			if (soap_flag_http__address_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTohttp__address(soap, "http:address", &(a->wsdl__port::http__address_), "http:address"))
				{	soap_flag_http__address_1--;
					continue;
				}
			/* non-serializable bindingRef skipped */
			/* transient wsdl__port skipped */
			/* transient traverse skipped */
			/* transient bindingPtr skipped */
			/* transient bindingPtr skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (wsdl__port *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsdl__port, 0, sizeof(wsdl__port), 0, soap_copy_wsdl__port);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int wsdl__port::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_wsdl__port);
	if (this->soap_out(soap, tag?tag:"wsdl:port", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *wsdl__port::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_wsdl__port(soap, this, tag, type);
}

SOAP_FMAC3 wsdl__port * SOAP_FMAC4 soap_get_wsdl__port(struct soap *soap, wsdl__port *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsdl__port(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 wsdl__port * SOAP_FMAC2 soap_instantiate_wsdl__port(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsdl__port(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsdl__port, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(wsdl__port);
		if (size)
			*size = sizeof(wsdl__port);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(wsdl__port[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(wsdl__port);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (wsdl__port*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsdl__port(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying wsdl__port %p -> %p\n", q, p));
	*(wsdl__port*)p = *(wsdl__port*)q;
}

void wsdl__binding::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__NMTOKEN(soap, &this->wsdl__binding::name);
	soap_default_xsd__QName(soap, &this->wsdl__binding::type);
	soap_default_xsd__string(soap, &this->wsdl__binding::documentation);
	soap_default_std__vectorTemplateOfwsp__Policy(soap, &this->wsdl__binding::wsp__Policy_);
	soap_default_std__vectorTemplateOfwsp__PolicyReference(soap, &this->wsdl__binding::wsp__PolicyReference_);
	this->wsdl__binding::soap__binding_ = NULL;
	this->wsdl__binding::http__binding_ = NULL;
	soap_default_std__vectorTemplateOfwsdl__binding_operation(soap, &this->wsdl__binding::operation);
	this->wsdl__binding::portTypeRef = NULL;
}

void wsdl__binding::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &this->wsdl__binding::documentation);
	soap_serialize_std__vectorTemplateOfwsp__Policy(soap, &this->wsdl__binding::wsp__Policy_);
	soap_serialize_std__vectorTemplateOfwsp__PolicyReference(soap, &this->wsdl__binding::wsp__PolicyReference_);
	soap_serialize_PointerTosoap__binding(soap, &this->wsdl__binding::soap__binding_);
	soap_serialize_PointerTohttp__binding(soap, &this->wsdl__binding::http__binding_);
	soap_serialize_std__vectorTemplateOfwsdl__binding_operation(soap, &this->wsdl__binding::operation);
	/* non-serializable portTypeRef skipped */
	/* transient wsdl__binding skipped */
	/* transient traverse skipped */
	/* transient portTypePtr skipped */
	/* transient portTypePtr skipped */
}

int wsdl__binding::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_wsdl__binding(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsdl__binding(struct soap *soap, const char *tag, int id, const wsdl__binding *a, const char *type)
{
	if (((wsdl__binding*)a)->name)
		soap_set_attr(soap, "name", ((wsdl__binding*)a)->name, 1);
	if (((wsdl__binding*)a)->type)
		soap_set_attr(soap, "type", soap_QName2s(soap, ((wsdl__binding*)a)->type), 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsdl__binding), type))
		return soap->error;
	if (soap_out_xsd__string(soap, "wsdl:documentation", -1, &(a->wsdl__binding::documentation), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfwsp__Policy(soap, "wsp:Policy", -1, &(a->wsdl__binding::wsp__Policy_), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfwsp__PolicyReference(soap, "wsp:PolicyReference", -1, &(a->wsdl__binding::wsp__PolicyReference_), ""))
		return soap->error;
	if (soap_out_PointerTosoap__binding(soap, "soap:binding", -1, &(a->wsdl__binding::soap__binding_), ""))
		return soap->error;
	if (soap_out_PointerTohttp__binding(soap, "http:binding", -1, &(a->wsdl__binding::http__binding_), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfwsdl__binding_operation(soap, "wsdl:operation", -1, &(a->wsdl__binding::operation), ""))
		return soap->error;
	/* non-serializable portTypeRef skipped */
	/* transient wsdl__binding skipped */
	/* transient traverse skipped */
	/* transient portTypePtr skipped */
	/* transient portTypePtr skipped */
	return soap_element_end_out(soap, tag);
}

void *wsdl__binding::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_wsdl__binding(soap, tag, this, type);
}

SOAP_FMAC3 wsdl__binding * SOAP_FMAC4 soap_in_wsdl__binding(struct soap *soap, const char *tag, wsdl__binding *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (wsdl__binding *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_wsdl__binding, sizeof(wsdl__binding), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_wsdl__binding)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (wsdl__binding *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "name", 0), &((wsdl__binding*)a)->name, 0, -1))
		return NULL;
	if (soap_s2QName(soap, soap_attr_value(soap, "type", 0), &((wsdl__binding*)a)->type, 0, -1))
		return NULL;
	size_t soap_flag_documentation1 = 1;
	size_t soap_flag_soap__binding_1 = 1;
	size_t soap_flag_http__binding_1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_documentation1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "wsdl:documentation", &(a->wsdl__binding::documentation), "xsd:string"))
				{	soap_flag_documentation1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfwsp__Policy(soap, "wsp:Policy", &(a->wsdl__binding::wsp__Policy_), "wsp:Policy"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfwsp__PolicyReference(soap, "wsp:PolicyReference", &(a->wsdl__binding::wsp__PolicyReference_), "wsp:PolicyReference"))
					continue;
			if (soap_flag_soap__binding_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosoap__binding(soap, "soap:binding", &(a->wsdl__binding::soap__binding_), "soap:binding"))
				{	soap_flag_soap__binding_1--;
					continue;
				}
			if (soap_flag_http__binding_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTohttp__binding(soap, "http:binding", &(a->wsdl__binding::http__binding_), "http:binding"))
				{	soap_flag_http__binding_1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfwsdl__binding_operation(soap, "wsdl:operation", &(a->wsdl__binding::operation), "wsdl:binding-operation"))
					continue;
			/* non-serializable portTypeRef skipped */
			/* transient wsdl__binding skipped */
			/* transient traverse skipped */
			/* transient portTypePtr skipped */
			/* transient portTypePtr skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (wsdl__binding *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsdl__binding, 0, sizeof(wsdl__binding), 0, soap_copy_wsdl__binding);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int wsdl__binding::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_wsdl__binding);
	if (this->soap_out(soap, tag?tag:"wsdl:binding", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *wsdl__binding::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_wsdl__binding(soap, this, tag, type);
}

SOAP_FMAC3 wsdl__binding * SOAP_FMAC4 soap_get_wsdl__binding(struct soap *soap, wsdl__binding *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsdl__binding(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 wsdl__binding * SOAP_FMAC2 soap_instantiate_wsdl__binding(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsdl__binding(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsdl__binding, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(wsdl__binding);
		if (size)
			*size = sizeof(wsdl__binding);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(wsdl__binding[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(wsdl__binding);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (wsdl__binding*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsdl__binding(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying wsdl__binding %p -> %p\n", q, p));
	*(wsdl__binding*)p = *(wsdl__binding*)q;
}

void wsdl__binding_operation::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__NMTOKEN(soap, &this->wsdl__binding_operation::name);
	soap_default_xsd__string(soap, &this->wsdl__binding_operation::documentation);
	this->wsdl__binding_operation::wsp__Policy_ = NULL;
	this->wsdl__binding_operation::wsp__PolicyReference_ = NULL;
	this->wsdl__binding_operation::soap__operation_ = NULL;
	this->wsdl__binding_operation::http__operation_ = NULL;
	this->wsdl__binding_operation::input = NULL;
	this->wsdl__binding_operation::output = NULL;
	soap_default_std__vectorTemplateOfwsdl__ext_fault(soap, &this->wsdl__binding_operation::fault);
	this->wsdl__binding_operation::operationRef = NULL;
}

void wsdl__binding_operation::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &this->wsdl__binding_operation::documentation);
	soap_serialize_PointerTowsp__Policy(soap, &this->wsdl__binding_operation::wsp__Policy_);
	soap_serialize_PointerTowsp__PolicyReference(soap, &this->wsdl__binding_operation::wsp__PolicyReference_);
	soap_serialize_PointerTosoap__operation(soap, &this->wsdl__binding_operation::soap__operation_);
	soap_serialize_PointerTohttp__operation(soap, &this->wsdl__binding_operation::http__operation_);
	soap_serialize_PointerTowsdl__ext_input(soap, &this->wsdl__binding_operation::input);
	soap_serialize_PointerTowsdl__ext_output(soap, &this->wsdl__binding_operation::output);
	soap_serialize_std__vectorTemplateOfwsdl__ext_fault(soap, &this->wsdl__binding_operation::fault);
	/* non-serializable operationRef skipped */
	/* transient wsdl__binding_operation skipped */
	/* transient traverse skipped */
	/* transient operationPtr skipped */
	/* transient operationPtr skipped */
}

int wsdl__binding_operation::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_wsdl__binding_operation(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsdl__binding_operation(struct soap *soap, const char *tag, int id, const wsdl__binding_operation *a, const char *type)
{
	if (((wsdl__binding_operation*)a)->name)
		soap_set_attr(soap, "name", ((wsdl__binding_operation*)a)->name, 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsdl__binding_operation), type))
		return soap->error;
	if (soap_out_xsd__string(soap, "wsdl:documentation", -1, &(a->wsdl__binding_operation::documentation), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Policy(soap, "wsp:Policy", -1, &(a->wsdl__binding_operation::wsp__Policy_), ""))
		return soap->error;
	if (soap_out_PointerTowsp__PolicyReference(soap, "wsp:PolicyReference", -1, &(a->wsdl__binding_operation::wsp__PolicyReference_), ""))
		return soap->error;
	if (soap_out_PointerTosoap__operation(soap, "soap:operation", -1, &(a->wsdl__binding_operation::soap__operation_), ""))
		return soap->error;
	if (soap_out_PointerTohttp__operation(soap, "http:operation", -1, &(a->wsdl__binding_operation::http__operation_), ""))
		return soap->error;
	if (soap_out_PointerTowsdl__ext_input(soap, "wsdl:input", -1, &(a->wsdl__binding_operation::input), ""))
		return soap->error;
	if (soap_out_PointerTowsdl__ext_output(soap, "wsdl:output", -1, &(a->wsdl__binding_operation::output), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfwsdl__ext_fault(soap, "wsdl:fault", -1, &(a->wsdl__binding_operation::fault), ""))
		return soap->error;
	/* non-serializable operationRef skipped */
	/* transient wsdl__binding_operation skipped */
	/* transient traverse skipped */
	/* transient operationPtr skipped */
	/* transient operationPtr skipped */
	return soap_element_end_out(soap, tag);
}

void *wsdl__binding_operation::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_wsdl__binding_operation(soap, tag, this, type);
}

SOAP_FMAC3 wsdl__binding_operation * SOAP_FMAC4 soap_in_wsdl__binding_operation(struct soap *soap, const char *tag, wsdl__binding_operation *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (wsdl__binding_operation *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_wsdl__binding_operation, sizeof(wsdl__binding_operation), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_wsdl__binding_operation)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (wsdl__binding_operation *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "name", 0), &((wsdl__binding_operation*)a)->name, 0, -1))
		return NULL;
	size_t soap_flag_documentation1 = 1;
	size_t soap_flag_wsp__Policy_1 = 1;
	size_t soap_flag_wsp__PolicyReference_1 = 1;
	size_t soap_flag_soap__operation_1 = 1;
	size_t soap_flag_http__operation_1 = 1;
	size_t soap_flag_input1 = 1;
	size_t soap_flag_output1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_documentation1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "wsdl:documentation", &(a->wsdl__binding_operation::documentation), "xsd:string"))
				{	soap_flag_documentation1--;
					continue;
				}
			if (soap_flag_wsp__Policy_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Policy(soap, "wsp:Policy", &(a->wsdl__binding_operation::wsp__Policy_), "wsp:Policy"))
				{	soap_flag_wsp__Policy_1--;
					continue;
				}
			if (soap_flag_wsp__PolicyReference_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__PolicyReference(soap, "wsp:PolicyReference", &(a->wsdl__binding_operation::wsp__PolicyReference_), "wsp:PolicyReference"))
				{	soap_flag_wsp__PolicyReference_1--;
					continue;
				}
			if (soap_flag_soap__operation_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosoap__operation(soap, "soap:operation", &(a->wsdl__binding_operation::soap__operation_), "soap:operation"))
				{	soap_flag_soap__operation_1--;
					continue;
				}
			if (soap_flag_http__operation_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTohttp__operation(soap, "http:operation", &(a->wsdl__binding_operation::http__operation_), "http:operation"))
				{	soap_flag_http__operation_1--;
					continue;
				}
			if (soap_flag_input1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsdl__ext_input(soap, "wsdl:input", &(a->wsdl__binding_operation::input), "wsdl:ext-input"))
				{	soap_flag_input1--;
					continue;
				}
			if (soap_flag_output1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsdl__ext_output(soap, "wsdl:output", &(a->wsdl__binding_operation::output), "wsdl:ext-output"))
				{	soap_flag_output1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfwsdl__ext_fault(soap, "wsdl:fault", &(a->wsdl__binding_operation::fault), "wsdl:ext-fault"))
					continue;
			/* non-serializable operationRef skipped */
			/* transient wsdl__binding_operation skipped */
			/* transient traverse skipped */
			/* transient operationPtr skipped */
			/* transient operationPtr skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (wsdl__binding_operation *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsdl__binding_operation, 0, sizeof(wsdl__binding_operation), 0, soap_copy_wsdl__binding_operation);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int wsdl__binding_operation::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_wsdl__binding_operation);
	if (this->soap_out(soap, tag?tag:"wsdl:binding-operation", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *wsdl__binding_operation::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_wsdl__binding_operation(soap, this, tag, type);
}

SOAP_FMAC3 wsdl__binding_operation * SOAP_FMAC4 soap_get_wsdl__binding_operation(struct soap *soap, wsdl__binding_operation *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsdl__binding_operation(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 wsdl__binding_operation * SOAP_FMAC2 soap_instantiate_wsdl__binding_operation(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsdl__binding_operation(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsdl__binding_operation, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(wsdl__binding_operation);
		if (size)
			*size = sizeof(wsdl__binding_operation);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(wsdl__binding_operation[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(wsdl__binding_operation);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (wsdl__binding_operation*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsdl__binding_operation(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying wsdl__binding_operation %p -> %p\n", q, p));
	*(wsdl__binding_operation*)p = *(wsdl__binding_operation*)q;
}

void wsdl__ext_fault::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__NMTOKEN(soap, &this->wsdl__ext_fault::name);
	soap_default_xsd__string(soap, &this->wsdl__ext_fault::documentation);
	this->wsdl__ext_fault::wsp__Policy_ = NULL;
	this->wsdl__ext_fault::wsp__PolicyReference_ = NULL;
	this->wsdl__ext_fault::soap__fault_ = NULL;
	this->wsdl__ext_fault::messageRef = NULL;
}

void wsdl__ext_fault::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &this->wsdl__ext_fault::documentation);
	soap_serialize_PointerTowsp__Policy(soap, &this->wsdl__ext_fault::wsp__Policy_);
	soap_serialize_PointerTowsp__PolicyReference(soap, &this->wsdl__ext_fault::wsp__PolicyReference_);
	soap_serialize_PointerTosoap__fault(soap, &this->wsdl__ext_fault::soap__fault_);
	/* non-serializable messageRef skipped */
	/* transient wsdl__ext_fault skipped */
	/* transient traverse skipped */
	/* transient messagePtr skipped */
	/* transient messagePtr skipped */
}

int wsdl__ext_fault::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_wsdl__ext_fault(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsdl__ext_fault(struct soap *soap, const char *tag, int id, const wsdl__ext_fault *a, const char *type)
{
	if (((wsdl__ext_fault*)a)->name)
		soap_set_attr(soap, "name", ((wsdl__ext_fault*)a)->name, 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsdl__ext_fault), type))
		return soap->error;
	if (soap_out_xsd__string(soap, "wsdl:documentation", -1, &(a->wsdl__ext_fault::documentation), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Policy(soap, "wsp:Policy", -1, &(a->wsdl__ext_fault::wsp__Policy_), ""))
		return soap->error;
	if (soap_out_PointerTowsp__PolicyReference(soap, "wsp:PolicyReference", -1, &(a->wsdl__ext_fault::wsp__PolicyReference_), ""))
		return soap->error;
	if (soap_out_PointerTosoap__fault(soap, "soap:fault", -1, &(a->wsdl__ext_fault::soap__fault_), ""))
		return soap->error;
	/* non-serializable messageRef skipped */
	/* transient wsdl__ext_fault skipped */
	/* transient traverse skipped */
	/* transient messagePtr skipped */
	/* transient messagePtr skipped */
	return soap_element_end_out(soap, tag);
}

void *wsdl__ext_fault::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_wsdl__ext_fault(soap, tag, this, type);
}

SOAP_FMAC3 wsdl__ext_fault * SOAP_FMAC4 soap_in_wsdl__ext_fault(struct soap *soap, const char *tag, wsdl__ext_fault *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (wsdl__ext_fault *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_wsdl__ext_fault, sizeof(wsdl__ext_fault), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_wsdl__ext_fault)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (wsdl__ext_fault *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "name", 0), &((wsdl__ext_fault*)a)->name, 0, -1))
		return NULL;
	size_t soap_flag_documentation1 = 1;
	size_t soap_flag_wsp__Policy_1 = 1;
	size_t soap_flag_wsp__PolicyReference_1 = 1;
	size_t soap_flag_soap__fault_1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_documentation1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "wsdl:documentation", &(a->wsdl__ext_fault::documentation), "xsd:string"))
				{	soap_flag_documentation1--;
					continue;
				}
			if (soap_flag_wsp__Policy_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Policy(soap, "wsp:Policy", &(a->wsdl__ext_fault::wsp__Policy_), "wsp:Policy"))
				{	soap_flag_wsp__Policy_1--;
					continue;
				}
			if (soap_flag_wsp__PolicyReference_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__PolicyReference(soap, "wsp:PolicyReference", &(a->wsdl__ext_fault::wsp__PolicyReference_), "wsp:PolicyReference"))
				{	soap_flag_wsp__PolicyReference_1--;
					continue;
				}
			if (soap_flag_soap__fault_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosoap__fault(soap, "soap:fault", &(a->wsdl__ext_fault::soap__fault_), "soap:fault"))
				{	soap_flag_soap__fault_1--;
					continue;
				}
			/* non-serializable messageRef skipped */
			/* transient wsdl__ext_fault skipped */
			/* transient traverse skipped */
			/* transient messagePtr skipped */
			/* transient messagePtr skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (wsdl__ext_fault *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsdl__ext_fault, 0, sizeof(wsdl__ext_fault), 0, soap_copy_wsdl__ext_fault);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int wsdl__ext_fault::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_wsdl__ext_fault);
	if (this->soap_out(soap, tag?tag:"wsdl:ext-fault", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *wsdl__ext_fault::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_wsdl__ext_fault(soap, this, tag, type);
}

SOAP_FMAC3 wsdl__ext_fault * SOAP_FMAC4 soap_get_wsdl__ext_fault(struct soap *soap, wsdl__ext_fault *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsdl__ext_fault(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 wsdl__ext_fault * SOAP_FMAC2 soap_instantiate_wsdl__ext_fault(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsdl__ext_fault(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsdl__ext_fault, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(wsdl__ext_fault);
		if (size)
			*size = sizeof(wsdl__ext_fault);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(wsdl__ext_fault[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(wsdl__ext_fault);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (wsdl__ext_fault*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsdl__ext_fault(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying wsdl__ext_fault %p -> %p\n", q, p));
	*(wsdl__ext_fault*)p = *(wsdl__ext_fault*)q;
}

void wsdl__ext_output::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__NMTOKEN(soap, &this->wsdl__ext_output::name);
	soap_default_xsd__string(soap, &this->wsdl__ext_output::documentation);
	this->wsdl__ext_output::wsp__Policy_ = NULL;
	this->wsdl__ext_output::wsp__PolicyReference_ = NULL;
	this->wsdl__ext_output::dime__message_ = NULL;
	this->wsdl__ext_output::soap__body_ = NULL;
	soap_default_xsd__string(soap, &this->wsdl__ext_output::http__urlEncoded);
	this->wsdl__ext_output::mime__multipartRelated_ = NULL;
	this->wsdl__ext_output::mime__content_ = NULL;
	this->wsdl__ext_output::mime__mimeXml_ = NULL;
	soap_default_std__vectorTemplateOfsoap__header(soap, &this->wsdl__ext_output::soap__header_);
}

void wsdl__ext_output::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &this->wsdl__ext_output::documentation);
	soap_serialize_PointerTowsp__Policy(soap, &this->wsdl__ext_output::wsp__Policy_);
	soap_serialize_PointerTowsp__PolicyReference(soap, &this->wsdl__ext_output::wsp__PolicyReference_);
	soap_serialize_PointerTodime__message(soap, &this->wsdl__ext_output::dime__message_);
	soap_serialize_PointerTosoap__body(soap, &this->wsdl__ext_output::soap__body_);
	soap_serialize_xsd__string(soap, &this->wsdl__ext_output::http__urlEncoded);
	soap_serialize_PointerTomime__multipartRelated(soap, &this->wsdl__ext_output::mime__multipartRelated_);
	soap_serialize_PointerTomime__content(soap, &this->wsdl__ext_output::mime__content_);
	soap_serialize_PointerTomime__mimeXml(soap, &this->wsdl__ext_output::mime__mimeXml_);
	soap_serialize_std__vectorTemplateOfsoap__header(soap, &this->wsdl__ext_output::soap__header_);
	/* transient traverse skipped */
}

int wsdl__ext_output::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_wsdl__ext_output(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsdl__ext_output(struct soap *soap, const char *tag, int id, const wsdl__ext_output *a, const char *type)
{
	if (((wsdl__ext_output*)a)->name)
		soap_set_attr(soap, "name", ((wsdl__ext_output*)a)->name, 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsdl__ext_output), type))
		return soap->error;
	if (soap_out_xsd__string(soap, "wsdl:documentation", -1, &(a->wsdl__ext_output::documentation), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Policy(soap, "wsp:Policy", -1, &(a->wsdl__ext_output::wsp__Policy_), ""))
		return soap->error;
	if (soap_out_PointerTowsp__PolicyReference(soap, "wsp:PolicyReference", -1, &(a->wsdl__ext_output::wsp__PolicyReference_), ""))
		return soap->error;
	if (soap_out_PointerTodime__message(soap, "dime:message", -1, &(a->wsdl__ext_output::dime__message_), ""))
		return soap->error;
	if (soap_out_PointerTosoap__body(soap, "soap:body", -1, &(a->wsdl__ext_output::soap__body_), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "http:urlEncoded", -1, &(a->wsdl__ext_output::http__urlEncoded), ""))
		return soap->error;
	if (soap_out_PointerTomime__multipartRelated(soap, "mime:multipartRelated", -1, &(a->wsdl__ext_output::mime__multipartRelated_), ""))
		return soap->error;
	if (soap_out_PointerTomime__content(soap, "mime:content", -1, &(a->wsdl__ext_output::mime__content_), ""))
		return soap->error;
	if (soap_out_PointerTomime__mimeXml(soap, "mime:mimeXml", -1, &(a->wsdl__ext_output::mime__mimeXml_), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfsoap__header(soap, "soap:header", -1, &(a->wsdl__ext_output::soap__header_), ""))
		return soap->error;
	/* transient traverse skipped */
	return soap_element_end_out(soap, tag);
}

void *wsdl__ext_output::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_wsdl__ext_output(soap, tag, this, type);
}

SOAP_FMAC3 wsdl__ext_output * SOAP_FMAC4 soap_in_wsdl__ext_output(struct soap *soap, const char *tag, wsdl__ext_output *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (wsdl__ext_output *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_wsdl__ext_output, sizeof(wsdl__ext_output), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_wsdl__ext_output)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (wsdl__ext_output *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "name", 0), &((wsdl__ext_output*)a)->name, 0, -1))
		return NULL;
	size_t soap_flag_documentation1 = 1;
	size_t soap_flag_wsp__Policy_1 = 1;
	size_t soap_flag_wsp__PolicyReference_1 = 1;
	size_t soap_flag_dime__message_1 = 1;
	size_t soap_flag_soap__body_1 = 1;
	size_t soap_flag_http__urlEncoded1 = 1;
	size_t soap_flag_mime__multipartRelated_1 = 1;
	size_t soap_flag_mime__content_1 = 1;
	size_t soap_flag_mime__mimeXml_1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_documentation1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "wsdl:documentation", &(a->wsdl__ext_output::documentation), "xsd:string"))
				{	soap_flag_documentation1--;
					continue;
				}
			if (soap_flag_wsp__Policy_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Policy(soap, "wsp:Policy", &(a->wsdl__ext_output::wsp__Policy_), "wsp:Policy"))
				{	soap_flag_wsp__Policy_1--;
					continue;
				}
			if (soap_flag_wsp__PolicyReference_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__PolicyReference(soap, "wsp:PolicyReference", &(a->wsdl__ext_output::wsp__PolicyReference_), "wsp:PolicyReference"))
				{	soap_flag_wsp__PolicyReference_1--;
					continue;
				}
			if (soap_flag_dime__message_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTodime__message(soap, "dime:message", &(a->wsdl__ext_output::dime__message_), "dime:message"))
				{	soap_flag_dime__message_1--;
					continue;
				}
			if (soap_flag_soap__body_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosoap__body(soap, "soap:body", &(a->wsdl__ext_output::soap__body_), "soap:body"))
				{	soap_flag_soap__body_1--;
					continue;
				}
			if (soap_flag_http__urlEncoded1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "http:urlEncoded", &(a->wsdl__ext_output::http__urlEncoded), "xsd:string"))
				{	soap_flag_http__urlEncoded1--;
					continue;
				}
			if (soap_flag_mime__multipartRelated_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTomime__multipartRelated(soap, "mime:multipartRelated", &(a->wsdl__ext_output::mime__multipartRelated_), "mime:multipartRelated"))
				{	soap_flag_mime__multipartRelated_1--;
					continue;
				}
			if (soap_flag_mime__content_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTomime__content(soap, "mime:content", &(a->wsdl__ext_output::mime__content_), "mime:content"))
				{	soap_flag_mime__content_1--;
					continue;
				}
			if (soap_flag_mime__mimeXml_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTomime__mimeXml(soap, "mime:mimeXml", &(a->wsdl__ext_output::mime__mimeXml_), "mime:mimeXml"))
				{	soap_flag_mime__mimeXml_1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfsoap__header(soap, "soap:header", &(a->wsdl__ext_output::soap__header_), "soap:header"))
					continue;
			/* transient traverse skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (wsdl__ext_output *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsdl__ext_output, 0, sizeof(wsdl__ext_output), 0, soap_copy_wsdl__ext_output);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int wsdl__ext_output::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_wsdl__ext_output);
	if (this->soap_out(soap, tag?tag:"wsdl:ext-output", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *wsdl__ext_output::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_wsdl__ext_output(soap, this, tag, type);
}

SOAP_FMAC3 wsdl__ext_output * SOAP_FMAC4 soap_get_wsdl__ext_output(struct soap *soap, wsdl__ext_output *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsdl__ext_output(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 wsdl__ext_output * SOAP_FMAC2 soap_instantiate_wsdl__ext_output(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsdl__ext_output(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsdl__ext_output, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(wsdl__ext_output);
		if (size)
			*size = sizeof(wsdl__ext_output);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(wsdl__ext_output[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(wsdl__ext_output);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (wsdl__ext_output*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsdl__ext_output(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying wsdl__ext_output %p -> %p\n", q, p));
	*(wsdl__ext_output*)p = *(wsdl__ext_output*)q;
}

void wsdl__ext_input::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__NMTOKEN(soap, &this->wsdl__ext_input::name);
	soap_default_xsd__string(soap, &this->wsdl__ext_input::documentation);
	this->wsdl__ext_input::wsp__Policy_ = NULL;
	this->wsdl__ext_input::wsp__PolicyReference_ = NULL;
	this->wsdl__ext_input::dime__message_ = NULL;
	this->wsdl__ext_input::soap__body_ = NULL;
	soap_default_xsd__string(soap, &this->wsdl__ext_input::http__urlEncoded);
	this->wsdl__ext_input::mime__multipartRelated_ = NULL;
	this->wsdl__ext_input::mime__content_ = NULL;
	this->wsdl__ext_input::mime__mimeXml_ = NULL;
	soap_default_std__vectorTemplateOfsoap__header(soap, &this->wsdl__ext_input::soap__header_);
}

void wsdl__ext_input::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &this->wsdl__ext_input::documentation);
	soap_serialize_PointerTowsp__Policy(soap, &this->wsdl__ext_input::wsp__Policy_);
	soap_serialize_PointerTowsp__PolicyReference(soap, &this->wsdl__ext_input::wsp__PolicyReference_);
	soap_serialize_PointerTodime__message(soap, &this->wsdl__ext_input::dime__message_);
	soap_serialize_PointerTosoap__body(soap, &this->wsdl__ext_input::soap__body_);
	soap_serialize_xsd__string(soap, &this->wsdl__ext_input::http__urlEncoded);
	soap_serialize_PointerTomime__multipartRelated(soap, &this->wsdl__ext_input::mime__multipartRelated_);
	soap_serialize_PointerTomime__content(soap, &this->wsdl__ext_input::mime__content_);
	soap_serialize_PointerTomime__mimeXml(soap, &this->wsdl__ext_input::mime__mimeXml_);
	soap_serialize_std__vectorTemplateOfsoap__header(soap, &this->wsdl__ext_input::soap__header_);
	/* transient traverse skipped */
}

int wsdl__ext_input::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_wsdl__ext_input(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsdl__ext_input(struct soap *soap, const char *tag, int id, const wsdl__ext_input *a, const char *type)
{
	if (((wsdl__ext_input*)a)->name)
		soap_set_attr(soap, "name", ((wsdl__ext_input*)a)->name, 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsdl__ext_input), type))
		return soap->error;
	if (soap_out_xsd__string(soap, "wsdl:documentation", -1, &(a->wsdl__ext_input::documentation), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Policy(soap, "wsp:Policy", -1, &(a->wsdl__ext_input::wsp__Policy_), ""))
		return soap->error;
	if (soap_out_PointerTowsp__PolicyReference(soap, "wsp:PolicyReference", -1, &(a->wsdl__ext_input::wsp__PolicyReference_), ""))
		return soap->error;
	if (soap_out_PointerTodime__message(soap, "dime:message", -1, &(a->wsdl__ext_input::dime__message_), ""))
		return soap->error;
	if (soap_out_PointerTosoap__body(soap, "soap:body", -1, &(a->wsdl__ext_input::soap__body_), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "http:urlEncoded", -1, &(a->wsdl__ext_input::http__urlEncoded), ""))
		return soap->error;
	if (soap_out_PointerTomime__multipartRelated(soap, "mime:multipartRelated", -1, &(a->wsdl__ext_input::mime__multipartRelated_), ""))
		return soap->error;
	if (soap_out_PointerTomime__content(soap, "mime:content", -1, &(a->wsdl__ext_input::mime__content_), ""))
		return soap->error;
	if (soap_out_PointerTomime__mimeXml(soap, "mime:mimeXml", -1, &(a->wsdl__ext_input::mime__mimeXml_), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfsoap__header(soap, "soap:header", -1, &(a->wsdl__ext_input::soap__header_), ""))
		return soap->error;
	/* transient traverse skipped */
	return soap_element_end_out(soap, tag);
}

void *wsdl__ext_input::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_wsdl__ext_input(soap, tag, this, type);
}

SOAP_FMAC3 wsdl__ext_input * SOAP_FMAC4 soap_in_wsdl__ext_input(struct soap *soap, const char *tag, wsdl__ext_input *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (wsdl__ext_input *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_wsdl__ext_input, sizeof(wsdl__ext_input), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_wsdl__ext_input)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (wsdl__ext_input *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "name", 0), &((wsdl__ext_input*)a)->name, 0, -1))
		return NULL;
	size_t soap_flag_documentation1 = 1;
	size_t soap_flag_wsp__Policy_1 = 1;
	size_t soap_flag_wsp__PolicyReference_1 = 1;
	size_t soap_flag_dime__message_1 = 1;
	size_t soap_flag_soap__body_1 = 1;
	size_t soap_flag_http__urlEncoded1 = 1;
	size_t soap_flag_mime__multipartRelated_1 = 1;
	size_t soap_flag_mime__content_1 = 1;
	size_t soap_flag_mime__mimeXml_1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_documentation1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "wsdl:documentation", &(a->wsdl__ext_input::documentation), "xsd:string"))
				{	soap_flag_documentation1--;
					continue;
				}
			if (soap_flag_wsp__Policy_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Policy(soap, "wsp:Policy", &(a->wsdl__ext_input::wsp__Policy_), "wsp:Policy"))
				{	soap_flag_wsp__Policy_1--;
					continue;
				}
			if (soap_flag_wsp__PolicyReference_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__PolicyReference(soap, "wsp:PolicyReference", &(a->wsdl__ext_input::wsp__PolicyReference_), "wsp:PolicyReference"))
				{	soap_flag_wsp__PolicyReference_1--;
					continue;
				}
			if (soap_flag_dime__message_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTodime__message(soap, "dime:message", &(a->wsdl__ext_input::dime__message_), "dime:message"))
				{	soap_flag_dime__message_1--;
					continue;
				}
			if (soap_flag_soap__body_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosoap__body(soap, "soap:body", &(a->wsdl__ext_input::soap__body_), "soap:body"))
				{	soap_flag_soap__body_1--;
					continue;
				}
			if (soap_flag_http__urlEncoded1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "http:urlEncoded", &(a->wsdl__ext_input::http__urlEncoded), "xsd:string"))
				{	soap_flag_http__urlEncoded1--;
					continue;
				}
			if (soap_flag_mime__multipartRelated_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTomime__multipartRelated(soap, "mime:multipartRelated", &(a->wsdl__ext_input::mime__multipartRelated_), "mime:multipartRelated"))
				{	soap_flag_mime__multipartRelated_1--;
					continue;
				}
			if (soap_flag_mime__content_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTomime__content(soap, "mime:content", &(a->wsdl__ext_input::mime__content_), "mime:content"))
				{	soap_flag_mime__content_1--;
					continue;
				}
			if (soap_flag_mime__mimeXml_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTomime__mimeXml(soap, "mime:mimeXml", &(a->wsdl__ext_input::mime__mimeXml_), "mime:mimeXml"))
				{	soap_flag_mime__mimeXml_1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfsoap__header(soap, "soap:header", &(a->wsdl__ext_input::soap__header_), "soap:header"))
					continue;
			/* transient traverse skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (wsdl__ext_input *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsdl__ext_input, 0, sizeof(wsdl__ext_input), 0, soap_copy_wsdl__ext_input);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int wsdl__ext_input::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_wsdl__ext_input);
	if (this->soap_out(soap, tag?tag:"wsdl:ext-input", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *wsdl__ext_input::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_wsdl__ext_input(soap, this, tag, type);
}

SOAP_FMAC3 wsdl__ext_input * SOAP_FMAC4 soap_get_wsdl__ext_input(struct soap *soap, wsdl__ext_input *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsdl__ext_input(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 wsdl__ext_input * SOAP_FMAC2 soap_instantiate_wsdl__ext_input(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsdl__ext_input(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsdl__ext_input, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(wsdl__ext_input);
		if (size)
			*size = sizeof(wsdl__ext_input);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(wsdl__ext_input[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(wsdl__ext_input);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (wsdl__ext_input*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsdl__ext_input(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying wsdl__ext_input %p -> %p\n", q, p));
	*(wsdl__ext_input*)p = *(wsdl__ext_input*)q;
}

void wsdl__portType::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__NMTOKEN(soap, &this->wsdl__portType::name);
	soap_default_xsd__string(soap, &this->wsdl__portType::documentation);
	this->wsdl__portType::wsp__Policy_ = NULL;
	this->wsdl__portType::wsp__PolicyReference_ = NULL;
	soap_default_std__vectorTemplateOfwsdl__operation(soap, &this->wsdl__portType::operation);
}

void wsdl__portType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &this->wsdl__portType::documentation);
	soap_serialize_PointerTowsp__Policy(soap, &this->wsdl__portType::wsp__Policy_);
	soap_serialize_PointerTowsp__PolicyReference(soap, &this->wsdl__portType::wsp__PolicyReference_);
	soap_serialize_std__vectorTemplateOfwsdl__operation(soap, &this->wsdl__portType::operation);
	/* transient traverse skipped */
}

int wsdl__portType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_wsdl__portType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsdl__portType(struct soap *soap, const char *tag, int id, const wsdl__portType *a, const char *type)
{
	if (((wsdl__portType*)a)->name)
		soap_set_attr(soap, "name", ((wsdl__portType*)a)->name, 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsdl__portType), type))
		return soap->error;
	if (soap_out_xsd__string(soap, "wsdl:documentation", -1, &(a->wsdl__portType::documentation), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Policy(soap, "wsp:Policy", -1, &(a->wsdl__portType::wsp__Policy_), ""))
		return soap->error;
	if (soap_out_PointerTowsp__PolicyReference(soap, "wsp:PolicyReference", -1, &(a->wsdl__portType::wsp__PolicyReference_), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfwsdl__operation(soap, "wsdl:operation", -1, &(a->wsdl__portType::operation), ""))
		return soap->error;
	/* transient traverse skipped */
	return soap_element_end_out(soap, tag);
}

void *wsdl__portType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_wsdl__portType(soap, tag, this, type);
}

SOAP_FMAC3 wsdl__portType * SOAP_FMAC4 soap_in_wsdl__portType(struct soap *soap, const char *tag, wsdl__portType *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (wsdl__portType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_wsdl__portType, sizeof(wsdl__portType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_wsdl__portType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (wsdl__portType *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "name", 0), &((wsdl__portType*)a)->name, 0, -1))
		return NULL;
	size_t soap_flag_documentation1 = 1;
	size_t soap_flag_wsp__Policy_1 = 1;
	size_t soap_flag_wsp__PolicyReference_1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_documentation1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "wsdl:documentation", &(a->wsdl__portType::documentation), "xsd:string"))
				{	soap_flag_documentation1--;
					continue;
				}
			if (soap_flag_wsp__Policy_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Policy(soap, "wsp:Policy", &(a->wsdl__portType::wsp__Policy_), "wsp:Policy"))
				{	soap_flag_wsp__Policy_1--;
					continue;
				}
			if (soap_flag_wsp__PolicyReference_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__PolicyReference(soap, "wsp:PolicyReference", &(a->wsdl__portType::wsp__PolicyReference_), "wsp:PolicyReference"))
				{	soap_flag_wsp__PolicyReference_1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfwsdl__operation(soap, "wsdl:operation", &(a->wsdl__portType::operation), "wsdl:operation"))
					continue;
			/* transient traverse skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (wsdl__portType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsdl__portType, 0, sizeof(wsdl__portType), 0, soap_copy_wsdl__portType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int wsdl__portType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_wsdl__portType);
	if (this->soap_out(soap, tag?tag:"wsdl:portType", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *wsdl__portType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_wsdl__portType(soap, this, tag, type);
}

SOAP_FMAC3 wsdl__portType * SOAP_FMAC4 soap_get_wsdl__portType(struct soap *soap, wsdl__portType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsdl__portType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 wsdl__portType * SOAP_FMAC2 soap_instantiate_wsdl__portType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsdl__portType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsdl__portType, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(wsdl__portType);
		if (size)
			*size = sizeof(wsdl__portType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(wsdl__portType[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(wsdl__portType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (wsdl__portType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsdl__portType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying wsdl__portType %p -> %p\n", q, p));
	*(wsdl__portType*)p = *(wsdl__portType*)q;
}

void wsdl__fault::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__NMTOKEN(soap, &this->wsdl__fault::name);
	soap_default_xsd__QName(soap, &this->wsdl__fault::message);
	soap_default_xsd__anyURI(soap, &this->wsdl__fault::wsam__Action);
	soap_default_xsd__string(soap, &this->wsdl__fault::documentation);
	this->wsdl__fault::wsp__Policy_ = NULL;
	this->wsdl__fault::wsp__PolicyReference_ = NULL;
	this->wsdl__fault::messageRef = NULL;
}

void wsdl__fault::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &this->wsdl__fault::documentation);
	soap_serialize_PointerTowsp__Policy(soap, &this->wsdl__fault::wsp__Policy_);
	soap_serialize_PointerTowsp__PolicyReference(soap, &this->wsdl__fault::wsp__PolicyReference_);
	/* non-serializable messageRef skipped */
	/* transient wsdl__fault skipped */
	/* transient traverse skipped */
	/* transient messagePtr skipped */
	/* transient messagePtr skipped */
}

int wsdl__fault::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_wsdl__fault(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsdl__fault(struct soap *soap, const char *tag, int id, const wsdl__fault *a, const char *type)
{
	if (((wsdl__fault*)a)->name)
		soap_set_attr(soap, "name", ((wsdl__fault*)a)->name, 1);
	if (((wsdl__fault*)a)->message)
		soap_set_attr(soap, "message", soap_QName2s(soap, ((wsdl__fault*)a)->message), 1);
	if (((wsdl__fault*)a)->wsam__Action)
		soap_set_attr(soap, "wsam:Action", ((wsdl__fault*)a)->wsam__Action, 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsdl__fault), type))
		return soap->error;
	if (soap_out_xsd__string(soap, "wsdl:documentation", -1, &(a->wsdl__fault::documentation), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Policy(soap, "wsp:Policy", -1, &(a->wsdl__fault::wsp__Policy_), ""))
		return soap->error;
	if (soap_out_PointerTowsp__PolicyReference(soap, "wsp:PolicyReference", -1, &(a->wsdl__fault::wsp__PolicyReference_), ""))
		return soap->error;
	/* non-serializable messageRef skipped */
	/* transient wsdl__fault skipped */
	/* transient traverse skipped */
	/* transient messagePtr skipped */
	/* transient messagePtr skipped */
	return soap_element_end_out(soap, tag);
}

void *wsdl__fault::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_wsdl__fault(soap, tag, this, type);
}

SOAP_FMAC3 wsdl__fault * SOAP_FMAC4 soap_in_wsdl__fault(struct soap *soap, const char *tag, wsdl__fault *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (wsdl__fault *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_wsdl__fault, sizeof(wsdl__fault), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_wsdl__fault)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (wsdl__fault *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "name", 0), &((wsdl__fault*)a)->name, 0, -1))
		return NULL;
	if (soap_s2QName(soap, soap_attr_value(soap, "message", 0), &((wsdl__fault*)a)->message, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "wsam:Action", 0), &((wsdl__fault*)a)->wsam__Action, 0, -1))
		return NULL;
	size_t soap_flag_documentation1 = 1;
	size_t soap_flag_wsp__Policy_1 = 1;
	size_t soap_flag_wsp__PolicyReference_1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_documentation1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "wsdl:documentation", &(a->wsdl__fault::documentation), "xsd:string"))
				{	soap_flag_documentation1--;
					continue;
				}
			if (soap_flag_wsp__Policy_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Policy(soap, "wsp:Policy", &(a->wsdl__fault::wsp__Policy_), "wsp:Policy"))
				{	soap_flag_wsp__Policy_1--;
					continue;
				}
			if (soap_flag_wsp__PolicyReference_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__PolicyReference(soap, "wsp:PolicyReference", &(a->wsdl__fault::wsp__PolicyReference_), "wsp:PolicyReference"))
				{	soap_flag_wsp__PolicyReference_1--;
					continue;
				}
			/* non-serializable messageRef skipped */
			/* transient wsdl__fault skipped */
			/* transient traverse skipped */
			/* transient messagePtr skipped */
			/* transient messagePtr skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (wsdl__fault *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsdl__fault, 0, sizeof(wsdl__fault), 0, soap_copy_wsdl__fault);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int wsdl__fault::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_wsdl__fault);
	if (this->soap_out(soap, tag?tag:"wsdl:fault", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *wsdl__fault::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_wsdl__fault(soap, this, tag, type);
}

SOAP_FMAC3 wsdl__fault * SOAP_FMAC4 soap_get_wsdl__fault(struct soap *soap, wsdl__fault *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsdl__fault(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 wsdl__fault * SOAP_FMAC2 soap_instantiate_wsdl__fault(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsdl__fault(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsdl__fault, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(wsdl__fault);
		if (size)
			*size = sizeof(wsdl__fault);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(wsdl__fault[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(wsdl__fault);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (wsdl__fault*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsdl__fault(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying wsdl__fault %p -> %p\n", q, p));
	*(wsdl__fault*)p = *(wsdl__fault*)q;
}

void wsdl__output::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__NMTOKEN(soap, &this->wsdl__output::name);
	soap_default_xsd__QName(soap, &this->wsdl__output::message);
	soap_default_xsd__anyURI(soap, &this->wsdl__output::wsam__Action);
	soap_default_xsd__string(soap, &this->wsdl__output::documentation);
	this->wsdl__output::wsp__Policy_ = NULL;
	this->wsdl__output::wsp__PolicyReference_ = NULL;
	this->wsdl__output::messageRef = NULL;
}

void wsdl__output::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &this->wsdl__output::documentation);
	soap_serialize_PointerTowsp__Policy(soap, &this->wsdl__output::wsp__Policy_);
	soap_serialize_PointerTowsp__PolicyReference(soap, &this->wsdl__output::wsp__PolicyReference_);
	/* non-serializable messageRef skipped */
	/* transient wsdl__output skipped */
	/* transient traverse skipped */
	/* transient messagePtr skipped */
	/* transient messagePtr skipped */
}

int wsdl__output::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_wsdl__output(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsdl__output(struct soap *soap, const char *tag, int id, const wsdl__output *a, const char *type)
{
	if (((wsdl__output*)a)->name)
		soap_set_attr(soap, "name", ((wsdl__output*)a)->name, 1);
	if (((wsdl__output*)a)->message)
		soap_set_attr(soap, "message", soap_QName2s(soap, ((wsdl__output*)a)->message), 1);
	if (((wsdl__output*)a)->wsam__Action)
		soap_set_attr(soap, "wsam:Action", ((wsdl__output*)a)->wsam__Action, 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsdl__output), type))
		return soap->error;
	if (soap_out_xsd__string(soap, "wsdl:documentation", -1, &(a->wsdl__output::documentation), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Policy(soap, "wsp:Policy", -1, &(a->wsdl__output::wsp__Policy_), ""))
		return soap->error;
	if (soap_out_PointerTowsp__PolicyReference(soap, "wsp:PolicyReference", -1, &(a->wsdl__output::wsp__PolicyReference_), ""))
		return soap->error;
	/* non-serializable messageRef skipped */
	/* transient wsdl__output skipped */
	/* transient traverse skipped */
	/* transient messagePtr skipped */
	/* transient messagePtr skipped */
	return soap_element_end_out(soap, tag);
}

void *wsdl__output::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_wsdl__output(soap, tag, this, type);
}

SOAP_FMAC3 wsdl__output * SOAP_FMAC4 soap_in_wsdl__output(struct soap *soap, const char *tag, wsdl__output *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (wsdl__output *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_wsdl__output, sizeof(wsdl__output), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_wsdl__output)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (wsdl__output *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "name", 0), &((wsdl__output*)a)->name, 0, -1))
		return NULL;
	if (soap_s2QName(soap, soap_attr_value(soap, "message", 0), &((wsdl__output*)a)->message, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "wsam:Action", 0), &((wsdl__output*)a)->wsam__Action, 0, -1))
		return NULL;
	size_t soap_flag_documentation1 = 1;
	size_t soap_flag_wsp__Policy_1 = 1;
	size_t soap_flag_wsp__PolicyReference_1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_documentation1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "wsdl:documentation", &(a->wsdl__output::documentation), "xsd:string"))
				{	soap_flag_documentation1--;
					continue;
				}
			if (soap_flag_wsp__Policy_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Policy(soap, "wsp:Policy", &(a->wsdl__output::wsp__Policy_), "wsp:Policy"))
				{	soap_flag_wsp__Policy_1--;
					continue;
				}
			if (soap_flag_wsp__PolicyReference_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__PolicyReference(soap, "wsp:PolicyReference", &(a->wsdl__output::wsp__PolicyReference_), "wsp:PolicyReference"))
				{	soap_flag_wsp__PolicyReference_1--;
					continue;
				}
			/* non-serializable messageRef skipped */
			/* transient wsdl__output skipped */
			/* transient traverse skipped */
			/* transient messagePtr skipped */
			/* transient messagePtr skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (wsdl__output *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsdl__output, 0, sizeof(wsdl__output), 0, soap_copy_wsdl__output);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int wsdl__output::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_wsdl__output);
	if (this->soap_out(soap, tag?tag:"wsdl:output", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *wsdl__output::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_wsdl__output(soap, this, tag, type);
}

SOAP_FMAC3 wsdl__output * SOAP_FMAC4 soap_get_wsdl__output(struct soap *soap, wsdl__output *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsdl__output(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 wsdl__output * SOAP_FMAC2 soap_instantiate_wsdl__output(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsdl__output(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsdl__output, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(wsdl__output);
		if (size)
			*size = sizeof(wsdl__output);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(wsdl__output[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(wsdl__output);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (wsdl__output*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsdl__output(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying wsdl__output %p -> %p\n", q, p));
	*(wsdl__output*)p = *(wsdl__output*)q;
}

void wsdl__input::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__NMTOKEN(soap, &this->wsdl__input::name);
	soap_default_xsd__QName(soap, &this->wsdl__input::message);
	soap_default_xsd__anyURI(soap, &this->wsdl__input::wsam__Action);
	soap_default_xsd__string(soap, &this->wsdl__input::documentation);
	this->wsdl__input::wsp__Policy_ = NULL;
	this->wsdl__input::wsp__PolicyReference_ = NULL;
	this->wsdl__input::messageRef = NULL;
}

void wsdl__input::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &this->wsdl__input::documentation);
	soap_serialize_PointerTowsp__Policy(soap, &this->wsdl__input::wsp__Policy_);
	soap_serialize_PointerTowsp__PolicyReference(soap, &this->wsdl__input::wsp__PolicyReference_);
	/* non-serializable messageRef skipped */
	/* transient wsdl__input skipped */
	/* transient traverse skipped */
	/* transient messagePtr skipped */
	/* transient messagePtr skipped */
}

int wsdl__input::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_wsdl__input(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsdl__input(struct soap *soap, const char *tag, int id, const wsdl__input *a, const char *type)
{
	if (((wsdl__input*)a)->name)
		soap_set_attr(soap, "name", ((wsdl__input*)a)->name, 1);
	if (((wsdl__input*)a)->message)
		soap_set_attr(soap, "message", soap_QName2s(soap, ((wsdl__input*)a)->message), 1);
	if (((wsdl__input*)a)->wsam__Action)
		soap_set_attr(soap, "wsam:Action", ((wsdl__input*)a)->wsam__Action, 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsdl__input), type))
		return soap->error;
	if (soap_out_xsd__string(soap, "wsdl:documentation", -1, &(a->wsdl__input::documentation), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Policy(soap, "wsp:Policy", -1, &(a->wsdl__input::wsp__Policy_), ""))
		return soap->error;
	if (soap_out_PointerTowsp__PolicyReference(soap, "wsp:PolicyReference", -1, &(a->wsdl__input::wsp__PolicyReference_), ""))
		return soap->error;
	/* non-serializable messageRef skipped */
	/* transient wsdl__input skipped */
	/* transient traverse skipped */
	/* transient messagePtr skipped */
	/* transient messagePtr skipped */
	return soap_element_end_out(soap, tag);
}

void *wsdl__input::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_wsdl__input(soap, tag, this, type);
}

SOAP_FMAC3 wsdl__input * SOAP_FMAC4 soap_in_wsdl__input(struct soap *soap, const char *tag, wsdl__input *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (wsdl__input *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_wsdl__input, sizeof(wsdl__input), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_wsdl__input)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (wsdl__input *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "name", 0), &((wsdl__input*)a)->name, 0, -1))
		return NULL;
	if (soap_s2QName(soap, soap_attr_value(soap, "message", 0), &((wsdl__input*)a)->message, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "wsam:Action", 0), &((wsdl__input*)a)->wsam__Action, 0, -1))
		return NULL;
	size_t soap_flag_documentation1 = 1;
	size_t soap_flag_wsp__Policy_1 = 1;
	size_t soap_flag_wsp__PolicyReference_1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_documentation1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "wsdl:documentation", &(a->wsdl__input::documentation), "xsd:string"))
				{	soap_flag_documentation1--;
					continue;
				}
			if (soap_flag_wsp__Policy_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Policy(soap, "wsp:Policy", &(a->wsdl__input::wsp__Policy_), "wsp:Policy"))
				{	soap_flag_wsp__Policy_1--;
					continue;
				}
			if (soap_flag_wsp__PolicyReference_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__PolicyReference(soap, "wsp:PolicyReference", &(a->wsdl__input::wsp__PolicyReference_), "wsp:PolicyReference"))
				{	soap_flag_wsp__PolicyReference_1--;
					continue;
				}
			/* non-serializable messageRef skipped */
			/* transient wsdl__input skipped */
			/* transient traverse skipped */
			/* transient messagePtr skipped */
			/* transient messagePtr skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (wsdl__input *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsdl__input, 0, sizeof(wsdl__input), 0, soap_copy_wsdl__input);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int wsdl__input::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_wsdl__input);
	if (this->soap_out(soap, tag?tag:"wsdl:input", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *wsdl__input::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_wsdl__input(soap, this, tag, type);
}

SOAP_FMAC3 wsdl__input * SOAP_FMAC4 soap_get_wsdl__input(struct soap *soap, wsdl__input *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsdl__input(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 wsdl__input * SOAP_FMAC2 soap_instantiate_wsdl__input(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsdl__input(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsdl__input, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(wsdl__input);
		if (size)
			*size = sizeof(wsdl__input);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(wsdl__input[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(wsdl__input);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (wsdl__input*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsdl__input(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying wsdl__input %p -> %p\n", q, p));
	*(wsdl__input*)p = *(wsdl__input*)q;
}

void wsdl__types::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &this->wsdl__types::documentation);
	soap_default_std__vectorTemplateOfPointerToxs__schema(soap, &this->wsdl__types::xs__schema_);
}

void wsdl__types::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &this->wsdl__types::documentation);
	soap_serialize_std__vectorTemplateOfPointerToxs__schema(soap, &this->wsdl__types::xs__schema_);
	/* transient preprocess skipped */
	/* transient traverse skipped */
}

int wsdl__types::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_wsdl__types(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsdl__types(struct soap *soap, const char *tag, int id, const wsdl__types *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsdl__types), type))
		return soap->error;
	if (soap_out_xsd__string(soap, "wsdl:documentation", -1, &(a->wsdl__types::documentation), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfPointerToxs__schema(soap, "xs:schema", -1, &(a->wsdl__types::xs__schema_), ""))
		return soap->error;
	/* transient preprocess skipped */
	/* transient traverse skipped */
	return soap_element_end_out(soap, tag);
}

void *wsdl__types::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_wsdl__types(soap, tag, this, type);
}

SOAP_FMAC3 wsdl__types * SOAP_FMAC4 soap_in_wsdl__types(struct soap *soap, const char *tag, wsdl__types *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (wsdl__types *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_wsdl__types, sizeof(wsdl__types), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_wsdl__types)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (wsdl__types *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_documentation1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_documentation1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "wsdl:documentation", &(a->wsdl__types::documentation), "xsd:string"))
				{	soap_flag_documentation1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerToxs__schema(soap, "xs:schema", &(a->wsdl__types::xs__schema_), "xs:schema"))
					continue;
			/* transient preprocess skipped */
			/* transient traverse skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (wsdl__types *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsdl__types, 0, sizeof(wsdl__types), 0, soap_copy_wsdl__types);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int wsdl__types::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_wsdl__types);
	if (this->soap_out(soap, tag?tag:"wsdl:types", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *wsdl__types::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_wsdl__types(soap, this, tag, type);
}

SOAP_FMAC3 wsdl__types * SOAP_FMAC4 soap_get_wsdl__types(struct soap *soap, wsdl__types *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsdl__types(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 wsdl__types * SOAP_FMAC2 soap_instantiate_wsdl__types(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsdl__types(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsdl__types, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(wsdl__types);
		if (size)
			*size = sizeof(wsdl__types);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(wsdl__types[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(wsdl__types);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (wsdl__types*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsdl__types(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying wsdl__types %p -> %p\n", q, p));
	*(wsdl__types*)p = *(wsdl__types*)q;
}

void wsdl__import::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__anyURI(soap, &this->wsdl__import::namespace_);
	soap_default_xsd__anyURI(soap, &this->wsdl__import::location);
	this->wsdl__import::definitionsRef = NULL;
}

void wsdl__import::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	/* non-serializable definitionsRef skipped */
	/* transient wsdl__import skipped */
	/* transient preprocess skipped */
	/* transient traverse skipped */
	/* transient definitionsPtr skipped */
	/* transient definitionsPtr skipped */
}

int wsdl__import::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_wsdl__import(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsdl__import(struct soap *soap, const char *tag, int id, const wsdl__import *a, const char *type)
{
	if (((wsdl__import*)a)->namespace_)
		soap_set_attr(soap, "namespace", ((wsdl__import*)a)->namespace_, 1);
	if (((wsdl__import*)a)->location)
		soap_set_attr(soap, "location", ((wsdl__import*)a)->location, 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsdl__import), type))
		return soap->error;
	/* non-serializable definitionsRef skipped */
	/* transient wsdl__import skipped */
	/* transient preprocess skipped */
	/* transient traverse skipped */
	/* transient definitionsPtr skipped */
	/* transient definitionsPtr skipped */
	return soap_element_end_out(soap, tag);
}

void *wsdl__import::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_wsdl__import(soap, tag, this, type);
}

SOAP_FMAC3 wsdl__import * SOAP_FMAC4 soap_in_wsdl__import(struct soap *soap, const char *tag, wsdl__import *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (wsdl__import *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_wsdl__import, sizeof(wsdl__import), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_wsdl__import)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (wsdl__import *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "namespace", 0), &((wsdl__import*)a)->namespace_, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "location", 0), &((wsdl__import*)a)->location, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			/* non-serializable definitionsRef skipped */
			/* transient wsdl__import skipped */
			/* transient preprocess skipped */
			/* transient traverse skipped */
			/* transient definitionsPtr skipped */
			/* transient definitionsPtr skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (wsdl__import *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsdl__import, 0, sizeof(wsdl__import), 0, soap_copy_wsdl__import);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int wsdl__import::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_wsdl__import);
	if (this->soap_out(soap, tag?tag:"wsdl:import", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *wsdl__import::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_wsdl__import(soap, this, tag, type);
}

SOAP_FMAC3 wsdl__import * SOAP_FMAC4 soap_get_wsdl__import(struct soap *soap, wsdl__import *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsdl__import(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 wsdl__import * SOAP_FMAC2 soap_instantiate_wsdl__import(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsdl__import(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsdl__import, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(wsdl__import);
		if (size)
			*size = sizeof(wsdl__import);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(wsdl__import[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(wsdl__import);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (wsdl__import*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsdl__import(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying wsdl__import %p -> %p\n", q, p));
	*(wsdl__import*)p = *(wsdl__import*)q;
}

void wsp__PolicyAttachment::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	this->wsp__PolicyAttachment::AppliesTo = NULL;
	soap_default_std__vectorTemplateOfwsp__Attachment(soap, &this->wsp__PolicyAttachment::Attachment);
}

void wsp__PolicyAttachment::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTowsp__AppliesTo(soap, &this->wsp__PolicyAttachment::AppliesTo);
	soap_serialize_std__vectorTemplateOfwsp__Attachment(soap, &this->wsp__PolicyAttachment::Attachment);
}

int wsp__PolicyAttachment::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_wsp__PolicyAttachment(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsp__PolicyAttachment(struct soap *soap, const char *tag, int id, const wsp__PolicyAttachment *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsp__PolicyAttachment), type))
		return soap->error;
	if (soap_out_PointerTowsp__AppliesTo(soap, "wsp:AppliesTo", -1, &(a->wsp__PolicyAttachment::AppliesTo), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfwsp__Attachment(soap, "wsp:Attachment", -1, &(a->wsp__PolicyAttachment::Attachment), ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *wsp__PolicyAttachment::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_wsp__PolicyAttachment(soap, tag, this, type);
}

SOAP_FMAC3 wsp__PolicyAttachment * SOAP_FMAC4 soap_in_wsp__PolicyAttachment(struct soap *soap, const char *tag, wsp__PolicyAttachment *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (wsp__PolicyAttachment *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_wsp__PolicyAttachment, sizeof(wsp__PolicyAttachment), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_wsp__PolicyAttachment)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (wsp__PolicyAttachment *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_AppliesTo1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_AppliesTo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__AppliesTo(soap, "wsp:AppliesTo", &(a->wsp__PolicyAttachment::AppliesTo), "wsp:AppliesTo"))
				{	soap_flag_AppliesTo1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfwsp__Attachment(soap, "wsp:Attachment", &(a->wsp__PolicyAttachment::Attachment), "wsp:Attachment"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (wsp__PolicyAttachment *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsp__PolicyAttachment, 0, sizeof(wsp__PolicyAttachment), 0, soap_copy_wsp__PolicyAttachment);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int wsp__PolicyAttachment::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_wsp__PolicyAttachment);
	if (this->soap_out(soap, tag?tag:"wsp:PolicyAttachment", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *wsp__PolicyAttachment::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_wsp__PolicyAttachment(soap, this, tag, type);
}

SOAP_FMAC3 wsp__PolicyAttachment * SOAP_FMAC4 soap_get_wsp__PolicyAttachment(struct soap *soap, wsp__PolicyAttachment *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsp__PolicyAttachment(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 wsp__PolicyAttachment * SOAP_FMAC2 soap_instantiate_wsp__PolicyAttachment(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsp__PolicyAttachment(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsp__PolicyAttachment, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(wsp__PolicyAttachment);
		if (size)
			*size = sizeof(wsp__PolicyAttachment);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(wsp__PolicyAttachment[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(wsp__PolicyAttachment);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (wsp__PolicyAttachment*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsp__PolicyAttachment(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying wsp__PolicyAttachment %p -> %p\n", q, p));
	*(wsp__PolicyAttachment*)p = *(wsp__PolicyAttachment*)q;
}

void wsp__AppliesTo::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	this->wsp__AppliesTo::__any = NULL;
}

void wsp__AppliesTo::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
}

int wsp__AppliesTo::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_wsp__AppliesTo(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsp__AppliesTo(struct soap *soap, const char *tag, int id, const wsp__AppliesTo *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsp__AppliesTo), type))
		return soap->error;
	soap_outliteral(soap, "-any", &(a->wsp__AppliesTo::__any), NULL);
	return soap_element_end_out(soap, tag);
}

void *wsp__AppliesTo::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_wsp__AppliesTo(soap, tag, this, type);
}

SOAP_FMAC3 wsp__AppliesTo * SOAP_FMAC4 soap_in_wsp__AppliesTo(struct soap *soap, const char *tag, wsp__AppliesTo *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (wsp__AppliesTo *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_wsp__AppliesTo, sizeof(wsp__AppliesTo), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_wsp__AppliesTo)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (wsp__AppliesTo *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag___any1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag___any1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &(a->wsp__AppliesTo::__any)))
				{	soap_flag___any1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (wsp__AppliesTo *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsp__AppliesTo, 0, sizeof(wsp__AppliesTo), 0, soap_copy_wsp__AppliesTo);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int wsp__AppliesTo::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_wsp__AppliesTo);
	if (this->soap_out(soap, tag?tag:"wsp:AppliesTo", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *wsp__AppliesTo::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_wsp__AppliesTo(soap, this, tag, type);
}

SOAP_FMAC3 wsp__AppliesTo * SOAP_FMAC4 soap_get_wsp__AppliesTo(struct soap *soap, wsp__AppliesTo *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsp__AppliesTo(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 wsp__AppliesTo * SOAP_FMAC2 soap_instantiate_wsp__AppliesTo(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsp__AppliesTo(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsp__AppliesTo, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(wsp__AppliesTo);
		if (size)
			*size = sizeof(wsp__AppliesTo);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(wsp__AppliesTo[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(wsp__AppliesTo);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (wsp__AppliesTo*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsp__AppliesTo(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying wsp__AppliesTo %p -> %p\n", q, p));
	*(wsp__AppliesTo*)p = *(wsp__AppliesTo*)q;
}

void wsp__Attachment::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	this->wsp__Attachment::Policy = NULL;
	this->wsp__Attachment::PolicyReference = NULL;
}

void wsp__Attachment::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTowsp__Policy(soap, &this->wsp__Attachment::Policy);
	soap_serialize_PointerTowsp__PolicyReference(soap, &this->wsp__Attachment::PolicyReference);
}

int wsp__Attachment::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_wsp__Attachment(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsp__Attachment(struct soap *soap, const char *tag, int id, const wsp__Attachment *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsp__Attachment), type))
		return soap->error;
	if (soap_out_PointerTowsp__Policy(soap, "wsp:Policy", -1, &(a->wsp__Attachment::Policy), ""))
		return soap->error;
	if (soap_out_PointerTowsp__PolicyReference(soap, "wsp:PolicyReference", -1, &(a->wsp__Attachment::PolicyReference), ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *wsp__Attachment::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_wsp__Attachment(soap, tag, this, type);
}

SOAP_FMAC3 wsp__Attachment * SOAP_FMAC4 soap_in_wsp__Attachment(struct soap *soap, const char *tag, wsp__Attachment *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (wsp__Attachment *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_wsp__Attachment, sizeof(wsp__Attachment), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_wsp__Attachment)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (wsp__Attachment *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_Policy1 = 1;
	size_t soap_flag_PolicyReference1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Policy1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Policy(soap, "wsp:Policy", &(a->wsp__Attachment::Policy), "wsp:Policy"))
				{	soap_flag_Policy1--;
					continue;
				}
			if (soap_flag_PolicyReference1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__PolicyReference(soap, "wsp:PolicyReference", &(a->wsp__Attachment::PolicyReference), "wsp:PolicyReference"))
				{	soap_flag_PolicyReference1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (wsp__Attachment *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsp__Attachment, 0, sizeof(wsp__Attachment), 0, soap_copy_wsp__Attachment);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int wsp__Attachment::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_wsp__Attachment);
	if (this->soap_out(soap, tag?tag:"wsp:Attachment", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *wsp__Attachment::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_wsp__Attachment(soap, this, tag, type);
}

SOAP_FMAC3 wsp__Attachment * SOAP_FMAC4 soap_get_wsp__Attachment(struct soap *soap, wsp__Attachment *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsp__Attachment(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 wsp__Attachment * SOAP_FMAC2 soap_instantiate_wsp__Attachment(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsp__Attachment(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsp__Attachment, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(wsp__Attachment);
		if (size)
			*size = sizeof(wsp__Attachment);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(wsp__Attachment[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(wsp__Attachment);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (wsp__Attachment*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsp__Attachment(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying wsp__Attachment %p -> %p\n", q, p));
	*(wsp__Attachment*)p = *(wsp__Attachment*)q;
}

void wsrmp__RMAssertion::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	this->wsp__Assertion::Optional = (bool)0;
	this->wsp__Assertion::Ignorable = (bool)0;
	this->wsp__Assertion::Policy = NULL;
}

void wsrmp__RMAssertion::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTowsp__Content(soap, &this->wsp__Assertion::Policy);
}

int wsrmp__RMAssertion::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_wsrmp__RMAssertion(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsrmp__RMAssertion(struct soap *soap, const char *tag, int id, const wsrmp__RMAssertion *a, const char *type)
{
	soap_set_attr(soap, "Optional", soap_bool2s(soap, ((wsp__Assertion*)a)->Optional), 1);
	soap_set_attr(soap, "Ignorable", soap_bool2s(soap, ((wsp__Assertion*)a)->Ignorable), 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsrmp__RMAssertion), "wsrmp:RMAssertion"))
		return soap->error;
	if (soap_out_PointerTowsp__Content(soap, "wsp:Policy", -1, &(a->wsp__Assertion::Policy), ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *wsrmp__RMAssertion::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_wsrmp__RMAssertion(soap, tag, this, type);
}

SOAP_FMAC3 wsrmp__RMAssertion * SOAP_FMAC4 soap_in_wsrmp__RMAssertion(struct soap *soap, const char *tag, wsrmp__RMAssertion *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (wsrmp__RMAssertion *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_wsrmp__RMAssertion, sizeof(wsrmp__RMAssertion), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_wsrmp__RMAssertion)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (wsrmp__RMAssertion *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2bool(soap, soap_attr_value(soap, "Optional", 0), &((wsp__Assertion*)a)->Optional))
		return NULL;
	if (soap_s2bool(soap, soap_attr_value(soap, "Ignorable", 0), &((wsp__Assertion*)a)->Ignorable))
		return NULL;
	size_t soap_flag_Policy2 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Policy2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Content(soap, "wsp:Policy", &(a->wsp__Assertion::Policy), "wsp:Content"))
				{	soap_flag_Policy2--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (wsrmp__RMAssertion *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsrmp__RMAssertion, 0, sizeof(wsrmp__RMAssertion), 0, soap_copy_wsrmp__RMAssertion);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int wsrmp__RMAssertion::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_wsrmp__RMAssertion);
	if (this->soap_out(soap, tag?tag:"wsrmp:RMAssertion", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *wsrmp__RMAssertion::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_wsrmp__RMAssertion(soap, this, tag, type);
}

SOAP_FMAC3 wsrmp__RMAssertion * SOAP_FMAC4 soap_get_wsrmp__RMAssertion(struct soap *soap, wsrmp__RMAssertion *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsrmp__RMAssertion(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 wsrmp__RMAssertion * SOAP_FMAC2 soap_instantiate_wsrmp__RMAssertion(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsrmp__RMAssertion(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsrmp__RMAssertion, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(wsrmp__RMAssertion);
		if (size)
			*size = sizeof(wsrmp__RMAssertion);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(wsrmp__RMAssertion[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(wsrmp__RMAssertion);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (wsrmp__RMAssertion*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsrmp__RMAssertion(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying wsrmp__RMAssertion %p -> %p\n", q, p));
	*(wsrmp__RMAssertion*)p = *(wsrmp__RMAssertion*)q;
}

void sp__Token::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__anyURI(soap, &this->sp__Token::IncludeToken);
	this->sp__Token::Issuer = NULL;
	soap_default_xsd__anyURI(soap, &this->sp__Token::IssuerName);
	this->sp__Token::wst__Claims_ = NULL;
	this->wsp__Assertion::Optional = (bool)0;
	this->wsp__Assertion::Ignorable = (bool)0;
	this->wsp__Assertion::Policy = NULL;
}

void sp__Token::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTowsa__EndpointReferenceType(soap, &this->sp__Token::Issuer);
	soap_serialize_xsd__anyURI(soap, &this->sp__Token::IssuerName);
	soap_serialize_PointerTowst__Claims(soap, &this->sp__Token::wst__Claims_);
	soap_serialize_PointerTowsp__Content(soap, &this->wsp__Assertion::Policy);
}

int sp__Token::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_sp__Token(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sp__Token(struct soap *soap, const char *tag, int id, const sp__Token *a, const char *type)
{
	if (((sp__Token*)a)->IncludeToken)
		soap_set_attr(soap, "IncludeToken", ((sp__Token*)a)->IncludeToken, 1);
	soap_set_attr(soap, "Optional", soap_bool2s(soap, ((wsp__Assertion*)a)->Optional), 1);
	soap_set_attr(soap, "Ignorable", soap_bool2s(soap, ((wsp__Assertion*)a)->Ignorable), 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sp__Token), "sp:Token"))
		return soap->error;
	if (soap_out_PointerTowsp__Content(soap, "wsp:Policy", -1, &(a->wsp__Assertion::Policy), ""))
		return soap->error;
	if (soap_out_PointerTowsa__EndpointReferenceType(soap, "sp:Issuer", -1, &(a->sp__Token::Issuer), ""))
		return soap->error;
	if (soap_out_xsd__anyURI(soap, "sp:IssuerName", -1, &(a->sp__Token::IssuerName), ""))
		return soap->error;
	if (soap_out_PointerTowst__Claims(soap, "wst:Claims", -1, &(a->sp__Token::wst__Claims_), ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *sp__Token::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_sp__Token(soap, tag, this, type);
}

SOAP_FMAC3 sp__Token * SOAP_FMAC4 soap_in_sp__Token(struct soap *soap, const char *tag, sp__Token *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (sp__Token *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_sp__Token, sizeof(sp__Token), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_sp__Token)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (sp__Token *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "IncludeToken", 0), &((sp__Token*)a)->IncludeToken, 0, -1))
		return NULL;
	if (soap_s2bool(soap, soap_attr_value(soap, "Optional", 0), &((wsp__Assertion*)a)->Optional))
		return NULL;
	if (soap_s2bool(soap, soap_attr_value(soap, "Ignorable", 0), &((wsp__Assertion*)a)->Ignorable))
		return NULL;
	size_t soap_flag_Policy2 = 1;
	size_t soap_flag_Issuer1 = 1;
	size_t soap_flag_IssuerName1 = 1;
	size_t soap_flag_wst__Claims_1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Policy2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Content(soap, "wsp:Policy", &(a->wsp__Assertion::Policy), "wsp:Content"))
				{	soap_flag_Policy2--;
					continue;
				}
			if (soap_flag_Issuer1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsa__EndpointReferenceType(soap, "sp:Issuer", &(a->sp__Token::Issuer), "wsa:EndpointReferenceType"))
				{	soap_flag_Issuer1--;
					continue;
				}
			if (soap_flag_IssuerName1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__anyURI(soap, "sp:IssuerName", &(a->sp__Token::IssuerName), "xsd:anyURI"))
				{	soap_flag_IssuerName1--;
					continue;
				}
			if (soap_flag_wst__Claims_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowst__Claims(soap, "wst:Claims", &(a->sp__Token::wst__Claims_), "wst:Claims"))
				{	soap_flag_wst__Claims_1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (sp__Token *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sp__Token, 0, sizeof(sp__Token), 0, soap_copy_sp__Token);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int sp__Token::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_sp__Token);
	if (this->soap_out(soap, tag?tag:"sp:Token", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *sp__Token::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_sp__Token(soap, this, tag, type);
}

SOAP_FMAC3 sp__Token * SOAP_FMAC4 soap_get_sp__Token(struct soap *soap, sp__Token *p, const char *tag, const char *type)
{
	if ((p = soap_in_sp__Token(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 sp__Token * SOAP_FMAC2 soap_instantiate_sp__Token(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_sp__Token(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_sp__Token, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(sp__Token);
		if (size)
			*size = sizeof(sp__Token);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(sp__Token[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(sp__Token);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (sp__Token*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_sp__Token(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying sp__Token %p -> %p\n", q, p));
	*(sp__Token*)p = *(sp__Token*)q;
}

void sp__Elements::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__anyURI(soap, &this->sp__Elements::XPathVersion);
	soap_default_std__vectorTemplateOfxsd__string(soap, &this->sp__Elements::XPath);
}

void sp__Elements::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfxsd__string(soap, &this->sp__Elements::XPath);
}

int sp__Elements::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_sp__Elements(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sp__Elements(struct soap *soap, const char *tag, int id, const sp__Elements *a, const char *type)
{
	if (((sp__Elements*)a)->XPathVersion)
		soap_set_attr(soap, "XPathVersion", ((sp__Elements*)a)->XPathVersion, 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sp__Elements), type))
		return soap->error;
	if (soap_out_std__vectorTemplateOfxsd__string(soap, "sp:XPath", -1, &(a->sp__Elements::XPath), ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *sp__Elements::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_sp__Elements(soap, tag, this, type);
}

SOAP_FMAC3 sp__Elements * SOAP_FMAC4 soap_in_sp__Elements(struct soap *soap, const char *tag, sp__Elements *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (sp__Elements *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_sp__Elements, sizeof(sp__Elements), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_sp__Elements)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (sp__Elements *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "XPathVersion", 0), &((sp__Elements*)a)->XPathVersion, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfxsd__string(soap, "sp:XPath", &(a->sp__Elements::XPath), "xsd:string"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (sp__Elements *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sp__Elements, 0, sizeof(sp__Elements), 0, soap_copy_sp__Elements);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int sp__Elements::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_sp__Elements);
	if (this->soap_out(soap, tag?tag:"sp:Elements", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *sp__Elements::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_sp__Elements(soap, this, tag, type);
}

SOAP_FMAC3 sp__Elements * SOAP_FMAC4 soap_get_sp__Elements(struct soap *soap, sp__Elements *p, const char *tag, const char *type)
{
	if ((p = soap_in_sp__Elements(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 sp__Elements * SOAP_FMAC2 soap_instantiate_sp__Elements(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_sp__Elements(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_sp__Elements, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(sp__Elements);
		if (size)
			*size = sizeof(sp__Elements);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(sp__Elements[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(sp__Elements);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (sp__Elements*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_sp__Elements(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying sp__Elements %p -> %p\n", q, p));
	*(sp__Elements*)p = *(sp__Elements*)q;
}

void sp__Parts::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &this->sp__Parts::Body);
	soap_default_std__vectorTemplateOfsp__Header(soap, &this->sp__Parts::Header);
	soap_default_xsd__string(soap, &this->sp__Parts::Attachments);
}

void sp__Parts::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &this->sp__Parts::Body);
	soap_serialize_std__vectorTemplateOfsp__Header(soap, &this->sp__Parts::Header);
	soap_serialize_xsd__string(soap, &this->sp__Parts::Attachments);
}

int sp__Parts::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_sp__Parts(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sp__Parts(struct soap *soap, const char *tag, int id, const sp__Parts *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sp__Parts), type))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:Body", -1, &(a->sp__Parts::Body), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfsp__Header(soap, "sp:Header", -1, &(a->sp__Parts::Header), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:Attachments", -1, &(a->sp__Parts::Attachments), ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *sp__Parts::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_sp__Parts(soap, tag, this, type);
}

SOAP_FMAC3 sp__Parts * SOAP_FMAC4 soap_in_sp__Parts(struct soap *soap, const char *tag, sp__Parts *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (sp__Parts *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_sp__Parts, sizeof(sp__Parts), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_sp__Parts)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (sp__Parts *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_Body1 = 1;
	size_t soap_flag_Attachments1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Body1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:Body", &(a->sp__Parts::Body), "xsd:string"))
				{	soap_flag_Body1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfsp__Header(soap, "sp:Header", &(a->sp__Parts::Header), "sp:Header"))
					continue;
			if (soap_flag_Attachments1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:Attachments", &(a->sp__Parts::Attachments), "xsd:string"))
				{	soap_flag_Attachments1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (sp__Parts *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sp__Parts, 0, sizeof(sp__Parts), 0, soap_copy_sp__Parts);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int sp__Parts::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_sp__Parts);
	if (this->soap_out(soap, tag?tag:"sp:Parts", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *sp__Parts::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_sp__Parts(soap, this, tag, type);
}

SOAP_FMAC3 sp__Parts * SOAP_FMAC4 soap_get_sp__Parts(struct soap *soap, sp__Parts *p, const char *tag, const char *type)
{
	if ((p = soap_in_sp__Parts(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 sp__Parts * SOAP_FMAC2 soap_instantiate_sp__Parts(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_sp__Parts(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_sp__Parts, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(sp__Parts);
		if (size)
			*size = sizeof(sp__Parts);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(sp__Parts[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(sp__Parts);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (sp__Parts*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_sp__Parts(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying sp__Parts %p -> %p\n", q, p));
	*(sp__Parts*)p = *(sp__Parts*)q;
}

void sp__Header::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__NCName(soap, &this->sp__Header::Name);
	soap_default_xsd__anyURI(soap, &this->sp__Header::Namespace);
}

void sp__Header::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
}

int sp__Header::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_sp__Header(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sp__Header(struct soap *soap, const char *tag, int id, const sp__Header *a, const char *type)
{
	if (((sp__Header*)a)->Name)
		soap_set_attr(soap, "Name", ((sp__Header*)a)->Name, 1);
	if (((sp__Header*)a)->Namespace)
		soap_set_attr(soap, "Namespace", ((sp__Header*)a)->Namespace, 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sp__Header), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *sp__Header::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_sp__Header(soap, tag, this, type);
}

SOAP_FMAC3 sp__Header * SOAP_FMAC4 soap_in_sp__Header(struct soap *soap, const char *tag, sp__Header *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (sp__Header *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_sp__Header, sizeof(sp__Header), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_sp__Header)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (sp__Header *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "Name", 0), &((sp__Header*)a)->Name, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "Namespace", 0), &((sp__Header*)a)->Namespace, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (sp__Header *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sp__Header, 0, sizeof(sp__Header), 0, soap_copy_sp__Header);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int sp__Header::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_sp__Header);
	if (this->soap_out(soap, tag?tag:"sp:Header", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *sp__Header::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_sp__Header(soap, this, tag, type);
}

SOAP_FMAC3 sp__Header * SOAP_FMAC4 soap_get_sp__Header(struct soap *soap, sp__Header *p, const char *tag, const char *type)
{
	if ((p = soap_in_sp__Header(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 sp__Header * SOAP_FMAC2 soap_instantiate_sp__Header(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_sp__Header(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_sp__Header, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(sp__Header);
		if (size)
			*size = sizeof(sp__Header);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(sp__Header[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(sp__Header);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (sp__Header*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_sp__Header(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying sp__Header %p -> %p\n", q, p));
	*(sp__Header*)p = *(sp__Header*)q;
}

void wst__Claims::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &this->wst__Claims::Dialect);
	soap_default_xsd__string(soap, &this->wst__Claims::__item);
}

void wst__Claims::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &this->wst__Claims::__item);
}

int wst__Claims::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_wst__Claims(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wst__Claims(struct soap *soap, const char *tag, int id, const wst__Claims *a, const char *type)
{
	if (((wst__Claims*)a)->Dialect)
		soap_set_attr(soap, "Dialect", ((wst__Claims*)a)->Dialect, 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wst__Claims), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *wst__Claims::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_wst__Claims(soap, tag, this, type);
}

SOAP_FMAC3 wst__Claims * SOAP_FMAC4 soap_in_wst__Claims(struct soap *soap, const char *tag, wst__Claims *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (wst__Claims *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_wst__Claims, sizeof(wst__Claims), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_wst__Claims)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (wst__Claims *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "Dialect", 0), &((wst__Claims*)a)->Dialect, 0, -1))
		return NULL;
	size_t soap_flag___item1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag___item1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "-item", &(a->wst__Claims::__item), "xsd:string"))
				{	soap_flag___item1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (wst__Claims *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wst__Claims, 0, sizeof(wst__Claims), 0, soap_copy_wst__Claims);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int wst__Claims::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_wst__Claims);
	if (this->soap_out(soap, tag?tag:"wst:Claims", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *wst__Claims::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_wst__Claims(soap, this, tag, type);
}

SOAP_FMAC3 wst__Claims * SOAP_FMAC4 soap_get_wst__Claims(struct soap *soap, wst__Claims *p, const char *tag, const char *type)
{
	if ((p = soap_in_wst__Claims(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 wst__Claims * SOAP_FMAC2 soap_instantiate_wst__Claims(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wst__Claims(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wst__Claims, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(wst__Claims);
		if (size)
			*size = sizeof(wst__Claims);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(wst__Claims[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(wst__Claims);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (wst__Claims*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wst__Claims(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying wst__Claims %p -> %p\n", q, p));
	*(wst__Claims*)p = *(wst__Claims*)q;
}

void wsp__Assertion::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	this->wsp__Assertion::Optional = (bool)0;
	this->wsp__Assertion::Ignorable = (bool)0;
	this->wsp__Assertion::Policy = NULL;
}

void wsp__Assertion::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTowsp__Content(soap, &this->wsp__Assertion::Policy);
}

int wsp__Assertion::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_wsp__Assertion(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsp__Assertion(struct soap *soap, const char *tag, int id, const wsp__Assertion *a, const char *type)
{
	soap_set_attr(soap, "Optional", soap_bool2s(soap, ((wsp__Assertion*)a)->Optional), 1);
	soap_set_attr(soap, "Ignorable", soap_bool2s(soap, ((wsp__Assertion*)a)->Ignorable), 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsp__Assertion), type))
		return soap->error;
	if (soap_out_PointerTowsp__Content(soap, "wsp:Policy", -1, &(a->wsp__Assertion::Policy), ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *wsp__Assertion::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_wsp__Assertion(soap, tag, this, type);
}

SOAP_FMAC3 wsp__Assertion * SOAP_FMAC4 soap_in_wsp__Assertion(struct soap *soap, const char *tag, wsp__Assertion *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (wsp__Assertion *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_wsp__Assertion, sizeof(wsp__Assertion), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_wsp__Assertion)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (wsp__Assertion *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2bool(soap, soap_attr_value(soap, "Optional", 0), &((wsp__Assertion*)a)->Optional))
		return NULL;
	if (soap_s2bool(soap, soap_attr_value(soap, "Ignorable", 0), &((wsp__Assertion*)a)->Ignorable))
		return NULL;
	size_t soap_flag_Policy1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Policy1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Content(soap, "wsp:Policy", &(a->wsp__Assertion::Policy), "wsp:Content"))
				{	soap_flag_Policy1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (wsp__Assertion *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsp__Assertion, 0, sizeof(wsp__Assertion), 0, soap_copy_wsp__Assertion);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int wsp__Assertion::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_wsp__Assertion);
	if (this->soap_out(soap, tag?tag:"wsp:Assertion", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *wsp__Assertion::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_wsp__Assertion(soap, this, tag, type);
}

SOAP_FMAC3 wsp__Assertion * SOAP_FMAC4 soap_get_wsp__Assertion(struct soap *soap, wsp__Assertion *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsp__Assertion(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 wsp__Assertion * SOAP_FMAC2 soap_instantiate_wsp__Assertion(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsp__Assertion(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsp__Assertion, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (type && !soap_match_tag(soap, type, "sp:Token"))
	{	cp->type = SOAP_TYPE_sp__Token;
		if (n < 0)
		{	cp->ptr = (void*)SOAP_NEW(sp__Token);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(sp__Token);
		}
		else
		{	cp->ptr = (void*)SOAP_NEW(sp__Token[n]);
			if (size)
				*size = n * sizeof(sp__Token);
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (sp__Token*)cp->ptr;
	}
	if (type && !soap_match_tag(soap, type, "wsrmp:RMAssertion"))
	{	cp->type = SOAP_TYPE_wsrmp__RMAssertion;
		if (n < 0)
		{	cp->ptr = (void*)SOAP_NEW(wsrmp__RMAssertion);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(wsrmp__RMAssertion);
		}
		else
		{	cp->ptr = (void*)SOAP_NEW(wsrmp__RMAssertion[n]);
			if (size)
				*size = n * sizeof(wsrmp__RMAssertion);
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (wsrmp__RMAssertion*)cp->ptr;
	}
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(wsp__Assertion);
		if (size)
			*size = sizeof(wsp__Assertion);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(wsp__Assertion[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(wsp__Assertion);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (wsp__Assertion*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsp__Assertion(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying wsp__Assertion %p -> %p\n", q, p));
	*(wsp__Assertion*)p = *(wsp__Assertion*)q;
}

void wsp__PolicyReference::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__anyURI(soap, &this->wsp__PolicyReference::URI);
	soap_default_xsd__string(soap, &this->wsp__PolicyReference::Digest);
	soap_default_xsd__anyURI(soap, &this->wsp__PolicyReference::DigestAlgorithm);
	this->wsp__PolicyReference::policyRef = NULL;
}

void wsp__PolicyReference::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	/* non-serializable policyRef skipped */
	/* transient traverse skipped */
	/* transient policyPtr skipped */
	/* transient policyPtr skipped */
}

int wsp__PolicyReference::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_wsp__PolicyReference(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsp__PolicyReference(struct soap *soap, const char *tag, int id, const wsp__PolicyReference *a, const char *type)
{
	if (((wsp__PolicyReference*)a)->URI)
		soap_set_attr(soap, "URI", ((wsp__PolicyReference*)a)->URI, 1);
	if (((wsp__PolicyReference*)a)->Digest)
		soap_set_attr(soap, "Digest", ((wsp__PolicyReference*)a)->Digest, 1);
	if (((wsp__PolicyReference*)a)->DigestAlgorithm)
		soap_set_attr(soap, "DigestAlgorithm", ((wsp__PolicyReference*)a)->DigestAlgorithm, 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsp__PolicyReference), type))
		return soap->error;
	/* non-serializable policyRef skipped */
	/* transient traverse skipped */
	/* transient policyPtr skipped */
	/* transient policyPtr skipped */
	return soap_element_end_out(soap, tag);
}

void *wsp__PolicyReference::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_wsp__PolicyReference(soap, tag, this, type);
}

SOAP_FMAC3 wsp__PolicyReference * SOAP_FMAC4 soap_in_wsp__PolicyReference(struct soap *soap, const char *tag, wsp__PolicyReference *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (wsp__PolicyReference *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_wsp__PolicyReference, sizeof(wsp__PolicyReference), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_wsp__PolicyReference)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (wsp__PolicyReference *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "URI", 0), &((wsp__PolicyReference*)a)->URI, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "Digest", 0), &((wsp__PolicyReference*)a)->Digest, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "DigestAlgorithm", 0), &((wsp__PolicyReference*)a)->DigestAlgorithm, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			/* non-serializable policyRef skipped */
			/* transient traverse skipped */
			/* transient policyPtr skipped */
			/* transient policyPtr skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (wsp__PolicyReference *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsp__PolicyReference, 0, sizeof(wsp__PolicyReference), 0, soap_copy_wsp__PolicyReference);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int wsp__PolicyReference::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_wsp__PolicyReference);
	if (this->soap_out(soap, tag?tag:"wsp:PolicyReference", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *wsp__PolicyReference::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_wsp__PolicyReference(soap, this, tag, type);
}

SOAP_FMAC3 wsp__PolicyReference * SOAP_FMAC4 soap_get_wsp__PolicyReference(struct soap *soap, wsp__PolicyReference *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsp__PolicyReference(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 wsp__PolicyReference * SOAP_FMAC2 soap_instantiate_wsp__PolicyReference(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsp__PolicyReference(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsp__PolicyReference, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(wsp__PolicyReference);
		if (size)
			*size = sizeof(wsp__PolicyReference);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(wsp__PolicyReference[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(wsp__PolicyReference);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (wsp__PolicyReference*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsp__PolicyReference(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying wsp__PolicyReference %p -> %p\n", q, p));
	*(wsp__PolicyReference*)p = *(wsp__PolicyReference*)q;
}

void wsp__Content::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	this->wsp__Content::Policy = NULL;
	this->wsp__Content::PolicyReference = NULL;
	soap_default_std__vectorTemplateOfPointerTowsp__Content(soap, &this->wsp__Content::All);
	soap_default_std__vectorTemplateOfPointerTowsp__Content(soap, &this->wsp__Content::ExactlyOne);
	soap_default_std__vectorTemplateOfsp__Parts(soap, &this->wsp__Content::sp__SignedParts);
	soap_default_std__vectorTemplateOfsp__Parts(soap, &this->wsp__Content::sp__EncryptedParts);
	soap_default_std__vectorTemplateOfsp__Parts(soap, &this->wsp__Content::sp__RequiredParts);
	this->wsp__Content::sp__SignedElements = NULL;
	this->wsp__Content::sp__EncryptedElements = NULL;
	this->wsp__Content::sp__ContentEncryptedElements = NULL;
	this->wsp__Content::sp__RequiredElements = NULL;
	this->wsp__Content::sp__UsernameToken = NULL;
	this->wsp__Content::sp__IssuedToken = NULL;
	this->wsp__Content::sp__X509Token = NULL;
	this->wsp__Content::sp__KerberosToken = NULL;
	this->wsp__Content::sp__SpnegoContextToken = NULL;
	this->wsp__Content::sp__SecurityContextToken = NULL;
	this->wsp__Content::sp__SecureConversationToken = NULL;
	this->wsp__Content::sp__SamlToken = NULL;
	this->wsp__Content::sp__RelToken = NULL;
	this->wsp__Content::sp__HttpsToken = NULL;
	this->wsp__Content::sp__KeyValueToken = NULL;
	this->wsp__Content::sp__TransportBinding = NULL;
	this->wsp__Content::sp__TransportToken = NULL;
	this->wsp__Content::sp__AlgorithmSuite = NULL;
	this->wsp__Content::sp__Layout = NULL;
	this->wsp__Content::sp__SymmetricBinding = NULL;
	this->wsp__Content::sp__AsymmetricBinding = NULL;
	this->wsp__Content::sp__ProtectionToken = NULL;
	this->wsp__Content::sp__InitiatorToken = NULL;
	this->wsp__Content::sp__InitiatorSignatureToken = NULL;
	this->wsp__Content::sp__InitiatorEncryptionToken = NULL;
	this->wsp__Content::sp__RecipientToken = NULL;
	this->wsp__Content::sp__SupportingTokens = NULL;
	this->wsp__Content::sp__SignedSupportingTokens = NULL;
	this->wsp__Content::sp__EndorsingSupportingTokens = NULL;
	this->wsp__Content::sp__SignedEndorsingSupportingTokens = NULL;
	this->wsp__Content::sp__SignedEncryptedSupportingTokens = NULL;
	this->wsp__Content::sp__EncryptedSupportingTokens = NULL;
	this->wsp__Content::sp__EndorsingEncryptedSupportingTokens = NULL;
	this->wsp__Content::sp__SignedEndorsingEncryptedSupportingTokens = NULL;
	this->wsp__Content::sp__Wss10 = NULL;
	this->wsp__Content::sp__Wss11 = NULL;
	this->wsp__Content::sp__Trust13 = NULL;
	this->wsp__Content::wsam__Addressing = NULL;
	this->wsp__Content::wsrmp__RMAssertion_ = NULL;
	this->wsp__Content::wsrmp__DeliveryAssurance = NULL;
	soap_default_xsd__string(soap, &this->wsp__Content::wsrmp__AtLeastOnce);
	soap_default_xsd__string(soap, &this->wsp__Content::wsrmp__AtMostOnce);
	soap_default_xsd__string(soap, &this->wsp__Content::wsrmp__ExactlyOnce);
	soap_default_xsd__string(soap, &this->wsp__Content::wsrmp__InOrder);
	this->wsp__Content::sp__NoPassword = NULL;
	this->wsp__Content::sp__HashPassword = NULL;
	this->wsp__Content::sp__IncludeTimestamp = NULL;
	this->wsp__Content::sp__EncryptBeforeSigning = NULL;
	this->wsp__Content::sp__EncryptSignature = NULL;
	this->wsp__Content::sp__ProtectTokens = NULL;
	this->wsp__Content::sp__OnlySignEntireHeadersAndBody = NULL;
	soap_default_xsd__string(soap, &this->wsp__Content::sp__RequireDerivedKeys);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__RequireImpliedDerivedKeys);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__RequireExplicitDerivedKeys);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__WssUsernameToken10);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__WssUsernameToken11);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__RequireExternalReference);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__RequireInternalReference);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__RequireKeyIdentifierReference);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__RequireIssuerSerialReference);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__RequireEmbeddedTokenReference);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__RequireThumbprintReference);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__WssX509V3Token10);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__WssX509Pkcs7Token10);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__WssX509PkiPathV1Token10);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__WssX509V1Token11);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__WssX509V3Token11);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__WssX509Pkcs7Token11);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__WssX509PkiPathV1Token11);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__WssKerberosV5ApReqToken11);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__WssGssKerberosV5ApReqToken11);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__WssRelV10Token10);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__WssRelV20Token10);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__WssRelV10Token11);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__WssRelV20Token11);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__MustNotSendCancel);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__MustNotSendAmend);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__MustNotSendRenew);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__MustSupportRefKeyIdentifier);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__MustSupportRefIssuerSerial);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__MustSupportRefExternalURI);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__MustSupportRefEmbeddedToken);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__MustSupportRefThumbprint);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__MustSupportRefEncryptedKey);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__RequireSignatureConfirmation);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__MustSupportClientChallenge);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__MustSupportServerChallenge);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__RequireClientEntropy);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__RequireServerEntropy);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__MustSupportIssuedTokens);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__RequireRequestSecurityTokenCollection);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__RequireAppliesTo);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__RequireExternalUriReference);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__SC13SecurityContextToken);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__Strict);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__Lax);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__LaxTsFirst);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__LaxTsLast);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__HttpBasicAuthentication);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__HttpDigestAuthentication);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__RequireClientCertificate);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__Basic256);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__Basic192);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__Basic128);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__TripleDes);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__Basic256Rsa15);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__Basic192Rsa15);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__Basic128Rsa15);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__TripleDesRsa15);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__Basic256Sha256);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__Basic192Sha256);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__Basic128Sha256);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__TripleDesSha256);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__Basic256Sha256Rsa15);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__Basic192Sha256Rsa15);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__Basic128Sha256Rsa15);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__TripleDesSha256Rsa15);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__InclusiveC14N);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__SOAPNormalization10);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__STRTransform10);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__Path10);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__XPathFilter20);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__AbsXPath);
	soap_default_xsd__string(soap, &this->wsp__Content::wsam__AnonymousResponses);
	soap_default_xsd__string(soap, &this->wsp__Content::wsam__NonAnonymousResponses);
	soap_default_std__vectorTemplateOf_XML(soap, &this->wsp__Content::__any);
}

void wsp__Content::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTowsp__Policy(soap, &this->wsp__Content::Policy);
	soap_serialize_PointerTowsp__PolicyReference(soap, &this->wsp__Content::PolicyReference);
	soap_serialize_std__vectorTemplateOfPointerTowsp__Content(soap, &this->wsp__Content::All);
	soap_serialize_std__vectorTemplateOfPointerTowsp__Content(soap, &this->wsp__Content::ExactlyOne);
	soap_serialize_std__vectorTemplateOfsp__Parts(soap, &this->wsp__Content::sp__SignedParts);
	soap_serialize_std__vectorTemplateOfsp__Parts(soap, &this->wsp__Content::sp__EncryptedParts);
	soap_serialize_std__vectorTemplateOfsp__Parts(soap, &this->wsp__Content::sp__RequiredParts);
	soap_serialize_PointerTosp__Elements(soap, &this->wsp__Content::sp__SignedElements);
	soap_serialize_PointerTosp__Elements(soap, &this->wsp__Content::sp__EncryptedElements);
	soap_serialize_PointerTosp__Elements(soap, &this->wsp__Content::sp__ContentEncryptedElements);
	soap_serialize_PointerTosp__Elements(soap, &this->wsp__Content::sp__RequiredElements);
	soap_serialize_PointerTosp__Token(soap, &this->wsp__Content::sp__UsernameToken);
	soap_serialize_PointerTosp__Token(soap, &this->wsp__Content::sp__IssuedToken);
	soap_serialize_PointerTosp__Token(soap, &this->wsp__Content::sp__X509Token);
	soap_serialize_PointerTosp__Token(soap, &this->wsp__Content::sp__KerberosToken);
	soap_serialize_PointerTosp__Token(soap, &this->wsp__Content::sp__SpnegoContextToken);
	soap_serialize_PointerTosp__Token(soap, &this->wsp__Content::sp__SecurityContextToken);
	soap_serialize_PointerTosp__Token(soap, &this->wsp__Content::sp__SecureConversationToken);
	soap_serialize_PointerTosp__Token(soap, &this->wsp__Content::sp__SamlToken);
	soap_serialize_PointerTosp__Token(soap, &this->wsp__Content::sp__RelToken);
	soap_serialize_PointerTosp__Token(soap, &this->wsp__Content::sp__HttpsToken);
	soap_serialize_PointerTosp__Token(soap, &this->wsp__Content::sp__KeyValueToken);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__TransportBinding);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__TransportToken);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__AlgorithmSuite);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__Layout);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__SymmetricBinding);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__AsymmetricBinding);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__ProtectionToken);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__InitiatorToken);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__InitiatorSignatureToken);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__InitiatorEncryptionToken);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__RecipientToken);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__SupportingTokens);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__SignedSupportingTokens);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__EndorsingSupportingTokens);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__SignedEndorsingSupportingTokens);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__SignedEncryptedSupportingTokens);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__EncryptedSupportingTokens);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__EndorsingEncryptedSupportingTokens);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__SignedEndorsingEncryptedSupportingTokens);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__Wss10);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__Wss11);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__Trust13);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::wsam__Addressing);
	soap_serialize_PointerTowsrmp__RMAssertion(soap, &this->wsp__Content::wsrmp__RMAssertion_);
	soap_serialize_PointerTowsrmp__RMAssertion(soap, &this->wsp__Content::wsrmp__DeliveryAssurance);
	soap_serialize_xsd__string(soap, &this->wsp__Content::wsrmp__AtLeastOnce);
	soap_serialize_xsd__string(soap, &this->wsp__Content::wsrmp__AtMostOnce);
	soap_serialize_xsd__string(soap, &this->wsp__Content::wsrmp__ExactlyOnce);
	soap_serialize_xsd__string(soap, &this->wsp__Content::wsrmp__InOrder);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__NoPassword);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__HashPassword);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__IncludeTimestamp);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__EncryptBeforeSigning);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__EncryptSignature);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__ProtectTokens);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__OnlySignEntireHeadersAndBody);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__RequireDerivedKeys);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__RequireImpliedDerivedKeys);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__RequireExplicitDerivedKeys);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__WssUsernameToken10);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__WssUsernameToken11);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__RequireExternalReference);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__RequireInternalReference);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__RequireKeyIdentifierReference);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__RequireIssuerSerialReference);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__RequireEmbeddedTokenReference);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__RequireThumbprintReference);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__WssX509V3Token10);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__WssX509Pkcs7Token10);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__WssX509PkiPathV1Token10);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__WssX509V1Token11);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__WssX509V3Token11);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__WssX509Pkcs7Token11);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__WssX509PkiPathV1Token11);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__WssKerberosV5ApReqToken11);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__WssGssKerberosV5ApReqToken11);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__WssRelV10Token10);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__WssRelV20Token10);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__WssRelV10Token11);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__WssRelV20Token11);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__MustNotSendCancel);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__MustNotSendAmend);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__MustNotSendRenew);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__MustSupportRefKeyIdentifier);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__MustSupportRefIssuerSerial);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__MustSupportRefExternalURI);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__MustSupportRefEmbeddedToken);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__MustSupportRefThumbprint);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__MustSupportRefEncryptedKey);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__RequireSignatureConfirmation);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__MustSupportClientChallenge);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__MustSupportServerChallenge);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__RequireClientEntropy);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__RequireServerEntropy);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__MustSupportIssuedTokens);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__RequireRequestSecurityTokenCollection);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__RequireAppliesTo);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__RequireExternalUriReference);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__SC13SecurityContextToken);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__Strict);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__Lax);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__LaxTsFirst);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__LaxTsLast);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__HttpBasicAuthentication);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__HttpDigestAuthentication);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__RequireClientCertificate);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__Basic256);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__Basic192);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__Basic128);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__TripleDes);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__Basic256Rsa15);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__Basic192Rsa15);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__Basic128Rsa15);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__TripleDesRsa15);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__Basic256Sha256);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__Basic192Sha256);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__Basic128Sha256);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__TripleDesSha256);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__Basic256Sha256Rsa15);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__Basic192Sha256Rsa15);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__Basic128Sha256Rsa15);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__TripleDesSha256Rsa15);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__InclusiveC14N);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__SOAPNormalization10);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__STRTransform10);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__Path10);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__XPathFilter20);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__AbsXPath);
	soap_serialize_xsd__string(soap, &this->wsp__Content::wsam__AnonymousResponses);
	soap_serialize_xsd__string(soap, &this->wsp__Content::wsam__NonAnonymousResponses);
	soap_serialize_std__vectorTemplateOf_XML(soap, &this->wsp__Content::__any);
	/* transient traverse skipped */
	/* transient generate skipped */
}

int wsp__Content::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_wsp__Content(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsp__Content(struct soap *soap, const char *tag, int id, const wsp__Content *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsp__Content), type))
		return soap->error;
	if (soap_out_PointerTowsp__Policy(soap, "wsp:Policy", -1, &(a->wsp__Content::Policy), ""))
		return soap->error;
	if (soap_out_PointerTowsp__PolicyReference(soap, "wsp:PolicyReference", -1, &(a->wsp__Content::PolicyReference), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfPointerTowsp__Content(soap, "wsp:All", -1, &(a->wsp__Content::All), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfPointerTowsp__Content(soap, "wsp:ExactlyOne", -1, &(a->wsp__Content::ExactlyOne), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfsp__Parts(soap, "sp:SignedParts", -1, &(a->wsp__Content::sp__SignedParts), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfsp__Parts(soap, "sp:EncryptedParts", -1, &(a->wsp__Content::sp__EncryptedParts), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfsp__Parts(soap, "sp:RequiredParts", -1, &(a->wsp__Content::sp__RequiredParts), ""))
		return soap->error;
	if (soap_out_PointerTosp__Elements(soap, "sp:SignedElements", -1, &(a->wsp__Content::sp__SignedElements), ""))
		return soap->error;
	if (soap_out_PointerTosp__Elements(soap, "sp:EncryptedElements", -1, &(a->wsp__Content::sp__EncryptedElements), ""))
		return soap->error;
	if (soap_out_PointerTosp__Elements(soap, "sp:ContentEncryptedElements", -1, &(a->wsp__Content::sp__ContentEncryptedElements), ""))
		return soap->error;
	if (soap_out_PointerTosp__Elements(soap, "sp:RequiredElements", -1, &(a->wsp__Content::sp__RequiredElements), ""))
		return soap->error;
	if (soap_out_PointerTosp__Token(soap, "sp:UsernameToken", -1, &(a->wsp__Content::sp__UsernameToken), ""))
		return soap->error;
	if (soap_out_PointerTosp__Token(soap, "sp:IssuedToken", -1, &(a->wsp__Content::sp__IssuedToken), ""))
		return soap->error;
	if (soap_out_PointerTosp__Token(soap, "sp:X509Token", -1, &(a->wsp__Content::sp__X509Token), ""))
		return soap->error;
	if (soap_out_PointerTosp__Token(soap, "sp:KerberosToken", -1, &(a->wsp__Content::sp__KerberosToken), ""))
		return soap->error;
	if (soap_out_PointerTosp__Token(soap, "sp:SpnegoContextToken", -1, &(a->wsp__Content::sp__SpnegoContextToken), ""))
		return soap->error;
	if (soap_out_PointerTosp__Token(soap, "sp:SecurityContextToken", -1, &(a->wsp__Content::sp__SecurityContextToken), ""))
		return soap->error;
	if (soap_out_PointerTosp__Token(soap, "sp:SecureConversationToken", -1, &(a->wsp__Content::sp__SecureConversationToken), ""))
		return soap->error;
	if (soap_out_PointerTosp__Token(soap, "sp:SamlToken", -1, &(a->wsp__Content::sp__SamlToken), ""))
		return soap->error;
	if (soap_out_PointerTosp__Token(soap, "sp:RelToken", -1, &(a->wsp__Content::sp__RelToken), ""))
		return soap->error;
	if (soap_out_PointerTosp__Token(soap, "sp:HttpsToken", -1, &(a->wsp__Content::sp__HttpsToken), ""))
		return soap->error;
	if (soap_out_PointerTosp__Token(soap, "sp:KeyValueToken", -1, &(a->wsp__Content::sp__KeyValueToken), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:TransportBinding", -1, &(a->wsp__Content::sp__TransportBinding), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:TransportToken", -1, &(a->wsp__Content::sp__TransportToken), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:AlgorithmSuite", -1, &(a->wsp__Content::sp__AlgorithmSuite), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:Layout", -1, &(a->wsp__Content::sp__Layout), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:SymmetricBinding", -1, &(a->wsp__Content::sp__SymmetricBinding), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:AsymmetricBinding", -1, &(a->wsp__Content::sp__AsymmetricBinding), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:ProtectionToken", -1, &(a->wsp__Content::sp__ProtectionToken), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:InitiatorToken", -1, &(a->wsp__Content::sp__InitiatorToken), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:InitiatorSignatureToken", -1, &(a->wsp__Content::sp__InitiatorSignatureToken), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:InitiatorEncryptionToken", -1, &(a->wsp__Content::sp__InitiatorEncryptionToken), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:RecipientToken", -1, &(a->wsp__Content::sp__RecipientToken), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:SupportingTokens", -1, &(a->wsp__Content::sp__SupportingTokens), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:SignedSupportingTokens", -1, &(a->wsp__Content::sp__SignedSupportingTokens), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:EndorsingSupportingTokens", -1, &(a->wsp__Content::sp__EndorsingSupportingTokens), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:SignedEndorsingSupportingTokens", -1, &(a->wsp__Content::sp__SignedEndorsingSupportingTokens), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:SignedEncryptedSupportingTokens", -1, &(a->wsp__Content::sp__SignedEncryptedSupportingTokens), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:EncryptedSupportingTokens", -1, &(a->wsp__Content::sp__EncryptedSupportingTokens), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:EndorsingEncryptedSupportingTokens", -1, &(a->wsp__Content::sp__EndorsingEncryptedSupportingTokens), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:SignedEndorsingEncryptedSupportingTokens", -1, &(a->wsp__Content::sp__SignedEndorsingEncryptedSupportingTokens), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:Wss10", -1, &(a->wsp__Content::sp__Wss10), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:Wss11", -1, &(a->wsp__Content::sp__Wss11), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:Trust13", -1, &(a->wsp__Content::sp__Trust13), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "wsam:Addressing", -1, &(a->wsp__Content::wsam__Addressing), ""))
		return soap->error;
	if (soap_out_PointerTowsrmp__RMAssertion(soap, "wsrmp:RMAssertion", -1, &(a->wsp__Content::wsrmp__RMAssertion_), ""))
		return soap->error;
	if (soap_out_PointerTowsrmp__RMAssertion(soap, "wsrmp:DeliveryAssurance", -1, &(a->wsp__Content::wsrmp__DeliveryAssurance), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "wsrmp:AtLeastOnce", -1, &(a->wsp__Content::wsrmp__AtLeastOnce), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "wsrmp:AtMostOnce", -1, &(a->wsp__Content::wsrmp__AtMostOnce), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "wsrmp:ExactlyOnce", -1, &(a->wsp__Content::wsrmp__ExactlyOnce), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "wsrmp:InOrder", -1, &(a->wsp__Content::wsrmp__InOrder), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:NoPassword", -1, &(a->wsp__Content::sp__NoPassword), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:HashPassword", -1, &(a->wsp__Content::sp__HashPassword), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:IncludeTimestamp", -1, &(a->wsp__Content::sp__IncludeTimestamp), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:EncryptBeforeSigning", -1, &(a->wsp__Content::sp__EncryptBeforeSigning), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:EncryptSignature", -1, &(a->wsp__Content::sp__EncryptSignature), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:ProtectTokens", -1, &(a->wsp__Content::sp__ProtectTokens), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:OnlySignEntireHeadersAndBody", -1, &(a->wsp__Content::sp__OnlySignEntireHeadersAndBody), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:RequireDerivedKeys", -1, &(a->wsp__Content::sp__RequireDerivedKeys), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:RequireImpliedDerivedKeys", -1, &(a->wsp__Content::sp__RequireImpliedDerivedKeys), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:RequireExplicitDerivedKeys", -1, &(a->wsp__Content::sp__RequireExplicitDerivedKeys), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:WssUsernameToken10", -1, &(a->wsp__Content::sp__WssUsernameToken10), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:WssUsernameToken11", -1, &(a->wsp__Content::sp__WssUsernameToken11), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:RequireExternalReference", -1, &(a->wsp__Content::sp__RequireExternalReference), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:RequireInternalReference", -1, &(a->wsp__Content::sp__RequireInternalReference), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:RequireKeyIdentifierReference", -1, &(a->wsp__Content::sp__RequireKeyIdentifierReference), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:RequireIssuerSerialReference", -1, &(a->wsp__Content::sp__RequireIssuerSerialReference), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:RequireEmbeddedTokenReference", -1, &(a->wsp__Content::sp__RequireEmbeddedTokenReference), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:RequireThumbprintReference", -1, &(a->wsp__Content::sp__RequireThumbprintReference), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:WssX509V3Token10", -1, &(a->wsp__Content::sp__WssX509V3Token10), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:WssX509Pkcs7Token10", -1, &(a->wsp__Content::sp__WssX509Pkcs7Token10), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:WssX509PkiPathV1Token10", -1, &(a->wsp__Content::sp__WssX509PkiPathV1Token10), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:WssX509V1Token11", -1, &(a->wsp__Content::sp__WssX509V1Token11), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:WssX509V3Token11", -1, &(a->wsp__Content::sp__WssX509V3Token11), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:WssX509Pkcs7Token11", -1, &(a->wsp__Content::sp__WssX509Pkcs7Token11), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:WssX509PkiPathV1Token11", -1, &(a->wsp__Content::sp__WssX509PkiPathV1Token11), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:WssKerberosV5ApReqToken11", -1, &(a->wsp__Content::sp__WssKerberosV5ApReqToken11), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:WssGssKerberosV5ApReqToken11", -1, &(a->wsp__Content::sp__WssGssKerberosV5ApReqToken11), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:WssRelV10Token10", -1, &(a->wsp__Content::sp__WssRelV10Token10), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:WssRelV20Token10", -1, &(a->wsp__Content::sp__WssRelV20Token10), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:WssRelV10Token11", -1, &(a->wsp__Content::sp__WssRelV10Token11), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:WssRelV20Token11", -1, &(a->wsp__Content::sp__WssRelV20Token11), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:MustNotSendCancel", -1, &(a->wsp__Content::sp__MustNotSendCancel), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:MustNotSendAmend", -1, &(a->wsp__Content::sp__MustNotSendAmend), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:MustNotSendRenew", -1, &(a->wsp__Content::sp__MustNotSendRenew), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:MustSupportRefKeyIdentifier", -1, &(a->wsp__Content::sp__MustSupportRefKeyIdentifier), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:MustSupportRefIssuerSerial", -1, &(a->wsp__Content::sp__MustSupportRefIssuerSerial), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:MustSupportRefExternalURI", -1, &(a->wsp__Content::sp__MustSupportRefExternalURI), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:MustSupportRefEmbeddedToken", -1, &(a->wsp__Content::sp__MustSupportRefEmbeddedToken), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:MustSupportRefThumbprint", -1, &(a->wsp__Content::sp__MustSupportRefThumbprint), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:MustSupportRefEncryptedKey", -1, &(a->wsp__Content::sp__MustSupportRefEncryptedKey), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:RequireSignatureConfirmation", -1, &(a->wsp__Content::sp__RequireSignatureConfirmation), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:MustSupportClientChallenge", -1, &(a->wsp__Content::sp__MustSupportClientChallenge), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:MustSupportServerChallenge", -1, &(a->wsp__Content::sp__MustSupportServerChallenge), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:RequireClientEntropy", -1, &(a->wsp__Content::sp__RequireClientEntropy), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:RequireServerEntropy", -1, &(a->wsp__Content::sp__RequireServerEntropy), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:MustSupportIssuedTokens", -1, &(a->wsp__Content::sp__MustSupportIssuedTokens), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:RequireRequestSecurityTokenCollection", -1, &(a->wsp__Content::sp__RequireRequestSecurityTokenCollection), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:RequireAppliesTo", -1, &(a->wsp__Content::sp__RequireAppliesTo), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:RequireExternalUriReference", -1, &(a->wsp__Content::sp__RequireExternalUriReference), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:SC13SecurityContextToken", -1, &(a->wsp__Content::sp__SC13SecurityContextToken), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:Strict", -1, &(a->wsp__Content::sp__Strict), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:Lax", -1, &(a->wsp__Content::sp__Lax), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:LaxTsFirst", -1, &(a->wsp__Content::sp__LaxTsFirst), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:LaxTsLast", -1, &(a->wsp__Content::sp__LaxTsLast), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:HttpBasicAuthentication", -1, &(a->wsp__Content::sp__HttpBasicAuthentication), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:HttpDigestAuthentication", -1, &(a->wsp__Content::sp__HttpDigestAuthentication), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:RequireClientCertificate", -1, &(a->wsp__Content::sp__RequireClientCertificate), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:Basic256", -1, &(a->wsp__Content::sp__Basic256), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:Basic192", -1, &(a->wsp__Content::sp__Basic192), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:Basic128", -1, &(a->wsp__Content::sp__Basic128), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:TripleDes", -1, &(a->wsp__Content::sp__TripleDes), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:Basic256Rsa15", -1, &(a->wsp__Content::sp__Basic256Rsa15), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:Basic192Rsa15", -1, &(a->wsp__Content::sp__Basic192Rsa15), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:Basic128Rsa15", -1, &(a->wsp__Content::sp__Basic128Rsa15), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:TripleDesRsa15", -1, &(a->wsp__Content::sp__TripleDesRsa15), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:Basic256Sha256", -1, &(a->wsp__Content::sp__Basic256Sha256), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:Basic192Sha256", -1, &(a->wsp__Content::sp__Basic192Sha256), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:Basic128Sha256", -1, &(a->wsp__Content::sp__Basic128Sha256), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:TripleDesSha256", -1, &(a->wsp__Content::sp__TripleDesSha256), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:Basic256Sha256Rsa15", -1, &(a->wsp__Content::sp__Basic256Sha256Rsa15), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:Basic192Sha256Rsa15", -1, &(a->wsp__Content::sp__Basic192Sha256Rsa15), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:Basic128Sha256Rsa15", -1, &(a->wsp__Content::sp__Basic128Sha256Rsa15), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:TripleDesSha256Rsa15", -1, &(a->wsp__Content::sp__TripleDesSha256Rsa15), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:InclusiveC14N", -1, &(a->wsp__Content::sp__InclusiveC14N), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:SOAPNormalization10", -1, &(a->wsp__Content::sp__SOAPNormalization10), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:STRTransform10", -1, &(a->wsp__Content::sp__STRTransform10), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:Path10", -1, &(a->wsp__Content::sp__Path10), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:XPathFilter20", -1, &(a->wsp__Content::sp__XPathFilter20), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:AbsXPath", -1, &(a->wsp__Content::sp__AbsXPath), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "wsam:AnonymousResponses", -1, &(a->wsp__Content::wsam__AnonymousResponses), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "wsam:NonAnonymousResponses", -1, &(a->wsp__Content::wsam__NonAnonymousResponses), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOf_XML(soap, "-any", -1, &(a->wsp__Content::__any), ""))
		return soap->error;
	/* transient traverse skipped */
	/* transient generate skipped */
	return soap_element_end_out(soap, tag);
}

void *wsp__Content::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_wsp__Content(soap, tag, this, type);
}

SOAP_FMAC3 wsp__Content * SOAP_FMAC4 soap_in_wsp__Content(struct soap *soap, const char *tag, wsp__Content *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (wsp__Content *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_wsp__Content, sizeof(wsp__Content), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_wsp__Content)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (wsp__Content *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_Policy1 = 1;
	size_t soap_flag_PolicyReference1 = 1;
	size_t soap_flag_sp__SignedElements1 = 1;
	size_t soap_flag_sp__EncryptedElements1 = 1;
	size_t soap_flag_sp__ContentEncryptedElements1 = 1;
	size_t soap_flag_sp__RequiredElements1 = 1;
	size_t soap_flag_sp__UsernameToken1 = 1;
	size_t soap_flag_sp__IssuedToken1 = 1;
	size_t soap_flag_sp__X509Token1 = 1;
	size_t soap_flag_sp__KerberosToken1 = 1;
	size_t soap_flag_sp__SpnegoContextToken1 = 1;
	size_t soap_flag_sp__SecurityContextToken1 = 1;
	size_t soap_flag_sp__SecureConversationToken1 = 1;
	size_t soap_flag_sp__SamlToken1 = 1;
	size_t soap_flag_sp__RelToken1 = 1;
	size_t soap_flag_sp__HttpsToken1 = 1;
	size_t soap_flag_sp__KeyValueToken1 = 1;
	size_t soap_flag_sp__TransportBinding1 = 1;
	size_t soap_flag_sp__TransportToken1 = 1;
	size_t soap_flag_sp__AlgorithmSuite1 = 1;
	size_t soap_flag_sp__Layout1 = 1;
	size_t soap_flag_sp__SymmetricBinding1 = 1;
	size_t soap_flag_sp__AsymmetricBinding1 = 1;
	size_t soap_flag_sp__ProtectionToken1 = 1;
	size_t soap_flag_sp__InitiatorToken1 = 1;
	size_t soap_flag_sp__InitiatorSignatureToken1 = 1;
	size_t soap_flag_sp__InitiatorEncryptionToken1 = 1;
	size_t soap_flag_sp__RecipientToken1 = 1;
	size_t soap_flag_sp__SupportingTokens1 = 1;
	size_t soap_flag_sp__SignedSupportingTokens1 = 1;
	size_t soap_flag_sp__EndorsingSupportingTokens1 = 1;
	size_t soap_flag_sp__SignedEndorsingSupportingTokens1 = 1;
	size_t soap_flag_sp__SignedEncryptedSupportingTokens1 = 1;
	size_t soap_flag_sp__EncryptedSupportingTokens1 = 1;
	size_t soap_flag_sp__EndorsingEncryptedSupportingTokens1 = 1;
	size_t soap_flag_sp__SignedEndorsingEncryptedSupportingTokens1 = 1;
	size_t soap_flag_sp__Wss101 = 1;
	size_t soap_flag_sp__Wss111 = 1;
	size_t soap_flag_sp__Trust131 = 1;
	size_t soap_flag_wsam__Addressing1 = 1;
	size_t soap_flag_wsrmp__RMAssertion_1 = 1;
	size_t soap_flag_wsrmp__DeliveryAssurance1 = 1;
	size_t soap_flag_wsrmp__AtLeastOnce1 = 1;
	size_t soap_flag_wsrmp__AtMostOnce1 = 1;
	size_t soap_flag_wsrmp__ExactlyOnce1 = 1;
	size_t soap_flag_wsrmp__InOrder1 = 1;
	size_t soap_flag_sp__NoPassword1 = 1;
	size_t soap_flag_sp__HashPassword1 = 1;
	size_t soap_flag_sp__IncludeTimestamp1 = 1;
	size_t soap_flag_sp__EncryptBeforeSigning1 = 1;
	size_t soap_flag_sp__EncryptSignature1 = 1;
	size_t soap_flag_sp__ProtectTokens1 = 1;
	size_t soap_flag_sp__OnlySignEntireHeadersAndBody1 = 1;
	size_t soap_flag_sp__RequireDerivedKeys1 = 1;
	size_t soap_flag_sp__RequireImpliedDerivedKeys1 = 1;
	size_t soap_flag_sp__RequireExplicitDerivedKeys1 = 1;
	size_t soap_flag_sp__WssUsernameToken101 = 1;
	size_t soap_flag_sp__WssUsernameToken111 = 1;
	size_t soap_flag_sp__RequireExternalReference1 = 1;
	size_t soap_flag_sp__RequireInternalReference1 = 1;
	size_t soap_flag_sp__RequireKeyIdentifierReference1 = 1;
	size_t soap_flag_sp__RequireIssuerSerialReference1 = 1;
	size_t soap_flag_sp__RequireEmbeddedTokenReference1 = 1;
	size_t soap_flag_sp__RequireThumbprintReference1 = 1;
	size_t soap_flag_sp__WssX509V3Token101 = 1;
	size_t soap_flag_sp__WssX509Pkcs7Token101 = 1;
	size_t soap_flag_sp__WssX509PkiPathV1Token101 = 1;
	size_t soap_flag_sp__WssX509V1Token111 = 1;
	size_t soap_flag_sp__WssX509V3Token111 = 1;
	size_t soap_flag_sp__WssX509Pkcs7Token111 = 1;
	size_t soap_flag_sp__WssX509PkiPathV1Token111 = 1;
	size_t soap_flag_sp__WssKerberosV5ApReqToken111 = 1;
	size_t soap_flag_sp__WssGssKerberosV5ApReqToken111 = 1;
	size_t soap_flag_sp__WssRelV10Token101 = 1;
	size_t soap_flag_sp__WssRelV20Token101 = 1;
	size_t soap_flag_sp__WssRelV10Token111 = 1;
	size_t soap_flag_sp__WssRelV20Token111 = 1;
	size_t soap_flag_sp__MustNotSendCancel1 = 1;
	size_t soap_flag_sp__MustNotSendAmend1 = 1;
	size_t soap_flag_sp__MustNotSendRenew1 = 1;
	size_t soap_flag_sp__MustSupportRefKeyIdentifier1 = 1;
	size_t soap_flag_sp__MustSupportRefIssuerSerial1 = 1;
	size_t soap_flag_sp__MustSupportRefExternalURI1 = 1;
	size_t soap_flag_sp__MustSupportRefEmbeddedToken1 = 1;
	size_t soap_flag_sp__MustSupportRefThumbprint1 = 1;
	size_t soap_flag_sp__MustSupportRefEncryptedKey1 = 1;
	size_t soap_flag_sp__RequireSignatureConfirmation1 = 1;
	size_t soap_flag_sp__MustSupportClientChallenge1 = 1;
	size_t soap_flag_sp__MustSupportServerChallenge1 = 1;
	size_t soap_flag_sp__RequireClientEntropy1 = 1;
	size_t soap_flag_sp__RequireServerEntropy1 = 1;
	size_t soap_flag_sp__MustSupportIssuedTokens1 = 1;
	size_t soap_flag_sp__RequireRequestSecurityTokenCollection1 = 1;
	size_t soap_flag_sp__RequireAppliesTo1 = 1;
	size_t soap_flag_sp__RequireExternalUriReference1 = 1;
	size_t soap_flag_sp__SC13SecurityContextToken1 = 1;
	size_t soap_flag_sp__Strict1 = 1;
	size_t soap_flag_sp__Lax1 = 1;
	size_t soap_flag_sp__LaxTsFirst1 = 1;
	size_t soap_flag_sp__LaxTsLast1 = 1;
	size_t soap_flag_sp__HttpBasicAuthentication1 = 1;
	size_t soap_flag_sp__HttpDigestAuthentication1 = 1;
	size_t soap_flag_sp__RequireClientCertificate1 = 1;
	size_t soap_flag_sp__Basic2561 = 1;
	size_t soap_flag_sp__Basic1921 = 1;
	size_t soap_flag_sp__Basic1281 = 1;
	size_t soap_flag_sp__TripleDes1 = 1;
	size_t soap_flag_sp__Basic256Rsa151 = 1;
	size_t soap_flag_sp__Basic192Rsa151 = 1;
	size_t soap_flag_sp__Basic128Rsa151 = 1;
	size_t soap_flag_sp__TripleDesRsa151 = 1;
	size_t soap_flag_sp__Basic256Sha2561 = 1;
	size_t soap_flag_sp__Basic192Sha2561 = 1;
	size_t soap_flag_sp__Basic128Sha2561 = 1;
	size_t soap_flag_sp__TripleDesSha2561 = 1;
	size_t soap_flag_sp__Basic256Sha256Rsa151 = 1;
	size_t soap_flag_sp__Basic192Sha256Rsa151 = 1;
	size_t soap_flag_sp__Basic128Sha256Rsa151 = 1;
	size_t soap_flag_sp__TripleDesSha256Rsa151 = 1;
	size_t soap_flag_sp__InclusiveC14N1 = 1;
	size_t soap_flag_sp__SOAPNormalization101 = 1;
	size_t soap_flag_sp__STRTransform101 = 1;
	size_t soap_flag_sp__Path101 = 1;
	size_t soap_flag_sp__XPathFilter201 = 1;
	size_t soap_flag_sp__AbsXPath1 = 1;
	size_t soap_flag_wsam__AnonymousResponses1 = 1;
	size_t soap_flag_wsam__NonAnonymousResponses1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Policy1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Policy(soap, "wsp:Policy", &(a->wsp__Content::Policy), "wsp:Policy"))
				{	soap_flag_Policy1--;
					continue;
				}
			if (soap_flag_PolicyReference1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__PolicyReference(soap, "wsp:PolicyReference", &(a->wsp__Content::PolicyReference), "wsp:PolicyReference"))
				{	soap_flag_PolicyReference1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerTowsp__Content(soap, "wsp:All", &(a->wsp__Content::All), "wsp:Content"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerTowsp__Content(soap, "wsp:ExactlyOne", &(a->wsp__Content::ExactlyOne), "wsp:Content"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfsp__Parts(soap, "sp:SignedParts", &(a->wsp__Content::sp__SignedParts), "sp:Parts"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfsp__Parts(soap, "sp:EncryptedParts", &(a->wsp__Content::sp__EncryptedParts), "sp:Parts"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfsp__Parts(soap, "sp:RequiredParts", &(a->wsp__Content::sp__RequiredParts), "sp:Parts"))
					continue;
			if (soap_flag_sp__SignedElements1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosp__Elements(soap, "sp:SignedElements", &(a->wsp__Content::sp__SignedElements), "sp:Elements"))
				{	soap_flag_sp__SignedElements1--;
					continue;
				}
			if (soap_flag_sp__EncryptedElements1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosp__Elements(soap, "sp:EncryptedElements", &(a->wsp__Content::sp__EncryptedElements), "sp:Elements"))
				{	soap_flag_sp__EncryptedElements1--;
					continue;
				}
			if (soap_flag_sp__ContentEncryptedElements1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosp__Elements(soap, "sp:ContentEncryptedElements", &(a->wsp__Content::sp__ContentEncryptedElements), "sp:Elements"))
				{	soap_flag_sp__ContentEncryptedElements1--;
					continue;
				}
			if (soap_flag_sp__RequiredElements1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosp__Elements(soap, "sp:RequiredElements", &(a->wsp__Content::sp__RequiredElements), "sp:Elements"))
				{	soap_flag_sp__RequiredElements1--;
					continue;
				}
			if (soap_flag_sp__UsernameToken1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosp__Token(soap, "sp:UsernameToken", &(a->wsp__Content::sp__UsernameToken), "sp:Token"))
				{	soap_flag_sp__UsernameToken1--;
					continue;
				}
			if (soap_flag_sp__IssuedToken1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosp__Token(soap, "sp:IssuedToken", &(a->wsp__Content::sp__IssuedToken), "sp:Token"))
				{	soap_flag_sp__IssuedToken1--;
					continue;
				}
			if (soap_flag_sp__X509Token1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosp__Token(soap, "sp:X509Token", &(a->wsp__Content::sp__X509Token), "sp:Token"))
				{	soap_flag_sp__X509Token1--;
					continue;
				}
			if (soap_flag_sp__KerberosToken1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosp__Token(soap, "sp:KerberosToken", &(a->wsp__Content::sp__KerberosToken), "sp:Token"))
				{	soap_flag_sp__KerberosToken1--;
					continue;
				}
			if (soap_flag_sp__SpnegoContextToken1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosp__Token(soap, "sp:SpnegoContextToken", &(a->wsp__Content::sp__SpnegoContextToken), "sp:Token"))
				{	soap_flag_sp__SpnegoContextToken1--;
					continue;
				}
			if (soap_flag_sp__SecurityContextToken1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosp__Token(soap, "sp:SecurityContextToken", &(a->wsp__Content::sp__SecurityContextToken), "sp:Token"))
				{	soap_flag_sp__SecurityContextToken1--;
					continue;
				}
			if (soap_flag_sp__SecureConversationToken1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosp__Token(soap, "sp:SecureConversationToken", &(a->wsp__Content::sp__SecureConversationToken), "sp:Token"))
				{	soap_flag_sp__SecureConversationToken1--;
					continue;
				}
			if (soap_flag_sp__SamlToken1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosp__Token(soap, "sp:SamlToken", &(a->wsp__Content::sp__SamlToken), "sp:Token"))
				{	soap_flag_sp__SamlToken1--;
					continue;
				}
			if (soap_flag_sp__RelToken1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosp__Token(soap, "sp:RelToken", &(a->wsp__Content::sp__RelToken), "sp:Token"))
				{	soap_flag_sp__RelToken1--;
					continue;
				}
			if (soap_flag_sp__HttpsToken1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosp__Token(soap, "sp:HttpsToken", &(a->wsp__Content::sp__HttpsToken), "sp:Token"))
				{	soap_flag_sp__HttpsToken1--;
					continue;
				}
			if (soap_flag_sp__KeyValueToken1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosp__Token(soap, "sp:KeyValueToken", &(a->wsp__Content::sp__KeyValueToken), "sp:Token"))
				{	soap_flag_sp__KeyValueToken1--;
					continue;
				}
			if (soap_flag_sp__TransportBinding1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:TransportBinding", &(a->wsp__Content::sp__TransportBinding), "wsp:Assertion"))
				{	soap_flag_sp__TransportBinding1--;
					continue;
				}
			if (soap_flag_sp__TransportToken1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:TransportToken", &(a->wsp__Content::sp__TransportToken), "wsp:Assertion"))
				{	soap_flag_sp__TransportToken1--;
					continue;
				}
			if (soap_flag_sp__AlgorithmSuite1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:AlgorithmSuite", &(a->wsp__Content::sp__AlgorithmSuite), "wsp:Assertion"))
				{	soap_flag_sp__AlgorithmSuite1--;
					continue;
				}
			if (soap_flag_sp__Layout1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:Layout", &(a->wsp__Content::sp__Layout), "wsp:Assertion"))
				{	soap_flag_sp__Layout1--;
					continue;
				}
			if (soap_flag_sp__SymmetricBinding1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:SymmetricBinding", &(a->wsp__Content::sp__SymmetricBinding), "wsp:Assertion"))
				{	soap_flag_sp__SymmetricBinding1--;
					continue;
				}
			if (soap_flag_sp__AsymmetricBinding1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:AsymmetricBinding", &(a->wsp__Content::sp__AsymmetricBinding), "wsp:Assertion"))
				{	soap_flag_sp__AsymmetricBinding1--;
					continue;
				}
			if (soap_flag_sp__ProtectionToken1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:ProtectionToken", &(a->wsp__Content::sp__ProtectionToken), "wsp:Assertion"))
				{	soap_flag_sp__ProtectionToken1--;
					continue;
				}
			if (soap_flag_sp__InitiatorToken1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:InitiatorToken", &(a->wsp__Content::sp__InitiatorToken), "wsp:Assertion"))
				{	soap_flag_sp__InitiatorToken1--;
					continue;
				}
			if (soap_flag_sp__InitiatorSignatureToken1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:InitiatorSignatureToken", &(a->wsp__Content::sp__InitiatorSignatureToken), "wsp:Assertion"))
				{	soap_flag_sp__InitiatorSignatureToken1--;
					continue;
				}
			if (soap_flag_sp__InitiatorEncryptionToken1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:InitiatorEncryptionToken", &(a->wsp__Content::sp__InitiatorEncryptionToken), "wsp:Assertion"))
				{	soap_flag_sp__InitiatorEncryptionToken1--;
					continue;
				}
			if (soap_flag_sp__RecipientToken1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:RecipientToken", &(a->wsp__Content::sp__RecipientToken), "wsp:Assertion"))
				{	soap_flag_sp__RecipientToken1--;
					continue;
				}
			if (soap_flag_sp__SupportingTokens1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:SupportingTokens", &(a->wsp__Content::sp__SupportingTokens), "wsp:Assertion"))
				{	soap_flag_sp__SupportingTokens1--;
					continue;
				}
			if (soap_flag_sp__SignedSupportingTokens1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:SignedSupportingTokens", &(a->wsp__Content::sp__SignedSupportingTokens), "wsp:Assertion"))
				{	soap_flag_sp__SignedSupportingTokens1--;
					continue;
				}
			if (soap_flag_sp__EndorsingSupportingTokens1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:EndorsingSupportingTokens", &(a->wsp__Content::sp__EndorsingSupportingTokens), "wsp:Assertion"))
				{	soap_flag_sp__EndorsingSupportingTokens1--;
					continue;
				}
			if (soap_flag_sp__SignedEndorsingSupportingTokens1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:SignedEndorsingSupportingTokens", &(a->wsp__Content::sp__SignedEndorsingSupportingTokens), "wsp:Assertion"))
				{	soap_flag_sp__SignedEndorsingSupportingTokens1--;
					continue;
				}
			if (soap_flag_sp__SignedEncryptedSupportingTokens1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:SignedEncryptedSupportingTokens", &(a->wsp__Content::sp__SignedEncryptedSupportingTokens), "wsp:Assertion"))
				{	soap_flag_sp__SignedEncryptedSupportingTokens1--;
					continue;
				}
			if (soap_flag_sp__EncryptedSupportingTokens1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:EncryptedSupportingTokens", &(a->wsp__Content::sp__EncryptedSupportingTokens), "wsp:Assertion"))
				{	soap_flag_sp__EncryptedSupportingTokens1--;
					continue;
				}
			if (soap_flag_sp__EndorsingEncryptedSupportingTokens1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:EndorsingEncryptedSupportingTokens", &(a->wsp__Content::sp__EndorsingEncryptedSupportingTokens), "wsp:Assertion"))
				{	soap_flag_sp__EndorsingEncryptedSupportingTokens1--;
					continue;
				}
			if (soap_flag_sp__SignedEndorsingEncryptedSupportingTokens1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:SignedEndorsingEncryptedSupportingTokens", &(a->wsp__Content::sp__SignedEndorsingEncryptedSupportingTokens), "wsp:Assertion"))
				{	soap_flag_sp__SignedEndorsingEncryptedSupportingTokens1--;
					continue;
				}
			if (soap_flag_sp__Wss101 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:Wss10", &(a->wsp__Content::sp__Wss10), "wsp:Assertion"))
				{	soap_flag_sp__Wss101--;
					continue;
				}
			if (soap_flag_sp__Wss111 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:Wss11", &(a->wsp__Content::sp__Wss11), "wsp:Assertion"))
				{	soap_flag_sp__Wss111--;
					continue;
				}
			if (soap_flag_sp__Trust131 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:Trust13", &(a->wsp__Content::sp__Trust13), "wsp:Assertion"))
				{	soap_flag_sp__Trust131--;
					continue;
				}
			if (soap_flag_wsam__Addressing1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "wsam:Addressing", &(a->wsp__Content::wsam__Addressing), "wsp:Assertion"))
				{	soap_flag_wsam__Addressing1--;
					continue;
				}
			if (soap_flag_wsrmp__RMAssertion_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsrmp__RMAssertion(soap, "wsrmp:RMAssertion", &(a->wsp__Content::wsrmp__RMAssertion_), "wsrmp:RMAssertion"))
				{	soap_flag_wsrmp__RMAssertion_1--;
					continue;
				}
			if (soap_flag_wsrmp__DeliveryAssurance1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsrmp__RMAssertion(soap, "wsrmp:DeliveryAssurance", &(a->wsp__Content::wsrmp__DeliveryAssurance), "wsrmp:RMAssertion"))
				{	soap_flag_wsrmp__DeliveryAssurance1--;
					continue;
				}
			if (soap_flag_wsrmp__AtLeastOnce1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "wsrmp:AtLeastOnce", &(a->wsp__Content::wsrmp__AtLeastOnce), "xsd:string"))
				{	soap_flag_wsrmp__AtLeastOnce1--;
					continue;
				}
			if (soap_flag_wsrmp__AtMostOnce1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "wsrmp:AtMostOnce", &(a->wsp__Content::wsrmp__AtMostOnce), "xsd:string"))
				{	soap_flag_wsrmp__AtMostOnce1--;
					continue;
				}
			if (soap_flag_wsrmp__ExactlyOnce1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "wsrmp:ExactlyOnce", &(a->wsp__Content::wsrmp__ExactlyOnce), "xsd:string"))
				{	soap_flag_wsrmp__ExactlyOnce1--;
					continue;
				}
			if (soap_flag_wsrmp__InOrder1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "wsrmp:InOrder", &(a->wsp__Content::wsrmp__InOrder), "xsd:string"))
				{	soap_flag_wsrmp__InOrder1--;
					continue;
				}
			if (soap_flag_sp__NoPassword1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:NoPassword", &(a->wsp__Content::sp__NoPassword), "wsp:Assertion"))
				{	soap_flag_sp__NoPassword1--;
					continue;
				}
			if (soap_flag_sp__HashPassword1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:HashPassword", &(a->wsp__Content::sp__HashPassword), "wsp:Assertion"))
				{	soap_flag_sp__HashPassword1--;
					continue;
				}
			if (soap_flag_sp__IncludeTimestamp1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:IncludeTimestamp", &(a->wsp__Content::sp__IncludeTimestamp), "wsp:Assertion"))
				{	soap_flag_sp__IncludeTimestamp1--;
					continue;
				}
			if (soap_flag_sp__EncryptBeforeSigning1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:EncryptBeforeSigning", &(a->wsp__Content::sp__EncryptBeforeSigning), "wsp:Assertion"))
				{	soap_flag_sp__EncryptBeforeSigning1--;
					continue;
				}
			if (soap_flag_sp__EncryptSignature1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:EncryptSignature", &(a->wsp__Content::sp__EncryptSignature), "wsp:Assertion"))
				{	soap_flag_sp__EncryptSignature1--;
					continue;
				}
			if (soap_flag_sp__ProtectTokens1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:ProtectTokens", &(a->wsp__Content::sp__ProtectTokens), "wsp:Assertion"))
				{	soap_flag_sp__ProtectTokens1--;
					continue;
				}
			if (soap_flag_sp__OnlySignEntireHeadersAndBody1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:OnlySignEntireHeadersAndBody", &(a->wsp__Content::sp__OnlySignEntireHeadersAndBody), "wsp:Assertion"))
				{	soap_flag_sp__OnlySignEntireHeadersAndBody1--;
					continue;
				}
			if (soap_flag_sp__RequireDerivedKeys1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:RequireDerivedKeys", &(a->wsp__Content::sp__RequireDerivedKeys), "xsd:string"))
				{	soap_flag_sp__RequireDerivedKeys1--;
					continue;
				}
			if (soap_flag_sp__RequireImpliedDerivedKeys1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:RequireImpliedDerivedKeys", &(a->wsp__Content::sp__RequireImpliedDerivedKeys), "xsd:string"))
				{	soap_flag_sp__RequireImpliedDerivedKeys1--;
					continue;
				}
			if (soap_flag_sp__RequireExplicitDerivedKeys1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:RequireExplicitDerivedKeys", &(a->wsp__Content::sp__RequireExplicitDerivedKeys), "xsd:string"))
				{	soap_flag_sp__RequireExplicitDerivedKeys1--;
					continue;
				}
			if (soap_flag_sp__WssUsernameToken101 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:WssUsernameToken10", &(a->wsp__Content::sp__WssUsernameToken10), "xsd:string"))
				{	soap_flag_sp__WssUsernameToken101--;
					continue;
				}
			if (soap_flag_sp__WssUsernameToken111 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:WssUsernameToken11", &(a->wsp__Content::sp__WssUsernameToken11), "xsd:string"))
				{	soap_flag_sp__WssUsernameToken111--;
					continue;
				}
			if (soap_flag_sp__RequireExternalReference1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:RequireExternalReference", &(a->wsp__Content::sp__RequireExternalReference), "xsd:string"))
				{	soap_flag_sp__RequireExternalReference1--;
					continue;
				}
			if (soap_flag_sp__RequireInternalReference1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:RequireInternalReference", &(a->wsp__Content::sp__RequireInternalReference), "xsd:string"))
				{	soap_flag_sp__RequireInternalReference1--;
					continue;
				}
			if (soap_flag_sp__RequireKeyIdentifierReference1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:RequireKeyIdentifierReference", &(a->wsp__Content::sp__RequireKeyIdentifierReference), "xsd:string"))
				{	soap_flag_sp__RequireKeyIdentifierReference1--;
					continue;
				}
			if (soap_flag_sp__RequireIssuerSerialReference1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:RequireIssuerSerialReference", &(a->wsp__Content::sp__RequireIssuerSerialReference), "xsd:string"))
				{	soap_flag_sp__RequireIssuerSerialReference1--;
					continue;
				}
			if (soap_flag_sp__RequireEmbeddedTokenReference1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:RequireEmbeddedTokenReference", &(a->wsp__Content::sp__RequireEmbeddedTokenReference), "xsd:string"))
				{	soap_flag_sp__RequireEmbeddedTokenReference1--;
					continue;
				}
			if (soap_flag_sp__RequireThumbprintReference1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:RequireThumbprintReference", &(a->wsp__Content::sp__RequireThumbprintReference), "xsd:string"))
				{	soap_flag_sp__RequireThumbprintReference1--;
					continue;
				}
			if (soap_flag_sp__WssX509V3Token101 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:WssX509V3Token10", &(a->wsp__Content::sp__WssX509V3Token10), "xsd:string"))
				{	soap_flag_sp__WssX509V3Token101--;
					continue;
				}
			if (soap_flag_sp__WssX509Pkcs7Token101 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:WssX509Pkcs7Token10", &(a->wsp__Content::sp__WssX509Pkcs7Token10), "xsd:string"))
				{	soap_flag_sp__WssX509Pkcs7Token101--;
					continue;
				}
			if (soap_flag_sp__WssX509PkiPathV1Token101 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:WssX509PkiPathV1Token10", &(a->wsp__Content::sp__WssX509PkiPathV1Token10), "xsd:string"))
				{	soap_flag_sp__WssX509PkiPathV1Token101--;
					continue;
				}
			if (soap_flag_sp__WssX509V1Token111 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:WssX509V1Token11", &(a->wsp__Content::sp__WssX509V1Token11), "xsd:string"))
				{	soap_flag_sp__WssX509V1Token111--;
					continue;
				}
			if (soap_flag_sp__WssX509V3Token111 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:WssX509V3Token11", &(a->wsp__Content::sp__WssX509V3Token11), "xsd:string"))
				{	soap_flag_sp__WssX509V3Token111--;
					continue;
				}
			if (soap_flag_sp__WssX509Pkcs7Token111 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:WssX509Pkcs7Token11", &(a->wsp__Content::sp__WssX509Pkcs7Token11), "xsd:string"))
				{	soap_flag_sp__WssX509Pkcs7Token111--;
					continue;
				}
			if (soap_flag_sp__WssX509PkiPathV1Token111 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:WssX509PkiPathV1Token11", &(a->wsp__Content::sp__WssX509PkiPathV1Token11), "xsd:string"))
				{	soap_flag_sp__WssX509PkiPathV1Token111--;
					continue;
				}
			if (soap_flag_sp__WssKerberosV5ApReqToken111 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:WssKerberosV5ApReqToken11", &(a->wsp__Content::sp__WssKerberosV5ApReqToken11), "xsd:string"))
				{	soap_flag_sp__WssKerberosV5ApReqToken111--;
					continue;
				}
			if (soap_flag_sp__WssGssKerberosV5ApReqToken111 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:WssGssKerberosV5ApReqToken11", &(a->wsp__Content::sp__WssGssKerberosV5ApReqToken11), "xsd:string"))
				{	soap_flag_sp__WssGssKerberosV5ApReqToken111--;
					continue;
				}
			if (soap_flag_sp__WssRelV10Token101 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:WssRelV10Token10", &(a->wsp__Content::sp__WssRelV10Token10), "xsd:string"))
				{	soap_flag_sp__WssRelV10Token101--;
					continue;
				}
			if (soap_flag_sp__WssRelV20Token101 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:WssRelV20Token10", &(a->wsp__Content::sp__WssRelV20Token10), "xsd:string"))
				{	soap_flag_sp__WssRelV20Token101--;
					continue;
				}
			if (soap_flag_sp__WssRelV10Token111 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:WssRelV10Token11", &(a->wsp__Content::sp__WssRelV10Token11), "xsd:string"))
				{	soap_flag_sp__WssRelV10Token111--;
					continue;
				}
			if (soap_flag_sp__WssRelV20Token111 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:WssRelV20Token11", &(a->wsp__Content::sp__WssRelV20Token11), "xsd:string"))
				{	soap_flag_sp__WssRelV20Token111--;
					continue;
				}
			if (soap_flag_sp__MustNotSendCancel1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:MustNotSendCancel", &(a->wsp__Content::sp__MustNotSendCancel), "xsd:string"))
				{	soap_flag_sp__MustNotSendCancel1--;
					continue;
				}
			if (soap_flag_sp__MustNotSendAmend1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:MustNotSendAmend", &(a->wsp__Content::sp__MustNotSendAmend), "xsd:string"))
				{	soap_flag_sp__MustNotSendAmend1--;
					continue;
				}
			if (soap_flag_sp__MustNotSendRenew1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:MustNotSendRenew", &(a->wsp__Content::sp__MustNotSendRenew), "xsd:string"))
				{	soap_flag_sp__MustNotSendRenew1--;
					continue;
				}
			if (soap_flag_sp__MustSupportRefKeyIdentifier1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:MustSupportRefKeyIdentifier", &(a->wsp__Content::sp__MustSupportRefKeyIdentifier), "xsd:string"))
				{	soap_flag_sp__MustSupportRefKeyIdentifier1--;
					continue;
				}
			if (soap_flag_sp__MustSupportRefIssuerSerial1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:MustSupportRefIssuerSerial", &(a->wsp__Content::sp__MustSupportRefIssuerSerial), "xsd:string"))
				{	soap_flag_sp__MustSupportRefIssuerSerial1--;
					continue;
				}
			if (soap_flag_sp__MustSupportRefExternalURI1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:MustSupportRefExternalURI", &(a->wsp__Content::sp__MustSupportRefExternalURI), "xsd:string"))
				{	soap_flag_sp__MustSupportRefExternalURI1--;
					continue;
				}
			if (soap_flag_sp__MustSupportRefEmbeddedToken1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:MustSupportRefEmbeddedToken", &(a->wsp__Content::sp__MustSupportRefEmbeddedToken), "xsd:string"))
				{	soap_flag_sp__MustSupportRefEmbeddedToken1--;
					continue;
				}
			if (soap_flag_sp__MustSupportRefThumbprint1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:MustSupportRefThumbprint", &(a->wsp__Content::sp__MustSupportRefThumbprint), "xsd:string"))
				{	soap_flag_sp__MustSupportRefThumbprint1--;
					continue;
				}
			if (soap_flag_sp__MustSupportRefEncryptedKey1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:MustSupportRefEncryptedKey", &(a->wsp__Content::sp__MustSupportRefEncryptedKey), "xsd:string"))
				{	soap_flag_sp__MustSupportRefEncryptedKey1--;
					continue;
				}
			if (soap_flag_sp__RequireSignatureConfirmation1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:RequireSignatureConfirmation", &(a->wsp__Content::sp__RequireSignatureConfirmation), "xsd:string"))
				{	soap_flag_sp__RequireSignatureConfirmation1--;
					continue;
				}
			if (soap_flag_sp__MustSupportClientChallenge1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:MustSupportClientChallenge", &(a->wsp__Content::sp__MustSupportClientChallenge), "xsd:string"))
				{	soap_flag_sp__MustSupportClientChallenge1--;
					continue;
				}
			if (soap_flag_sp__MustSupportServerChallenge1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:MustSupportServerChallenge", &(a->wsp__Content::sp__MustSupportServerChallenge), "xsd:string"))
				{	soap_flag_sp__MustSupportServerChallenge1--;
					continue;
				}
			if (soap_flag_sp__RequireClientEntropy1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:RequireClientEntropy", &(a->wsp__Content::sp__RequireClientEntropy), "xsd:string"))
				{	soap_flag_sp__RequireClientEntropy1--;
					continue;
				}
			if (soap_flag_sp__RequireServerEntropy1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:RequireServerEntropy", &(a->wsp__Content::sp__RequireServerEntropy), "xsd:string"))
				{	soap_flag_sp__RequireServerEntropy1--;
					continue;
				}
			if (soap_flag_sp__MustSupportIssuedTokens1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:MustSupportIssuedTokens", &(a->wsp__Content::sp__MustSupportIssuedTokens), "xsd:string"))
				{	soap_flag_sp__MustSupportIssuedTokens1--;
					continue;
				}
			if (soap_flag_sp__RequireRequestSecurityTokenCollection1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:RequireRequestSecurityTokenCollection", &(a->wsp__Content::sp__RequireRequestSecurityTokenCollection), "xsd:string"))
				{	soap_flag_sp__RequireRequestSecurityTokenCollection1--;
					continue;
				}
			if (soap_flag_sp__RequireAppliesTo1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:RequireAppliesTo", &(a->wsp__Content::sp__RequireAppliesTo), "xsd:string"))
				{	soap_flag_sp__RequireAppliesTo1--;
					continue;
				}
			if (soap_flag_sp__RequireExternalUriReference1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:RequireExternalUriReference", &(a->wsp__Content::sp__RequireExternalUriReference), "xsd:string"))
				{	soap_flag_sp__RequireExternalUriReference1--;
					continue;
				}
			if (soap_flag_sp__SC13SecurityContextToken1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:SC13SecurityContextToken", &(a->wsp__Content::sp__SC13SecurityContextToken), "xsd:string"))
				{	soap_flag_sp__SC13SecurityContextToken1--;
					continue;
				}
			if (soap_flag_sp__Strict1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:Strict", &(a->wsp__Content::sp__Strict), "xsd:string"))
				{	soap_flag_sp__Strict1--;
					continue;
				}
			if (soap_flag_sp__Lax1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:Lax", &(a->wsp__Content::sp__Lax), "xsd:string"))
				{	soap_flag_sp__Lax1--;
					continue;
				}
			if (soap_flag_sp__LaxTsFirst1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:LaxTsFirst", &(a->wsp__Content::sp__LaxTsFirst), "xsd:string"))
				{	soap_flag_sp__LaxTsFirst1--;
					continue;
				}
			if (soap_flag_sp__LaxTsLast1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:LaxTsLast", &(a->wsp__Content::sp__LaxTsLast), "xsd:string"))
				{	soap_flag_sp__LaxTsLast1--;
					continue;
				}
			if (soap_flag_sp__HttpBasicAuthentication1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:HttpBasicAuthentication", &(a->wsp__Content::sp__HttpBasicAuthentication), "xsd:string"))
				{	soap_flag_sp__HttpBasicAuthentication1--;
					continue;
				}
			if (soap_flag_sp__HttpDigestAuthentication1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:HttpDigestAuthentication", &(a->wsp__Content::sp__HttpDigestAuthentication), "xsd:string"))
				{	soap_flag_sp__HttpDigestAuthentication1--;
					continue;
				}
			if (soap_flag_sp__RequireClientCertificate1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:RequireClientCertificate", &(a->wsp__Content::sp__RequireClientCertificate), "xsd:string"))
				{	soap_flag_sp__RequireClientCertificate1--;
					continue;
				}
			if (soap_flag_sp__Basic2561 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:Basic256", &(a->wsp__Content::sp__Basic256), "xsd:string"))
				{	soap_flag_sp__Basic2561--;
					continue;
				}
			if (soap_flag_sp__Basic1921 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:Basic192", &(a->wsp__Content::sp__Basic192), "xsd:string"))
				{	soap_flag_sp__Basic1921--;
					continue;
				}
			if (soap_flag_sp__Basic1281 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:Basic128", &(a->wsp__Content::sp__Basic128), "xsd:string"))
				{	soap_flag_sp__Basic1281--;
					continue;
				}
			if (soap_flag_sp__TripleDes1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:TripleDes", &(a->wsp__Content::sp__TripleDes), "xsd:string"))
				{	soap_flag_sp__TripleDes1--;
					continue;
				}
			if (soap_flag_sp__Basic256Rsa151 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:Basic256Rsa15", &(a->wsp__Content::sp__Basic256Rsa15), "xsd:string"))
				{	soap_flag_sp__Basic256Rsa151--;
					continue;
				}
			if (soap_flag_sp__Basic192Rsa151 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:Basic192Rsa15", &(a->wsp__Content::sp__Basic192Rsa15), "xsd:string"))
				{	soap_flag_sp__Basic192Rsa151--;
					continue;
				}
			if (soap_flag_sp__Basic128Rsa151 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:Basic128Rsa15", &(a->wsp__Content::sp__Basic128Rsa15), "xsd:string"))
				{	soap_flag_sp__Basic128Rsa151--;
					continue;
				}
			if (soap_flag_sp__TripleDesRsa151 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:TripleDesRsa15", &(a->wsp__Content::sp__TripleDesRsa15), "xsd:string"))
				{	soap_flag_sp__TripleDesRsa151--;
					continue;
				}
			if (soap_flag_sp__Basic256Sha2561 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:Basic256Sha256", &(a->wsp__Content::sp__Basic256Sha256), "xsd:string"))
				{	soap_flag_sp__Basic256Sha2561--;
					continue;
				}
			if (soap_flag_sp__Basic192Sha2561 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:Basic192Sha256", &(a->wsp__Content::sp__Basic192Sha256), "xsd:string"))
				{	soap_flag_sp__Basic192Sha2561--;
					continue;
				}
			if (soap_flag_sp__Basic128Sha2561 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:Basic128Sha256", &(a->wsp__Content::sp__Basic128Sha256), "xsd:string"))
				{	soap_flag_sp__Basic128Sha2561--;
					continue;
				}
			if (soap_flag_sp__TripleDesSha2561 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:TripleDesSha256", &(a->wsp__Content::sp__TripleDesSha256), "xsd:string"))
				{	soap_flag_sp__TripleDesSha2561--;
					continue;
				}
			if (soap_flag_sp__Basic256Sha256Rsa151 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:Basic256Sha256Rsa15", &(a->wsp__Content::sp__Basic256Sha256Rsa15), "xsd:string"))
				{	soap_flag_sp__Basic256Sha256Rsa151--;
					continue;
				}
			if (soap_flag_sp__Basic192Sha256Rsa151 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:Basic192Sha256Rsa15", &(a->wsp__Content::sp__Basic192Sha256Rsa15), "xsd:string"))
				{	soap_flag_sp__Basic192Sha256Rsa151--;
					continue;
				}
			if (soap_flag_sp__Basic128Sha256Rsa151 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:Basic128Sha256Rsa15", &(a->wsp__Content::sp__Basic128Sha256Rsa15), "xsd:string"))
				{	soap_flag_sp__Basic128Sha256Rsa151--;
					continue;
				}
			if (soap_flag_sp__TripleDesSha256Rsa151 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:TripleDesSha256Rsa15", &(a->wsp__Content::sp__TripleDesSha256Rsa15), "xsd:string"))
				{	soap_flag_sp__TripleDesSha256Rsa151--;
					continue;
				}
			if (soap_flag_sp__InclusiveC14N1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:InclusiveC14N", &(a->wsp__Content::sp__InclusiveC14N), "xsd:string"))
				{	soap_flag_sp__InclusiveC14N1--;
					continue;
				}
			if (soap_flag_sp__SOAPNormalization101 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:SOAPNormalization10", &(a->wsp__Content::sp__SOAPNormalization10), "xsd:string"))
				{	soap_flag_sp__SOAPNormalization101--;
					continue;
				}
			if (soap_flag_sp__STRTransform101 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:STRTransform10", &(a->wsp__Content::sp__STRTransform10), "xsd:string"))
				{	soap_flag_sp__STRTransform101--;
					continue;
				}
			if (soap_flag_sp__Path101 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:Path10", &(a->wsp__Content::sp__Path10), "xsd:string"))
				{	soap_flag_sp__Path101--;
					continue;
				}
			if (soap_flag_sp__XPathFilter201 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:XPathFilter20", &(a->wsp__Content::sp__XPathFilter20), "xsd:string"))
				{	soap_flag_sp__XPathFilter201--;
					continue;
				}
			if (soap_flag_sp__AbsXPath1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:AbsXPath", &(a->wsp__Content::sp__AbsXPath), "xsd:string"))
				{	soap_flag_sp__AbsXPath1--;
					continue;
				}
			if (soap_flag_wsam__AnonymousResponses1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "wsam:AnonymousResponses", &(a->wsp__Content::wsam__AnonymousResponses), "xsd:string"))
				{	soap_flag_wsam__AnonymousResponses1--;
					continue;
				}
			if (soap_flag_wsam__NonAnonymousResponses1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "wsam:NonAnonymousResponses", &(a->wsp__Content::wsam__NonAnonymousResponses), "xsd:string"))
				{	soap_flag_wsam__NonAnonymousResponses1--;
					continue;
				}
			/* transient traverse skipped */
			/* transient generate skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOf_XML(soap, "-any", &(a->wsp__Content::__any), ""))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (wsp__Content *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsp__Content, 0, sizeof(wsp__Content), 0, soap_copy_wsp__Content);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int wsp__Content::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_wsp__Content);
	if (this->soap_out(soap, tag?tag:"wsp:Content", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *wsp__Content::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_wsp__Content(soap, this, tag, type);
}

SOAP_FMAC3 wsp__Content * SOAP_FMAC4 soap_get_wsp__Content(struct soap *soap, wsp__Content *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsp__Content(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 wsp__Content * SOAP_FMAC2 soap_instantiate_wsp__Content(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsp__Content(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsp__Content, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (type && !soap_match_tag(soap, type, "wsp:Policy"))
	{	cp->type = SOAP_TYPE_wsp__Policy;
		if (n < 0)
		{	cp->ptr = (void*)SOAP_NEW(wsp__Policy);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(wsp__Policy);
		}
		else
		{	cp->ptr = (void*)SOAP_NEW(wsp__Policy[n]);
			if (size)
				*size = n * sizeof(wsp__Policy);
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (wsp__Policy*)cp->ptr;
	}
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(wsp__Content);
		if (size)
			*size = sizeof(wsp__Content);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(wsp__Content[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(wsp__Content);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (wsp__Content*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsp__Content(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying wsp__Content %p -> %p\n", q, p));
	*(wsp__Content*)p = *(wsp__Content*)q;
}

void wsp__Policy::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__anyURI(soap, &this->wsp__Policy::xml__base);
	soap_default_xsd__string(soap, &this->wsp__Policy::wsu__Id);
	soap_default_xsd__anyURI(soap, &this->wsp__Policy::TargetNamespace);
	this->wsp__Content::Policy = NULL;
	this->wsp__Content::PolicyReference = NULL;
	soap_default_std__vectorTemplateOfPointerTowsp__Content(soap, &this->wsp__Content::All);
	soap_default_std__vectorTemplateOfPointerTowsp__Content(soap, &this->wsp__Content::ExactlyOne);
	soap_default_std__vectorTemplateOfsp__Parts(soap, &this->wsp__Content::sp__SignedParts);
	soap_default_std__vectorTemplateOfsp__Parts(soap, &this->wsp__Content::sp__EncryptedParts);
	soap_default_std__vectorTemplateOfsp__Parts(soap, &this->wsp__Content::sp__RequiredParts);
	this->wsp__Content::sp__SignedElements = NULL;
	this->wsp__Content::sp__EncryptedElements = NULL;
	this->wsp__Content::sp__ContentEncryptedElements = NULL;
	this->wsp__Content::sp__RequiredElements = NULL;
	this->wsp__Content::sp__UsernameToken = NULL;
	this->wsp__Content::sp__IssuedToken = NULL;
	this->wsp__Content::sp__X509Token = NULL;
	this->wsp__Content::sp__KerberosToken = NULL;
	this->wsp__Content::sp__SpnegoContextToken = NULL;
	this->wsp__Content::sp__SecurityContextToken = NULL;
	this->wsp__Content::sp__SecureConversationToken = NULL;
	this->wsp__Content::sp__SamlToken = NULL;
	this->wsp__Content::sp__RelToken = NULL;
	this->wsp__Content::sp__HttpsToken = NULL;
	this->wsp__Content::sp__KeyValueToken = NULL;
	this->wsp__Content::sp__TransportBinding = NULL;
	this->wsp__Content::sp__TransportToken = NULL;
	this->wsp__Content::sp__AlgorithmSuite = NULL;
	this->wsp__Content::sp__Layout = NULL;
	this->wsp__Content::sp__SymmetricBinding = NULL;
	this->wsp__Content::sp__AsymmetricBinding = NULL;
	this->wsp__Content::sp__ProtectionToken = NULL;
	this->wsp__Content::sp__InitiatorToken = NULL;
	this->wsp__Content::sp__InitiatorSignatureToken = NULL;
	this->wsp__Content::sp__InitiatorEncryptionToken = NULL;
	this->wsp__Content::sp__RecipientToken = NULL;
	this->wsp__Content::sp__SupportingTokens = NULL;
	this->wsp__Content::sp__SignedSupportingTokens = NULL;
	this->wsp__Content::sp__EndorsingSupportingTokens = NULL;
	this->wsp__Content::sp__SignedEndorsingSupportingTokens = NULL;
	this->wsp__Content::sp__SignedEncryptedSupportingTokens = NULL;
	this->wsp__Content::sp__EncryptedSupportingTokens = NULL;
	this->wsp__Content::sp__EndorsingEncryptedSupportingTokens = NULL;
	this->wsp__Content::sp__SignedEndorsingEncryptedSupportingTokens = NULL;
	this->wsp__Content::sp__Wss10 = NULL;
	this->wsp__Content::sp__Wss11 = NULL;
	this->wsp__Content::sp__Trust13 = NULL;
	this->wsp__Content::wsam__Addressing = NULL;
	this->wsp__Content::wsrmp__RMAssertion_ = NULL;
	this->wsp__Content::wsrmp__DeliveryAssurance = NULL;
	soap_default_xsd__string(soap, &this->wsp__Content::wsrmp__AtLeastOnce);
	soap_default_xsd__string(soap, &this->wsp__Content::wsrmp__AtMostOnce);
	soap_default_xsd__string(soap, &this->wsp__Content::wsrmp__ExactlyOnce);
	soap_default_xsd__string(soap, &this->wsp__Content::wsrmp__InOrder);
	this->wsp__Content::sp__NoPassword = NULL;
	this->wsp__Content::sp__HashPassword = NULL;
	this->wsp__Content::sp__IncludeTimestamp = NULL;
	this->wsp__Content::sp__EncryptBeforeSigning = NULL;
	this->wsp__Content::sp__EncryptSignature = NULL;
	this->wsp__Content::sp__ProtectTokens = NULL;
	this->wsp__Content::sp__OnlySignEntireHeadersAndBody = NULL;
	soap_default_xsd__string(soap, &this->wsp__Content::sp__RequireDerivedKeys);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__RequireImpliedDerivedKeys);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__RequireExplicitDerivedKeys);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__WssUsernameToken10);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__WssUsernameToken11);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__RequireExternalReference);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__RequireInternalReference);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__RequireKeyIdentifierReference);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__RequireIssuerSerialReference);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__RequireEmbeddedTokenReference);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__RequireThumbprintReference);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__WssX509V3Token10);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__WssX509Pkcs7Token10);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__WssX509PkiPathV1Token10);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__WssX509V1Token11);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__WssX509V3Token11);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__WssX509Pkcs7Token11);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__WssX509PkiPathV1Token11);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__WssKerberosV5ApReqToken11);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__WssGssKerberosV5ApReqToken11);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__WssRelV10Token10);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__WssRelV20Token10);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__WssRelV10Token11);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__WssRelV20Token11);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__MustNotSendCancel);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__MustNotSendAmend);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__MustNotSendRenew);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__MustSupportRefKeyIdentifier);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__MustSupportRefIssuerSerial);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__MustSupportRefExternalURI);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__MustSupportRefEmbeddedToken);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__MustSupportRefThumbprint);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__MustSupportRefEncryptedKey);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__RequireSignatureConfirmation);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__MustSupportClientChallenge);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__MustSupportServerChallenge);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__RequireClientEntropy);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__RequireServerEntropy);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__MustSupportIssuedTokens);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__RequireRequestSecurityTokenCollection);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__RequireAppliesTo);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__RequireExternalUriReference);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__SC13SecurityContextToken);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__Strict);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__Lax);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__LaxTsFirst);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__LaxTsLast);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__HttpBasicAuthentication);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__HttpDigestAuthentication);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__RequireClientCertificate);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__Basic256);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__Basic192);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__Basic128);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__TripleDes);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__Basic256Rsa15);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__Basic192Rsa15);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__Basic128Rsa15);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__TripleDesRsa15);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__Basic256Sha256);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__Basic192Sha256);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__Basic128Sha256);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__TripleDesSha256);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__Basic256Sha256Rsa15);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__Basic192Sha256Rsa15);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__Basic128Sha256Rsa15);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__TripleDesSha256Rsa15);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__InclusiveC14N);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__SOAPNormalization10);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__STRTransform10);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__Path10);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__XPathFilter20);
	soap_default_xsd__string(soap, &this->wsp__Content::sp__AbsXPath);
	soap_default_xsd__string(soap, &this->wsp__Content::wsam__AnonymousResponses);
	soap_default_xsd__string(soap, &this->wsp__Content::wsam__NonAnonymousResponses);
	soap_default_std__vectorTemplateOf_XML(soap, &this->wsp__Content::__any);
}

void wsp__Policy::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTowsp__Policy(soap, &this->wsp__Content::Policy);
	soap_serialize_PointerTowsp__PolicyReference(soap, &this->wsp__Content::PolicyReference);
	soap_serialize_std__vectorTemplateOfPointerTowsp__Content(soap, &this->wsp__Content::All);
	soap_serialize_std__vectorTemplateOfPointerTowsp__Content(soap, &this->wsp__Content::ExactlyOne);
	soap_serialize_std__vectorTemplateOfsp__Parts(soap, &this->wsp__Content::sp__SignedParts);
	soap_serialize_std__vectorTemplateOfsp__Parts(soap, &this->wsp__Content::sp__EncryptedParts);
	soap_serialize_std__vectorTemplateOfsp__Parts(soap, &this->wsp__Content::sp__RequiredParts);
	soap_serialize_PointerTosp__Elements(soap, &this->wsp__Content::sp__SignedElements);
	soap_serialize_PointerTosp__Elements(soap, &this->wsp__Content::sp__EncryptedElements);
	soap_serialize_PointerTosp__Elements(soap, &this->wsp__Content::sp__ContentEncryptedElements);
	soap_serialize_PointerTosp__Elements(soap, &this->wsp__Content::sp__RequiredElements);
	soap_serialize_PointerTosp__Token(soap, &this->wsp__Content::sp__UsernameToken);
	soap_serialize_PointerTosp__Token(soap, &this->wsp__Content::sp__IssuedToken);
	soap_serialize_PointerTosp__Token(soap, &this->wsp__Content::sp__X509Token);
	soap_serialize_PointerTosp__Token(soap, &this->wsp__Content::sp__KerberosToken);
	soap_serialize_PointerTosp__Token(soap, &this->wsp__Content::sp__SpnegoContextToken);
	soap_serialize_PointerTosp__Token(soap, &this->wsp__Content::sp__SecurityContextToken);
	soap_serialize_PointerTosp__Token(soap, &this->wsp__Content::sp__SecureConversationToken);
	soap_serialize_PointerTosp__Token(soap, &this->wsp__Content::sp__SamlToken);
	soap_serialize_PointerTosp__Token(soap, &this->wsp__Content::sp__RelToken);
	soap_serialize_PointerTosp__Token(soap, &this->wsp__Content::sp__HttpsToken);
	soap_serialize_PointerTosp__Token(soap, &this->wsp__Content::sp__KeyValueToken);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__TransportBinding);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__TransportToken);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__AlgorithmSuite);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__Layout);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__SymmetricBinding);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__AsymmetricBinding);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__ProtectionToken);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__InitiatorToken);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__InitiatorSignatureToken);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__InitiatorEncryptionToken);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__RecipientToken);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__SupportingTokens);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__SignedSupportingTokens);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__EndorsingSupportingTokens);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__SignedEndorsingSupportingTokens);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__SignedEncryptedSupportingTokens);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__EncryptedSupportingTokens);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__EndorsingEncryptedSupportingTokens);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__SignedEndorsingEncryptedSupportingTokens);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__Wss10);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__Wss11);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__Trust13);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::wsam__Addressing);
	soap_serialize_PointerTowsrmp__RMAssertion(soap, &this->wsp__Content::wsrmp__RMAssertion_);
	soap_serialize_PointerTowsrmp__RMAssertion(soap, &this->wsp__Content::wsrmp__DeliveryAssurance);
	soap_serialize_xsd__string(soap, &this->wsp__Content::wsrmp__AtLeastOnce);
	soap_serialize_xsd__string(soap, &this->wsp__Content::wsrmp__AtMostOnce);
	soap_serialize_xsd__string(soap, &this->wsp__Content::wsrmp__ExactlyOnce);
	soap_serialize_xsd__string(soap, &this->wsp__Content::wsrmp__InOrder);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__NoPassword);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__HashPassword);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__IncludeTimestamp);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__EncryptBeforeSigning);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__EncryptSignature);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__ProtectTokens);
	soap_serialize_PointerTowsp__Assertion(soap, &this->wsp__Content::sp__OnlySignEntireHeadersAndBody);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__RequireDerivedKeys);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__RequireImpliedDerivedKeys);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__RequireExplicitDerivedKeys);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__WssUsernameToken10);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__WssUsernameToken11);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__RequireExternalReference);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__RequireInternalReference);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__RequireKeyIdentifierReference);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__RequireIssuerSerialReference);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__RequireEmbeddedTokenReference);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__RequireThumbprintReference);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__WssX509V3Token10);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__WssX509Pkcs7Token10);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__WssX509PkiPathV1Token10);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__WssX509V1Token11);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__WssX509V3Token11);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__WssX509Pkcs7Token11);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__WssX509PkiPathV1Token11);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__WssKerberosV5ApReqToken11);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__WssGssKerberosV5ApReqToken11);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__WssRelV10Token10);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__WssRelV20Token10);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__WssRelV10Token11);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__WssRelV20Token11);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__MustNotSendCancel);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__MustNotSendAmend);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__MustNotSendRenew);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__MustSupportRefKeyIdentifier);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__MustSupportRefIssuerSerial);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__MustSupportRefExternalURI);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__MustSupportRefEmbeddedToken);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__MustSupportRefThumbprint);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__MustSupportRefEncryptedKey);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__RequireSignatureConfirmation);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__MustSupportClientChallenge);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__MustSupportServerChallenge);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__RequireClientEntropy);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__RequireServerEntropy);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__MustSupportIssuedTokens);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__RequireRequestSecurityTokenCollection);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__RequireAppliesTo);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__RequireExternalUriReference);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__SC13SecurityContextToken);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__Strict);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__Lax);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__LaxTsFirst);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__LaxTsLast);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__HttpBasicAuthentication);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__HttpDigestAuthentication);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__RequireClientCertificate);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__Basic256);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__Basic192);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__Basic128);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__TripleDes);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__Basic256Rsa15);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__Basic192Rsa15);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__Basic128Rsa15);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__TripleDesRsa15);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__Basic256Sha256);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__Basic192Sha256);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__Basic128Sha256);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__TripleDesSha256);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__Basic256Sha256Rsa15);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__Basic192Sha256Rsa15);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__Basic128Sha256Rsa15);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__TripleDesSha256Rsa15);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__InclusiveC14N);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__SOAPNormalization10);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__STRTransform10);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__Path10);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__XPathFilter20);
	soap_serialize_xsd__string(soap, &this->wsp__Content::sp__AbsXPath);
	soap_serialize_xsd__string(soap, &this->wsp__Content::wsam__AnonymousResponses);
	soap_serialize_xsd__string(soap, &this->wsp__Content::wsam__NonAnonymousResponses);
	soap_serialize_std__vectorTemplateOf_XML(soap, &this->wsp__Content::__any);
	/* transient traverse skipped */
	/* transient generate skipped */
}

int wsp__Policy::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_wsp__Policy(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsp__Policy(struct soap *soap, const char *tag, int id, const wsp__Policy *a, const char *type)
{
	if (((wsp__Policy*)a)->xml__base)
		soap_set_attr(soap, "xml:base", ((wsp__Policy*)a)->xml__base, 1);
	if (((wsp__Policy*)a)->wsu__Id)
		soap_set_attr(soap, "wsu:Id", ((wsp__Policy*)a)->wsu__Id, 1);
	if (((wsp__Policy*)a)->TargetNamespace)
		soap_set_attr(soap, "TargetNamespace", ((wsp__Policy*)a)->TargetNamespace, 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsp__Policy), "wsp:Policy"))
		return soap->error;
	if (soap_out_PointerTowsp__Policy(soap, "wsp:Policy", -1, &(a->wsp__Content::Policy), ""))
		return soap->error;
	if (soap_out_PointerTowsp__PolicyReference(soap, "wsp:PolicyReference", -1, &(a->wsp__Content::PolicyReference), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfPointerTowsp__Content(soap, "wsp:All", -1, &(a->wsp__Content::All), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfPointerTowsp__Content(soap, "wsp:ExactlyOne", -1, &(a->wsp__Content::ExactlyOne), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfsp__Parts(soap, "sp:SignedParts", -1, &(a->wsp__Content::sp__SignedParts), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfsp__Parts(soap, "sp:EncryptedParts", -1, &(a->wsp__Content::sp__EncryptedParts), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfsp__Parts(soap, "sp:RequiredParts", -1, &(a->wsp__Content::sp__RequiredParts), ""))
		return soap->error;
	if (soap_out_PointerTosp__Elements(soap, "sp:SignedElements", -1, &(a->wsp__Content::sp__SignedElements), ""))
		return soap->error;
	if (soap_out_PointerTosp__Elements(soap, "sp:EncryptedElements", -1, &(a->wsp__Content::sp__EncryptedElements), ""))
		return soap->error;
	if (soap_out_PointerTosp__Elements(soap, "sp:ContentEncryptedElements", -1, &(a->wsp__Content::sp__ContentEncryptedElements), ""))
		return soap->error;
	if (soap_out_PointerTosp__Elements(soap, "sp:RequiredElements", -1, &(a->wsp__Content::sp__RequiredElements), ""))
		return soap->error;
	if (soap_out_PointerTosp__Token(soap, "sp:UsernameToken", -1, &(a->wsp__Content::sp__UsernameToken), ""))
		return soap->error;
	if (soap_out_PointerTosp__Token(soap, "sp:IssuedToken", -1, &(a->wsp__Content::sp__IssuedToken), ""))
		return soap->error;
	if (soap_out_PointerTosp__Token(soap, "sp:X509Token", -1, &(a->wsp__Content::sp__X509Token), ""))
		return soap->error;
	if (soap_out_PointerTosp__Token(soap, "sp:KerberosToken", -1, &(a->wsp__Content::sp__KerberosToken), ""))
		return soap->error;
	if (soap_out_PointerTosp__Token(soap, "sp:SpnegoContextToken", -1, &(a->wsp__Content::sp__SpnegoContextToken), ""))
		return soap->error;
	if (soap_out_PointerTosp__Token(soap, "sp:SecurityContextToken", -1, &(a->wsp__Content::sp__SecurityContextToken), ""))
		return soap->error;
	if (soap_out_PointerTosp__Token(soap, "sp:SecureConversationToken", -1, &(a->wsp__Content::sp__SecureConversationToken), ""))
		return soap->error;
	if (soap_out_PointerTosp__Token(soap, "sp:SamlToken", -1, &(a->wsp__Content::sp__SamlToken), ""))
		return soap->error;
	if (soap_out_PointerTosp__Token(soap, "sp:RelToken", -1, &(a->wsp__Content::sp__RelToken), ""))
		return soap->error;
	if (soap_out_PointerTosp__Token(soap, "sp:HttpsToken", -1, &(a->wsp__Content::sp__HttpsToken), ""))
		return soap->error;
	if (soap_out_PointerTosp__Token(soap, "sp:KeyValueToken", -1, &(a->wsp__Content::sp__KeyValueToken), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:TransportBinding", -1, &(a->wsp__Content::sp__TransportBinding), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:TransportToken", -1, &(a->wsp__Content::sp__TransportToken), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:AlgorithmSuite", -1, &(a->wsp__Content::sp__AlgorithmSuite), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:Layout", -1, &(a->wsp__Content::sp__Layout), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:SymmetricBinding", -1, &(a->wsp__Content::sp__SymmetricBinding), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:AsymmetricBinding", -1, &(a->wsp__Content::sp__AsymmetricBinding), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:ProtectionToken", -1, &(a->wsp__Content::sp__ProtectionToken), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:InitiatorToken", -1, &(a->wsp__Content::sp__InitiatorToken), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:InitiatorSignatureToken", -1, &(a->wsp__Content::sp__InitiatorSignatureToken), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:InitiatorEncryptionToken", -1, &(a->wsp__Content::sp__InitiatorEncryptionToken), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:RecipientToken", -1, &(a->wsp__Content::sp__RecipientToken), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:SupportingTokens", -1, &(a->wsp__Content::sp__SupportingTokens), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:SignedSupportingTokens", -1, &(a->wsp__Content::sp__SignedSupportingTokens), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:EndorsingSupportingTokens", -1, &(a->wsp__Content::sp__EndorsingSupportingTokens), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:SignedEndorsingSupportingTokens", -1, &(a->wsp__Content::sp__SignedEndorsingSupportingTokens), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:SignedEncryptedSupportingTokens", -1, &(a->wsp__Content::sp__SignedEncryptedSupportingTokens), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:EncryptedSupportingTokens", -1, &(a->wsp__Content::sp__EncryptedSupportingTokens), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:EndorsingEncryptedSupportingTokens", -1, &(a->wsp__Content::sp__EndorsingEncryptedSupportingTokens), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:SignedEndorsingEncryptedSupportingTokens", -1, &(a->wsp__Content::sp__SignedEndorsingEncryptedSupportingTokens), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:Wss10", -1, &(a->wsp__Content::sp__Wss10), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:Wss11", -1, &(a->wsp__Content::sp__Wss11), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:Trust13", -1, &(a->wsp__Content::sp__Trust13), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "wsam:Addressing", -1, &(a->wsp__Content::wsam__Addressing), ""))
		return soap->error;
	if (soap_out_PointerTowsrmp__RMAssertion(soap, "wsrmp:RMAssertion", -1, &(a->wsp__Content::wsrmp__RMAssertion_), ""))
		return soap->error;
	if (soap_out_PointerTowsrmp__RMAssertion(soap, "wsrmp:DeliveryAssurance", -1, &(a->wsp__Content::wsrmp__DeliveryAssurance), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "wsrmp:AtLeastOnce", -1, &(a->wsp__Content::wsrmp__AtLeastOnce), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "wsrmp:AtMostOnce", -1, &(a->wsp__Content::wsrmp__AtMostOnce), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "wsrmp:ExactlyOnce", -1, &(a->wsp__Content::wsrmp__ExactlyOnce), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "wsrmp:InOrder", -1, &(a->wsp__Content::wsrmp__InOrder), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:NoPassword", -1, &(a->wsp__Content::sp__NoPassword), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:HashPassword", -1, &(a->wsp__Content::sp__HashPassword), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:IncludeTimestamp", -1, &(a->wsp__Content::sp__IncludeTimestamp), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:EncryptBeforeSigning", -1, &(a->wsp__Content::sp__EncryptBeforeSigning), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:EncryptSignature", -1, &(a->wsp__Content::sp__EncryptSignature), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:ProtectTokens", -1, &(a->wsp__Content::sp__ProtectTokens), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Assertion(soap, "sp:OnlySignEntireHeadersAndBody", -1, &(a->wsp__Content::sp__OnlySignEntireHeadersAndBody), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:RequireDerivedKeys", -1, &(a->wsp__Content::sp__RequireDerivedKeys), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:RequireImpliedDerivedKeys", -1, &(a->wsp__Content::sp__RequireImpliedDerivedKeys), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:RequireExplicitDerivedKeys", -1, &(a->wsp__Content::sp__RequireExplicitDerivedKeys), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:WssUsernameToken10", -1, &(a->wsp__Content::sp__WssUsernameToken10), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:WssUsernameToken11", -1, &(a->wsp__Content::sp__WssUsernameToken11), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:RequireExternalReference", -1, &(a->wsp__Content::sp__RequireExternalReference), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:RequireInternalReference", -1, &(a->wsp__Content::sp__RequireInternalReference), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:RequireKeyIdentifierReference", -1, &(a->wsp__Content::sp__RequireKeyIdentifierReference), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:RequireIssuerSerialReference", -1, &(a->wsp__Content::sp__RequireIssuerSerialReference), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:RequireEmbeddedTokenReference", -1, &(a->wsp__Content::sp__RequireEmbeddedTokenReference), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:RequireThumbprintReference", -1, &(a->wsp__Content::sp__RequireThumbprintReference), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:WssX509V3Token10", -1, &(a->wsp__Content::sp__WssX509V3Token10), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:WssX509Pkcs7Token10", -1, &(a->wsp__Content::sp__WssX509Pkcs7Token10), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:WssX509PkiPathV1Token10", -1, &(a->wsp__Content::sp__WssX509PkiPathV1Token10), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:WssX509V1Token11", -1, &(a->wsp__Content::sp__WssX509V1Token11), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:WssX509V3Token11", -1, &(a->wsp__Content::sp__WssX509V3Token11), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:WssX509Pkcs7Token11", -1, &(a->wsp__Content::sp__WssX509Pkcs7Token11), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:WssX509PkiPathV1Token11", -1, &(a->wsp__Content::sp__WssX509PkiPathV1Token11), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:WssKerberosV5ApReqToken11", -1, &(a->wsp__Content::sp__WssKerberosV5ApReqToken11), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:WssGssKerberosV5ApReqToken11", -1, &(a->wsp__Content::sp__WssGssKerberosV5ApReqToken11), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:WssRelV10Token10", -1, &(a->wsp__Content::sp__WssRelV10Token10), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:WssRelV20Token10", -1, &(a->wsp__Content::sp__WssRelV20Token10), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:WssRelV10Token11", -1, &(a->wsp__Content::sp__WssRelV10Token11), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:WssRelV20Token11", -1, &(a->wsp__Content::sp__WssRelV20Token11), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:MustNotSendCancel", -1, &(a->wsp__Content::sp__MustNotSendCancel), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:MustNotSendAmend", -1, &(a->wsp__Content::sp__MustNotSendAmend), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:MustNotSendRenew", -1, &(a->wsp__Content::sp__MustNotSendRenew), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:MustSupportRefKeyIdentifier", -1, &(a->wsp__Content::sp__MustSupportRefKeyIdentifier), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:MustSupportRefIssuerSerial", -1, &(a->wsp__Content::sp__MustSupportRefIssuerSerial), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:MustSupportRefExternalURI", -1, &(a->wsp__Content::sp__MustSupportRefExternalURI), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:MustSupportRefEmbeddedToken", -1, &(a->wsp__Content::sp__MustSupportRefEmbeddedToken), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:MustSupportRefThumbprint", -1, &(a->wsp__Content::sp__MustSupportRefThumbprint), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:MustSupportRefEncryptedKey", -1, &(a->wsp__Content::sp__MustSupportRefEncryptedKey), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:RequireSignatureConfirmation", -1, &(a->wsp__Content::sp__RequireSignatureConfirmation), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:MustSupportClientChallenge", -1, &(a->wsp__Content::sp__MustSupportClientChallenge), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:MustSupportServerChallenge", -1, &(a->wsp__Content::sp__MustSupportServerChallenge), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:RequireClientEntropy", -1, &(a->wsp__Content::sp__RequireClientEntropy), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:RequireServerEntropy", -1, &(a->wsp__Content::sp__RequireServerEntropy), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:MustSupportIssuedTokens", -1, &(a->wsp__Content::sp__MustSupportIssuedTokens), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:RequireRequestSecurityTokenCollection", -1, &(a->wsp__Content::sp__RequireRequestSecurityTokenCollection), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:RequireAppliesTo", -1, &(a->wsp__Content::sp__RequireAppliesTo), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:RequireExternalUriReference", -1, &(a->wsp__Content::sp__RequireExternalUriReference), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:SC13SecurityContextToken", -1, &(a->wsp__Content::sp__SC13SecurityContextToken), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:Strict", -1, &(a->wsp__Content::sp__Strict), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:Lax", -1, &(a->wsp__Content::sp__Lax), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:LaxTsFirst", -1, &(a->wsp__Content::sp__LaxTsFirst), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:LaxTsLast", -1, &(a->wsp__Content::sp__LaxTsLast), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:HttpBasicAuthentication", -1, &(a->wsp__Content::sp__HttpBasicAuthentication), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:HttpDigestAuthentication", -1, &(a->wsp__Content::sp__HttpDigestAuthentication), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:RequireClientCertificate", -1, &(a->wsp__Content::sp__RequireClientCertificate), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:Basic256", -1, &(a->wsp__Content::sp__Basic256), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:Basic192", -1, &(a->wsp__Content::sp__Basic192), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:Basic128", -1, &(a->wsp__Content::sp__Basic128), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:TripleDes", -1, &(a->wsp__Content::sp__TripleDes), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:Basic256Rsa15", -1, &(a->wsp__Content::sp__Basic256Rsa15), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:Basic192Rsa15", -1, &(a->wsp__Content::sp__Basic192Rsa15), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:Basic128Rsa15", -1, &(a->wsp__Content::sp__Basic128Rsa15), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:TripleDesRsa15", -1, &(a->wsp__Content::sp__TripleDesRsa15), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:Basic256Sha256", -1, &(a->wsp__Content::sp__Basic256Sha256), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:Basic192Sha256", -1, &(a->wsp__Content::sp__Basic192Sha256), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:Basic128Sha256", -1, &(a->wsp__Content::sp__Basic128Sha256), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:TripleDesSha256", -1, &(a->wsp__Content::sp__TripleDesSha256), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:Basic256Sha256Rsa15", -1, &(a->wsp__Content::sp__Basic256Sha256Rsa15), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:Basic192Sha256Rsa15", -1, &(a->wsp__Content::sp__Basic192Sha256Rsa15), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:Basic128Sha256Rsa15", -1, &(a->wsp__Content::sp__Basic128Sha256Rsa15), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:TripleDesSha256Rsa15", -1, &(a->wsp__Content::sp__TripleDesSha256Rsa15), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:InclusiveC14N", -1, &(a->wsp__Content::sp__InclusiveC14N), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:SOAPNormalization10", -1, &(a->wsp__Content::sp__SOAPNormalization10), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:STRTransform10", -1, &(a->wsp__Content::sp__STRTransform10), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:Path10", -1, &(a->wsp__Content::sp__Path10), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:XPathFilter20", -1, &(a->wsp__Content::sp__XPathFilter20), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "sp:AbsXPath", -1, &(a->wsp__Content::sp__AbsXPath), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "wsam:AnonymousResponses", -1, &(a->wsp__Content::wsam__AnonymousResponses), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "wsam:NonAnonymousResponses", -1, &(a->wsp__Content::wsam__NonAnonymousResponses), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOf_XML(soap, "-any", -1, &(a->wsp__Content::__any), ""))
		return soap->error;
	/* transient traverse skipped */
	/* transient generate skipped */
	return soap_element_end_out(soap, tag);
}

void *wsp__Policy::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_wsp__Policy(soap, tag, this, type);
}

SOAP_FMAC3 wsp__Policy * SOAP_FMAC4 soap_in_wsp__Policy(struct soap *soap, const char *tag, wsp__Policy *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (wsp__Policy *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_wsp__Policy, sizeof(wsp__Policy), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_wsp__Policy)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (wsp__Policy *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "xml:base", 0), &((wsp__Policy*)a)->xml__base, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "wsu:Id", 0), &((wsp__Policy*)a)->wsu__Id, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "TargetNamespace", 0), &((wsp__Policy*)a)->TargetNamespace, 0, -1))
		return NULL;
	size_t soap_flag_Policy2 = 1;
	size_t soap_flag_PolicyReference2 = 1;
	size_t soap_flag_sp__SignedElements2 = 1;
	size_t soap_flag_sp__EncryptedElements2 = 1;
	size_t soap_flag_sp__ContentEncryptedElements2 = 1;
	size_t soap_flag_sp__RequiredElements2 = 1;
	size_t soap_flag_sp__UsernameToken2 = 1;
	size_t soap_flag_sp__IssuedToken2 = 1;
	size_t soap_flag_sp__X509Token2 = 1;
	size_t soap_flag_sp__KerberosToken2 = 1;
	size_t soap_flag_sp__SpnegoContextToken2 = 1;
	size_t soap_flag_sp__SecurityContextToken2 = 1;
	size_t soap_flag_sp__SecureConversationToken2 = 1;
	size_t soap_flag_sp__SamlToken2 = 1;
	size_t soap_flag_sp__RelToken2 = 1;
	size_t soap_flag_sp__HttpsToken2 = 1;
	size_t soap_flag_sp__KeyValueToken2 = 1;
	size_t soap_flag_sp__TransportBinding2 = 1;
	size_t soap_flag_sp__TransportToken2 = 1;
	size_t soap_flag_sp__AlgorithmSuite2 = 1;
	size_t soap_flag_sp__Layout2 = 1;
	size_t soap_flag_sp__SymmetricBinding2 = 1;
	size_t soap_flag_sp__AsymmetricBinding2 = 1;
	size_t soap_flag_sp__ProtectionToken2 = 1;
	size_t soap_flag_sp__InitiatorToken2 = 1;
	size_t soap_flag_sp__InitiatorSignatureToken2 = 1;
	size_t soap_flag_sp__InitiatorEncryptionToken2 = 1;
	size_t soap_flag_sp__RecipientToken2 = 1;
	size_t soap_flag_sp__SupportingTokens2 = 1;
	size_t soap_flag_sp__SignedSupportingTokens2 = 1;
	size_t soap_flag_sp__EndorsingSupportingTokens2 = 1;
	size_t soap_flag_sp__SignedEndorsingSupportingTokens2 = 1;
	size_t soap_flag_sp__SignedEncryptedSupportingTokens2 = 1;
	size_t soap_flag_sp__EncryptedSupportingTokens2 = 1;
	size_t soap_flag_sp__EndorsingEncryptedSupportingTokens2 = 1;
	size_t soap_flag_sp__SignedEndorsingEncryptedSupportingTokens2 = 1;
	size_t soap_flag_sp__Wss102 = 1;
	size_t soap_flag_sp__Wss112 = 1;
	size_t soap_flag_sp__Trust132 = 1;
	size_t soap_flag_wsam__Addressing2 = 1;
	size_t soap_flag_wsrmp__RMAssertion_2 = 1;
	size_t soap_flag_wsrmp__DeliveryAssurance2 = 1;
	size_t soap_flag_wsrmp__AtLeastOnce2 = 1;
	size_t soap_flag_wsrmp__AtMostOnce2 = 1;
	size_t soap_flag_wsrmp__ExactlyOnce2 = 1;
	size_t soap_flag_wsrmp__InOrder2 = 1;
	size_t soap_flag_sp__NoPassword2 = 1;
	size_t soap_flag_sp__HashPassword2 = 1;
	size_t soap_flag_sp__IncludeTimestamp2 = 1;
	size_t soap_flag_sp__EncryptBeforeSigning2 = 1;
	size_t soap_flag_sp__EncryptSignature2 = 1;
	size_t soap_flag_sp__ProtectTokens2 = 1;
	size_t soap_flag_sp__OnlySignEntireHeadersAndBody2 = 1;
	size_t soap_flag_sp__RequireDerivedKeys2 = 1;
	size_t soap_flag_sp__RequireImpliedDerivedKeys2 = 1;
	size_t soap_flag_sp__RequireExplicitDerivedKeys2 = 1;
	size_t soap_flag_sp__WssUsernameToken102 = 1;
	size_t soap_flag_sp__WssUsernameToken112 = 1;
	size_t soap_flag_sp__RequireExternalReference2 = 1;
	size_t soap_flag_sp__RequireInternalReference2 = 1;
	size_t soap_flag_sp__RequireKeyIdentifierReference2 = 1;
	size_t soap_flag_sp__RequireIssuerSerialReference2 = 1;
	size_t soap_flag_sp__RequireEmbeddedTokenReference2 = 1;
	size_t soap_flag_sp__RequireThumbprintReference2 = 1;
	size_t soap_flag_sp__WssX509V3Token102 = 1;
	size_t soap_flag_sp__WssX509Pkcs7Token102 = 1;
	size_t soap_flag_sp__WssX509PkiPathV1Token102 = 1;
	size_t soap_flag_sp__WssX509V1Token112 = 1;
	size_t soap_flag_sp__WssX509V3Token112 = 1;
	size_t soap_flag_sp__WssX509Pkcs7Token112 = 1;
	size_t soap_flag_sp__WssX509PkiPathV1Token112 = 1;
	size_t soap_flag_sp__WssKerberosV5ApReqToken112 = 1;
	size_t soap_flag_sp__WssGssKerberosV5ApReqToken112 = 1;
	size_t soap_flag_sp__WssRelV10Token102 = 1;
	size_t soap_flag_sp__WssRelV20Token102 = 1;
	size_t soap_flag_sp__WssRelV10Token112 = 1;
	size_t soap_flag_sp__WssRelV20Token112 = 1;
	size_t soap_flag_sp__MustNotSendCancel2 = 1;
	size_t soap_flag_sp__MustNotSendAmend2 = 1;
	size_t soap_flag_sp__MustNotSendRenew2 = 1;
	size_t soap_flag_sp__MustSupportRefKeyIdentifier2 = 1;
	size_t soap_flag_sp__MustSupportRefIssuerSerial2 = 1;
	size_t soap_flag_sp__MustSupportRefExternalURI2 = 1;
	size_t soap_flag_sp__MustSupportRefEmbeddedToken2 = 1;
	size_t soap_flag_sp__MustSupportRefThumbprint2 = 1;
	size_t soap_flag_sp__MustSupportRefEncryptedKey2 = 1;
	size_t soap_flag_sp__RequireSignatureConfirmation2 = 1;
	size_t soap_flag_sp__MustSupportClientChallenge2 = 1;
	size_t soap_flag_sp__MustSupportServerChallenge2 = 1;
	size_t soap_flag_sp__RequireClientEntropy2 = 1;
	size_t soap_flag_sp__RequireServerEntropy2 = 1;
	size_t soap_flag_sp__MustSupportIssuedTokens2 = 1;
	size_t soap_flag_sp__RequireRequestSecurityTokenCollection2 = 1;
	size_t soap_flag_sp__RequireAppliesTo2 = 1;
	size_t soap_flag_sp__RequireExternalUriReference2 = 1;
	size_t soap_flag_sp__SC13SecurityContextToken2 = 1;
	size_t soap_flag_sp__Strict2 = 1;
	size_t soap_flag_sp__Lax2 = 1;
	size_t soap_flag_sp__LaxTsFirst2 = 1;
	size_t soap_flag_sp__LaxTsLast2 = 1;
	size_t soap_flag_sp__HttpBasicAuthentication2 = 1;
	size_t soap_flag_sp__HttpDigestAuthentication2 = 1;
	size_t soap_flag_sp__RequireClientCertificate2 = 1;
	size_t soap_flag_sp__Basic2562 = 1;
	size_t soap_flag_sp__Basic1922 = 1;
	size_t soap_flag_sp__Basic1282 = 1;
	size_t soap_flag_sp__TripleDes2 = 1;
	size_t soap_flag_sp__Basic256Rsa152 = 1;
	size_t soap_flag_sp__Basic192Rsa152 = 1;
	size_t soap_flag_sp__Basic128Rsa152 = 1;
	size_t soap_flag_sp__TripleDesRsa152 = 1;
	size_t soap_flag_sp__Basic256Sha2562 = 1;
	size_t soap_flag_sp__Basic192Sha2562 = 1;
	size_t soap_flag_sp__Basic128Sha2562 = 1;
	size_t soap_flag_sp__TripleDesSha2562 = 1;
	size_t soap_flag_sp__Basic256Sha256Rsa152 = 1;
	size_t soap_flag_sp__Basic192Sha256Rsa152 = 1;
	size_t soap_flag_sp__Basic128Sha256Rsa152 = 1;
	size_t soap_flag_sp__TripleDesSha256Rsa152 = 1;
	size_t soap_flag_sp__InclusiveC14N2 = 1;
	size_t soap_flag_sp__SOAPNormalization102 = 1;
	size_t soap_flag_sp__STRTransform102 = 1;
	size_t soap_flag_sp__Path102 = 1;
	size_t soap_flag_sp__XPathFilter202 = 1;
	size_t soap_flag_sp__AbsXPath2 = 1;
	size_t soap_flag_wsam__AnonymousResponses2 = 1;
	size_t soap_flag_wsam__NonAnonymousResponses2 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Policy2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Policy(soap, "wsp:Policy", &(a->wsp__Content::Policy), "wsp:Policy"))
				{	soap_flag_Policy2--;
					continue;
				}
			if (soap_flag_PolicyReference2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__PolicyReference(soap, "wsp:PolicyReference", &(a->wsp__Content::PolicyReference), "wsp:PolicyReference"))
				{	soap_flag_PolicyReference2--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerTowsp__Content(soap, "wsp:All", &(a->wsp__Content::All), "wsp:Content"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerTowsp__Content(soap, "wsp:ExactlyOne", &(a->wsp__Content::ExactlyOne), "wsp:Content"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfsp__Parts(soap, "sp:SignedParts", &(a->wsp__Content::sp__SignedParts), "sp:Parts"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfsp__Parts(soap, "sp:EncryptedParts", &(a->wsp__Content::sp__EncryptedParts), "sp:Parts"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfsp__Parts(soap, "sp:RequiredParts", &(a->wsp__Content::sp__RequiredParts), "sp:Parts"))
					continue;
			if (soap_flag_sp__SignedElements2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosp__Elements(soap, "sp:SignedElements", &(a->wsp__Content::sp__SignedElements), "sp:Elements"))
				{	soap_flag_sp__SignedElements2--;
					continue;
				}
			if (soap_flag_sp__EncryptedElements2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosp__Elements(soap, "sp:EncryptedElements", &(a->wsp__Content::sp__EncryptedElements), "sp:Elements"))
				{	soap_flag_sp__EncryptedElements2--;
					continue;
				}
			if (soap_flag_sp__ContentEncryptedElements2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosp__Elements(soap, "sp:ContentEncryptedElements", &(a->wsp__Content::sp__ContentEncryptedElements), "sp:Elements"))
				{	soap_flag_sp__ContentEncryptedElements2--;
					continue;
				}
			if (soap_flag_sp__RequiredElements2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosp__Elements(soap, "sp:RequiredElements", &(a->wsp__Content::sp__RequiredElements), "sp:Elements"))
				{	soap_flag_sp__RequiredElements2--;
					continue;
				}
			if (soap_flag_sp__UsernameToken2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosp__Token(soap, "sp:UsernameToken", &(a->wsp__Content::sp__UsernameToken), "sp:Token"))
				{	soap_flag_sp__UsernameToken2--;
					continue;
				}
			if (soap_flag_sp__IssuedToken2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosp__Token(soap, "sp:IssuedToken", &(a->wsp__Content::sp__IssuedToken), "sp:Token"))
				{	soap_flag_sp__IssuedToken2--;
					continue;
				}
			if (soap_flag_sp__X509Token2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosp__Token(soap, "sp:X509Token", &(a->wsp__Content::sp__X509Token), "sp:Token"))
				{	soap_flag_sp__X509Token2--;
					continue;
				}
			if (soap_flag_sp__KerberosToken2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosp__Token(soap, "sp:KerberosToken", &(a->wsp__Content::sp__KerberosToken), "sp:Token"))
				{	soap_flag_sp__KerberosToken2--;
					continue;
				}
			if (soap_flag_sp__SpnegoContextToken2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosp__Token(soap, "sp:SpnegoContextToken", &(a->wsp__Content::sp__SpnegoContextToken), "sp:Token"))
				{	soap_flag_sp__SpnegoContextToken2--;
					continue;
				}
			if (soap_flag_sp__SecurityContextToken2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosp__Token(soap, "sp:SecurityContextToken", &(a->wsp__Content::sp__SecurityContextToken), "sp:Token"))
				{	soap_flag_sp__SecurityContextToken2--;
					continue;
				}
			if (soap_flag_sp__SecureConversationToken2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosp__Token(soap, "sp:SecureConversationToken", &(a->wsp__Content::sp__SecureConversationToken), "sp:Token"))
				{	soap_flag_sp__SecureConversationToken2--;
					continue;
				}
			if (soap_flag_sp__SamlToken2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosp__Token(soap, "sp:SamlToken", &(a->wsp__Content::sp__SamlToken), "sp:Token"))
				{	soap_flag_sp__SamlToken2--;
					continue;
				}
			if (soap_flag_sp__RelToken2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosp__Token(soap, "sp:RelToken", &(a->wsp__Content::sp__RelToken), "sp:Token"))
				{	soap_flag_sp__RelToken2--;
					continue;
				}
			if (soap_flag_sp__HttpsToken2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosp__Token(soap, "sp:HttpsToken", &(a->wsp__Content::sp__HttpsToken), "sp:Token"))
				{	soap_flag_sp__HttpsToken2--;
					continue;
				}
			if (soap_flag_sp__KeyValueToken2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosp__Token(soap, "sp:KeyValueToken", &(a->wsp__Content::sp__KeyValueToken), "sp:Token"))
				{	soap_flag_sp__KeyValueToken2--;
					continue;
				}
			if (soap_flag_sp__TransportBinding2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:TransportBinding", &(a->wsp__Content::sp__TransportBinding), "wsp:Assertion"))
				{	soap_flag_sp__TransportBinding2--;
					continue;
				}
			if (soap_flag_sp__TransportToken2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:TransportToken", &(a->wsp__Content::sp__TransportToken), "wsp:Assertion"))
				{	soap_flag_sp__TransportToken2--;
					continue;
				}
			if (soap_flag_sp__AlgorithmSuite2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:AlgorithmSuite", &(a->wsp__Content::sp__AlgorithmSuite), "wsp:Assertion"))
				{	soap_flag_sp__AlgorithmSuite2--;
					continue;
				}
			if (soap_flag_sp__Layout2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:Layout", &(a->wsp__Content::sp__Layout), "wsp:Assertion"))
				{	soap_flag_sp__Layout2--;
					continue;
				}
			if (soap_flag_sp__SymmetricBinding2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:SymmetricBinding", &(a->wsp__Content::sp__SymmetricBinding), "wsp:Assertion"))
				{	soap_flag_sp__SymmetricBinding2--;
					continue;
				}
			if (soap_flag_sp__AsymmetricBinding2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:AsymmetricBinding", &(a->wsp__Content::sp__AsymmetricBinding), "wsp:Assertion"))
				{	soap_flag_sp__AsymmetricBinding2--;
					continue;
				}
			if (soap_flag_sp__ProtectionToken2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:ProtectionToken", &(a->wsp__Content::sp__ProtectionToken), "wsp:Assertion"))
				{	soap_flag_sp__ProtectionToken2--;
					continue;
				}
			if (soap_flag_sp__InitiatorToken2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:InitiatorToken", &(a->wsp__Content::sp__InitiatorToken), "wsp:Assertion"))
				{	soap_flag_sp__InitiatorToken2--;
					continue;
				}
			if (soap_flag_sp__InitiatorSignatureToken2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:InitiatorSignatureToken", &(a->wsp__Content::sp__InitiatorSignatureToken), "wsp:Assertion"))
				{	soap_flag_sp__InitiatorSignatureToken2--;
					continue;
				}
			if (soap_flag_sp__InitiatorEncryptionToken2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:InitiatorEncryptionToken", &(a->wsp__Content::sp__InitiatorEncryptionToken), "wsp:Assertion"))
				{	soap_flag_sp__InitiatorEncryptionToken2--;
					continue;
				}
			if (soap_flag_sp__RecipientToken2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:RecipientToken", &(a->wsp__Content::sp__RecipientToken), "wsp:Assertion"))
				{	soap_flag_sp__RecipientToken2--;
					continue;
				}
			if (soap_flag_sp__SupportingTokens2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:SupportingTokens", &(a->wsp__Content::sp__SupportingTokens), "wsp:Assertion"))
				{	soap_flag_sp__SupportingTokens2--;
					continue;
				}
			if (soap_flag_sp__SignedSupportingTokens2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:SignedSupportingTokens", &(a->wsp__Content::sp__SignedSupportingTokens), "wsp:Assertion"))
				{	soap_flag_sp__SignedSupportingTokens2--;
					continue;
				}
			if (soap_flag_sp__EndorsingSupportingTokens2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:EndorsingSupportingTokens", &(a->wsp__Content::sp__EndorsingSupportingTokens), "wsp:Assertion"))
				{	soap_flag_sp__EndorsingSupportingTokens2--;
					continue;
				}
			if (soap_flag_sp__SignedEndorsingSupportingTokens2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:SignedEndorsingSupportingTokens", &(a->wsp__Content::sp__SignedEndorsingSupportingTokens), "wsp:Assertion"))
				{	soap_flag_sp__SignedEndorsingSupportingTokens2--;
					continue;
				}
			if (soap_flag_sp__SignedEncryptedSupportingTokens2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:SignedEncryptedSupportingTokens", &(a->wsp__Content::sp__SignedEncryptedSupportingTokens), "wsp:Assertion"))
				{	soap_flag_sp__SignedEncryptedSupportingTokens2--;
					continue;
				}
			if (soap_flag_sp__EncryptedSupportingTokens2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:EncryptedSupportingTokens", &(a->wsp__Content::sp__EncryptedSupportingTokens), "wsp:Assertion"))
				{	soap_flag_sp__EncryptedSupportingTokens2--;
					continue;
				}
			if (soap_flag_sp__EndorsingEncryptedSupportingTokens2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:EndorsingEncryptedSupportingTokens", &(a->wsp__Content::sp__EndorsingEncryptedSupportingTokens), "wsp:Assertion"))
				{	soap_flag_sp__EndorsingEncryptedSupportingTokens2--;
					continue;
				}
			if (soap_flag_sp__SignedEndorsingEncryptedSupportingTokens2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:SignedEndorsingEncryptedSupportingTokens", &(a->wsp__Content::sp__SignedEndorsingEncryptedSupportingTokens), "wsp:Assertion"))
				{	soap_flag_sp__SignedEndorsingEncryptedSupportingTokens2--;
					continue;
				}
			if (soap_flag_sp__Wss102 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:Wss10", &(a->wsp__Content::sp__Wss10), "wsp:Assertion"))
				{	soap_flag_sp__Wss102--;
					continue;
				}
			if (soap_flag_sp__Wss112 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:Wss11", &(a->wsp__Content::sp__Wss11), "wsp:Assertion"))
				{	soap_flag_sp__Wss112--;
					continue;
				}
			if (soap_flag_sp__Trust132 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:Trust13", &(a->wsp__Content::sp__Trust13), "wsp:Assertion"))
				{	soap_flag_sp__Trust132--;
					continue;
				}
			if (soap_flag_wsam__Addressing2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "wsam:Addressing", &(a->wsp__Content::wsam__Addressing), "wsp:Assertion"))
				{	soap_flag_wsam__Addressing2--;
					continue;
				}
			if (soap_flag_wsrmp__RMAssertion_2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsrmp__RMAssertion(soap, "wsrmp:RMAssertion", &(a->wsp__Content::wsrmp__RMAssertion_), "wsrmp:RMAssertion"))
				{	soap_flag_wsrmp__RMAssertion_2--;
					continue;
				}
			if (soap_flag_wsrmp__DeliveryAssurance2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsrmp__RMAssertion(soap, "wsrmp:DeliveryAssurance", &(a->wsp__Content::wsrmp__DeliveryAssurance), "wsrmp:RMAssertion"))
				{	soap_flag_wsrmp__DeliveryAssurance2--;
					continue;
				}
			if (soap_flag_wsrmp__AtLeastOnce2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "wsrmp:AtLeastOnce", &(a->wsp__Content::wsrmp__AtLeastOnce), "xsd:string"))
				{	soap_flag_wsrmp__AtLeastOnce2--;
					continue;
				}
			if (soap_flag_wsrmp__AtMostOnce2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "wsrmp:AtMostOnce", &(a->wsp__Content::wsrmp__AtMostOnce), "xsd:string"))
				{	soap_flag_wsrmp__AtMostOnce2--;
					continue;
				}
			if (soap_flag_wsrmp__ExactlyOnce2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "wsrmp:ExactlyOnce", &(a->wsp__Content::wsrmp__ExactlyOnce), "xsd:string"))
				{	soap_flag_wsrmp__ExactlyOnce2--;
					continue;
				}
			if (soap_flag_wsrmp__InOrder2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "wsrmp:InOrder", &(a->wsp__Content::wsrmp__InOrder), "xsd:string"))
				{	soap_flag_wsrmp__InOrder2--;
					continue;
				}
			if (soap_flag_sp__NoPassword2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:NoPassword", &(a->wsp__Content::sp__NoPassword), "wsp:Assertion"))
				{	soap_flag_sp__NoPassword2--;
					continue;
				}
			if (soap_flag_sp__HashPassword2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:HashPassword", &(a->wsp__Content::sp__HashPassword), "wsp:Assertion"))
				{	soap_flag_sp__HashPassword2--;
					continue;
				}
			if (soap_flag_sp__IncludeTimestamp2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:IncludeTimestamp", &(a->wsp__Content::sp__IncludeTimestamp), "wsp:Assertion"))
				{	soap_flag_sp__IncludeTimestamp2--;
					continue;
				}
			if (soap_flag_sp__EncryptBeforeSigning2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:EncryptBeforeSigning", &(a->wsp__Content::sp__EncryptBeforeSigning), "wsp:Assertion"))
				{	soap_flag_sp__EncryptBeforeSigning2--;
					continue;
				}
			if (soap_flag_sp__EncryptSignature2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:EncryptSignature", &(a->wsp__Content::sp__EncryptSignature), "wsp:Assertion"))
				{	soap_flag_sp__EncryptSignature2--;
					continue;
				}
			if (soap_flag_sp__ProtectTokens2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:ProtectTokens", &(a->wsp__Content::sp__ProtectTokens), "wsp:Assertion"))
				{	soap_flag_sp__ProtectTokens2--;
					continue;
				}
			if (soap_flag_sp__OnlySignEntireHeadersAndBody2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Assertion(soap, "sp:OnlySignEntireHeadersAndBody", &(a->wsp__Content::sp__OnlySignEntireHeadersAndBody), "wsp:Assertion"))
				{	soap_flag_sp__OnlySignEntireHeadersAndBody2--;
					continue;
				}
			if (soap_flag_sp__RequireDerivedKeys2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:RequireDerivedKeys", &(a->wsp__Content::sp__RequireDerivedKeys), "xsd:string"))
				{	soap_flag_sp__RequireDerivedKeys2--;
					continue;
				}
			if (soap_flag_sp__RequireImpliedDerivedKeys2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:RequireImpliedDerivedKeys", &(a->wsp__Content::sp__RequireImpliedDerivedKeys), "xsd:string"))
				{	soap_flag_sp__RequireImpliedDerivedKeys2--;
					continue;
				}
			if (soap_flag_sp__RequireExplicitDerivedKeys2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:RequireExplicitDerivedKeys", &(a->wsp__Content::sp__RequireExplicitDerivedKeys), "xsd:string"))
				{	soap_flag_sp__RequireExplicitDerivedKeys2--;
					continue;
				}
			if (soap_flag_sp__WssUsernameToken102 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:WssUsernameToken10", &(a->wsp__Content::sp__WssUsernameToken10), "xsd:string"))
				{	soap_flag_sp__WssUsernameToken102--;
					continue;
				}
			if (soap_flag_sp__WssUsernameToken112 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:WssUsernameToken11", &(a->wsp__Content::sp__WssUsernameToken11), "xsd:string"))
				{	soap_flag_sp__WssUsernameToken112--;
					continue;
				}
			if (soap_flag_sp__RequireExternalReference2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:RequireExternalReference", &(a->wsp__Content::sp__RequireExternalReference), "xsd:string"))
				{	soap_flag_sp__RequireExternalReference2--;
					continue;
				}
			if (soap_flag_sp__RequireInternalReference2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:RequireInternalReference", &(a->wsp__Content::sp__RequireInternalReference), "xsd:string"))
				{	soap_flag_sp__RequireInternalReference2--;
					continue;
				}
			if (soap_flag_sp__RequireKeyIdentifierReference2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:RequireKeyIdentifierReference", &(a->wsp__Content::sp__RequireKeyIdentifierReference), "xsd:string"))
				{	soap_flag_sp__RequireKeyIdentifierReference2--;
					continue;
				}
			if (soap_flag_sp__RequireIssuerSerialReference2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:RequireIssuerSerialReference", &(a->wsp__Content::sp__RequireIssuerSerialReference), "xsd:string"))
				{	soap_flag_sp__RequireIssuerSerialReference2--;
					continue;
				}
			if (soap_flag_sp__RequireEmbeddedTokenReference2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:RequireEmbeddedTokenReference", &(a->wsp__Content::sp__RequireEmbeddedTokenReference), "xsd:string"))
				{	soap_flag_sp__RequireEmbeddedTokenReference2--;
					continue;
				}
			if (soap_flag_sp__RequireThumbprintReference2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:RequireThumbprintReference", &(a->wsp__Content::sp__RequireThumbprintReference), "xsd:string"))
				{	soap_flag_sp__RequireThumbprintReference2--;
					continue;
				}
			if (soap_flag_sp__WssX509V3Token102 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:WssX509V3Token10", &(a->wsp__Content::sp__WssX509V3Token10), "xsd:string"))
				{	soap_flag_sp__WssX509V3Token102--;
					continue;
				}
			if (soap_flag_sp__WssX509Pkcs7Token102 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:WssX509Pkcs7Token10", &(a->wsp__Content::sp__WssX509Pkcs7Token10), "xsd:string"))
				{	soap_flag_sp__WssX509Pkcs7Token102--;
					continue;
				}
			if (soap_flag_sp__WssX509PkiPathV1Token102 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:WssX509PkiPathV1Token10", &(a->wsp__Content::sp__WssX509PkiPathV1Token10), "xsd:string"))
				{	soap_flag_sp__WssX509PkiPathV1Token102--;
					continue;
				}
			if (soap_flag_sp__WssX509V1Token112 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:WssX509V1Token11", &(a->wsp__Content::sp__WssX509V1Token11), "xsd:string"))
				{	soap_flag_sp__WssX509V1Token112--;
					continue;
				}
			if (soap_flag_sp__WssX509V3Token112 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:WssX509V3Token11", &(a->wsp__Content::sp__WssX509V3Token11), "xsd:string"))
				{	soap_flag_sp__WssX509V3Token112--;
					continue;
				}
			if (soap_flag_sp__WssX509Pkcs7Token112 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:WssX509Pkcs7Token11", &(a->wsp__Content::sp__WssX509Pkcs7Token11), "xsd:string"))
				{	soap_flag_sp__WssX509Pkcs7Token112--;
					continue;
				}
			if (soap_flag_sp__WssX509PkiPathV1Token112 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:WssX509PkiPathV1Token11", &(a->wsp__Content::sp__WssX509PkiPathV1Token11), "xsd:string"))
				{	soap_flag_sp__WssX509PkiPathV1Token112--;
					continue;
				}
			if (soap_flag_sp__WssKerberosV5ApReqToken112 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:WssKerberosV5ApReqToken11", &(a->wsp__Content::sp__WssKerberosV5ApReqToken11), "xsd:string"))
				{	soap_flag_sp__WssKerberosV5ApReqToken112--;
					continue;
				}
			if (soap_flag_sp__WssGssKerberosV5ApReqToken112 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:WssGssKerberosV5ApReqToken11", &(a->wsp__Content::sp__WssGssKerberosV5ApReqToken11), "xsd:string"))
				{	soap_flag_sp__WssGssKerberosV5ApReqToken112--;
					continue;
				}
			if (soap_flag_sp__WssRelV10Token102 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:WssRelV10Token10", &(a->wsp__Content::sp__WssRelV10Token10), "xsd:string"))
				{	soap_flag_sp__WssRelV10Token102--;
					continue;
				}
			if (soap_flag_sp__WssRelV20Token102 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:WssRelV20Token10", &(a->wsp__Content::sp__WssRelV20Token10), "xsd:string"))
				{	soap_flag_sp__WssRelV20Token102--;
					continue;
				}
			if (soap_flag_sp__WssRelV10Token112 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:WssRelV10Token11", &(a->wsp__Content::sp__WssRelV10Token11), "xsd:string"))
				{	soap_flag_sp__WssRelV10Token112--;
					continue;
				}
			if (soap_flag_sp__WssRelV20Token112 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:WssRelV20Token11", &(a->wsp__Content::sp__WssRelV20Token11), "xsd:string"))
				{	soap_flag_sp__WssRelV20Token112--;
					continue;
				}
			if (soap_flag_sp__MustNotSendCancel2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:MustNotSendCancel", &(a->wsp__Content::sp__MustNotSendCancel), "xsd:string"))
				{	soap_flag_sp__MustNotSendCancel2--;
					continue;
				}
			if (soap_flag_sp__MustNotSendAmend2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:MustNotSendAmend", &(a->wsp__Content::sp__MustNotSendAmend), "xsd:string"))
				{	soap_flag_sp__MustNotSendAmend2--;
					continue;
				}
			if (soap_flag_sp__MustNotSendRenew2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:MustNotSendRenew", &(a->wsp__Content::sp__MustNotSendRenew), "xsd:string"))
				{	soap_flag_sp__MustNotSendRenew2--;
					continue;
				}
			if (soap_flag_sp__MustSupportRefKeyIdentifier2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:MustSupportRefKeyIdentifier", &(a->wsp__Content::sp__MustSupportRefKeyIdentifier), "xsd:string"))
				{	soap_flag_sp__MustSupportRefKeyIdentifier2--;
					continue;
				}
			if (soap_flag_sp__MustSupportRefIssuerSerial2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:MustSupportRefIssuerSerial", &(a->wsp__Content::sp__MustSupportRefIssuerSerial), "xsd:string"))
				{	soap_flag_sp__MustSupportRefIssuerSerial2--;
					continue;
				}
			if (soap_flag_sp__MustSupportRefExternalURI2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:MustSupportRefExternalURI", &(a->wsp__Content::sp__MustSupportRefExternalURI), "xsd:string"))
				{	soap_flag_sp__MustSupportRefExternalURI2--;
					continue;
				}
			if (soap_flag_sp__MustSupportRefEmbeddedToken2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:MustSupportRefEmbeddedToken", &(a->wsp__Content::sp__MustSupportRefEmbeddedToken), "xsd:string"))
				{	soap_flag_sp__MustSupportRefEmbeddedToken2--;
					continue;
				}
			if (soap_flag_sp__MustSupportRefThumbprint2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:MustSupportRefThumbprint", &(a->wsp__Content::sp__MustSupportRefThumbprint), "xsd:string"))
				{	soap_flag_sp__MustSupportRefThumbprint2--;
					continue;
				}
			if (soap_flag_sp__MustSupportRefEncryptedKey2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:MustSupportRefEncryptedKey", &(a->wsp__Content::sp__MustSupportRefEncryptedKey), "xsd:string"))
				{	soap_flag_sp__MustSupportRefEncryptedKey2--;
					continue;
				}
			if (soap_flag_sp__RequireSignatureConfirmation2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:RequireSignatureConfirmation", &(a->wsp__Content::sp__RequireSignatureConfirmation), "xsd:string"))
				{	soap_flag_sp__RequireSignatureConfirmation2--;
					continue;
				}
			if (soap_flag_sp__MustSupportClientChallenge2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:MustSupportClientChallenge", &(a->wsp__Content::sp__MustSupportClientChallenge), "xsd:string"))
				{	soap_flag_sp__MustSupportClientChallenge2--;
					continue;
				}
			if (soap_flag_sp__MustSupportServerChallenge2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:MustSupportServerChallenge", &(a->wsp__Content::sp__MustSupportServerChallenge), "xsd:string"))
				{	soap_flag_sp__MustSupportServerChallenge2--;
					continue;
				}
			if (soap_flag_sp__RequireClientEntropy2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:RequireClientEntropy", &(a->wsp__Content::sp__RequireClientEntropy), "xsd:string"))
				{	soap_flag_sp__RequireClientEntropy2--;
					continue;
				}
			if (soap_flag_sp__RequireServerEntropy2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:RequireServerEntropy", &(a->wsp__Content::sp__RequireServerEntropy), "xsd:string"))
				{	soap_flag_sp__RequireServerEntropy2--;
					continue;
				}
			if (soap_flag_sp__MustSupportIssuedTokens2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:MustSupportIssuedTokens", &(a->wsp__Content::sp__MustSupportIssuedTokens), "xsd:string"))
				{	soap_flag_sp__MustSupportIssuedTokens2--;
					continue;
				}
			if (soap_flag_sp__RequireRequestSecurityTokenCollection2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:RequireRequestSecurityTokenCollection", &(a->wsp__Content::sp__RequireRequestSecurityTokenCollection), "xsd:string"))
				{	soap_flag_sp__RequireRequestSecurityTokenCollection2--;
					continue;
				}
			if (soap_flag_sp__RequireAppliesTo2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:RequireAppliesTo", &(a->wsp__Content::sp__RequireAppliesTo), "xsd:string"))
				{	soap_flag_sp__RequireAppliesTo2--;
					continue;
				}
			if (soap_flag_sp__RequireExternalUriReference2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:RequireExternalUriReference", &(a->wsp__Content::sp__RequireExternalUriReference), "xsd:string"))
				{	soap_flag_sp__RequireExternalUriReference2--;
					continue;
				}
			if (soap_flag_sp__SC13SecurityContextToken2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:SC13SecurityContextToken", &(a->wsp__Content::sp__SC13SecurityContextToken), "xsd:string"))
				{	soap_flag_sp__SC13SecurityContextToken2--;
					continue;
				}
			if (soap_flag_sp__Strict2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:Strict", &(a->wsp__Content::sp__Strict), "xsd:string"))
				{	soap_flag_sp__Strict2--;
					continue;
				}
			if (soap_flag_sp__Lax2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:Lax", &(a->wsp__Content::sp__Lax), "xsd:string"))
				{	soap_flag_sp__Lax2--;
					continue;
				}
			if (soap_flag_sp__LaxTsFirst2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:LaxTsFirst", &(a->wsp__Content::sp__LaxTsFirst), "xsd:string"))
				{	soap_flag_sp__LaxTsFirst2--;
					continue;
				}
			if (soap_flag_sp__LaxTsLast2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:LaxTsLast", &(a->wsp__Content::sp__LaxTsLast), "xsd:string"))
				{	soap_flag_sp__LaxTsLast2--;
					continue;
				}
			if (soap_flag_sp__HttpBasicAuthentication2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:HttpBasicAuthentication", &(a->wsp__Content::sp__HttpBasicAuthentication), "xsd:string"))
				{	soap_flag_sp__HttpBasicAuthentication2--;
					continue;
				}
			if (soap_flag_sp__HttpDigestAuthentication2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:HttpDigestAuthentication", &(a->wsp__Content::sp__HttpDigestAuthentication), "xsd:string"))
				{	soap_flag_sp__HttpDigestAuthentication2--;
					continue;
				}
			if (soap_flag_sp__RequireClientCertificate2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:RequireClientCertificate", &(a->wsp__Content::sp__RequireClientCertificate), "xsd:string"))
				{	soap_flag_sp__RequireClientCertificate2--;
					continue;
				}
			if (soap_flag_sp__Basic2562 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:Basic256", &(a->wsp__Content::sp__Basic256), "xsd:string"))
				{	soap_flag_sp__Basic2562--;
					continue;
				}
			if (soap_flag_sp__Basic1922 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:Basic192", &(a->wsp__Content::sp__Basic192), "xsd:string"))
				{	soap_flag_sp__Basic1922--;
					continue;
				}
			if (soap_flag_sp__Basic1282 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:Basic128", &(a->wsp__Content::sp__Basic128), "xsd:string"))
				{	soap_flag_sp__Basic1282--;
					continue;
				}
			if (soap_flag_sp__TripleDes2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:TripleDes", &(a->wsp__Content::sp__TripleDes), "xsd:string"))
				{	soap_flag_sp__TripleDes2--;
					continue;
				}
			if (soap_flag_sp__Basic256Rsa152 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:Basic256Rsa15", &(a->wsp__Content::sp__Basic256Rsa15), "xsd:string"))
				{	soap_flag_sp__Basic256Rsa152--;
					continue;
				}
			if (soap_flag_sp__Basic192Rsa152 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:Basic192Rsa15", &(a->wsp__Content::sp__Basic192Rsa15), "xsd:string"))
				{	soap_flag_sp__Basic192Rsa152--;
					continue;
				}
			if (soap_flag_sp__Basic128Rsa152 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:Basic128Rsa15", &(a->wsp__Content::sp__Basic128Rsa15), "xsd:string"))
				{	soap_flag_sp__Basic128Rsa152--;
					continue;
				}
			if (soap_flag_sp__TripleDesRsa152 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:TripleDesRsa15", &(a->wsp__Content::sp__TripleDesRsa15), "xsd:string"))
				{	soap_flag_sp__TripleDesRsa152--;
					continue;
				}
			if (soap_flag_sp__Basic256Sha2562 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:Basic256Sha256", &(a->wsp__Content::sp__Basic256Sha256), "xsd:string"))
				{	soap_flag_sp__Basic256Sha2562--;
					continue;
				}
			if (soap_flag_sp__Basic192Sha2562 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:Basic192Sha256", &(a->wsp__Content::sp__Basic192Sha256), "xsd:string"))
				{	soap_flag_sp__Basic192Sha2562--;
					continue;
				}
			if (soap_flag_sp__Basic128Sha2562 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:Basic128Sha256", &(a->wsp__Content::sp__Basic128Sha256), "xsd:string"))
				{	soap_flag_sp__Basic128Sha2562--;
					continue;
				}
			if (soap_flag_sp__TripleDesSha2562 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:TripleDesSha256", &(a->wsp__Content::sp__TripleDesSha256), "xsd:string"))
				{	soap_flag_sp__TripleDesSha2562--;
					continue;
				}
			if (soap_flag_sp__Basic256Sha256Rsa152 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:Basic256Sha256Rsa15", &(a->wsp__Content::sp__Basic256Sha256Rsa15), "xsd:string"))
				{	soap_flag_sp__Basic256Sha256Rsa152--;
					continue;
				}
			if (soap_flag_sp__Basic192Sha256Rsa152 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:Basic192Sha256Rsa15", &(a->wsp__Content::sp__Basic192Sha256Rsa15), "xsd:string"))
				{	soap_flag_sp__Basic192Sha256Rsa152--;
					continue;
				}
			if (soap_flag_sp__Basic128Sha256Rsa152 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:Basic128Sha256Rsa15", &(a->wsp__Content::sp__Basic128Sha256Rsa15), "xsd:string"))
				{	soap_flag_sp__Basic128Sha256Rsa152--;
					continue;
				}
			if (soap_flag_sp__TripleDesSha256Rsa152 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:TripleDesSha256Rsa15", &(a->wsp__Content::sp__TripleDesSha256Rsa15), "xsd:string"))
				{	soap_flag_sp__TripleDesSha256Rsa152--;
					continue;
				}
			if (soap_flag_sp__InclusiveC14N2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:InclusiveC14N", &(a->wsp__Content::sp__InclusiveC14N), "xsd:string"))
				{	soap_flag_sp__InclusiveC14N2--;
					continue;
				}
			if (soap_flag_sp__SOAPNormalization102 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:SOAPNormalization10", &(a->wsp__Content::sp__SOAPNormalization10), "xsd:string"))
				{	soap_flag_sp__SOAPNormalization102--;
					continue;
				}
			if (soap_flag_sp__STRTransform102 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:STRTransform10", &(a->wsp__Content::sp__STRTransform10), "xsd:string"))
				{	soap_flag_sp__STRTransform102--;
					continue;
				}
			if (soap_flag_sp__Path102 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:Path10", &(a->wsp__Content::sp__Path10), "xsd:string"))
				{	soap_flag_sp__Path102--;
					continue;
				}
			if (soap_flag_sp__XPathFilter202 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:XPathFilter20", &(a->wsp__Content::sp__XPathFilter20), "xsd:string"))
				{	soap_flag_sp__XPathFilter202--;
					continue;
				}
			if (soap_flag_sp__AbsXPath2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "sp:AbsXPath", &(a->wsp__Content::sp__AbsXPath), "xsd:string"))
				{	soap_flag_sp__AbsXPath2--;
					continue;
				}
			if (soap_flag_wsam__AnonymousResponses2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "wsam:AnonymousResponses", &(a->wsp__Content::wsam__AnonymousResponses), "xsd:string"))
				{	soap_flag_wsam__AnonymousResponses2--;
					continue;
				}
			if (soap_flag_wsam__NonAnonymousResponses2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "wsam:NonAnonymousResponses", &(a->wsp__Content::wsam__NonAnonymousResponses), "xsd:string"))
				{	soap_flag_wsam__NonAnonymousResponses2--;
					continue;
				}
			/* transient traverse skipped */
			/* transient generate skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOf_XML(soap, "-any", &(a->wsp__Content::__any), ""))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (wsp__Policy *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsp__Policy, 0, sizeof(wsp__Policy), 0, soap_copy_wsp__Policy);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int wsp__Policy::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_wsp__Policy);
	if (this->soap_out(soap, tag?tag:"wsp:Policy", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *wsp__Policy::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_wsp__Policy(soap, this, tag, type);
}

SOAP_FMAC3 wsp__Policy * SOAP_FMAC4 soap_get_wsp__Policy(struct soap *soap, wsp__Policy *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsp__Policy(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 wsp__Policy * SOAP_FMAC2 soap_instantiate_wsp__Policy(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsp__Policy(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsp__Policy, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(wsp__Policy);
		if (size)
			*size = sizeof(wsp__Policy);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(wsp__Policy[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(wsp__Policy);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (wsp__Policy*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsp__Policy(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying wsp__Policy %p -> %p\n", q, p));
	*(wsp__Policy*)p = *(wsp__Policy*)q;
}

void wsa__EndpointReferenceType::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__anyURI(soap, &this->wsa__EndpointReferenceType::Address);
	this->wsa__EndpointReferenceType::__any = NULL;
}

void wsa__EndpointReferenceType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_xsd__anyURI(soap, &this->wsa__EndpointReferenceType::Address);
}

int wsa__EndpointReferenceType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_wsa__EndpointReferenceType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsa__EndpointReferenceType(struct soap *soap, const char *tag, int id, const wsa__EndpointReferenceType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsa__EndpointReferenceType), type))
		return soap->error;
	if (soap_out_xsd__anyURI(soap, "wsa:Address", -1, &(a->wsa__EndpointReferenceType::Address), ""))
		return soap->error;
	soap_outliteral(soap, "-any", &(a->wsa__EndpointReferenceType::__any), NULL);
	return soap_element_end_out(soap, tag);
}

void *wsa__EndpointReferenceType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_wsa__EndpointReferenceType(soap, tag, this, type);
}

SOAP_FMAC3 wsa__EndpointReferenceType * SOAP_FMAC4 soap_in_wsa__EndpointReferenceType(struct soap *soap, const char *tag, wsa__EndpointReferenceType *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (wsa__EndpointReferenceType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_wsa__EndpointReferenceType, sizeof(wsa__EndpointReferenceType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_wsa__EndpointReferenceType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (wsa__EndpointReferenceType *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_Address1 = 1;
	size_t soap_flag___any1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Address1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__anyURI(soap, "wsa:Address", &(a->wsa__EndpointReferenceType::Address), "xsd:anyURI"))
				{	soap_flag_Address1--;
					continue;
				}
			if (soap_flag___any1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &(a->wsa__EndpointReferenceType::__any)))
				{	soap_flag___any1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (wsa__EndpointReferenceType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsa__EndpointReferenceType, 0, sizeof(wsa__EndpointReferenceType), 0, soap_copy_wsa__EndpointReferenceType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int wsa__EndpointReferenceType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_wsa__EndpointReferenceType);
	if (this->soap_out(soap, tag?tag:"wsa:EndpointReferenceType", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *wsa__EndpointReferenceType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_wsa__EndpointReferenceType(soap, this, tag, type);
}

SOAP_FMAC3 wsa__EndpointReferenceType * SOAP_FMAC4 soap_get_wsa__EndpointReferenceType(struct soap *soap, wsa__EndpointReferenceType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsa__EndpointReferenceType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 wsa__EndpointReferenceType * SOAP_FMAC2 soap_instantiate_wsa__EndpointReferenceType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsa__EndpointReferenceType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsa__EndpointReferenceType, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(wsa__EndpointReferenceType);
		if (size)
			*size = sizeof(wsa__EndpointReferenceType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(wsa__EndpointReferenceType[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(wsa__EndpointReferenceType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (wsa__EndpointReferenceType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsa__EndpointReferenceType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying wsa__EndpointReferenceType %p -> %p\n", q, p));
	*(wsa__EndpointReferenceType*)p = *(wsa__EndpointReferenceType*)q;
}

void gwsdl__portType::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__NMTOKEN(soap, &this->gwsdl__portType::name);
	soap_default_xsd__QName(soap, &this->gwsdl__portType::extends);
	soap_default_xsd__string(soap, &this->gwsdl__portType::documentation);
	soap_default_std__vectorTemplateOfPointerTowsdl__operation(soap, &this->gwsdl__portType::operation);
	soap_default_std__vectorTemplateOfsd__serviceData(soap, &this->gwsdl__portType::sd__serviceData_);
	this->gwsdl__portType::sd__staticServiceDataValues_ = NULL;
}

void gwsdl__portType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &this->gwsdl__portType::documentation);
	soap_serialize_std__vectorTemplateOfPointerTowsdl__operation(soap, &this->gwsdl__portType::operation);
	soap_serialize_std__vectorTemplateOfsd__serviceData(soap, &this->gwsdl__portType::sd__serviceData_);
	soap_serialize_PointerTosd__staticServiceDataValues(soap, &this->gwsdl__portType::sd__staticServiceDataValues_);
}

int gwsdl__portType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_gwsdl__portType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_gwsdl__portType(struct soap *soap, const char *tag, int id, const gwsdl__portType *a, const char *type)
{
	if (((gwsdl__portType*)a)->name)
		soap_set_attr(soap, "name", ((gwsdl__portType*)a)->name, 1);
	if (((gwsdl__portType*)a)->extends)
		soap_set_attr(soap, "extends", soap_QName2s(soap, ((gwsdl__portType*)a)->extends), 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_gwsdl__portType), type))
		return soap->error;
	if (soap_out_xsd__string(soap, "documentation", -1, &(a->gwsdl__portType::documentation), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfPointerTowsdl__operation(soap, "operation", -1, &(a->gwsdl__portType::operation), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfsd__serviceData(soap, "sd:serviceData", -1, &(a->gwsdl__portType::sd__serviceData_), ""))
		return soap->error;
	if (soap_out_PointerTosd__staticServiceDataValues(soap, "sd:staticServiceDataValues", -1, &(a->gwsdl__portType::sd__staticServiceDataValues_), ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *gwsdl__portType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_gwsdl__portType(soap, tag, this, type);
}

SOAP_FMAC3 gwsdl__portType * SOAP_FMAC4 soap_in_gwsdl__portType(struct soap *soap, const char *tag, gwsdl__portType *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (gwsdl__portType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_gwsdl__portType, sizeof(gwsdl__portType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_gwsdl__portType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (gwsdl__portType *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "name", 0), &((gwsdl__portType*)a)->name, 0, -1))
		return NULL;
	if (soap_s2QName(soap, soap_attr_value(soap, "extends", 0), &((gwsdl__portType*)a)->extends, 0, -1))
		return NULL;
	size_t soap_flag_documentation1 = 1;
	size_t soap_flag_sd__staticServiceDataValues_1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_documentation1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "documentation", &(a->gwsdl__portType::documentation), "xsd:string"))
				{	soap_flag_documentation1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerTowsdl__operation(soap, "operation", &(a->gwsdl__portType::operation), "wsdl:operation"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfsd__serviceData(soap, "sd:serviceData", &(a->gwsdl__portType::sd__serviceData_), "sd:serviceData"))
					continue;
			if (soap_flag_sd__staticServiceDataValues_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosd__staticServiceDataValues(soap, "sd:staticServiceDataValues", &(a->gwsdl__portType::sd__staticServiceDataValues_), "sd:staticServiceDataValues"))
				{	soap_flag_sd__staticServiceDataValues_1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (gwsdl__portType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_gwsdl__portType, 0, sizeof(gwsdl__portType), 0, soap_copy_gwsdl__portType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int gwsdl__portType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_gwsdl__portType);
	if (this->soap_out(soap, tag?tag:"gwsdl:portType", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *gwsdl__portType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_gwsdl__portType(soap, this, tag, type);
}

SOAP_FMAC3 gwsdl__portType * SOAP_FMAC4 soap_get_gwsdl__portType(struct soap *soap, gwsdl__portType *p, const char *tag, const char *type)
{
	if ((p = soap_in_gwsdl__portType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 gwsdl__portType * SOAP_FMAC2 soap_instantiate_gwsdl__portType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_gwsdl__portType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_gwsdl__portType, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(gwsdl__portType);
		if (size)
			*size = sizeof(gwsdl__portType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(gwsdl__portType[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(gwsdl__portType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (gwsdl__portType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_gwsdl__portType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying gwsdl__portType %p -> %p\n", q, p));
	*(gwsdl__portType*)p = *(gwsdl__portType*)q;
}

void sd__staticServiceDataValues::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	this->sd__staticServiceDataValues::__type = 0;
	this->sd__staticServiceDataValues::_any = NULL;
}

void sd__staticServiceDataValues::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_markelement(soap, this->_any, this->__type);
}

int sd__staticServiceDataValues::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_sd__staticServiceDataValues(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sd__staticServiceDataValues(struct soap *soap, const char *tag, int id, const sd__staticServiceDataValues *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sd__staticServiceDataValues), type))
		return soap->error;
	if (soap_putelement(soap, a->sd__staticServiceDataValues::_any, "-type", -1, a->sd__staticServiceDataValues::__type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *sd__staticServiceDataValues::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_sd__staticServiceDataValues(soap, tag, this, type);
}

SOAP_FMAC3 sd__staticServiceDataValues * SOAP_FMAC4 soap_in_sd__staticServiceDataValues(struct soap *soap, const char *tag, sd__staticServiceDataValues *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (sd__staticServiceDataValues *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_sd__staticServiceDataValues, sizeof(sd__staticServiceDataValues), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_sd__staticServiceDataValues)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (sd__staticServiceDataValues *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag__any1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__any1 && soap->error == SOAP_TAG_MISMATCH)
				if ((a->sd__staticServiceDataValues::_any = soap_getelement(soap, &a->sd__staticServiceDataValues::__type)))
				{	soap_flag__any1 = 0;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (sd__staticServiceDataValues *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sd__staticServiceDataValues, 0, sizeof(sd__staticServiceDataValues), 0, soap_copy_sd__staticServiceDataValues);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__any1 > 1))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

int sd__staticServiceDataValues::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_sd__staticServiceDataValues);
	if (this->soap_out(soap, tag?tag:"sd:staticServiceDataValues", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *sd__staticServiceDataValues::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_sd__staticServiceDataValues(soap, this, tag, type);
}

SOAP_FMAC3 sd__staticServiceDataValues * SOAP_FMAC4 soap_get_sd__staticServiceDataValues(struct soap *soap, sd__staticServiceDataValues *p, const char *tag, const char *type)
{
	if ((p = soap_in_sd__staticServiceDataValues(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 sd__staticServiceDataValues * SOAP_FMAC2 soap_instantiate_sd__staticServiceDataValues(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_sd__staticServiceDataValues(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_sd__staticServiceDataValues, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(sd__staticServiceDataValues);
		if (size)
			*size = sizeof(sd__staticServiceDataValues);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(sd__staticServiceDataValues[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(sd__staticServiceDataValues);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (sd__staticServiceDataValues*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_sd__staticServiceDataValues(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying sd__staticServiceDataValues %p -> %p\n", q, p));
	*(sd__staticServiceDataValues*)p = *(sd__staticServiceDataValues*)q;
}

void sd__serviceData::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__NMTOKEN(soap, &this->sd__serviceData::name);
	soap_default_xsd__QName(soap, &this->sd__serviceData::type);
	this->sd__serviceData::nillable = (bool)0;
	soap_default_xsd__string(soap, &this->sd__serviceData::minOccurs);
	soap_default_xsd__string(soap, &this->sd__serviceData::maxOccurs);
	this->sd__serviceData::mutability = (enum sd__mutability)2;
	this->sd__serviceData::modifiable = (bool)0;
}

void sd__serviceData::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
}

int sd__serviceData::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_sd__serviceData(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_sd__serviceData(struct soap *soap, const char *tag, int id, const sd__serviceData *a, const char *type)
{
	if (((sd__serviceData*)a)->name)
		soap_set_attr(soap, "name", ((sd__serviceData*)a)->name, 1);
	if (((sd__serviceData*)a)->type)
		soap_set_attr(soap, "type", soap_QName2s(soap, ((sd__serviceData*)a)->type), 1);
	soap_set_attr(soap, "nillable", soap_xsd__boolean2s(soap, ((sd__serviceData*)a)->nillable), 1);
	if (((sd__serviceData*)a)->minOccurs)
		soap_set_attr(soap, "minOccurs", ((sd__serviceData*)a)->minOccurs, 1);
	if (((sd__serviceData*)a)->maxOccurs)
		soap_set_attr(soap, "maxOccurs", ((sd__serviceData*)a)->maxOccurs, 1);
	soap_set_attr(soap, "mutability", soap_sd__mutability2s(soap, ((sd__serviceData*)a)->mutability), 1);
	soap_set_attr(soap, "modifiable", soap_xsd__boolean2s(soap, ((sd__serviceData*)a)->modifiable), 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_sd__serviceData), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *sd__serviceData::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_sd__serviceData(soap, tag, this, type);
}

SOAP_FMAC3 sd__serviceData * SOAP_FMAC4 soap_in_sd__serviceData(struct soap *soap, const char *tag, sd__serviceData *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (sd__serviceData *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_sd__serviceData, sizeof(sd__serviceData), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_sd__serviceData)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (sd__serviceData *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "name", 0), &((sd__serviceData*)a)->name, 0, -1))
		return NULL;
	if (soap_s2QName(soap, soap_attr_value(soap, "type", 0), &((sd__serviceData*)a)->type, 0, -1))
		return NULL;
	if (soap_s2xsd__boolean(soap, soap_attr_value(soap, "nillable", 0), &((sd__serviceData*)a)->nillable))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "minOccurs", 0), &((sd__serviceData*)a)->minOccurs, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "maxOccurs", 0), &((sd__serviceData*)a)->maxOccurs, 0, -1))
		return NULL;
	if (soap_s2sd__mutability(soap, soap_attr_value(soap, "mutability", 0), &((sd__serviceData*)a)->mutability))
		return NULL;
	if (soap_s2xsd__boolean(soap, soap_attr_value(soap, "modifiable", 0), &((sd__serviceData*)a)->modifiable))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (sd__serviceData *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_sd__serviceData, 0, sizeof(sd__serviceData), 0, soap_copy_sd__serviceData);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int sd__serviceData::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_sd__serviceData);
	if (this->soap_out(soap, tag?tag:"sd:serviceData", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *sd__serviceData::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_sd__serviceData(soap, this, tag, type);
}

SOAP_FMAC3 sd__serviceData * SOAP_FMAC4 soap_get_sd__serviceData(struct soap *soap, sd__serviceData *p, const char *tag, const char *type)
{
	if ((p = soap_in_sd__serviceData(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 sd__serviceData * SOAP_FMAC2 soap_instantiate_sd__serviceData(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_sd__serviceData(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_sd__serviceData, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(sd__serviceData);
		if (size)
			*size = sizeof(sd__serviceData);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(sd__serviceData[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(sd__serviceData);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (sd__serviceData*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_sd__serviceData(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying sd__serviceData %p -> %p\n", q, p));
	*(sd__serviceData*)p = *(sd__serviceData*)q;
}

void wsdl__operation::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__NMTOKEN(soap, &this->wsdl__operation::name);
	soap_default_xsd__string(soap, &this->wsdl__operation::parameterOrder);
	soap_default_xsd__string(soap, &this->wsdl__operation::documentation);
	this->wsdl__operation::wsp__Policy_ = NULL;
	this->wsdl__operation::wsp__PolicyReference_ = NULL;
	this->wsdl__operation::input = NULL;
	this->wsdl__operation::output = NULL;
	soap_default_std__vectorTemplateOfwsdl__fault(soap, &this->wsdl__operation::fault);
}

void wsdl__operation::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &this->wsdl__operation::documentation);
	soap_serialize_PointerTowsp__Policy(soap, &this->wsdl__operation::wsp__Policy_);
	soap_serialize_PointerTowsp__PolicyReference(soap, &this->wsdl__operation::wsp__PolicyReference_);
	soap_serialize_PointerTowsdl__input(soap, &this->wsdl__operation::input);
	soap_serialize_PointerTowsdl__output(soap, &this->wsdl__operation::output);
	soap_serialize_std__vectorTemplateOfwsdl__fault(soap, &this->wsdl__operation::fault);
	/* transient traverse skipped */
}

int wsdl__operation::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_wsdl__operation(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsdl__operation(struct soap *soap, const char *tag, int id, const wsdl__operation *a, const char *type)
{
	if (((wsdl__operation*)a)->name)
		soap_set_attr(soap, "name", ((wsdl__operation*)a)->name, 1);
	if (((wsdl__operation*)a)->parameterOrder)
		soap_set_attr(soap, "parameterOrder", ((wsdl__operation*)a)->parameterOrder, 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsdl__operation), type))
		return soap->error;
	if (soap_out_xsd__string(soap, "wsdl:documentation", -1, &(a->wsdl__operation::documentation), ""))
		return soap->error;
	if (soap_out_PointerTowsp__Policy(soap, "wsp:Policy", -1, &(a->wsdl__operation::wsp__Policy_), ""))
		return soap->error;
	if (soap_out_PointerTowsp__PolicyReference(soap, "wsp:PolicyReference", -1, &(a->wsdl__operation::wsp__PolicyReference_), ""))
		return soap->error;
	if (soap_out_PointerTowsdl__input(soap, "wsdl:input", -1, &(a->wsdl__operation::input), ""))
		return soap->error;
	if (soap_out_PointerTowsdl__output(soap, "wsdl:output", -1, &(a->wsdl__operation::output), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfwsdl__fault(soap, "wsdl:fault", -1, &(a->wsdl__operation::fault), ""))
		return soap->error;
	/* transient traverse skipped */
	return soap_element_end_out(soap, tag);
}

void *wsdl__operation::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_wsdl__operation(soap, tag, this, type);
}

SOAP_FMAC3 wsdl__operation * SOAP_FMAC4 soap_in_wsdl__operation(struct soap *soap, const char *tag, wsdl__operation *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (wsdl__operation *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_wsdl__operation, sizeof(wsdl__operation), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_wsdl__operation)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (wsdl__operation *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "name", 0), &((wsdl__operation*)a)->name, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "parameterOrder", 0), &((wsdl__operation*)a)->parameterOrder, 0, -1))
		return NULL;
	size_t soap_flag_documentation1 = 1;
	size_t soap_flag_wsp__Policy_1 = 1;
	size_t soap_flag_wsp__PolicyReference_1 = 1;
	size_t soap_flag_input1 = 1;
	size_t soap_flag_output1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_documentation1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "wsdl:documentation", &(a->wsdl__operation::documentation), "xsd:string"))
				{	soap_flag_documentation1--;
					continue;
				}
			if (soap_flag_wsp__Policy_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__Policy(soap, "wsp:Policy", &(a->wsdl__operation::wsp__Policy_), "wsp:Policy"))
				{	soap_flag_wsp__Policy_1--;
					continue;
				}
			if (soap_flag_wsp__PolicyReference_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsp__PolicyReference(soap, "wsp:PolicyReference", &(a->wsdl__operation::wsp__PolicyReference_), "wsp:PolicyReference"))
				{	soap_flag_wsp__PolicyReference_1--;
					continue;
				}
			if (soap_flag_input1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsdl__input(soap, "wsdl:input", &(a->wsdl__operation::input), "wsdl:input"))
				{	soap_flag_input1--;
					continue;
				}
			if (soap_flag_output1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsdl__output(soap, "wsdl:output", &(a->wsdl__operation::output), "wsdl:output"))
				{	soap_flag_output1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfwsdl__fault(soap, "wsdl:fault", &(a->wsdl__operation::fault), "wsdl:fault"))
					continue;
			/* transient traverse skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (wsdl__operation *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsdl__operation, 0, sizeof(wsdl__operation), 0, soap_copy_wsdl__operation);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int wsdl__operation::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_wsdl__operation);
	if (this->soap_out(soap, tag?tag:"wsdl:operation", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *wsdl__operation::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_wsdl__operation(soap, this, tag, type);
}

SOAP_FMAC3 wsdl__operation * SOAP_FMAC4 soap_get_wsdl__operation(struct soap *soap, wsdl__operation *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsdl__operation(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 wsdl__operation * SOAP_FMAC2 soap_instantiate_wsdl__operation(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsdl__operation(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsdl__operation, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(wsdl__operation);
		if (size)
			*size = sizeof(wsdl__operation);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(wsdl__operation[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(wsdl__operation);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (wsdl__operation*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsdl__operation(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying wsdl__operation %p -> %p\n", q, p));
	*(wsdl__operation*)p = *(wsdl__operation*)q;
}

void http__operation::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__anyURI(soap, &this->http__operation::location);
}

void http__operation::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
}

int http__operation::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_http__operation(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_http__operation(struct soap *soap, const char *tag, int id, const http__operation *a, const char *type)
{
	if (((http__operation*)a)->location)
		soap_set_attr(soap, "location", ((http__operation*)a)->location, 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_http__operation), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *http__operation::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_http__operation(soap, tag, this, type);
}

SOAP_FMAC3 http__operation * SOAP_FMAC4 soap_in_http__operation(struct soap *soap, const char *tag, http__operation *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (http__operation *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_http__operation, sizeof(http__operation), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_http__operation)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (http__operation *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "location", 0), &((http__operation*)a)->location, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (http__operation *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_http__operation, 0, sizeof(http__operation), 0, soap_copy_http__operation);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int http__operation::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_http__operation);
	if (this->soap_out(soap, tag?tag:"http:operation", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *http__operation::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_http__operation(soap, this, tag, type);
}

SOAP_FMAC3 http__operation * SOAP_FMAC4 soap_get_http__operation(struct soap *soap, http__operation *p, const char *tag, const char *type)
{
	if ((p = soap_in_http__operation(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 http__operation * SOAP_FMAC2 soap_instantiate_http__operation(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_http__operation(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_http__operation, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(http__operation);
		if (size)
			*size = sizeof(http__operation);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(http__operation[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(http__operation);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (http__operation*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_http__operation(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying http__operation %p -> %p\n", q, p));
	*(http__operation*)p = *(http__operation*)q;
}

void http__binding::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__NMTOKEN(soap, &this->http__binding::verb);
}

void http__binding::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
}

int http__binding::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_http__binding(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_http__binding(struct soap *soap, const char *tag, int id, const http__binding *a, const char *type)
{
	if (((http__binding*)a)->verb)
		soap_set_attr(soap, "verb", ((http__binding*)a)->verb, 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_http__binding), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *http__binding::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_http__binding(soap, tag, this, type);
}

SOAP_FMAC3 http__binding * SOAP_FMAC4 soap_in_http__binding(struct soap *soap, const char *tag, http__binding *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (http__binding *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_http__binding, sizeof(http__binding), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_http__binding)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (http__binding *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "verb", 0), &((http__binding*)a)->verb, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (http__binding *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_http__binding, 0, sizeof(http__binding), 0, soap_copy_http__binding);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int http__binding::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_http__binding);
	if (this->soap_out(soap, tag?tag:"http:binding", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *http__binding::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_http__binding(soap, this, tag, type);
}

SOAP_FMAC3 http__binding * SOAP_FMAC4 soap_get_http__binding(struct soap *soap, http__binding *p, const char *tag, const char *type)
{
	if ((p = soap_in_http__binding(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 http__binding * SOAP_FMAC2 soap_instantiate_http__binding(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_http__binding(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_http__binding, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(http__binding);
		if (size)
			*size = sizeof(http__binding);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(http__binding[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(http__binding);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (http__binding*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_http__binding(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying http__binding %p -> %p\n", q, p));
	*(http__binding*)p = *(http__binding*)q;
}

void http__address::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__anyURI(soap, &this->http__address::location);
}

void http__address::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
}

int http__address::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_http__address(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_http__address(struct soap *soap, const char *tag, int id, const http__address *a, const char *type)
{
	if (((http__address*)a)->location)
		soap_set_attr(soap, "location", ((http__address*)a)->location, 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_http__address), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *http__address::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_http__address(soap, tag, this, type);
}

SOAP_FMAC3 http__address * SOAP_FMAC4 soap_in_http__address(struct soap *soap, const char *tag, http__address *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (http__address *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_http__address, sizeof(http__address), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_http__address)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (http__address *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "location", 0), &((http__address*)a)->location, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (http__address *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_http__address, 0, sizeof(http__address), 0, soap_copy_http__address);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int http__address::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_http__address);
	if (this->soap_out(soap, tag?tag:"http:address", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *http__address::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_http__address(soap, this, tag, type);
}

SOAP_FMAC3 http__address * SOAP_FMAC4 soap_get_http__address(struct soap *soap, http__address *p, const char *tag, const char *type)
{
	if ((p = soap_in_http__address(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 http__address * SOAP_FMAC2 soap_instantiate_http__address(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_http__address(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_http__address, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(http__address);
		if (size)
			*size = sizeof(http__address);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(http__address[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(http__address);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (http__address*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_http__address(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying http__address %p -> %p\n", q, p));
	*(http__address*)p = *(http__address*)q;
}

void dime__message::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__anyURI(soap, &this->dime__message::layout);
}

void dime__message::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
}

int dime__message::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_dime__message(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_dime__message(struct soap *soap, const char *tag, int id, const dime__message *a, const char *type)
{
	if (((dime__message*)a)->layout)
		soap_set_attr(soap, "layout", ((dime__message*)a)->layout, 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_dime__message), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *dime__message::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_dime__message(soap, tag, this, type);
}

SOAP_FMAC3 dime__message * SOAP_FMAC4 soap_in_dime__message(struct soap *soap, const char *tag, dime__message *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (dime__message *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_dime__message, sizeof(dime__message), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_dime__message)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (dime__message *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "layout", 0), &((dime__message*)a)->layout, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (dime__message *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_dime__message, 0, sizeof(dime__message), 0, soap_copy_dime__message);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int dime__message::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_dime__message);
	if (this->soap_out(soap, tag?tag:"dime:message", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *dime__message::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_dime__message(soap, this, tag, type);
}

SOAP_FMAC3 dime__message * SOAP_FMAC4 soap_get_dime__message(struct soap *soap, dime__message *p, const char *tag, const char *type)
{
	if ((p = soap_in_dime__message(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 dime__message * SOAP_FMAC2 soap_instantiate_dime__message(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_dime__message(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_dime__message, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(dime__message);
		if (size)
			*size = sizeof(dime__message);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(dime__message[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(dime__message);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (dime__message*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_dime__message(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying dime__message %p -> %p\n", q, p));
	*(dime__message*)p = *(dime__message*)q;
}

void mime__mimeXml::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__NMTOKEN(soap, &this->mime__mimeXml::part);
}

void mime__mimeXml::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
}

int mime__mimeXml::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_mime__mimeXml(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_mime__mimeXml(struct soap *soap, const char *tag, int id, const mime__mimeXml *a, const char *type)
{
	if (((mime__mimeXml*)a)->part)
		soap_set_attr(soap, "part", ((mime__mimeXml*)a)->part, 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_mime__mimeXml), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *mime__mimeXml::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_mime__mimeXml(soap, tag, this, type);
}

SOAP_FMAC3 mime__mimeXml * SOAP_FMAC4 soap_in_mime__mimeXml(struct soap *soap, const char *tag, mime__mimeXml *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (mime__mimeXml *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_mime__mimeXml, sizeof(mime__mimeXml), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_mime__mimeXml)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (mime__mimeXml *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "part", 0), &((mime__mimeXml*)a)->part, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (mime__mimeXml *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_mime__mimeXml, 0, sizeof(mime__mimeXml), 0, soap_copy_mime__mimeXml);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int mime__mimeXml::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_mime__mimeXml);
	if (this->soap_out(soap, tag?tag:"mime:mimeXml", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *mime__mimeXml::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_mime__mimeXml(soap, this, tag, type);
}

SOAP_FMAC3 mime__mimeXml * SOAP_FMAC4 soap_get_mime__mimeXml(struct soap *soap, mime__mimeXml *p, const char *tag, const char *type)
{
	if ((p = soap_in_mime__mimeXml(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 mime__mimeXml * SOAP_FMAC2 soap_instantiate_mime__mimeXml(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_mime__mimeXml(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_mime__mimeXml, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(mime__mimeXml);
		if (size)
			*size = sizeof(mime__mimeXml);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(mime__mimeXml[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(mime__mimeXml);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (mime__mimeXml*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_mime__mimeXml(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying mime__mimeXml %p -> %p\n", q, p));
	*(mime__mimeXml*)p = *(mime__mimeXml*)q;
}

void mime__multipartRelated::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_std__vectorTemplateOfmime__part(soap, &this->mime__multipartRelated::part);
}

void mime__multipartRelated::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfmime__part(soap, &this->mime__multipartRelated::part);
	/* transient traverse skipped */
}

int mime__multipartRelated::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_mime__multipartRelated(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_mime__multipartRelated(struct soap *soap, const char *tag, int id, const mime__multipartRelated *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_mime__multipartRelated), type))
		return soap->error;
	if (soap_out_std__vectorTemplateOfmime__part(soap, "part", -1, &(a->mime__multipartRelated::part), ""))
		return soap->error;
	/* transient traverse skipped */
	return soap_element_end_out(soap, tag);
}

void *mime__multipartRelated::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_mime__multipartRelated(soap, tag, this, type);
}

SOAP_FMAC3 mime__multipartRelated * SOAP_FMAC4 soap_in_mime__multipartRelated(struct soap *soap, const char *tag, mime__multipartRelated *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (mime__multipartRelated *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_mime__multipartRelated, sizeof(mime__multipartRelated), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_mime__multipartRelated)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (mime__multipartRelated *)a->soap_in(soap, tag, type);
		}
	}
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfmime__part(soap, "part", &(a->mime__multipartRelated::part), "mime:part"))
					continue;
			/* transient traverse skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (mime__multipartRelated *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_mime__multipartRelated, 0, sizeof(mime__multipartRelated), 0, soap_copy_mime__multipartRelated);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int mime__multipartRelated::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_mime__multipartRelated);
	if (this->soap_out(soap, tag?tag:"mime:multipartRelated", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *mime__multipartRelated::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_mime__multipartRelated(soap, this, tag, type);
}

SOAP_FMAC3 mime__multipartRelated * SOAP_FMAC4 soap_get_mime__multipartRelated(struct soap *soap, mime__multipartRelated *p, const char *tag, const char *type)
{
	if ((p = soap_in_mime__multipartRelated(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 mime__multipartRelated * SOAP_FMAC2 soap_instantiate_mime__multipartRelated(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_mime__multipartRelated(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_mime__multipartRelated, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(mime__multipartRelated);
		if (size)
			*size = sizeof(mime__multipartRelated);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(mime__multipartRelated[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(mime__multipartRelated);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (mime__multipartRelated*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_mime__multipartRelated(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying mime__multipartRelated %p -> %p\n", q, p));
	*(mime__multipartRelated*)p = *(mime__multipartRelated*)q;
}

void mime__part::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	this->mime__part::soap__body_ = NULL;
	soap_default_std__vectorTemplateOfsoap__header(soap, &this->mime__part::soap__header_);
	soap_default_std__vectorTemplateOfmime__content(soap, &this->mime__part::content);
}

void mime__part::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTosoap__body(soap, &this->mime__part::soap__body_);
	soap_serialize_std__vectorTemplateOfsoap__header(soap, &this->mime__part::soap__header_);
	soap_serialize_std__vectorTemplateOfmime__content(soap, &this->mime__part::content);
	/* transient traverse skipped */
}

int mime__part::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_mime__part(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_mime__part(struct soap *soap, const char *tag, int id, const mime__part *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_mime__part), type))
		return soap->error;
	if (soap_out_PointerTosoap__body(soap, "soap:body", -1, &(a->mime__part::soap__body_), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfsoap__header(soap, "soap:header", -1, &(a->mime__part::soap__header_), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfmime__content(soap, "content", -1, &(a->mime__part::content), ""))
		return soap->error;
	/* transient traverse skipped */
	return soap_element_end_out(soap, tag);
}

void *mime__part::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_mime__part(soap, tag, this, type);
}

SOAP_FMAC3 mime__part * SOAP_FMAC4 soap_in_mime__part(struct soap *soap, const char *tag, mime__part *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (mime__part *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_mime__part, sizeof(mime__part), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_mime__part)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (mime__part *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_soap__body_1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_soap__body_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTosoap__body(soap, "soap:body", &(a->mime__part::soap__body_), "soap:body"))
				{	soap_flag_soap__body_1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfsoap__header(soap, "soap:header", &(a->mime__part::soap__header_), "soap:header"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfmime__content(soap, "content", &(a->mime__part::content), "mime:content"))
					continue;
			/* transient traverse skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (mime__part *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_mime__part, 0, sizeof(mime__part), 0, soap_copy_mime__part);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int mime__part::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_mime__part);
	if (this->soap_out(soap, tag?tag:"mime:part", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *mime__part::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_mime__part(soap, this, tag, type);
}

SOAP_FMAC3 mime__part * SOAP_FMAC4 soap_get_mime__part(struct soap *soap, mime__part *p, const char *tag, const char *type)
{
	if ((p = soap_in_mime__part(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 mime__part * SOAP_FMAC2 soap_instantiate_mime__part(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_mime__part(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_mime__part, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(mime__part);
		if (size)
			*size = sizeof(mime__part);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(mime__part[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(mime__part);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (mime__part*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_mime__part(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying mime__part %p -> %p\n", q, p));
	*(mime__part*)p = *(mime__part*)q;
}

void mime__content::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__NMTOKEN(soap, &this->mime__content::part);
	soap_default_xsd__string(soap, &this->mime__content::type);
}

void mime__content::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
}

int mime__content::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_mime__content(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_mime__content(struct soap *soap, const char *tag, int id, const mime__content *a, const char *type)
{
	if (((mime__content*)a)->part)
		soap_set_attr(soap, "part", ((mime__content*)a)->part, 1);
	if (((mime__content*)a)->type)
		soap_set_attr(soap, "type", ((mime__content*)a)->type, 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_mime__content), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *mime__content::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_mime__content(soap, tag, this, type);
}

SOAP_FMAC3 mime__content * SOAP_FMAC4 soap_in_mime__content(struct soap *soap, const char *tag, mime__content *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (mime__content *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_mime__content, sizeof(mime__content), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_mime__content)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (mime__content *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "part", 0), &((mime__content*)a)->part, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "type", 0), &((mime__content*)a)->type, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (mime__content *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_mime__content, 0, sizeof(mime__content), 0, soap_copy_mime__content);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int mime__content::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_mime__content);
	if (this->soap_out(soap, tag?tag:"mime:content", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *mime__content::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_mime__content(soap, this, tag, type);
}

SOAP_FMAC3 mime__content * SOAP_FMAC4 soap_get_mime__content(struct soap *soap, mime__content *p, const char *tag, const char *type)
{
	if ((p = soap_in_mime__content(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 mime__content * SOAP_FMAC2 soap_instantiate_mime__content(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_mime__content(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_mime__content, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(mime__content);
		if (size)
			*size = sizeof(mime__content);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(mime__content[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(mime__content);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (mime__content*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_mime__content(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying mime__content %p -> %p\n", q, p));
	*(mime__content*)p = *(mime__content*)q;
}

void soap__address::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__anyURI(soap, &this->soap__address::location);
}

void soap__address::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
}

int soap__address::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_soap__address(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_soap__address(struct soap *soap, const char *tag, int id, const soap__address *a, const char *type)
{
	if (((soap__address*)a)->location)
		soap_set_attr(soap, "location", ((soap__address*)a)->location, 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_soap__address), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *soap__address::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_soap__address(soap, tag, this, type);
}

SOAP_FMAC3 soap__address * SOAP_FMAC4 soap_in_soap__address(struct soap *soap, const char *tag, soap__address *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (soap__address *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_soap__address, sizeof(soap__address), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_soap__address)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (soap__address *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "location", 0), &((soap__address*)a)->location, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (soap__address *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_soap__address, 0, sizeof(soap__address), 0, soap_copy_soap__address);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int soap__address::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_soap__address);
	if (this->soap_out(soap, tag?tag:"soap:address", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *soap__address::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_soap__address(soap, this, tag, type);
}

SOAP_FMAC3 soap__address * SOAP_FMAC4 soap_get_soap__address(struct soap *soap, soap__address *p, const char *tag, const char *type)
{
	if ((p = soap_in_soap__address(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 soap__address * SOAP_FMAC2 soap_instantiate_soap__address(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_soap__address(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_soap__address, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(soap__address);
		if (size)
			*size = sizeof(soap__address);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(soap__address[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(soap__address);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (soap__address*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_soap__address(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying soap__address %p -> %p\n", q, p));
	*(soap__address*)p = *(soap__address*)q;
}

void soap__header::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__QName(soap, &this->soap__header::message);
	soap_default_xsd__NMTOKEN(soap, &this->soap__header::part);
	soap_default_soap__useChoice(soap, &this->soap__header::use);
	soap_default_xsd__anyURI(soap, &this->soap__header::encodingStyle);
	soap_default_xsd__anyURI(soap, &this->soap__header::namespace_);
	soap_default_std__vectorTemplateOfsoap__headerfault(soap, &this->soap__header::headerfault);
	this->soap__header::messageRef = NULL;
	this->soap__header::partRef = NULL;
}

void soap__header::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfsoap__headerfault(soap, &this->soap__header::headerfault);
	/* non-serializable messageRef skipped */
	/* non-serializable partRef skipped */
	/* transient traverse skipped */
	/* transient messagePtr skipped */
	/* transient partPtr skipped */
	/* transient messagePtr skipped */
	/* transient partPtr skipped */
}

int soap__header::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_soap__header(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_soap__header(struct soap *soap, const char *tag, int id, const soap__header *a, const char *type)
{
	if (((soap__header*)a)->message)
		soap_set_attr(soap, "message", soap_QName2s(soap, ((soap__header*)a)->message), 1);
	if (((soap__header*)a)->part)
		soap_set_attr(soap, "part", ((soap__header*)a)->part, 1);
	soap_set_attr(soap, "use", soap_soap__useChoice2s(soap, ((soap__header*)a)->use), 1);
	if (((soap__header*)a)->encodingStyle)
		soap_set_attr(soap, "encodingStyle", ((soap__header*)a)->encodingStyle, 1);
	if (((soap__header*)a)->namespace_)
		soap_set_attr(soap, "namespace", ((soap__header*)a)->namespace_, 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_soap__header), type))
		return soap->error;
	if (soap_out_std__vectorTemplateOfsoap__headerfault(soap, "headerfault", -1, &(a->soap__header::headerfault), ""))
		return soap->error;
	/* non-serializable messageRef skipped */
	/* non-serializable partRef skipped */
	/* transient traverse skipped */
	/* transient messagePtr skipped */
	/* transient partPtr skipped */
	/* transient messagePtr skipped */
	/* transient partPtr skipped */
	return soap_element_end_out(soap, tag);
}

void *soap__header::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_soap__header(soap, tag, this, type);
}

SOAP_FMAC3 soap__header * SOAP_FMAC4 soap_in_soap__header(struct soap *soap, const char *tag, soap__header *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (soap__header *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_soap__header, sizeof(soap__header), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_soap__header)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (soap__header *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2QName(soap, soap_attr_value(soap, "message", 0), &((soap__header*)a)->message, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "part", 0), &((soap__header*)a)->part, 0, -1))
		return NULL;
	if (soap_s2soap__useChoice(soap, soap_attr_value(soap, "use", 0), &((soap__header*)a)->use))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "encodingStyle", 0), &((soap__header*)a)->encodingStyle, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "namespace", 0), &((soap__header*)a)->namespace_, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfsoap__headerfault(soap, "headerfault", &(a->soap__header::headerfault), "soap:headerfault"))
					continue;
			/* non-serializable messageRef skipped */
			/* non-serializable partRef skipped */
			/* transient traverse skipped */
			/* transient messagePtr skipped */
			/* transient partPtr skipped */
			/* transient messagePtr skipped */
			/* transient partPtr skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (soap__header *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_soap__header, 0, sizeof(soap__header), 0, soap_copy_soap__header);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int soap__header::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_soap__header);
	if (this->soap_out(soap, tag?tag:"soap:header", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *soap__header::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_soap__header(soap, this, tag, type);
}

SOAP_FMAC3 soap__header * SOAP_FMAC4 soap_get_soap__header(struct soap *soap, soap__header *p, const char *tag, const char *type)
{
	if ((p = soap_in_soap__header(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 soap__header * SOAP_FMAC2 soap_instantiate_soap__header(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_soap__header(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_soap__header, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(soap__header);
		if (size)
			*size = sizeof(soap__header);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(soap__header[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(soap__header);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (soap__header*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_soap__header(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying soap__header %p -> %p\n", q, p));
	*(soap__header*)p = *(soap__header*)q;
}

void soap__headerfault::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__QName(soap, &this->soap__headerfault::message);
	soap_default_xsd__NMTOKEN(soap, &this->soap__headerfault::part);
	soap_default_soap__useChoice(soap, &this->soap__headerfault::use);
	soap_default_xsd__anyURI(soap, &this->soap__headerfault::encodingStyle);
	soap_default_xsd__anyURI(soap, &this->soap__headerfault::namespace_);
	this->soap__headerfault::messageRef = NULL;
	this->soap__headerfault::partRef = NULL;
}

void soap__headerfault::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	/* non-serializable messageRef skipped */
	/* non-serializable partRef skipped */
	/* transient traverse skipped */
	/* transient messagePtr skipped */
	/* transient partPtr skipped */
	/* transient messagePtr skipped */
	/* transient partPtr skipped */
}

int soap__headerfault::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_soap__headerfault(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_soap__headerfault(struct soap *soap, const char *tag, int id, const soap__headerfault *a, const char *type)
{
	if (((soap__headerfault*)a)->message)
		soap_set_attr(soap, "message", soap_QName2s(soap, ((soap__headerfault*)a)->message), 1);
	if (((soap__headerfault*)a)->part)
		soap_set_attr(soap, "part", ((soap__headerfault*)a)->part, 1);
	soap_set_attr(soap, "use", soap_soap__useChoice2s(soap, ((soap__headerfault*)a)->use), 1);
	if (((soap__headerfault*)a)->encodingStyle)
		soap_set_attr(soap, "encodingStyle", ((soap__headerfault*)a)->encodingStyle, 1);
	if (((soap__headerfault*)a)->namespace_)
		soap_set_attr(soap, "namespace", ((soap__headerfault*)a)->namespace_, 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_soap__headerfault), type))
		return soap->error;
	/* non-serializable messageRef skipped */
	/* non-serializable partRef skipped */
	/* transient traverse skipped */
	/* transient messagePtr skipped */
	/* transient partPtr skipped */
	/* transient messagePtr skipped */
	/* transient partPtr skipped */
	return soap_element_end_out(soap, tag);
}

void *soap__headerfault::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_soap__headerfault(soap, tag, this, type);
}

SOAP_FMAC3 soap__headerfault * SOAP_FMAC4 soap_in_soap__headerfault(struct soap *soap, const char *tag, soap__headerfault *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (soap__headerfault *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_soap__headerfault, sizeof(soap__headerfault), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_soap__headerfault)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (soap__headerfault *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2QName(soap, soap_attr_value(soap, "message", 0), &((soap__headerfault*)a)->message, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "part", 0), &((soap__headerfault*)a)->part, 0, -1))
		return NULL;
	if (soap_s2soap__useChoice(soap, soap_attr_value(soap, "use", 0), &((soap__headerfault*)a)->use))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "encodingStyle", 0), &((soap__headerfault*)a)->encodingStyle, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "namespace", 0), &((soap__headerfault*)a)->namespace_, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			/* non-serializable messageRef skipped */
			/* non-serializable partRef skipped */
			/* transient traverse skipped */
			/* transient messagePtr skipped */
			/* transient partPtr skipped */
			/* transient messagePtr skipped */
			/* transient partPtr skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (soap__headerfault *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_soap__headerfault, 0, sizeof(soap__headerfault), 0, soap_copy_soap__headerfault);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int soap__headerfault::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_soap__headerfault);
	if (this->soap_out(soap, tag?tag:"soap:headerfault", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *soap__headerfault::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_soap__headerfault(soap, this, tag, type);
}

SOAP_FMAC3 soap__headerfault * SOAP_FMAC4 soap_get_soap__headerfault(struct soap *soap, soap__headerfault *p, const char *tag, const char *type)
{
	if ((p = soap_in_soap__headerfault(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 soap__headerfault * SOAP_FMAC2 soap_instantiate_soap__headerfault(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_soap__headerfault(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_soap__headerfault, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(soap__headerfault);
		if (size)
			*size = sizeof(soap__headerfault);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(soap__headerfault[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(soap__headerfault);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (soap__headerfault*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_soap__headerfault(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying soap__headerfault %p -> %p\n", q, p));
	*(soap__headerfault*)p = *(soap__headerfault*)q;
}

void soap__fault::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__NMTOKEN(soap, &this->soap__fault::name);
	soap_default_xsd__anyURI(soap, &this->soap__fault::encodingStyle);
	soap_default_soap__useChoice(soap, &this->soap__fault::use);
	soap_default_xsd__anyURI(soap, &this->soap__fault::namespace_);
}

void soap__fault::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
}

int soap__fault::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_soap__fault(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_soap__fault(struct soap *soap, const char *tag, int id, const soap__fault *a, const char *type)
{
	if (((soap__fault*)a)->name)
		soap_set_attr(soap, "name", ((soap__fault*)a)->name, 1);
	if (((soap__fault*)a)->encodingStyle)
		soap_set_attr(soap, "encodingStyle", ((soap__fault*)a)->encodingStyle, 1);
	soap_set_attr(soap, "use", soap_soap__useChoice2s(soap, ((soap__fault*)a)->use), 1);
	if (((soap__fault*)a)->namespace_)
		soap_set_attr(soap, "namespace", ((soap__fault*)a)->namespace_, 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_soap__fault), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *soap__fault::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_soap__fault(soap, tag, this, type);
}

SOAP_FMAC3 soap__fault * SOAP_FMAC4 soap_in_soap__fault(struct soap *soap, const char *tag, soap__fault *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (soap__fault *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_soap__fault, sizeof(soap__fault), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_soap__fault)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (soap__fault *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "name", 0), &((soap__fault*)a)->name, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "encodingStyle", 0), &((soap__fault*)a)->encodingStyle, 0, -1))
		return NULL;
	if (soap_s2soap__useChoice(soap, soap_attr_value(soap, "use", 0), &((soap__fault*)a)->use))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "namespace", 0), &((soap__fault*)a)->namespace_, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (soap__fault *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_soap__fault, 0, sizeof(soap__fault), 0, soap_copy_soap__fault);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int soap__fault::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_soap__fault);
	if (this->soap_out(soap, tag?tag:"soap:fault", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *soap__fault::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_soap__fault(soap, this, tag, type);
}

SOAP_FMAC3 soap__fault * SOAP_FMAC4 soap_get_soap__fault(struct soap *soap, soap__fault *p, const char *tag, const char *type)
{
	if ((p = soap_in_soap__fault(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 soap__fault * SOAP_FMAC2 soap_instantiate_soap__fault(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_soap__fault(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_soap__fault, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(soap__fault);
		if (size)
			*size = sizeof(soap__fault);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(soap__fault[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(soap__fault);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (soap__fault*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_soap__fault(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying soap__fault %p -> %p\n", q, p));
	*(soap__fault*)p = *(soap__fault*)q;
}

void soap__body::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__anyURI(soap, &this->soap__body::encodingStyle);
	soap_default_xsd__NMTOKENS(soap, &this->soap__body::parts);
	soap_default_soap__useChoice(soap, &this->soap__body::use);
	soap_default_xsd__anyURI(soap, &this->soap__body::namespace_);
}

void soap__body::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
}

int soap__body::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_soap__body(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_soap__body(struct soap *soap, const char *tag, int id, const soap__body *a, const char *type)
{
	if (((soap__body*)a)->encodingStyle)
		soap_set_attr(soap, "encodingStyle", ((soap__body*)a)->encodingStyle, 1);
	if (((soap__body*)a)->parts)
		soap_set_attr(soap, "parts", ((soap__body*)a)->parts, 1);
	soap_set_attr(soap, "use", soap_soap__useChoice2s(soap, ((soap__body*)a)->use), 1);
	if (((soap__body*)a)->namespace_)
		soap_set_attr(soap, "namespace", ((soap__body*)a)->namespace_, 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_soap__body), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *soap__body::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_soap__body(soap, tag, this, type);
}

SOAP_FMAC3 soap__body * SOAP_FMAC4 soap_in_soap__body(struct soap *soap, const char *tag, soap__body *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (soap__body *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_soap__body, sizeof(soap__body), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_soap__body)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (soap__body *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "encodingStyle", 0), &((soap__body*)a)->encodingStyle, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "parts", 0), &((soap__body*)a)->parts, 0, -1))
		return NULL;
	if (soap_s2soap__useChoice(soap, soap_attr_value(soap, "use", 0), &((soap__body*)a)->use))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "namespace", 0), &((soap__body*)a)->namespace_, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (soap__body *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_soap__body, 0, sizeof(soap__body), 0, soap_copy_soap__body);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int soap__body::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_soap__body);
	if (this->soap_out(soap, tag?tag:"soap:body", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *soap__body::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_soap__body(soap, this, tag, type);
}

SOAP_FMAC3 soap__body * SOAP_FMAC4 soap_get_soap__body(struct soap *soap, soap__body *p, const char *tag, const char *type)
{
	if ((p = soap_in_soap__body(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 soap__body * SOAP_FMAC2 soap_instantiate_soap__body(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_soap__body(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_soap__body, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(soap__body);
		if (size)
			*size = sizeof(soap__body);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(soap__body[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(soap__body);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (soap__body*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_soap__body(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying soap__body %p -> %p\n", q, p));
	*(soap__body*)p = *(soap__body*)q;
}

void soap__operation::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__anyURI(soap, &this->soap__operation::soapAction);
	this->soap__operation::style = NULL;
}

void soap__operation::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
}

int soap__operation::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_soap__operation(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_soap__operation(struct soap *soap, const char *tag, int id, const soap__operation *a, const char *type)
{
	if (((soap__operation*)a)->soapAction)
		soap_set_attr(soap, "soapAction", ((soap__operation*)a)->soapAction, 1);
	if (((soap__operation*)a)->style)
		soap_set_attr(soap, "style", soap_soap__styleChoice2s(soap, *((soap__operation*)a)->style), 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_soap__operation), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *soap__operation::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_soap__operation(soap, tag, this, type);
}

SOAP_FMAC3 soap__operation * SOAP_FMAC4 soap_in_soap__operation(struct soap *soap, const char *tag, soap__operation *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (soap__operation *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_soap__operation, sizeof(soap__operation), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_soap__operation)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (soap__operation *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "soapAction", 0), &((soap__operation*)a)->soapAction, 0, -1))
		return NULL;
	{	const char *t = soap_attr_value(soap, "style", 0);
		if (t)
		{
			if (!(((soap__operation*)a)->style = (enum soap__styleChoice *)soap_malloc(soap, sizeof(enum soap__styleChoice))))
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (soap_s2soap__styleChoice(soap, t, ((soap__operation*)a)->style))
			return NULL;
		}
		else if (soap->error)
			return NULL;
	}
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (soap__operation *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_soap__operation, 0, sizeof(soap__operation), 0, soap_copy_soap__operation);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int soap__operation::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_soap__operation);
	if (this->soap_out(soap, tag?tag:"soap:operation", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *soap__operation::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_soap__operation(soap, this, tag, type);
}

SOAP_FMAC3 soap__operation * SOAP_FMAC4 soap_get_soap__operation(struct soap *soap, soap__operation *p, const char *tag, const char *type)
{
	if ((p = soap_in_soap__operation(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 soap__operation * SOAP_FMAC2 soap_instantiate_soap__operation(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_soap__operation(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_soap__operation, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(soap__operation);
		if (size)
			*size = sizeof(soap__operation);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(soap__operation[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(soap__operation);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (soap__operation*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_soap__operation(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying soap__operation %p -> %p\n", q, p));
	*(soap__operation*)p = *(soap__operation*)q;
}

void soap__binding::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__anyURI(soap, &this->soap__binding::transport);
	this->soap__binding::style = NULL;
}

void soap__binding::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
}

int soap__binding::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_soap__binding(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_soap__binding(struct soap *soap, const char *tag, int id, const soap__binding *a, const char *type)
{
	if (((soap__binding*)a)->transport)
		soap_set_attr(soap, "transport", ((soap__binding*)a)->transport, 1);
	if (((soap__binding*)a)->style)
		soap_set_attr(soap, "style", soap_soap__styleChoice2s(soap, *((soap__binding*)a)->style), 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_soap__binding), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *soap__binding::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_soap__binding(soap, tag, this, type);
}

SOAP_FMAC3 soap__binding * SOAP_FMAC4 soap_in_soap__binding(struct soap *soap, const char *tag, soap__binding *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (soap__binding *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_soap__binding, sizeof(soap__binding), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_soap__binding)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (soap__binding *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "transport", 0), &((soap__binding*)a)->transport, 0, -1))
		return NULL;
	{	const char *t = soap_attr_value(soap, "style", 0);
		if (t)
		{
			if (!(((soap__binding*)a)->style = (enum soap__styleChoice *)soap_malloc(soap, sizeof(enum soap__styleChoice))))
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (soap_s2soap__styleChoice(soap, t, ((soap__binding*)a)->style))
			return NULL;
		}
		else if (soap->error)
			return NULL;
	}
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (soap__binding *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_soap__binding, 0, sizeof(soap__binding), 0, soap_copy_soap__binding);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int soap__binding::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_soap__binding);
	if (this->soap_out(soap, tag?tag:"soap:binding", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *soap__binding::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_soap__binding(soap, this, tag, type);
}

SOAP_FMAC3 soap__binding * SOAP_FMAC4 soap_get_soap__binding(struct soap *soap, soap__binding *p, const char *tag, const char *type)
{
	if ((p = soap_in_soap__binding(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 soap__binding * SOAP_FMAC2 soap_instantiate_soap__binding(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_soap__binding(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_soap__binding, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(soap__binding);
		if (size)
			*size = sizeof(soap__binding);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(soap__binding[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(soap__binding);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (soap__binding*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_soap__binding(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying soap__binding %p -> %p\n", q, p));
	*(soap__binding*)p = *(soap__binding*)q;
}

void wsdl__part::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__NMTOKEN(soap, &this->wsdl__part::name);
	soap_default_xsd__QName(soap, &this->wsdl__part::element);
	soap_default_xsd__QName(soap, &this->wsdl__part::type);
	soap_default_xsd__string(soap, &this->wsdl__part::documentation);
	this->wsdl__part::elementRef = NULL;
	this->wsdl__part::simpleTypeRef = NULL;
	this->wsdl__part::complexTypeRef = NULL;
}

void wsdl__part::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &this->wsdl__part::documentation);
	/* non-serializable elementRef skipped */
	/* non-serializable simpleTypeRef skipped */
	/* non-serializable complexTypeRef skipped */
	/* transient wsdl__part skipped */
	/* transient traverse skipped */
	/* transient elementPtr skipped */
	/* transient simpleTypePtr skipped */
	/* transient complexTypePtr skipped */
	/* transient elementPtr skipped */
	/* transient simpleTypePtr skipped */
	/* transient complexTypePtr skipped */
}

int wsdl__part::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_wsdl__part(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsdl__part(struct soap *soap, const char *tag, int id, const wsdl__part *a, const char *type)
{
	if (((wsdl__part*)a)->name)
		soap_set_attr(soap, "name", ((wsdl__part*)a)->name, 1);
	if (((wsdl__part*)a)->element)
		soap_set_attr(soap, "element", soap_QName2s(soap, ((wsdl__part*)a)->element), 1);
	if (((wsdl__part*)a)->type)
		soap_set_attr(soap, "type", soap_QName2s(soap, ((wsdl__part*)a)->type), 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsdl__part), type))
		return soap->error;
	if (soap_out_xsd__string(soap, "wsdl:documentation", -1, &(a->wsdl__part::documentation), ""))
		return soap->error;
	/* non-serializable elementRef skipped */
	/* non-serializable simpleTypeRef skipped */
	/* non-serializable complexTypeRef skipped */
	/* transient wsdl__part skipped */
	/* transient traverse skipped */
	/* transient elementPtr skipped */
	/* transient simpleTypePtr skipped */
	/* transient complexTypePtr skipped */
	/* transient elementPtr skipped */
	/* transient simpleTypePtr skipped */
	/* transient complexTypePtr skipped */
	return soap_element_end_out(soap, tag);
}

void *wsdl__part::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_wsdl__part(soap, tag, this, type);
}

SOAP_FMAC3 wsdl__part * SOAP_FMAC4 soap_in_wsdl__part(struct soap *soap, const char *tag, wsdl__part *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (wsdl__part *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_wsdl__part, sizeof(wsdl__part), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_wsdl__part)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (wsdl__part *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "name", 0), &((wsdl__part*)a)->name, 0, -1))
		return NULL;
	if (soap_s2QName(soap, soap_attr_value(soap, "element", 0), &((wsdl__part*)a)->element, 0, -1))
		return NULL;
	if (soap_s2QName(soap, soap_attr_value(soap, "type", 0), &((wsdl__part*)a)->type, 0, -1))
		return NULL;
	size_t soap_flag_documentation1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_documentation1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "wsdl:documentation", &(a->wsdl__part::documentation), "xsd:string"))
				{	soap_flag_documentation1--;
					continue;
				}
			/* non-serializable elementRef skipped */
			/* non-serializable simpleTypeRef skipped */
			/* non-serializable complexTypeRef skipped */
			/* transient wsdl__part skipped */
			/* transient traverse skipped */
			/* transient elementPtr skipped */
			/* transient simpleTypePtr skipped */
			/* transient complexTypePtr skipped */
			/* transient elementPtr skipped */
			/* transient simpleTypePtr skipped */
			/* transient complexTypePtr skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (wsdl__part *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsdl__part, 0, sizeof(wsdl__part), 0, soap_copy_wsdl__part);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int wsdl__part::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_wsdl__part);
	if (this->soap_out(soap, tag?tag:"wsdl:part", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *wsdl__part::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_wsdl__part(soap, this, tag, type);
}

SOAP_FMAC3 wsdl__part * SOAP_FMAC4 soap_get_wsdl__part(struct soap *soap, wsdl__part *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsdl__part(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 wsdl__part * SOAP_FMAC2 soap_instantiate_wsdl__part(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsdl__part(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsdl__part, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(wsdl__part);
		if (size)
			*size = sizeof(wsdl__part);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(wsdl__part[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(wsdl__part);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (wsdl__part*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsdl__part(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying wsdl__part %p -> %p\n", q, p));
	*(wsdl__part*)p = *(wsdl__part*)q;
}

void wsdl__message::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__NMTOKEN(soap, &this->wsdl__message::name);
	soap_default_xsd__string(soap, &this->wsdl__message::documentation);
	soap_default_std__vectorTemplateOfwsp__Policy(soap, &this->wsdl__message::wsp__Policy_);
	soap_default_std__vectorTemplateOfwsp__PolicyReference(soap, &this->wsdl__message::wsp__PolicyReference_);
	soap_default_std__vectorTemplateOfwsdl__part(soap, &this->wsdl__message::part);
}

void wsdl__message::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &this->wsdl__message::documentation);
	soap_serialize_std__vectorTemplateOfwsp__Policy(soap, &this->wsdl__message::wsp__Policy_);
	soap_serialize_std__vectorTemplateOfwsp__PolicyReference(soap, &this->wsdl__message::wsp__PolicyReference_);
	soap_serialize_std__vectorTemplateOfwsdl__part(soap, &this->wsdl__message::part);
	/* transient traverse skipped */
}

int wsdl__message::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_wsdl__message(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsdl__message(struct soap *soap, const char *tag, int id, const wsdl__message *a, const char *type)
{
	if (((wsdl__message*)a)->name)
		soap_set_attr(soap, "name", ((wsdl__message*)a)->name, 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsdl__message), type))
		return soap->error;
	if (soap_out_xsd__string(soap, "wsdl:documentation", -1, &(a->wsdl__message::documentation), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfwsp__Policy(soap, "wsp:Policy", -1, &(a->wsdl__message::wsp__Policy_), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfwsp__PolicyReference(soap, "wsp:PolicyReference", -1, &(a->wsdl__message::wsp__PolicyReference_), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfwsdl__part(soap, "wsdl:part", -1, &(a->wsdl__message::part), ""))
		return soap->error;
	/* transient traverse skipped */
	return soap_element_end_out(soap, tag);
}

void *wsdl__message::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_wsdl__message(soap, tag, this, type);
}

SOAP_FMAC3 wsdl__message * SOAP_FMAC4 soap_in_wsdl__message(struct soap *soap, const char *tag, wsdl__message *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (wsdl__message *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_wsdl__message, sizeof(wsdl__message), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_wsdl__message)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (wsdl__message *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "name", 0), &((wsdl__message*)a)->name, 0, -1))
		return NULL;
	size_t soap_flag_documentation1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_documentation1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "wsdl:documentation", &(a->wsdl__message::documentation), "xsd:string"))
				{	soap_flag_documentation1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfwsp__Policy(soap, "wsp:Policy", &(a->wsdl__message::wsp__Policy_), "wsp:Policy"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfwsp__PolicyReference(soap, "wsp:PolicyReference", &(a->wsdl__message::wsp__PolicyReference_), "wsp:PolicyReference"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfwsdl__part(soap, "wsdl:part", &(a->wsdl__message::part), "wsdl:part"))
					continue;
			/* transient traverse skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (wsdl__message *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsdl__message, 0, sizeof(wsdl__message), 0, soap_copy_wsdl__message);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int wsdl__message::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_wsdl__message);
	if (this->soap_out(soap, tag?tag:"wsdl:message", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *wsdl__message::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_wsdl__message(soap, this, tag, type);
}

SOAP_FMAC3 wsdl__message * SOAP_FMAC4 soap_get_wsdl__message(struct soap *soap, wsdl__message *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsdl__message(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 wsdl__message * SOAP_FMAC2 soap_instantiate_wsdl__message(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsdl__message(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsdl__message, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(wsdl__message);
		if (size)
			*size = sizeof(wsdl__message);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(wsdl__message[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(wsdl__message);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (wsdl__message*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsdl__message(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying wsdl__message %p -> %p\n", q, p));
	*(wsdl__message*)p = *(wsdl__message*)q;
}

void wsdl__definitions::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_xsd__NMTOKEN(soap, &this->wsdl__definitions::name);
	this->wsdl__definitions::targetNamespace = (char*)"";
	soap_default_xsd__NMTOKEN(soap, &this->wsdl__definitions::version);
	soap_default_std__vectorTemplateOfwsdl__import(soap, &this->wsdl__definitions::import);
	soap_default_xsd__string(soap, &this->wsdl__definitions::documentation);
	soap_default_xsd__string(soap, &this->wsdl__definitions::wsp__UsingPolicy);
	soap_default_std__vectorTemplateOfwsp__Policy(soap, &this->wsdl__definitions::wsp__Policy_);
	this->wsdl__definitions::types = NULL;
	soap_default_std__vectorTemplateOfwsdl__message(soap, &this->wsdl__definitions::message);
	soap_default_std__vectorTemplateOfwsdl__portType(soap, &this->wsdl__definitions::portType);
	soap_default_std__vectorTemplateOfwsdl__binding(soap, &this->wsdl__definitions::binding);
	soap_default_std__vectorTemplateOfwsdl__service(soap, &this->wsdl__definitions::service);
	soap_default_std__vectorTemplateOfgwsdl__portType(soap, &this->wsdl__definitions::gwsdl__portType_);
	/* transient soap skipped */
	this->wsdl__definitions::updated = (bool)0;
	this->wsdl__definitions::location = NULL;
	this->wsdl__definitions::redirs = 0;
	/* transient builtinTypeSet skipped */
	/* transient builtinElementSet skipped */
	/* transient builtinAttributeSet skipped */
}

void wsdl__definitions::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfwsdl__import(soap, &this->wsdl__definitions::import);
	soap_serialize_xsd__string(soap, &this->wsdl__definitions::documentation);
	soap_serialize_xsd__string(soap, &this->wsdl__definitions::wsp__UsingPolicy);
	soap_serialize_std__vectorTemplateOfwsp__Policy(soap, &this->wsdl__definitions::wsp__Policy_);
	soap_serialize_PointerTowsdl__types(soap, &this->wsdl__definitions::types);
	soap_serialize_std__vectorTemplateOfwsdl__message(soap, &this->wsdl__definitions::message);
	soap_serialize_std__vectorTemplateOfwsdl__portType(soap, &this->wsdl__definitions::portType);
	soap_serialize_std__vectorTemplateOfwsdl__binding(soap, &this->wsdl__definitions::binding);
	soap_serialize_std__vectorTemplateOfwsdl__service(soap, &this->wsdl__definitions::service);
	soap_serialize_std__vectorTemplateOfgwsdl__portType(soap, &this->wsdl__definitions::gwsdl__portType_);
	/* transient soap skipped */
	/* non-serializable updated skipped */
	/* non-serializable location skipped */
	/* non-serializable redirs skipped */
	/* non-serializable builtinTypeSet skipped */
	/* non-serializable builtinElementSet skipped */
	/* non-serializable builtinAttributeSet skipped */
	/* transient wsdl__definitions skipped */
	/* transient wsdl__definitions skipped */
	/* transient ~wsdl__definitions skipped */
	/* transient get skipped */
	/* transient preprocess skipped */
	/* transient traverse skipped */
	/* transient read skipped */
	/* transient read skipped */
	/* transient sourceLocation skipped */
	/* transient error skipped */
	/* transient print_fault skipped */
	/* transient builtinType skipped */
	/* transient builtinTypes skipped */
	/* transient builtinElement skipped */
	/* transient builtinElements skipped */
	/* transient builtinAttribute skipped */
	/* transient builtinAttributes skipped */
	/* non-serializable builtinTypes skipped */
	/* non-serializable builtinElements skipped */
	/* non-serializable builtinAttributes skipped */
	/* transient operator<< skipped */
	/* transient operator>> skipped */
}

int wsdl__definitions::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_wsdl__definitions(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsdl__definitions(struct soap *soap, const char *tag, int id, const wsdl__definitions *a, const char *type)
{
	if (((wsdl__definitions*)a)->name)
		soap_set_attr(soap, "name", ((wsdl__definitions*)a)->name, 1);
	if (((wsdl__definitions*)a)->targetNamespace)
		soap_set_attr(soap, "targetNamespace", ((wsdl__definitions*)a)->targetNamespace, 1);
	if (((wsdl__definitions*)a)->version)
		soap_set_attr(soap, "version", ((wsdl__definitions*)a)->version, 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsdl__definitions), type))
		return soap->error;
	if (soap_out_std__vectorTemplateOfwsdl__import(soap, "wsdl:import", -1, &(a->wsdl__definitions::import), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "wsdl:documentation", -1, &(a->wsdl__definitions::documentation), ""))
		return soap->error;
	if (soap_out_xsd__string(soap, "wsp:UsingPolicy", -1, &(a->wsdl__definitions::wsp__UsingPolicy), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfwsp__Policy(soap, "wsp:Policy", -1, &(a->wsdl__definitions::wsp__Policy_), ""))
		return soap->error;
	if (soap_out_PointerTowsdl__types(soap, "wsdl:types", -1, &(a->wsdl__definitions::types), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfwsdl__message(soap, "wsdl:message", -1, &(a->wsdl__definitions::message), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfwsdl__portType(soap, "wsdl:portType", -1, &(a->wsdl__definitions::portType), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfwsdl__binding(soap, "wsdl:binding", -1, &(a->wsdl__definitions::binding), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfwsdl__service(soap, "wsdl:service", -1, &(a->wsdl__definitions::service), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfgwsdl__portType(soap, "gwsdl:portType", -1, &(a->wsdl__definitions::gwsdl__portType_), ""))
		return soap->error;
	/* transient soap skipped */
	/* non-serializable updated skipped */
	/* non-serializable location skipped */
	/* non-serializable redirs skipped */
	/* non-serializable builtinTypeSet skipped */
	/* non-serializable builtinElementSet skipped */
	/* non-serializable builtinAttributeSet skipped */
	/* transient wsdl__definitions skipped */
	/* transient wsdl__definitions skipped */
	/* transient ~wsdl__definitions skipped */
	/* transient get skipped */
	/* transient preprocess skipped */
	/* transient traverse skipped */
	/* transient read skipped */
	/* transient read skipped */
	/* transient sourceLocation skipped */
	/* transient error skipped */
	/* transient print_fault skipped */
	/* transient builtinType skipped */
	/* transient builtinTypes skipped */
	/* transient builtinElement skipped */
	/* transient builtinElements skipped */
	/* transient builtinAttribute skipped */
	/* transient builtinAttributes skipped */
	/* non-serializable builtinTypes skipped */
	/* non-serializable builtinElements skipped */
	/* non-serializable builtinAttributes skipped */
	/* transient operator<< skipped */
	/* transient operator>> skipped */
	return soap_element_end_out(soap, tag);
}

void *wsdl__definitions::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_wsdl__definitions(soap, tag, this, type);
}

SOAP_FMAC3 wsdl__definitions * SOAP_FMAC4 soap_in_wsdl__definitions(struct soap *soap, const char *tag, wsdl__definitions *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (wsdl__definitions *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_wsdl__definitions, sizeof(wsdl__definitions), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_wsdl__definitions)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (wsdl__definitions *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "name", 0), &((wsdl__definitions*)a)->name, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "targetNamespace", 0), &((wsdl__definitions*)a)->targetNamespace, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "version", 0), &((wsdl__definitions*)a)->version, 0, -1))
		return NULL;
	size_t soap_flag_documentation1 = 1;
	size_t soap_flag_wsp__UsingPolicy1 = 1;
	size_t soap_flag_types1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfwsdl__import(soap, "wsdl:import", &(a->wsdl__definitions::import), "wsdl:import"))
					continue;
			if (soap_flag_documentation1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "wsdl:documentation", &(a->wsdl__definitions::documentation), "xsd:string"))
				{	soap_flag_documentation1--;
					continue;
				}
			if (soap_flag_wsp__UsingPolicy1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "wsp:UsingPolicy", &(a->wsdl__definitions::wsp__UsingPolicy), "xsd:string"))
				{	soap_flag_wsp__UsingPolicy1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfwsp__Policy(soap, "wsp:Policy", &(a->wsdl__definitions::wsp__Policy_), "wsp:Policy"))
					continue;
			if (soap_flag_types1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsdl__types(soap, "wsdl:types", &(a->wsdl__definitions::types), "wsdl:types"))
				{	soap_flag_types1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfwsdl__message(soap, "wsdl:message", &(a->wsdl__definitions::message), "wsdl:message"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfwsdl__portType(soap, "wsdl:portType", &(a->wsdl__definitions::portType), "wsdl:portType"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfwsdl__binding(soap, "wsdl:binding", &(a->wsdl__definitions::binding), "wsdl:binding"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfwsdl__service(soap, "wsdl:service", &(a->wsdl__definitions::service), "wsdl:service"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfgwsdl__portType(soap, "gwsdl:portType", &(a->wsdl__definitions::gwsdl__portType_), "gwsdl:portType"))
					continue;
			/* transient soap skipped */
			/* non-serializable updated skipped */
			/* non-serializable location skipped */
			/* non-serializable redirs skipped */
			/* non-serializable builtinTypeSet skipped */
			/* non-serializable builtinElementSet skipped */
			/* non-serializable builtinAttributeSet skipped */
			/* transient wsdl__definitions skipped */
			/* transient wsdl__definitions skipped */
			/* transient ~wsdl__definitions skipped */
			/* transient get skipped */
			/* transient preprocess skipped */
			/* transient traverse skipped */
			/* transient read skipped */
			/* transient read skipped */
			/* transient sourceLocation skipped */
			/* transient error skipped */
			/* transient print_fault skipped */
			/* transient builtinType skipped */
			/* transient builtinTypes skipped */
			/* transient builtinElement skipped */
			/* transient builtinElements skipped */
			/* transient builtinAttribute skipped */
			/* transient builtinAttributes skipped */
			/* non-serializable builtinTypes skipped */
			/* non-serializable builtinElements skipped */
			/* non-serializable builtinAttributes skipped */
			/* transient operator<< skipped */
			/* transient operator>> skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->get(soap))
			return NULL;
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (wsdl__definitions *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsdl__definitions, 0, sizeof(wsdl__definitions), 0, soap_copy_wsdl__definitions);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int wsdl__definitions::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_wsdl__definitions);
	if (this->soap_out(soap, tag?tag:"wsdl:definitions", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *wsdl__definitions::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_wsdl__definitions(soap, this, tag, type);
}

SOAP_FMAC3 wsdl__definitions * SOAP_FMAC4 soap_get_wsdl__definitions(struct soap *soap, wsdl__definitions *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsdl__definitions(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 wsdl__definitions * SOAP_FMAC2 soap_instantiate_wsdl__definitions(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsdl__definitions(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsdl__definitions, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(wsdl__definitions);
		if (size)
			*size = sizeof(wsdl__definitions);
		((wsdl__definitions*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(wsdl__definitions[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(wsdl__definitions);
		for (int i = 0; i < n; i++)
			((wsdl__definitions*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (wsdl__definitions*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsdl__definitions(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying wsdl__definitions %p -> %p\n", q, p));
	*(wsdl__definitions*)p = *(wsdl__definitions*)q;
}

void xs__redefine::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__anyURI(soap, &this->xs__redefine::schemaLocation);
	soap_default_std__vectorTemplateOfxs__group(soap, &this->xs__redefine::group);
	soap_default_std__vectorTemplateOfxs__attributeGroup(soap, &this->xs__redefine::attributeGroup);
	soap_default_std__vectorTemplateOfxs__simpleType(soap, &this->xs__redefine::simpleType);
	soap_default_std__vectorTemplateOfxs__complexType(soap, &this->xs__redefine::complexType);
	this->xs__redefine::schemaRef = NULL;
}

void xs__redefine::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfxs__group(soap, &this->xs__redefine::group);
	soap_serialize_std__vectorTemplateOfxs__attributeGroup(soap, &this->xs__redefine::attributeGroup);
	soap_serialize_std__vectorTemplateOfxs__simpleType(soap, &this->xs__redefine::simpleType);
	soap_serialize_std__vectorTemplateOfxs__complexType(soap, &this->xs__redefine::complexType);
	/* non-serializable schemaRef skipped */
	/* transient xs__redefine skipped */
	/* transient preprocess skipped */
	/* transient traverse skipped */
	/* transient schemaPtr skipped */
	/* transient schemaPtr skipped */
}

int xs__redefine::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_xs__redefine(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xs__redefine(struct soap *soap, const char *tag, int id, const xs__redefine *a, const char *type)
{
	if (((xs__redefine*)a)->schemaLocation)
		soap_set_attr(soap, "schemaLocation", ((xs__redefine*)a)->schemaLocation, 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xs__redefine), type))
		return soap->error;
	if (soap_out_std__vectorTemplateOfxs__group(soap, "xs:group", -1, &(a->xs__redefine::group), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfxs__attributeGroup(soap, "xs:attributeGroup", -1, &(a->xs__redefine::attributeGroup), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfxs__simpleType(soap, "xs:simpleType", -1, &(a->xs__redefine::simpleType), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfxs__complexType(soap, "xs:complexType", -1, &(a->xs__redefine::complexType), ""))
		return soap->error;
	/* non-serializable schemaRef skipped */
	/* transient xs__redefine skipped */
	/* transient preprocess skipped */
	/* transient traverse skipped */
	/* transient schemaPtr skipped */
	/* transient schemaPtr skipped */
	return soap_element_end_out(soap, tag);
}

void *xs__redefine::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_xs__redefine(soap, tag, this, type);
}

SOAP_FMAC3 xs__redefine * SOAP_FMAC4 soap_in_xs__redefine(struct soap *soap, const char *tag, xs__redefine *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (xs__redefine *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xs__redefine, sizeof(xs__redefine), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_xs__redefine)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (xs__redefine *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "schemaLocation", 0), &((xs__redefine*)a)->schemaLocation, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfxs__group(soap, "xs:group", &(a->xs__redefine::group), "xs:group"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfxs__attributeGroup(soap, "xs:attributeGroup", &(a->xs__redefine::attributeGroup), "xs:attributeGroup"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfxs__simpleType(soap, "xs:simpleType", &(a->xs__redefine::simpleType), "xs:simpleType"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfxs__complexType(soap, "xs:complexType", &(a->xs__redefine::complexType), "xs:complexType"))
					continue;
			/* non-serializable schemaRef skipped */
			/* transient xs__redefine skipped */
			/* transient preprocess skipped */
			/* transient traverse skipped */
			/* transient schemaPtr skipped */
			/* transient schemaPtr skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (xs__redefine *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xs__redefine, 0, sizeof(xs__redefine), 0, soap_copy_xs__redefine);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int xs__redefine::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xs__redefine);
	if (this->soap_out(soap, tag?tag:"xs:redefine", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *xs__redefine::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_xs__redefine(soap, this, tag, type);
}

SOAP_FMAC3 xs__redefine * SOAP_FMAC4 soap_get_xs__redefine(struct soap *soap, xs__redefine *p, const char *tag, const char *type)
{
	if ((p = soap_in_xs__redefine(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 xs__redefine * SOAP_FMAC2 soap_instantiate_xs__redefine(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xs__redefine(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xs__redefine, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(xs__redefine);
		if (size)
			*size = sizeof(xs__redefine);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(xs__redefine[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(xs__redefine);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (xs__redefine*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xs__redefine(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xs__redefine %p -> %p\n", q, p));
	*(xs__redefine*)p = *(xs__redefine*)q;
}

void xs__include::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__anyURI(soap, &this->xs__include::schemaLocation);
	this->xs__include::schemaRef = NULL;
}

void xs__include::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	/* non-serializable schemaRef skipped */
	/* transient xs__include skipped */
	/* transient preprocess skipped */
	/* transient traverse skipped */
	/* transient schemaPtr skipped */
	/* transient schemaPtr skipped */
}

int xs__include::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_xs__include(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xs__include(struct soap *soap, const char *tag, int id, const xs__include *a, const char *type)
{
	if (((xs__include*)a)->schemaLocation)
		soap_set_attr(soap, "schemaLocation", ((xs__include*)a)->schemaLocation, 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xs__include), type))
		return soap->error;
	/* non-serializable schemaRef skipped */
	/* transient xs__include skipped */
	/* transient preprocess skipped */
	/* transient traverse skipped */
	/* transient schemaPtr skipped */
	/* transient schemaPtr skipped */
	return soap_element_end_out(soap, tag);
}

void *xs__include::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_xs__include(soap, tag, this, type);
}

SOAP_FMAC3 xs__include * SOAP_FMAC4 soap_in_xs__include(struct soap *soap, const char *tag, xs__include *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (xs__include *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xs__include, sizeof(xs__include), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_xs__include)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (xs__include *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "schemaLocation", 0), &((xs__include*)a)->schemaLocation, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			/* non-serializable schemaRef skipped */
			/* transient xs__include skipped */
			/* transient preprocess skipped */
			/* transient traverse skipped */
			/* transient schemaPtr skipped */
			/* transient schemaPtr skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (xs__include *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xs__include, 0, sizeof(xs__include), 0, soap_copy_xs__include);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int xs__include::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xs__include);
	if (this->soap_out(soap, tag?tag:"xs:include", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *xs__include::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_xs__include(soap, this, tag, type);
}

SOAP_FMAC3 xs__include * SOAP_FMAC4 soap_get_xs__include(struct soap *soap, xs__include *p, const char *tag, const char *type)
{
	if ((p = soap_in_xs__include(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 xs__include * SOAP_FMAC2 soap_instantiate_xs__include(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xs__include(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xs__include, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(xs__include);
		if (size)
			*size = sizeof(xs__include);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(xs__include[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(xs__include);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (xs__include*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xs__include(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xs__include %p -> %p\n", q, p));
	*(xs__include*)p = *(xs__include*)q;
}

void xs__import::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__anyURI(soap, &this->xs__import::namespace_);
	soap_default_xsd__anyURI(soap, &this->xs__import::schemaLocation);
	this->xs__import::schemaRef = NULL;
}

void xs__import::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	/* non-serializable schemaRef skipped */
	/* transient xs__import skipped */
	/* transient traverse skipped */
	/* transient schemaPtr skipped */
	/* transient schemaPtr skipped */
}

int xs__import::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_xs__import(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xs__import(struct soap *soap, const char *tag, int id, const xs__import *a, const char *type)
{
	if (((xs__import*)a)->namespace_)
		soap_set_attr(soap, "namespace", ((xs__import*)a)->namespace_, 1);
	if (((xs__import*)a)->schemaLocation)
		soap_set_attr(soap, "schemaLocation", ((xs__import*)a)->schemaLocation, 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xs__import), type))
		return soap->error;
	/* non-serializable schemaRef skipped */
	/* transient xs__import skipped */
	/* transient traverse skipped */
	/* transient schemaPtr skipped */
	/* transient schemaPtr skipped */
	return soap_element_end_out(soap, tag);
}

void *xs__import::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_xs__import(soap, tag, this, type);
}

SOAP_FMAC3 xs__import * SOAP_FMAC4 soap_in_xs__import(struct soap *soap, const char *tag, xs__import *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (xs__import *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xs__import, sizeof(xs__import), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_xs__import)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (xs__import *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "namespace", 0), &((xs__import*)a)->namespace_, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "schemaLocation", 0), &((xs__import*)a)->schemaLocation, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			/* non-serializable schemaRef skipped */
			/* transient xs__import skipped */
			/* transient traverse skipped */
			/* transient schemaPtr skipped */
			/* transient schemaPtr skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (xs__import *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xs__import, 0, sizeof(xs__import), 0, soap_copy_xs__import);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int xs__import::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xs__import);
	if (this->soap_out(soap, tag?tag:"xs:import", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *xs__import::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_xs__import(soap, this, tag, type);
}

SOAP_FMAC3 xs__import * SOAP_FMAC4 soap_get_xs__import(struct soap *soap, xs__import *p, const char *tag, const char *type)
{
	if ((p = soap_in_xs__import(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 xs__import * SOAP_FMAC2 soap_instantiate_xs__import(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xs__import(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xs__import, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(xs__import);
		if (size)
			*size = sizeof(xs__import);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(xs__import[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(xs__import);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (xs__import*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xs__import(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xs__import %p -> %p\n", q, p));
	*(xs__import*)p = *(xs__import*)q;
}

void xs__complexContent::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	this->xs__complexContent::mixed = (bool)0;
	this->xs__complexContent::extension = NULL;
	this->xs__complexContent::restriction = NULL;
}

void xs__complexContent::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToxs__extension(soap, &this->xs__complexContent::extension);
	soap_serialize_PointerToxs__restriction(soap, &this->xs__complexContent::restriction);
	/* transient traverse skipped */
}

int xs__complexContent::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_xs__complexContent(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xs__complexContent(struct soap *soap, const char *tag, int id, const xs__complexContent *a, const char *type)
{
	soap_set_attr(soap, "mixed", soap_xsd__boolean2s(soap, ((xs__complexContent*)a)->mixed), 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xs__complexContent), type))
		return soap->error;
	if (soap_out_PointerToxs__extension(soap, "xs:extension", -1, &(a->xs__complexContent::extension), ""))
		return soap->error;
	if (soap_out_PointerToxs__restriction(soap, "xs:restriction", -1, &(a->xs__complexContent::restriction), ""))
		return soap->error;
	/* transient traverse skipped */
	return soap_element_end_out(soap, tag);
}

void *xs__complexContent::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_xs__complexContent(soap, tag, this, type);
}

SOAP_FMAC3 xs__complexContent * SOAP_FMAC4 soap_in_xs__complexContent(struct soap *soap, const char *tag, xs__complexContent *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (xs__complexContent *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xs__complexContent, sizeof(xs__complexContent), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_xs__complexContent)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (xs__complexContent *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2xsd__boolean(soap, soap_attr_value(soap, "mixed", 0), &((xs__complexContent*)a)->mixed))
		return NULL;
	size_t soap_flag_extension1 = 1;
	size_t soap_flag_restriction1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_extension1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__extension(soap, "xs:extension", &(a->xs__complexContent::extension), "xs:extension"))
				{	soap_flag_extension1--;
					continue;
				}
			if (soap_flag_restriction1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__restriction(soap, "xs:restriction", &(a->xs__complexContent::restriction), "xs:restriction"))
				{	soap_flag_restriction1--;
					continue;
				}
			/* transient traverse skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (xs__complexContent *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xs__complexContent, 0, sizeof(xs__complexContent), 0, soap_copy_xs__complexContent);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int xs__complexContent::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xs__complexContent);
	if (this->soap_out(soap, tag?tag:"xs:complexContent", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *xs__complexContent::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_xs__complexContent(soap, this, tag, type);
}

SOAP_FMAC3 xs__complexContent * SOAP_FMAC4 soap_get_xs__complexContent(struct soap *soap, xs__complexContent *p, const char *tag, const char *type)
{
	if ((p = soap_in_xs__complexContent(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 xs__complexContent * SOAP_FMAC2 soap_instantiate_xs__complexContent(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xs__complexContent(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xs__complexContent, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(xs__complexContent);
		if (size)
			*size = sizeof(xs__complexContent);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(xs__complexContent[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(xs__complexContent);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (xs__complexContent*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xs__complexContent(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xs__complexContent %p -> %p\n", q, p));
	*(xs__complexContent*)p = *(xs__complexContent*)q;
}

void xs__whiteSpace::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &this->xs__whiteSpace::value);
}

void xs__whiteSpace::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
}

int xs__whiteSpace::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_xs__whiteSpace(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xs__whiteSpace(struct soap *soap, const char *tag, int id, const xs__whiteSpace *a, const char *type)
{
	if (((xs__whiteSpace*)a)->value)
		soap_set_attr(soap, "value", ((xs__whiteSpace*)a)->value, 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xs__whiteSpace), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *xs__whiteSpace::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_xs__whiteSpace(soap, tag, this, type);
}

SOAP_FMAC3 xs__whiteSpace * SOAP_FMAC4 soap_in_xs__whiteSpace(struct soap *soap, const char *tag, xs__whiteSpace *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (xs__whiteSpace *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xs__whiteSpace, sizeof(xs__whiteSpace), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_xs__whiteSpace)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (xs__whiteSpace *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "value", 0), &((xs__whiteSpace*)a)->value, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (xs__whiteSpace *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xs__whiteSpace, 0, sizeof(xs__whiteSpace), 0, soap_copy_xs__whiteSpace);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int xs__whiteSpace::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xs__whiteSpace);
	if (this->soap_out(soap, tag?tag:"xs:whiteSpace", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *xs__whiteSpace::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_xs__whiteSpace(soap, this, tag, type);
}

SOAP_FMAC3 xs__whiteSpace * SOAP_FMAC4 soap_get_xs__whiteSpace(struct soap *soap, xs__whiteSpace *p, const char *tag, const char *type)
{
	if ((p = soap_in_xs__whiteSpace(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 xs__whiteSpace * SOAP_FMAC2 soap_instantiate_xs__whiteSpace(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xs__whiteSpace(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xs__whiteSpace, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(xs__whiteSpace);
		if (size)
			*size = sizeof(xs__whiteSpace);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(xs__whiteSpace[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(xs__whiteSpace);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (xs__whiteSpace*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xs__whiteSpace(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xs__whiteSpace %p -> %p\n", q, p));
	*(xs__whiteSpace*)p = *(xs__whiteSpace*)q;
}

void xs__length::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &this->xs__length::value);
	soap_default_xsd__boolean(soap, &this->xs__length::fixed);
	this->xs__length::annotation = NULL;
}

void xs__length::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToxs__annotation(soap, &this->xs__length::annotation);
}

int xs__length::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_xs__length(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xs__length(struct soap *soap, const char *tag, int id, const xs__length *a, const char *type)
{
	if (((xs__length*)a)->value)
		soap_set_attr(soap, "value", ((xs__length*)a)->value, 1);
	soap_set_attr(soap, "fixed", soap_xsd__boolean2s(soap, ((xs__length*)a)->fixed), 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xs__length), type))
		return soap->error;
	if (soap_out_PointerToxs__annotation(soap, "xs:annotation", -1, &(a->xs__length::annotation), ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *xs__length::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_xs__length(soap, tag, this, type);
}

SOAP_FMAC3 xs__length * SOAP_FMAC4 soap_in_xs__length(struct soap *soap, const char *tag, xs__length *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (xs__length *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xs__length, sizeof(xs__length), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_xs__length)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (xs__length *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "value", 0), &((xs__length*)a)->value, 0, -1))
		return NULL;
	if (soap_s2xsd__boolean(soap, soap_attr_value(soap, "fixed", 0), &((xs__length*)a)->fixed))
		return NULL;
	size_t soap_flag_annotation1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_annotation1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__annotation(soap, "xs:annotation", &(a->xs__length::annotation), "xs:annotation"))
				{	soap_flag_annotation1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (xs__length *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xs__length, 0, sizeof(xs__length), 0, soap_copy_xs__length);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int xs__length::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xs__length);
	if (this->soap_out(soap, tag?tag:"xs:length", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *xs__length::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_xs__length(soap, this, tag, type);
}

SOAP_FMAC3 xs__length * SOAP_FMAC4 soap_get_xs__length(struct soap *soap, xs__length *p, const char *tag, const char *type)
{
	if ((p = soap_in_xs__length(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 xs__length * SOAP_FMAC2 soap_instantiate_xs__length(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xs__length(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xs__length, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(xs__length);
		if (size)
			*size = sizeof(xs__length);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(xs__length[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(xs__length);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (xs__length*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xs__length(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xs__length %p -> %p\n", q, p));
	*(xs__length*)p = *(xs__length*)q;
}

void xs__simpleContent::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	this->xs__simpleContent::extension = NULL;
	this->xs__simpleContent::restriction = NULL;
}

void xs__simpleContent::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToxs__extension(soap, &this->xs__simpleContent::extension);
	soap_serialize_PointerToxs__restriction(soap, &this->xs__simpleContent::restriction);
	/* transient traverse skipped */
}

int xs__simpleContent::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_xs__simpleContent(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xs__simpleContent(struct soap *soap, const char *tag, int id, const xs__simpleContent *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xs__simpleContent), type))
		return soap->error;
	if (soap_out_PointerToxs__extension(soap, "xs:extension", -1, &(a->xs__simpleContent::extension), ""))
		return soap->error;
	if (soap_out_PointerToxs__restriction(soap, "xs:restriction", -1, &(a->xs__simpleContent::restriction), ""))
		return soap->error;
	/* transient traverse skipped */
	return soap_element_end_out(soap, tag);
}

void *xs__simpleContent::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_xs__simpleContent(soap, tag, this, type);
}

SOAP_FMAC3 xs__simpleContent * SOAP_FMAC4 soap_in_xs__simpleContent(struct soap *soap, const char *tag, xs__simpleContent *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (xs__simpleContent *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xs__simpleContent, sizeof(xs__simpleContent), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_xs__simpleContent)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (xs__simpleContent *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_extension1 = 1;
	size_t soap_flag_restriction1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_extension1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__extension(soap, "xs:extension", &(a->xs__simpleContent::extension), "xs:extension"))
				{	soap_flag_extension1--;
					continue;
				}
			if (soap_flag_restriction1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__restriction(soap, "xs:restriction", &(a->xs__simpleContent::restriction), "xs:restriction"))
				{	soap_flag_restriction1--;
					continue;
				}
			/* transient traverse skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (xs__simpleContent *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xs__simpleContent, 0, sizeof(xs__simpleContent), 0, soap_copy_xs__simpleContent);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int xs__simpleContent::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xs__simpleContent);
	if (this->soap_out(soap, tag?tag:"xs:simpleContent", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *xs__simpleContent::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_xs__simpleContent(soap, this, tag, type);
}

SOAP_FMAC3 xs__simpleContent * SOAP_FMAC4 soap_get_xs__simpleContent(struct soap *soap, xs__simpleContent *p, const char *tag, const char *type)
{
	if ((p = soap_in_xs__simpleContent(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 xs__simpleContent * SOAP_FMAC2 soap_instantiate_xs__simpleContent(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xs__simpleContent(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xs__simpleContent, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(xs__simpleContent);
		if (size)
			*size = sizeof(xs__simpleContent);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(xs__simpleContent[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(xs__simpleContent);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (xs__simpleContent*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xs__simpleContent(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xs__simpleContent %p -> %p\n", q, p));
	*(xs__simpleContent*)p = *(xs__simpleContent*)q;
}

void xs__pattern::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &this->xs__pattern::value);
}

void xs__pattern::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	/* transient traverse skipped */
}

int xs__pattern::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_xs__pattern(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xs__pattern(struct soap *soap, const char *tag, int id, const xs__pattern *a, const char *type)
{
	if (((xs__pattern*)a)->value)
		soap_set_attr(soap, "value", ((xs__pattern*)a)->value, 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xs__pattern), type))
		return soap->error;
	/* transient traverse skipped */
	return soap_element_end_out(soap, tag);
}

void *xs__pattern::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_xs__pattern(soap, tag, this, type);
}

SOAP_FMAC3 xs__pattern * SOAP_FMAC4 soap_in_xs__pattern(struct soap *soap, const char *tag, xs__pattern *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (xs__pattern *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xs__pattern, sizeof(xs__pattern), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_xs__pattern)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (xs__pattern *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "value", 0), &((xs__pattern*)a)->value, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			/* transient traverse skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (xs__pattern *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xs__pattern, 0, sizeof(xs__pattern), 0, soap_copy_xs__pattern);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int xs__pattern::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xs__pattern);
	if (this->soap_out(soap, tag?tag:"xs:pattern", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *xs__pattern::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_xs__pattern(soap, this, tag, type);
}

SOAP_FMAC3 xs__pattern * SOAP_FMAC4 soap_get_xs__pattern(struct soap *soap, xs__pattern *p, const char *tag, const char *type)
{
	if ((p = soap_in_xs__pattern(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 xs__pattern * SOAP_FMAC2 soap_instantiate_xs__pattern(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xs__pattern(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xs__pattern, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(xs__pattern);
		if (size)
			*size = sizeof(xs__pattern);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(xs__pattern[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(xs__pattern);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (xs__pattern*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xs__pattern(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xs__pattern %p -> %p\n", q, p));
	*(xs__pattern*)p = *(xs__pattern*)q;
}

void xs__enumeration::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &this->xs__enumeration::value);
	soap_default_xsd__QName(soap, &this->xs__enumeration::value_);
	this->xs__enumeration::annotation = NULL;
}

void xs__enumeration::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToxs__annotation(soap, &this->xs__enumeration::annotation);
	/* transient traverse skipped */
}

int xs__enumeration::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_xs__enumeration(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xs__enumeration(struct soap *soap, const char *tag, int id, const xs__enumeration *a, const char *type)
{
	if (((xs__enumeration*)a)->value)
		soap_set_attr(soap, "value", ((xs__enumeration*)a)->value, 1);
	if (((xs__enumeration*)a)->value_)
		soap_set_attr(soap, "value", soap_QName2s(soap, ((xs__enumeration*)a)->value_), 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xs__enumeration), type))
		return soap->error;
	if (soap_out_PointerToxs__annotation(soap, "xs:annotation", -1, &(a->xs__enumeration::annotation), ""))
		return soap->error;
	/* transient traverse skipped */
	return soap_element_end_out(soap, tag);
}

void *xs__enumeration::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_xs__enumeration(soap, tag, this, type);
}

SOAP_FMAC3 xs__enumeration * SOAP_FMAC4 soap_in_xs__enumeration(struct soap *soap, const char *tag, xs__enumeration *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (xs__enumeration *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xs__enumeration, sizeof(xs__enumeration), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_xs__enumeration)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (xs__enumeration *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "value", 0), &((xs__enumeration*)a)->value, 0, -1))
		return NULL;
	if (soap_s2QName(soap, soap_attr_value(soap, "value", 0), &((xs__enumeration*)a)->value_, 0, -1))
		return NULL;
	size_t soap_flag_annotation1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_annotation1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__annotation(soap, "xs:annotation", &(a->xs__enumeration::annotation), "xs:annotation"))
				{	soap_flag_annotation1--;
					continue;
				}
			/* transient traverse skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (xs__enumeration *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xs__enumeration, 0, sizeof(xs__enumeration), 0, soap_copy_xs__enumeration);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int xs__enumeration::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xs__enumeration);
	if (this->soap_out(soap, tag?tag:"xs:enumeration", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *xs__enumeration::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_xs__enumeration(soap, this, tag, type);
}

SOAP_FMAC3 xs__enumeration * SOAP_FMAC4 soap_get_xs__enumeration(struct soap *soap, xs__enumeration *p, const char *tag, const char *type)
{
	if ((p = soap_in_xs__enumeration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 xs__enumeration * SOAP_FMAC2 soap_instantiate_xs__enumeration(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xs__enumeration(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xs__enumeration, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(xs__enumeration);
		if (size)
			*size = sizeof(xs__enumeration);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(xs__enumeration[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(xs__enumeration);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (xs__enumeration*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xs__enumeration(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xs__enumeration %p -> %p\n", q, p));
	*(xs__enumeration*)p = *(xs__enumeration*)q;
}

void xs__attributeGroup::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__NCName(soap, &this->xs__attributeGroup::name);
	soap_default_xsd__QName(soap, &this->xs__attributeGroup::ref);
	this->xs__attributeGroup::annotation = NULL;
	soap_default_std__vectorTemplateOfxs__attribute(soap, &this->xs__attributeGroup::attribute);
	soap_default_std__vectorTemplateOfxs__attributeGroup(soap, &this->xs__attributeGroup::attributeGroup);
	this->xs__attributeGroup::anyAttribute = NULL;
	this->xs__attributeGroup::schemaRef = NULL;
	this->xs__attributeGroup::attributeGroupRef = NULL;
}

void xs__attributeGroup::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToxs__annotation(soap, &this->xs__attributeGroup::annotation);
	soap_serialize_std__vectorTemplateOfxs__attribute(soap, &this->xs__attributeGroup::attribute);
	soap_serialize_std__vectorTemplateOfxs__attributeGroup(soap, &this->xs__attributeGroup::attributeGroup);
	soap_serialize_PointerToxs__anyAttribute(soap, &this->xs__attributeGroup::anyAttribute);
	/* non-serializable schemaRef skipped */
	/* non-serializable attributeGroupRef skipped */
	/* transient xs__attributeGroup skipped */
	/* transient traverse skipped */
	/* transient schemaPtr skipped */
	/* transient attributeGroupPtr skipped */
	/* transient schemaPtr skipped */
	/* transient attributeGroupPtr skipped */
}

int xs__attributeGroup::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_xs__attributeGroup(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xs__attributeGroup(struct soap *soap, const char *tag, int id, const xs__attributeGroup *a, const char *type)
{
	if (((xs__attributeGroup*)a)->name)
		soap_set_attr(soap, "name", ((xs__attributeGroup*)a)->name, 1);
	if (((xs__attributeGroup*)a)->ref)
		soap_set_attr(soap, "ref", soap_QName2s(soap, ((xs__attributeGroup*)a)->ref), 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xs__attributeGroup), type))
		return soap->error;
	if (soap_out_PointerToxs__annotation(soap, "xs:annotation", -1, &(a->xs__attributeGroup::annotation), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfxs__attribute(soap, "xs:attribute", -1, &(a->xs__attributeGroup::attribute), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfxs__attributeGroup(soap, "xs:attributeGroup", -1, &(a->xs__attributeGroup::attributeGroup), ""))
		return soap->error;
	if (soap_out_PointerToxs__anyAttribute(soap, "xs:anyAttribute", -1, &(a->xs__attributeGroup::anyAttribute), ""))
		return soap->error;
	/* non-serializable schemaRef skipped */
	/* non-serializable attributeGroupRef skipped */
	/* transient xs__attributeGroup skipped */
	/* transient traverse skipped */
	/* transient schemaPtr skipped */
	/* transient attributeGroupPtr skipped */
	/* transient schemaPtr skipped */
	/* transient attributeGroupPtr skipped */
	return soap_element_end_out(soap, tag);
}

void *xs__attributeGroup::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_xs__attributeGroup(soap, tag, this, type);
}

SOAP_FMAC3 xs__attributeGroup * SOAP_FMAC4 soap_in_xs__attributeGroup(struct soap *soap, const char *tag, xs__attributeGroup *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (xs__attributeGroup *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xs__attributeGroup, sizeof(xs__attributeGroup), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_xs__attributeGroup)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (xs__attributeGroup *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "name", 0), &((xs__attributeGroup*)a)->name, 0, -1))
		return NULL;
	if (soap_s2QName(soap, soap_attr_value(soap, "ref", 0), &((xs__attributeGroup*)a)->ref, 0, -1))
		return NULL;
	size_t soap_flag_annotation1 = 1;
	size_t soap_flag_anyAttribute1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_annotation1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__annotation(soap, "xs:annotation", &(a->xs__attributeGroup::annotation), "xs:annotation"))
				{	soap_flag_annotation1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfxs__attribute(soap, "xs:attribute", &(a->xs__attributeGroup::attribute), "xs:attribute"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfxs__attributeGroup(soap, "xs:attributeGroup", &(a->xs__attributeGroup::attributeGroup), "xs:attributeGroup"))
					continue;
			if (soap_flag_anyAttribute1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__anyAttribute(soap, "xs:anyAttribute", &(a->xs__attributeGroup::anyAttribute), "xs:anyAttribute"))
				{	soap_flag_anyAttribute1--;
					continue;
				}
			/* non-serializable schemaRef skipped */
			/* non-serializable attributeGroupRef skipped */
			/* transient xs__attributeGroup skipped */
			/* transient traverse skipped */
			/* transient schemaPtr skipped */
			/* transient attributeGroupPtr skipped */
			/* transient schemaPtr skipped */
			/* transient attributeGroupPtr skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (xs__attributeGroup *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xs__attributeGroup, 0, sizeof(xs__attributeGroup), 0, soap_copy_xs__attributeGroup);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int xs__attributeGroup::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xs__attributeGroup);
	if (this->soap_out(soap, tag?tag:"xs:attributeGroup", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *xs__attributeGroup::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_xs__attributeGroup(soap, this, tag, type);
}

SOAP_FMAC3 xs__attributeGroup * SOAP_FMAC4 soap_get_xs__attributeGroup(struct soap *soap, xs__attributeGroup *p, const char *tag, const char *type)
{
	if ((p = soap_in_xs__attributeGroup(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 xs__attributeGroup * SOAP_FMAC2 soap_instantiate_xs__attributeGroup(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xs__attributeGroup(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xs__attributeGroup, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(xs__attributeGroup);
		if (size)
			*size = sizeof(xs__attributeGroup);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(xs__attributeGroup[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(xs__attributeGroup);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (xs__attributeGroup*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xs__attributeGroup(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xs__attributeGroup %p -> %p\n", q, p));
	*(xs__attributeGroup*)p = *(xs__attributeGroup*)q;
}

void xs__anyAttribute::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	this->xs__anyAttribute::namespace_ = (char*)"##any";
	this->xs__anyAttribute::processContents = (enum xs__processContents)0;
}

void xs__anyAttribute::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
}

int xs__anyAttribute::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_xs__anyAttribute(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xs__anyAttribute(struct soap *soap, const char *tag, int id, const xs__anyAttribute *a, const char *type)
{
	if (((xs__anyAttribute*)a)->namespace_)
		soap_set_attr(soap, "namespace", ((xs__anyAttribute*)a)->namespace_, 1);
	soap_set_attr(soap, "processContents", soap_xs__processContents2s(soap, ((xs__anyAttribute*)a)->processContents), 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xs__anyAttribute), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *xs__anyAttribute::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_xs__anyAttribute(soap, tag, this, type);
}

SOAP_FMAC3 xs__anyAttribute * SOAP_FMAC4 soap_in_xs__anyAttribute(struct soap *soap, const char *tag, xs__anyAttribute *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (xs__anyAttribute *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xs__anyAttribute, sizeof(xs__anyAttribute), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_xs__anyAttribute)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (xs__anyAttribute *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "namespace", 0), &((xs__anyAttribute*)a)->namespace_, 0, -1))
		return NULL;
	if (soap_s2xs__processContents(soap, soap_attr_value(soap, "processContents", 0), &((xs__anyAttribute*)a)->processContents))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (xs__anyAttribute *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xs__anyAttribute, 0, sizeof(xs__anyAttribute), 0, soap_copy_xs__anyAttribute);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int xs__anyAttribute::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xs__anyAttribute);
	if (this->soap_out(soap, tag?tag:"xs:anyAttribute", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *xs__anyAttribute::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_xs__anyAttribute(soap, this, tag, type);
}

SOAP_FMAC3 xs__anyAttribute * SOAP_FMAC4 soap_get_xs__anyAttribute(struct soap *soap, xs__anyAttribute *p, const char *tag, const char *type)
{
	if ((p = soap_in_xs__anyAttribute(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 xs__anyAttribute * SOAP_FMAC2 soap_instantiate_xs__anyAttribute(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xs__anyAttribute(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xs__anyAttribute, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(xs__anyAttribute);
		if (size)
			*size = sizeof(xs__anyAttribute);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(xs__anyAttribute[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(xs__anyAttribute);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (xs__anyAttribute*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xs__anyAttribute(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xs__anyAttribute %p -> %p\n", q, p));
	*(xs__anyAttribute*)p = *(xs__anyAttribute*)q;
}

void xs__contents::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	this->xs__contents::__union = 0;
}

void xs__contents::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_xs__union_content(soap, this->xs__contents::__union, &this->xs__contents::__content);
	/* transient traverse skipped */
}

int xs__contents::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_xs__contents(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xs__contents(struct soap *soap, const char *tag, int id, const xs__contents *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xs__contents), type))
		return soap->error;
	if (soap_out_xs__union_content(soap, a->xs__contents::__union, &a->xs__contents::__content))
		return soap->error;
	/* transient traverse skipped */
	return soap_element_end_out(soap, tag);
}

void *xs__contents::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_xs__contents(soap, tag, this, type);
}

SOAP_FMAC3 xs__contents * SOAP_FMAC4 soap_in_xs__contents(struct soap *soap, const char *tag, xs__contents *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (xs__contents *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xs__contents, sizeof(xs__contents), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	a->soap_default(soap);
	if (!tag || *tag == '-' || (soap->body && !*soap->href))
	{
		if (!soap_in_xs__union_content(soap, &a->__union, &a->__content))
			return NULL;
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (xs__contents *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xs__contents, 0, sizeof(xs__contents), 0, soap_copy_xs__contents);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int xs__contents::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xs__contents);
	if (this->soap_out(soap, tag?tag:"xs:contents", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *xs__contents::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_xs__contents(soap, this, tag, type);
}

SOAP_FMAC3 xs__contents * SOAP_FMAC4 soap_get_xs__contents(struct soap *soap, xs__contents *p, const char *tag, const char *type)
{
	if ((p = soap_in_xs__contents(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 xs__contents * SOAP_FMAC2 soap_instantiate_xs__contents(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xs__contents(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xs__contents, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(xs__contents);
		if (size)
			*size = sizeof(xs__contents);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(xs__contents[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(xs__contents);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (xs__contents*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xs__contents(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xs__contents %p -> %p\n", q, p));
	*(xs__contents*)p = *(xs__contents*)q;
}

void xs__any::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	this->xs__any::namespace_ = (char*)"##any";
	this->xs__any::processContents = (enum xs__processContents)0;
	soap_default_xsd__string(soap, &this->xs__any::minOccurs);
	soap_default_xsd__string(soap, &this->xs__any::maxOccurs);
	soap_default_std__vectorTemplateOfxs__element(soap, &this->xs__any::element);
}

void xs__any::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfxs__element(soap, &this->xs__any::element);
	/* transient traverse skipped */
}

int xs__any::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_xs__any(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xs__any(struct soap *soap, const char *tag, int id, const xs__any *a, const char *type)
{
	if (((xs__any*)a)->namespace_)
		soap_set_attr(soap, "namespace", ((xs__any*)a)->namespace_, 1);
	soap_set_attr(soap, "processContents", soap_xs__processContents2s(soap, ((xs__any*)a)->processContents), 1);
	if (((xs__any*)a)->minOccurs)
		soap_set_attr(soap, "minOccurs", ((xs__any*)a)->minOccurs, 1);
	if (((xs__any*)a)->maxOccurs)
		soap_set_attr(soap, "maxOccurs", ((xs__any*)a)->maxOccurs, 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xs__any), type))
		return soap->error;
	if (soap_out_std__vectorTemplateOfxs__element(soap, "xs:element", -1, &(a->xs__any::element), ""))
		return soap->error;
	/* transient traverse skipped */
	return soap_element_end_out(soap, tag);
}

void *xs__any::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_xs__any(soap, tag, this, type);
}

SOAP_FMAC3 xs__any * SOAP_FMAC4 soap_in_xs__any(struct soap *soap, const char *tag, xs__any *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (xs__any *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xs__any, sizeof(xs__any), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_xs__any)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (xs__any *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "namespace", 0), &((xs__any*)a)->namespace_, 0, -1))
		return NULL;
	if (soap_s2xs__processContents(soap, soap_attr_value(soap, "processContents", 0), &((xs__any*)a)->processContents))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "minOccurs", 0), &((xs__any*)a)->minOccurs, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "maxOccurs", 0), &((xs__any*)a)->maxOccurs, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfxs__element(soap, "xs:element", &(a->xs__any::element), "xs:element"))
					continue;
			/* transient traverse skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (xs__any *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xs__any, 0, sizeof(xs__any), 0, soap_copy_xs__any);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int xs__any::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xs__any);
	if (this->soap_out(soap, tag?tag:"xs:any", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *xs__any::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_xs__any(soap, this, tag, type);
}

SOAP_FMAC3 xs__any * SOAP_FMAC4 soap_get_xs__any(struct soap *soap, xs__any *p, const char *tag, const char *type)
{
	if ((p = soap_in_xs__any(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 xs__any * SOAP_FMAC2 soap_instantiate_xs__any(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xs__any(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xs__any, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(xs__any);
		if (size)
			*size = sizeof(xs__any);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(xs__any[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(xs__any);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (xs__any*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xs__any(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xs__any %p -> %p\n", q, p));
	*(xs__any*)p = *(xs__any*)q;
}

void xs__all::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_std__vectorTemplateOfxs__element(soap, &this->xs__all::element);
}

void xs__all::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfxs__element(soap, &this->xs__all::element);
	/* transient traverse skipped */
}

int xs__all::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_xs__all(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xs__all(struct soap *soap, const char *tag, int id, const xs__all *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xs__all), type))
		return soap->error;
	if (soap_out_std__vectorTemplateOfxs__element(soap, "xs:element", -1, &(a->xs__all::element), ""))
		return soap->error;
	/* transient traverse skipped */
	return soap_element_end_out(soap, tag);
}

void *xs__all::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_xs__all(soap, tag, this, type);
}

SOAP_FMAC3 xs__all * SOAP_FMAC4 soap_in_xs__all(struct soap *soap, const char *tag, xs__all *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (xs__all *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xs__all, sizeof(xs__all), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_xs__all)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (xs__all *)a->soap_in(soap, tag, type);
		}
	}
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfxs__element(soap, "xs:element", &(a->xs__all::element), "xs:element"))
					continue;
			/* transient traverse skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (xs__all *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xs__all, 0, sizeof(xs__all), 0, soap_copy_xs__all);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int xs__all::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xs__all);
	if (this->soap_out(soap, tag?tag:"xs:all", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *xs__all::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_xs__all(soap, this, tag, type);
}

SOAP_FMAC3 xs__all * SOAP_FMAC4 soap_get_xs__all(struct soap *soap, xs__all *p, const char *tag, const char *type)
{
	if ((p = soap_in_xs__all(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 xs__all * SOAP_FMAC2 soap_instantiate_xs__all(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xs__all(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xs__all, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(xs__all);
		if (size)
			*size = sizeof(xs__all);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(xs__all[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(xs__all);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (xs__all*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xs__all(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xs__all %p -> %p\n", q, p));
	*(xs__all*)p = *(xs__all*)q;
}

void xs__attribute::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__NCName(soap, &this->xs__attribute::name);
	soap_default_xsd__QName(soap, &this->xs__attribute::ref);
	soap_default_xsd__QName(soap, &this->xs__attribute::type);
	this->xs__attribute::use = (enum xs__attribute_use)0;
	soap_default_xsd__string(soap, &this->xs__attribute::default_);
	soap_default_xsd__QName(soap, &this->xs__attribute::default__);
	soap_default_xsd__string(soap, &this->xs__attribute::fixed);
	soap_default_xsd__QName(soap, &this->xs__attribute::fixed_);
	this->xs__attribute::form = NULL;
	soap_default_xsd__QName(soap, &this->xs__attribute::wsdl__arrayType);
	this->xs__attribute::annotation = NULL;
	this->xs__attribute::simpleType = NULL;
	this->xs__attribute::schemaRef = NULL;
	this->xs__attribute::attributeRef = NULL;
	this->xs__attribute::simpleTypeRef = NULL;
}

void xs__attribute::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToxs__annotation(soap, &this->xs__attribute::annotation);
	soap_serialize_PointerToxs__simpleType(soap, &this->xs__attribute::simpleType);
	/* non-serializable schemaRef skipped */
	/* non-serializable attributeRef skipped */
	/* non-serializable simpleTypeRef skipped */
	/* transient xs__attribute skipped */
	/* transient traverse skipped */
	/* transient schemaPtr skipped */
	/* transient attributePtr skipped */
	/* transient simpleTypePtr skipped */
	/* transient schemaPtr skipped */
	/* transient attributePtr skipped */
	/* transient simpleTypePtr skipped */
}

int xs__attribute::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_xs__attribute(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xs__attribute(struct soap *soap, const char *tag, int id, const xs__attribute *a, const char *type)
{
	if (((xs__attribute*)a)->name)
		soap_set_attr(soap, "name", ((xs__attribute*)a)->name, 1);
	if (((xs__attribute*)a)->ref)
		soap_set_attr(soap, "ref", soap_QName2s(soap, ((xs__attribute*)a)->ref), 1);
	if (((xs__attribute*)a)->type)
		soap_set_attr(soap, "type", soap_QName2s(soap, ((xs__attribute*)a)->type), 1);
	soap_set_attr(soap, "use", soap_xs__attribute_use2s(soap, ((xs__attribute*)a)->use), 1);
	if (((xs__attribute*)a)->default_)
		soap_set_attr(soap, "default", ((xs__attribute*)a)->default_, 1);
	if (((xs__attribute*)a)->default__)
		soap_set_attr(soap, "default", soap_QName2s(soap, ((xs__attribute*)a)->default__), 1);
	if (((xs__attribute*)a)->fixed)
		soap_set_attr(soap, "fixed", ((xs__attribute*)a)->fixed, 1);
	if (((xs__attribute*)a)->fixed_)
		soap_set_attr(soap, "fixed", soap_QName2s(soap, ((xs__attribute*)a)->fixed_), 1);
	if (((xs__attribute*)a)->form)
		soap_set_attr(soap, "form", soap_xs__formChoice2s(soap, *((xs__attribute*)a)->form), 1);
	if (((xs__attribute*)a)->wsdl__arrayType)
		soap_set_attr(soap, "wsdl:arrayType", soap_QName2s(soap, ((xs__attribute*)a)->wsdl__arrayType), 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xs__attribute), type))
		return soap->error;
	if (soap_out_PointerToxs__annotation(soap, "xs:annotation", -1, &(a->xs__attribute::annotation), ""))
		return soap->error;
	if (soap_out_PointerToxs__simpleType(soap, "xs:simpleType", -1, &(a->xs__attribute::simpleType), ""))
		return soap->error;
	/* non-serializable schemaRef skipped */
	/* non-serializable attributeRef skipped */
	/* non-serializable simpleTypeRef skipped */
	/* transient xs__attribute skipped */
	/* transient traverse skipped */
	/* transient schemaPtr skipped */
	/* transient attributePtr skipped */
	/* transient simpleTypePtr skipped */
	/* transient schemaPtr skipped */
	/* transient attributePtr skipped */
	/* transient simpleTypePtr skipped */
	return soap_element_end_out(soap, tag);
}

void *xs__attribute::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_xs__attribute(soap, tag, this, type);
}

SOAP_FMAC3 xs__attribute * SOAP_FMAC4 soap_in_xs__attribute(struct soap *soap, const char *tag, xs__attribute *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (xs__attribute *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xs__attribute, sizeof(xs__attribute), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_xs__attribute)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (xs__attribute *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "name", 0), &((xs__attribute*)a)->name, 0, -1))
		return NULL;
	if (soap_s2QName(soap, soap_attr_value(soap, "ref", 0), &((xs__attribute*)a)->ref, 0, -1))
		return NULL;
	if (soap_s2QName(soap, soap_attr_value(soap, "type", 0), &((xs__attribute*)a)->type, 0, -1))
		return NULL;
	if (soap_s2xs__attribute_use(soap, soap_attr_value(soap, "use", 0), &((xs__attribute*)a)->use))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "default", 0), &((xs__attribute*)a)->default_, 0, -1))
		return NULL;
	if (soap_s2QName(soap, soap_attr_value(soap, "default", 0), &((xs__attribute*)a)->default__, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "fixed", 0), &((xs__attribute*)a)->fixed, 0, -1))
		return NULL;
	if (soap_s2QName(soap, soap_attr_value(soap, "fixed", 0), &((xs__attribute*)a)->fixed_, 0, -1))
		return NULL;
	{	const char *t = soap_attr_value(soap, "form", 0);
		if (t)
		{
			if (!(((xs__attribute*)a)->form = (enum xs__formChoice *)soap_malloc(soap, sizeof(enum xs__formChoice))))
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (soap_s2xs__formChoice(soap, t, ((xs__attribute*)a)->form))
			return NULL;
		}
		else if (soap->error)
			return NULL;
	}
	if (soap_s2QName(soap, soap_attr_value(soap, "wsdl:arrayType", 0), &((xs__attribute*)a)->wsdl__arrayType, 0, -1))
		return NULL;
	size_t soap_flag_annotation1 = 1;
	size_t soap_flag_simpleType1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_annotation1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__annotation(soap, "xs:annotation", &(a->xs__attribute::annotation), "xs:annotation"))
				{	soap_flag_annotation1--;
					continue;
				}
			if (soap_flag_simpleType1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__simpleType(soap, "xs:simpleType", &(a->xs__attribute::simpleType), "xs:simpleType"))
				{	soap_flag_simpleType1--;
					continue;
				}
			/* non-serializable schemaRef skipped */
			/* non-serializable attributeRef skipped */
			/* non-serializable simpleTypeRef skipped */
			/* transient xs__attribute skipped */
			/* transient traverse skipped */
			/* transient schemaPtr skipped */
			/* transient attributePtr skipped */
			/* transient simpleTypePtr skipped */
			/* transient schemaPtr skipped */
			/* transient attributePtr skipped */
			/* transient simpleTypePtr skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (xs__attribute *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xs__attribute, 0, sizeof(xs__attribute), 0, soap_copy_xs__attribute);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int xs__attribute::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xs__attribute);
	if (this->soap_out(soap, tag?tag:"xs:attribute", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *xs__attribute::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_xs__attribute(soap, this, tag, type);
}

SOAP_FMAC3 xs__attribute * SOAP_FMAC4 soap_get_xs__attribute(struct soap *soap, xs__attribute *p, const char *tag, const char *type)
{
	if ((p = soap_in_xs__attribute(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 xs__attribute * SOAP_FMAC2 soap_instantiate_xs__attribute(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xs__attribute(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xs__attribute, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(xs__attribute);
		if (size)
			*size = sizeof(xs__attribute);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(xs__attribute[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(xs__attribute);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (xs__attribute*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xs__attribute(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xs__attribute %p -> %p\n", q, p));
	*(xs__attribute*)p = *(xs__attribute*)q;
}

void xs__element::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__NCName(soap, &this->xs__element::name);
	soap_default_xsd__QName(soap, &this->xs__element::ref);
	soap_default_xsd__QName(soap, &this->xs__element::type);
	soap_default_xsd__string(soap, &this->xs__element::default_);
	soap_default_xsd__QName(soap, &this->xs__element::default__);
	soap_default_xsd__string(soap, &this->xs__element::fixed);
	soap_default_xsd__QName(soap, &this->xs__element::fixed_);
	this->xs__element::form = NULL;
	this->xs__element::nillable = (bool)0;
	this->xs__element::abstract = (bool)0;
	soap_default_xsd__QName(soap, &this->xs__element::substitutionGroup);
	soap_default_xsd__string(soap, &this->xs__element::minOccurs);
	soap_default_xsd__string(soap, &this->xs__element::maxOccurs);
	soap_default_xsd__string(soap, &this->xs__element::xmime__expectedContentTypes);
	this->xs__element::annotation = NULL;
	this->xs__element::simpleType = NULL;
	this->xs__element::complexType = NULL;
	this->xs__element::schemaRef = NULL;
	this->xs__element::elementRef = NULL;
	this->xs__element::simpleTypeRef = NULL;
	this->xs__element::complexTypeRef = NULL;
	/* private/protected substitutions skipped */
}

void xs__element::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToxs__annotation(soap, &this->xs__element::annotation);
	soap_serialize_PointerToxs__simpleType(soap, &this->xs__element::simpleType);
	soap_serialize_PointerToxs__complexType(soap, &this->xs__element::complexType);
	/* non-serializable schemaRef skipped */
	/* non-serializable elementRef skipped */
	/* non-serializable simpleTypeRef skipped */
	/* non-serializable complexTypeRef skipped */
	/* non-serializable substitutions skipped */
	/* transient xs__element skipped */
	/* transient traverse skipped */
	/* transient schemaPtr skipped */
	/* transient elementPtr skipped */
	/* transient simpleTypePtr skipped */
	/* transient complexTypePtr skipped */
	/* transient schemaPtr skipped */
	/* transient elementPtr skipped */
	/* transient simpleTypePtr skipped */
	/* transient complexTypePtr skipped */
	/* transient substitutionsPtr skipped */
}

int xs__element::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_xs__element(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xs__element(struct soap *soap, const char *tag, int id, const xs__element *a, const char *type)
{
	if (((xs__element*)a)->name)
		soap_set_attr(soap, "name", ((xs__element*)a)->name, 1);
	if (((xs__element*)a)->ref)
		soap_set_attr(soap, "ref", soap_QName2s(soap, ((xs__element*)a)->ref), 1);
	if (((xs__element*)a)->type)
		soap_set_attr(soap, "type", soap_QName2s(soap, ((xs__element*)a)->type), 1);
	if (((xs__element*)a)->default_)
		soap_set_attr(soap, "default", ((xs__element*)a)->default_, 1);
	if (((xs__element*)a)->default__)
		soap_set_attr(soap, "default", soap_QName2s(soap, ((xs__element*)a)->default__), 1);
	if (((xs__element*)a)->fixed)
		soap_set_attr(soap, "fixed", ((xs__element*)a)->fixed, 1);
	if (((xs__element*)a)->fixed_)
		soap_set_attr(soap, "fixed", soap_QName2s(soap, ((xs__element*)a)->fixed_), 1);
	if (((xs__element*)a)->form)
		soap_set_attr(soap, "form", soap_xs__formChoice2s(soap, *((xs__element*)a)->form), 1);
	soap_set_attr(soap, "nillable", soap_xsd__boolean2s(soap, ((xs__element*)a)->nillable), 1);
	soap_set_attr(soap, "abstract", soap_xsd__boolean2s(soap, ((xs__element*)a)->abstract), 1);
	if (((xs__element*)a)->substitutionGroup)
		soap_set_attr(soap, "substitutionGroup", soap_QName2s(soap, ((xs__element*)a)->substitutionGroup), 1);
	if (((xs__element*)a)->minOccurs)
		soap_set_attr(soap, "minOccurs", ((xs__element*)a)->minOccurs, 1);
	if (((xs__element*)a)->maxOccurs)
		soap_set_attr(soap, "maxOccurs", ((xs__element*)a)->maxOccurs, 1);
	if (((xs__element*)a)->xmime__expectedContentTypes)
		soap_set_attr(soap, "xmime:expectedContentTypes", ((xs__element*)a)->xmime__expectedContentTypes, 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xs__element), type))
		return soap->error;
	if (soap_out_PointerToxs__annotation(soap, "xs:annotation", -1, &(a->xs__element::annotation), ""))
		return soap->error;
	if (soap_out_PointerToxs__simpleType(soap, "xs:simpleType", -1, &(a->xs__element::simpleType), ""))
		return soap->error;
	if (soap_out_PointerToxs__complexType(soap, "xs:complexType", -1, &(a->xs__element::complexType), ""))
		return soap->error;
	/* non-serializable schemaRef skipped */
	/* non-serializable elementRef skipped */
	/* non-serializable simpleTypeRef skipped */
	/* non-serializable complexTypeRef skipped */
	/* non-serializable substitutions skipped */
	/* transient xs__element skipped */
	/* transient traverse skipped */
	/* transient schemaPtr skipped */
	/* transient elementPtr skipped */
	/* transient simpleTypePtr skipped */
	/* transient complexTypePtr skipped */
	/* transient schemaPtr skipped */
	/* transient elementPtr skipped */
	/* transient simpleTypePtr skipped */
	/* transient complexTypePtr skipped */
	/* transient substitutionsPtr skipped */
	return soap_element_end_out(soap, tag);
}

void *xs__element::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_xs__element(soap, tag, this, type);
}

SOAP_FMAC3 xs__element * SOAP_FMAC4 soap_in_xs__element(struct soap *soap, const char *tag, xs__element *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (xs__element *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xs__element, sizeof(xs__element), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_xs__element)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (xs__element *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "name", 0), &((xs__element*)a)->name, 0, -1))
		return NULL;
	if (soap_s2QName(soap, soap_attr_value(soap, "ref", 0), &((xs__element*)a)->ref, 0, -1))
		return NULL;
	if (soap_s2QName(soap, soap_attr_value(soap, "type", 0), &((xs__element*)a)->type, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "default", 0), &((xs__element*)a)->default_, 0, -1))
		return NULL;
	if (soap_s2QName(soap, soap_attr_value(soap, "default", 0), &((xs__element*)a)->default__, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "fixed", 0), &((xs__element*)a)->fixed, 0, -1))
		return NULL;
	if (soap_s2QName(soap, soap_attr_value(soap, "fixed", 0), &((xs__element*)a)->fixed_, 0, -1))
		return NULL;
	{	const char *t = soap_attr_value(soap, "form", 0);
		if (t)
		{
			if (!(((xs__element*)a)->form = (enum xs__formChoice *)soap_malloc(soap, sizeof(enum xs__formChoice))))
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (soap_s2xs__formChoice(soap, t, ((xs__element*)a)->form))
			return NULL;
		}
		else if (soap->error)
			return NULL;
	}
	if (soap_s2xsd__boolean(soap, soap_attr_value(soap, "nillable", 0), &((xs__element*)a)->nillable))
		return NULL;
	if (soap_s2xsd__boolean(soap, soap_attr_value(soap, "abstract", 0), &((xs__element*)a)->abstract))
		return NULL;
	if (soap_s2QName(soap, soap_attr_value(soap, "substitutionGroup", 0), &((xs__element*)a)->substitutionGroup, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "minOccurs", 0), &((xs__element*)a)->minOccurs, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "maxOccurs", 0), &((xs__element*)a)->maxOccurs, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "xmime:expectedContentTypes", 0), &((xs__element*)a)->xmime__expectedContentTypes, 0, -1))
		return NULL;
	size_t soap_flag_annotation1 = 1;
	size_t soap_flag_simpleType1 = 1;
	size_t soap_flag_complexType1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_annotation1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__annotation(soap, "xs:annotation", &(a->xs__element::annotation), "xs:annotation"))
				{	soap_flag_annotation1--;
					continue;
				}
			if (soap_flag_simpleType1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__simpleType(soap, "xs:simpleType", &(a->xs__element::simpleType), "xs:simpleType"))
				{	soap_flag_simpleType1--;
					continue;
				}
			if (soap_flag_complexType1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__complexType(soap, "xs:complexType", &(a->xs__element::complexType), "xs:complexType"))
				{	soap_flag_complexType1--;
					continue;
				}
			/* non-serializable schemaRef skipped */
			/* non-serializable elementRef skipped */
			/* non-serializable simpleTypeRef skipped */
			/* non-serializable complexTypeRef skipped */
			/* non-serializable substitutions skipped */
			/* transient xs__element skipped */
			/* transient traverse skipped */
			/* transient schemaPtr skipped */
			/* transient elementPtr skipped */
			/* transient simpleTypePtr skipped */
			/* transient complexTypePtr skipped */
			/* transient schemaPtr skipped */
			/* transient elementPtr skipped */
			/* transient simpleTypePtr skipped */
			/* transient complexTypePtr skipped */
			/* transient substitutionsPtr skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (xs__element *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xs__element, 0, sizeof(xs__element), 0, soap_copy_xs__element);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int xs__element::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xs__element);
	if (this->soap_out(soap, tag?tag:"xs:element", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *xs__element::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_xs__element(soap, this, tag, type);
}

SOAP_FMAC3 xs__element * SOAP_FMAC4 soap_get_xs__element(struct soap *soap, xs__element *p, const char *tag, const char *type)
{
	if ((p = soap_in_xs__element(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 xs__element * SOAP_FMAC2 soap_instantiate_xs__element(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xs__element(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xs__element, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(xs__element);
		if (size)
			*size = sizeof(xs__element);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(xs__element[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(xs__element);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (xs__element*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xs__element(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xs__element %p -> %p\n", q, p));
	*(xs__element*)p = *(xs__element*)q;
}

void xs__annotation::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_string(soap, &this->xs__annotation::documentation);
}

void xs__annotation::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &this->xs__annotation::documentation);
}

int xs__annotation::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_xs__annotation(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xs__annotation(struct soap *soap, const char *tag, int id, const xs__annotation *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xs__annotation), type))
		return soap->error;
	if (soap_out_string(soap, "xs:documentation", -1, &(a->xs__annotation::documentation), ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *xs__annotation::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_xs__annotation(soap, tag, this, type);
}

SOAP_FMAC3 xs__annotation * SOAP_FMAC4 soap_in_xs__annotation(struct soap *soap, const char *tag, xs__annotation *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (xs__annotation *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xs__annotation, sizeof(xs__annotation), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_xs__annotation)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (xs__annotation *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_documentation1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_documentation1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "xs:documentation", &(a->xs__annotation::documentation), "xsd:string"))
				{	soap_flag_documentation1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (xs__annotation *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xs__annotation, 0, sizeof(xs__annotation), 0, soap_copy_xs__annotation);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int xs__annotation::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xs__annotation);
	if (this->soap_out(soap, tag?tag:"xs:annotation", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *xs__annotation::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_xs__annotation(soap, this, tag, type);
}

SOAP_FMAC3 xs__annotation * SOAP_FMAC4 soap_get_xs__annotation(struct soap *soap, xs__annotation *p, const char *tag, const char *type)
{
	if ((p = soap_in_xs__annotation(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 xs__annotation * SOAP_FMAC2 soap_instantiate_xs__annotation(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xs__annotation(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xs__annotation, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(xs__annotation);
		if (size)
			*size = sizeof(xs__annotation);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(xs__annotation[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(xs__annotation);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (xs__annotation*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xs__annotation(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xs__annotation %p -> %p\n", q, p));
	*(xs__annotation*)p = *(xs__annotation*)q;
}

void xs__union::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__NMTOKENS(soap, &this->xs__union::memberTypes);
	soap_default_std__vectorTemplateOfxs__simpleType(soap, &this->xs__union::simpleType);
}

void xs__union::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfxs__simpleType(soap, &this->xs__union::simpleType);
	/* transient traverse skipped */
}

int xs__union::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_xs__union(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xs__union(struct soap *soap, const char *tag, int id, const xs__union *a, const char *type)
{
	if (((xs__union*)a)->memberTypes)
		soap_set_attr(soap, "memberTypes", ((xs__union*)a)->memberTypes, 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xs__union), type))
		return soap->error;
	if (soap_out_std__vectorTemplateOfxs__simpleType(soap, "xs:simpleType", -1, &(a->xs__union::simpleType), ""))
		return soap->error;
	/* transient traverse skipped */
	return soap_element_end_out(soap, tag);
}

void *xs__union::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_xs__union(soap, tag, this, type);
}

SOAP_FMAC3 xs__union * SOAP_FMAC4 soap_in_xs__union(struct soap *soap, const char *tag, xs__union *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (xs__union *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xs__union, sizeof(xs__union), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_xs__union)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (xs__union *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "memberTypes", 0), &((xs__union*)a)->memberTypes, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfxs__simpleType(soap, "xs:simpleType", &(a->xs__union::simpleType), "xs:simpleType"))
					continue;
			/* transient traverse skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (xs__union *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xs__union, 0, sizeof(xs__union), 0, soap_copy_xs__union);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int xs__union::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xs__union);
	if (this->soap_out(soap, tag?tag:"xs:union", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *xs__union::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_xs__union(soap, this, tag, type);
}

SOAP_FMAC3 xs__union * SOAP_FMAC4 soap_get_xs__union(struct soap *soap, xs__union *p, const char *tag, const char *type)
{
	if ((p = soap_in_xs__union(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 xs__union * SOAP_FMAC2 soap_instantiate_xs__union(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xs__union(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xs__union, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(xs__union);
		if (size)
			*size = sizeof(xs__union);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(xs__union[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(xs__union);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (xs__union*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xs__union(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xs__union %p -> %p\n", q, p));
	*(xs__union*)p = *(xs__union*)q;
}

void xs__list::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__QName(soap, &this->xs__list::itemType);
	this->xs__list::restriction = NULL;
	soap_default_std__vectorTemplateOfxs__simpleType(soap, &this->xs__list::simpleType);
	this->xs__list::itemTypeRef = NULL;
}

void xs__list::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToxs__restriction(soap, &this->xs__list::restriction);
	soap_serialize_std__vectorTemplateOfxs__simpleType(soap, &this->xs__list::simpleType);
	/* non-serializable itemTypeRef skipped */
	/* transient xs__list skipped */
	/* transient traverse skipped */
	/* transient itemTypePtr skipped */
	/* transient itemTypePtr skipped */
}

int xs__list::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_xs__list(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xs__list(struct soap *soap, const char *tag, int id, const xs__list *a, const char *type)
{
	if (((xs__list*)a)->itemType)
		soap_set_attr(soap, "itemType", soap_QName2s(soap, ((xs__list*)a)->itemType), 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xs__list), type))
		return soap->error;
	if (soap_out_PointerToxs__restriction(soap, "xs:restriction", -1, &(a->xs__list::restriction), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfxs__simpleType(soap, "xs:simpleType", -1, &(a->xs__list::simpleType), ""))
		return soap->error;
	/* non-serializable itemTypeRef skipped */
	/* transient xs__list skipped */
	/* transient traverse skipped */
	/* transient itemTypePtr skipped */
	/* transient itemTypePtr skipped */
	return soap_element_end_out(soap, tag);
}

void *xs__list::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_xs__list(soap, tag, this, type);
}

SOAP_FMAC3 xs__list * SOAP_FMAC4 soap_in_xs__list(struct soap *soap, const char *tag, xs__list *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (xs__list *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xs__list, sizeof(xs__list), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_xs__list)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (xs__list *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2QName(soap, soap_attr_value(soap, "itemType", 0), &((xs__list*)a)->itemType, 0, -1))
		return NULL;
	size_t soap_flag_restriction1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_restriction1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__restriction(soap, "xs:restriction", &(a->xs__list::restriction), "xs:restriction"))
				{	soap_flag_restriction1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfxs__simpleType(soap, "xs:simpleType", &(a->xs__list::simpleType), "xs:simpleType"))
					continue;
			/* non-serializable itemTypeRef skipped */
			/* transient xs__list skipped */
			/* transient traverse skipped */
			/* transient itemTypePtr skipped */
			/* transient itemTypePtr skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (xs__list *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xs__list, 0, sizeof(xs__list), 0, soap_copy_xs__list);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int xs__list::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xs__list);
	if (this->soap_out(soap, tag?tag:"xs:list", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *xs__list::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_xs__list(soap, this, tag, type);
}

SOAP_FMAC3 xs__list * SOAP_FMAC4 soap_get_xs__list(struct soap *soap, xs__list *p, const char *tag, const char *type)
{
	if ((p = soap_in_xs__list(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 xs__list * SOAP_FMAC2 soap_instantiate_xs__list(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xs__list(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xs__list, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(xs__list);
		if (size)
			*size = sizeof(xs__list);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(xs__list[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(xs__list);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (xs__list*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xs__list(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xs__list %p -> %p\n", q, p));
	*(xs__list*)p = *(xs__list*)q;
}

void xs__group::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__NCName(soap, &this->xs__group::name);
	soap_default_xsd__QName(soap, &this->xs__group::ref);
	soap_default_xsd__string(soap, &this->xs__group::minOccurs);
	soap_default_xsd__string(soap, &this->xs__group::maxOccurs);
	this->xs__group::annotation = NULL;
	this->xs__group::all = NULL;
	this->xs__group::choice = NULL;
	this->xs__group::sequence = NULL;
	this->xs__group::schemaRef = NULL;
	this->xs__group::groupRef = NULL;
}

void xs__group::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToxs__annotation(soap, &this->xs__group::annotation);
	soap_serialize_PointerToxs__all(soap, &this->xs__group::all);
	soap_serialize_PointerToxs__seqchoice(soap, &this->xs__group::choice);
	soap_serialize_PointerToxs__seqchoice(soap, &this->xs__group::sequence);
	/* non-serializable schemaRef skipped */
	/* non-serializable groupRef skipped */
	/* transient xs__group skipped */
	/* transient traverse skipped */
	/* transient schemaPtr skipped */
	/* transient groupPtr skipped */
	/* transient schemaPtr skipped */
	/* transient groupPtr skipped */
}

int xs__group::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_xs__group(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xs__group(struct soap *soap, const char *tag, int id, const xs__group *a, const char *type)
{
	if (((xs__group*)a)->name)
		soap_set_attr(soap, "name", ((xs__group*)a)->name, 1);
	if (((xs__group*)a)->ref)
		soap_set_attr(soap, "ref", soap_QName2s(soap, ((xs__group*)a)->ref), 1);
	if (((xs__group*)a)->minOccurs)
		soap_set_attr(soap, "minOccurs", ((xs__group*)a)->minOccurs, 1);
	if (((xs__group*)a)->maxOccurs)
		soap_set_attr(soap, "maxOccurs", ((xs__group*)a)->maxOccurs, 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xs__group), type))
		return soap->error;
	if (soap_out_PointerToxs__annotation(soap, "xs:annotation", -1, &(a->xs__group::annotation), ""))
		return soap->error;
	if (soap_out_PointerToxs__all(soap, "xs:all", -1, &(a->xs__group::all), ""))
		return soap->error;
	if (soap_out_PointerToxs__seqchoice(soap, "xs:choice", -1, &(a->xs__group::choice), ""))
		return soap->error;
	if (soap_out_PointerToxs__seqchoice(soap, "xs:sequence", -1, &(a->xs__group::sequence), ""))
		return soap->error;
	/* non-serializable schemaRef skipped */
	/* non-serializable groupRef skipped */
	/* transient xs__group skipped */
	/* transient traverse skipped */
	/* transient schemaPtr skipped */
	/* transient groupPtr skipped */
	/* transient schemaPtr skipped */
	/* transient groupPtr skipped */
	return soap_element_end_out(soap, tag);
}

void *xs__group::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_xs__group(soap, tag, this, type);
}

SOAP_FMAC3 xs__group * SOAP_FMAC4 soap_in_xs__group(struct soap *soap, const char *tag, xs__group *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (xs__group *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xs__group, sizeof(xs__group), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_xs__group)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (xs__group *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "name", 0), &((xs__group*)a)->name, 0, -1))
		return NULL;
	if (soap_s2QName(soap, soap_attr_value(soap, "ref", 0), &((xs__group*)a)->ref, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "minOccurs", 0), &((xs__group*)a)->minOccurs, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "maxOccurs", 0), &((xs__group*)a)->maxOccurs, 0, -1))
		return NULL;
	size_t soap_flag_annotation1 = 1;
	size_t soap_flag_all1 = 1;
	size_t soap_flag_choice1 = 1;
	size_t soap_flag_sequence1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_annotation1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__annotation(soap, "xs:annotation", &(a->xs__group::annotation), "xs:annotation"))
				{	soap_flag_annotation1--;
					continue;
				}
			if (soap_flag_all1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__all(soap, "xs:all", &(a->xs__group::all), "xs:all"))
				{	soap_flag_all1--;
					continue;
				}
			if (soap_flag_choice1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__seqchoice(soap, "xs:choice", &(a->xs__group::choice), "xs:seqchoice"))
				{	soap_flag_choice1--;
					continue;
				}
			if (soap_flag_sequence1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__seqchoice(soap, "xs:sequence", &(a->xs__group::sequence), "xs:seqchoice"))
				{	soap_flag_sequence1--;
					continue;
				}
			/* non-serializable schemaRef skipped */
			/* non-serializable groupRef skipped */
			/* transient xs__group skipped */
			/* transient traverse skipped */
			/* transient schemaPtr skipped */
			/* transient groupPtr skipped */
			/* transient schemaPtr skipped */
			/* transient groupPtr skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (xs__group *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xs__group, 0, sizeof(xs__group), 0, soap_copy_xs__group);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int xs__group::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xs__group);
	if (this->soap_out(soap, tag?tag:"xs:group", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *xs__group::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_xs__group(soap, this, tag, type);
}

SOAP_FMAC3 xs__group * SOAP_FMAC4 soap_get_xs__group(struct soap *soap, xs__group *p, const char *tag, const char *type)
{
	if ((p = soap_in_xs__group(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 xs__group * SOAP_FMAC2 soap_instantiate_xs__group(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xs__group(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xs__group, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(xs__group);
		if (size)
			*size = sizeof(xs__group);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(xs__group[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(xs__group);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (xs__group*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xs__group(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xs__group %p -> %p\n", q, p));
	*(xs__group*)p = *(xs__group*)q;
}

void xs__seqchoice::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &this->xs__seqchoice::minOccurs);
	soap_default_xsd__string(soap, &this->xs__seqchoice::maxOccurs);
	this->xs__seqchoice::annotation = NULL;
	soap_default_std__vectorTemplateOfxs__contents(soap, &this->xs__seqchoice::__contents);
	this->xs__seqchoice::schemaRef = NULL;
}

void xs__seqchoice::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToxs__annotation(soap, &this->xs__seqchoice::annotation);
	soap_serialize_std__vectorTemplateOfxs__contents(soap, &this->xs__seqchoice::__contents);
	/* non-serializable schemaRef skipped */
	/* transient xs__seqchoice skipped */
	/* transient traverse skipped */
	/* transient schemaPtr skipped */
	/* transient schemaPtr skipped */
}

int xs__seqchoice::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_xs__seqchoice(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xs__seqchoice(struct soap *soap, const char *tag, int id, const xs__seqchoice *a, const char *type)
{
	if (((xs__seqchoice*)a)->minOccurs)
		soap_set_attr(soap, "minOccurs", ((xs__seqchoice*)a)->minOccurs, 1);
	if (((xs__seqchoice*)a)->maxOccurs)
		soap_set_attr(soap, "maxOccurs", ((xs__seqchoice*)a)->maxOccurs, 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xs__seqchoice), type))
		return soap->error;
	if (soap_out_PointerToxs__annotation(soap, "xs:annotation", -1, &(a->xs__seqchoice::annotation), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfxs__contents(soap, "-contents", -1, &(a->xs__seqchoice::__contents), ""))
		return soap->error;
	/* non-serializable schemaRef skipped */
	/* transient xs__seqchoice skipped */
	/* transient traverse skipped */
	/* transient schemaPtr skipped */
	/* transient schemaPtr skipped */
	return soap_element_end_out(soap, tag);
}

void *xs__seqchoice::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_xs__seqchoice(soap, tag, this, type);
}

SOAP_FMAC3 xs__seqchoice * SOAP_FMAC4 soap_in_xs__seqchoice(struct soap *soap, const char *tag, xs__seqchoice *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (xs__seqchoice *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xs__seqchoice, sizeof(xs__seqchoice), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_xs__seqchoice)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (xs__seqchoice *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "minOccurs", 0), &((xs__seqchoice*)a)->minOccurs, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "maxOccurs", 0), &((xs__seqchoice*)a)->maxOccurs, 0, -1))
		return NULL;
	size_t soap_flag_annotation1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_annotation1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__annotation(soap, "xs:annotation", &(a->xs__seqchoice::annotation), "xs:annotation"))
				{	soap_flag_annotation1--;
					continue;
				}
			/* non-serializable schemaRef skipped */
			/* transient xs__seqchoice skipped */
			/* transient traverse skipped */
			/* transient schemaPtr skipped */
			/* transient schemaPtr skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfxs__contents(soap, "-contents", &(a->xs__seqchoice::__contents), "xs:contents"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (xs__seqchoice *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xs__seqchoice, 0, sizeof(xs__seqchoice), 0, soap_copy_xs__seqchoice);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int xs__seqchoice::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xs__seqchoice);
	if (this->soap_out(soap, tag?tag:"xs:seqchoice", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *xs__seqchoice::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_xs__seqchoice(soap, this, tag, type);
}

SOAP_FMAC3 xs__seqchoice * SOAP_FMAC4 soap_get_xs__seqchoice(struct soap *soap, xs__seqchoice *p, const char *tag, const char *type)
{
	if ((p = soap_in_xs__seqchoice(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 xs__seqchoice * SOAP_FMAC2 soap_instantiate_xs__seqchoice(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xs__seqchoice(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xs__seqchoice, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(xs__seqchoice);
		if (size)
			*size = sizeof(xs__seqchoice);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(xs__seqchoice[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(xs__seqchoice);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (xs__seqchoice*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xs__seqchoice(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xs__seqchoice %p -> %p\n", q, p));
	*(xs__seqchoice*)p = *(xs__seqchoice*)q;
}

void xs__restriction::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__QName(soap, &this->xs__restriction::base);
	this->xs__restriction::group = NULL;
	this->xs__restriction::all = NULL;
	this->xs__restriction::choice = NULL;
	this->xs__restriction::sequence = NULL;
	soap_default_std__vectorTemplateOfxs__attribute(soap, &this->xs__restriction::attribute);
	this->xs__restriction::anyAttribute = NULL;
	soap_default_std__vectorTemplateOfxs__enumeration(soap, &this->xs__restriction::enumeration);
	soap_default_std__vectorTemplateOfxs__pattern(soap, &this->xs__restriction::pattern);
	this->xs__restriction::whiteSpace = NULL;
	this->xs__restriction::length = NULL;
	this->xs__restriction::minLength = NULL;
	this->xs__restriction::maxLength = NULL;
	this->xs__restriction::precision = NULL;
	this->xs__restriction::scale = NULL;
	this->xs__restriction::totalDigits = NULL;
	this->xs__restriction::fractionDigits = NULL;
	this->xs__restriction::minInclusive = NULL;
	this->xs__restriction::maxInclusive = NULL;
	this->xs__restriction::minExclusive = NULL;
	this->xs__restriction::maxExclusive = NULL;
	this->xs__restriction::annotation = NULL;
	this->xs__restriction::simpleTypeRef = NULL;
	this->xs__restriction::complexTypeRef = NULL;
}

void xs__restriction::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToxs__group(soap, &this->xs__restriction::group);
	soap_serialize_PointerToxs__all(soap, &this->xs__restriction::all);
	soap_serialize_PointerToxs__seqchoice(soap, &this->xs__restriction::choice);
	soap_serialize_PointerToxs__seqchoice(soap, &this->xs__restriction::sequence);
	soap_serialize_std__vectorTemplateOfxs__attribute(soap, &this->xs__restriction::attribute);
	soap_serialize_PointerToxs__anyAttribute(soap, &this->xs__restriction::anyAttribute);
	soap_serialize_std__vectorTemplateOfxs__enumeration(soap, &this->xs__restriction::enumeration);
	soap_serialize_std__vectorTemplateOfxs__pattern(soap, &this->xs__restriction::pattern);
	soap_serialize_PointerToxs__whiteSpace(soap, &this->xs__restriction::whiteSpace);
	soap_serialize_PointerToxs__length(soap, &this->xs__restriction::length);
	soap_serialize_PointerToxs__length(soap, &this->xs__restriction::minLength);
	soap_serialize_PointerToxs__length(soap, &this->xs__restriction::maxLength);
	soap_serialize_PointerToxs__length(soap, &this->xs__restriction::precision);
	soap_serialize_PointerToxs__length(soap, &this->xs__restriction::scale);
	soap_serialize_PointerToxs__length(soap, &this->xs__restriction::totalDigits);
	soap_serialize_PointerToxs__length(soap, &this->xs__restriction::fractionDigits);
	soap_serialize_PointerToxs__length(soap, &this->xs__restriction::minInclusive);
	soap_serialize_PointerToxs__length(soap, &this->xs__restriction::maxInclusive);
	soap_serialize_PointerToxs__length(soap, &this->xs__restriction::minExclusive);
	soap_serialize_PointerToxs__length(soap, &this->xs__restriction::maxExclusive);
	soap_serialize_PointerToxs__annotation(soap, &this->xs__restriction::annotation);
	/* non-serializable simpleTypeRef skipped */
	/* non-serializable complexTypeRef skipped */
	/* transient xs__restriction skipped */
	/* transient traverse skipped */
	/* transient simpleTypePtr skipped */
	/* transient complexTypePtr skipped */
	/* transient simpleTypePtr skipped */
	/* transient complexTypePtr skipped */
}

int xs__restriction::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_xs__restriction(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xs__restriction(struct soap *soap, const char *tag, int id, const xs__restriction *a, const char *type)
{
	if (((xs__restriction*)a)->base)
		soap_set_attr(soap, "base", soap_QName2s(soap, ((xs__restriction*)a)->base), 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xs__restriction), type))
		return soap->error;
	if (soap_out_PointerToxs__group(soap, "xs:group", -1, &(a->xs__restriction::group), ""))
		return soap->error;
	if (soap_out_PointerToxs__all(soap, "xs:all", -1, &(a->xs__restriction::all), ""))
		return soap->error;
	if (soap_out_PointerToxs__seqchoice(soap, "xs:choice", -1, &(a->xs__restriction::choice), ""))
		return soap->error;
	if (soap_out_PointerToxs__seqchoice(soap, "xs:sequence", -1, &(a->xs__restriction::sequence), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfxs__attribute(soap, "xs:attribute", -1, &(a->xs__restriction::attribute), ""))
		return soap->error;
	if (soap_out_PointerToxs__anyAttribute(soap, "xs:anyAttribute", -1, &(a->xs__restriction::anyAttribute), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfxs__enumeration(soap, "xs:enumeration", -1, &(a->xs__restriction::enumeration), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfxs__pattern(soap, "xs:pattern", -1, &(a->xs__restriction::pattern), ""))
		return soap->error;
	if (soap_out_PointerToxs__whiteSpace(soap, "xs:whiteSpace", -1, &(a->xs__restriction::whiteSpace), ""))
		return soap->error;
	if (soap_out_PointerToxs__length(soap, "xs:length", -1, &(a->xs__restriction::length), ""))
		return soap->error;
	if (soap_out_PointerToxs__length(soap, "xs:minLength", -1, &(a->xs__restriction::minLength), ""))
		return soap->error;
	if (soap_out_PointerToxs__length(soap, "xs:maxLength", -1, &(a->xs__restriction::maxLength), ""))
		return soap->error;
	if (soap_out_PointerToxs__length(soap, "xs:precision", -1, &(a->xs__restriction::precision), ""))
		return soap->error;
	if (soap_out_PointerToxs__length(soap, "xs:scale", -1, &(a->xs__restriction::scale), ""))
		return soap->error;
	if (soap_out_PointerToxs__length(soap, "xs:totalDigits", -1, &(a->xs__restriction::totalDigits), ""))
		return soap->error;
	if (soap_out_PointerToxs__length(soap, "xs:fractionDigits", -1, &(a->xs__restriction::fractionDigits), ""))
		return soap->error;
	if (soap_out_PointerToxs__length(soap, "xs:minInclusive", -1, &(a->xs__restriction::minInclusive), ""))
		return soap->error;
	if (soap_out_PointerToxs__length(soap, "xs:maxInclusive", -1, &(a->xs__restriction::maxInclusive), ""))
		return soap->error;
	if (soap_out_PointerToxs__length(soap, "xs:minExclusive", -1, &(a->xs__restriction::minExclusive), ""))
		return soap->error;
	if (soap_out_PointerToxs__length(soap, "xs:maxExclusive", -1, &(a->xs__restriction::maxExclusive), ""))
		return soap->error;
	if (soap_out_PointerToxs__annotation(soap, "xs:annotation", -1, &(a->xs__restriction::annotation), ""))
		return soap->error;
	/* non-serializable simpleTypeRef skipped */
	/* non-serializable complexTypeRef skipped */
	/* transient xs__restriction skipped */
	/* transient traverse skipped */
	/* transient simpleTypePtr skipped */
	/* transient complexTypePtr skipped */
	/* transient simpleTypePtr skipped */
	/* transient complexTypePtr skipped */
	return soap_element_end_out(soap, tag);
}

void *xs__restriction::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_xs__restriction(soap, tag, this, type);
}

SOAP_FMAC3 xs__restriction * SOAP_FMAC4 soap_in_xs__restriction(struct soap *soap, const char *tag, xs__restriction *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (xs__restriction *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xs__restriction, sizeof(xs__restriction), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_xs__restriction)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (xs__restriction *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2QName(soap, soap_attr_value(soap, "base", 0), &((xs__restriction*)a)->base, 0, -1))
		return NULL;
	size_t soap_flag_group1 = 1;
	size_t soap_flag_all1 = 1;
	size_t soap_flag_choice1 = 1;
	size_t soap_flag_sequence1 = 1;
	size_t soap_flag_anyAttribute1 = 1;
	size_t soap_flag_whiteSpace1 = 1;
	size_t soap_flag_length1 = 1;
	size_t soap_flag_minLength1 = 1;
	size_t soap_flag_maxLength1 = 1;
	size_t soap_flag_precision1 = 1;
	size_t soap_flag_scale1 = 1;
	size_t soap_flag_totalDigits1 = 1;
	size_t soap_flag_fractionDigits1 = 1;
	size_t soap_flag_minInclusive1 = 1;
	size_t soap_flag_maxInclusive1 = 1;
	size_t soap_flag_minExclusive1 = 1;
	size_t soap_flag_maxExclusive1 = 1;
	size_t soap_flag_annotation1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_group1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__group(soap, "xs:group", &(a->xs__restriction::group), "xs:group"))
				{	soap_flag_group1--;
					continue;
				}
			if (soap_flag_all1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__all(soap, "xs:all", &(a->xs__restriction::all), "xs:all"))
				{	soap_flag_all1--;
					continue;
				}
			if (soap_flag_choice1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__seqchoice(soap, "xs:choice", &(a->xs__restriction::choice), "xs:seqchoice"))
				{	soap_flag_choice1--;
					continue;
				}
			if (soap_flag_sequence1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__seqchoice(soap, "xs:sequence", &(a->xs__restriction::sequence), "xs:seqchoice"))
				{	soap_flag_sequence1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfxs__attribute(soap, "xs:attribute", &(a->xs__restriction::attribute), "xs:attribute"))
					continue;
			if (soap_flag_anyAttribute1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__anyAttribute(soap, "xs:anyAttribute", &(a->xs__restriction::anyAttribute), "xs:anyAttribute"))
				{	soap_flag_anyAttribute1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfxs__enumeration(soap, "xs:enumeration", &(a->xs__restriction::enumeration), "xs:enumeration"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfxs__pattern(soap, "xs:pattern", &(a->xs__restriction::pattern), "xs:pattern"))
					continue;
			if (soap_flag_whiteSpace1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__whiteSpace(soap, "xs:whiteSpace", &(a->xs__restriction::whiteSpace), "xs:whiteSpace"))
				{	soap_flag_whiteSpace1--;
					continue;
				}
			if (soap_flag_length1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__length(soap, "xs:length", &(a->xs__restriction::length), "xs:length"))
				{	soap_flag_length1--;
					continue;
				}
			if (soap_flag_minLength1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__length(soap, "xs:minLength", &(a->xs__restriction::minLength), "xs:length"))
				{	soap_flag_minLength1--;
					continue;
				}
			if (soap_flag_maxLength1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__length(soap, "xs:maxLength", &(a->xs__restriction::maxLength), "xs:length"))
				{	soap_flag_maxLength1--;
					continue;
				}
			if (soap_flag_precision1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__length(soap, "xs:precision", &(a->xs__restriction::precision), "xs:length"))
				{	soap_flag_precision1--;
					continue;
				}
			if (soap_flag_scale1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__length(soap, "xs:scale", &(a->xs__restriction::scale), "xs:length"))
				{	soap_flag_scale1--;
					continue;
				}
			if (soap_flag_totalDigits1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__length(soap, "xs:totalDigits", &(a->xs__restriction::totalDigits), "xs:length"))
				{	soap_flag_totalDigits1--;
					continue;
				}
			if (soap_flag_fractionDigits1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__length(soap, "xs:fractionDigits", &(a->xs__restriction::fractionDigits), "xs:length"))
				{	soap_flag_fractionDigits1--;
					continue;
				}
			if (soap_flag_minInclusive1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__length(soap, "xs:minInclusive", &(a->xs__restriction::minInclusive), "xs:length"))
				{	soap_flag_minInclusive1--;
					continue;
				}
			if (soap_flag_maxInclusive1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__length(soap, "xs:maxInclusive", &(a->xs__restriction::maxInclusive), "xs:length"))
				{	soap_flag_maxInclusive1--;
					continue;
				}
			if (soap_flag_minExclusive1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__length(soap, "xs:minExclusive", &(a->xs__restriction::minExclusive), "xs:length"))
				{	soap_flag_minExclusive1--;
					continue;
				}
			if (soap_flag_maxExclusive1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__length(soap, "xs:maxExclusive", &(a->xs__restriction::maxExclusive), "xs:length"))
				{	soap_flag_maxExclusive1--;
					continue;
				}
			if (soap_flag_annotation1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__annotation(soap, "xs:annotation", &(a->xs__restriction::annotation), "xs:annotation"))
				{	soap_flag_annotation1--;
					continue;
				}
			/* non-serializable simpleTypeRef skipped */
			/* non-serializable complexTypeRef skipped */
			/* transient xs__restriction skipped */
			/* transient traverse skipped */
			/* transient simpleTypePtr skipped */
			/* transient complexTypePtr skipped */
			/* transient simpleTypePtr skipped */
			/* transient complexTypePtr skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (xs__restriction *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xs__restriction, 0, sizeof(xs__restriction), 0, soap_copy_xs__restriction);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int xs__restriction::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xs__restriction);
	if (this->soap_out(soap, tag?tag:"xs:restriction", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *xs__restriction::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_xs__restriction(soap, this, tag, type);
}

SOAP_FMAC3 xs__restriction * SOAP_FMAC4 soap_get_xs__restriction(struct soap *soap, xs__restriction *p, const char *tag, const char *type)
{
	if ((p = soap_in_xs__restriction(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 xs__restriction * SOAP_FMAC2 soap_instantiate_xs__restriction(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xs__restriction(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xs__restriction, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(xs__restriction);
		if (size)
			*size = sizeof(xs__restriction);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(xs__restriction[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(xs__restriction);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (xs__restriction*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xs__restriction(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xs__restriction %p -> %p\n", q, p));
	*(xs__restriction*)p = *(xs__restriction*)q;
}

void xs__extension::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__QName(soap, &this->xs__extension::base);
	this->xs__extension::group = NULL;
	this->xs__extension::all = NULL;
	this->xs__extension::choice = NULL;
	this->xs__extension::sequence = NULL;
	soap_default_std__vectorTemplateOfxs__attribute(soap, &this->xs__extension::attribute);
	soap_default_std__vectorTemplateOfxs__attributeGroup(soap, &this->xs__extension::attributeGroup);
	this->xs__extension::anyAttribute = NULL;
	this->xs__extension::simpleTypeRef = NULL;
	this->xs__extension::complexTypeRef = NULL;
}

void xs__extension::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToxs__group(soap, &this->xs__extension::group);
	soap_serialize_PointerToxs__all(soap, &this->xs__extension::all);
	soap_serialize_PointerToxs__seqchoice(soap, &this->xs__extension::choice);
	soap_serialize_PointerToxs__seqchoice(soap, &this->xs__extension::sequence);
	soap_serialize_std__vectorTemplateOfxs__attribute(soap, &this->xs__extension::attribute);
	soap_serialize_std__vectorTemplateOfxs__attributeGroup(soap, &this->xs__extension::attributeGroup);
	soap_serialize_PointerToxs__anyAttribute(soap, &this->xs__extension::anyAttribute);
	/* non-serializable simpleTypeRef skipped */
	/* non-serializable complexTypeRef skipped */
	/* transient xs__extension skipped */
	/* transient traverse skipped */
	/* transient simpleTypePtr skipped */
	/* transient complexTypePtr skipped */
	/* transient simpleTypePtr skipped */
	/* transient complexTypePtr skipped */
}

int xs__extension::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_xs__extension(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xs__extension(struct soap *soap, const char *tag, int id, const xs__extension *a, const char *type)
{
	if (((xs__extension*)a)->base)
		soap_set_attr(soap, "base", soap_QName2s(soap, ((xs__extension*)a)->base), 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xs__extension), type))
		return soap->error;
	if (soap_out_PointerToxs__group(soap, "xs:group", -1, &(a->xs__extension::group), ""))
		return soap->error;
	if (soap_out_PointerToxs__all(soap, "xs:all", -1, &(a->xs__extension::all), ""))
		return soap->error;
	if (soap_out_PointerToxs__seqchoice(soap, "xs:choice", -1, &(a->xs__extension::choice), ""))
		return soap->error;
	if (soap_out_PointerToxs__seqchoice(soap, "xs:sequence", -1, &(a->xs__extension::sequence), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfxs__attribute(soap, "xs:attribute", -1, &(a->xs__extension::attribute), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfxs__attributeGroup(soap, "xs:attributeGroup", -1, &(a->xs__extension::attributeGroup), ""))
		return soap->error;
	if (soap_out_PointerToxs__anyAttribute(soap, "xs:anyAttribute", -1, &(a->xs__extension::anyAttribute), ""))
		return soap->error;
	/* non-serializable simpleTypeRef skipped */
	/* non-serializable complexTypeRef skipped */
	/* transient xs__extension skipped */
	/* transient traverse skipped */
	/* transient simpleTypePtr skipped */
	/* transient complexTypePtr skipped */
	/* transient simpleTypePtr skipped */
	/* transient complexTypePtr skipped */
	return soap_element_end_out(soap, tag);
}

void *xs__extension::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_xs__extension(soap, tag, this, type);
}

SOAP_FMAC3 xs__extension * SOAP_FMAC4 soap_in_xs__extension(struct soap *soap, const char *tag, xs__extension *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (xs__extension *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xs__extension, sizeof(xs__extension), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_xs__extension)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (xs__extension *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2QName(soap, soap_attr_value(soap, "base", 0), &((xs__extension*)a)->base, 0, -1))
		return NULL;
	size_t soap_flag_group1 = 1;
	size_t soap_flag_all1 = 1;
	size_t soap_flag_choice1 = 1;
	size_t soap_flag_sequence1 = 1;
	size_t soap_flag_anyAttribute1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_group1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__group(soap, "xs:group", &(a->xs__extension::group), "xs:group"))
				{	soap_flag_group1--;
					continue;
				}
			if (soap_flag_all1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__all(soap, "xs:all", &(a->xs__extension::all), "xs:all"))
				{	soap_flag_all1--;
					continue;
				}
			if (soap_flag_choice1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__seqchoice(soap, "xs:choice", &(a->xs__extension::choice), "xs:seqchoice"))
				{	soap_flag_choice1--;
					continue;
				}
			if (soap_flag_sequence1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__seqchoice(soap, "xs:sequence", &(a->xs__extension::sequence), "xs:seqchoice"))
				{	soap_flag_sequence1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfxs__attribute(soap, "xs:attribute", &(a->xs__extension::attribute), "xs:attribute"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfxs__attributeGroup(soap, "xs:attributeGroup", &(a->xs__extension::attributeGroup), "xs:attributeGroup"))
					continue;
			if (soap_flag_anyAttribute1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__anyAttribute(soap, "xs:anyAttribute", &(a->xs__extension::anyAttribute), "xs:anyAttribute"))
				{	soap_flag_anyAttribute1--;
					continue;
				}
			/* non-serializable simpleTypeRef skipped */
			/* non-serializable complexTypeRef skipped */
			/* transient xs__extension skipped */
			/* transient traverse skipped */
			/* transient simpleTypePtr skipped */
			/* transient complexTypePtr skipped */
			/* transient simpleTypePtr skipped */
			/* transient complexTypePtr skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (xs__extension *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xs__extension, 0, sizeof(xs__extension), 0, soap_copy_xs__extension);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int xs__extension::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xs__extension);
	if (this->soap_out(soap, tag?tag:"xs:extension", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *xs__extension::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_xs__extension(soap, this, tag, type);
}

SOAP_FMAC3 xs__extension * SOAP_FMAC4 soap_get_xs__extension(struct soap *soap, xs__extension *p, const char *tag, const char *type)
{
	if ((p = soap_in_xs__extension(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 xs__extension * SOAP_FMAC2 soap_instantiate_xs__extension(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xs__extension(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xs__extension, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(xs__extension);
		if (size)
			*size = sizeof(xs__extension);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(xs__extension[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(xs__extension);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (xs__extension*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xs__extension(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xs__extension %p -> %p\n", q, p));
	*(xs__extension*)p = *(xs__extension*)q;
}

void xs__complexType::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__NMTOKEN(soap, &this->xs__complexType::name);
	this->xs__complexType::abstract = (bool)0;
	this->xs__complexType::mixed = (bool)0;
	this->xs__complexType::annotation = NULL;
	this->xs__complexType::simpleContent = NULL;
	this->xs__complexType::complexContent = NULL;
	this->xs__complexType::all = NULL;
	this->xs__complexType::choice = NULL;
	this->xs__complexType::sequence = NULL;
	this->xs__complexType::any = NULL;
	soap_default_std__vectorTemplateOfxs__attribute(soap, &this->xs__complexType::attribute);
	soap_default_std__vectorTemplateOfxs__attributeGroup(soap, &this->xs__complexType::attributeGroup);
	this->xs__complexType::anyAttribute = NULL;
	this->xs__complexType::schemaRef = NULL;
	this->xs__complexType::level = 0;
}

void xs__complexType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToxs__annotation(soap, &this->xs__complexType::annotation);
	soap_serialize_PointerToxs__simpleContent(soap, &this->xs__complexType::simpleContent);
	soap_serialize_PointerToxs__complexContent(soap, &this->xs__complexType::complexContent);
	soap_serialize_PointerToxs__all(soap, &this->xs__complexType::all);
	soap_serialize_PointerToxs__seqchoice(soap, &this->xs__complexType::choice);
	soap_serialize_PointerToxs__seqchoice(soap, &this->xs__complexType::sequence);
	soap_serialize_PointerToxs__any(soap, &this->xs__complexType::any);
	soap_serialize_std__vectorTemplateOfxs__attribute(soap, &this->xs__complexType::attribute);
	soap_serialize_std__vectorTemplateOfxs__attributeGroup(soap, &this->xs__complexType::attributeGroup);
	soap_serialize_PointerToxs__anyAttribute(soap, &this->xs__complexType::anyAttribute);
	/* non-serializable schemaRef skipped */
	/* non-serializable level skipped */
	/* transient xs__complexType skipped */
	/* transient traverse skipped */
	/* transient schemaPtr skipped */
	/* transient schemaPtr skipped */
	/* transient baseLevel skipped */
}

int xs__complexType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_xs__complexType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xs__complexType(struct soap *soap, const char *tag, int id, const xs__complexType *a, const char *type)
{
	if (((xs__complexType*)a)->name)
		soap_set_attr(soap, "name", ((xs__complexType*)a)->name, 1);
	soap_set_attr(soap, "abstract", soap_xsd__boolean2s(soap, ((xs__complexType*)a)->abstract), 1);
	soap_set_attr(soap, "mixed", soap_xsd__boolean2s(soap, ((xs__complexType*)a)->mixed), 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xs__complexType), type))
		return soap->error;
	if (soap_out_PointerToxs__annotation(soap, "xs:annotation", -1, &(a->xs__complexType::annotation), ""))
		return soap->error;
	if (soap_out_PointerToxs__simpleContent(soap, "xs:simpleContent", -1, &(a->xs__complexType::simpleContent), ""))
		return soap->error;
	if (soap_out_PointerToxs__complexContent(soap, "xs:complexContent", -1, &(a->xs__complexType::complexContent), ""))
		return soap->error;
	if (soap_out_PointerToxs__all(soap, "xs:all", -1, &(a->xs__complexType::all), ""))
		return soap->error;
	if (soap_out_PointerToxs__seqchoice(soap, "xs:choice", -1, &(a->xs__complexType::choice), ""))
		return soap->error;
	if (soap_out_PointerToxs__seqchoice(soap, "xs:sequence", -1, &(a->xs__complexType::sequence), ""))
		return soap->error;
	if (soap_out_PointerToxs__any(soap, "xs:any", -1, &(a->xs__complexType::any), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfxs__attribute(soap, "xs:attribute", -1, &(a->xs__complexType::attribute), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfxs__attributeGroup(soap, "xs:attributeGroup", -1, &(a->xs__complexType::attributeGroup), ""))
		return soap->error;
	if (soap_out_PointerToxs__anyAttribute(soap, "xs:anyAttribute", -1, &(a->xs__complexType::anyAttribute), ""))
		return soap->error;
	/* non-serializable schemaRef skipped */
	/* non-serializable level skipped */
	/* transient xs__complexType skipped */
	/* transient traverse skipped */
	/* transient schemaPtr skipped */
	/* transient schemaPtr skipped */
	/* transient baseLevel skipped */
	return soap_element_end_out(soap, tag);
}

void *xs__complexType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_xs__complexType(soap, tag, this, type);
}

SOAP_FMAC3 xs__complexType * SOAP_FMAC4 soap_in_xs__complexType(struct soap *soap, const char *tag, xs__complexType *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (xs__complexType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xs__complexType, sizeof(xs__complexType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_xs__complexType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (xs__complexType *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "name", 0), &((xs__complexType*)a)->name, 0, -1))
		return NULL;
	if (soap_s2xsd__boolean(soap, soap_attr_value(soap, "abstract", 0), &((xs__complexType*)a)->abstract))
		return NULL;
	if (soap_s2xsd__boolean(soap, soap_attr_value(soap, "mixed", 0), &((xs__complexType*)a)->mixed))
		return NULL;
	size_t soap_flag_annotation1 = 1;
	size_t soap_flag_simpleContent1 = 1;
	size_t soap_flag_complexContent1 = 1;
	size_t soap_flag_all1 = 1;
	size_t soap_flag_choice1 = 1;
	size_t soap_flag_sequence1 = 1;
	size_t soap_flag_any1 = 1;
	size_t soap_flag_anyAttribute1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_annotation1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__annotation(soap, "xs:annotation", &(a->xs__complexType::annotation), "xs:annotation"))
				{	soap_flag_annotation1--;
					continue;
				}
			if (soap_flag_simpleContent1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__simpleContent(soap, "xs:simpleContent", &(a->xs__complexType::simpleContent), "xs:simpleContent"))
				{	soap_flag_simpleContent1--;
					continue;
				}
			if (soap_flag_complexContent1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__complexContent(soap, "xs:complexContent", &(a->xs__complexType::complexContent), "xs:complexContent"))
				{	soap_flag_complexContent1--;
					continue;
				}
			if (soap_flag_all1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__all(soap, "xs:all", &(a->xs__complexType::all), "xs:all"))
				{	soap_flag_all1--;
					continue;
				}
			if (soap_flag_choice1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__seqchoice(soap, "xs:choice", &(a->xs__complexType::choice), "xs:seqchoice"))
				{	soap_flag_choice1--;
					continue;
				}
			if (soap_flag_sequence1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__seqchoice(soap, "xs:sequence", &(a->xs__complexType::sequence), "xs:seqchoice"))
				{	soap_flag_sequence1--;
					continue;
				}
			if (soap_flag_any1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__any(soap, "xs:any", &(a->xs__complexType::any), "xs:any"))
				{	soap_flag_any1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfxs__attribute(soap, "xs:attribute", &(a->xs__complexType::attribute), "xs:attribute"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfxs__attributeGroup(soap, "xs:attributeGroup", &(a->xs__complexType::attributeGroup), "xs:attributeGroup"))
					continue;
			if (soap_flag_anyAttribute1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__anyAttribute(soap, "xs:anyAttribute", &(a->xs__complexType::anyAttribute), "xs:anyAttribute"))
				{	soap_flag_anyAttribute1--;
					continue;
				}
			/* non-serializable schemaRef skipped */
			/* non-serializable level skipped */
			/* transient xs__complexType skipped */
			/* transient traverse skipped */
			/* transient schemaPtr skipped */
			/* transient schemaPtr skipped */
			/* transient baseLevel skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (xs__complexType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xs__complexType, 0, sizeof(xs__complexType), 0, soap_copy_xs__complexType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int xs__complexType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xs__complexType);
	if (this->soap_out(soap, tag?tag:"xs:complexType", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *xs__complexType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_xs__complexType(soap, this, tag, type);
}

SOAP_FMAC3 xs__complexType * SOAP_FMAC4 soap_get_xs__complexType(struct soap *soap, xs__complexType *p, const char *tag, const char *type)
{
	if ((p = soap_in_xs__complexType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 xs__complexType * SOAP_FMAC2 soap_instantiate_xs__complexType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xs__complexType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xs__complexType, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(xs__complexType);
		if (size)
			*size = sizeof(xs__complexType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(xs__complexType[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(xs__complexType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (xs__complexType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xs__complexType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xs__complexType %p -> %p\n", q, p));
	*(xs__complexType*)p = *(xs__complexType*)q;
}

void xs__simpleType::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_xsd__NMTOKEN(soap, &this->xs__simpleType::name);
	this->xs__simpleType::annotation = NULL;
	this->xs__simpleType::restriction = NULL;
	this->xs__simpleType::list = NULL;
	this->xs__simpleType::union_ = NULL;
	this->xs__simpleType::schemaRef = NULL;
	this->xs__simpleType::level = 0;
}

void xs__simpleType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToxs__annotation(soap, &this->xs__simpleType::annotation);
	soap_serialize_PointerToxs__restriction(soap, &this->xs__simpleType::restriction);
	soap_serialize_PointerToxs__list(soap, &this->xs__simpleType::list);
	soap_serialize_PointerToxs__union(soap, &this->xs__simpleType::union_);
	/* non-serializable schemaRef skipped */
	/* non-serializable level skipped */
	/* transient xs__simpleType skipped */
	/* transient traverse skipped */
	/* transient schemaPtr skipped */
	/* transient schemaPtr skipped */
	/* transient baseLevel skipped */
}

int xs__simpleType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_xs__simpleType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xs__simpleType(struct soap *soap, const char *tag, int id, const xs__simpleType *a, const char *type)
{
	if (((xs__simpleType*)a)->name)
		soap_set_attr(soap, "name", ((xs__simpleType*)a)->name, 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xs__simpleType), type))
		return soap->error;
	if (soap_out_PointerToxs__annotation(soap, "xs:annotation", -1, &(a->xs__simpleType::annotation), ""))
		return soap->error;
	if (soap_out_PointerToxs__restriction(soap, "xs:restriction", -1, &(a->xs__simpleType::restriction), ""))
		return soap->error;
	if (soap_out_PointerToxs__list(soap, "xs:list", -1, &(a->xs__simpleType::list), ""))
		return soap->error;
	if (soap_out_PointerToxs__union(soap, "xs:union", -1, &(a->xs__simpleType::union_), ""))
		return soap->error;
	/* non-serializable schemaRef skipped */
	/* non-serializable level skipped */
	/* transient xs__simpleType skipped */
	/* transient traverse skipped */
	/* transient schemaPtr skipped */
	/* transient schemaPtr skipped */
	/* transient baseLevel skipped */
	return soap_element_end_out(soap, tag);
}

void *xs__simpleType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_xs__simpleType(soap, tag, this, type);
}

SOAP_FMAC3 xs__simpleType * SOAP_FMAC4 soap_in_xs__simpleType(struct soap *soap, const char *tag, xs__simpleType *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (xs__simpleType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xs__simpleType, sizeof(xs__simpleType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_xs__simpleType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (xs__simpleType *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "name", 0), &((xs__simpleType*)a)->name, 0, -1))
		return NULL;
	size_t soap_flag_annotation1 = 1;
	size_t soap_flag_restriction1 = 1;
	size_t soap_flag_list1 = 1;
	size_t soap_flag_union_1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_annotation1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__annotation(soap, "xs:annotation", &(a->xs__simpleType::annotation), "xs:annotation"))
				{	soap_flag_annotation1--;
					continue;
				}
			if (soap_flag_restriction1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__restriction(soap, "xs:restriction", &(a->xs__simpleType::restriction), "xs:restriction"))
				{	soap_flag_restriction1--;
					continue;
				}
			if (soap_flag_list1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__list(soap, "xs:list", &(a->xs__simpleType::list), "xs:list"))
				{	soap_flag_list1--;
					continue;
				}
			if (soap_flag_union_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__union(soap, "xs:union", &(a->xs__simpleType::union_), "xs:union"))
				{	soap_flag_union_1--;
					continue;
				}
			/* non-serializable schemaRef skipped */
			/* non-serializable level skipped */
			/* transient xs__simpleType skipped */
			/* transient traverse skipped */
			/* transient schemaPtr skipped */
			/* transient schemaPtr skipped */
			/* transient baseLevel skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (xs__simpleType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xs__simpleType, 0, sizeof(xs__simpleType), 0, soap_copy_xs__simpleType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int xs__simpleType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xs__simpleType);
	if (this->soap_out(soap, tag?tag:"xs:simpleType", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *xs__simpleType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_xs__simpleType(soap, this, tag, type);
}

SOAP_FMAC3 xs__simpleType * SOAP_FMAC4 soap_get_xs__simpleType(struct soap *soap, xs__simpleType *p, const char *tag, const char *type)
{
	if ((p = soap_in_xs__simpleType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 xs__simpleType * SOAP_FMAC2 soap_instantiate_xs__simpleType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xs__simpleType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xs__simpleType, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(xs__simpleType);
		if (size)
			*size = sizeof(xs__simpleType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(xs__simpleType[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(xs__simpleType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (xs__simpleType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xs__simpleType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xs__simpleType %p -> %p\n", q, p));
	*(xs__simpleType*)p = *(xs__simpleType*)q;
}

void xs__schema::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->xs__schema::targetNamespace = (char*)"";
	soap_default_xsd__string(soap, &this->xs__schema::version);
	this->xs__schema::attributeFormDefault = (enum xs__formChoice)0;
	this->xs__schema::elementFormDefault = (enum xs__formChoice)0;
	this->xs__schema::annotation = NULL;
	soap_default_std__vectorTemplateOfxs__include(soap, &this->xs__schema::include);
	soap_default_std__vectorTemplateOfxs__redefine(soap, &this->xs__schema::redefine);
	soap_default_std__vectorTemplateOfxs__import(soap, &this->xs__schema::import);
	soap_default_std__vectorTemplateOfxs__attribute(soap, &this->xs__schema::attribute);
	soap_default_std__vectorTemplateOfxs__element(soap, &this->xs__schema::element);
	soap_default_std__vectorTemplateOfxs__group(soap, &this->xs__schema::group);
	soap_default_std__vectorTemplateOfxs__attributeGroup(soap, &this->xs__schema::attributeGroup);
	soap_default_std__vectorTemplateOfxs__simpleType(soap, &this->xs__schema::simpleType);
	soap_default_std__vectorTemplateOfxs__complexType(soap, &this->xs__schema::complexType);
	/* transient soap skipped */
	this->xs__schema::updated = (bool)0;
	this->xs__schema::location = NULL;
	this->xs__schema::redirs = 0;
	/* transient builtinTypeSet skipped */
	/* transient builtinElementSet skipped */
	/* transient builtinAttributeSet skipped */
}

void xs__schema::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToxs__annotation(soap, &this->xs__schema::annotation);
	soap_serialize_std__vectorTemplateOfxs__include(soap, &this->xs__schema::include);
	soap_serialize_std__vectorTemplateOfxs__redefine(soap, &this->xs__schema::redefine);
	soap_serialize_std__vectorTemplateOfxs__import(soap, &this->xs__schema::import);
	soap_serialize_std__vectorTemplateOfxs__attribute(soap, &this->xs__schema::attribute);
	soap_serialize_std__vectorTemplateOfxs__element(soap, &this->xs__schema::element);
	soap_serialize_std__vectorTemplateOfxs__group(soap, &this->xs__schema::group);
	soap_serialize_std__vectorTemplateOfxs__attributeGroup(soap, &this->xs__schema::attributeGroup);
	soap_serialize_std__vectorTemplateOfxs__simpleType(soap, &this->xs__schema::simpleType);
	soap_serialize_std__vectorTemplateOfxs__complexType(soap, &this->xs__schema::complexType);
	/* transient soap skipped */
	/* non-serializable updated skipped */
	/* non-serializable location skipped */
	/* non-serializable redirs skipped */
	/* non-serializable builtinTypeSet skipped */
	/* non-serializable builtinElementSet skipped */
	/* non-serializable builtinAttributeSet skipped */
	/* transient xs__schema skipped */
	/* transient xs__schema skipped */
	/* transient xs__schema skipped */
	/* transient ~xs__schema skipped */
	/* transient get skipped */
	/* transient preprocess skipped */
	/* transient insert skipped */
	/* transient traverse skipped */
	/* transient read skipped */
	/* transient sourceLocation skipped */
	/* transient sourceLocation skipped */
	/* transient error skipped */
	/* transient print_fault skipped */
	/* transient builtinType skipped */
	/* transient builtinElement skipped */
	/* transient builtinAttribute skipped */
	/* non-serializable builtinTypes skipped */
	/* non-serializable builtinElements skipped */
	/* non-serializable builtinAttributes skipped */
	/* transient operator<< skipped */
	/* transient operator>> skipped */
}

int xs__schema::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_xs__schema(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xs__schema(struct soap *soap, const char *tag, int id, const xs__schema *a, const char *type)
{
	if (((xs__schema*)a)->targetNamespace)
		soap_set_attr(soap, "targetNamespace", ((xs__schema*)a)->targetNamespace, 1);
	if (((xs__schema*)a)->version)
		soap_set_attr(soap, "version", ((xs__schema*)a)->version, 1);
	soap_set_attr(soap, "attributeFormDefault", soap_xs__formChoice2s(soap, ((xs__schema*)a)->attributeFormDefault), 1);
	soap_set_attr(soap, "elementFormDefault", soap_xs__formChoice2s(soap, ((xs__schema*)a)->elementFormDefault), 1);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xs__schema), type))
		return soap->error;
	if (soap_out_PointerToxs__annotation(soap, "xs:annotation", -1, &(a->xs__schema::annotation), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfxs__include(soap, "xs:include", -1, &(a->xs__schema::include), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfxs__redefine(soap, "xs:redefine", -1, &(a->xs__schema::redefine), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfxs__import(soap, "xs:import", -1, &(a->xs__schema::import), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfxs__attribute(soap, "xs:attribute", -1, &(a->xs__schema::attribute), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfxs__element(soap, "xs:element", -1, &(a->xs__schema::element), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfxs__group(soap, "xs:group", -1, &(a->xs__schema::group), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfxs__attributeGroup(soap, "xs:attributeGroup", -1, &(a->xs__schema::attributeGroup), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfxs__simpleType(soap, "xs:simpleType", -1, &(a->xs__schema::simpleType), ""))
		return soap->error;
	if (soap_out_std__vectorTemplateOfxs__complexType(soap, "xs:complexType", -1, &(a->xs__schema::complexType), ""))
		return soap->error;
	/* transient soap skipped */
	/* non-serializable updated skipped */
	/* non-serializable location skipped */
	/* non-serializable redirs skipped */
	/* non-serializable builtinTypeSet skipped */
	/* non-serializable builtinElementSet skipped */
	/* non-serializable builtinAttributeSet skipped */
	/* transient xs__schema skipped */
	/* transient xs__schema skipped */
	/* transient xs__schema skipped */
	/* transient ~xs__schema skipped */
	/* transient get skipped */
	/* transient preprocess skipped */
	/* transient insert skipped */
	/* transient traverse skipped */
	/* transient read skipped */
	/* transient sourceLocation skipped */
	/* transient sourceLocation skipped */
	/* transient error skipped */
	/* transient print_fault skipped */
	/* transient builtinType skipped */
	/* transient builtinElement skipped */
	/* transient builtinAttribute skipped */
	/* non-serializable builtinTypes skipped */
	/* non-serializable builtinElements skipped */
	/* non-serializable builtinAttributes skipped */
	/* transient operator<< skipped */
	/* transient operator>> skipped */
	return soap_element_end_out(soap, tag);
}

void *xs__schema::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_xs__schema(soap, tag, this, type);
}

SOAP_FMAC3 xs__schema * SOAP_FMAC4 soap_in_xs__schema(struct soap *soap, const char *tag, xs__schema *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (xs__schema *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xs__schema, sizeof(xs__schema), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_xs__schema)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (xs__schema *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "targetNamespace", 0), &((xs__schema*)a)->targetNamespace, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "version", 0), &((xs__schema*)a)->version, 0, -1))
		return NULL;
	if (soap_s2xs__formChoice(soap, soap_attr_value(soap, "attributeFormDefault", 0), &((xs__schema*)a)->attributeFormDefault))
		return NULL;
	if (soap_s2xs__formChoice(soap, soap_attr_value(soap, "elementFormDefault", 0), &((xs__schema*)a)->elementFormDefault))
		return NULL;
	size_t soap_flag_annotation1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_annotation1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxs__annotation(soap, "xs:annotation", &(a->xs__schema::annotation), "xs:annotation"))
				{	soap_flag_annotation1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfxs__include(soap, "xs:include", &(a->xs__schema::include), "xs:include"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfxs__redefine(soap, "xs:redefine", &(a->xs__schema::redefine), "xs:redefine"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfxs__import(soap, "xs:import", &(a->xs__schema::import), "xs:import"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfxs__attribute(soap, "xs:attribute", &(a->xs__schema::attribute), "xs:attribute"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfxs__element(soap, "xs:element", &(a->xs__schema::element), "xs:element"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfxs__group(soap, "xs:group", &(a->xs__schema::group), "xs:group"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfxs__attributeGroup(soap, "xs:attributeGroup", &(a->xs__schema::attributeGroup), "xs:attributeGroup"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfxs__simpleType(soap, "xs:simpleType", &(a->xs__schema::simpleType), "xs:simpleType"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfxs__complexType(soap, "xs:complexType", &(a->xs__schema::complexType), "xs:complexType"))
					continue;
			/* transient soap skipped */
			/* non-serializable updated skipped */
			/* non-serializable location skipped */
			/* non-serializable redirs skipped */
			/* non-serializable builtinTypeSet skipped */
			/* non-serializable builtinElementSet skipped */
			/* non-serializable builtinAttributeSet skipped */
			/* transient xs__schema skipped */
			/* transient xs__schema skipped */
			/* transient xs__schema skipped */
			/* transient ~xs__schema skipped */
			/* transient get skipped */
			/* transient preprocess skipped */
			/* transient insert skipped */
			/* transient traverse skipped */
			/* transient read skipped */
			/* transient sourceLocation skipped */
			/* transient sourceLocation skipped */
			/* transient error skipped */
			/* transient print_fault skipped */
			/* transient builtinType skipped */
			/* transient builtinElement skipped */
			/* transient builtinAttribute skipped */
			/* non-serializable builtinTypes skipped */
			/* non-serializable builtinElements skipped */
			/* non-serializable builtinAttributes skipped */
			/* transient operator<< skipped */
			/* transient operator>> skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->get(soap))
			return NULL;
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (xs__schema *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xs__schema, 0, sizeof(xs__schema), 0, soap_copy_xs__schema);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int xs__schema::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_xs__schema);
	if (this->soap_out(soap, tag?tag:"xs:schema", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *xs__schema::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_xs__schema(soap, this, tag, type);
}

SOAP_FMAC3 xs__schema * SOAP_FMAC4 soap_get_xs__schema(struct soap *soap, xs__schema *p, const char *tag, const char *type)
{
	if ((p = soap_in_xs__schema(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 xs__schema * SOAP_FMAC2 soap_instantiate_xs__schema(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xs__schema(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xs__schema, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(xs__schema);
		if (size)
			*size = sizeof(xs__schema);
		((xs__schema*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(xs__schema[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(xs__schema);
		for (int i = 0; i < n; i++)
			((xs__schema*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (xs__schema*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xs__schema(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xs__schema %p -> %p\n", q, p));
	*(xs__schema*)p = *(xs__schema*)q;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->faultcode);
	soap_default_string(soap, &a->faultstring);
	soap_default_string(soap, &a->faultactor);
	a->detail = NULL;
	a->SOAP_ENV__Code = NULL;
	a->SOAP_ENV__Reason = NULL;
	soap_default_string(soap, &a->SOAP_ENV__Node);
	soap_default_string(soap, &a->SOAP_ENV__Role);
	a->SOAP_ENV__Detail = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->faultcode);
	soap_serialize_string(soap, &a->faultstring);
	soap_serialize_string(soap, &a->faultactor);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->detail);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Code);
	soap_serialize_PointerToSOAP_ENV__Reason(soap, &a->SOAP_ENV__Reason);
	soap_serialize_string(soap, &a->SOAP_ENV__Node);
	soap_serialize_string(soap, &a->SOAP_ENV__Role);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->SOAP_ENV__Detail);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Fault(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Fault *a, const char *type)
{
	const char *soap_tmp_faultcode = soap_QName2s(soap, a->faultcode);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Fault), type))
		return soap->error;
	if (soap_out__QName(soap, "faultcode", -1, (char*const*)&soap_tmp_faultcode, ""))
		return soap->error;
	if (soap_out_string(soap, "faultstring", -1, &a->faultstring, ""))
		return soap->error;
	if (soap_out_string(soap, "faultactor", -1, &a->faultactor, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Detail(soap, "detail", -1, &a->detail, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", -1, &a->SOAP_ENV__Code, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", -1, &a->SOAP_ENV__Reason, ""))
		return soap->error;
	if (soap_out_string(soap, "SOAP-ENV:Node", -1, &a->SOAP_ENV__Node, ""))
		return soap->error;
	if (soap_out_string(soap, "SOAP-ENV:Role", -1, &a->SOAP_ENV__Role, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", -1, &a->SOAP_ENV__Detail, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_in_SOAP_ENV__Fault(struct soap *soap, const char *tag, struct SOAP_ENV__Fault *a, const char *type)
{
	size_t soap_flag_faultcode = 1;
	size_t soap_flag_faultstring = 1;
	size_t soap_flag_faultactor = 1;
	size_t soap_flag_detail = 1;
	size_t soap_flag_SOAP_ENV__Code = 1;
	size_t soap_flag_SOAP_ENV__Reason = 1;
	size_t soap_flag_SOAP_ENV__Node = 1;
	size_t soap_flag_SOAP_ENV__Role = 1;
	size_t soap_flag_SOAP_ENV__Detail = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Fault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Fault(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_faultcode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "faultcode", &a->faultcode, ""))
				{	soap_flag_faultcode--;
					continue;
				}
			if (soap_flag_faultstring && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultstring", &a->faultstring, "xsd:string"))
				{	soap_flag_faultstring--;
					continue;
				}
			if (soap_flag_faultactor && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultactor", &a->faultactor, "xsd:string"))
				{	soap_flag_faultactor--;
					continue;
				}
			if (soap_flag_detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "detail", &a->detail, ""))
				{	soap_flag_detail--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", &a->SOAP_ENV__Code, ""))
				{	soap_flag_SOAP_ENV__Code--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Reason && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", &a->SOAP_ENV__Reason, ""))
				{	soap_flag_SOAP_ENV__Reason--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Node && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Node", &a->SOAP_ENV__Node, "xsd:string"))
				{	soap_flag_SOAP_ENV__Node--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Role", &a->SOAP_ENV__Role, "xsd:string"))
				{	soap_flag_SOAP_ENV__Role--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", &a->SOAP_ENV__Detail, ""))
				{	soap_flag_SOAP_ENV__Detail--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Fault *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Fault, 0, sizeof(struct SOAP_ENV__Fault), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Fault);
	if (soap_out_SOAP_ENV__Fault(soap, tag?tag:"SOAP-ENV:Fault", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_get_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Fault(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct SOAP_ENV__Fault * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Fault(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Fault(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Fault, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Fault);
		if (size)
			*size = sizeof(struct SOAP_ENV__Fault);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Fault[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Fault);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Fault*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Fault(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Fault %p -> %p\n", q, p));
	*(struct SOAP_ENV__Fault*)p = *(struct SOAP_ENV__Fault*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Reason(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Reason *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Reason), type))
		return soap->error;
	if (soap->lang)
		soap_set_attr(soap, "xml:lang", soap->lang, 1);
	if (soap_out_string(soap, "SOAP-ENV:Text", -1, &a->SOAP_ENV__Text, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_in_SOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason *a, const char *type)
{
	size_t soap_flag_SOAP_ENV__Text = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Reason *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Reason(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Text && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Text", &a->SOAP_ENV__Text, "xsd:string"))
				{	soap_flag_SOAP_ENV__Text--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Reason, 0, sizeof(struct SOAP_ENV__Reason), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Reason);
	if (soap_out_SOAP_ENV__Reason(soap, tag?tag:"SOAP-ENV:Reason", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_get_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Reason(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct SOAP_ENV__Reason * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Reason(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Reason(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Reason, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Reason);
		if (size)
			*size = sizeof(struct SOAP_ENV__Reason);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Reason[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Reason);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Reason*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Reason(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Reason %p -> %p\n", q, p));
	*(struct SOAP_ENV__Reason*)p = *(struct SOAP_ENV__Reason*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__any = NULL;
	a->__type = 0;
	a->fault = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_markelement(soap, a->fault, a->__type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Detail(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Detail *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Detail), type))
		return soap->error;
	soap_outliteral(soap, "-any", &a->__any, NULL);
	if (soap_putelement(soap, a->fault, "fault", -1, a->__type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_in_SOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail *a, const char *type)
{
	size_t soap_flag___any = 1;
	size_t soap_flag_fault = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Detail *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Detail(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault && soap->error == SOAP_TAG_MISMATCH)
				if ((a->fault = soap_getelement(soap, &a->__type)))
				{	soap_flag_fault = 0;
					continue;
				}
			if (soap_flag___any && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &a->__any))
				{	soap_flag___any--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Detail, 0, sizeof(struct SOAP_ENV__Detail), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Detail);
	if (soap_out_SOAP_ENV__Detail(soap, tag?tag:"SOAP-ENV:Detail", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_get_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Detail(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct SOAP_ENV__Detail * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Detail(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Detail(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Detail, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Detail);
		if (size)
			*size = sizeof(struct SOAP_ENV__Detail);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Detail[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Detail);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Detail*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Detail(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Detail %p -> %p\n", q, p));
	*(struct SOAP_ENV__Detail*)p = *(struct SOAP_ENV__Detail*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->SOAP_ENV__Value);
	a->SOAP_ENV__Subcode = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->SOAP_ENV__Value);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Subcode);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Code(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Code *a, const char *type)
{
	const char *soap_tmp_SOAP_ENV__Value = soap_QName2s(soap, a->SOAP_ENV__Value);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Code), type))
		return soap->error;
	if (soap_out__QName(soap, "SOAP-ENV:Value", -1, (char*const*)&soap_tmp_SOAP_ENV__Value, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", -1, &a->SOAP_ENV__Subcode, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_in_SOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code *a, const char *type)
{
	size_t soap_flag_SOAP_ENV__Value = 1;
	size_t soap_flag_SOAP_ENV__Subcode = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Code *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Code(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "SOAP-ENV:Value", &a->SOAP_ENV__Value, ""))
				{	soap_flag_SOAP_ENV__Value--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Subcode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", &a->SOAP_ENV__Subcode, ""))
				{	soap_flag_SOAP_ENV__Subcode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Code, 0, sizeof(struct SOAP_ENV__Code), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Code);
	if (soap_out_SOAP_ENV__Code(soap, tag?tag:"SOAP-ENV:Code", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_get_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Code(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct SOAP_ENV__Code * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Code(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Code(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Code, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Code);
		if (size)
			*size = sizeof(struct SOAP_ENV__Code);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Code[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Code);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Code*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Code(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Code %p -> %p\n", q, p));
	*(struct SOAP_ENV__Code*)p = *(struct SOAP_ENV__Code*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Header(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Header *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Header), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_in_SOAP_ENV__Header(struct soap *soap, const char *tag, struct SOAP_ENV__Header *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Header *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Header(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Header *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Header, 0, sizeof(struct SOAP_ENV__Header), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Header);
	if (soap_out_SOAP_ENV__Header(soap, tag?tag:"SOAP-ENV:Header", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_get_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Header(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct SOAP_ENV__Header * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Header(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Header(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Header, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Header);
		if (size)
			*size = sizeof(struct SOAP_ENV__Header);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Header[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Header);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Header*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Header(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Header %p -> %p\n", q, p));
	*(struct SOAP_ENV__Header*)p = *(struct SOAP_ENV__Header*)q;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xs__union_content(struct soap *soap, int choice, const union xs__union_content *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	switch (choice)
	{
	case SOAP_UNION_xs__union_content_element:
		soap_serialize_PointerToxs__element(soap, &a->element);
		break;
	case SOAP_UNION_xs__union_content_group:
		soap_serialize_PointerToxs__group(soap, &a->group);
		break;
	case SOAP_UNION_xs__union_content_choice:
		soap_serialize_PointerToxs__seqchoice(soap, &a->choice);
		break;
	case SOAP_UNION_xs__union_content_sequence:
		soap_serialize_PointerToxs__seqchoice(soap, &a->sequence);
		break;
	case SOAP_UNION_xs__union_content_any:
		soap_serialize_PointerToxs__any(soap, &a->any);
		break;
	default:
		break;
	}
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xs__union_content(struct soap *soap, int choice, const union xs__union_content *a)
{
	switch (choice)
	{
	case SOAP_UNION_xs__union_content_element:
		return soap_out_PointerToxs__element(soap, "xs:element", -1, &a->element, "");
	case SOAP_UNION_xs__union_content_group:
		return soap_out_PointerToxs__group(soap, "xs:group", -1, &a->group, "");
	case SOAP_UNION_xs__union_content_choice:
		return soap_out_PointerToxs__seqchoice(soap, "xs:choice", -1, &a->choice, "");
	case SOAP_UNION_xs__union_content_sequence:
		return soap_out_PointerToxs__seqchoice(soap, "xs:sequence", -1, &a->sequence, "");
	case SOAP_UNION_xs__union_content_any:
		return soap_out_PointerToxs__any(soap, "xs:any", -1, &a->any, "");
	default:
		break;
	}
	return SOAP_OK;
}

SOAP_FMAC3 union xs__union_content * SOAP_FMAC4 soap_in_xs__union_content(struct soap *soap, int *choice, union xs__union_content *a)
{	soap->error = SOAP_TAG_MISMATCH;
	a->element = NULL;
	if (soap->error == SOAP_TAG_MISMATCH && soap_in_PointerToxs__element(soap, "xs:element", &a->element, "xs:element"))
	{	*choice = SOAP_UNION_xs__union_content_element;
		return a;
	}
	a->group = NULL;
	if (soap->error == SOAP_TAG_MISMATCH && soap_in_PointerToxs__group(soap, "xs:group", &a->group, "xs:group"))
	{	*choice = SOAP_UNION_xs__union_content_group;
		return a;
	}
	a->choice = NULL;
	if (soap->error == SOAP_TAG_MISMATCH && soap_in_PointerToxs__seqchoice(soap, "xs:choice", &a->choice, "xs:seqchoice"))
	{	*choice = SOAP_UNION_xs__union_content_choice;
		return a;
	}
	a->sequence = NULL;
	if (soap->error == SOAP_TAG_MISMATCH && soap_in_PointerToxs__seqchoice(soap, "xs:sequence", &a->sequence, "xs:seqchoice"))
	{	*choice = SOAP_UNION_xs__union_content_sequence;
		return a;
	}
	a->any = NULL;
	if (soap->error == SOAP_TAG_MISMATCH && soap_in_PointerToxs__any(soap, "xs:any", &a->any, "xs:any"))
	{	*choice = SOAP_UNION_xs__union_content_any;
		return a;
	}
	*choice = 0;
	if (!soap->error)
		soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Reason))
		soap_serialize_SOAP_ENV__Reason(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Reason *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Reason);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Reason(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Reason **)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Reason(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Reason);
	if (soap_out_PointerToSOAP_ENV__Reason(soap, tag?tag:"SOAP-ENV:Reason", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Reason(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Detail))
		soap_serialize_SOAP_ENV__Detail(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Detail *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Detail);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Detail(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Detail **)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Detail(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Detail);
	if (soap_out_PointerToSOAP_ENV__Detail(soap, tag?tag:"SOAP-ENV:Detail", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Detail(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Code))
		soap_serialize_SOAP_ENV__Code(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Code *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Code);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Code(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Code **)soap_malloc(soap, sizeof(struct SOAP_ENV__Code *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Code(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Code);
	if (soap_out_PointerToSOAP_ENV__Code(soap, tag?tag:"SOAP-ENV:Code", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Code(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsdl__types(struct soap *soap, wsdl__types *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsdl__types))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsdl__types(struct soap *soap, const char *tag, int id, wsdl__types *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsdl__types);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 wsdl__types ** SOAP_FMAC4 soap_in_PointerTowsdl__types(struct soap *soap, const char *tag, wsdl__types **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (wsdl__types **)soap_malloc(soap, sizeof(wsdl__types *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (wsdl__types *)soap_instantiate_wsdl__types(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	wsdl__types ** p = (wsdl__types **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsdl__types, sizeof(wsdl__types), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsdl__types(struct soap *soap, wsdl__types *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsdl__types);
	if (soap_out_PointerTowsdl__types(soap, tag?tag:"wsdl:types", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 wsdl__types ** SOAP_FMAC4 soap_get_PointerTowsdl__types(struct soap *soap, wsdl__types **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsdl__types(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsdl__binding(struct soap *soap, wsdl__binding *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsdl__binding))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsdl__binding(struct soap *soap, const char *tag, int id, wsdl__binding *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsdl__binding);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 wsdl__binding ** SOAP_FMAC4 soap_in_PointerTowsdl__binding(struct soap *soap, const char *tag, wsdl__binding **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (wsdl__binding **)soap_malloc(soap, sizeof(wsdl__binding *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (wsdl__binding *)soap_instantiate_wsdl__binding(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	wsdl__binding ** p = (wsdl__binding **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsdl__binding, sizeof(wsdl__binding), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsdl__binding(struct soap *soap, wsdl__binding *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsdl__binding);
	if (soap_out_PointerTowsdl__binding(soap, tag?tag:"wsdl:binding", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 wsdl__binding ** SOAP_FMAC4 soap_get_PointerTowsdl__binding(struct soap *soap, wsdl__binding **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsdl__binding(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTohttp__address(struct soap *soap, http__address *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_http__address))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTohttp__address(struct soap *soap, const char *tag, int id, http__address *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_http__address);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 http__address ** SOAP_FMAC4 soap_in_PointerTohttp__address(struct soap *soap, const char *tag, http__address **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (http__address **)soap_malloc(soap, sizeof(http__address *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (http__address *)soap_instantiate_http__address(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	http__address ** p = (http__address **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_http__address, sizeof(http__address), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTohttp__address(struct soap *soap, http__address *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTohttp__address);
	if (soap_out_PointerTohttp__address(soap, tag?tag:"http:address", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 http__address ** SOAP_FMAC4 soap_get_PointerTohttp__address(struct soap *soap, http__address **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTohttp__address(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTosoap__address(struct soap *soap, soap__address *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_soap__address))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTosoap__address(struct soap *soap, const char *tag, int id, soap__address *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_soap__address);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 soap__address ** SOAP_FMAC4 soap_in_PointerTosoap__address(struct soap *soap, const char *tag, soap__address **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (soap__address **)soap_malloc(soap, sizeof(soap__address *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (soap__address *)soap_instantiate_soap__address(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	soap__address ** p = (soap__address **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_soap__address, sizeof(soap__address), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTosoap__address(struct soap *soap, soap__address *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTosoap__address);
	if (soap_out_PointerTosoap__address(soap, tag?tag:"soap:address", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 soap__address ** SOAP_FMAC4 soap_get_PointerTosoap__address(struct soap *soap, soap__address **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTosoap__address(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsdl__portType(struct soap *soap, wsdl__portType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsdl__portType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsdl__portType(struct soap *soap, const char *tag, int id, wsdl__portType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsdl__portType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 wsdl__portType ** SOAP_FMAC4 soap_in_PointerTowsdl__portType(struct soap *soap, const char *tag, wsdl__portType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (wsdl__portType **)soap_malloc(soap, sizeof(wsdl__portType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (wsdl__portType *)soap_instantiate_wsdl__portType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	wsdl__portType ** p = (wsdl__portType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsdl__portType, sizeof(wsdl__portType), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsdl__portType(struct soap *soap, wsdl__portType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsdl__portType);
	if (soap_out_PointerTowsdl__portType(soap, tag?tag:"wsdl:portType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 wsdl__portType ** SOAP_FMAC4 soap_get_PointerTowsdl__portType(struct soap *soap, wsdl__portType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsdl__portType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTohttp__binding(struct soap *soap, http__binding *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_http__binding))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTohttp__binding(struct soap *soap, const char *tag, int id, http__binding *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_http__binding);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 http__binding ** SOAP_FMAC4 soap_in_PointerTohttp__binding(struct soap *soap, const char *tag, http__binding **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (http__binding **)soap_malloc(soap, sizeof(http__binding *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (http__binding *)soap_instantiate_http__binding(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	http__binding ** p = (http__binding **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_http__binding, sizeof(http__binding), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTohttp__binding(struct soap *soap, http__binding *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTohttp__binding);
	if (soap_out_PointerTohttp__binding(soap, tag?tag:"http:binding", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 http__binding ** SOAP_FMAC4 soap_get_PointerTohttp__binding(struct soap *soap, http__binding **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTohttp__binding(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTosoap__binding(struct soap *soap, soap__binding *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_soap__binding))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTosoap__binding(struct soap *soap, const char *tag, int id, soap__binding *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_soap__binding);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 soap__binding ** SOAP_FMAC4 soap_in_PointerTosoap__binding(struct soap *soap, const char *tag, soap__binding **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (soap__binding **)soap_malloc(soap, sizeof(soap__binding *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (soap__binding *)soap_instantiate_soap__binding(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	soap__binding ** p = (soap__binding **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_soap__binding, sizeof(soap__binding), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTosoap__binding(struct soap *soap, soap__binding *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTosoap__binding);
	if (soap_out_PointerTosoap__binding(soap, tag?tag:"soap:binding", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 soap__binding ** SOAP_FMAC4 soap_get_PointerTosoap__binding(struct soap *soap, soap__binding **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTosoap__binding(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsdl__ext_output(struct soap *soap, wsdl__ext_output *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsdl__ext_output))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsdl__ext_output(struct soap *soap, const char *tag, int id, wsdl__ext_output *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsdl__ext_output);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 wsdl__ext_output ** SOAP_FMAC4 soap_in_PointerTowsdl__ext_output(struct soap *soap, const char *tag, wsdl__ext_output **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (wsdl__ext_output **)soap_malloc(soap, sizeof(wsdl__ext_output *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (wsdl__ext_output *)soap_instantiate_wsdl__ext_output(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	wsdl__ext_output ** p = (wsdl__ext_output **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsdl__ext_output, sizeof(wsdl__ext_output), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsdl__ext_output(struct soap *soap, wsdl__ext_output *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsdl__ext_output);
	if (soap_out_PointerTowsdl__ext_output(soap, tag?tag:"wsdl:ext-output", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 wsdl__ext_output ** SOAP_FMAC4 soap_get_PointerTowsdl__ext_output(struct soap *soap, wsdl__ext_output **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsdl__ext_output(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsdl__ext_input(struct soap *soap, wsdl__ext_input *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsdl__ext_input))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsdl__ext_input(struct soap *soap, const char *tag, int id, wsdl__ext_input *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsdl__ext_input);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 wsdl__ext_input ** SOAP_FMAC4 soap_in_PointerTowsdl__ext_input(struct soap *soap, const char *tag, wsdl__ext_input **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (wsdl__ext_input **)soap_malloc(soap, sizeof(wsdl__ext_input *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (wsdl__ext_input *)soap_instantiate_wsdl__ext_input(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	wsdl__ext_input ** p = (wsdl__ext_input **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsdl__ext_input, sizeof(wsdl__ext_input), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsdl__ext_input(struct soap *soap, wsdl__ext_input *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsdl__ext_input);
	if (soap_out_PointerTowsdl__ext_input(soap, tag?tag:"wsdl:ext-input", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 wsdl__ext_input ** SOAP_FMAC4 soap_get_PointerTowsdl__ext_input(struct soap *soap, wsdl__ext_input **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsdl__ext_input(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTohttp__operation(struct soap *soap, http__operation *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_http__operation))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTohttp__operation(struct soap *soap, const char *tag, int id, http__operation *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_http__operation);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 http__operation ** SOAP_FMAC4 soap_in_PointerTohttp__operation(struct soap *soap, const char *tag, http__operation **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (http__operation **)soap_malloc(soap, sizeof(http__operation *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (http__operation *)soap_instantiate_http__operation(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	http__operation ** p = (http__operation **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_http__operation, sizeof(http__operation), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTohttp__operation(struct soap *soap, http__operation *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTohttp__operation);
	if (soap_out_PointerTohttp__operation(soap, tag?tag:"http:operation", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 http__operation ** SOAP_FMAC4 soap_get_PointerTohttp__operation(struct soap *soap, http__operation **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTohttp__operation(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTosoap__operation(struct soap *soap, soap__operation *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_soap__operation))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTosoap__operation(struct soap *soap, const char *tag, int id, soap__operation *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_soap__operation);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 soap__operation ** SOAP_FMAC4 soap_in_PointerTosoap__operation(struct soap *soap, const char *tag, soap__operation **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (soap__operation **)soap_malloc(soap, sizeof(soap__operation *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (soap__operation *)soap_instantiate_soap__operation(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	soap__operation ** p = (soap__operation **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_soap__operation, sizeof(soap__operation), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTosoap__operation(struct soap *soap, soap__operation *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTosoap__operation);
	if (soap_out_PointerTosoap__operation(soap, tag?tag:"soap:operation", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 soap__operation ** SOAP_FMAC4 soap_get_PointerTosoap__operation(struct soap *soap, soap__operation **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTosoap__operation(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTosoap__fault(struct soap *soap, soap__fault *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_soap__fault))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTosoap__fault(struct soap *soap, const char *tag, int id, soap__fault *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_soap__fault);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 soap__fault ** SOAP_FMAC4 soap_in_PointerTosoap__fault(struct soap *soap, const char *tag, soap__fault **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (soap__fault **)soap_malloc(soap, sizeof(soap__fault *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (soap__fault *)soap_instantiate_soap__fault(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	soap__fault ** p = (soap__fault **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_soap__fault, sizeof(soap__fault), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTosoap__fault(struct soap *soap, soap__fault *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTosoap__fault);
	if (soap_out_PointerTosoap__fault(soap, tag?tag:"soap:fault", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 soap__fault ** SOAP_FMAC4 soap_get_PointerTosoap__fault(struct soap *soap, soap__fault **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTosoap__fault(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTomime__mimeXml(struct soap *soap, mime__mimeXml *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_mime__mimeXml))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTomime__mimeXml(struct soap *soap, const char *tag, int id, mime__mimeXml *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_mime__mimeXml);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 mime__mimeXml ** SOAP_FMAC4 soap_in_PointerTomime__mimeXml(struct soap *soap, const char *tag, mime__mimeXml **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (mime__mimeXml **)soap_malloc(soap, sizeof(mime__mimeXml *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (mime__mimeXml *)soap_instantiate_mime__mimeXml(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	mime__mimeXml ** p = (mime__mimeXml **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_mime__mimeXml, sizeof(mime__mimeXml), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTomime__mimeXml(struct soap *soap, mime__mimeXml *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTomime__mimeXml);
	if (soap_out_PointerTomime__mimeXml(soap, tag?tag:"mime:mimeXml", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 mime__mimeXml ** SOAP_FMAC4 soap_get_PointerTomime__mimeXml(struct soap *soap, mime__mimeXml **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTomime__mimeXml(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTomime__content(struct soap *soap, mime__content *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_mime__content))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTomime__content(struct soap *soap, const char *tag, int id, mime__content *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_mime__content);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 mime__content ** SOAP_FMAC4 soap_in_PointerTomime__content(struct soap *soap, const char *tag, mime__content **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (mime__content **)soap_malloc(soap, sizeof(mime__content *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (mime__content *)soap_instantiate_mime__content(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	mime__content ** p = (mime__content **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_mime__content, sizeof(mime__content), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTomime__content(struct soap *soap, mime__content *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTomime__content);
	if (soap_out_PointerTomime__content(soap, tag?tag:"mime:content", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 mime__content ** SOAP_FMAC4 soap_get_PointerTomime__content(struct soap *soap, mime__content **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTomime__content(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTomime__multipartRelated(struct soap *soap, mime__multipartRelated *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_mime__multipartRelated))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTomime__multipartRelated(struct soap *soap, const char *tag, int id, mime__multipartRelated *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_mime__multipartRelated);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 mime__multipartRelated ** SOAP_FMAC4 soap_in_PointerTomime__multipartRelated(struct soap *soap, const char *tag, mime__multipartRelated **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (mime__multipartRelated **)soap_malloc(soap, sizeof(mime__multipartRelated *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (mime__multipartRelated *)soap_instantiate_mime__multipartRelated(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	mime__multipartRelated ** p = (mime__multipartRelated **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_mime__multipartRelated, sizeof(mime__multipartRelated), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTomime__multipartRelated(struct soap *soap, mime__multipartRelated *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTomime__multipartRelated);
	if (soap_out_PointerTomime__multipartRelated(soap, tag?tag:"mime:multipartRelated", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 mime__multipartRelated ** SOAP_FMAC4 soap_get_PointerTomime__multipartRelated(struct soap *soap, mime__multipartRelated **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTomime__multipartRelated(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTodime__message(struct soap *soap, dime__message *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_dime__message))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTodime__message(struct soap *soap, const char *tag, int id, dime__message *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_dime__message);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 dime__message ** SOAP_FMAC4 soap_in_PointerTodime__message(struct soap *soap, const char *tag, dime__message **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (dime__message **)soap_malloc(soap, sizeof(dime__message *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (dime__message *)soap_instantiate_dime__message(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	dime__message ** p = (dime__message **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_dime__message, sizeof(dime__message), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTodime__message(struct soap *soap, dime__message *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTodime__message);
	if (soap_out_PointerTodime__message(soap, tag?tag:"dime:message", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 dime__message ** SOAP_FMAC4 soap_get_PointerTodime__message(struct soap *soap, dime__message **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTodime__message(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsdl__output(struct soap *soap, wsdl__output *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsdl__output))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsdl__output(struct soap *soap, const char *tag, int id, wsdl__output *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsdl__output);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 wsdl__output ** SOAP_FMAC4 soap_in_PointerTowsdl__output(struct soap *soap, const char *tag, wsdl__output **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (wsdl__output **)soap_malloc(soap, sizeof(wsdl__output *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (wsdl__output *)soap_instantiate_wsdl__output(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	wsdl__output ** p = (wsdl__output **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsdl__output, sizeof(wsdl__output), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsdl__output(struct soap *soap, wsdl__output *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsdl__output);
	if (soap_out_PointerTowsdl__output(soap, tag?tag:"wsdl:output", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 wsdl__output ** SOAP_FMAC4 soap_get_PointerTowsdl__output(struct soap *soap, wsdl__output **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsdl__output(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsdl__input(struct soap *soap, wsdl__input *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsdl__input))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsdl__input(struct soap *soap, const char *tag, int id, wsdl__input *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsdl__input);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 wsdl__input ** SOAP_FMAC4 soap_in_PointerTowsdl__input(struct soap *soap, const char *tag, wsdl__input **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (wsdl__input **)soap_malloc(soap, sizeof(wsdl__input *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (wsdl__input *)soap_instantiate_wsdl__input(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	wsdl__input ** p = (wsdl__input **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsdl__input, sizeof(wsdl__input), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsdl__input(struct soap *soap, wsdl__input *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsdl__input);
	if (soap_out_PointerTowsdl__input(soap, tag?tag:"wsdl:input", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 wsdl__input ** SOAP_FMAC4 soap_get_PointerTowsdl__input(struct soap *soap, wsdl__input **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsdl__input(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsdl__definitions(struct soap *soap, wsdl__definitions *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsdl__definitions))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsdl__definitions(struct soap *soap, const char *tag, int id, wsdl__definitions *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsdl__definitions);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 wsdl__definitions ** SOAP_FMAC4 soap_in_PointerTowsdl__definitions(struct soap *soap, const char *tag, wsdl__definitions **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (wsdl__definitions **)soap_malloc(soap, sizeof(wsdl__definitions *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (wsdl__definitions *)soap_instantiate_wsdl__definitions(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	wsdl__definitions ** p = (wsdl__definitions **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsdl__definitions, sizeof(wsdl__definitions), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsdl__definitions(struct soap *soap, wsdl__definitions *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsdl__definitions);
	if (soap_out_PointerTowsdl__definitions(soap, tag?tag:"wsdl:definitions", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 wsdl__definitions ** SOAP_FMAC4 soap_get_PointerTowsdl__definitions(struct soap *soap, wsdl__definitions **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsdl__definitions(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsp__AppliesTo(struct soap *soap, wsp__AppliesTo *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsp__AppliesTo))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsp__AppliesTo(struct soap *soap, const char *tag, int id, wsp__AppliesTo *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsp__AppliesTo);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 wsp__AppliesTo ** SOAP_FMAC4 soap_in_PointerTowsp__AppliesTo(struct soap *soap, const char *tag, wsp__AppliesTo **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (wsp__AppliesTo **)soap_malloc(soap, sizeof(wsp__AppliesTo *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (wsp__AppliesTo *)soap_instantiate_wsp__AppliesTo(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	wsp__AppliesTo ** p = (wsp__AppliesTo **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsp__AppliesTo, sizeof(wsp__AppliesTo), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsp__AppliesTo(struct soap *soap, wsp__AppliesTo *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsp__AppliesTo);
	if (soap_out_PointerTowsp__AppliesTo(soap, tag?tag:"wsp:AppliesTo", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 wsp__AppliesTo ** SOAP_FMAC4 soap_get_PointerTowsp__AppliesTo(struct soap *soap, wsp__AppliesTo **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsp__AppliesTo(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsrmp__RMAssertion(struct soap *soap, wsrmp__RMAssertion *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsrmp__RMAssertion))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsrmp__RMAssertion(struct soap *soap, const char *tag, int id, wsrmp__RMAssertion *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsrmp__RMAssertion);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 wsrmp__RMAssertion ** SOAP_FMAC4 soap_in_PointerTowsrmp__RMAssertion(struct soap *soap, const char *tag, wsrmp__RMAssertion **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (wsrmp__RMAssertion **)soap_malloc(soap, sizeof(wsrmp__RMAssertion *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (wsrmp__RMAssertion *)soap_instantiate_wsrmp__RMAssertion(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	wsrmp__RMAssertion ** p = (wsrmp__RMAssertion **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsrmp__RMAssertion, sizeof(wsrmp__RMAssertion), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsrmp__RMAssertion(struct soap *soap, wsrmp__RMAssertion *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsrmp__RMAssertion);
	if (soap_out_PointerTowsrmp__RMAssertion(soap, tag?tag:"wsrmp:RMAssertion", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 wsrmp__RMAssertion ** SOAP_FMAC4 soap_get_PointerTowsrmp__RMAssertion(struct soap *soap, wsrmp__RMAssertion **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsrmp__RMAssertion(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsp__Assertion(struct soap *soap, wsp__Assertion *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsp__Assertion))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsp__Assertion(struct soap *soap, const char *tag, int id, wsp__Assertion *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsp__Assertion);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 wsp__Assertion ** SOAP_FMAC4 soap_in_PointerTowsp__Assertion(struct soap *soap, const char *tag, wsp__Assertion **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (wsp__Assertion **)soap_malloc(soap, sizeof(wsp__Assertion *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (wsp__Assertion *)soap_instantiate_wsp__Assertion(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	wsp__Assertion ** p = (wsp__Assertion **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsp__Assertion, sizeof(wsp__Assertion), 0);
		if (!p && soap->error == SOAP_HREF)
		{	soap->error = SOAP_OK;
			p = (wsp__Assertion **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_sp__Token, sizeof(sp__Token), 0);
		}
		if (!p && soap->error == SOAP_HREF)
		{	soap->error = SOAP_OK;
			p = (wsp__Assertion **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsrmp__RMAssertion, sizeof(wsrmp__RMAssertion), 0);
		}
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsp__Assertion(struct soap *soap, wsp__Assertion *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsp__Assertion);
	if (soap_out_PointerTowsp__Assertion(soap, tag?tag:"wsp:Assertion", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 wsp__Assertion ** SOAP_FMAC4 soap_get_PointerTowsp__Assertion(struct soap *soap, wsp__Assertion **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsp__Assertion(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTosp__Token(struct soap *soap, sp__Token *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_sp__Token))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTosp__Token(struct soap *soap, const char *tag, int id, sp__Token *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_sp__Token);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 sp__Token ** SOAP_FMAC4 soap_in_PointerTosp__Token(struct soap *soap, const char *tag, sp__Token **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (sp__Token **)soap_malloc(soap, sizeof(sp__Token *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (sp__Token *)soap_instantiate_sp__Token(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	sp__Token ** p = (sp__Token **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_sp__Token, sizeof(sp__Token), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTosp__Token(struct soap *soap, sp__Token *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTosp__Token);
	if (soap_out_PointerTosp__Token(soap, tag?tag:"sp:Token", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 sp__Token ** SOAP_FMAC4 soap_get_PointerTosp__Token(struct soap *soap, sp__Token **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTosp__Token(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTosp__Elements(struct soap *soap, sp__Elements *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_sp__Elements))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTosp__Elements(struct soap *soap, const char *tag, int id, sp__Elements *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_sp__Elements);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 sp__Elements ** SOAP_FMAC4 soap_in_PointerTosp__Elements(struct soap *soap, const char *tag, sp__Elements **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (sp__Elements **)soap_malloc(soap, sizeof(sp__Elements *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (sp__Elements *)soap_instantiate_sp__Elements(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	sp__Elements ** p = (sp__Elements **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_sp__Elements, sizeof(sp__Elements), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTosp__Elements(struct soap *soap, sp__Elements *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTosp__Elements);
	if (soap_out_PointerTosp__Elements(soap, tag?tag:"sp:Elements", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 sp__Elements ** SOAP_FMAC4 soap_get_PointerTosp__Elements(struct soap *soap, sp__Elements **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTosp__Elements(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsp__PolicyReference(struct soap *soap, wsp__PolicyReference *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsp__PolicyReference))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsp__PolicyReference(struct soap *soap, const char *tag, int id, wsp__PolicyReference *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsp__PolicyReference);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 wsp__PolicyReference ** SOAP_FMAC4 soap_in_PointerTowsp__PolicyReference(struct soap *soap, const char *tag, wsp__PolicyReference **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (wsp__PolicyReference **)soap_malloc(soap, sizeof(wsp__PolicyReference *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (wsp__PolicyReference *)soap_instantiate_wsp__PolicyReference(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	wsp__PolicyReference ** p = (wsp__PolicyReference **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsp__PolicyReference, sizeof(wsp__PolicyReference), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsp__PolicyReference(struct soap *soap, wsp__PolicyReference *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsp__PolicyReference);
	if (soap_out_PointerTowsp__PolicyReference(soap, tag?tag:"wsp:PolicyReference", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 wsp__PolicyReference ** SOAP_FMAC4 soap_get_PointerTowsp__PolicyReference(struct soap *soap, wsp__PolicyReference **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsp__PolicyReference(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowst__Claims(struct soap *soap, wst__Claims *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wst__Claims))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowst__Claims(struct soap *soap, const char *tag, int id, wst__Claims *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wst__Claims);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 wst__Claims ** SOAP_FMAC4 soap_in_PointerTowst__Claims(struct soap *soap, const char *tag, wst__Claims **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (wst__Claims **)soap_malloc(soap, sizeof(wst__Claims *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (wst__Claims *)soap_instantiate_wst__Claims(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	wst__Claims ** p = (wst__Claims **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wst__Claims, sizeof(wst__Claims), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowst__Claims(struct soap *soap, wst__Claims *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowst__Claims);
	if (soap_out_PointerTowst__Claims(soap, tag?tag:"wst:Claims", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 wst__Claims ** SOAP_FMAC4 soap_get_PointerTowst__Claims(struct soap *soap, wst__Claims **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowst__Claims(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsa__EndpointReferenceType(struct soap *soap, wsa__EndpointReferenceType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsa__EndpointReferenceType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsa__EndpointReferenceType(struct soap *soap, const char *tag, int id, wsa__EndpointReferenceType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsa__EndpointReferenceType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 wsa__EndpointReferenceType ** SOAP_FMAC4 soap_in_PointerTowsa__EndpointReferenceType(struct soap *soap, const char *tag, wsa__EndpointReferenceType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (wsa__EndpointReferenceType **)soap_malloc(soap, sizeof(wsa__EndpointReferenceType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (wsa__EndpointReferenceType *)soap_instantiate_wsa__EndpointReferenceType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	wsa__EndpointReferenceType ** p = (wsa__EndpointReferenceType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsa__EndpointReferenceType, sizeof(wsa__EndpointReferenceType), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsa__EndpointReferenceType(struct soap *soap, wsa__EndpointReferenceType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsa__EndpointReferenceType);
	if (soap_out_PointerTowsa__EndpointReferenceType(soap, tag?tag:"wsa:EndpointReferenceType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 wsa__EndpointReferenceType ** SOAP_FMAC4 soap_get_PointerTowsa__EndpointReferenceType(struct soap *soap, wsa__EndpointReferenceType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsa__EndpointReferenceType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsp__Content(struct soap *soap, wsp__Content *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsp__Content))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsp__Content(struct soap *soap, const char *tag, int id, wsp__Content *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsp__Content);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 wsp__Content ** SOAP_FMAC4 soap_in_PointerTowsp__Content(struct soap *soap, const char *tag, wsp__Content **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (wsp__Content **)soap_malloc(soap, sizeof(wsp__Content *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (wsp__Content *)soap_instantiate_wsp__Content(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	wsp__Content ** p = (wsp__Content **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsp__Content, sizeof(wsp__Content), 0);
		if (!p && soap->error == SOAP_HREF)
		{	soap->error = SOAP_OK;
			p = (wsp__Content **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsp__Policy, sizeof(wsp__Policy), 0);
		}
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsp__Content(struct soap *soap, wsp__Content *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsp__Content);
	if (soap_out_PointerTowsp__Content(soap, tag?tag:"wsp:Content", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 wsp__Content ** SOAP_FMAC4 soap_get_PointerTowsp__Content(struct soap *soap, wsp__Content **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsp__Content(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsp__Policy(struct soap *soap, wsp__Policy *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsp__Policy))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsp__Policy(struct soap *soap, const char *tag, int id, wsp__Policy *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsp__Policy);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 wsp__Policy ** SOAP_FMAC4 soap_in_PointerTowsp__Policy(struct soap *soap, const char *tag, wsp__Policy **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (wsp__Policy **)soap_malloc(soap, sizeof(wsp__Policy *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (wsp__Policy *)soap_instantiate_wsp__Policy(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	wsp__Policy ** p = (wsp__Policy **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsp__Policy, sizeof(wsp__Policy), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsp__Policy(struct soap *soap, wsp__Policy *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsp__Policy);
	if (soap_out_PointerTowsp__Policy(soap, tag?tag:"wsp:Policy", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 wsp__Policy ** SOAP_FMAC4 soap_get_PointerTowsp__Policy(struct soap *soap, wsp__Policy **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsp__Policy(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTosd__staticServiceDataValues(struct soap *soap, sd__staticServiceDataValues *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_sd__staticServiceDataValues))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTosd__staticServiceDataValues(struct soap *soap, const char *tag, int id, sd__staticServiceDataValues *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_sd__staticServiceDataValues);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 sd__staticServiceDataValues ** SOAP_FMAC4 soap_in_PointerTosd__staticServiceDataValues(struct soap *soap, const char *tag, sd__staticServiceDataValues **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (sd__staticServiceDataValues **)soap_malloc(soap, sizeof(sd__staticServiceDataValues *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (sd__staticServiceDataValues *)soap_instantiate_sd__staticServiceDataValues(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	sd__staticServiceDataValues ** p = (sd__staticServiceDataValues **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_sd__staticServiceDataValues, sizeof(sd__staticServiceDataValues), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTosd__staticServiceDataValues(struct soap *soap, sd__staticServiceDataValues *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTosd__staticServiceDataValues);
	if (soap_out_PointerTosd__staticServiceDataValues(soap, tag?tag:"sd:staticServiceDataValues", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 sd__staticServiceDataValues ** SOAP_FMAC4 soap_get_PointerTosd__staticServiceDataValues(struct soap *soap, sd__staticServiceDataValues **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTosd__staticServiceDataValues(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsdl__operation(struct soap *soap, wsdl__operation *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsdl__operation))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsdl__operation(struct soap *soap, const char *tag, int id, wsdl__operation *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsdl__operation);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 wsdl__operation ** SOAP_FMAC4 soap_in_PointerTowsdl__operation(struct soap *soap, const char *tag, wsdl__operation **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (wsdl__operation **)soap_malloc(soap, sizeof(wsdl__operation *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (wsdl__operation *)soap_instantiate_wsdl__operation(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	wsdl__operation ** p = (wsdl__operation **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsdl__operation, sizeof(wsdl__operation), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsdl__operation(struct soap *soap, wsdl__operation *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsdl__operation);
	if (soap_out_PointerTowsdl__operation(soap, tag?tag:"wsdl:operation", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 wsdl__operation ** SOAP_FMAC4 soap_get_PointerTowsdl__operation(struct soap *soap, wsdl__operation **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsdl__operation(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTosoap__body(struct soap *soap, soap__body *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_soap__body))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTosoap__body(struct soap *soap, const char *tag, int id, soap__body *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_soap__body);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 soap__body ** SOAP_FMAC4 soap_in_PointerTosoap__body(struct soap *soap, const char *tag, soap__body **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (soap__body **)soap_malloc(soap, sizeof(soap__body *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (soap__body *)soap_instantiate_soap__body(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	soap__body ** p = (soap__body **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_soap__body, sizeof(soap__body), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTosoap__body(struct soap *soap, soap__body *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTosoap__body);
	if (soap_out_PointerTosoap__body(soap, tag?tag:"soap:body", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 soap__body ** SOAP_FMAC4 soap_get_PointerTosoap__body(struct soap *soap, soap__body **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTosoap__body(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsdl__part(struct soap *soap, wsdl__part *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsdl__part))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsdl__part(struct soap *soap, const char *tag, int id, wsdl__part *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsdl__part);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 wsdl__part ** SOAP_FMAC4 soap_in_PointerTowsdl__part(struct soap *soap, const char *tag, wsdl__part **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (wsdl__part **)soap_malloc(soap, sizeof(wsdl__part *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (wsdl__part *)soap_instantiate_wsdl__part(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	wsdl__part ** p = (wsdl__part **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsdl__part, sizeof(wsdl__part), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsdl__part(struct soap *soap, wsdl__part *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsdl__part);
	if (soap_out_PointerTowsdl__part(soap, tag?tag:"wsdl:part", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 wsdl__part ** SOAP_FMAC4 soap_get_PointerTowsdl__part(struct soap *soap, wsdl__part **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsdl__part(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsdl__message(struct soap *soap, wsdl__message *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsdl__message))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsdl__message(struct soap *soap, const char *tag, int id, wsdl__message *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsdl__message);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 wsdl__message ** SOAP_FMAC4 soap_in_PointerTowsdl__message(struct soap *soap, const char *tag, wsdl__message **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (wsdl__message **)soap_malloc(soap, sizeof(wsdl__message *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (wsdl__message *)soap_instantiate_wsdl__message(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	wsdl__message ** p = (wsdl__message **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsdl__message, sizeof(wsdl__message), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsdl__message(struct soap *soap, wsdl__message *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsdl__message);
	if (soap_out_PointerTowsdl__message(soap, tag?tag:"wsdl:message", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 wsdl__message ** SOAP_FMAC4 soap_get_PointerTowsdl__message(struct soap *soap, wsdl__message **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsdl__message(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTosoap__styleChoice(struct soap *soap, enum soap__styleChoice *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_soap__styleChoice);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTosoap__styleChoice(struct soap *soap, const char *tag, int id, enum soap__styleChoice *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_soap__styleChoice);
	if (id < 0)
		return soap->error;
	return soap_out_soap__styleChoice(soap, tag, id, *a, type);
}

SOAP_FMAC3 enum soap__styleChoice ** SOAP_FMAC4 soap_in_PointerTosoap__styleChoice(struct soap *soap, const char *tag, enum soap__styleChoice **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (enum soap__styleChoice **)soap_malloc(soap, sizeof(enum soap__styleChoice *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_soap__styleChoice(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (enum soap__styleChoice **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_soap__styleChoice, sizeof(enum soap__styleChoice), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTosoap__styleChoice(struct soap *soap, enum soap__styleChoice *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTosoap__styleChoice);
	if (soap_out_PointerTosoap__styleChoice(soap, tag?tag:"soap:styleChoice", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum soap__styleChoice ** SOAP_FMAC4 soap_get_PointerTosoap__styleChoice(struct soap *soap, enum soap__styleChoice **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTosoap__styleChoice(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxs__complexContent(struct soap *soap, xs__complexContent *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_xs__complexContent))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxs__complexContent(struct soap *soap, const char *tag, int id, xs__complexContent *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_xs__complexContent);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 xs__complexContent ** SOAP_FMAC4 soap_in_PointerToxs__complexContent(struct soap *soap, const char *tag, xs__complexContent **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (xs__complexContent **)soap_malloc(soap, sizeof(xs__complexContent *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (xs__complexContent *)soap_instantiate_xs__complexContent(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	xs__complexContent ** p = (xs__complexContent **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xs__complexContent, sizeof(xs__complexContent), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxs__complexContent(struct soap *soap, xs__complexContent *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxs__complexContent);
	if (soap_out_PointerToxs__complexContent(soap, tag?tag:"xs:complexContent", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 xs__complexContent ** SOAP_FMAC4 soap_get_PointerToxs__complexContent(struct soap *soap, xs__complexContent **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxs__complexContent(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxs__simpleContent(struct soap *soap, xs__simpleContent *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_xs__simpleContent))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxs__simpleContent(struct soap *soap, const char *tag, int id, xs__simpleContent *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_xs__simpleContent);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 xs__simpleContent ** SOAP_FMAC4 soap_in_PointerToxs__simpleContent(struct soap *soap, const char *tag, xs__simpleContent **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (xs__simpleContent **)soap_malloc(soap, sizeof(xs__simpleContent *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (xs__simpleContent *)soap_instantiate_xs__simpleContent(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	xs__simpleContent ** p = (xs__simpleContent **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xs__simpleContent, sizeof(xs__simpleContent), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxs__simpleContent(struct soap *soap, xs__simpleContent *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxs__simpleContent);
	if (soap_out_PointerToxs__simpleContent(soap, tag?tag:"xs:simpleContent", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 xs__simpleContent ** SOAP_FMAC4 soap_get_PointerToxs__simpleContent(struct soap *soap, xs__simpleContent **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxs__simpleContent(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxs__length(struct soap *soap, xs__length *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_xs__length))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxs__length(struct soap *soap, const char *tag, int id, xs__length *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_xs__length);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 xs__length ** SOAP_FMAC4 soap_in_PointerToxs__length(struct soap *soap, const char *tag, xs__length **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (xs__length **)soap_malloc(soap, sizeof(xs__length *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (xs__length *)soap_instantiate_xs__length(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	xs__length ** p = (xs__length **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xs__length, sizeof(xs__length), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxs__length(struct soap *soap, xs__length *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxs__length);
	if (soap_out_PointerToxs__length(soap, tag?tag:"xs:length", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 xs__length ** SOAP_FMAC4 soap_get_PointerToxs__length(struct soap *soap, xs__length **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxs__length(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxs__whiteSpace(struct soap *soap, xs__whiteSpace *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_xs__whiteSpace))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxs__whiteSpace(struct soap *soap, const char *tag, int id, xs__whiteSpace *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_xs__whiteSpace);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 xs__whiteSpace ** SOAP_FMAC4 soap_in_PointerToxs__whiteSpace(struct soap *soap, const char *tag, xs__whiteSpace **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (xs__whiteSpace **)soap_malloc(soap, sizeof(xs__whiteSpace *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (xs__whiteSpace *)soap_instantiate_xs__whiteSpace(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	xs__whiteSpace ** p = (xs__whiteSpace **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xs__whiteSpace, sizeof(xs__whiteSpace), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxs__whiteSpace(struct soap *soap, xs__whiteSpace *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxs__whiteSpace);
	if (soap_out_PointerToxs__whiteSpace(soap, tag?tag:"xs:whiteSpace", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 xs__whiteSpace ** SOAP_FMAC4 soap_get_PointerToxs__whiteSpace(struct soap *soap, xs__whiteSpace **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxs__whiteSpace(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxs__union(struct soap *soap, xs__union *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_xs__union))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxs__union(struct soap *soap, const char *tag, int id, xs__union *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_xs__union);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 xs__union ** SOAP_FMAC4 soap_in_PointerToxs__union(struct soap *soap, const char *tag, xs__union **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (xs__union **)soap_malloc(soap, sizeof(xs__union *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (xs__union *)soap_instantiate_xs__union(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	xs__union ** p = (xs__union **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xs__union, sizeof(xs__union), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxs__union(struct soap *soap, xs__union *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxs__union);
	if (soap_out_PointerToxs__union(soap, tag?tag:"xs:union", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 xs__union ** SOAP_FMAC4 soap_get_PointerToxs__union(struct soap *soap, xs__union **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxs__union(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxs__list(struct soap *soap, xs__list *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_xs__list))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxs__list(struct soap *soap, const char *tag, int id, xs__list *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_xs__list);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 xs__list ** SOAP_FMAC4 soap_in_PointerToxs__list(struct soap *soap, const char *tag, xs__list **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (xs__list **)soap_malloc(soap, sizeof(xs__list *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (xs__list *)soap_instantiate_xs__list(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	xs__list ** p = (xs__list **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xs__list, sizeof(xs__list), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxs__list(struct soap *soap, xs__list *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxs__list);
	if (soap_out_PointerToxs__list(soap, tag?tag:"xs:list", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 xs__list ** SOAP_FMAC4 soap_get_PointerToxs__list(struct soap *soap, xs__list **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxs__list(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxs__restriction(struct soap *soap, xs__restriction *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_xs__restriction))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxs__restriction(struct soap *soap, const char *tag, int id, xs__restriction *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_xs__restriction);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 xs__restriction ** SOAP_FMAC4 soap_in_PointerToxs__restriction(struct soap *soap, const char *tag, xs__restriction **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (xs__restriction **)soap_malloc(soap, sizeof(xs__restriction *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (xs__restriction *)soap_instantiate_xs__restriction(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	xs__restriction ** p = (xs__restriction **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xs__restriction, sizeof(xs__restriction), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxs__restriction(struct soap *soap, xs__restriction *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxs__restriction);
	if (soap_out_PointerToxs__restriction(soap, tag?tag:"xs:restriction", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 xs__restriction ** SOAP_FMAC4 soap_get_PointerToxs__restriction(struct soap *soap, xs__restriction **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxs__restriction(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxs__extension(struct soap *soap, xs__extension *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_xs__extension))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxs__extension(struct soap *soap, const char *tag, int id, xs__extension *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_xs__extension);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 xs__extension ** SOAP_FMAC4 soap_in_PointerToxs__extension(struct soap *soap, const char *tag, xs__extension **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (xs__extension **)soap_malloc(soap, sizeof(xs__extension *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (xs__extension *)soap_instantiate_xs__extension(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	xs__extension ** p = (xs__extension **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xs__extension, sizeof(xs__extension), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxs__extension(struct soap *soap, xs__extension *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxs__extension);
	if (soap_out_PointerToxs__extension(soap, tag?tag:"xs:extension", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 xs__extension ** SOAP_FMAC4 soap_get_PointerToxs__extension(struct soap *soap, xs__extension **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxs__extension(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxs__attributeGroup(struct soap *soap, xs__attributeGroup *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_xs__attributeGroup))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxs__attributeGroup(struct soap *soap, const char *tag, int id, xs__attributeGroup *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_xs__attributeGroup);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 xs__attributeGroup ** SOAP_FMAC4 soap_in_PointerToxs__attributeGroup(struct soap *soap, const char *tag, xs__attributeGroup **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (xs__attributeGroup **)soap_malloc(soap, sizeof(xs__attributeGroup *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (xs__attributeGroup *)soap_instantiate_xs__attributeGroup(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	xs__attributeGroup ** p = (xs__attributeGroup **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xs__attributeGroup, sizeof(xs__attributeGroup), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxs__attributeGroup(struct soap *soap, xs__attributeGroup *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxs__attributeGroup);
	if (soap_out_PointerToxs__attributeGroup(soap, tag?tag:"xs:attributeGroup", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 xs__attributeGroup ** SOAP_FMAC4 soap_get_PointerToxs__attributeGroup(struct soap *soap, xs__attributeGroup **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxs__attributeGroup(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxs__anyAttribute(struct soap *soap, xs__anyAttribute *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_xs__anyAttribute))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxs__anyAttribute(struct soap *soap, const char *tag, int id, xs__anyAttribute *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_xs__anyAttribute);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 xs__anyAttribute ** SOAP_FMAC4 soap_in_PointerToxs__anyAttribute(struct soap *soap, const char *tag, xs__anyAttribute **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (xs__anyAttribute **)soap_malloc(soap, sizeof(xs__anyAttribute *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (xs__anyAttribute *)soap_instantiate_xs__anyAttribute(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	xs__anyAttribute ** p = (xs__anyAttribute **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xs__anyAttribute, sizeof(xs__anyAttribute), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxs__anyAttribute(struct soap *soap, xs__anyAttribute *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxs__anyAttribute);
	if (soap_out_PointerToxs__anyAttribute(soap, tag?tag:"xs:anyAttribute", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 xs__anyAttribute ** SOAP_FMAC4 soap_get_PointerToxs__anyAttribute(struct soap *soap, xs__anyAttribute **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxs__anyAttribute(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxs__all(struct soap *soap, xs__all *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_xs__all))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxs__all(struct soap *soap, const char *tag, int id, xs__all *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_xs__all);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 xs__all ** SOAP_FMAC4 soap_in_PointerToxs__all(struct soap *soap, const char *tag, xs__all **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (xs__all **)soap_malloc(soap, sizeof(xs__all *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (xs__all *)soap_instantiate_xs__all(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	xs__all ** p = (xs__all **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xs__all, sizeof(xs__all), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxs__all(struct soap *soap, xs__all *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxs__all);
	if (soap_out_PointerToxs__all(soap, tag?tag:"xs:all", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 xs__all ** SOAP_FMAC4 soap_get_PointerToxs__all(struct soap *soap, xs__all **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxs__all(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxs__any(struct soap *soap, xs__any *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_xs__any))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxs__any(struct soap *soap, const char *tag, int id, xs__any *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_xs__any);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 xs__any ** SOAP_FMAC4 soap_in_PointerToxs__any(struct soap *soap, const char *tag, xs__any **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (xs__any **)soap_malloc(soap, sizeof(xs__any *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (xs__any *)soap_instantiate_xs__any(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	xs__any ** p = (xs__any **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xs__any, sizeof(xs__any), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxs__any(struct soap *soap, xs__any *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxs__any);
	if (soap_out_PointerToxs__any(soap, tag?tag:"xs:any", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 xs__any ** SOAP_FMAC4 soap_get_PointerToxs__any(struct soap *soap, xs__any **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxs__any(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxs__seqchoice(struct soap *soap, xs__seqchoice *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_xs__seqchoice))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxs__seqchoice(struct soap *soap, const char *tag, int id, xs__seqchoice *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_xs__seqchoice);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 xs__seqchoice ** SOAP_FMAC4 soap_in_PointerToxs__seqchoice(struct soap *soap, const char *tag, xs__seqchoice **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (xs__seqchoice **)soap_malloc(soap, sizeof(xs__seqchoice *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (xs__seqchoice *)soap_instantiate_xs__seqchoice(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	xs__seqchoice ** p = (xs__seqchoice **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xs__seqchoice, sizeof(xs__seqchoice), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxs__seqchoice(struct soap *soap, xs__seqchoice *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxs__seqchoice);
	if (soap_out_PointerToxs__seqchoice(soap, tag?tag:"xs:seqchoice", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 xs__seqchoice ** SOAP_FMAC4 soap_get_PointerToxs__seqchoice(struct soap *soap, xs__seqchoice **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxs__seqchoice(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxs__group(struct soap *soap, xs__group *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_xs__group))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxs__group(struct soap *soap, const char *tag, int id, xs__group *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_xs__group);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 xs__group ** SOAP_FMAC4 soap_in_PointerToxs__group(struct soap *soap, const char *tag, xs__group **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (xs__group **)soap_malloc(soap, sizeof(xs__group *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (xs__group *)soap_instantiate_xs__group(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	xs__group ** p = (xs__group **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xs__group, sizeof(xs__group), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxs__group(struct soap *soap, xs__group *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxs__group);
	if (soap_out_PointerToxs__group(soap, tag?tag:"xs:group", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 xs__group ** SOAP_FMAC4 soap_get_PointerToxs__group(struct soap *soap, xs__group **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxs__group(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xs__namespaceList(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_xs__namespaceList);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_xs__namespaceList(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE_xs__namespaceList, 1, 0, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xs__namespaceList(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xs__namespaceList);
	if (soap_out_xs__namespaceList(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_xs__namespaceList(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_xs__namespaceList(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxs__attribute(struct soap *soap, xs__attribute *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_xs__attribute))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxs__attribute(struct soap *soap, const char *tag, int id, xs__attribute *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_xs__attribute);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 xs__attribute ** SOAP_FMAC4 soap_in_PointerToxs__attribute(struct soap *soap, const char *tag, xs__attribute **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (xs__attribute **)soap_malloc(soap, sizeof(xs__attribute *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (xs__attribute *)soap_instantiate_xs__attribute(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	xs__attribute ** p = (xs__attribute **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xs__attribute, sizeof(xs__attribute), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxs__attribute(struct soap *soap, xs__attribute *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxs__attribute);
	if (soap_out_PointerToxs__attribute(soap, tag?tag:"xs:attribute", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 xs__attribute ** SOAP_FMAC4 soap_get_PointerToxs__attribute(struct soap *soap, xs__attribute **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxs__attribute(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTostd__vectorTemplateOfPointerToxs__element(struct soap *soap, std::vector<xs__element * >*const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_std__vectorTemplateOfPointerToxs__element))
		soap_serialize_std__vectorTemplateOfPointerToxs__element(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTostd__vectorTemplateOfPointerToxs__element(struct soap *soap, const char *tag, int id, std::vector<xs__element * >*const*a, const char *type)
{
	if (!*a)
		return soap_element_null(soap, tag, id, type);
	return soap_out_std__vectorTemplateOfPointerToxs__element(soap, tag, id, *a, type);
}

SOAP_FMAC3 std::vector<xs__element * >** SOAP_FMAC4 soap_in_PointerTostd__vectorTemplateOfPointerToxs__element(struct soap *soap, const char *tag, std::vector<xs__element * >**a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	soap_revert(soap);
	if (!a)
		if (!(a = (std::vector<xs__element * >**)soap_malloc(soap, sizeof(std::vector<xs__element * >*))))
			return NULL;
	if (!(*a = soap_in_std__vectorTemplateOfPointerToxs__element(soap, tag, *a, type)))
		return NULL;
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTostd__vectorTemplateOfPointerToxs__element(struct soap *soap, std::vector<xs__element * >*const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTostd__vectorTemplateOfPointerToxs__element);
	if (soap_out_PointerTostd__vectorTemplateOfPointerToxs__element(soap, tag?tag:"", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 std::vector<xs__element * >** SOAP_FMAC4 soap_get_PointerTostd__vectorTemplateOfPointerToxs__element(struct soap *soap, std::vector<xs__element * >**p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTostd__vectorTemplateOfPointerToxs__element(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxs__element(struct soap *soap, xs__element *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_xs__element))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxs__element(struct soap *soap, const char *tag, int id, xs__element *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_xs__element);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 xs__element ** SOAP_FMAC4 soap_in_PointerToxs__element(struct soap *soap, const char *tag, xs__element **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (xs__element **)soap_malloc(soap, sizeof(xs__element *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (xs__element *)soap_instantiate_xs__element(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	xs__element ** p = (xs__element **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xs__element, sizeof(xs__element), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxs__element(struct soap *soap, xs__element *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxs__element);
	if (soap_out_PointerToxs__element(soap, tag?tag:"xs:element", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 xs__element ** SOAP_FMAC4 soap_get_PointerToxs__element(struct soap *soap, xs__element **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxs__element(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxs__schema(struct soap *soap, xs__schema *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_xs__schema))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxs__schema(struct soap *soap, const char *tag, int id, xs__schema *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_xs__schema);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 xs__schema ** SOAP_FMAC4 soap_in_PointerToxs__schema(struct soap *soap, const char *tag, xs__schema **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (xs__schema **)soap_malloc(soap, sizeof(xs__schema *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (xs__schema *)soap_instantiate_xs__schema(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	xs__schema ** p = (xs__schema **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xs__schema, sizeof(xs__schema), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxs__schema(struct soap *soap, xs__schema *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxs__schema);
	if (soap_out_PointerToxs__schema(soap, tag?tag:"xs:schema", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 xs__schema ** SOAP_FMAC4 soap_get_PointerToxs__schema(struct soap *soap, xs__schema **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxs__schema(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxs__complexType(struct soap *soap, xs__complexType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_xs__complexType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxs__complexType(struct soap *soap, const char *tag, int id, xs__complexType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_xs__complexType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 xs__complexType ** SOAP_FMAC4 soap_in_PointerToxs__complexType(struct soap *soap, const char *tag, xs__complexType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (xs__complexType **)soap_malloc(soap, sizeof(xs__complexType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (xs__complexType *)soap_instantiate_xs__complexType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	xs__complexType ** p = (xs__complexType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xs__complexType, sizeof(xs__complexType), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxs__complexType(struct soap *soap, xs__complexType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxs__complexType);
	if (soap_out_PointerToxs__complexType(soap, tag?tag:"xs:complexType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 xs__complexType ** SOAP_FMAC4 soap_get_PointerToxs__complexType(struct soap *soap, xs__complexType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxs__complexType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxs__simpleType(struct soap *soap, xs__simpleType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_xs__simpleType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxs__simpleType(struct soap *soap, const char *tag, int id, xs__simpleType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_xs__simpleType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 xs__simpleType ** SOAP_FMAC4 soap_in_PointerToxs__simpleType(struct soap *soap, const char *tag, xs__simpleType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (xs__simpleType **)soap_malloc(soap, sizeof(xs__simpleType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (xs__simpleType *)soap_instantiate_xs__simpleType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	xs__simpleType ** p = (xs__simpleType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xs__simpleType, sizeof(xs__simpleType), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxs__simpleType(struct soap *soap, xs__simpleType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxs__simpleType);
	if (soap_out_PointerToxs__simpleType(soap, tag?tag:"xs:simpleType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 xs__simpleType ** SOAP_FMAC4 soap_get_PointerToxs__simpleType(struct soap *soap, xs__simpleType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxs__simpleType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxs__annotation(struct soap *soap, xs__annotation *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_xs__annotation))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxs__annotation(struct soap *soap, const char *tag, int id, xs__annotation *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_xs__annotation);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 xs__annotation ** SOAP_FMAC4 soap_in_PointerToxs__annotation(struct soap *soap, const char *tag, xs__annotation **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (xs__annotation **)soap_malloc(soap, sizeof(xs__annotation *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (xs__annotation *)soap_instantiate_xs__annotation(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	xs__annotation ** p = (xs__annotation **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xs__annotation, sizeof(xs__annotation), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxs__annotation(struct soap *soap, xs__annotation *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxs__annotation);
	if (soap_out_PointerToxs__annotation(soap, tag?tag:"xs:annotation", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 xs__annotation ** SOAP_FMAC4 soap_get_PointerToxs__annotation(struct soap *soap, xs__annotation **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxs__annotation(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxs__formChoice(struct soap *soap, enum xs__formChoice *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_xs__formChoice);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxs__formChoice(struct soap *soap, const char *tag, int id, enum xs__formChoice *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_xs__formChoice);
	if (id < 0)
		return soap->error;
	return soap_out_xs__formChoice(soap, tag, id, *a, type);
}

SOAP_FMAC3 enum xs__formChoice ** SOAP_FMAC4 soap_in_PointerToxs__formChoice(struct soap *soap, const char *tag, enum xs__formChoice **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (enum xs__formChoice **)soap_malloc(soap, sizeof(enum xs__formChoice *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_xs__formChoice(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (enum xs__formChoice **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xs__formChoice, sizeof(enum xs__formChoice), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxs__formChoice(struct soap *soap, enum xs__formChoice *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxs__formChoice);
	if (soap_out_PointerToxs__formChoice(soap, tag?tag:"xs:formChoice", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum xs__formChoice ** SOAP_FMAC4 soap_get_PointerToxs__formChoice(struct soap *soap, enum xs__formChoice **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxs__formChoice(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__string(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_xsd__string);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_xsd__string(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE_xsd__string, 1, 0, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__string(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__string);
	if (soap_out_xsd__string(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_xsd__string(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__string(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__QName(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_xsd__QName);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_xsd__QName(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE_xsd__QName, 2, 0, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__QName(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__QName);
	if (soap_out_xsd__QName(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_xsd__QName(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__QName(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__NMTOKENS(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_xsd__NMTOKENS);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_xsd__NMTOKENS(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE_xsd__NMTOKENS, 1, 0, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__NMTOKENS(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__NMTOKENS);
	if (soap_out_xsd__NMTOKENS(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_xsd__NMTOKENS(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__NMTOKENS(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__NMTOKEN(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_xsd__NMTOKEN);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_xsd__NMTOKEN(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE_xsd__NMTOKEN, 1, 0, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__NMTOKEN(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__NMTOKEN);
	if (soap_out_xsd__NMTOKEN(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_xsd__NMTOKEN(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__NMTOKEN(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__NCName(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_xsd__NCName);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_xsd__NCName(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE_xsd__NCName, 1, 0, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__NCName(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__NCName);
	if (soap_out_xsd__NCName(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_xsd__NCName(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__NCName(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__ID(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_xsd__ID);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_xsd__ID(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE_xsd__ID, 1, 0, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__ID(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__ID);
	if (soap_out_xsd__ID(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_xsd__ID(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__ID(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__anyURI(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_xsd__anyURI);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_xsd__anyURI(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE_xsd__anyURI, 1, 0, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__anyURI(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__anyURI);
	if (soap_out_xsd__anyURI(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_xsd__anyURI(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__anyURI(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__QName(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__QName);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__QName(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE__QName, 2, 0, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__QName(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__QName);
	if (soap_out__QName(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__QName(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__QName(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_string(struct soap *soap, char **a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_string
	*a = SOAP_DEFAULT_string;
#else
	*a = (char *)0;
#endif
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_string(struct soap *soap, char *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_string);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_string(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_string);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_string(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE_string, 1, 0, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_string(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_string);
	if (soap_out_string(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_string(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_string(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfgwsdl__portType(struct soap *soap, std::vector<gwsdl__portType >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfgwsdl__portType(struct soap *soap, const std::vector<gwsdl__portType >*a)
{
	for (std::vector<gwsdl__portType >::const_iterator i = a->begin(); i != a->end(); ++i)
		(*i).soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfgwsdl__portType(struct soap *soap, const char *tag, int id, const std::vector<gwsdl__portType >*a, const char *type)
{
	for (std::vector<gwsdl__portType >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if ((*i).soap_out(soap, tag, id, ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<gwsdl__portType >* SOAP_FMAC4 soap_in_std__vectorTemplateOfgwsdl__portType(struct soap *soap, const char *tag, std::vector<gwsdl__portType >*a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfgwsdl__portType(soap, -1)))
		return NULL;
	gwsdl__portType n;
	short soap_flag = 0;
	do
	{	if (tag && *tag != '-')
			soap_revert(soap);
		n.soap_default(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_gwsdl__portType, SOAP_TYPE_std__vectorTemplateOfgwsdl__portType, sizeof(gwsdl__portType), 0))
				break;
			if (!soap_in_gwsdl__portType(soap, tag, NULL, "gwsdl:portType"))
				break;
		}
		else
		{
			if (!soap_in_gwsdl__portType(soap, tag, &n, "gwsdl:portType"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (tag && *tag != '-' && !soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC1 std::vector<gwsdl__portType > * SOAP_FMAC2 soap_instantiate_std__vectorTemplateOfgwsdl__portType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfgwsdl__portType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfgwsdl__portType, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(std::vector<gwsdl__portType >);
		if (size)
			*size = sizeof(std::vector<gwsdl__portType >);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(std::vector<gwsdl__portType >[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<gwsdl__portType >);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<gwsdl__portType >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfgwsdl__portType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<gwsdl__portType > %p -> %p\n", q, p));
	*(std::vector<gwsdl__portType >*)p = *(std::vector<gwsdl__portType >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfwsdl__service(struct soap *soap, std::vector<wsdl__service >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfwsdl__service(struct soap *soap, const std::vector<wsdl__service >*a)
{
	for (std::vector<wsdl__service >::const_iterator i = a->begin(); i != a->end(); ++i)
		(*i).soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfwsdl__service(struct soap *soap, const char *tag, int id, const std::vector<wsdl__service >*a, const char *type)
{
	for (std::vector<wsdl__service >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if ((*i).soap_out(soap, tag, id, ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<wsdl__service >* SOAP_FMAC4 soap_in_std__vectorTemplateOfwsdl__service(struct soap *soap, const char *tag, std::vector<wsdl__service >*a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfwsdl__service(soap, -1)))
		return NULL;
	wsdl__service n;
	short soap_flag = 0;
	do
	{	if (tag && *tag != '-')
			soap_revert(soap);
		n.soap_default(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_wsdl__service, SOAP_TYPE_std__vectorTemplateOfwsdl__service, sizeof(wsdl__service), 0))
				break;
			if (!soap_in_wsdl__service(soap, tag, NULL, "wsdl:service"))
				break;
		}
		else
		{
			if (!soap_in_wsdl__service(soap, tag, &n, "wsdl:service"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (tag && *tag != '-' && !soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC1 std::vector<wsdl__service > * SOAP_FMAC2 soap_instantiate_std__vectorTemplateOfwsdl__service(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfwsdl__service(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfwsdl__service, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(std::vector<wsdl__service >);
		if (size)
			*size = sizeof(std::vector<wsdl__service >);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(std::vector<wsdl__service >[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<wsdl__service >);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<wsdl__service >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfwsdl__service(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<wsdl__service > %p -> %p\n", q, p));
	*(std::vector<wsdl__service >*)p = *(std::vector<wsdl__service >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfwsdl__binding(struct soap *soap, std::vector<wsdl__binding >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfwsdl__binding(struct soap *soap, const std::vector<wsdl__binding >*a)
{
	for (std::vector<wsdl__binding >::const_iterator i = a->begin(); i != a->end(); ++i)
		(*i).soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfwsdl__binding(struct soap *soap, const char *tag, int id, const std::vector<wsdl__binding >*a, const char *type)
{
	for (std::vector<wsdl__binding >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if ((*i).soap_out(soap, tag, id, ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<wsdl__binding >* SOAP_FMAC4 soap_in_std__vectorTemplateOfwsdl__binding(struct soap *soap, const char *tag, std::vector<wsdl__binding >*a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfwsdl__binding(soap, -1)))
		return NULL;
	wsdl__binding n;
	short soap_flag = 0;
	do
	{	if (tag && *tag != '-')
			soap_revert(soap);
		n.soap_default(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_wsdl__binding, SOAP_TYPE_std__vectorTemplateOfwsdl__binding, sizeof(wsdl__binding), 0))
				break;
			if (!soap_in_wsdl__binding(soap, tag, NULL, "wsdl:binding"))
				break;
		}
		else
		{
			if (!soap_in_wsdl__binding(soap, tag, &n, "wsdl:binding"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (tag && *tag != '-' && !soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC1 std::vector<wsdl__binding > * SOAP_FMAC2 soap_instantiate_std__vectorTemplateOfwsdl__binding(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfwsdl__binding(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfwsdl__binding, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(std::vector<wsdl__binding >);
		if (size)
			*size = sizeof(std::vector<wsdl__binding >);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(std::vector<wsdl__binding >[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<wsdl__binding >);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<wsdl__binding >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfwsdl__binding(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<wsdl__binding > %p -> %p\n", q, p));
	*(std::vector<wsdl__binding >*)p = *(std::vector<wsdl__binding >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfwsdl__portType(struct soap *soap, std::vector<wsdl__portType >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfwsdl__portType(struct soap *soap, const std::vector<wsdl__portType >*a)
{
	for (std::vector<wsdl__portType >::const_iterator i = a->begin(); i != a->end(); ++i)
		(*i).soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfwsdl__portType(struct soap *soap, const char *tag, int id, const std::vector<wsdl__portType >*a, const char *type)
{
	for (std::vector<wsdl__portType >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if ((*i).soap_out(soap, tag, id, ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<wsdl__portType >* SOAP_FMAC4 soap_in_std__vectorTemplateOfwsdl__portType(struct soap *soap, const char *tag, std::vector<wsdl__portType >*a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfwsdl__portType(soap, -1)))
		return NULL;
	wsdl__portType n;
	short soap_flag = 0;
	do
	{	if (tag && *tag != '-')
			soap_revert(soap);
		n.soap_default(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_wsdl__portType, SOAP_TYPE_std__vectorTemplateOfwsdl__portType, sizeof(wsdl__portType), 0))
				break;
			if (!soap_in_wsdl__portType(soap, tag, NULL, "wsdl:portType"))
				break;
		}
		else
		{
			if (!soap_in_wsdl__portType(soap, tag, &n, "wsdl:portType"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (tag && *tag != '-' && !soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC1 std::vector<wsdl__portType > * SOAP_FMAC2 soap_instantiate_std__vectorTemplateOfwsdl__portType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfwsdl__portType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfwsdl__portType, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(std::vector<wsdl__portType >);
		if (size)
			*size = sizeof(std::vector<wsdl__portType >);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(std::vector<wsdl__portType >[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<wsdl__portType >);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<wsdl__portType >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfwsdl__portType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<wsdl__portType > %p -> %p\n", q, p));
	*(std::vector<wsdl__portType >*)p = *(std::vector<wsdl__portType >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfwsdl__message(struct soap *soap, std::vector<wsdl__message >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfwsdl__message(struct soap *soap, const std::vector<wsdl__message >*a)
{
	for (std::vector<wsdl__message >::const_iterator i = a->begin(); i != a->end(); ++i)
		(*i).soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfwsdl__message(struct soap *soap, const char *tag, int id, const std::vector<wsdl__message >*a, const char *type)
{
	for (std::vector<wsdl__message >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if ((*i).soap_out(soap, tag, id, ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<wsdl__message >* SOAP_FMAC4 soap_in_std__vectorTemplateOfwsdl__message(struct soap *soap, const char *tag, std::vector<wsdl__message >*a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfwsdl__message(soap, -1)))
		return NULL;
	wsdl__message n;
	short soap_flag = 0;
	do
	{	if (tag && *tag != '-')
			soap_revert(soap);
		n.soap_default(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_wsdl__message, SOAP_TYPE_std__vectorTemplateOfwsdl__message, sizeof(wsdl__message), 0))
				break;
			if (!soap_in_wsdl__message(soap, tag, NULL, "wsdl:message"))
				break;
		}
		else
		{
			if (!soap_in_wsdl__message(soap, tag, &n, "wsdl:message"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (tag && *tag != '-' && !soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC1 std::vector<wsdl__message > * SOAP_FMAC2 soap_instantiate_std__vectorTemplateOfwsdl__message(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfwsdl__message(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfwsdl__message, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(std::vector<wsdl__message >);
		if (size)
			*size = sizeof(std::vector<wsdl__message >);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(std::vector<wsdl__message >[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<wsdl__message >);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<wsdl__message >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfwsdl__message(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<wsdl__message > %p -> %p\n", q, p));
	*(std::vector<wsdl__message >*)p = *(std::vector<wsdl__message >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfwsdl__import(struct soap *soap, std::vector<wsdl__import >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfwsdl__import(struct soap *soap, const std::vector<wsdl__import >*a)
{
	for (std::vector<wsdl__import >::const_iterator i = a->begin(); i != a->end(); ++i)
		(*i).soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfwsdl__import(struct soap *soap, const char *tag, int id, const std::vector<wsdl__import >*a, const char *type)
{
	for (std::vector<wsdl__import >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if ((*i).soap_out(soap, tag, id, ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<wsdl__import >* SOAP_FMAC4 soap_in_std__vectorTemplateOfwsdl__import(struct soap *soap, const char *tag, std::vector<wsdl__import >*a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfwsdl__import(soap, -1)))
		return NULL;
	wsdl__import n;
	short soap_flag = 0;
	do
	{	if (tag && *tag != '-')
			soap_revert(soap);
		n.soap_default(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_wsdl__import, SOAP_TYPE_std__vectorTemplateOfwsdl__import, sizeof(wsdl__import), 0))
				break;
			if (!soap_in_wsdl__import(soap, tag, NULL, "wsdl:import"))
				break;
		}
		else
		{
			if (!soap_in_wsdl__import(soap, tag, &n, "wsdl:import"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (tag && *tag != '-' && !soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC1 std::vector<wsdl__import > * SOAP_FMAC2 soap_instantiate_std__vectorTemplateOfwsdl__import(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfwsdl__import(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfwsdl__import, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(std::vector<wsdl__import >);
		if (size)
			*size = sizeof(std::vector<wsdl__import >);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(std::vector<wsdl__import >[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<wsdl__import >);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<wsdl__import >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfwsdl__import(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<wsdl__import > %p -> %p\n", q, p));
	*(std::vector<wsdl__import >*)p = *(std::vector<wsdl__import >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfwsdl__port(struct soap *soap, std::vector<wsdl__port >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfwsdl__port(struct soap *soap, const std::vector<wsdl__port >*a)
{
	for (std::vector<wsdl__port >::const_iterator i = a->begin(); i != a->end(); ++i)
		(*i).soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfwsdl__port(struct soap *soap, const char *tag, int id, const std::vector<wsdl__port >*a, const char *type)
{
	for (std::vector<wsdl__port >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if ((*i).soap_out(soap, tag, id, ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<wsdl__port >* SOAP_FMAC4 soap_in_std__vectorTemplateOfwsdl__port(struct soap *soap, const char *tag, std::vector<wsdl__port >*a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfwsdl__port(soap, -1)))
		return NULL;
	wsdl__port n;
	short soap_flag = 0;
	do
	{	if (tag && *tag != '-')
			soap_revert(soap);
		n.soap_default(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_wsdl__port, SOAP_TYPE_std__vectorTemplateOfwsdl__port, sizeof(wsdl__port), 0))
				break;
			if (!soap_in_wsdl__port(soap, tag, NULL, "wsdl:port"))
				break;
		}
		else
		{
			if (!soap_in_wsdl__port(soap, tag, &n, "wsdl:port"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (tag && *tag != '-' && !soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC1 std::vector<wsdl__port > * SOAP_FMAC2 soap_instantiate_std__vectorTemplateOfwsdl__port(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfwsdl__port(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfwsdl__port, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(std::vector<wsdl__port >);
		if (size)
			*size = sizeof(std::vector<wsdl__port >);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(std::vector<wsdl__port >[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<wsdl__port >);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<wsdl__port >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfwsdl__port(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<wsdl__port > %p -> %p\n", q, p));
	*(std::vector<wsdl__port >*)p = *(std::vector<wsdl__port >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfwsdl__binding_operation(struct soap *soap, std::vector<wsdl__binding_operation >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfwsdl__binding_operation(struct soap *soap, const std::vector<wsdl__binding_operation >*a)
{
	for (std::vector<wsdl__binding_operation >::const_iterator i = a->begin(); i != a->end(); ++i)
		(*i).soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfwsdl__binding_operation(struct soap *soap, const char *tag, int id, const std::vector<wsdl__binding_operation >*a, const char *type)
{
	for (std::vector<wsdl__binding_operation >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if ((*i).soap_out(soap, tag, id, ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<wsdl__binding_operation >* SOAP_FMAC4 soap_in_std__vectorTemplateOfwsdl__binding_operation(struct soap *soap, const char *tag, std::vector<wsdl__binding_operation >*a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfwsdl__binding_operation(soap, -1)))
		return NULL;
	wsdl__binding_operation n;
	short soap_flag = 0;
	do
	{	if (tag && *tag != '-')
			soap_revert(soap);
		n.soap_default(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_wsdl__binding_operation, SOAP_TYPE_std__vectorTemplateOfwsdl__binding_operation, sizeof(wsdl__binding_operation), 0))
				break;
			if (!soap_in_wsdl__binding_operation(soap, tag, NULL, "wsdl:binding-operation"))
				break;
		}
		else
		{
			if (!soap_in_wsdl__binding_operation(soap, tag, &n, "wsdl:binding-operation"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (tag && *tag != '-' && !soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC1 std::vector<wsdl__binding_operation > * SOAP_FMAC2 soap_instantiate_std__vectorTemplateOfwsdl__binding_operation(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfwsdl__binding_operation(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfwsdl__binding_operation, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(std::vector<wsdl__binding_operation >);
		if (size)
			*size = sizeof(std::vector<wsdl__binding_operation >);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(std::vector<wsdl__binding_operation >[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<wsdl__binding_operation >);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<wsdl__binding_operation >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfwsdl__binding_operation(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<wsdl__binding_operation > %p -> %p\n", q, p));
	*(std::vector<wsdl__binding_operation >*)p = *(std::vector<wsdl__binding_operation >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfwsdl__ext_fault(struct soap *soap, std::vector<wsdl__ext_fault >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfwsdl__ext_fault(struct soap *soap, const std::vector<wsdl__ext_fault >*a)
{
	for (std::vector<wsdl__ext_fault >::const_iterator i = a->begin(); i != a->end(); ++i)
		(*i).soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfwsdl__ext_fault(struct soap *soap, const char *tag, int id, const std::vector<wsdl__ext_fault >*a, const char *type)
{
	for (std::vector<wsdl__ext_fault >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if ((*i).soap_out(soap, tag, id, ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<wsdl__ext_fault >* SOAP_FMAC4 soap_in_std__vectorTemplateOfwsdl__ext_fault(struct soap *soap, const char *tag, std::vector<wsdl__ext_fault >*a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfwsdl__ext_fault(soap, -1)))
		return NULL;
	wsdl__ext_fault n;
	short soap_flag = 0;
	do
	{	if (tag && *tag != '-')
			soap_revert(soap);
		n.soap_default(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_wsdl__ext_fault, SOAP_TYPE_std__vectorTemplateOfwsdl__ext_fault, sizeof(wsdl__ext_fault), 0))
				break;
			if (!soap_in_wsdl__ext_fault(soap, tag, NULL, "wsdl:ext-fault"))
				break;
		}
		else
		{
			if (!soap_in_wsdl__ext_fault(soap, tag, &n, "wsdl:ext-fault"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (tag && *tag != '-' && !soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC1 std::vector<wsdl__ext_fault > * SOAP_FMAC2 soap_instantiate_std__vectorTemplateOfwsdl__ext_fault(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfwsdl__ext_fault(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfwsdl__ext_fault, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(std::vector<wsdl__ext_fault >);
		if (size)
			*size = sizeof(std::vector<wsdl__ext_fault >);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(std::vector<wsdl__ext_fault >[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<wsdl__ext_fault >);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<wsdl__ext_fault >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfwsdl__ext_fault(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<wsdl__ext_fault > %p -> %p\n", q, p));
	*(std::vector<wsdl__ext_fault >*)p = *(std::vector<wsdl__ext_fault >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfwsdl__operation(struct soap *soap, std::vector<wsdl__operation >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfwsdl__operation(struct soap *soap, const std::vector<wsdl__operation >*a)
{
	for (std::vector<wsdl__operation >::const_iterator i = a->begin(); i != a->end(); ++i)
		(*i).soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfwsdl__operation(struct soap *soap, const char *tag, int id, const std::vector<wsdl__operation >*a, const char *type)
{
	for (std::vector<wsdl__operation >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if ((*i).soap_out(soap, tag, id, ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<wsdl__operation >* SOAP_FMAC4 soap_in_std__vectorTemplateOfwsdl__operation(struct soap *soap, const char *tag, std::vector<wsdl__operation >*a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfwsdl__operation(soap, -1)))
		return NULL;
	wsdl__operation n;
	short soap_flag = 0;
	do
	{	if (tag && *tag != '-')
			soap_revert(soap);
		n.soap_default(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_wsdl__operation, SOAP_TYPE_std__vectorTemplateOfwsdl__operation, sizeof(wsdl__operation), 0))
				break;
			if (!soap_in_wsdl__operation(soap, tag, NULL, "wsdl:operation"))
				break;
		}
		else
		{
			if (!soap_in_wsdl__operation(soap, tag, &n, "wsdl:operation"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (tag && *tag != '-' && !soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC1 std::vector<wsdl__operation > * SOAP_FMAC2 soap_instantiate_std__vectorTemplateOfwsdl__operation(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfwsdl__operation(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfwsdl__operation, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(std::vector<wsdl__operation >);
		if (size)
			*size = sizeof(std::vector<wsdl__operation >);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(std::vector<wsdl__operation >[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<wsdl__operation >);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<wsdl__operation >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfwsdl__operation(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<wsdl__operation > %p -> %p\n", q, p));
	*(std::vector<wsdl__operation >*)p = *(std::vector<wsdl__operation >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfwsdl__fault(struct soap *soap, std::vector<wsdl__fault >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfwsdl__fault(struct soap *soap, const std::vector<wsdl__fault >*a)
{
	for (std::vector<wsdl__fault >::const_iterator i = a->begin(); i != a->end(); ++i)
		(*i).soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfwsdl__fault(struct soap *soap, const char *tag, int id, const std::vector<wsdl__fault >*a, const char *type)
{
	for (std::vector<wsdl__fault >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if ((*i).soap_out(soap, tag, id, ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<wsdl__fault >* SOAP_FMAC4 soap_in_std__vectorTemplateOfwsdl__fault(struct soap *soap, const char *tag, std::vector<wsdl__fault >*a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfwsdl__fault(soap, -1)))
		return NULL;
	wsdl__fault n;
	short soap_flag = 0;
	do
	{	if (tag && *tag != '-')
			soap_revert(soap);
		n.soap_default(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_wsdl__fault, SOAP_TYPE_std__vectorTemplateOfwsdl__fault, sizeof(wsdl__fault), 0))
				break;
			if (!soap_in_wsdl__fault(soap, tag, NULL, "wsdl:fault"))
				break;
		}
		else
		{
			if (!soap_in_wsdl__fault(soap, tag, &n, "wsdl:fault"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (tag && *tag != '-' && !soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC1 std::vector<wsdl__fault > * SOAP_FMAC2 soap_instantiate_std__vectorTemplateOfwsdl__fault(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfwsdl__fault(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfwsdl__fault, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(std::vector<wsdl__fault >);
		if (size)
			*size = sizeof(std::vector<wsdl__fault >);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(std::vector<wsdl__fault >[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<wsdl__fault >);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<wsdl__fault >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfwsdl__fault(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<wsdl__fault > %p -> %p\n", q, p));
	*(std::vector<wsdl__fault >*)p = *(std::vector<wsdl__fault >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfwsdl__part(struct soap *soap, std::vector<wsdl__part >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfwsdl__part(struct soap *soap, const std::vector<wsdl__part >*a)
{
	for (std::vector<wsdl__part >::const_iterator i = a->begin(); i != a->end(); ++i)
		(*i).soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfwsdl__part(struct soap *soap, const char *tag, int id, const std::vector<wsdl__part >*a, const char *type)
{
	for (std::vector<wsdl__part >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if ((*i).soap_out(soap, tag, id, ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<wsdl__part >* SOAP_FMAC4 soap_in_std__vectorTemplateOfwsdl__part(struct soap *soap, const char *tag, std::vector<wsdl__part >*a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfwsdl__part(soap, -1)))
		return NULL;
	wsdl__part n;
	short soap_flag = 0;
	do
	{	if (tag && *tag != '-')
			soap_revert(soap);
		n.soap_default(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_wsdl__part, SOAP_TYPE_std__vectorTemplateOfwsdl__part, sizeof(wsdl__part), 0))
				break;
			if (!soap_in_wsdl__part(soap, tag, NULL, "wsdl:part"))
				break;
		}
		else
		{
			if (!soap_in_wsdl__part(soap, tag, &n, "wsdl:part"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (tag && *tag != '-' && !soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC1 std::vector<wsdl__part > * SOAP_FMAC2 soap_instantiate_std__vectorTemplateOfwsdl__part(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfwsdl__part(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfwsdl__part, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(std::vector<wsdl__part >);
		if (size)
			*size = sizeof(std::vector<wsdl__part >);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(std::vector<wsdl__part >[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<wsdl__part >);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<wsdl__part >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfwsdl__part(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<wsdl__part > %p -> %p\n", q, p));
	*(std::vector<wsdl__part >*)p = *(std::vector<wsdl__part >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfwsp__PolicyReference(struct soap *soap, std::vector<wsp__PolicyReference >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfwsp__PolicyReference(struct soap *soap, const std::vector<wsp__PolicyReference >*a)
{
	for (std::vector<wsp__PolicyReference >::const_iterator i = a->begin(); i != a->end(); ++i)
		(*i).soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfwsp__PolicyReference(struct soap *soap, const char *tag, int id, const std::vector<wsp__PolicyReference >*a, const char *type)
{
	for (std::vector<wsp__PolicyReference >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if ((*i).soap_out(soap, tag, id, ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<wsp__PolicyReference >* SOAP_FMAC4 soap_in_std__vectorTemplateOfwsp__PolicyReference(struct soap *soap, const char *tag, std::vector<wsp__PolicyReference >*a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfwsp__PolicyReference(soap, -1)))
		return NULL;
	wsp__PolicyReference n;
	short soap_flag = 0;
	do
	{	if (tag && *tag != '-')
			soap_revert(soap);
		n.soap_default(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_wsp__PolicyReference, SOAP_TYPE_std__vectorTemplateOfwsp__PolicyReference, sizeof(wsp__PolicyReference), 0))
				break;
			if (!soap_in_wsp__PolicyReference(soap, tag, NULL, "wsp:PolicyReference"))
				break;
		}
		else
		{
			if (!soap_in_wsp__PolicyReference(soap, tag, &n, "wsp:PolicyReference"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (tag && *tag != '-' && !soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC1 std::vector<wsp__PolicyReference > * SOAP_FMAC2 soap_instantiate_std__vectorTemplateOfwsp__PolicyReference(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfwsp__PolicyReference(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfwsp__PolicyReference, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(std::vector<wsp__PolicyReference >);
		if (size)
			*size = sizeof(std::vector<wsp__PolicyReference >);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(std::vector<wsp__PolicyReference >[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<wsp__PolicyReference >);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<wsp__PolicyReference >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfwsp__PolicyReference(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<wsp__PolicyReference > %p -> %p\n", q, p));
	*(std::vector<wsp__PolicyReference >*)p = *(std::vector<wsp__PolicyReference >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfwsp__Policy(struct soap *soap, std::vector<wsp__Policy >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfwsp__Policy(struct soap *soap, const std::vector<wsp__Policy >*a)
{
	for (std::vector<wsp__Policy >::const_iterator i = a->begin(); i != a->end(); ++i)
		(*i).soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfwsp__Policy(struct soap *soap, const char *tag, int id, const std::vector<wsp__Policy >*a, const char *type)
{
	for (std::vector<wsp__Policy >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if ((*i).soap_out(soap, tag, id, ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<wsp__Policy >* SOAP_FMAC4 soap_in_std__vectorTemplateOfwsp__Policy(struct soap *soap, const char *tag, std::vector<wsp__Policy >*a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfwsp__Policy(soap, -1)))
		return NULL;
	wsp__Policy n;
	short soap_flag = 0;
	do
	{	if (tag && *tag != '-')
			soap_revert(soap);
		n.soap_default(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_wsp__Policy, SOAP_TYPE_std__vectorTemplateOfwsp__Policy, sizeof(wsp__Policy), 0))
				break;
			if (!soap_in_wsp__Policy(soap, tag, NULL, "wsp:Policy"))
				break;
		}
		else
		{
			if (!soap_in_wsp__Policy(soap, tag, &n, "wsp:Policy"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (tag && *tag != '-' && !soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC1 std::vector<wsp__Policy > * SOAP_FMAC2 soap_instantiate_std__vectorTemplateOfwsp__Policy(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfwsp__Policy(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfwsp__Policy, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(std::vector<wsp__Policy >);
		if (size)
			*size = sizeof(std::vector<wsp__Policy >);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(std::vector<wsp__Policy >[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<wsp__Policy >);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<wsp__Policy >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfwsp__Policy(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<wsp__Policy > %p -> %p\n", q, p));
	*(std::vector<wsp__Policy >*)p = *(std::vector<wsp__Policy >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfPointerToxs__schema(struct soap *soap, std::vector<xs__schema * >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfPointerToxs__schema(struct soap *soap, const std::vector<xs__schema * >*a)
{
	for (std::vector<xs__schema * >::const_iterator i = a->begin(); i != a->end(); ++i)
		soap_serialize_PointerToxs__schema(soap, &(*i));
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfPointerToxs__schema(struct soap *soap, const char *tag, int id, const std::vector<xs__schema * >*a, const char *type)
{
	for (std::vector<xs__schema * >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_PointerToxs__schema(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<xs__schema * >* SOAP_FMAC4 soap_in_std__vectorTemplateOfPointerToxs__schema(struct soap *soap, const char *tag, std::vector<xs__schema * >*a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfPointerToxs__schema(soap, -1)))
		return NULL;
	xs__schema *n;
	short soap_flag = 0;
	do
	{	if (tag && *tag != '-')
			soap_revert(soap);
		n = NULL;
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_xs__schema, SOAP_TYPE_std__vectorTemplateOfPointerToxs__schema, sizeof(xs__schema), 1))
				break;
			if (!soap_in_PointerToxs__schema(soap, tag, NULL, "xs:schema"))
				break;
		}
		else
		{
			if (!soap_in_PointerToxs__schema(soap, tag, &n, "xs:schema"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (tag && *tag != '-' && !soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC1 std::vector<xs__schema * > * SOAP_FMAC2 soap_instantiate_std__vectorTemplateOfPointerToxs__schema(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfPointerToxs__schema(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfPointerToxs__schema, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(std::vector<xs__schema * >);
		if (size)
			*size = sizeof(std::vector<xs__schema * >);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(std::vector<xs__schema * >[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<xs__schema * >);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<xs__schema * >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfPointerToxs__schema(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<xs__schema * > %p -> %p\n", q, p));
	*(std::vector<xs__schema * >*)p = *(std::vector<xs__schema * >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfwsp__Attachment(struct soap *soap, std::vector<wsp__Attachment >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfwsp__Attachment(struct soap *soap, const std::vector<wsp__Attachment >*a)
{
	for (std::vector<wsp__Attachment >::const_iterator i = a->begin(); i != a->end(); ++i)
		(*i).soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfwsp__Attachment(struct soap *soap, const char *tag, int id, const std::vector<wsp__Attachment >*a, const char *type)
{
	for (std::vector<wsp__Attachment >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if ((*i).soap_out(soap, tag, id, ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<wsp__Attachment >* SOAP_FMAC4 soap_in_std__vectorTemplateOfwsp__Attachment(struct soap *soap, const char *tag, std::vector<wsp__Attachment >*a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfwsp__Attachment(soap, -1)))
		return NULL;
	wsp__Attachment n;
	short soap_flag = 0;
	do
	{	if (tag && *tag != '-')
			soap_revert(soap);
		n.soap_default(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_wsp__Attachment, SOAP_TYPE_std__vectorTemplateOfwsp__Attachment, sizeof(wsp__Attachment), 0))
				break;
			if (!soap_in_wsp__Attachment(soap, tag, NULL, "wsp:Attachment"))
				break;
		}
		else
		{
			if (!soap_in_wsp__Attachment(soap, tag, &n, "wsp:Attachment"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (tag && *tag != '-' && !soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC1 std::vector<wsp__Attachment > * SOAP_FMAC2 soap_instantiate_std__vectorTemplateOfwsp__Attachment(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfwsp__Attachment(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfwsp__Attachment, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(std::vector<wsp__Attachment >);
		if (size)
			*size = sizeof(std::vector<wsp__Attachment >);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(std::vector<wsp__Attachment >[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<wsp__Attachment >);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<wsp__Attachment >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfwsp__Attachment(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<wsp__Attachment > %p -> %p\n", q, p));
	*(std::vector<wsp__Attachment >*)p = *(std::vector<wsp__Attachment >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOf_XML(struct soap *soap, std::vector<char * >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOf_XML(struct soap *soap, const std::vector<char * >*a)
{
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOf_XML(struct soap *soap, const char *tag, int id, const std::vector<char * >*a, const char *type)
{
	for (std::vector<char * >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_outliteral(soap, tag, &(*i), NULL))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<char * >* SOAP_FMAC4 soap_in_std__vectorTemplateOf_XML(struct soap *soap, const char *tag, std::vector<char * >*a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOf_XML(soap, -1)))
		return NULL;
	char *n;
	short soap_flag = 0;
	do
	{	if (tag && *tag != '-')
			soap_revert(soap);
		n = NULL;
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE__XML, SOAP_TYPE_std__vectorTemplateOf_XML, sizeof(char *), 1))
				break;
			if (!soap_inliteral(soap, tag, NULL))
				break;
		}
		else
		{
			if (!soap_inliteral(soap, tag, &n))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (tag && *tag != '-' && !soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC1 std::vector<char * > * SOAP_FMAC2 soap_instantiate_std__vectorTemplateOf_XML(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOf_XML(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOf_XML, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(std::vector<char * >);
		if (size)
			*size = sizeof(std::vector<char * >);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(std::vector<char * >[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<char * >);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<char * >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOf_XML(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<char * > %p -> %p\n", q, p));
	*(std::vector<char * >*)p = *(std::vector<char * >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfsp__Parts(struct soap *soap, std::vector<sp__Parts >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfsp__Parts(struct soap *soap, const std::vector<sp__Parts >*a)
{
	for (std::vector<sp__Parts >::const_iterator i = a->begin(); i != a->end(); ++i)
		(*i).soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfsp__Parts(struct soap *soap, const char *tag, int id, const std::vector<sp__Parts >*a, const char *type)
{
	for (std::vector<sp__Parts >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if ((*i).soap_out(soap, tag, id, ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<sp__Parts >* SOAP_FMAC4 soap_in_std__vectorTemplateOfsp__Parts(struct soap *soap, const char *tag, std::vector<sp__Parts >*a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfsp__Parts(soap, -1)))
		return NULL;
	sp__Parts n;
	short soap_flag = 0;
	do
	{	if (tag && *tag != '-')
			soap_revert(soap);
		n.soap_default(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_sp__Parts, SOAP_TYPE_std__vectorTemplateOfsp__Parts, sizeof(sp__Parts), 0))
				break;
			if (!soap_in_sp__Parts(soap, tag, NULL, "sp:Parts"))
				break;
		}
		else
		{
			if (!soap_in_sp__Parts(soap, tag, &n, "sp:Parts"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (tag && *tag != '-' && !soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC1 std::vector<sp__Parts > * SOAP_FMAC2 soap_instantiate_std__vectorTemplateOfsp__Parts(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfsp__Parts(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfsp__Parts, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(std::vector<sp__Parts >);
		if (size)
			*size = sizeof(std::vector<sp__Parts >);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(std::vector<sp__Parts >[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<sp__Parts >);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<sp__Parts >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfsp__Parts(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<sp__Parts > %p -> %p\n", q, p));
	*(std::vector<sp__Parts >*)p = *(std::vector<sp__Parts >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfPointerTowsp__Content(struct soap *soap, std::vector<wsp__Content * >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfPointerTowsp__Content(struct soap *soap, const std::vector<wsp__Content * >*a)
{
	for (std::vector<wsp__Content * >::const_iterator i = a->begin(); i != a->end(); ++i)
		soap_serialize_PointerTowsp__Content(soap, &(*i));
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfPointerTowsp__Content(struct soap *soap, const char *tag, int id, const std::vector<wsp__Content * >*a, const char *type)
{
	for (std::vector<wsp__Content * >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_PointerTowsp__Content(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<wsp__Content * >* SOAP_FMAC4 soap_in_std__vectorTemplateOfPointerTowsp__Content(struct soap *soap, const char *tag, std::vector<wsp__Content * >*a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfPointerTowsp__Content(soap, -1)))
		return NULL;
	wsp__Content *n;
	short soap_flag = 0;
	do
	{	if (tag && *tag != '-')
			soap_revert(soap);
		n = NULL;
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_wsp__Content, SOAP_TYPE_std__vectorTemplateOfPointerTowsp__Content, sizeof(wsp__Content), 1))
				break;
			if (!soap_in_PointerTowsp__Content(soap, tag, NULL, "wsp:Content"))
				break;
		}
		else
		{
			if (!soap_in_PointerTowsp__Content(soap, tag, &n, "wsp:Content"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (tag && *tag != '-' && !soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC1 std::vector<wsp__Content * > * SOAP_FMAC2 soap_instantiate_std__vectorTemplateOfPointerTowsp__Content(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfPointerTowsp__Content(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfPointerTowsp__Content, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(std::vector<wsp__Content * >);
		if (size)
			*size = sizeof(std::vector<wsp__Content * >);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(std::vector<wsp__Content * >[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<wsp__Content * >);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<wsp__Content * >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfPointerTowsp__Content(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<wsp__Content * > %p -> %p\n", q, p));
	*(std::vector<wsp__Content * >*)p = *(std::vector<wsp__Content * >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfxsd__string(struct soap *soap, std::vector<char * >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfxsd__string(struct soap *soap, const std::vector<char * >*a)
{
	for (std::vector<char * >::const_iterator i = a->begin(); i != a->end(); ++i)
		soap_serialize_xsd__string(soap, &(*i));
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfxsd__string(struct soap *soap, const char *tag, int id, const std::vector<char * >*a, const char *type)
{
	for (std::vector<char * >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_xsd__string(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<char * >* SOAP_FMAC4 soap_in_std__vectorTemplateOfxsd__string(struct soap *soap, const char *tag, std::vector<char * >*a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfxsd__string(soap, -1)))
		return NULL;
	char *n;
	short soap_flag = 0;
	do
	{	if (tag && *tag != '-')
			soap_revert(soap);
		n = NULL;
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_xsd__string, SOAP_TYPE_std__vectorTemplateOfxsd__string, sizeof(char *), 1))
				break;
			if (!soap_in_xsd__string(soap, tag, NULL, "xsd:string"))
				break;
		}
		else
		{
			if (!soap_in_xsd__string(soap, tag, &n, "xsd:string"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (tag && *tag != '-' && !soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC1 std::vector<char * > * SOAP_FMAC2 soap_instantiate_std__vectorTemplateOfxsd__string(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfxsd__string(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfxsd__string, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(std::vector<char * >);
		if (size)
			*size = sizeof(std::vector<char * >);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(std::vector<char * >[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<char * >);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<char * >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfxsd__string(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<char * > %p -> %p\n", q, p));
	*(std::vector<char * >*)p = *(std::vector<char * >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfsp__Header(struct soap *soap, std::vector<sp__Header >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfsp__Header(struct soap *soap, const std::vector<sp__Header >*a)
{
	for (std::vector<sp__Header >::const_iterator i = a->begin(); i != a->end(); ++i)
		(*i).soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfsp__Header(struct soap *soap, const char *tag, int id, const std::vector<sp__Header >*a, const char *type)
{
	for (std::vector<sp__Header >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if ((*i).soap_out(soap, tag, id, ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<sp__Header >* SOAP_FMAC4 soap_in_std__vectorTemplateOfsp__Header(struct soap *soap, const char *tag, std::vector<sp__Header >*a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfsp__Header(soap, -1)))
		return NULL;
	sp__Header n;
	short soap_flag = 0;
	do
	{	if (tag && *tag != '-')
			soap_revert(soap);
		n.soap_default(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_sp__Header, SOAP_TYPE_std__vectorTemplateOfsp__Header, sizeof(sp__Header), 0))
				break;
			if (!soap_in_sp__Header(soap, tag, NULL, "sp:Header"))
				break;
		}
		else
		{
			if (!soap_in_sp__Header(soap, tag, &n, "sp:Header"))
				break;
		}
		a->push_back(n);
		soap_flag = 1;
	}
	while (tag && *tag != '-' && !soap_element_begin_in(soap, tag, 1, NULL));
	if (soap_flag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC1 std::vector<sp__Header > * SOAP_FMAC2 soap_instantiate_std__vectorTemplateOfsp__Header(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfsp__Header(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfsp__Header, n, wsdl_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(std::vector<sp__Header >);
		if (size)
			*size = sizeof(std::vector<sp__Header >);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(std::vector<sp__Header >[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::vector<sp__Header >);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<sp__Header >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfsp__Header(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<sp__Header > %p -> %p\n", q, p));
	*(std::vector<sp__Header >*)p = *(std::vector<sp__Header >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfsd__serviceData(struct soap *soap, std::vector<sd__serviceData >*p)
{
	p->clear();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfsd__serviceData(struct soap *soap, const std::vector<sd__serviceData >*a)
{
	for (std::vector<sd__serviceData >::const_iterator i = a->begin(); i != a->end(); ++i)
		(*i).soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfsd__serviceData(struct soap *soap, const char *tag, int id, const std::vector<sd__serviceData >*a, const char *type)
{
	for (std::vector<sd__serviceData >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if ((*i).soap_out(soap, tag, id, ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<sd__serviceData >* SOAP_FMAC4 soap_in_std__vectorTemplateOfsd__serviceData(struct soap *soap, const char *tag, std::vector<sd__serviceData >*a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfsd__serviceData(soap, -1)))
		return NULL;
	sd__serviceData n;
	short soap_flag = 0;
	do
	{	if (tag && *tag != '-')
			soap_revert(soap);
		n.soap_defaul