#!/usr/bin/python
#
# Copyright 2009 Martin Owens
#
# This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>
#
"""Add an SSH key to your launchpad user account."""

# Import standard python libs
import sys
import os
from GroundControl.launchpadweb import LaunchpadWeb
from GroundControl.launchpad import EDGE_WEB_ROOT

if __name__ == '__main__':
    myself = LaunchpadWeb(root=EDGE_WEB_ROOT)
    filename = sys.argv[-1]
    if os.path.exists(filename):
        fh = open(filename, "r")
        fkey = fh.readline()
        fh.close()
        myself.addSshKey(fkey)
    sys.exit(0)
