/**
 * Copyright 2003-2015 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package groovy.util;

import org.xml.sax.SAXException;

import javax.xml.parsers.ParserConfigurationException;
import java.util.Map;

class CustomXmlParser extends XmlParser {
    CustomXmlParser() throws ParserConfigurationException, SAXException {
        super();
    }

    protected Object getElementName(String s, String s1, String s2) {
        return new Integer(42);
    }

    protected Node createNode(Node parent, Object name, Map attributes) {
        return new CustomNode(parent, name, attributes, new NodeList());
    }
}