/* A Bison parser, made by GNU Bison 3.3.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2019 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Undocumented macros, especially those whose name start with YY_,
   are private implementation details.  Do not rely on them.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.3.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 7 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:337  */

#undef PARSER_DEBUG
#ifdef PARSER_DEBUG
# define YYDEBUG 1
#endif
#define YYERROR_VERBOSE 1
#define YYSTACK_USE_ALLOCA 1

#include <ctype.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <mruby.h>
#include <mruby/compile.h>
#include <mruby/proc.h>
#include <mruby/error.h>
#include <mruby/throw.h>
#include <mruby/string.h>
#include "node.h"

#define YYLEX_PARAM p

typedef mrb_ast_node node;
typedef struct mrb_parser_state parser_state;
typedef struct mrb_parser_heredoc_info parser_heredoc_info;

static int yyparse(parser_state *p);
static int yylex(void *lval, parser_state *p);
static void yyerror(parser_state *p, const char *s);
static void yywarn(parser_state *p, const char *s);
static void yywarning(parser_state *p, const char *s);
static void backref_error(parser_state *p, node *n);
static void void_expr_error(parser_state *p, node *n);
static void tokadd(parser_state *p, int32_t c);

#define identchar(c) (ISALNUM(c) || (c) == '_' || !ISASCII(c))

typedef unsigned int stack_type;

#define BITSTACK_PUSH(stack, n) ((stack) = ((stack)<<1)|((n)&1))
#define BITSTACK_POP(stack)     ((stack) = (stack) >> 1)
#define BITSTACK_LEXPOP(stack)  ((stack) = ((stack) >> 1) | ((stack) & 1))
#define BITSTACK_SET_P(stack)   ((stack)&1)

#define COND_PUSH(n)    BITSTACK_PUSH(p->cond_stack, (n))
#define COND_POP()      BITSTACK_POP(p->cond_stack)
#define COND_LEXPOP()   BITSTACK_LEXPOP(p->cond_stack)
#define COND_P()        BITSTACK_SET_P(p->cond_stack)

#define CMDARG_PUSH(n)  BITSTACK_PUSH(p->cmdarg_stack, (n))
#define CMDARG_POP()    BITSTACK_POP(p->cmdarg_stack)
#define CMDARG_LEXPOP() BITSTACK_LEXPOP(p->cmdarg_stack)
#define CMDARG_P()      BITSTACK_SET_P(p->cmdarg_stack)

#define SET_LINENO(c,n) ((c)->lineno = (n))
#define NODE_LINENO(c,n) do {\
  if (n) {\
     (c)->filename_index = (n)->filename_index;\
     (c)->lineno = (n)->lineno;\
  }\
} while (0)

#define sym(x) ((mrb_sym)(intptr_t)(x))
#define nsym(x) ((node*)(intptr_t)(x))
#define nint(x) ((node*)(intptr_t)(x))
#define intn(x) ((int)(intptr_t)(x))

#define NUM_SUFFIX_R   (1<<0)
#define NUM_SUFFIX_I   (1<<1)

static inline mrb_sym
intern_cstr_gen(parser_state *p, const char *s)
{
  return mrb_intern_cstr(p->mrb, s);
}
#define intern_cstr(s) intern_cstr_gen(p,(s))

static inline mrb_sym
intern_gen(parser_state *p, const char *s, size_t len)
{
  return mrb_intern(p->mrb, s, len);
}
#define intern(s,len) intern_gen(p,(s),(len))

#define intern_lit(s) mrb_intern_lit(p->mrb, s)

static void
cons_free_gen(parser_state *p, node *cons)
{
  cons->cdr = p->cells;
  p->cells = cons;
}
#define cons_free(c) cons_free_gen(p, (c))

static void*
parser_palloc(parser_state *p, size_t size)
{
  void *m = mrb_pool_alloc(p->pool, size);

  if (!m) {
    MRB_THROW(p->jmp);
  }
  return m;
}

static node*
cons_gen(parser_state *p, node *car, node *cdr)
{
  node *c;

  if (p->cells) {
    c = p->cells;
    p->cells = p->cells->cdr;
  }
  else {
    c = (node *)parser_palloc(p, sizeof(mrb_ast_node));
  }

  c->car = car;
  c->cdr = cdr;
  c->lineno = p->lineno;
  c->filename_index = p->current_filename_index;
  /* beginning of next partial file; need to point the previous file */
  if (p->lineno == 0 && p->current_filename_index > 0) {
    c->filename_index-- ;
  }
  return c;
}
#define cons(a,b) cons_gen(p,(a),(b))

static node*
list1_gen(parser_state *p, node *a)
{
  return cons(a, 0);
}
#define list1(a) list1_gen(p, (a))

static node*
list2_gen(parser_state *p, node *a, node *b)
{
  return cons(a, cons(b,0));
}
#define list2(a,b) list2_gen(p, (a),(b))

static node*
list3_gen(parser_state *p, node *a, node *b, node *c)
{
  return cons(a, cons(b, cons(c,0)));
}
#define list3(a,b,c) list3_gen(p, (a),(b),(c))

static node*
list4_gen(parser_state *p, node *a, node *b, node *c, node *d)
{
  return cons(a, cons(b, cons(c, cons(d, 0))));
}
#define list4(a,b,c,d) list4_gen(p, (a),(b),(c),(d))

static node*
list5_gen(parser_state *p, node *a, node *b, node *c, node *d, node *e)
{
  return cons(a, cons(b, cons(c, cons(d, cons(e, 0)))));
}
#define list5(a,b,c,d,e) list5_gen(p, (a),(b),(c),(d),(e))

static node*
list6_gen(parser_state *p, node *a, node *b, node *c, node *d, node *e, node *f)
{
  return cons(a, cons(b, cons(c, cons(d, cons(e, cons(f, 0))))));
}
#define list6(a,b,c,d,e,f) list6_gen(p, (a),(b),(c),(d),(e),(f))

static node*
append_gen(parser_state *p, node *a, node *b)
{
  node *c = a;

  if (!a) return b;
  if (!b) return a;
  while (c->cdr) {
    c = c->cdr;
  }
  c->cdr = b;
  return a;
}
#define append(a,b) append_gen(p,(a),(b))
#define push(a,b) append_gen(p,(a),list1(b))

static char*
parser_strndup(parser_state *p, const char *s, size_t len)
{
  char *b = (char *)parser_palloc(p, len+1);

  memcpy(b, s, len);
  b[len] = '\0';
  return b;
}
#undef strndup
#define strndup(s,len) parser_strndup(p, s, len)

static char*
parser_strdup(parser_state *p, const char *s)
{
  return parser_strndup(p, s, strlen(s));
}
#undef strdup
#define strdup(s) parser_strdup(p, s)

static void
dump_int(uint16_t i, char *s)
{
  char *p = s;
  char *t = s;

  while (i > 0) {
    *p++ = (i % 10)+'0';
    i /= 10;
  }
  if (p == s) *p++ = '0';
  *p = 0;
  p--;  /* point the last char */
  while (t < p) {
    char c = *t;
    *t++ = *p;
    *p-- = c;
  }
}

/* xxx ----------------------------- */

static node*
local_switch(parser_state *p)
{
  node *prev = p->locals;

  p->locals = cons(0, 0);
  return prev;
}

static void
local_resume(parser_state *p, node *prev)
{
  p->locals = prev;
}

static void
local_nest(parser_state *p)
{
  p->locals = cons(0, p->locals);
}

static void
local_unnest(parser_state *p)
{
  if (p->locals) {
    p->locals = p->locals->cdr;
  }
}

static mrb_bool
local_var_p(parser_state *p, mrb_sym sym)
{
  node *l = p->locals;

  while (l) {
    node *n = l->car;
    while (n) {
      if (sym(n->car) == sym) return TRUE;
      n = n->cdr;
    }
    l = l->cdr;
  }
  return FALSE;
}

static void
local_add_f(parser_state *p, mrb_sym sym)
{
  if (p->locals) {
    p->locals->car = push(p->locals->car, nsym(sym));
  }
}

static void
local_add(parser_state *p, mrb_sym sym)
{
  if (!local_var_p(p, sym)) {
    local_add_f(p, sym);
  }
}

static void
local_add_blk(parser_state *p, mrb_sym blk)
{
  /* allocate register for block */
  local_add_f(p, blk ? blk : mrb_intern_lit(p->mrb, "&"));
}

static void
local_add_kw(parser_state *p, mrb_sym kwd)
{
  /* allocate register for keywords hash */
  local_add_f(p, kwd ? kwd : mrb_intern_lit(p->mrb, "**"));
}

static node*
locals_node(parser_state *p)
{
  return p->locals ? p->locals->car : NULL;
}

static void
nvars_nest(parser_state *p)
{
  p->nvars = cons(nint(0), p->nvars);
}

static void
nvars_block(parser_state *p)
{
  p->nvars = cons(nint(-2), p->nvars);
}

static void
nvars_unnest(parser_state *p)
{
  p->nvars = p->nvars->cdr;
}

/* (:scope (vars..) (prog...)) */
static node*
new_scope(parser_state *p, node *body)
{
  return cons((node*)NODE_SCOPE, cons(locals_node(p), body));
}

/* (:begin prog...) */
static node*
new_begin(parser_state *p, node *body)
{
  if (body) {
    return list2((node*)NODE_BEGIN, body);
  }
  return cons((node*)NODE_BEGIN, 0);
}

#define newline_node(n) (n)

/* (:rescue body rescue else) */
static node*
new_rescue(parser_state *p, node *body, node *resq, node *els)
{
  return list4((node*)NODE_RESCUE, body, resq, els);
}

static node*
new_mod_rescue(parser_state *p, node *body, node *resq)
{
  return new_rescue(p, body, list1(list3(0, 0, resq)), 0);
}

/* (:ensure body ensure) */
static node*
new_ensure(parser_state *p, node *a, node *b)
{
  return cons((node*)NODE_ENSURE, cons(a, cons(0, b)));
}

/* (:nil) */
static node*
new_nil(parser_state *p)
{
  return list1((node*)NODE_NIL);
}

/* (:true) */
static node*
new_true(parser_state *p)
{
  return list1((node*)NODE_TRUE);
}

/* (:false) */
static node*
new_false(parser_state *p)
{
  return list1((node*)NODE_FALSE);
}

/* (:alias new old) */
static node*
new_alias(parser_state *p, mrb_sym a, mrb_sym b)
{
  return cons((node*)NODE_ALIAS, cons(nsym(a), nsym(b)));
}

/* (:if cond then else) */
static node*
new_if(parser_state *p, node *a, node *b, node *c)
{
  void_expr_error(p, a);
  return list4((node*)NODE_IF, a, b, c);
}

/* (:unless cond then else) */
static node*
new_unless(parser_state *p, node *a, node *b, node *c)
{
  void_expr_error(p, a);
  return list4((node*)NODE_IF, a, c, b);
}

/* (:while cond body) */
static node*
new_while(parser_state *p, node *a, node *b)
{
  void_expr_error(p, a);
  return cons((node*)NODE_WHILE, cons(a, b));
}

/* (:until cond body) */
static node*
new_until(parser_state *p, node *a, node *b)
{
  void_expr_error(p, a);
  return cons((node*)NODE_UNTIL, cons(a, b));
}

/* (:for var obj body) */
static node*
new_for(parser_state *p, node *v, node *o, node *b)
{
  void_expr_error(p, o);
  return list4((node*)NODE_FOR, v, o, b);
}

/* (:case a ((when ...) body) ((when...) body)) */
static node*
new_case(parser_state *p, node *a, node *b)
{
  node *n = list2((node*)NODE_CASE, a);
  node *n2 = n;

  void_expr_error(p, a);
  while (n2->cdr) {
    n2 = n2->cdr;
  }
  n2->cdr = b;
  return n;
}

/* (:postexe a) */
static node*
new_postexe(parser_state *p, node *a)
{
  return cons((node*)NODE_POSTEXE, a);
}

/* (:self) */
static node*
new_self(parser_state *p)
{
  return list1((node*)NODE_SELF);
}

/* (:call a b c) */
static node*
new_call(parser_state *p, node *a, mrb_sym b, node *c, int pass)
{
  node *n = list4(nint(pass?NODE_CALL:NODE_SCALL), a, nsym(b), c);
  void_expr_error(p, a);
  NODE_LINENO(n, a);
  return n;
}

/* (:fcall self mid args) */
static node*
new_fcall(parser_state *p, mrb_sym b, node *c)
{
  node *n = new_self(p);
  NODE_LINENO(n, c);
  n = list4((node*)NODE_FCALL, n, nsym(b), c);
  NODE_LINENO(n, c);
  return n;
}

/* (:super . c) */
static node*
new_super(parser_state *p, node *c)
{
  return cons((node*)NODE_SUPER, c);
}

/* (:zsuper) */
static node*
new_zsuper(parser_state *p)
{
  return list1((node*)NODE_ZSUPER);
}

/* (:yield . c) */
static node*
new_yield(parser_state *p, node *c)
{
  if (c) {
    if (c->cdr) {
      yyerror(p, "both block arg and actual block given");
    }
    return cons((node*)NODE_YIELD, c->car);
  }
  return cons((node*)NODE_YIELD, 0);
}

/* (:return . c) */
static node*
new_return(parser_state *p, node *c)
{
  return cons((node*)NODE_RETURN, c);
}

/* (:break . c) */
static node*
new_break(parser_state *p, node *c)
{
  return cons((node*)NODE_BREAK, c);
}

/* (:next . c) */
static node*
new_next(parser_state *p, node *c)
{
  return cons((node*)NODE_NEXT, c);
}

/* (:redo) */
static node*
new_redo(parser_state *p)
{
  return list1((node*)NODE_REDO);
}

/* (:retry) */
static node*
new_retry(parser_state *p)
{
  return list1((node*)NODE_RETRY);
}

/* (:dot2 a b) */
static node*
new_dot2(parser_state *p, node *a, node *b)
{
  return cons((node*)NODE_DOT2, cons(a, b));
}

/* (:dot3 a b) */
static node*
new_dot3(parser_state *p, node *a, node *b)
{
  return cons((node*)NODE_DOT3, cons(a, b));
}

/* (:colon2 b c) */
static node*
new_colon2(parser_state *p, node *b, mrb_sym c)
{
  void_expr_error(p, b);
  return cons((node*)NODE_COLON2, cons(b, nsym(c)));
}

/* (:colon3 . c) */
static node*
new_colon3(parser_state *p, mrb_sym c)
{
  return cons((node*)NODE_COLON3, nsym(c));
}

/* (:and a b) */
static node*
new_and(parser_state *p, node *a, node *b)
{
  return cons((node*)NODE_AND, cons(a, b));
}

/* (:or a b) */
static node*
new_or(parser_state *p, node *a, node *b)
{
  return cons((node*)NODE_OR, cons(a, b));
}

/* (:array a...) */
static node*
new_array(parser_state *p, node *a)
{
  return cons((node*)NODE_ARRAY, a);
}

/* (:splat . a) */
static node*
new_splat(parser_state *p, node *a)
{
  return cons((node*)NODE_SPLAT, a);
}

/* (:hash (k . v) (k . v)...) */
static node*
new_hash(parser_state *p, node *a)
{
  return cons((node*)NODE_HASH, a);
}

/* (:kw_hash (k . v) (k . v)...) */
static node*
new_kw_hash(parser_state *p, node *a)
{
  return cons((node*)NODE_KW_HASH, a);
}

/* (:sym . a) */
static node*
new_sym(parser_state *p, mrb_sym sym)
{
  return cons((node*)NODE_SYM, nsym(sym));
}

static mrb_sym
new_strsym(parser_state *p, node* str)
{
  const char *s = (const char*)str->cdr->car;
  size_t len = (size_t)str->cdr->cdr;

  return mrb_intern(p->mrb, s, len);
}

/* (:lvar . a) */
static node*
new_lvar(parser_state *p, mrb_sym sym)
{
  return cons((node*)NODE_LVAR, nsym(sym));
}

/* (:gvar . a) */
static node*
new_gvar(parser_state *p, mrb_sym sym)
{
  return cons((node*)NODE_GVAR, nsym(sym));
}

/* (:ivar . a) */
static node*
new_ivar(parser_state *p, mrb_sym sym)
{
  return cons((node*)NODE_IVAR, nsym(sym));
}

/* (:cvar . a) */
static node*
new_cvar(parser_state *p, mrb_sym sym)
{
  return cons((node*)NODE_CVAR, nsym(sym));
}

/* (:nvar . a) */
static node*
new_nvar(parser_state *p, int num)
{
  int nvars = intn(p->nvars->car);

  p->nvars->car = nint(nvars > num ? nvars : num);
  return cons((node*)NODE_NVAR, nint(num));
}

/* (:const . a) */
static node*
new_const(parser_state *p, mrb_sym sym)
{
  return cons((node*)NODE_CONST, nsym(sym));
}

/* (:undef a...) */
static node*
new_undef(parser_state *p, mrb_sym sym)
{
  return list2((node*)NODE_UNDEF, nsym(sym));
}

/* (:class class super body) */
static node*
new_class(parser_state *p, node *c, node *s, node *b)
{
  void_expr_error(p, s);
  return list4((node*)NODE_CLASS, c, s, cons(locals_node(p), b));
}

/* (:sclass obj body) */
static node*
new_sclass(parser_state *p, node *o, node *b)
{
  void_expr_error(p, o);
  return list3((node*)NODE_SCLASS, o, cons(locals_node(p), b));
}

/* (:module module body) */
static node*
new_module(parser_state *p, node *m, node *b)
{
  return list3((node*)NODE_MODULE, m, cons(locals_node(p), b));
}

/* (:def m lv (arg . body)) */
static node*
new_def(parser_state *p, mrb_sym m, node *a, node *b)
{
  return list5((node*)NODE_DEF, nsym(m), locals_node(p), a, b);
}

/* (:sdef obj m lv (arg . body)) */
static node*
new_sdef(parser_state *p, node *o, mrb_sym m, node *a, node *b)
{
  void_expr_error(p, o);
  return list6((node*)NODE_SDEF, o, nsym(m), locals_node(p), a, b);
}

/* (:arg . sym) */
static node*
new_arg(parser_state *p, mrb_sym sym)
{
  return cons((node*)NODE_ARG, nsym(sym));
}

static void
local_add_margs(parser_state *p, node *n)
{
  while (n) {
    if (n->car->car == (node*)NODE_MASGN) {
      node *t = n->car->cdr->cdr;

      n->car->cdr->cdr = NULL;
      while (t) {
        local_add_f(p, sym(t->car));
        t = t->cdr;
      }
      local_add_margs(p, n->car->cdr->car->car);
      local_add_margs(p, n->car->cdr->car->cdr->cdr->car);
    }
    n = n->cdr;
  }
}

static void
local_add_lv(parser_state *p, node *lv)
{
  while (lv) {
    local_add_f(p, sym(lv->car));
    lv = lv->cdr;
  }
}

/* (m o r m2 tail) */
/* m: (a b c) */
/* o: ((a . e1) (b . e2)) */
/* r: a */
/* m2: (a b c) */
/* b: a */
static node*
new_args(parser_state *p, node *m, node *opt, mrb_sym rest, node *m2, node *tail)
{
  node *n;

  local_add_margs(p, m);
  local_add_margs(p, m2);
  n = cons(m2, tail);
  n = cons(nsym(rest), n);
  n = cons(opt, n);
  while (opt) {
    /* opt: (sym . (opt . lv)) -> (sym . opt) */
    local_add_lv(p, opt->car->cdr->cdr);
    opt->car->cdr = opt->car->cdr->car;
    opt = opt->cdr;
  }
  return cons(m, n);
}

/* (:args_tail keywords rest_keywords_sym block_sym) */
static node*
new_args_tail(parser_state *p, node *kws, node *kwrest, mrb_sym blk)
{
  node *k;

  if (kws || kwrest) {
    local_add_kw(p, (kwrest && kwrest->cdr)? sym(kwrest->cdr) : 0);
  }

  local_add_blk(p, blk);

  /* allocate register for keywords arguments */
  /* order is for Proc#parameters */
  for (k = kws; k; k = k->cdr) {
    if (!k->car->cdr->cdr->car) { /* allocate required keywords */
      local_add_f(p, sym(k->car->cdr->car));
    }
  }
  for (k = kws; k; k = k->cdr) {
    if (k->car->cdr->cdr->car) { /* allocate keywords with default */
      local_add_lv(p, k->car->cdr->cdr->car->cdr);
      k->car->cdr->cdr->car = k->car->cdr->cdr->car->car;
      local_add_f(p, sym(k->car->cdr->car));
    }
  }

  return list4((node*)NODE_ARGS_TAIL, kws, kwrest, nsym(blk));
}

/* (:kw_arg kw_sym def_arg) */
static node*
new_kw_arg(parser_state *p, mrb_sym kw, node *def_arg)
{
  mrb_assert(kw);
  return list3((node*)NODE_KW_ARG, nsym(kw), def_arg);
}

/* (:block_arg . a) */
static node*
new_block_arg(parser_state *p, node *a)
{
  return cons((node*)NODE_BLOCK_ARG, a);
}

static node*
setup_numparams(parser_state *p, node *a)
{
  int nvars = intn(p->nvars->car);
  if (nvars > 0) {
    int i;
    mrb_sym sym;
    // m || opt || rest || tail
    if (a && (a->car || (a->cdr && a->cdr->car) || (a->cdr->cdr && a->cdr->cdr->car) || (a->cdr->cdr->cdr->cdr && a->cdr->cdr->cdr->cdr->car))) {
      yyerror(p, "ordinary parameter is defined");
    }
    else if (p->locals) {
      /* p->locals should not be NULL unless error happens before the point */
      node* args = 0;
      for (i = nvars; i > 0; i--) {
        char buf[3];

        buf[0] = '_';
        buf[1] = i+'0';
        buf[2] = '\0';
        sym = intern_cstr(buf);
        args = cons(new_arg(p, sym), args);
        p->locals->car = cons(nsym(sym), p->locals->car);
      }
      a = new_args(p, args, 0, 0, 0, 0);
    }
  }
  return a;
}

/* (:block arg body) */
static node*
new_block(parser_state *p, node *a, node *b)
{
  a = setup_numparams(p, a);
  return list4((node*)NODE_BLOCK, locals_node(p), a, b);
}

/* (:lambda arg body) */
static node*
new_lambda(parser_state *p, node *a, node *b)
{
  return list4((node*)NODE_LAMBDA, locals_node(p), a, b);
}

/* (:asgn lhs rhs) */
static node*
new_asgn(parser_state *p, node *a, node *b)
{
  void_expr_error(p, b);
  return cons((node*)NODE_ASGN, cons(a, b));
}

/* (:masgn mlhs=(pre rest post)  mrhs) */
static node*
new_masgn(parser_state *p, node *a, node *b)
{
  void_expr_error(p, b);
  return cons((node*)NODE_MASGN, cons(a, b));
}

/* (:masgn mlhs mrhs) no check */
static node*
new_masgn_param(parser_state *p, node *a, node *b)
{
  return cons((node*)NODE_MASGN, cons(a, b));
}

/* (:asgn lhs rhs) */
static node*
new_op_asgn(parser_state *p, node *a, mrb_sym op, node *b)
{
  void_expr_error(p, b);
  return list4((node*)NODE_OP_ASGN, a, nsym(op), b);
}

static node*
new_imaginary(parser_state *p, node *imaginary)
{
  return new_call(p, new_const(p, intern_lit("Kernel")), intern_lit("Complex"), list1(list2(list3((node*)NODE_INT, (node*)strdup("0"), nint(10)), imaginary)), 1);
}

static node*
new_rational(parser_state *p, node *rational)
{
  return new_call(p, new_const(p, intern_lit("Kernel")), intern_lit("Rational"), list1(list1(rational)), 1);
}

/* (:int . i) */
static node*
new_int(parser_state *p, const char *s, int base, int suffix)
{
  node* result = list3((node*)NODE_INT, (node*)strdup(s), nint(base));
  if (suffix & NUM_SUFFIX_R) {
    result = new_rational(p, result);
  }
  if (suffix & NUM_SUFFIX_I) {
    result = new_imaginary(p, result);
  }
  return result;
}

#ifndef MRB_WITHOUT_FLOAT
/* (:float . i) */
static node*
new_float(parser_state *p, const char *s, int suffix)
{
  node* result = cons((node*)NODE_FLOAT, (node*)strdup(s));
  if (suffix & NUM_SUFFIX_R) {
    result = new_rational(p, result);
  }
  if (suffix & NUM_SUFFIX_I) {
    result = new_imaginary(p, result);
  }
  return result;
}
#endif

/* (:str . (s . len)) */
static node*
new_str(parser_state *p, const char *s, size_t len)
{
  return cons((node*)NODE_STR, cons((node*)strndup(s, len), nint(len)));
}

/* (:dstr . a) */
static node*
new_dstr(parser_state *p, node *a)
{
  return cons((node*)NODE_DSTR, a);
}

static int
string_node_p(node *n)
{
  return (int)((enum node_type)(intptr_t)n->car == NODE_STR);
}

static node*
composite_string_node(parser_state *p, node *a, node *b)
{
  size_t newlen = (size_t)a->cdr + (size_t)b->cdr;
  char *str = (char*)mrb_pool_realloc(p->pool, a->car, (size_t)a->cdr + 1, newlen + 1);
  memcpy(str + (size_t)a->cdr, b->car, (size_t)b->cdr);
  str[newlen] = '\0';
  a->car = (node*)str;
  a->cdr = (node*)newlen;
  cons_free(b);
  return a;
}

static node*
concat_string(parser_state *p, node *a, node *b)
{
  if (string_node_p(a)) {
    if (string_node_p(b)) {
      /* a == NODE_STR && b == NODE_STR */
      composite_string_node(p, a->cdr, b->cdr);
      cons_free(b);
      return a;
    }
    else {
      /* a == NODE_STR && b == NODE_DSTR */

      if (string_node_p(b->cdr->car)) {
        /* a == NODE_STR && b->[NODE_STR, ...] */
        composite_string_node(p, a->cdr, b->cdr->car->cdr);
        cons_free(b->cdr->car);
        b->cdr->car = a;
        return b;
      }
    }
  }
  else {
    node *c; /* last node of a */
    for (c = a; c->cdr != NULL; c = c->cdr) ;

    if (string_node_p(b)) {
      /* a == NODE_DSTR && b == NODE_STR */
      if (string_node_p(c->car)) {
        /* a->[..., NODE_STR] && b == NODE_STR */
        composite_string_node(p, c->car->cdr, b->cdr);
        cons_free(b);
        return a;
      }

      push(a, b);
      return a;
    }
    else {
      /* a == NODE_DSTR && b == NODE_DSTR */
      if (string_node_p(c->car) && string_node_p(b->cdr->car)) {
        /* a->[..., NODE_STR] && b->[NODE_STR, ...] */
        node *d = b->cdr;
        cons_free(b);
        composite_string_node(p, c->car->cdr, d->car->cdr);
        cons_free(d->car);
        c->cdr = d->cdr;
        cons_free(d);
        return a;
      }
      else {
        c->cdr = b->cdr;
        cons_free(b);
        return a;
      }
    }
  }

  return new_dstr(p, list2(a, b));
}

/* (:str . (s . len)) */
static node*
new_xstr(parser_state *p, const char *s, int len)
{
  return cons((node*)NODE_XSTR, cons((node*)strndup(s, len), nint(len)));
}

/* (:xstr . a) */
static node*
new_dxstr(parser_state *p, node *a)
{
  return cons((node*)NODE_DXSTR, a);
}

/* (:dsym . a) */
static node*
new_dsym(parser_state *p, node *a)
{
  return cons((node*)NODE_DSYM, a);
}

/* (:regx . (s . (opt . enc))) */
static node*
new_regx(parser_state *p, const char *p1, const char* p2, const char* p3)
{
  return cons((node*)NODE_REGX, cons((node*)p1, cons((node*)p2, (node*)p3)));
}

/* (:dregx . (a . b)) */
static node*
new_dregx(parser_state *p, node *a, node *b)
{
  return cons((node*)NODE_DREGX, cons(a, b));
}

/* (:backref . n) */
static node*
new_back_ref(parser_state *p, int n)
{
  return cons((node*)NODE_BACK_REF, nint(n));
}

/* (:nthref . n) */
static node*
new_nth_ref(parser_state *p, int n)
{
  return cons((node*)NODE_NTH_REF, nint(n));
}

/* (:heredoc . a) */
static node*
new_heredoc(parser_state *p)
{
  parser_heredoc_info *inf = (parser_heredoc_info *)parser_palloc(p, sizeof(parser_heredoc_info));
  return cons((node*)NODE_HEREDOC, (node*)inf);
}

static void
new_bv(parser_state *p, mrb_sym id)
{
}

static node*
new_literal_delim(parser_state *p)
{
  return cons((node*)NODE_LITERAL_DELIM, 0);
}

/* (:words . a) */
static node*
new_words(parser_state *p, node *a)
{
  return cons((node*)NODE_WORDS, a);
}

/* (:symbols . a) */
static node*
new_symbols(parser_state *p, node *a)
{
  return cons((node*)NODE_SYMBOLS, a);
}

/* xxx ----------------------------- */

/* (:call a op) */
static node*
call_uni_op(parser_state *p, node *recv, const char *m)
{
  void_expr_error(p, recv);
  return new_call(p, recv, intern_cstr(m), 0, 1);
}

/* (:call a op b) */
static node*
call_bin_op(parser_state *p, node *recv, const char *m, node *arg1)
{
  return new_call(p, recv, intern_cstr(m), list1(list1(arg1)), 1);
}

static void
args_with_block(parser_state *p, node *a, node *b)
{
  if (b) {
    if (a->cdr) {
      yyerror(p, "both block arg and actual block given");
    }
    a->cdr = b;
  }
}

static void
call_with_block(parser_state *p, node *a, node *b)
{
  node *n;

  switch ((enum node_type)intn(a->car)) {
  case NODE_SUPER:
  case NODE_ZSUPER:
    if (!a->cdr) a->cdr = cons(0, b);
    else {
      args_with_block(p, a->cdr, b);
    }
    break;
  case NODE_CALL:
  case NODE_FCALL:
  case NODE_SCALL:
    n = a->cdr->cdr->cdr;
    if (!n->car) n->car = cons(0, b);
    else {
      args_with_block(p, n->car, b);
    }
    break;
  default:
    break;
  }
}

static node*
negate_lit(parser_state *p, node *n)
{
  return cons((node*)NODE_NEGATE, n);
}

static node*
cond(node *n)
{
  return n;
}

static node*
ret_args(parser_state *p, node *n)
{
  if (n->cdr) {
    yyerror(p, "block argument should not be given");
    return NULL;
  }
  if (!n->car->cdr) return n->car->car;
  return new_array(p, n->car);
}

static void
assignable(parser_state *p, node *lhs)
{
  if (intn(lhs->car) == NODE_LVAR) {
    local_add(p, sym(lhs->cdr));
  }
}

static node*
var_reference(parser_state *p, node *lhs)
{
  node *n;

  if (intn(lhs->car) == NODE_LVAR) {
    if (!local_var_p(p, sym(lhs->cdr))) {
      n = new_fcall(p, sym(lhs->cdr), 0);
      cons_free(lhs);
      return n;
    }
  }

  return lhs;
}

typedef enum mrb_string_type  string_type;

static node*
new_strterm(parser_state *p, string_type type, int term, int paren)
{
  return cons(nint(type), cons((node*)0, cons(nint(paren), nint(term))));
}

static void
end_strterm(parser_state *p)
{
  cons_free(p->lex_strterm->cdr->cdr);
  cons_free(p->lex_strterm->cdr);
  cons_free(p->lex_strterm);
  p->lex_strterm = NULL;
}

static parser_heredoc_info *
parsing_heredoc_inf(parser_state *p)
{
  node *nd = p->parsing_heredoc;
  if (nd == NULL)
    return NULL;
  /* mrb_assert(nd->car->car == NODE_HEREDOC); */
  return (parser_heredoc_info*)nd->car->cdr;
}

static void
heredoc_treat_nextline(parser_state *p)
{
  if (p->heredocs_from_nextline == NULL)
    return;
  if (p->parsing_heredoc == NULL) {
    node *n;
    p->parsing_heredoc = p->heredocs_from_nextline;
    p->lex_strterm_before_heredoc = p->lex_strterm;
    p->lex_strterm = new_strterm(p, parsing_heredoc_inf(p)->type, 0, 0);
    n = p->all_heredocs;
    if (n) {
      while (n->cdr)
        n = n->cdr;
      n->cdr = p->parsing_heredoc;
    }
    else {
      p->all_heredocs = p->parsing_heredoc;
    }
  }
  else {
    node *n, *m;
    m = p->heredocs_from_nextline;
    while (m->cdr)
      m = m->cdr;
    n = p->all_heredocs;
    mrb_assert(n != NULL);
    if (n == p->parsing_heredoc) {
      m->cdr = n;
      p->all_heredocs = p->heredocs_from_nextline;
      p->parsing_heredoc = p->heredocs_from_nextline;
    }
    else {
      while (n->cdr != p->parsing_heredoc) {
        n = n->cdr;
        mrb_assert(n != NULL);
      }
      m->cdr = n->cdr;
      n->cdr = p->heredocs_from_nextline;
      p->parsing_heredoc = p->heredocs_from_nextline;
    }
  }
  p->heredocs_from_nextline = NULL;
}

static void
heredoc_end(parser_state *p)
{
  p->parsing_heredoc = p->parsing_heredoc->cdr;
  if (p->parsing_heredoc == NULL) {
    p->lstate = EXPR_BEG;
    end_strterm(p);
    p->lex_strterm = p->lex_strterm_before_heredoc;
    p->lex_strterm_before_heredoc = NULL;
  }
  else {
    /* next heredoc */
    p->lex_strterm->car = nint(parsing_heredoc_inf(p)->type);
  }
}
#define is_strterm_type(p,str_func) (intn((p)->lex_strterm->car) & (str_func))

/* xxx ----------------------------- */


#line 1389 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:337  */
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif


/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token type.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    keyword_class = 258,
    keyword_module = 259,
    keyword_def = 260,
    keyword_begin = 261,
    keyword_if = 262,
    keyword_unless = 263,
    keyword_while = 264,
    keyword_until = 265,
    keyword_for = 266,
    keyword_undef = 267,
    keyword_rescue = 268,
    keyword_ensure = 269,
    keyword_end = 270,
    keyword_then = 271,
    keyword_elsif = 272,
    keyword_else = 273,
    keyword_case = 274,
    keyword_when = 275,
    keyword_break = 276,
    keyword_next = 277,
    keyword_redo = 278,
    keyword_retry = 279,
    keyword_in = 280,
    keyword_do = 281,
    keyword_do_cond = 282,
    keyword_do_block = 283,
    keyword_do_LAMBDA = 284,
    keyword_return = 285,
    keyword_yield = 286,
    keyword_super = 287,
    keyword_self = 288,
    keyword_nil = 289,
    keyword_true = 290,
    keyword_false = 291,
    keyword_and = 292,
    keyword_or = 293,
    keyword_not = 294,
    modifier_if = 295,
    modifier_unless = 296,
    modifier_while = 297,
    modifier_until = 298,
    modifier_rescue = 299,
    keyword_alias = 300,
    keyword_BEGIN = 301,
    keyword_END = 302,
    keyword__LINE__ = 303,
    keyword__FILE__ = 304,
    keyword__ENCODING__ = 305,
    tIDENTIFIER = 306,
    tFID = 307,
    tGVAR = 308,
    tIVAR = 309,
    tCONSTANT = 310,
    tCVAR = 311,
    tLABEL_TAG = 312,
    tINTEGER = 313,
    tFLOAT = 314,
    tCHAR = 315,
    tXSTRING = 316,
    tREGEXP = 317,
    tSTRING = 318,
    tSTRING_PART = 319,
    tSTRING_MID = 320,
    tNTH_REF = 321,
    tBACK_REF = 322,
    tREGEXP_END = 323,
    tNUMPARAM = 324,
    tUPLUS = 325,
    tUMINUS = 326,
    tPOW = 327,
    tCMP = 328,
    tEQ = 329,
    tEQQ = 330,
    tNEQ = 331,
    tGEQ = 332,
    tLEQ = 333,
    tANDOP = 334,
    tOROP = 335,
    tMATCH = 336,
    tNMATCH = 337,
    tDOT2 = 338,
    tDOT3 = 339,
    tAREF = 340,
    tASET = 341,
    tLSHFT = 342,
    tRSHFT = 343,
    tCOLON2 = 344,
    tCOLON3 = 345,
    tOP_ASGN = 346,
    tASSOC = 347,
    tLPAREN = 348,
    tLPAREN_ARG = 349,
    tRPAREN = 350,
    tLBRACK = 351,
    tLBRACE = 352,
    tLBRACE_ARG = 353,
    tSTAR = 354,
    tDSTAR = 355,
    tAMPER = 356,
    tLAMBDA = 357,
    tANDDOT = 358,
    tSYMBEG = 359,
    tREGEXP_BEG = 360,
    tWORDS_BEG = 361,
    tSYMBOLS_BEG = 362,
    tSTRING_BEG = 363,
    tXSTRING_BEG = 364,
    tSTRING_DVAR = 365,
    tLAMBEG = 366,
    tHEREDOC_BEG = 367,
    tHEREDOC_END = 368,
    tLITERAL_DELIM = 369,
    tHD_LITERAL_DELIM = 370,
    tHD_STRING_PART = 371,
    tHD_STRING_MID = 372,
    tLOWEST = 373,
    tUMINUS_NUM = 374,
    tLAST_TOKEN = 375
  };
#endif

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED

union YYSTYPE
{
#line 1330 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:352  */

    node *nd;
    mrb_sym id;
    int num;
    stack_type stack;
    const struct vtable *vars;

#line 1558 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:352  */
};

typedef union YYSTYPE YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif



int yyparse (parser_state *p);





#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef YY_ATTRIBUTE
# if (defined __GNUC__                                               \
      && (2 < __GNUC__ || (__GNUC__ == 2 && 96 <= __GNUC_MINOR__)))  \
     || defined __SUNPRO_C && 0x5110 <= __SUNPRO_C
#  define YY_ATTRIBUTE(Spec) __attribute__(Spec)
# else
#  define YY_ATTRIBUTE(Spec) /* empty */
# endif
#endif

#ifndef YY_ATTRIBUTE_PURE
# define YY_ATTRIBUTE_PURE   YY_ATTRIBUTE ((__pure__))
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# define YY_ATTRIBUTE_UNUSED YY_ATTRIBUTE ((__unused__))
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && ! defined __ICC && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN \
    _Pragma ("GCC diagnostic push") \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")\
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif


#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYSIZE_T yynewbytes;                                            \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / sizeof (*yyptr);                          \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, (Count) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYSIZE_T yyi;                         \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   11381

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  147
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  176
/* YYNRULES -- Number of rules.  */
#define YYNRULES  592
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  1030

#define YYUNDEFTOK  2
#define YYMAXUTOK   375

/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                                \
  ((unsigned) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     146,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   133,     2,     2,     2,   131,   126,     2,
     142,   143,   129,   127,   140,   128,   145,   130,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   121,   144,
     123,   119,   122,   120,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   138,     2,   139,   125,     2,   141,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   136,   124,   137,   134,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   132,   135
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1488,  1488,  1488,  1499,  1505,  1509,  1514,  1518,  1524,
    1526,  1525,  1539,  1566,  1572,  1576,  1581,  1585,  1591,  1591,
    1595,  1599,  1603,  1607,  1611,  1615,  1619,  1624,  1625,  1629,
    1633,  1637,  1641,  1644,  1648,  1652,  1656,  1660,  1664,  1669,
    1673,  1680,  1681,  1685,  1689,  1690,  1694,  1698,  1702,  1706,
    1709,  1718,  1719,  1722,  1723,  1730,  1729,  1744,  1748,  1753,
    1757,  1762,  1766,  1771,  1775,  1779,  1783,  1787,  1793,  1797,
    1803,  1804,  1810,  1814,  1818,  1822,  1826,  1830,  1834,  1838,
    1842,  1846,  1852,  1853,  1859,  1863,  1869,  1873,  1879,  1883,
    1887,  1891,  1895,  1899,  1905,  1911,  1918,  1922,  1926,  1930,
    1934,  1938,  1944,  1950,  1955,  1961,  1965,  1968,  1972,  1976,
    1983,  1984,  1985,  1986,  1991,  1998,  1999,  2002,  2006,  2006,
    2012,  2013,  2014,  2015,  2016,  2017,  2018,  2019,  2020,  2021,
    2022,  2023,  2024,  2025,  2026,  2027,  2028,  2029,  2030,  2031,
    2032,  2033,  2034,  2035,  2036,  2037,  2038,  2039,  2040,  2041,
    2044,  2044,  2044,  2045,  2045,  2046,  2046,  2046,  2047,  2047,
    2047,  2047,  2048,  2048,  2048,  2049,  2049,  2049,  2050,  2050,
    2050,  2050,  2051,  2051,  2051,  2051,  2052,  2052,  2052,  2052,
    2053,  2053,  2053,  2053,  2054,  2054,  2054,  2054,  2055,  2055,
    2058,  2062,  2066,  2070,  2074,  2078,  2082,  2087,  2092,  2097,
    2101,  2105,  2109,  2113,  2117,  2121,  2125,  2129,  2133,  2137,
    2141,  2145,  2149,  2153,  2157,  2161,  2165,  2169,  2173,  2177,
    2181,  2185,  2189,  2193,  2197,  2201,  2205,  2209,  2213,  2217,
    2221,  2225,  2229,  2235,  2236,  2241,  2245,  2252,  2256,  2264,
    2270,  2271,  2274,  2275,  2276,  2281,  2286,  2293,  2299,  2304,
    2309,  2314,  2321,  2321,  2332,  2338,  2342,  2348,  2349,  2352,
    2358,  2364,  2369,  2376,  2381,  2386,  2393,  2394,  2395,  2396,
    2397,  2398,  2399,  2400,  2404,  2409,  2408,  2420,  2424,  2419,
    2429,  2429,  2433,  2437,  2441,  2445,  2450,  2455,  2459,  2463,
    2467,  2471,  2475,  2476,  2482,  2488,  2481,  2500,  2508,  2516,
    2516,  2516,  2523,  2523,  2523,  2530,  2536,  2541,  2543,  2540,
    2552,  2550,  2568,  2573,  2566,  2590,  2588,  2605,  2609,  2604,
    2626,  2632,  2625,  2649,  2653,  2657,  2661,  2667,  2674,  2675,
    2676,  2679,  2680,  2683,  2684,  2692,  2693,  2699,  2703,  2706,
    2710,  2714,  2718,  2723,  2727,  2731,  2735,  2741,  2740,  2750,
    2754,  2758,  2762,  2768,  2773,  2778,  2782,  2786,  2790,  2794,
    2798,  2802,  2806,  2810,  2814,  2818,  2822,  2826,  2830,  2834,
    2840,  2845,  2852,  2852,  2856,  2861,  2868,  2872,  2878,  2879,
    2882,  2887,  2890,  2894,  2900,  2904,  2911,  2910,  2925,  2935,
    2939,  2944,  2951,  2955,  2959,  2963,  2967,  2971,  2975,  2979,
    2983,  2990,  2989,  3004,  3003,  3019,  3027,  3036,  3039,  3046,
    3049,  3053,  3054,  3057,  3061,  3064,  3068,  3071,  3072,  3073,
    3074,  3077,  3078,  3084,  3085,  3086,  3090,  3096,  3097,  3103,
    3108,  3107,  3118,  3122,  3128,  3132,  3138,  3142,  3148,  3151,
    3152,  3155,  3161,  3167,  3168,  3171,  3178,  3177,  3191,  3195,
    3202,  3207,  3214,  3220,  3221,  3222,  3223,  3224,  3228,  3234,
    3238,  3244,  3245,  3246,  3250,  3256,  3260,  3264,  3268,  3272,
    3278,  3282,  3288,  3292,  3296,  3300,  3304,  3308,  3316,  3323,
    3334,  3335,  3339,  3343,  3342,  3358,  3364,  3370,  3376,  3382,
    3389,  3394,  3401,  3405,  3411,  3415,  3421,  3422,  3425,  3429,
    3435,  3439,  3443,  3447,  3453,  3458,  3463,  3467,  3471,  3475,
    3479,  3483,  3487,  3491,  3495,  3499,  3503,  3507,  3511,  3515,
    3520,  3526,  3531,  3536,  3541,  3546,  3553,  3557,  3564,  3569,
    3568,  3580,  3584,  3590,  3598,  3606,  3614,  3618,  3624,  3628,
    3634,  3635,  3638,  3643,  3650,  3651,  3654,  3660,  3664,  3670,
    3675,  3675,  3700,  3701,  3707,  3712,  3718,  3719,  3722,  3728,
    3733,  3743,  3750,  3751,  3752,  3755,  3756,  3757,  3758,  3761,
    3762,  3763,  3766,  3767,  3770,  3774,  3780,  3781,  3787,  3788,
    3791,  3792,  3795,  3798,  3799,  3800,  3803,  3804,  3805,  3808,
    3815,  3816,  3820
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 0
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "keyword_class", "keyword_module",
  "keyword_def", "keyword_begin", "keyword_if", "keyword_unless",
  "keyword_while", "keyword_until", "keyword_for", "keyword_undef",
  "keyword_rescue", "keyword_ensure", "keyword_end", "keyword_then",
  "keyword_elsif", "keyword_else", "keyword_case", "keyword_when",
  "keyword_break", "keyword_next", "keyword_redo", "keyword_retry",
  "keyword_in", "keyword_do", "keyword_do_cond", "keyword_do_block",
  "keyword_do_LAMBDA", "keyword_return", "keyword_yield", "keyword_super",
  "keyword_self", "keyword_nil", "keyword_true", "keyword_false",
  "keyword_and", "keyword_or", "keyword_not", "modifier_if",
  "modifier_unless", "modifier_while", "modifier_until", "modifier_rescue",
  "keyword_alias", "keyword_BEGIN", "keyword_END", "keyword__LINE__",
  "keyword__FILE__", "keyword__ENCODING__", "tIDENTIFIER", "tFID", "tGVAR",
  "tIVAR", "tCONSTANT", "tCVAR", "tLABEL_TAG", "tINTEGER", "tFLOAT",
  "tCHAR", "tXSTRING", "tREGEXP", "tSTRING", "tSTRING_PART", "tSTRING_MID",
  "tNTH_REF", "tBACK_REF", "tREGEXP_END", "tNUMPARAM", "tUPLUS", "tUMINUS",
  "tPOW", "tCMP", "tEQ", "tEQQ", "tNEQ", "tGEQ", "tLEQ", "tANDOP", "tOROP",
  "tMATCH", "tNMATCH", "tDOT2", "tDOT3", "tAREF", "tASET", "tLSHFT",
  "tRSHFT", "tCOLON2", "tCOLON3", "tOP_ASGN", "tASSOC", "tLPAREN",
  "tLPAREN_ARG", "tRPAREN", "tLBRACK", "tLBRACE", "tLBRACE_ARG", "tSTAR",
  "tDSTAR", "tAMPER", "tLAMBDA", "tANDDOT", "tSYMBEG", "tREGEXP_BEG",
  "tWORDS_BEG", "tSYMBOLS_BEG", "tSTRING_BEG", "tXSTRING_BEG",
  "tSTRING_DVAR", "tLAMBEG", "tHEREDOC_BEG", "tHEREDOC_END",
  "tLITERAL_DELIM", "tHD_LITERAL_DELIM", "tHD_STRING_PART",
  "tHD_STRING_MID", "tLOWEST", "'='", "'?'", "':'", "'>'", "'<'", "'|'",
  "'^'", "'&'", "'+'", "'-'", "'*'", "'/'", "'%'", "tUMINUS_NUM", "'!'",
  "'~'", "tLAST_TOKEN", "'{'", "'}'", "'['", "']'", "','", "'`'", "'('",
  "')'", "';'", "'.'", "'\\n'", "$accept", "program", "$@1",
  "top_compstmt", "top_stmts", "top_stmt", "@2", "bodystmt", "compstmt",
  "stmts", "stmt", "$@3", "command_asgn", "command_rhs", "expr",
  "expr_value", "command_call", "block_command", "cmd_brace_block", "$@4",
  "command", "mlhs", "mlhs_inner", "mlhs_basic", "mlhs_item", "mlhs_list",
  "mlhs_post", "mlhs_node", "lhs", "cname", "cpath", "fname", "fsym",
  "undef_list", "$@5", "op", "reswords", "arg", "aref_args", "arg_rhs",
  "paren_args", "opt_paren_args", "opt_call_args", "call_args",
  "command_args", "@6", "block_arg", "opt_block_arg", "comma", "args",
  "mrhs", "primary", "@7", "@8", "$@9", "$@10", "@11", "@12", "$@13",
  "$@14", "$@15", "$@16", "$@17", "$@18", "@19", "@20", "@21", "@22",
  "@23", "@24", "@25", "@26", "primary_value", "then", "do", "if_tail",
  "opt_else", "for_var", "f_margs", "$@27", "block_args_tail",
  "opt_block_args_tail", "block_param", "opt_block_param",
  "block_param_def", "$@28", "opt_bv_decl", "bv_decls", "bvar",
  "f_larglist", "lambda_body", "do_block", "$@29", "block_call",
  "method_call", "brace_block", "@30", "@31", "case_body", "cases",
  "opt_rescue", "exc_list", "exc_var", "opt_ensure", "literal", "string",
  "string_fragment", "string_rep", "string_interp", "@32", "xstring",
  "regexp", "heredoc", "heredoc_bodies", "heredoc_body",
  "heredoc_string_rep", "heredoc_string_interp", "@33", "words", "symbol",
  "basic_symbol", "sym", "symbols", "numeric", "variable", "var_lhs",
  "var_ref", "backref", "superclass", "$@34", "f_arglist", "f_label",
  "f_kw", "f_block_kw", "f_block_kwarg", "f_kwarg", "kwrest_mark",
  "f_kwrest", "args_tail", "opt_args_tail", "f_args", "f_bad_arg",
  "f_norm_arg", "f_arg_item", "@35", "f_arg", "f_opt_asgn", "f_opt",
  "f_block_opt", "f_block_optarg", "f_optarg", "restarg_mark",
  "f_rest_arg", "blkarg_mark", "f_block_arg", "opt_f_block_arg",
  "singleton", "$@36", "assoc_list", "assocs", "label_tag", "assoc",
  "operation", "operation2", "operation3", "dot_or_colon", "call_op",
  "call_op2", "opt_terms", "opt_nl", "rparen", "trailer", "term", "nl",
  "terms", "none", YY_NULLPTR
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,    61,
      63,    58,    62,    60,   124,    94,    38,    43,    45,    42,
      47,    37,   374,    33,   126,   375,   123,   125,    91,    93,
      44,    96,    40,    41,    59,    46,    10
};
# endif

#define YYPACT_NINF -810

#define yypact_value_is_default(Yystate) \
  (!!((Yystate) == (-810)))

#define YYTABLE_NINF -593

#define yytable_value_is_error(Yytable_value) \
  (!!((Yytable_value) == (-593)))

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const yytype_int16 yypact[] =
{
    -810,   107,  2683,  -810,  7226,  9082,  9418,  5304,  -810,  8734,
    8734,  -810,  -810,  9194,  6724,  5160,  7458,  7458,  -810,  -810,
    7458,  2939,  6074,  -810,  -810,  -810,  -810,   281,  6724,  -810,
      32,  -810,  -810,  -810,  5444,  5584,  -810,  -810,  5724,  -810,
    -810,  -810,  -810,  -810,  -810,  -810,     1,  8850,  8850,    55,
    4431,   903,  7690,  8038,  7002,  -810,  6446,   261,   477,   638,
    1027,   725,  -810,   273,  8966,  8850,  -810,   909,  -810,  1131,
    -810,   278,  -810,  -810,   109,   108,  -810,    94,  9306,  -810,
     120, 11096,   343,   466,    84,    50,  -810,   371,  -810,  -810,
    -810,  -810,  -810,  -810,  -810,  -810,  -810,   356,   174,  -810,
     411,    30,  -810,  -810,  -810,  -810,  -810,   195,   195,   198,
     672,   708,  -810,  8734,    99,  4548,   295,  -810,   246,  -810,
     499,  -810,  -810,    30,  -810,  -810,  -810,  -810,  -810,  -810,
    -810,  -810,  -810,  -810,  -810,  -810,  -810,  -810,  -810,  -810,
    -810,  -810,  -810,  -810,  -810,  -810,  -810,  -810,  -810,  -810,
    -810,  -810,    52,    72,   101,   116,  -810,  -810,  -810,  -810,
    -810,  -810,   149,   173,   184,   235,  -810,   252,  -810,  -810,
    -810,  -810,  -810,  -810,  -810,  -810,  -810,  -810,  -810,  -810,
    -810,  -810,  -810,  -810,  -810,  -810,  -810,  -810,  -810,  -810,
    -810,  -810,  -810,  -810,  -810,  -810,  -810,  -810,  -810,  -810,
    -810,  -810,  -810,   285,  3621,   335,   278,    58,   283,   588,
      24,   316,    66,    58,  8734,  8734,   771,   369,  -810,  -810,
     805,   412,    29,    60,  -810,  -810,  -810,  -810,  -810,  -810,
    -810,  -810,  -810,  6585,  -810,  -810,   299,  -810,  -810,  -810,
    -810,  -810,  -810,   909,  -810,   189,  -810,   424,  -810,  -810,
     909,  2805,  8850,  8850,  8850,  8850,  -810, 11075,  -810,  -810,
     309,   397,   309,  -810,  -810,  -810,  7458,  -810,  -810,  -810,
    7458,  -810,  -810,  -810,  5160,  8734,  -810,  -810,   324,  4665,
    -810,   873,   396,   577,  7342,  4431,   344,   909,  1131,   909,
     357,  -810,  7342,   909,   355,  1201,  1201,  -810, 11075,   366,
    1201,  -810,   464,  9530,   381,   951,   963,   978,  1582,  -810,
    -810,  -810,  -810,  1105,  -810,  -810,  -810,  -810,  -810,  -810,
     746,   887,  -810,  -810,  1133,  -810,  1191,  -810,  1197,  -810,
     872,   456,   472,  -810,  -810,  -810,  -810,  4926,  8734,  8734,
    8734,  8734,  7342,  8734,  8734,  -810,  -810,  8154,  -810,  4431,
    7114,   408,  8154,  8850,  8850,  8850,  8850,  8850,  8850,  8850,
    8850,  8850,  8850,  8850,  8850,  8850,  8850,  8850,  8850,  8850,
    8850,  8850,  8850,  8850,  8850,  8850,  8850,  8850,  8850,  1441,
    -810,  7458,  -810,  1986,  -810,  -810, 10810,  -810,  -810,  -810,
    -810,  8966,  8966,  -810,   438,  -810,   278,  -810,  1010,  -810,
    -810,  -810,  -810,  -810,  2408,  7458,  9802,  3621,  8734,  -810,
    -810,  -810,  -810,   544,   547,   152,  -810,  3765,   546,  8850,
    9886,  7458,  9970,  8850,  8850,  4053,    63,    63,    73, 10054,
    7458, 10138,  -810,   503,  -810,  4665,   424,  -810,  -810,  8270,
     553,  -810,   746,  8850, 11096, 11096, 11096,  8850,   891,  -810,
    7574,  -810,  8850,  -810,  7806,   432,   909,   309,   309,  -810,
    -810,   850,   434,  -810,  -810,  6724,  4170,   445,  9886,  9970,
    8850,  1131,   909,  -810,  -810,  5043,   454,  1131,  -810,  -810,
    7922,  -810,   909,  8038,  -810,  -810,  -810,  1010,    94,  9530,
    -810,  9530, 10222,  7458, 10306,    59,  -810,  -810,  -810,  -810,
    -810,  -810,  -810,  -810,  -810,  -810,  -810,  -810,  1926,  -810,
    8850,  -810,   463,   539,   474,  -810,  -810,  -810,  -810,  -810,
     478,  8850,  -810,   481,   555,   491,   583,  -810,  -810,  1207,
    4665,   746,  -810,  -810,  -810,  -810,  -810,  -810,  -810,  8850,
    8850,  -810,  -810,  -810,  -810,  -810,  -810,  -810,  -810,   112,
    8850,  -810, 10899,   309,  -810,   909,  9530,   505,  -810,  -810,
    -810,   602,   529,  1792,  -810,  -810,  1018,   172,   396, 11233,
   11233, 11233, 11233,  1206,  1206, 11250, 11173, 11233, 11233, 11156,
   11156,   121,   121, 10839,  1206,  1206,  1158,  1158,   694,   255,
     255,   396,   396,   396,  3073,  6190,  3341,  6306,  -810,   195,
    -810,   520,   696,  -810,   837,  -810,  -810,  6074,  -810,  -810,
    1585,   112,   112,  -810,  2481,  -810,  -810,  -810,  -810,  -810,
     909,  8734,  3621,   894,   754,  -810,   195,   521,   195,   648,
     850,  2156,  6863,  -810,  8386,   653,  -810,   496,  -810,  5840,
    5957,   535,   323,   359,   653,  -810,  -810,  -810,  -810,    41,
      79,   565,    93,    97,  8734,  6724,   569,   677, 11096,   568,
    -810,   746, 11096, 11096,   746,  8850, 11075,  -810,   309, 11096,
    -810,  -810,  -810,  7574,  7806,  -810,  -810,  -810,   570,  -810,
    -810,     6,  1131,   909,  1201,   408,  -810,   894,   754,   579,
     906,  1009,  -810,  -810,  1343,   576,    54, 11096,   175,  -810,
    -810,  -810,   188,  -810,  1926,  -810, 11096,  1926,  -810,  -810,
    1593,  -810,  -810,  -810,   572,  -810,   396,   396,  -810,  1926,
    3621,  -810,  -810, 10918,  8502,  -810,  -810,  9530,  7342,  8966,
    8850, 10390,  7458, 10474,    82,  8966,  8966,  -810,   438,   839,
    8966,  8966,  -810,   438,    50,   109,  3621,  4665,   112,  -810,
     909,   712,  -810,  -810,  -810,  1926,  3621,   909,  -810, 10899,
    -810,   637,  -810,  4314,   717,  -810,  8734,   723,  -810,  8850,
    8850,   415,  8850,  8850,   724,  4809,  4809,   105,    63,  -810,
    -810,  -810,  8618,  3909,   746, 11096,  -810,   309,  -810,  -810,
    -810,   141,  -810,   601,   909,   592,   599,   606,  3621,  4665,
    -810,   701,  -810,   474,  -810,  -810,  -810,   611,   623,   625,
    -810,   630,   701,   625,  -810,  -810,   576,   576,  9642,  -810,
     636,   474,   658,  9642,  -810,   659,   664,  -810,   778,  8850,
   10987,  -810,  -810, 11096,  3207,  3475,   657,   444,   455,  8850,
    8850,  -810,  -810,  -810,  -810,  -810,  8966,  -810,  -810,  -810,
    -810,  -810,  -810,  -810,   790,   690,  4665,  3621,  -810,  -810,
     909,   794,  -810,  2156,  9754,    58,  -810,  -810,  4809,  -810,
    -810,    58,  -810,  8850,  -810,   813,   815,  -810, 11096,   236,
    7806,  -810,   692,  -810,  1432,  -810,  1031,   819,   698,  -810,
    1926,  -810,  1593,  -810,  1593,  -810,  1593,  -810,  -810,   721,
     728,   786,  1021,   175,  -810,  -810,  1873,  -810,  1021,  1926,
    -810,  1593,  -810,  -810, 11006,   467, 11096, 11096,  -810,  -810,
    -810,  -810,   729,   843,  -810,  -810,  3621,   812,  -810,  1091,
     963,   978,  3621,  -810,  3765,  -810,  -810,  4809,  -810,  -810,
    -810,  1504,  1504,   829,  -810,    78,  -810,  -810,  -810,  -810,
     625,   741,   625,   625,  -810,  -810,  -810, 10558,  -810,   474,
     175,  -810,  -810,   749,   750,   751,  -810,   753,   751,  -810,
    -810,   871,  1010, 10642,  7458, 10726,   547,   496,   902,   781,
     781,  1504,   782,  1031,  -810,  -810,  1593,  -810,  -810,  -810,
     783,   789,  -810,  1926,  -810,  1593,  -810,  1593,  -810,  1593,
    -810,  -810,  -810,   894,   754,   785,   507,   656,  -810,  -810,
    -810,  1504,   781,  1504,  -810,   625,   751,   799,   751,   751,
     141,   781,  -810,  -810,  1593,  -810,  -810,  -810,   751,  -810
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       2,     0,     0,     1,     0,     0,     0,     0,   275,     0,
       0,   299,   302,     0,     0,   578,   323,   324,   325,   326,
     287,   252,   399,   474,   473,   475,   476,   580,     0,    10,
       0,   478,   477,   479,   465,   274,   467,   466,   469,   468,
     461,   462,   423,   424,   480,   481,   273,     0,     0,     0,
       0,   277,   592,   592,    80,   294,     0,     0,     0,     0,
       0,     0,   438,     0,     0,     0,     3,   578,     6,     9,
      27,    32,    44,    52,    51,     0,    68,     0,    72,    82,
       0,    49,   232,     0,    53,   292,   266,   267,   421,   268,
     269,   270,   419,   418,   450,   420,   417,   472,     0,   271,
     272,   252,     5,     8,   323,   324,   287,   592,   399,     0,
     105,   106,   273,     0,     0,     0,     0,   108,   482,   327,
       0,   472,   272,     0,   315,   160,   170,   161,   157,   186,
     187,   188,   189,   168,   183,   176,   166,   165,   181,   164,
     163,   159,   184,   158,   171,   175,   177,   169,   162,   178,
     185,   180,   179,   172,   182,   167,   156,   174,   173,   155,
     153,   154,   150,   151,   152,   110,   112,   111,   145,   146,
     141,   123,   124,   125,   132,   129,   131,   126,   127,   147,
     148,   133,   134,   138,   142,   128,   130,   120,   121,   122,
     135,   136,   137,   139,   140,   143,   144,   149,   550,   317,
     113,   114,   549,     0,     0,     0,    50,     0,     0,     0,
     472,     0,   272,     0,     0,     0,   104,     0,   338,   337,
       0,     0,   472,   272,   179,   172,   182,   167,   150,   151,
     152,   110,   111,     0,   115,   117,    20,   116,   441,   446,
     445,   586,   589,   578,   588,     0,   443,     0,   590,   587,
     579,   562,     0,     0,     0,     0,   247,   259,    66,   251,
     592,   421,   592,   554,    67,    65,   592,   241,   288,    64,
       0,   240,   398,    63,   578,     0,   581,    18,     0,     0,
     209,     0,   210,   284,     0,     0,     0,   578,    15,   578,
      70,    14,     0,   578,     0,   583,   583,   233,     0,     0,
     583,   552,     0,     0,    78,     0,    88,    95,   520,   455,
     454,   456,   457,     0,   453,   452,   436,   430,   429,   432,
       0,     0,   427,   448,     0,   459,     0,   425,     0,   434,
       0,   463,   464,    48,   224,   225,     4,   579,     0,     0,
       0,     0,     0,     0,     0,   386,   388,     0,    84,     0,
      76,    73,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     575,   592,   574,     0,   577,   576,     0,   403,   401,   293,
     422,     0,     0,   392,    57,   291,   312,   105,   106,   107,
     463,   464,   483,   310,     0,   592,     0,     0,     0,   318,
     573,   572,   320,     0,   592,   284,   329,     0,   328,     0,
       0,   592,     0,     0,     0,     0,     0,     0,   284,     0,
     592,     0,   307,     0,   118,     0,     0,   442,   444,     0,
       0,   591,   556,     0,   260,   561,   254,     0,   257,   248,
       0,   256,     0,   249,     0,     0,   578,   592,   592,   242,
     253,   578,     0,   290,    47,     0,     0,     0,     0,     0,
       0,    17,   578,   282,    13,   579,    69,   278,   281,   285,
     585,   234,   584,   585,   236,   286,   553,    94,    86,     0,
      81,     0,     0,   592,     0,   527,   523,   522,   521,   524,
     525,   496,   529,   541,   497,   545,   544,   540,   520,   295,
     489,   494,   592,   499,   592,   519,   383,   526,   528,   531,
     505,     0,   538,   505,   543,   505,     0,   503,   458,     0,
       0,   433,   439,   437,   428,   449,   460,   426,   435,     0,
       0,     7,    21,    22,    23,    24,    25,    45,    46,   592,
       0,    28,    30,     0,    31,   578,     0,    74,    85,    43,
      33,    41,     0,   237,   190,    29,     0,   272,   206,   214,
     219,   220,   221,   216,   218,   228,   229,   222,   223,   199,
     200,   226,   227,   580,   215,   217,   211,   212,   213,   201,
     202,   203,   204,   205,   565,   570,   566,   571,   397,   252,
     395,     0,   565,   567,   566,   568,   396,   592,   565,   566,
     252,   592,   592,    34,   237,   191,    40,   198,    55,    58,
       0,     0,     0,   105,   106,   109,     0,     0,   592,     0,
     578,   520,     0,   276,   592,   592,   409,   592,   330,   569,
     283,     0,   565,   566,   592,   332,   300,   331,   303,   569,
     283,     0,   565,   566,     0,     0,     0,     0,   259,     0,
     306,   557,   559,   558,     0,     0,   261,   255,   592,   560,
     555,   239,   243,   244,   246,   289,   582,    19,     0,    26,
     197,    71,    16,   578,   583,    87,    79,    91,    93,     0,
      90,    92,   487,   533,     0,   580,     0,   488,     0,   501,
     548,   498,     0,   502,     0,   512,   534,     0,   515,   542,
       0,   517,   546,   451,     0,   440,   207,   208,   374,   372,
       0,   371,   370,   265,     0,    83,    77,     0,     0,     0,
       0,     0,   592,     0,     0,     0,     0,   394,    61,   400,
       0,     0,   393,    59,   389,    54,     0,     0,   592,   313,
       0,     0,   400,   316,   551,   520,     0,     0,   321,   410,
     411,   592,   412,     0,   592,   335,     0,     0,   333,     0,
       0,   400,     0,     0,     0,     0,     0,   400,     0,   119,
     447,   305,     0,     0,   258,   262,   250,   592,    11,   279,
     235,    89,   527,   346,   578,   339,     0,   376,     0,     0,
     296,     0,   495,   592,   547,   504,   532,   505,   505,   505,
     539,   505,   527,   505,   431,   369,   580,   580,   491,   492,
     592,   592,   354,     0,   536,   354,   354,   352,     0,     0,
     263,    75,    42,   238,   565,   566,     0,   565,   566,     0,
       0,    39,   195,    38,   196,    62,     0,    36,   193,    37,
     194,    60,   390,   391,     0,     0,     0,     0,   484,   311,
     578,     0,   486,   520,     0,     0,   414,   336,     0,    12,
     416,     0,   297,     0,   298,     0,     0,   308,   261,   592,
     245,   347,   344,   530,     0,   382,     0,     0,     0,   500,
       0,   508,     0,   510,     0,   516,     0,   513,   518,     0,
       0,     0,   490,     0,   350,   351,   354,   362,   535,     0,
     365,     0,   367,   387,   264,   400,   231,   230,    35,   192,
     404,   402,     0,     0,   485,   319,     0,     0,   413,     0,
      96,   103,     0,   415,     0,   301,   304,     0,   406,   407,
     405,     0,     0,   342,   380,   580,   378,   381,   385,   384,
     505,   505,   505,   505,   375,   373,   284,     0,   493,   592,
       0,   353,   360,   354,   354,   354,   537,   354,   354,    56,
     314,     0,   102,     0,   592,     0,   592,   592,     0,   348,
     345,     0,   340,     0,   377,   509,     0,   506,   511,   514,
     569,   283,   349,     0,   357,     0,   359,     0,   366,     0,
     363,   368,   322,    99,   101,     0,   565,   566,   408,   334,
     309,     0,   343,     0,   379,   505,   354,   354,   354,   354,
      97,   341,   507,   358,     0,   355,   361,   364,   354,   356
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -810,  -810,  -810,   475,  -810,     5,  -810,   -77,   258,  -810,
      51,  -810,   -30,  -331,   257,    26,   224,  -810,  -561,  -810,
     -13,   933,  -141,    -5,    -7,  -222,  -432,    21,  1659,   -32,
     967,     9,   -17,  -810,  -810,    35,  -810,  1011,  -810,   333,
      87,    12,  -292,   136,    18,  -810,  -353,  -233,  -148,   111,
    -295,    33,  -810,  -810,  -810,  -810,  -810,  -810,  -810,  -810,
    -810,  -810,  -810,  -810,  -810,  -810,  -810,  -810,  -810,  -810,
    -810,  -810,     8,  -207,  -400,     4,  -566,  -810,  -810,  -810,
     259,   450,  -810,  -516,  -810,  -810,  -264,  -810,     2,  -810,
    -810,   245,  -810,  -810,  -810,   -83,  -810,  -810,  -406,  -810,
      16,  -810,  -810,  -810,  -810,  -810,    15,    74,  -166,  -810,
    -810,  -810,  -810,  -405,  -172,  -810,   755,  -810,  -810,  -810,
      -6,  -810,  -810,  -810,  1540,  1902,   984,  1420,  -810,  -810,
     140,   228,   301,   114,  -810,  -810,  -810,   229,  -293,    62,
    -288,  -792,  -745,  -678,  -810,   219,  -602,  -655,  -809,   118,
     339,  -810,  -508,  -810,   216,  -426,  -810,  -810,  -810,    27,
     800,  -390,   563,  -280,  -810,  -810,   -50,  -810,    69,   -26,
    -144,  -223,   386,   -22,     3,    -2
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,     1,     2,    66,    67,    68,   278,   413,   414,   287,
     288,   465,    70,   560,    71,   207,    72,    73,   619,   748,
      74,    75,   289,    76,    77,    78,   490,    79,   208,   117,
     118,   234,   235,   236,   655,   597,   201,    81,   294,   564,
     598,   268,   455,   456,   269,   270,   259,   449,   483,   457,
     554,    82,   204,   292,   683,   293,   308,   696,   214,   775,
     215,   776,   654,   937,   622,   620,   857,   407,   409,   631,
     632,   863,   281,   417,   646,   767,   768,   221,   794,   941,
     961,   907,   816,   720,   721,   817,   796,   945,   946,   509,
     800,   346,   549,    84,    85,   395,   612,   611,   440,   940,
     635,   761,   865,   869,    86,    87,    88,   321,   322,   530,
      89,    90,    91,   531,   244,   245,   246,   435,    92,    93,
      94,   315,    95,    96,   210,   211,    99,   212,   403,   621,
     756,   510,   511,   819,   820,   512,   513,   514,   805,   705,
     757,   517,   518,   519,   694,   520,   521,   522,   824,   825,
     523,   524,   525,   526,   527,   699,   203,   408,   299,   458,
     443,   263,   123,   626,   600,   412,   406,   386,   462,   797,
     463,   481,   248,   249,   250,   291
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     102,   275,   389,   256,   256,   276,   425,   256,   237,   103,
      83,   277,    83,   120,   120,   515,   199,   209,   209,   271,
     516,   220,   237,   209,   209,   209,   806,   648,   209,   453,
     657,   261,   261,   383,   385,   261,   213,   661,   119,   119,
     273,   243,   200,   262,   262,   290,   119,   262,   882,   200,
     297,   301,   810,    69,   -96,    69,   387,   565,    83,   686,
     613,   616,   305,   200,   670,   314,   -99,   261,   261,   764,
     337,   351,   209,   484,   416,   304,   387,   486,   774,   296,
     300,   489,   399,   798,   247,  -103,   305,   119,   703,   601,
     645,   200,  -471,   670,   947,   746,   747,   667,  -102,   599,
     966,   667,   390,   607,  -101,   271,   610,     3,   267,   272,
     283,   119,   450,   627,   454,  -470,   692,   823,   -98,   394,
    -104,   209,  -100,    83,   726,   -69,   628,   260,   260,   641,
     -97,   260,   324,   326,   328,   330,   336,   345,   651,   839,
     599,  -474,   607,   -96,   472,   476,   -83,   480,   532,   478,
     397,   628,   258,   264,   398,   534,   265,   424,   534,   422,
     534,  -473,   534,   295,   534,   799,   388,  -400,   279,   -88,
     431,   238,   266,   384,   239,   240,   238,   845,   693,   239,
     240,   -91,   851,  -565,   966,  -103,   388,   380,   393,   628,
    -475,   947,   718,   353,   267,   272,   808,  -474,   982,   811,
     -95,   689,   241,   840,   242,  -476,   806,   241,   555,   242,
     393,   826,    83,   -94,   628,   515,   806,  -473,   983,   -93,
     695,  -566,   209,   209,   242,   453,   801,   347,   806,   382,
    -400,   469,   856,   -90,   348,   810,   719,   -92,  -478,   352,
     426,   427,   314,   470,  -400,   -89,  -475,   501,   374,   375,
     376,   377,   378,   256,   763,   494,   439,   256,   451,   784,
     451,  -476,  -477,   392,   459,   391,   206,   206,   200,   489,
     532,  -102,   206,  -479,   209,   504,   505,  -400,   209,  -400,
     290,   261,   209,   209,   670,   261,  -400,    83,   333,   505,
     475,  -103,    83,    83,  -478,   831,   488,   262,   482,   482,
      83,   506,   437,   482,   823,   239,   240,   823,   286,   673,
     674,   305,   436,   938,   506,   343,   344,   675,  -477,   806,
     667,   667,   559,   316,  -465,   317,   318,   353,   681,  -479,
     629,   331,   332,   806,   489,   471,   119,   266,   515,   760,
     274,  -469,   541,   477,   290,    83,   209,   209,   209,   209,
      83,   209,   209,   400,   401,   209,   474,    83,   305,   715,
     566,   559,   559,   534,   542,   543,   544,   545,   256,   402,
     396,   557,   625,   286,   410,   319,   320,   889,   877,   459,
    -465,   260,   951,   119,   376,   377,   378,   529,    69,   209,
     415,   823,   256,   546,   904,   905,   261,  -469,   964,   566,
     566,   967,   419,   459,   841,   724,   460,   423,   256,   847,
     849,   725,   636,   209,   772,    83,   209,   256,   605,   459,
     261,   605,   664,   274,   428,    83,   276,   242,   459,   209,
     411,    42,  -327,    83,    43,   786,   261,   432,   209,   434,
     836,   605,   -98,    83,   439,   261,  -327,  -470,   677,   448,
     773,   599,   783,   607,   442,   451,   451,   605,   553,   237,
     466,   790,   515,   553,   102,   261,   605,   860,   353,   261,
     606,   206,   206,   939,    83,   -96,   -68,   668,  -100,    60,
     256,  -327,   685,    83,   488,  1017,   754,   473,  -327,   715,
     670,   459,   532,   606,   479,   261,   -88,   305,   261,   305,
     200,   209,   392,   485,   605,   489,   873,   684,   261,   606,
     700,   782,   700,   766,   763,   918,   733,    69,   606,   487,
     454,   491,   119,   -98,   119,   672,   682,   667,   539,   605,
    -103,   461,   464,   992,   -97,   740,   618,   467,    83,   789,
     323,   317,   318,   286,   540,   751,   741,   722,   558,   488,
     659,   -95,   899,   900,   786,   379,   606,   734,   846,   633,
     634,   276,   638,   -98,   305,   101,   528,   101,   660,   380,
     515,   551,   101,   101,  -100,   671,   561,   676,   101,   101,
     101,   606,   679,   101,   416,   708,   -97,   711,   404,   119,
     701,   319,   320,   418,   -83,   206,   206,   206,   206,   418,
     547,   548,   380,   698,   381,   271,   709,   286,   271,   722,
     722,   382,   715,   101,   702,   561,   561,   738,   704,   742,
     -98,   707,   744,   -98,   -98,   743,   271,   101,   745,   209,
      83,   710,   762,   765,   712,   765,   441,   405,   779,   880,
     742,   758,   765,   828,   382,   727,   728,   750,   729,   237,
     883,   -98,   792,   -98,   496,   497,   498,   499,   932,   739,
     752,   852,   209,   753,   934,   630,   451,   200,   470,   854,
     500,   763,  -100,   276,   771,   637,   101,   420,   101,   861,
     778,   238,  1005,   644,   239,   240,   737,   482,   261,   261,
     200,   380,   781,   656,   267,   628,  -102,   267,  -562,   559,
     787,   325,   317,   318,   777,   559,   780,   788,   448,   814,
     559,   559,   241,   737,   242,   267,   924,   -94,   791,   256,
     488,   887,   242,   441,   615,   617,   421,   859,    83,   864,
     459,   868,   884,   382,  -563,   305,    83,   566,   872,   874,
     209,   881,   885,   566,   209,   553,   722,   261,   566,   566,
     886,   890,   319,   320,    83,    83,   615,   617,   692,   866,
     119,  -465,   870,   892,    83,   894,   353,   101,   605,  -100,
     896,    83,  -100,  -100,   209,  -465,   903,   101,   101,   832,
     923,   366,   367,    83,    83,   451,   329,   740,   714,   317,
     318,    83,   871,   913,   276,   276,   915,  -469,   906,   909,
    -100,   700,  -100,   680,   911,   920,    83,    83,  -562,   925,
    -465,  -469,   647,   647,  -562,   -98,   559,  -465,   700,   700,
     606,   374,   375,   376,   377,   378,   902,   921,   935,   101,
     936,   908,   942,   101,   948,   949,   -90,   101,   101,   319,
     320,   956,   101,  -283,  -563,   954,  -469,   101,   101,   971,
    -563,   119,   955,  -469,   566,   101,   119,  -283,   970,   238,
    -273,   441,   239,   240,    83,    83,   969,   972,   441,   891,
     893,   895,   929,   897,  -273,   898,    83,   765,   206,   975,
     792,   986,   496,   497,   498,   499,  1002,   343,   344,   993,
     995,   997,  -283,   999,   429,   261,  -566,   119,   500,  -283,
     101,   101,   101,   101,   101,   101,   101,   101,   380,  -273,
     101,   206,   101,   795,   804,   101,  -273,  1010,   804,   984,
    -569,  1011,  1013,   276,  1020,  -565,   809,   803,   741,   813,
     846,  -566,  -565,   538,    83,   827,   317,   318,   822,  1024,
      83,   678,    83,   430,   101,    83,   218,   818,   821,   533,
     382,   317,   318,   561,   101,   101,  -100,   700,   -97,   561,
     843,   256,   468,   238,   561,   561,   239,   240,   101,   981,
     101,   101,   459,   124,   636,   765,   380,   -92,   815,   -89,
     101,  1009,   209,  -569,   101,  1014,   319,   320,   101,   261,
     853,   202,  1008,   101,   241,  -565,   242,  -569,   101,   802,
     438,   319,   320,   926,  -580,   855,   749,  -580,  -580,  -565,
     605,   421,   985,   987,   988,   989,  -280,   958,   382,  -280,
    -280,   867,   238,   206,   963,   239,   240,   257,   257,   101,
    -569,   257,  -569,   875,   876,  -566,  -565,   242,   101,  -569,
     492,   879,  -565,   807,  -565,   418,  -280,  -280,  -565,  -280,
       0,  -565,  -472,   241,   380,   242,   101,   888,   280,   282,
       0,   452,   606,   257,   298,     0,  -472,  -272,   842,   844,
     561,     0,     0,   848,   850,   334,   335,  1022,     0,     0,
       0,  -272,   944,     0,   496,   497,   498,   499,     0,   493,
     327,   317,   318,   101,     0,     0,   382,     0,  -566,  -284,
     500,  -472,   842,   844,     0,   848,   850,   731,  -472,   950,
     957,   952,  -566,  -284,   922,   953,  -272,     0,     0,   804,
       0,   380,   827,  -272,   380,   827,   933,   827,   965,     0,
     968,   818,   959,     0,   818,   821,   858,   818,   821,   818,
     821,   319,   320,   862,     0,  -566,     0,  -566,  -284,     0,
       0,  -566,     0,     0,  -566,  -284,   732,     0,     0,   405,
     979,   980,     0,   382,   647,     0,   382,     0,   528,   317,
     318,   338,   339,   340,   341,   342,   827,     0,     0,   919,
     973,     0,     0,     0,   101,   101,     0,     0,   818,   821,
     976,     0,   977,     0,   380,   978,   535,   317,   318,     0,
    1012,     0,     0,     0,     0,  1015,   919,     0,     0,   827,
       0,   827,  1016,   827,  1018,   827,     0,   101,  1019,   319,
     320,   818,   821,   818,   821,   818,   821,   818,   821,   974,
     353,     0,  1021,     0,     0,     0,   382,     0,     0,     0,
     827,     0,     0,  1028,     0,   366,   367,   319,   320,     0,
       0,   418,   818,   821,   536,   317,   318,   418,     0,     0,
     537,   317,   318,   444,   445,   446,   334,     0,     0,     0,
     713,   317,   318,     0,     0,   910,   912,   257,   353,     0,
       0,   257,     0,   101,   373,   374,   375,   376,   377,   378,
       0,   101,   101,   366,   367,   101,     0,     0,   101,   101,
       0,     0,     0,   101,   101,   319,   320,     0,     0,   101,
     101,   319,   320,     0,   238,     0,     0,   239,   240,   101,
       0,   319,   320,     0,     0,     0,   101,     0,     0,   101,
     371,   372,   373,   374,   375,   376,   377,   378,   101,   101,
       0,   448,     0,     0,     0,   241,   101,   242,     0,     0,
       0,     0,     0,     0,     0,     0,   962,     0,   552,     0,
       0,   101,   101,   563,   568,   569,   570,   571,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,   593,
       0,     0,   257,     0,   792,     0,   496,   497,   498,   499,
       0,     0,   614,   614,     0,     0,     0,     0,     0,   101,
       0,     0,   500,   994,   996,   998,   257,  1000,  1001,   101,
     101,     0,   100,     0,   100,   122,   122,     0,     0,     0,
     614,   101,   257,   223,   614,   614,   502,     0,     0,     0,
       0,   257,   793,     0,     0,     0,     0,     0,     0,     0,
     658,     0,     0,     0,   662,     0,     0,     0,   663,     0,
       0,   666,     0,   669,     0,   298,  1023,  1025,  1026,  1027,
     100,     0,     0,     0,   307,     0,     0,     0,  1029,     0,
       0,   614,     0,   792,     0,   496,   497,   498,   499,   101,
       0,   666,   594,   595,   298,   101,   596,   101,   307,     0,
     101,   500,     0,     0,   257,     0,     0,     0,     0,     0,
       0,   168,   169,   170,   171,   172,   173,   174,   175,   176,
       0,   697,   177,   178,     0,   502,   179,   180,   181,   182,
       0,   943,   706,     0,     0,   100,     0,   101,     0,     0,
     183,   184,    97,     0,    97,   121,   121,   121,     0,     0,
     716,   717,     0,   222,     0,   792,     0,   496,   497,   498,
     499,   723,     0,   185,   186,   187,   188,   189,   190,   191,
     192,   193,   194,   500,   195,   196,     0,     0,     0,     0,
       0,     0,   197,   266,     0,  -592,     0,     0,     0,     0,
      97,     0,     0,     0,   306,     0,     0,   502,  -592,  -592,
    -592,  -592,  -592,  -592,     0,  -592,     0,     0,     0,     0,
       0,  -592,  -592,     0,     0,     0,     0,     0,   306,     0,
       0,     0,  -592,  -592,   100,  -592,  -592,  -592,  -592,  -592,
       0,     0,     0,   495,     0,   496,   497,   498,   499,     0,
       0,     0,     0,     0,   812,   759,   496,   497,   498,   499,
       0,   500,     0,     0,   501,    97,     0,     0,     0,     0,
       0,    80,   500,    80,     0,   501,     0,     0,     0,     0,
       0,     0,   219,     0,  -592,   502,   785,     0,     0,     0,
       0,   503,   504,   505,   666,   298,   502,     0,  -592,     0,
       0,     0,     0,   504,   505,     0,     0,     0,  -592,   100,
       0,  -592,  -592,     0,   100,   100,     0,     0,   506,    80,
       0,   507,   100,     0,     0,     0,     0,     0,     0,   506,
       0,  -592,  -592,   307,   508,     0,     0,   266,  -592,  -592,
    -592,  -592,     0,     0,     0,   830,     0,     0,     0,     0,
     614,   833,     0,   257,    97,     0,   614,   614,     0,     0,
       0,   614,   614,     0,     0,     0,     0,   100,     0,     0,
       0,     0,   100,     0,     0,     0,     0,     0,     0,   100,
     307,     0,   567,     0,    80,     0,     0,     0,     0,     0,
     614,   614,     0,   614,   614,     0,     0,     0,     0,     0,
       0,     0,     0,   878,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   567,   567,     0,     0,     0,     0,     0,     0,    97,
       0,     0,     0,     0,    97,    97,     0,   100,     0,     0,
       0,     0,    97,     0,     0,     0,   730,   100,     0,     0,
     914,     0,     0,   306,     0,   100,     0,     0,     0,     0,
     916,   917,     0,     0,     0,   100,     0,   614,     0,     0,
       0,     0,     0,    80,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,   364,   365,    97,     0,   366,
     367,     0,    97,     0,   614,     0,   100,     0,     0,    97,
     306,   298,     0,     0,     0,   100,     0,     0,     0,     0,
       0,     0,     0,     0,    98,     0,    98,     0,     0,   307,
       0,   307,   368,     0,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   495,     0,   496,   497,   498,   499,
       0,     0,  -259,     0,     0,     0,     0,     0,    80,     0,
       0,     0,   500,    80,    80,   501,     0,    97,     0,     0,
     100,    80,    98,     0,     0,     0,     0,    97,     0,     0,
       0,     0,     0,     0,     0,    97,   502,     0,     0,     0,
       0,     0,   503,   504,   505,    97,   307,   495,     0,   496,
     497,   498,   499,     0,     0,   257,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   500,    80,     0,   501,   506,
       0,    80,   507,     0,     0,     0,    97,     0,    80,     0,
       0,   562,     0,   960,     0,    97,     0,    98,     0,   502,
       0,     0,     0,     0,     0,   503,   504,   505,     0,   306,
       0,   306,     0,     0,     0,     0,     0,   602,   603,     0,
       0,   604,   100,     0,     0,     0,     0,     0,     0,     0,
     562,   562,   506,     0,     0,   507,   168,   169,   170,   171,
     172,   173,   174,   175,   176,     0,    80,   177,   178,     0,
      97,   179,   180,   181,   182,     0,    80,     0,     0,     0,
       0,     0,     0,     0,    80,   183,   184,     0,     0,     0,
       0,     0,     0,     0,    80,     0,   306,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    98,     0,   185,   186,
     187,   188,   189,   190,   191,   192,   193,   194,     0,   195,
     196,     0,     0,     0,     0,    80,     0,   197,   266,     0,
       0,     0,     0,     0,    80,     0,     0,     0,     0,     0,
     100,     0,     0,     0,     0,     0,     0,   307,   100,   567,
       0,     0,     0,     0,     0,   567,     0,     0,     0,     0,
     567,   567,    97,     0,     0,     0,   100,   100,     0,     0,
       0,     0,     0,     0,     0,     0,   100,     0,     0,     0,
       0,    98,     0,   100,     0,     0,    98,    98,     0,    80,
       0,     0,     0,     0,    98,   100,   100,     0,     0,     0,
       0,     0,     0,   100,     0,     0,     0,   495,     0,   496,
     497,   498,   499,     0,     0,     0,     0,     0,   100,   100,
       0,     0,     0,     0,     0,   500,     0,     0,   501,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   122,    98,
       0,     0,     0,   122,    98,     0,     0,     0,     0,   502,
       0,    98,     0,     0,    98,   503,   504,   505,     0,     0,
      97,     0,     0,     0,     0,     0,   567,   306,    97,     0,
       0,     0,     0,     0,     0,     0,   100,   100,     0,     0,
       0,    80,   506,     0,   931,   507,    97,    97,   100,     0,
       0,     0,     0,    98,    98,     0,    97,     0,   755,     0,
       0,     0,     0,    97,     0,     0,     0,     0,     0,    98,
       0,     0,     0,     0,     0,    97,    97,     0,     0,    98,
       0,     0,     0,    97,     0,     0,     0,    98,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    98,    97,    97,
       0,     0,     0,     0,     0,     0,   100,     0,     0,     0,
       0,     0,   100,     0,   100,     0,     0,   100,   121,     0,
       0,     0,     0,   121,     0,     0,     0,     0,    98,     0,
       0,     0,     0,     0,     0,     0,     0,    98,     0,    80,
       0,     0,     0,     0,     0,     0,     0,    80,   562,     0,
       0,     0,     0,     0,   562,     0,    97,    97,     0,   562,
     562,     0,     0,     0,   930,    80,    80,     0,    97,     0,
       0,     0,     0,     0,     0,    80,     0,     0,     0,     0,
       0,     0,    80,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    98,     0,    80,    80,     0,     0,     0,     0,
       0,     0,    80,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    80,    80,   623,
     595,     0,     0,   624,     0,     0,    97,     0,     0,     0,
       0,     0,    97,     0,    97,     0,     0,    97,   168,   169,
     170,   171,   172,   173,   174,   175,   176,     0,     0,   177,
     178,     0,     0,   179,   180,   181,   182,     0,     0,     0,
       0,     0,     0,     0,     0,   562,     0,   183,   184,     0,
       0,     0,     0,     0,     0,    80,    80,     0,     0,     0,
       0,     0,     0,   928,    98,   730,     0,    80,     0,     0,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
       0,   195,   196,     0,     0,     0,     0,     0,     0,   197,
     266,     0,     0,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,   364,   365,     0,     0,   366,   367,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    80,     0,     0,     0,     0,
       0,    80,     0,    80,     0,     0,    80,     0,     0,     0,
       0,   368,     0,   369,   370,   371,   372,   373,   374,   375,
     376,   377,   378,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    98,     0,     0,     0,     0,     0,     0,     0,
      98,    98,     0,     0,     0,     0,     0,    98,     0,     0,
       0,     0,    98,    98,     0,     0,     0,     0,    98,    98,
       0,     0,     0,     0,     0,     0,     0,     0,    98,     0,
       0,     0,     0,     0,     0,    98,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    98,    98,     0,
       0,     0,     0,  -592,     4,    98,     5,     6,     7,     8,
       9,    10,    11,    12,    13,    14,     0,     0,     0,     0,
      98,    98,    15,     0,    16,    17,    18,    19,     0,     0,
       0,     0,     0,    20,    21,    22,    23,    24,    25,    26,
       0,     0,    27,     0,     0,     0,     0,     0,    28,    29,
      30,    31,    32,    33,    34,    35,    36,    37,    38,    39,
       0,    40,    41,    42,     0,     0,    43,     0,    98,    44,
      45,     0,    46,    47,    48,     0,     0,     0,    98,    98,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      98,     0,     0,    49,     0,     0,    50,    51,     0,    52,
      53,     0,    54,     0,     0,    55,     0,    56,    57,    58,
      59,    60,    61,     0,     0,    62,  -592,     0,     0,  -592,
    -592,     0,     0,     0,     0,  -465,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    63,    64,    65,  -465,  -465,
    -465,  -465,  -465,  -465,     0,  -465,     0,  -592,    98,  -592,
       0,     0,  -465,  -465,    98,     0,    98,     0,     0,    98,
       0,     0,  -465,  -465,     0,  -465,  -465,  -465,  -465,  -465,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   442,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -465,  -465,  -465,
    -465,  -465,  -465,  -465,  -465,  -465,  -465,  -465,  -465,  -465,
       0,     0,  -465,  -465,  -465,     0,  -465,  -465,     0,     0,
       0,     0,     0,  -465,     0,     0,     0,     0,  -465,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -465,     0,
       0,  -465,  -465,     0,  -465,  -465,     0,  -465,  -465,  -465,
    -465,  -465,  -465,  -465,  -465,  -465,  -465,     0,     0,  -592,
       0,     0,  -465,  -465,  -465,  -465,     0,     0,  -465,  -465,
    -465,  -465,  -592,  -592,  -592,  -592,  -592,  -592,     0,  -592,
       0,     0,     0,     0,     0,     0,  -592,  -592,     0,     0,
       0,     0,     0,     0,     0,     0,  -592,  -592,     0,  -592,
    -592,  -592,  -592,  -592,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -592,  -592,  -592,  -592,  -592,  -592,  -592,  -592,  -592,
    -592,  -592,  -592,  -592,     0,     0,  -592,  -592,  -592,     0,
       0,  -592,     0,     0,     0,     0,     0,  -592,     0,     0,
       0,     0,  -592,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -592,     0,     0,  -592,  -592,     0,     0,  -592,
       0,  -592,  -592,  -592,  -592,  -592,  -592,  -592,  -592,  -592,
    -592,     0,     0,  -569,     0,     0,  -592,  -592,  -592,  -592,
       0,   266,  -592,  -592,  -592,  -592,  -569,  -569,  -569,     0,
    -569,  -569,     0,  -569,     0,     0,     0,     0,     0,  -569,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -569,  -569,     0,  -569,  -569,  -569,  -569,  -569,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -569,  -569,  -569,  -569,  -569,
    -569,  -569,  -569,  -569,  -569,  -569,  -569,  -569,     0,     0,
    -569,  -569,  -569,     0,   735,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -569,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -569,     0,     0,  -569,
    -569,     0,   -99,  -569,     0,  -569,  -569,  -569,  -569,  -569,
    -569,  -569,  -569,  -569,  -569,     0,     0,  -569,     0,  -569,
    -569,  -569,     0,   -91,     0,     0,  -569,  -569,  -569,  -569,
    -569,  -569,  -569,     0,  -569,  -569,     0,  -569,     0,     0,
       0,     0,     0,  -569,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  -569,  -569,     0,  -569,  -569,  -569,
    -569,  -569,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -569,
    -569,  -569,  -569,  -569,  -569,  -569,  -569,  -569,  -569,  -569,
    -569,  -569,     0,     0,  -569,  -569,  -569,     0,   735,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -569,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -569,     0,     0,  -569,  -569,     0,   -99,  -569,     0,  -569,
    -569,  -569,  -569,  -569,  -569,  -569,  -569,  -569,  -569,     0,
       0,  -283,     0,  -569,  -569,  -569,     0,  -569,     0,     0,
    -569,  -569,  -569,  -569,  -283,  -283,  -283,     0,  -283,  -283,
       0,  -283,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -283,  -283,
       0,  -283,  -283,  -283,  -283,  -283,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -283,  -283,  -283,  -283,  -283,  -283,  -283,
    -283,  -283,  -283,  -283,  -283,  -283,     0,     0,  -283,  -283,
    -283,     0,   736,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  -283,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  -283,     0,     0,  -283,  -283,     0,
    -101,  -283,     0,  -283,  -283,  -283,  -283,  -283,  -283,  -283,
    -283,  -283,  -283,     0,     0,  -283,     0,     0,  -283,  -283,
       0,   -93,     0,     0,  -283,  -283,  -283,  -283,  -283,  -283,
    -283,     0,  -283,  -283,     0,  -283,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -283,  -283,     0,  -283,  -283,  -283,  -283,  -283,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -283,  -283,  -283,
    -283,  -283,  -283,  -283,  -283,  -283,  -283,  -283,  -283,  -283,
       0,     0,  -283,  -283,  -283,     0,   736,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -283,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -283,     0,
       0,  -283,  -283,     0,  -101,  -283,     0,  -283,  -283,  -283,
    -283,  -283,  -283,  -283,  -283,  -283,  -283,     0,     0,     0,
       0,     0,  -283,  -283,     0,  -283,     0,     0,  -283,  -283,
    -283,  -283,   284,     0,     5,     6,     7,     8,     9,    10,
      11,    12,    13,    14,  -592,  -592,  -592,     0,     0,  -592,
      15,     0,    16,    17,    18,    19,     0,     0,     0,     0,
       0,    20,    21,    22,    23,    24,    25,    26,     0,     0,
      27,     0,     0,     0,     0,     0,    28,     0,    30,    31,
      32,    33,    34,    35,    36,    37,    38,    39,     0,    40,
      41,    42,     0,     0,    43,     0,     0,    44,    45,     0,
      46,    47,    48,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    49,     0,     0,    50,    51,     0,    52,    53,     0,
      54,     0,     0,    55,     0,    56,    57,    58,    59,    60,
      61,     0,     0,    62,  -592,     0,     0,  -592,  -592,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    63,    64,    65,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -592,   284,  -592,     5,     6,
       7,     8,     9,    10,    11,    12,    13,    14,     0,     0,
    -592,     0,  -592,  -592,    15,     0,    16,    17,    18,    19,
       0,     0,     0,     0,     0,    20,    21,    22,    23,    24,
      25,    26,     0,     0,    27,     0,     0,     0,     0,     0,
      28,     0,    30,    31,    32,    33,    34,    35,    36,    37,
      38,    39,     0,    40,    41,    42,     0,     0,    43,     0,
       0,    44,    45,     0,    46,    47,    48,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    49,     0,     0,    50,    51,
       0,    52,    53,     0,    54,     0,     0,    55,     0,    56,
      57,    58,    59,    60,    61,     0,     0,    62,  -592,     0,
       0,  -592,  -592,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    63,    64,    65,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -592,
     284,  -592,     5,     6,     7,     8,     9,    10,    11,    12,
      13,    14,     0,     0,  -592,     0,     0,  -592,    15,  -592,
      16,    17,    18,    19,     0,     0,     0,     0,     0,    20,
      21,    22,    23,    24,    25,    26,     0,     0,    27,     0,
       0,     0,     0,     0,    28,     0,    30,    31,    32,    33,
      34,    35,    36,    37,    38,    39,     0,    40,    41,    42,
       0,     0,    43,     0,     0,    44,    45,     0,    46,    47,
      48,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    49,
       0,     0,    50,    51,     0,    52,    53,     0,    54,     0,
       0,    55,     0,    56,    57,    58,    59,    60,    61,     0,
       0,    62,  -592,     0,     0,  -592,  -592,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    63,    64,    65,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -592,   284,  -592,     5,     6,     7,     8,
       9,    10,    11,    12,    13,    14,     0,     0,  -592,     0,
       0,  -592,    15,     0,    16,    17,    18,    19,     0,     0,
       0,     0,     0,    20,    21,    22,    23,    24,    25,    26,
       0,     0,    27,     0,     0,     0,     0,     0,    28,     0,
      30,    31,    32,    33,    34,    35,    36,    37,    38,    39,
       0,    40,    41,    42,     0,     0,    43,     0,     0,    44,
      45,     0,    46,    47,    48,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    49,     0,     0,    50,    51,     0,    52,
      53,     0,    54,     0,     0,    55,     0,    56,    57,    58,
      59,    60,    61,     0,     0,    62,  -592,     0,     0,  -592,
    -592,     4,     0,     5,     6,     7,     8,     9,    10,    11,
      12,    13,    14,     0,     0,    63,    64,    65,     0,    15,
       0,    16,    17,    18,    19,     0,     0,  -592,     0,  -592,
      20,    21,    22,    23,    24,    25,    26,     0,     0,    27,
       0,     0,     0,     0,     0,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,     0,    40,    41,
      42,     0,     0,    43,     0,     0,    44,    45,     0,    46,
      47,    48,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      49,     0,     0,    50,    51,     0,    52,    53,     0,    54,
       0,     0,    55,     0,    56,    57,    58,    59,    60,    61,
       0,     0,    62,  -592,     0,     0,  -592,  -592,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    63,    64,    65,     0,     0,  -592,     0,     0,
       0,     0,     0,     0,  -592,   284,  -592,     5,     6,     7,
       8,     9,    10,    11,    12,    13,    14,     0,  -592,  -592,
       0,     0,     0,    15,     0,    16,    17,    18,    19,     0,
       0,     0,     0,     0,    20,    21,    22,    23,    24,    25,
      26,     0,     0,    27,     0,     0,     0,     0,     0,    28,
       0,    30,    31,    32,    33,    34,    35,    36,    37,    38,
      39,     0,    40,    41,    42,     0,     0,    43,     0,     0,
      44,    45,     0,    46,    47,    48,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    49,     0,     0,    50,    51,     0,
      52,    53,     0,    54,     0,     0,    55,     0,    56,    57,
      58,    59,    60,    61,     0,     0,    62,  -592,     0,     0,
    -592,  -592,   284,     0,     5,     6,     7,     8,     9,    10,
      11,    12,    13,    14,     0,     0,    63,    64,    65,     0,
      15,     0,    16,    17,    18,    19,     0,     0,  -592,     0,
    -592,    20,    21,    22,    23,    24,    25,    26,     0,     0,
      27,     0,     0,     0,     0,     0,    28,     0,    30,    31,
      32,    33,    34,    35,    36,    37,    38,    39,     0,    40,
      41,    42,     0,     0,    43,     0,     0,    44,    45,     0,
      46,    47,    48,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    49,     0,     0,   285,    51,     0,    52,    53,     0,
      54,     0,     0,    55,     0,    56,    57,    58,    59,    60,
      61,     0,     0,    62,  -592,     0,     0,  -592,  -592,   284,
       0,     5,     6,     7,     8,     9,    10,    11,    12,    13,
      14,     0,     0,    63,    64,    65,     0,    15,     0,    16,
      17,    18,    19,     0,  -592,  -592,     0,  -592,    20,    21,
      22,    23,    24,    25,    26,     0,     0,    27,     0,     0,
       0,     0,     0,    28,     0,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,     0,    40,    41,    42,     0,
       0,    43,     0,     0,    44,    45,     0,    46,    47,    48,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    49,     0,
       0,    50,    51,     0,    52,    53,     0,    54,     0,     0,
      55,     0,    56,    57,    58,    59,    60,    61,     0,     0,
      62,  -592,     0,     0,  -592,  -592,   284,     0,     5,     6,
       7,     8,     9,    10,    11,    12,    13,    14,     0,     0,
      63,    64,    65,     0,    15,     0,    16,    17,    18,    19,
       0,  -592,  -592,     0,  -592,    20,    21,    22,    23,    24,
      25,    26,     0,     0,    27,     0,     0,     0,     0,     0,
      28,     0,    30,    31,    32,    33,    34,    35,    36,    37,
      38,    39,     0,    40,    41,    42,     0,     0,    43,     0,
       0,    44,    45,     0,    46,    47,    48,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    49,     0,     0,    50,    51,
       0,    52,    53,     0,    54,     0,     0,    55,     0,    56,
      57,    58,    59,    60,    61,     0,     0,    62,  -592,     0,
       0,  -592,  -592,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    63,    64,    65,
       0,     0,  -592,     0,     0,     0,     0,     0,     0,  -592,
     284,  -592,     5,     6,     7,     8,     9,    10,    11,    12,
      13,    14,     0,     0,  -592,     0,     0,     0,    15,     0,
      16,    17,    18,    19,     0,     0,     0,     0,     0,    20,
      21,    22,    23,    24,    25,    26,     0,     0,    27,     0,
       0,     0,     0,     0,    28,     0,    30,    31,    32,    33,
      34,    35,    36,    37,    38,    39,     0,    40,    41,    42,
       0,     0,    43,     0,     0,    44,    45,     0,    46,    47,
      48,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    49,
       0,     0,    50,    51,     0,    52,    53,     0,    54,     0,
       0,    55,     0,    56,    57,    58,    59,    60,    61,     0,
       0,    62,  -592,     0,     0,  -592,  -592,     0,     0,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,     0,
       0,    63,    64,    65,     0,    15,     0,    16,    17,    18,
      19,     0,     0,  -592,     0,  -592,    20,    21,    22,    23,
      24,    25,    26,     0,     0,    27,     0,     0,     0,     0,
       0,    28,    29,    30,    31,    32,    33,    34,    35,    36,
      37,    38,    39,     0,    40,    41,    42,     0,     0,    43,
       0,     0,    44,    45,     0,    46,    47,    48,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    49,     0,     0,    50,
      51,     0,    52,    53,     0,    54,     0,     0,    55,     0,
      56,    57,    58,    59,    60,    61,     0,     0,    62,   238,
       0,     0,   239,   240,     0,     0,     5,     6,     7,     8,
       9,    10,    11,    12,    13,    14,     0,     0,    63,    64,
      65,     0,    15,     0,    16,    17,    18,    19,     0,     0,
     241,     0,   242,    20,    21,    22,    23,    24,    25,    26,
       0,     0,    27,     0,     0,     0,     0,     0,    28,     0,
      30,    31,    32,    33,    34,    35,    36,    37,    38,    39,
       0,    40,    41,    42,     0,     0,    43,     0,     0,    44,
      45,     0,    46,    47,    48,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    49,     0,     0,    50,    51,     0,    52,
      53,     0,    54,     0,     0,    55,     0,    56,    57,    58,
      59,    60,    61,     0,     0,    62,   238,     0,     0,   239,
     240,     0,     0,     5,     6,     7,     8,     9,    10,    11,
      12,    13,     0,     0,     0,    63,    64,    65,     0,    15,
       0,    16,    17,    18,    19,     0,     0,   241,     0,   242,
      20,    21,    22,    23,    24,    25,    26,     0,     0,    27,
       0,     0,     0,     0,     0,     0,     0,     0,    31,    32,
      33,    34,    35,    36,    37,    38,    39,     0,    40,    41,
      42,     0,     0,    43,     0,     0,    44,    45,     0,    46,
      47,    48,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     205,     0,     0,   115,    51,     0,    52,    53,     0,     0,
       0,     0,    55,     0,    56,    57,    58,    59,    60,    61,
       0,     0,    62,   238,     0,     0,   239,   240,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    63,    64,    65,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   241,     0,   242,   125,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,     0,     0,     0,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,     0,     0,     0,     0,     0,   159,
     160,   161,   162,   163,   164,   165,   166,    36,    37,   167,
      39,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   168,   169,   170,   171,   172,   173,
     174,   175,   176,     0,     0,   177,   178,     0,     0,   179,
     180,   181,   182,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   183,   184,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   185,   186,   187,   188,
     189,   190,   191,   192,   193,   194,     0,   195,   196,     0,
       0,     0,     0,     0,     0,   197,   198,  -562,  -562,  -562,
    -562,  -562,  -562,  -562,  -562,  -562,     0,     0,     0,     0,
       0,     0,     0,  -562,     0,  -562,  -562,  -562,  -562,     0,
    -562,     0,     0,     0,  -562,  -562,  -562,  -562,  -562,  -562,
    -562,     0,     0,  -562,     0,     0,     0,     0,     0,     0,
       0,     0,  -562,  -562,  -562,  -562,  -562,  -562,  -562,  -562,
    -562,     0,  -562,  -562,  -562,     0,     0,  -562,     0,     0,
    -562,  -562,     0,  -562,  -562,  -562,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  -562,     0,     0,  -562,  -562,     0,
    -562,  -562,     0,  -562,  -562,  -562,  -562,     0,  -562,  -562,
    -562,  -562,  -562,  -562,     0,     0,  -562,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -562,  -562,  -562,     0,
    -562,     0,     0,     0,     0,     0,  -562,  -564,  -564,  -564,
    -564,  -564,  -564,  -564,  -564,  -564,     0,     0,     0,     0,
       0,     0,     0,  -564,     0,  -564,  -564,  -564,  -564,     0,
    -564,     0,     0,     0,  -564,  -564,  -564,  -564,  -564,  -564,
    -564,     0,     0,  -564,     0,     0,     0,     0,     0,     0,
       0,     0,  -564,  -564,  -564,  -564,  -564,  -564,  -564,  -564,
    -564,     0,  -564,  -564,  -564,     0,     0,  -564,     0,     0,
    -564,  -564,     0,  -564,  -564,  -564,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  -564,     0,     0,  -564,  -564,     0,
    -564,  -564,     0,  -564,  -564,  -564,  -564,     0,  -564,  -564,
    -564,  -564,  -564,  -564,     0,     0,  -564,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -564,  -564,  -564,     0,
    -564,     0,     0,     0,     0,     0,  -564,  -563,  -563,  -563,
    -563,  -563,  -563,  -563,  -563,  -563,     0,     0,     0,     0,
       0,     0,     0,  -563,     0,  -563,  -563,  -563,  -563,     0,
    -563,     0,     0,     0,  -563,  -563,  -563,  -563,  -563,  -563,
    -563,     0,     0,  -563,     0,     0,     0,     0,     0,     0,
       0,     0,  -563,  -563,  -563,  -563,  -563,  -563,  -563,  -563,
    -563,     0,  -563,  -563,  -563,     0,     0,  -563,     0,     0,
    -563,  -563,     0,  -563,  -563,  -563,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  -563,     0,     0,  -563,  -563,     0,
    -563,  -563,     0,  -563,  -563,  -563,  -563,     0,  -563,  -563,
    -563,  -563,  -563,  -563,     0,     0,  -563,     0,     0,     0,
       0,     0,     0,  -565,  -565,  -565,  -565,  -565,  -565,  -565,
    -565,  -565,     0,     0,     0,     0,  -563,  -563,  -563,  -565,
    -563,  -565,  -565,  -565,  -565,     0,  -563,     0,     0,     0,
    -565,  -565,  -565,  -565,  -565,  -565,  -565,     0,     0,  -565,
       0,     0,     0,     0,     0,     0,     0,     0,  -565,  -565,
    -565,  -565,  -565,  -565,  -565,  -565,  -565,     0,  -565,  -565,
    -565,     0,     0,  -565,     0,     0,  -565,  -565,     0,  -565,
    -565,  -565,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -565,   769,     0,  -565,  -565,     0,  -565,  -565,     0,  -565,
    -565,  -565,  -565,     0,  -565,  -565,  -565,  -565,  -565,  -565,
       0,     0,  -565,     0,     0,     0,     0,     0,     0,   -99,
    -566,  -566,  -566,  -566,  -566,  -566,  -566,  -566,  -566,     0,
       0,     0,  -565,  -565,  -565,     0,  -566,     0,  -566,  -566,
    -566,  -566,  -565,     0,     0,     0,     0,  -566,  -566,  -566,
    -566,  -566,  -566,  -566,     0,     0,  -566,     0,     0,     0,
       0,     0,     0,     0,     0,  -566,  -566,  -566,  -566,  -566,
    -566,  -566,  -566,  -566,     0,  -566,  -566,  -566,     0,     0,
    -566,     0,     0,  -566,  -566,     0,  -566,  -566,  -566,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -566,   770,     0,
    -566,  -566,     0,  -566,  -566,     0,  -566,  -566,  -566,  -566,
       0,  -566,  -566,  -566,  -566,  -566,  -566,     0,     0,  -566,
       0,     0,     0,     0,     0,     0,  -101,  -252,  -252,  -252,
    -252,  -252,  -252,  -252,  -252,  -252,     0,     0,     0,  -566,
    -566,  -566,     0,  -252,     0,  -252,  -252,  -252,  -252,  -566,
       0,     0,     0,     0,  -252,  -252,  -252,  -252,  -252,  -252,
    -252,     0,     0,  -252,     0,     0,     0,     0,     0,     0,
       0,     0,  -252,  -252,  -252,  -252,  -252,  -252,  -252,  -252,
    -252,     0,  -252,  -252,  -252,     0,     0,  -252,     0,     0,
    -252,  -252,     0,  -252,  -252,  -252,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  -252,     0,     0,  -252,  -252,     0,
    -252,  -252,     0,  -252,  -252,  -252,  -252,     0,  -252,  -252,
    -252,  -252,  -252,  -252,     0,     0,  -252,     0,     0,     0,
       0,     0,     0,  -567,  -567,  -567,  -567,  -567,  -567,  -567,
    -567,  -567,     0,     0,     0,     0,  -252,  -252,  -252,  -567,
       0,  -567,  -567,  -567,  -567,     0,   266,     0,     0,     0,
    -567,  -567,  -567,  -567,  -567,  -567,  -567,     0,     0,  -567,
       0,     0,     0,     0,     0,     0,     0,     0,  -567,  -567,
    -567,  -567,  -567,  -567,  -567,  -567,  -567,     0,  -567,  -567,
    -567,     0,     0,  -567,     0,     0,  -567,  -567,     0,  -567,
    -567,  -567,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -567,     0,     0,  -567,  -567,     0,  -567,  -567,     0,  -567,
    -567,  -567,  -567,     0,  -567,  -567,  -567,  -567,  -567,  -567,
       0,     0,  -567,     0,     0,     0,     0,     0,     0,  -568,
    -568,  -568,  -568,  -568,  -568,  -568,  -568,  -568,     0,     0,
       0,     0,  -567,  -567,  -567,  -568,     0,  -568,  -568,  -568,
    -568,     0,  -567,     0,     0,     0,  -568,  -568,  -568,  -568,
    -568,  -568,  -568,     0,     0,  -568,     0,     0,     0,     0,
       0,     0,     0,     0,  -568,  -568,  -568,  -568,  -568,  -568,
    -568,  -568,  -568,     0,  -568,  -568,  -568,     0,     0,  -568,
       0,     0,  -568,  -568,     0,  -568,  -568,  -568,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -568,     0,     0,  -568,
    -568,     0,  -568,  -568,     0,  -568,  -568,  -568,  -568,     0,
    -568,  -568,  -568,  -568,  -568,  -568,     0,     0,  -568,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -568,  -568,
    -568,     0,     0,     0,     0,     0,     0,     0,  -568,   125,
     126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,   141,   142,   143,   144,   145,
     146,   147,   148,     0,     0,     0,   149,   150,   151,   224,
     225,   226,   227,   156,   157,   158,     0,     0,     0,     0,
       0,   159,   160,   161,   228,   229,   230,   231,   166,   309,
     310,   232,   311,     0,     0,     0,     0,     0,     0,   312,
       0,     0,     0,     0,     0,     0,   168,   169,   170,   171,
     172,   173,   174,   175,   176,     0,     0,   177,   178,     0,
       0,   179,   180,   181,   182,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   183,   184,     0,     0,     0,
       0,     0,     0,     0,   313,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   185,   186,
     187,   188,   189,   190,   191,   192,   193,   194,     0,   195,
     196,     0,     0,     0,     0,     0,     0,   197,   125,   126,
     127,   128,   129,   130,   131,   132,   133,   134,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,     0,     0,     0,   149,   150,   151,   224,   225,
     226,   227,   156,   157,   158,     0,     0,     0,     0,     0,
     159,   160,   161,   228,   229,   230,   231,   166,   309,   310,
     232,   311,     0,     0,     0,     0,     0,     0,   312,     0,
       0,     0,     0,     0,     0,   168,   169,   170,   171,   172,
     173,   174,   175,   176,     0,     0,   177,   178,     0,     0,
     179,   180,   181,   182,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   183,   184,     0,     0,     0,     0,
       0,     0,     0,   433,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   185,   186,   187,
     188,   189,   190,   191,   192,   193,   194,     0,   195,   196,
       0,     0,     0,     0,     0,     0,   197,   125,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,     0,     0,     0,   149,   150,   151,   224,   225,   226,
     227,   156,   157,   158,     0,     0,     0,     0,     0,   159,
     160,   161,   228,   229,   230,   231,   166,     0,     0,   232,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   168,   169,   170,   171,   172,   173,
     174,   175,   176,     0,     0,   177,   178,     0,     0,   179,
     180,   181,   182,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   183,   184,     0,     0,     0,   233,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   185,   186,   187,   188,
     189,   190,   191,   192,   193,   194,     0,   195,   196,     0,
       0,     0,     0,     0,     0,   197,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
       0,     0,     0,   149,   150,   151,   224,   225,   226,   227,
     156,   157,   158,     0,     0,     0,     0,     0,   159,   160,
     161,   228,   229,   230,   231,   166,     0,     0,   232,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   168,   169,   170,   171,   172,   173,   174,
     175,   176,     0,     0,   177,   178,     0,     0,   179,   180,
     181,   182,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   183,   184,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   185,   186,   187,   188,   189,
     190,   191,   192,   193,   194,     0,   195,   196,     0,     0,
       0,     0,     0,     0,   197,     5,     6,     7,     8,     9,
      10,    11,    12,    13,     0,     0,     0,     0,     0,     0,
       0,    15,     0,   104,   105,    18,    19,     0,     0,     0,
       0,     0,   106,   107,   108,    23,    24,    25,    26,     0,
       0,   109,     0,     0,     0,     0,     0,     0,     0,     0,
      31,    32,    33,    34,    35,    36,    37,    38,    39,     0,
      40,    41,    42,     0,     0,    43,     0,     0,    44,    45,
       0,   112,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   302,     0,     0,   115,    51,     0,    52,    53,
       0,     0,     0,     0,    55,     0,    56,    57,    58,    59,
      60,    61,     0,     0,    62,     0,     0,     5,     6,     7,
       8,     9,    10,    11,    12,    13,     0,     0,     0,     0,
       0,     0,     0,    15,   116,   104,   105,    18,    19,     0,
       0,     0,   303,     0,   106,   107,   108,    23,    24,    25,
      26,     0,     0,   109,     0,     0,     0,     0,     0,     0,
       0,     0,    31,    32,    33,    34,    35,    36,    37,    38,
      39,     0,    40,    41,    42,     0,     0,    43,     0,     0,
      44,    45,     0,   112,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   302,     0,     0,   115,    51,     0,
      52,    53,     0,     0,     0,     0,    55,     0,    56,    57,
      58,    59,    60,    61,     0,     0,    62,     0,     0,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,     0,
       0,     0,     0,     0,     0,    15,   116,    16,    17,    18,
      19,     0,     0,     0,   556,     0,    20,    21,    22,    23,
      24,    25,    26,     0,     0,    27,     0,     0,     0,     0,
       0,    28,    29,    30,    31,    32,    33,    34,    35,    36,
      37,    38,    39,     0,    40,    41,    42,     0,     0,    43,
       0,     0,    44,    45,     0,    46,    47,    48,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    49,     0,     0,    50,
      51,     0,    52,    53,     0,    54,     0,     0,    55,     0,
      56,    57,    58,    59,    60,    61,     0,     0,    62,     0,
       0,     0,     0,     0,     0,     5,     6,     7,     8,     9,
      10,    11,    12,    13,    14,     0,     0,     0,    63,    64,
      65,    15,     0,    16,    17,    18,    19,     0,     0,     0,
       0,     0,    20,    21,    22,    23,    24,    25,    26,     0,
       0,    27,     0,     0,     0,     0,     0,    28,     0,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,     0,
      40,    41,    42,     0,     0,    43,     0,     0,    44,    45,
       0,    46,    47,    48,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    49,     0,     0,    50,    51,     0,    52,    53,
       0,    54,     0,     0,    55,     0,    56,    57,    58,    59,
      60,    61,     0,     0,    62,     0,     0,     0,     0,     0,
       0,     5,     6,     7,     8,     9,    10,    11,    12,    13,
       0,     0,     0,     0,    63,    64,    65,    15,     0,    16,
      17,    18,    19,     0,     0,     0,     0,     0,    20,    21,
      22,    23,    24,    25,    26,     0,     0,   109,     0,     0,
       0,     0,     0,     0,     0,     0,    31,    32,    33,   251,
      35,    36,    37,    38,    39,     0,    40,    41,    42,     0,
       0,    43,     0,     0,    44,    45,     0,    46,    47,    48,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   205,     0,
       0,   115,    51,     0,    52,    53,     0,   252,   253,   254,
      55,     0,    56,    57,    58,    59,    60,    61,     0,     0,
      62,     0,     0,     0,     0,     0,     0,     5,     6,     7,
       8,     9,    10,    11,    12,    13,     0,     0,     0,     0,
      63,   255,    65,    15,     0,   104,   105,    18,    19,     0,
       0,     0,     0,     0,   106,   107,   108,    23,    24,    25,
      26,     0,     0,   109,     0,     0,     0,     0,     0,     0,
       0,     0,    31,    32,    33,   251,    35,    36,    37,    38,
      39,     0,    40,    41,    42,     0,     0,    43,     0,     0,
      44,    45,     0,    46,    47,    48,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   205,     0,     0,   115,    51,     0,
      52,    53,     0,   665,   253,   254,    55,     0,    56,    57,
      58,    59,    60,    61,     0,     0,    62,     0,     0,     0,
       0,     0,     0,     5,     6,     7,     8,     9,    10,    11,
      12,    13,     0,     0,     0,     0,    63,   255,    65,    15,
       0,   104,   105,    18,    19,     0,     0,     0,     0,     0,
     106,   107,   108,    23,    24,    25,    26,     0,     0,   109,
       0,     0,     0,     0,     0,     0,     0,     0,    31,    32,
      33,   251,    35,    36,    37,    38,    39,     0,    40,    41,
      42,     0,     0,    43,     0,     0,    44,    45,     0,    46,
      47,    48,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     205,     0,     0,   115,    51,     0,    52,    53,     0,   252,
     253,     0,    55,     0,    56,    57,    58,    59,    60,    61,
       0,     0,    62,     0,     0,     0,     0,     0,     0,     5,
       6,     7,     8,     9,    10,    11,    12,    13,     0,     0,
       0,     0,    63,   255,    65,    15,     0,   104,   105,    18,
      19,     0,     0,     0,     0,     0,   106,   107,   108,    23,
      24,    25,    26,     0,     0,   109,     0,     0,     0,     0,
       0,     0,     0,     0,    31,    32,    33,   251,    35,    36,
      37,    38,    39,     0,    40,    41,    42,     0,     0,    43,
       0,     0,    44,    45,     0,    46,    47,    48,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   205,     0,     0,   115,
      51,     0,    52,    53,     0,     0,   253,   254,    55,     0,
      56,    57,    58,    59,    60,    61,     0,     0,    62,     0,
       0,     0,     0,     0,     0,     5,     6,     7,     8,     9,
      10,    11,    12,    13,     0,     0,     0,     0,    63,   255,
      65,    15,     0,   104,   105,    18,    19,     0,     0,     0,
       0,     0,   106,   107,   108,    23,    24,    25,    26,     0,
       0,   109,     0,     0,     0,     0,     0,     0,     0,     0,
      31,    32,    33,   251,    35,    36,    37,    38,    39,     0,
      40,    41,    42,     0,     0,    43,     0,     0,    44,    45,
       0,    46,    47,    48,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   205,     0,     0,   115,    51,     0,    52,    53,
       0,   665,   253,     0,    55,     0,    56,    57,    58,    59,
      60,    61,     0,     0,    62,     0,     0,     0,     0,     0,
       0,     5,     6,     7,     8,     9,    10,    11,    12,    13,
       0,     0,     0,     0,    63,   255,    65,    15,     0,   104,
     105,    18,    19,     0,     0,     0,     0,     0,   106,   107,
     108,    23,    24,    25,    26,     0,     0,   109,     0,     0,
       0,     0,     0,     0,     0,     0,    31,    32,    33,   251,
      35,    36,    37,    38,    39,     0,    40,    41,    42,     0,
       0,    43,     0,     0,    44,    45,     0,    46,    47,    48,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   205,     0,
       0,   115,    51,     0,    52,    53,     0,     0,   253,     0,
      55,     0,    56,    57,    58,    59,    60,    61,     0,     0,
      62,     0,     0,     0,     0,     0,     0,     5,     6,     7,
       8,     9,    10,    11,    12,    13,     0,     0,     0,     0,
      63,   255,    65,    15,     0,    16,    17,    18,    19,     0,
       0,     0,     0,     0,    20,    21,    22,    23,    24,    25,
      26,     0,     0,   109,     0,     0,     0,     0,     0,     0,
       0,     0,    31,    32,    33,    34,    35,    36,    37,    38,
      39,     0,    40,    41,    42,     0,     0,    43,     0,     0,
      44,    45,     0,    46,    47,    48,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   205,     0,     0,   115,    51,     0,
      52,    53,     0,   550,     0,     0,    55,     0,    56,    57,
      58,    59,    60,    61,     0,     0,    62,     0,     0,     0,
       0,     0,     0,     5,     6,     7,     8,     9,    10,    11,
      12,    13,     0,     0,     0,     0,    63,   255,    65,    15,
       0,   104,   105,    18,    19,     0,     0,     0,     0,     0,
     106,   107,   108,    23,    24,    25,    26,     0,     0,   109,
       0,     0,     0,     0,     0,     0,     0,     0,    31,    32,
      33,    34,    35,    36,    37,    38,    39,     0,    40,    41,
      42,     0,     0,    43,     0,     0,    44,    45,     0,    46,
      47,    48,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     205,     0,     0,   115,    51,     0,    52,    53,     0,   252,
       0,     0,    55,     0,    56,    57,    58,    59,    60,    61,
       0,     0,    62,     0,     0,     0,     0,     0,     0,     5,
       6,     7,     8,     9,    10,    11,    12,    13,     0,     0,
       0,     0,    63,   255,    65,    15,     0,   104,   105,    18,
      19,     0,     0,     0,     0,     0,   106,   107,   108,    23,
      24,    25,    26,     0,     0,   109,     0,     0,     0,     0,
       0,     0,     0,     0,    31,    32,    33,    34,    35,    36,
      37,    38,    39,     0,    40,    41,    42,     0,     0,    43,
       0,     0,    44,    45,     0,    46,    47,    48,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   205,     0,     0,   115,
      51,     0,    52,    53,     0,   550,     0,     0,    55,     0,
      56,    57,    58,    59,    60,    61,     0,     0,    62,     0,
       0,     0,     0,     0,     0,     5,     6,     7,     8,     9,
      10,    11,    12,    13,     0,     0,     0,     0,    63,   255,
      65,    15,     0,   104,   105,    18,    19,     0,     0,     0,
       0,     0,   106,   107,   108,    23,    24,    25,    26,     0,
       0,   109,     0,     0,     0,     0,     0,     0,     0,     0,
      31,    32,    33,    34,    35,    36,    37,    38,    39,     0,
      40,    41,    42,     0,     0,    43,     0,     0,    44,    45,
       0,    46,    47,    48,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   205,     0,     0,   115,    51,     0,    52,    53,
       0,   829,     0,     0,    55,     0,    56,    57,    58,    59,
      60,    61,     0,     0,    62,     0,     0,     0,     0,     0,
       0,     5,     6,     7,     8,     9,    10,    11,    12,    13,
       0,     0,     0,     0,    63,   255,    65,    15,     0,   104,
     105,    18,    19,     0,     0,     0,     0,     0,   106,   107,
     108,    23,    24,    25,    26,     0,     0,   109,     0,     0,
       0,     0,     0,     0,     0,     0,    31,    32,    33,    34,
      35,    36,    37,    38,    39,     0,    40,    41,    42,     0,
       0,    43,     0,     0,    44,    45,     0,    46,    47,    48,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   205,     0,
       0,   115,    51,     0,    52,    53,     0,   665,     0,     0,
      55,     0,    56,    57,    58,    59,    60,    61,     0,     0,
      62,     0,     0,     0,     0,     0,     0,     5,     6,     7,
       8,     9,    10,    11,    12,    13,     0,     0,     0,     0,
      63,   255,    65,    15,     0,    16,    17,    18,    19,     0,
       0,     0,     0,     0,    20,    21,    22,    23,    24,    25,
      26,     0,     0,    27,     0,     0,     0,     0,     0,     0,
       0,     0,    31,    32,    33,    34,    35,    36,    37,    38,
      39,     0,    40,    41,    42,     0,     0,    43,     0,     0,
      44,    45,     0,    46,    47,    48,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   205,     0,     0,   115,    51,     0,
      52,    53,     0,     0,     0,     0,    55,     0,    56,    57,
      58,    59,    60,    61,     0,     0,    62,     0,     0,     0,
       0,     0,     0,     5,     6,     7,     8,     9,    10,    11,
      12,    13,     0,     0,     0,     0,    63,    64,    65,    15,
       0,   104,   105,    18,    19,     0,     0,     0,     0,     0,
     106,   107,   108,    23,    24,    25,    26,     0,     0,   109,
       0,     0,     0,     0,     0,     0,     0,     0,    31,    32,
      33,    34,    35,    36,    37,    38,    39,     0,    40,    41,
      42,     0,     0,    43,     0,     0,    44,    45,     0,    46,
      47,    48,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     205,     0,     0,   115,    51,     0,    52,    53,     0,     0,
       0,     0,    55,     0,    56,    57,    58,    59,    60,    61,
       0,     0,    62,     0,     0,     0,     0,     0,     0,     5,
       6,     7,     8,     9,    10,    11,    12,    13,     0,     0,
       0,     0,    63,   255,    65,    15,     0,    16,    17,    18,
      19,     0,     0,     0,     0,     0,    20,    21,    22,    23,
      24,    25,    26,     0,     0,   109,     0,     0,     0,     0,
       0,     0,     0,     0,    31,    32,    33,    34,    35,    36,
      37,    38,    39,     0,    40,    41,    42,     0,     0,    43,
       0,     0,    44,    45,     0,    46,    47,    48,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   205,     0,     0,   115,
      51,     0,    52,    53,     0,     0,     0,     0,    55,     0,
      56,    57,    58,    59,    60,    61,     0,     0,    62,     0,
       0,     0,     0,     0,     0,     5,     6,     7,     8,     9,
      10,    11,    12,    13,     0,     0,     0,     0,    63,   255,
      65,    15,     0,   104,   105,    18,    19,     0,     0,     0,
       0,     0,   106,   107,   108,    23,    24,    25,    26,     0,
       0,   109,     0,     0,     0,     0,     0,     0,     0,     0,
      31,    32,    33,   110,    35,    36,    37,   111,    39,     0,
      40,    41,    42,     0,     0,    43,     0,     0,    44,    45,
       0,   112,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   113,
       0,     0,   114,     0,     0,   115,    51,     0,    52,    53,
       0,     0,     0,     0,    55,     0,    56,    57,    58,    59,
      60,    61,     0,     0,    62,     0,     0,     5,     6,     7,
       8,     9,    10,    11,    12,    13,     0,     0,     0,     0,
       0,     0,     0,    15,   116,   104,   105,    18,    19,     0,
       0,     0,     0,     0,   106,   107,   108,    23,    24,    25,
      26,     0,     0,   109,     0,     0,     0,     0,     0,     0,
       0,     0,    31,    32,    33,    34,    35,    36,    37,    38,
      39,     0,    40,    41,    42,     0,     0,    43,     0,     0,
      44,    45,     0,   216,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   217,     0,     0,    50,    51,     0,
      52,    53,     0,    54,     0,     0,    55,     0,    56,    57,
      58,    59,    60,    61,     0,     0,    62,     0,     0,     5,
       6,     7,     8,     9,    10,    11,    12,    13,     0,     0,
       0,     0,     0,     0,     0,    15,   116,   104,   105,    18,
      19,     0,     0,     0,     0,     0,   106,   107,   108,    23,
      24,    25,    26,     0,     0,   109,     0,     0,     0,     0,
       0,     0,     0,     0,    31,    32,    33,    34,    35,    36,
      37,    38,    39,     0,    40,    41,    42,     0,     0,    43,
       0,     0,    44,    45,     0,   112,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   302,     0,     0,   349,
      51,     0,    52,    53,     0,   350,     0,     0,    55,     0,
      56,    57,    58,    59,    60,    61,     0,     0,    62,     0,
       0,     5,     6,     7,     8,     9,    10,    11,    12,    13,
       0,     0,     0,     0,     0,     0,     0,    15,   116,   104,
     105,    18,    19,     0,     0,     0,     0,     0,   106,   107,
     108,    23,    24,    25,    26,     0,     0,   109,     0,     0,
       0,     0,     0,     0,     0,     0,    31,    32,    33,   110,
      35,    36,    37,   111,    39,     0,    40,    41,    42,     0,
       0,    43,     0,     0,    44,    45,     0,   112,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   114,     0,
       0,   115,    51,     0,    52,    53,     0,     0,     0,     0,
      55,     0,    56,    57,    58,    59,    60,    61,     0,     0,
      62,     0,     0,     5,     6,     7,     8,     9,    10,    11,
      12,    13,     0,     0,     0,     0,     0,     0,     0,    15,
     116,   104,   105,    18,    19,     0,     0,     0,     0,     0,
     106,   107,   108,    23,    24,    25,    26,     0,     0,   109,
       0,     0,     0,     0,     0,     0,     0,     0,    31,    32,
      33,    34,    35,    36,    37,    38,    39,     0,    40,    41,
      42,     0,     0,    43,     0,     0,    44,    45,     0,   112,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     302,     0,     0,   349,    51,     0,    52,    53,     0,     0,
       0,     0,    55,     0,    56,    57,    58,    59,    60,    61,
       0,     0,    62,     0,     0,     5,     6,     7,     8,     9,
      10,    11,    12,    13,     0,     0,     0,     0,     0,     0,
       0,    15,   116,   104,   105,    18,    19,     0,     0,     0,
       0,     0,   106,   107,   108,    23,    24,    25,    26,     0,
       0,   109,     0,     0,     0,     0,     0,     0,     0,     0,
      31,    32,    33,    34,    35,    36,    37,    38,    39,     0,
      40,    41,    42,     0,     0,    43,     0,     0,    44,    45,
       0,   112,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   901,     0,     0,   115,    51,     0,    52,    53,
       0,     0,     0,     0,    55,     0,    56,    57,    58,    59,
      60,    61,     0,     0,    62,     0,     0,     5,     6,     7,
       8,     9,    10,    11,    12,    13,     0,     0,     0,     0,
       0,     0,     0,    15,   116,   104,   105,    18,    19,     0,
       0,     0,     0,     0,   106,   107,   108,    23,    24,    25,
      26,     0,     0,   109,     0,     0,     0,     0,     0,     0,
       0,     0,    31,    32,    33,    34,    35,    36,    37,    38,
      39,     0,    40,    41,    42,     0,     0,    43,     0,     0,
      44,    45,     0,   216,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   927,     0,     0,   115,    51,     0,
      52,    53,     0,   608,   603,     0,    55,   609,    56,    57,
      58,    59,    60,    61,     0,     0,    62,     0,     0,     0,
       0,     0,   168,   169,   170,   171,   172,   173,   174,   175,
     176,     0,     0,   177,   178,     0,   116,   179,   180,   181,
     182,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   183,   184,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   185,   186,   187,   188,   189,   190,
     191,   192,   193,   194,     0,   195,   196,   639,   595,     0,
       0,   640,     0,   197,   266,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   168,   169,   170,   171,
     172,   173,   174,   175,   176,     0,     0,   177,   178,     0,
       0,   179,   180,   181,   182,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   183,   184,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   185,   186,
     187,   188,   189,   190,   191,   192,   193,   194,     0,   195,
     196,   642,   603,     0,     0,   643,     0,   197,   266,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     168,   169,   170,   171,   172,   173,   174,   175,   176,     0,
       0,   177,   178,     0,     0,   179,   180,   181,   182,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   183,
     184,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   185,   186,   187,   188,   189,   190,   191,   192,
     193,   194,     0,   195,   196,   649,   595,     0,     0,   650,
       0,   197,   266,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   168,   169,   170,   171,   172,   173,
     174,   175,   176,     0,     0,   177,   178,     0,     0,   179,
     180,   181,   182,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   183,   184,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   185,   186,   187,   188,
     189,   190,   191,   192,   193,   194,     0,   195,   196,   652,
     603,     0,     0,   653,     0,   197,   266,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   168,   169,
     170,   171,   172,   173,   174,   175,   176,     0,     0,   177,
     178,     0,     0,   179,   180,   181,   182,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   183,   184,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
       0,   195,   196,   687,   595,     0,     0,   688,     0,   197,
     266,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   168,   169,   170,   171,   172,   173,   174,   175,
     176,     0,     0,   177,   178,     0,     0,   179,   180,   181,
     182,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   183,   184,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   185,   186,   187,   188,   189,   190,
     191,   192,   193,   194,     0,   195,   196,   690,   603,     0,
       0,   691,     0,   197,   266,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   168,   169,   170,   171,
     172,   173,   174,   175,   176,     0,     0,   177,   178,     0,
       0,   179,   180,   181,   182,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   183,   184,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   185,   186,
     187,   188,   189,   190,   191,   192,   193,   194,     0,   195,
     196,   834,   595,     0,     0,   835,     0,   197,   266,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     168,   169,   170,   171,   172,   173,   174,   175,   176,     0,
       0,   177,   178,     0,     0,   179,   180,   181,   182,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   183,
     184,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   185,   186,   187,   188,   189,   190,   191,   192,
     193,   194,     0,   195,   196,   837,   603,     0,     0,   838,
       0,   197,   266,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   168,   169,   170,   171,   172,   173,
     174,   175,   176,     0,     0,   177,   178,     0,     0,   179,
     180,   181,   182,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   183,   184,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   185,   186,   187,   188,
     189,   190,   191,   192,   193,   194,     0,   195,   196,   990,
     595,     0,     0,   991,     0,   197,   266,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   168,   169,
     170,   171,   172,   173,   174,   175,   176,     0,     0,   177,
     178,     0,     0,   179,   180,   181,   182,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   183,   184,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
       0,   195,   196,  1003,   595,     0,     0,  1004,     0,   197,
     266,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   168,   169,   170,   171,   172,   173,   174,   175,
     176,     0,     0,   177,   178,     0,     0,   179,   180,   181,
     182,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   183,   184,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   185,   186,   187,   188,   189,   190,
     191,   192,   193,   194,     0,   195,   196,  1006,   603,     0,
       0,  1007,     0,   197,   266,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   168,   169,   170,   171,
     172,   173,   174,   175,   176,     0,     0,   177,   178,     0,
       0,   179,   180,   181,   182,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   183,   184,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   185,   186,
     187,   188,   189,   190,   191,   192,   193,   194,     0,   195,
     196,   608,   603,     0,     0,   609,     0,   197,   266,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     168,   169,   170,   171,   172,   173,   174,   175,   176,     0,
       0,   177,   178,     0,     0,   179,   180,   181,   182,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   183,
     184,   353,   354,   355,   356,   357,   358,   359,   360,   361,
     362,   363,   364,   365,     0,     0,   366,   367,     0,     0,
       0,     0,   185,   186,   187,   188,   189,   190,   191,   192,
     193,   194,     0,   195,   196,     0,     0,     0,     0,     0,
       0,   197,     0,     0,     0,     0,     0,     0,     0,   368,
       0,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   353,   354,   355,   356,   357,   358,   359,   360,   361,
     362,   363,   364,   365,     0,   242,   366,   367,     0,     0,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
     363,   364,   365,     0,     0,   366,   367,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   368,
       0,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,     0,     0,     0,     0,     0,     0,     0,   368,  -259,
     369,   370,   371,   372,   373,   374,   375,   376,   377,   378,
       0,     0,     0,     0,     0,     0,     0,     0,  -260,   353,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
     364,   365,     0,     0,   366,   367,     0,     0,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,     0,     0,   366,   367,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   368,     0,   369,
     370,   371,   372,   373,   374,   375,   376,   377,   378,     0,
       0,     0,     0,     0,     0,     0,   368,  -261,   369,   370,
     371,   372,   373,   374,   375,   376,   377,   378,     0,     0,
       0,     0,     0,     0,     0,     0,  -262,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,   363,   364,   365,
       0,     0,   366,   367,     0,     0,     0,   447,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,     0,     0,   366,   367,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   368,     0,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   368,     0,   369,   370,
     371,   372,   373,   374,   375,   376,   377,   378,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,  -593,
    -593,     0,     0,   366,   367,   353,   354,   355,   356,   357,
     358,   359,   360,     0,   362,   363,     0,     0,     0,     0,
     366,   367,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   369,   370,
     371,   372,   373,   374,   375,   376,   377,   378,     0,     0,
       0,     0,     0,     0,     0,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,   353,  -593,  -593,  -593,  -593,
     358,   359,     0,     0,  -593,  -593,     0,     0,     0,     0,
     366,   367,   353,   354,   355,   356,   357,   358,   359,     0,
       0,   362,   363,     0,     0,     0,     0,   366,   367,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,     0,     0,     0,     0,     0,
       0,     0,   369,   370,   371,   372,   373,   374,   375,   376,
     377,   378
};

static const yytype_int16 yycheck[] =
{
       2,    27,    85,    16,    17,    27,   213,    20,    14,     4,
       2,    28,     4,     5,     6,   308,     7,     9,    10,    21,
     308,    13,    28,    15,    16,    17,   704,   427,    20,   262,
     436,    16,    17,    83,    84,    20,    10,   442,     5,     6,
      22,    15,     7,    16,    17,    50,    13,    20,   793,    14,
      52,    53,   707,     2,    25,     4,    26,   352,    50,   491,
     391,   392,    54,    28,   454,    56,    25,    52,    53,   635,
      67,    78,    64,   296,    16,    54,    26,   300,   644,    52,
      53,   303,   114,    29,    15,    25,    78,    54,   514,   381,
      27,    56,    91,   483,   886,   611,   612,   450,    25,   379,
     909,   454,    87,   383,    25,   107,   386,     0,    21,    22,
      55,    78,   260,   405,   262,    91,    57,   719,    25,   101,
     119,   113,    25,   115,   556,   119,   406,    16,    17,   421,
      25,    20,    58,    59,    60,    61,    67,    28,   430,    57,
     420,    89,   422,   119,   285,   289,   140,   295,   320,   293,
      51,   431,    16,    17,    55,   321,    20,    91,   324,   209,
     326,    89,   328,    52,   330,   111,   136,    26,   136,   140,
     220,   113,   142,    89,   116,   117,   113,   738,   119,   116,
     117,   140,   743,   142,   993,   119,   136,   103,   101,   469,
      89,   983,    80,    72,   107,   108,   704,   145,   943,   707,
     140,   493,   144,   121,   146,    89,   884,   144,   349,   146,
     123,   719,   204,   140,   494,   508,   894,   145,   140,   140,
     508,   142,   214,   215,   146,   458,    51,   119,   906,   145,
      89,   281,   748,   140,   140,   890,   124,   140,    89,   119,
     214,   215,   233,    91,   103,   140,   145,    72,   127,   128,
     129,   130,   131,   266,    18,   305,    20,   270,   260,   664,
     262,   145,    89,    91,   266,    91,     9,    10,   233,   491,
     442,   119,    15,    89,   266,   100,   101,   136,   270,   138,
     285,   266,   274,   275,   674,   270,   145,   279,    64,   101,
     287,   119,   284,   285,   145,   727,   303,   270,   295,   296,
     292,   126,   113,   300,   906,   116,   117,   909,    50,   457,
     458,   303,   243,   879,   126,    37,    38,   461,   145,   997,
     673,   674,   352,    62,    89,    64,    65,    72,   472,   145,
     407,    58,    59,  1011,   556,   284,   303,   142,   631,   634,
     142,    89,   337,   292,   349,   337,   338,   339,   340,   341,
     342,   343,   344,    58,    59,   347,   287,   349,   350,   531,
     352,   391,   392,   529,   338,   339,   340,   341,   381,   123,
     113,   350,   404,   115,    89,   114,   115,   803,   778,   381,
     145,   270,   890,   350,   129,   130,   131,   313,   337,   381,
      55,   993,   405,   342,   820,   821,   381,   145,   906,   391,
     392,   909,   119,   405,   735,   553,   270,    91,   421,   740,
     741,   555,   414,   405,    91,   407,   408,   430,   383,   421,
     405,   386,   448,   142,    55,   417,   448,   146,   430,   421,
     145,    60,    89,   425,    63,   668,   421,    25,   430,   140,
     732,   406,   119,   435,    20,   430,   103,    91,   465,   140,
      91,   731,   659,   733,    57,   457,   458,   422,   347,   465,
     136,   684,   755,   352,   466,   450,   431,   755,    72,   454,
     383,   214,   215,   879,   466,   119,   119,   450,   119,   108,
     493,   138,   489,   475,   491,   993,   630,   143,   145,   661,
     880,   493,   664,   406,   139,   480,   140,   489,   483,   491,
     465,   493,    91,   137,   469,   727,    91,   480,   493,   422,
     512,   659,   514,    17,    18,   846,   566,   466,   431,    55,
     668,   140,   489,    16,   491,   456,   475,   880,    72,   494,
     119,   274,   275,   959,   119,    91,    98,   279,   530,   683,
      63,    64,    65,   285,    72,   622,    91,   549,   140,   556,
     439,   140,   816,   817,   787,    89,   469,   583,    91,    15,
      13,   583,    16,   119,   556,     2,    63,     4,    15,   103,
     863,   347,     9,    10,   119,   143,   352,   143,    15,    16,
      17,   494,   137,    20,    16,   523,   119,   525,    89,   556,
      51,   114,   115,   207,   140,   338,   339,   340,   341,   213,
     343,   344,   103,   140,   138,   607,    51,   349,   610,   611,
     612,   145,   784,    50,   140,   391,   392,   599,   140,   607,
     113,   140,   610,   116,   117,   607,   628,    64,   610,   621,
     622,   140,   634,   635,    51,   637,   250,   138,   655,   787,
     628,   632,   644,   720,   145,   140,    44,   621,   119,   655,
     794,   144,    51,   146,    53,    54,    55,    56,   865,   139,
     139,   744,   654,    15,   871,   408,   668,   632,    91,   746,
      69,    18,    16,   695,   139,   417,   113,    89,   115,   756,
     654,   113,   974,   425,   116,   117,   599,   684,   673,   674,
     655,   103,    15,   435,   607,   975,   119,   610,    26,   729,
     673,    63,    64,    65,   139,   735,   137,   137,   140,   137,
     740,   741,   144,   626,   146,   628,   860,   140,   139,   732,
     727,   798,   146,   337,   391,   392,   138,    15,   720,    92,
     732,    14,   140,   145,    26,   727,   728,   729,    15,    15,
     732,   140,   143,   735,   736,   634,   748,   732,   740,   741,
     144,   140,   114,   115,   746,   747,   423,   424,    57,   761,
     727,    89,   764,   140,   756,   140,    72,   204,   733,   113,
     140,   763,   116,   117,   766,   103,   140,   214,   215,   728,
     857,    87,    88,   775,   776,   787,    61,    91,   530,    64,
      65,   783,   766,    15,   816,   817,   139,    89,   140,   140,
     144,   803,   146,   470,   140,    15,   798,   799,   136,    15,
     138,   103,   426,   427,   142,   119,   846,   145,   820,   821,
     733,   127,   128,   129,   130,   131,   818,   137,    15,   266,
      15,   823,   140,   270,    15,   137,   140,   274,   275,   114,
     115,    55,   279,    89,   136,   124,   138,   284,   285,   926,
     142,   818,   124,   145,   846,   292,   823,   103,    15,   113,
      89,   475,   116,   117,   856,   857,   137,    55,   482,   807,
     808,   809,   864,   811,   103,   813,   868,   879,   621,   929,
      51,   140,    53,    54,    55,    56,    15,    37,    38,   140,
     140,   140,   138,   140,    89,   880,   142,   864,    69,   145,
     337,   338,   339,   340,   341,   342,   343,   344,   103,   138,
     347,   654,   349,   694,   698,   352,   145,    15,   702,   945,
      26,   140,   140,   945,   139,   142,   707,   698,    91,   710,
      91,   142,    26,    61,   926,   719,    64,    65,   719,   140,
     932,   466,   934,   138,   381,   937,    13,   719,   719,    62,
     145,    64,    65,   729,   391,   392,   119,   959,   119,   735,
     736,   974,    89,   113,   740,   741,   116,   117,   405,   140,
     407,   408,   974,     6,   976,   977,   103,   140,   719,   140,
     417,   977,   974,    89,   421,   983,   114,   115,   425,   974,
     745,     7,   976,   430,   144,    89,   146,   103,   435,   698,
     245,   114,   115,   863,   113,   747,   620,   116,   117,   103,
     975,   138,   950,   951,   952,   953,   113,   903,   145,   116,
     117,   763,   113,   766,   906,   116,   117,    16,    17,   466,
     136,    20,   138,   775,   776,    26,   142,   146,   475,   145,
      89,   783,   136,   704,   138,   659,   143,   144,   142,   146,
      -1,   145,    89,   144,   103,   146,   493,   799,    47,    48,
      -1,   261,   975,    52,    53,    -1,   103,    89,   735,   736,
     846,    -1,    -1,   740,   741,    64,    65,  1015,    -1,    -1,
      -1,   103,    51,    -1,    53,    54,    55,    56,    -1,   138,
      63,    64,    65,   530,    -1,    -1,   145,    -1,    89,    89,
      69,   138,   769,   770,    -1,   772,   773,    89,   145,   890,
      89,   892,   103,   103,   856,   896,   138,    -1,    -1,   903,
      -1,   103,   906,   145,   103,   909,   868,   911,   909,    -1,
     911,   903,   903,    -1,   906,   906,   750,   909,   909,   911,
     911,   114,   115,   757,    -1,   136,    -1,   138,   138,    -1,
      -1,   142,    -1,    -1,   145,   145,   138,    -1,    -1,   138,
     941,   942,    -1,   145,   778,    -1,   145,    -1,    63,    64,
      65,    40,    41,    42,    43,    44,   960,    -1,    -1,   846,
      89,    -1,    -1,    -1,   621,   622,    -1,    -1,   960,   960,
     932,    -1,   934,    -1,   103,   937,    63,    64,    65,    -1,
     981,    -1,    -1,    -1,    -1,   986,   873,    -1,    -1,   993,
      -1,   995,   993,   997,   995,   999,    -1,   654,   999,   114,
     115,   993,   993,   995,   995,   997,   997,   999,   999,   138,
      72,    -1,  1013,    -1,    -1,    -1,   145,    -1,    -1,    -1,
    1024,    -1,    -1,  1024,    -1,    87,    88,   114,   115,    -1,
      -1,   865,  1024,  1024,    63,    64,    65,   871,    -1,    -1,
      63,    64,    65,   252,   253,   254,   255,    -1,    -1,    -1,
      63,    64,    65,    -1,    -1,   825,   826,   266,    72,    -1,
      -1,   270,    -1,   720,   126,   127,   128,   129,   130,   131,
      -1,   728,   729,    87,    88,   732,    -1,    -1,   735,   736,
      -1,    -1,    -1,   740,   741,   114,   115,    -1,    -1,   746,
     747,   114,   115,    -1,   113,    -1,    -1,   116,   117,   756,
      -1,   114,   115,    -1,    -1,    -1,   763,    -1,    -1,   766,
     124,   125,   126,   127,   128,   129,   130,   131,   775,   776,
      -1,   140,    -1,    -1,    -1,   144,   783,   146,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   906,    -1,   347,    -1,
      -1,   798,   799,   352,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,   377,   378,
      -1,    -1,   381,    -1,    51,    -1,    53,    54,    55,    56,
      -1,    -1,   391,   392,    -1,    -1,    -1,    -1,    -1,   846,
      -1,    -1,    69,   963,   964,   965,   405,   967,   968,   856,
     857,    -1,     2,    -1,     4,     5,     6,    -1,    -1,    -1,
     419,   868,   421,    13,   423,   424,    93,    -1,    -1,    -1,
      -1,   430,    99,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     439,    -1,    -1,    -1,   443,    -1,    -1,    -1,   447,    -1,
      -1,   450,    -1,   452,    -1,   454,  1016,  1017,  1018,  1019,
      50,    -1,    -1,    -1,    54,    -1,    -1,    -1,  1028,    -1,
      -1,   470,    -1,    51,    -1,    53,    54,    55,    56,   926,
      -1,   480,    51,    52,   483,   932,    55,   934,    78,    -1,
     937,    69,    -1,    -1,   493,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      -1,   510,    81,    82,    -1,    93,    85,    86,    87,    88,
      -1,    99,   521,    -1,    -1,   115,    -1,   974,    -1,    -1,
      99,   100,     2,    -1,     4,     5,     6,     7,    -1,    -1,
     539,   540,    -1,    13,    -1,    51,    -1,    53,    54,    55,
      56,   550,    -1,   122,   123,   124,   125,   126,   127,   128,
     129,   130,   131,    69,   133,   134,    -1,    -1,    -1,    -1,
      -1,    -1,   141,   142,    -1,     0,    -1,    -1,    -1,    -1,
      50,    -1,    -1,    -1,    54,    -1,    -1,    93,    13,    14,
      15,    16,    17,    18,    -1,    20,    -1,    -1,    -1,    -1,
      -1,    26,    27,    -1,    -1,    -1,    -1,    -1,    78,    -1,
      -1,    -1,    37,    38,   204,    40,    41,    42,    43,    44,
      -1,    -1,    -1,    51,    -1,    53,    54,    55,    56,    -1,
      -1,    -1,    -1,    -1,    51,   634,    53,    54,    55,    56,
      -1,    69,    -1,    -1,    72,   115,    -1,    -1,    -1,    -1,
      -1,     2,    69,     4,    -1,    72,    -1,    -1,    -1,    -1,
      -1,    -1,    13,    -1,    89,    93,   665,    -1,    -1,    -1,
      -1,    99,   100,   101,   673,   674,    93,    -1,   103,    -1,
      -1,    -1,    -1,   100,   101,    -1,    -1,    -1,   113,   279,
      -1,   116,   117,    -1,   284,   285,    -1,    -1,   126,    50,
      -1,   129,   292,    -1,    -1,    -1,    -1,    -1,    -1,   126,
      -1,   136,   137,   303,   142,    -1,    -1,   142,   143,   144,
     145,   146,    -1,    -1,    -1,   724,    -1,    -1,    -1,    -1,
     729,   730,    -1,   732,   204,    -1,   735,   736,    -1,    -1,
      -1,   740,   741,    -1,    -1,    -1,    -1,   337,    -1,    -1,
      -1,    -1,   342,    -1,    -1,    -1,    -1,    -1,    -1,   349,
     350,    -1,   352,    -1,   115,    -1,    -1,    -1,    -1,    -1,
     769,   770,    -1,   772,   773,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   782,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   391,   392,    -1,    -1,    -1,    -1,    -1,    -1,   279,
      -1,    -1,    -1,    -1,   284,   285,    -1,   407,    -1,    -1,
      -1,    -1,   292,    -1,    -1,    -1,    44,   417,    -1,    -1,
     829,    -1,    -1,   303,    -1,   425,    -1,    -1,    -1,    -1,
     839,   840,    -1,    -1,    -1,   435,    -1,   846,    -1,    -1,
      -1,    -1,    -1,   204,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,   337,    -1,    87,
      88,    -1,   342,    -1,   873,    -1,   466,    -1,    -1,   349,
     350,   880,    -1,    -1,    -1,   475,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     2,    -1,     4,    -1,    -1,   489,
      -1,   491,   120,    -1,   122,   123,   124,   125,   126,   127,
     128,   129,   130,   131,    51,    -1,    53,    54,    55,    56,
      -1,    -1,   140,    -1,    -1,    -1,    -1,    -1,   279,    -1,
      -1,    -1,    69,   284,   285,    72,    -1,   407,    -1,    -1,
     530,   292,    50,    -1,    -1,    -1,    -1,   417,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   425,    93,    -1,    -1,    -1,
      -1,    -1,    99,   100,   101,   435,   556,    51,    -1,    53,
      54,    55,    56,    -1,    -1,   974,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    69,   337,    -1,    72,   126,
      -1,   342,   129,    -1,    -1,    -1,   466,    -1,   349,    -1,
      -1,   352,    -1,   140,    -1,   475,    -1,   115,    -1,    93,
      -1,    -1,    -1,    -1,    -1,    99,   100,   101,    -1,   489,
      -1,   491,    -1,    -1,    -1,    -1,    -1,    51,    52,    -1,
      -1,    55,   622,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     391,   392,   126,    -1,    -1,   129,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    -1,   407,    81,    82,    -1,
     530,    85,    86,    87,    88,    -1,   417,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   425,    99,   100,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   435,    -1,   556,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   204,    -1,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,    -1,   133,
     134,    -1,    -1,    -1,    -1,   466,    -1,   141,   142,    -1,
      -1,    -1,    -1,    -1,   475,    -1,    -1,    -1,    -1,    -1,
     720,    -1,    -1,    -1,    -1,    -1,    -1,   727,   728,   729,
      -1,    -1,    -1,    -1,    -1,   735,    -1,    -1,    -1,    -1,
     740,   741,   622,    -1,    -1,    -1,   746,   747,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   756,    -1,    -1,    -1,
      -1,   279,    -1,   763,    -1,    -1,   284,   285,    -1,   530,
      -1,    -1,    -1,    -1,   292,   775,   776,    -1,    -1,    -1,
      -1,    -1,    -1,   783,    -1,    -1,    -1,    51,    -1,    53,
      54,    55,    56,    -1,    -1,    -1,    -1,    -1,   798,   799,
      -1,    -1,    -1,    -1,    -1,    69,    -1,    -1,    72,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   818,   337,
      -1,    -1,    -1,   823,   342,    -1,    -1,    -1,    -1,    93,
      -1,   349,    -1,    -1,   352,    99,   100,   101,    -1,    -1,
     720,    -1,    -1,    -1,    -1,    -1,   846,   727,   728,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   856,   857,    -1,    -1,
      -1,   622,   126,    -1,   864,   129,   746,   747,   868,    -1,
      -1,    -1,    -1,   391,   392,    -1,   756,    -1,   142,    -1,
      -1,    -1,    -1,   763,    -1,    -1,    -1,    -1,    -1,   407,
      -1,    -1,    -1,    -1,    -1,   775,   776,    -1,    -1,   417,
      -1,    -1,    -1,   783,    -1,    -1,    -1,   425,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   435,   798,   799,
      -1,    -1,    -1,    -1,    -1,    -1,   926,    -1,    -1,    -1,
      -1,    -1,   932,    -1,   934,    -1,    -1,   937,   818,    -1,
      -1,    -1,    -1,   823,    -1,    -1,    -1,    -1,   466,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   475,    -1,   720,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   728,   729,    -1,
      -1,    -1,    -1,    -1,   735,    -1,   856,   857,    -1,   740,
     741,    -1,    -1,    -1,   864,   746,   747,    -1,   868,    -1,
      -1,    -1,    -1,    -1,    -1,   756,    -1,    -1,    -1,    -1,
      -1,    -1,   763,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   530,    -1,   775,   776,    -1,    -1,    -1,    -1,
      -1,    -1,   783,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   798,   799,    51,
      52,    -1,    -1,    55,    -1,    -1,   926,    -1,    -1,    -1,
      -1,    -1,   932,    -1,   934,    -1,    -1,   937,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    -1,    -1,    81,
      82,    -1,    -1,    85,    86,    87,    88,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   846,    -1,    99,   100,    -1,
      -1,    -1,    -1,    -1,    -1,   856,   857,    -1,    -1,    -1,
      -1,    -1,    -1,   864,   622,    44,    -1,   868,    -1,    -1,
     122,   123,   124,   125,   126,   127,   128,   129,   130,   131,
      -1,   133,   134,    -1,    -1,    -1,    -1,    -1,    -1,   141,
     142,    -1,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    -1,    87,    88,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   926,    -1,    -1,    -1,    -1,
      -1,   932,    -1,   934,    -1,    -1,   937,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,   125,   126,   127,   128,
     129,   130,   131,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   720,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     728,   729,    -1,    -1,    -1,    -1,    -1,   735,    -1,    -1,
      -1,    -1,   740,   741,    -1,    -1,    -1,    -1,   746,   747,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   756,    -1,
      -1,    -1,    -1,    -1,    -1,   763,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   775,   776,    -1,
      -1,    -1,    -1,     0,     1,   783,     3,     4,     5,     6,
       7,     8,     9,    10,    11,    12,    -1,    -1,    -1,    -1,
     798,   799,    19,    -1,    21,    22,    23,    24,    -1,    -1,
      -1,    -1,    -1,    30,    31,    32,    33,    34,    35,    36,
      -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      -1,    58,    59,    60,    -1,    -1,    63,    -1,   846,    66,
      67,    -1,    69,    70,    71,    -1,    -1,    -1,   856,   857,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     868,    -1,    -1,    90,    -1,    -1,    93,    94,    -1,    96,
      97,    -1,    99,    -1,    -1,   102,    -1,   104,   105,   106,
     107,   108,   109,    -1,    -1,   112,   113,    -1,    -1,   116,
     117,    -1,    -1,    -1,    -1,     0,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   132,   133,   134,    13,    14,
      15,    16,    17,    18,    -1,    20,    -1,   144,   926,   146,
      -1,    -1,    27,    28,   932,    -1,   934,    -1,    -1,   937,
      -1,    -1,    37,    38,    -1,    40,    41,    42,    43,    44,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    -1,    87,    88,    89,    -1,    91,    92,    -1,    -1,
      -1,    -1,    -1,    98,    -1,    -1,    -1,    -1,   103,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   113,    -1,
      -1,   116,   117,    -1,   119,   120,    -1,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,    -1,    -1,     0,
      -1,    -1,   137,   138,   139,   140,    -1,    -1,   143,   144,
     145,   146,    13,    14,    15,    16,    17,    18,    -1,    20,
      -1,    -1,    -1,    -1,    -1,    -1,    27,    28,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    37,    38,    -1,    40,
      41,    42,    43,    44,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    -1,    87,    88,    89,    -1,
      -1,    92,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,
      -1,    -1,   103,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   113,    -1,    -1,   116,   117,    -1,    -1,   120,
      -1,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,    -1,    -1,     0,    -1,    -1,   137,   138,   139,   140,
      -1,   142,   143,   144,   145,   146,    13,    14,    15,    -1,
      17,    18,    -1,    20,    -1,    -1,    -1,    -1,    -1,    26,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      37,    38,    -1,    40,    41,    42,    43,    44,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    -1,    -1,
      87,    88,    89,    -1,    91,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   103,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   113,    -1,    -1,   116,
     117,    -1,   119,   120,    -1,   122,   123,   124,   125,   126,
     127,   128,   129,   130,   131,    -1,    -1,     0,    -1,   136,
     137,   138,    -1,   140,    -1,    -1,   143,   144,   145,   146,
      13,    14,    15,    -1,    17,    18,    -1,    20,    -1,    -1,
      -1,    -1,    -1,    26,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    37,    38,    -1,    40,    41,    42,
      43,    44,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    -1,    87,    88,    89,    -1,    91,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     103,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     113,    -1,    -1,   116,   117,    -1,   119,   120,    -1,   122,
     123,   124,   125,   126,   127,   128,   129,   130,   131,    -1,
      -1,     0,    -1,   136,   137,   138,    -1,   140,    -1,    -1,
     143,   144,   145,   146,    13,    14,    15,    -1,    17,    18,
      -1,    20,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,    38,
      -1,    40,    41,    42,    43,    44,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    -1,    87,    88,
      89,    -1,    91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   103,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   113,    -1,    -1,   116,   117,    -1,
     119,   120,    -1,   122,   123,   124,   125,   126,   127,   128,
     129,   130,   131,    -1,    -1,     0,    -1,    -1,   137,   138,
      -1,   140,    -1,    -1,   143,   144,   145,   146,    13,    14,
      15,    -1,    17,    18,    -1,    20,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    37,    38,    -1,    40,    41,    42,    43,    44,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    -1,    87,    88,    89,    -1,    91,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   103,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   113,    -1,
      -1,   116,   117,    -1,   119,   120,    -1,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,    -1,    -1,    -1,
      -1,    -1,   137,   138,    -1,   140,    -1,    -1,   143,   144,
     145,   146,     1,    -1,     3,     4,     5,     6,     7,     8,
       9,    10,    11,    12,    13,    14,    15,    -1,    -1,    18,
      19,    -1,    21,    22,    23,    24,    -1,    -1,    -1,    -1,
      -1,    30,    31,    32,    33,    34,    35,    36,    -1,    -1,
      39,    -1,    -1,    -1,    -1,    -1,    45,    -1,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    -1,    58,
      59,    60,    -1,    -1,    63,    -1,    -1,    66,    67,    -1,
      69,    70,    71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    90,    -1,    -1,    93,    94,    -1,    96,    97,    -1,
      99,    -1,    -1,   102,    -1,   104,   105,   106,   107,   108,
     109,    -1,    -1,   112,   113,    -1,    -1,   116,   117,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   132,   133,   134,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   144,     1,   146,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    -1,    -1,
      15,    -1,    17,    18,    19,    -1,    21,    22,    23,    24,
      -1,    -1,    -1,    -1,    -1,    30,    31,    32,    33,    34,
      35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,
      45,    -1,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    -1,    58,    59,    60,    -1,    -1,    63,    -1,
      -1,    66,    67,    -1,    69,    70,    71,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    90,    -1,    -1,    93,    94,
      -1,    96,    97,    -1,    99,    -1,    -1,   102,    -1,   104,
     105,   106,   107,   108,   109,    -1,    -1,   112,   113,    -1,
      -1,   116,   117,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,   133,   134,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   144,
       1,   146,     3,     4,     5,     6,     7,     8,     9,    10,
      11,    12,    -1,    -1,    15,    -1,    -1,    18,    19,    20,
      21,    22,    23,    24,    -1,    -1,    -1,    -1,    -1,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    45,    -1,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    -1,    58,    59,    60,
      -1,    -1,    63,    -1,    -1,    66,    67,    -1,    69,    70,
      71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,
      -1,    -1,    93,    94,    -1,    96,    97,    -1,    99,    -1,
      -1,   102,    -1,   104,   105,   106,   107,   108,   109,    -1,
      -1,   112,   113,    -1,    -1,   116,   117,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   132,   133,   134,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   144,     1,   146,     3,     4,     5,     6,
       7,     8,     9,    10,    11,    12,    -1,    -1,    15,    -1,
      -1,    18,    19,    -1,    21,    22,    23,    24,    -1,    -1,
      -1,    -1,    -1,    30,    31,    32,    33,    34,    35,    36,
      -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    45,    -1,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      -1,    58,    59,    60,    -1,    -1,    63,    -1,    -1,    66,
      67,    -1,    69,    70,    71,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    90,    -1,    -1,    93,    94,    -1,    96,
      97,    -1,    99,    -1,    -1,   102,    -1,   104,   105,   106,
     107,   108,   109,    -1,    -1,   112,   113,    -1,    -1,   116,
     117,     1,    -1,     3,     4,     5,     6,     7,     8,     9,
      10,    11,    12,    -1,    -1,   132,   133,   134,    -1,    19,
      -1,    21,    22,    23,    24,    -1,    -1,   144,    -1,   146,
      30,    31,    32,    33,    34,    35,    36,    -1,    -1,    39,
      -1,    -1,    -1,    -1,    -1,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    -1,    58,    59,
      60,    -1,    -1,    63,    -1,    -1,    66,    67,    -1,    69,
      70,    71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      90,    -1,    -1,    93,    94,    -1,    96,    97,    -1,    99,
      -1,    -1,   102,    -1,   104,   105,   106,   107,   108,   109,
      -1,    -1,   112,   113,    -1,    -1,   116,   117,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   132,   133,   134,    -1,    -1,   137,    -1,    -1,
      -1,    -1,    -1,    -1,   144,     1,   146,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    12,    -1,    14,    15,
      -1,    -1,    -1,    19,    -1,    21,    22,    23,    24,    -1,
      -1,    -1,    -1,    -1,    30,    31,    32,    33,    34,    35,
      36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    45,
      -1,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    -1,    58,    59,    60,    -1,    -1,    63,    -1,    -1,
      66,    67,    -1,    69,    70,    71,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    90,    -1,    -1,    93,    94,    -1,
      96,    97,    -1,    99,    -1,    -1,   102,    -1,   104,   105,
     106,   107,   108,   109,    -1,    -1,   112,   113,    -1,    -1,
     116,   117,     1,    -1,     3,     4,     5,     6,     7,     8,
       9,    10,    11,    12,    -1,    -1,   132,   133,   134,    -1,
      19,    -1,    21,    22,    23,    24,    -1,    -1,   144,    -1,
     146,    30,    31,    32,    33,    34,    35,    36,    -1,    -1,
      39,    -1,    -1,    -1,    -1,    -1,    45,    -1,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    -1,    58,
      59,    60,    -1,    -1,    63,    -1,    -1,    66,    67,    -1,
      69,    70,    71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    90,    -1,    -1,    93,    94,    -1,    96,    97,    -1,
      99,    -1,    -1,   102,    -1,   104,   105,   106,   107,   108,
     109,    -1,    -1,   112,   113,    -1,    -1,   116,   117,     1,
      -1,     3,     4,     5,     6,     7,     8,     9,    10,    11,
      12,    -1,    -1,   132,   133,   134,    -1,    19,    -1,    21,
      22,    23,    24,    -1,   143,   144,    -1,   146,    30,    31,
      32,    33,    34,    35,    36,    -1,    -1,    39,    -1,    -1,
      -1,    -1,    -1,    45,    -1,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    -1,    58,    59,    60,    -1,
      -1,    63,    -1,    -1,    66,    67,    -1,    69,    70,    71,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,    -1,
      -1,    93,    94,    -1,    96,    97,    -1,    99,    -1,    -1,
     102,    -1,   104,   105,   106,   107,   108,   109,    -1,    -1,
     112,   113,    -1,    -1,   116,   117,     1,    -1,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    -1,    -1,
     132,   133,   134,    -1,    19,    -1,    21,    22,    23,    24,
      -1,   143,   144,    -1,   146,    30,    31,    32,    33,    34,
      35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,
      45,    -1,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    -1,    58,    59,    60,    -1,    -1,    63,    -1,
      -1,    66,    67,    -1,    69,    70,    71,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    90,    -1,    -1,    93,    94,
      -1,    96,    97,    -1,    99,    -1,    -1,   102,    -1,   104,
     105,   106,   107,   108,   109,    -1,    -1,   112,   113,    -1,
      -1,   116,   117,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,   133,   134,
      -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,   144,
       1,   146,     3,     4,     5,     6,     7,     8,     9,    10,
      11,    12,    -1,    -1,    15,    -1,    -1,    -1,    19,    -1,
      21,    22,    23,    24,    -1,    -1,    -1,    -1,    -1,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    45,    -1,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    -1,    58,    59,    60,
      -1,    -1,    63,    -1,    -1,    66,    67,    -1,    69,    70,
      71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,
      -1,    -1,    93,    94,    -1,    96,    97,    -1,    99,    -1,
      -1,   102,    -1,   104,   105,   106,   107,   108,   109,    -1,
      -1,   112,   113,    -1,    -1,   116,   117,    -1,    -1,     3,
       4,     5,     6,     7,     8,     9,    10,    11,    12,    -1,
      -1,   132,   133,   134,    -1,    19,    -1,    21,    22,    23,
      24,    -1,    -1,   144,    -1,   146,    30,    31,    32,    33,
      34,    35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,
      -1,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    -1,    58,    59,    60,    -1,    -1,    63,
      -1,    -1,    66,    67,    -1,    69,    70,    71,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    90,    -1,    -1,    93,
      94,    -1,    96,    97,    -1,    99,    -1,    -1,   102,    -1,
     104,   105,   106,   107,   108,   109,    -1,    -1,   112,   113,
      -1,    -1,   116,   117,    -1,    -1,     3,     4,     5,     6,
       7,     8,     9,    10,    11,    12,    -1,    -1,   132,   133,
     134,    -1,    19,    -1,    21,    22,    23,    24,    -1,    -1,
     144,    -1,   146,    30,    31,    32,    33,    34,    35,    36,
      -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    45,    -1,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      -1,    58,    59,    60,    -1,    -1,    63,    -1,    -1,    66,
      67,    -1,    69,    70,    71,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    90,    -1,    -1,    93,    94,    -1,    96,
      97,    -1,    99,    -1,    -1,   102,    -1,   104,   105,   106,
     107,   108,   109,    -1,    -1,   112,   113,    -1,    -1,   116,
     117,    -1,    -1,     3,     4,     5,     6,     7,     8,     9,
      10,    11,    -1,    -1,    -1,   132,   133,   134,    -1,    19,
      -1,    21,    22,    23,    24,    -1,    -1,   144,    -1,   146,
      30,    31,    32,    33,    34,    35,    36,    -1,    -1,    39,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    -1,    58,    59,
      60,    -1,    -1,    63,    -1,    -1,    66,    67,    -1,    69,
      70,    71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      90,    -1,    -1,    93,    94,    -1,    96,    97,    -1,    -1,
      -1,    -1,   102,    -1,   104,   105,   106,   107,   108,   109,
      -1,    -1,   112,   113,    -1,    -1,   116,   117,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   132,   133,   134,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   144,    -1,   146,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    -1,    -1,    -1,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    -1,    -1,    -1,    -1,    -1,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    -1,    -1,    81,    82,    -1,    -1,    85,
      86,    87,    88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    99,   100,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,    -1,   133,   134,    -1,
      -1,    -1,    -1,    -1,    -1,   141,   142,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    19,    -1,    21,    22,    23,    24,    -1,
      26,    -1,    -1,    -1,    30,    31,    32,    33,    34,    35,
      36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    -1,    58,    59,    60,    -1,    -1,    63,    -1,    -1,
      66,    67,    -1,    69,    70,    71,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    90,    -1,    -1,    93,    94,    -1,
      96,    97,    -1,    99,   100,   101,   102,    -1,   104,   105,
     106,   107,   108,   109,    -1,    -1,   112,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   132,   133,   134,    -1,
     136,    -1,    -1,    -1,    -1,    -1,   142,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    19,    -1,    21,    22,    23,    24,    -1,
      26,    -1,    -1,    -1,    30,    31,    32,    33,    34,    35,
      36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    -1,    58,    59,    60,    -1,    -1,    63,    -1,    -1,
      66,    67,    -1,    69,    70,    71,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    90,    -1,    -1,    93,    94,    -1,
      96,    97,    -1,    99,   100,   101,   102,    -1,   104,   105,
     106,   107,   108,   109,    -1,    -1,   112,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   132,   133,   134,    -1,
     136,    -1,    -1,    -1,    -1,    -1,   142,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    19,    -1,    21,    22,    23,    24,    -1,
      26,    -1,    -1,    -1,    30,    31,    32,    33,    34,    35,
      36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    -1,    58,    59,    60,    -1,    -1,    63,    -1,    -1,
      66,    67,    -1,    69,    70,    71,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    90,    -1,    -1,    93,    94,    -1,
      96,    97,    -1,    99,   100,   101,   102,    -1,   104,   105,
     106,   107,   108,   109,    -1,    -1,   112,    -1,    -1,    -1,
      -1,    -1,    -1,     3,     4,     5,     6,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,   132,   133,   134,    19,
     136,    21,    22,    23,    24,    -1,   142,    -1,    -1,    -1,
      30,    31,    32,    33,    34,    35,    36,    -1,    -1,    39,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    -1,    58,    59,
      60,    -1,    -1,    63,    -1,    -1,    66,    67,    -1,    69,
      70,    71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      90,    91,    -1,    93,    94,    -1,    96,    97,    -1,    99,
     100,   101,   102,    -1,   104,   105,   106,   107,   108,   109,
      -1,    -1,   112,    -1,    -1,    -1,    -1,    -1,    -1,   119,
       3,     4,     5,     6,     7,     8,     9,    10,    11,    -1,
      -1,    -1,   132,   133,   134,    -1,    19,    -1,    21,    22,
      23,    24,   142,    -1,    -1,    -1,    -1,    30,    31,    32,
      33,    34,    35,    36,    -1,    -1,    39,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    -1,    58,    59,    60,    -1,    -1,
      63,    -1,    -1,    66,    67,    -1,    69,    70,    71,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,    91,    -1,
      93,    94,    -1,    96,    97,    -1,    99,   100,   101,   102,
      -1,   104,   105,   106,   107,   108,   109,    -1,    -1,   112,
      -1,    -1,    -1,    -1,    -1,    -1,   119,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    -1,    -1,    -1,   132,
     133,   134,    -1,    19,    -1,    21,    22,    23,    24,   142,
      -1,    -1,    -1,    -1,    30,    31,    32,    33,    34,    35,
      36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    -1,    58,    59,    60,    -1,    -1,    63,    -1,    -1,
      66,    67,    -1,    69,    70,    71,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    90,    -1,    -1,    93,    94,    -1,
      96,    97,    -1,    99,   100,   101,   102,    -1,   104,   105,
     106,   107,   108,   109,    -1,    -1,   112,    -1,    -1,    -1,
      -1,    -1,    -1,     3,     4,     5,     6,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,   132,   133,   134,    19,
      -1,    21,    22,    23,    24,    -1,   142,    -1,    -1,    -1,
      30,    31,    32,    33,    34,    35,    36,    -1,    -1,    39,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    -1,    58,    59,
      60,    -1,    -1,    63,    -1,    -1,    66,    67,    -1,    69,
      70,    71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      90,    -1,    -1,    93,    94,    -1,    96,    97,    -1,    99,
     100,   101,   102,    -1,   104,   105,   106,   107,   108,   109,
      -1,    -1,   112,    -1,    -1,    -1,    -1,    -1,    -1,     3,
       4,     5,     6,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,   132,   133,   134,    19,    -1,    21,    22,    23,
      24,    -1,   142,    -1,    -1,    -1,    30,    31,    32,    33,
      34,    35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    -1,    58,    59,    60,    -1,    -1,    63,
      -1,    -1,    66,    67,    -1,    69,    70,    71,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    90,    -1,    -1,    93,
      94,    -1,    96,    97,    -1,    99,   100,   101,   102,    -1,
     104,   105,   106,   107,   108,   109,    -1,    -1,   112,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,   133,
     134,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   142,     3,
       4,     5,     6,     7,     8,     9,    10,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    21,    22,    23,
      24,    25,    26,    -1,    -1,    -1,    30,    31,    32,    33,
      34,    35,    36,    37,    38,    39,    -1,    -1,    -1,    -1,
      -1,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    -1,    -1,    -1,    -1,    -1,    -1,    63,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    -1,    -1,    81,    82,    -1,
      -1,    85,    86,    87,    88,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    99,   100,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   108,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,    -1,   133,
     134,    -1,    -1,    -1,    -1,    -1,    -1,   141,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    -1,    -1,    -1,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    -1,    -1,    -1,    -1,    -1,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    -1,    -1,    -1,    -1,    -1,    -1,    63,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    -1,    -1,    81,    82,    -1,    -1,
      85,    86,    87,    88,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    99,   100,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   108,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,    -1,   133,   134,
      -1,    -1,    -1,    -1,    -1,    -1,   141,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    -1,    -1,    -1,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    -1,    -1,    -1,    -1,    -1,    45,
      46,    47,    48,    49,    50,    51,    52,    -1,    -1,    55,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    -1,    -1,    81,    82,    -1,    -1,    85,
      86,    87,    88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    99,   100,    -1,    -1,    -1,   104,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,    -1,   133,   134,    -1,
      -1,    -1,    -1,    -1,    -1,   141,     3,     4,     5,     6,
       7,     8,     9,    10,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
      -1,    -1,    -1,    30,    31,    32,    33,    34,    35,    36,
      37,    38,    39,    -1,    -1,    -1,    -1,    -1,    45,    46,
      47,    48,    49,    50,    51,    52,    -1,    -1,    55,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    -1,    -1,    81,    82,    -1,    -1,    85,    86,
      87,    88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    99,   100,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   122,   123,   124,   125,   126,
     127,   128,   129,   130,   131,    -1,   133,   134,    -1,    -1,
      -1,    -1,    -1,    -1,   141,     3,     4,     5,     6,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    19,    -1,    21,    22,    23,    24,    -1,    -1,    -1,
      -1,    -1,    30,    31,    32,    33,    34,    35,    36,    -1,
      -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    -1,
      58,    59,    60,    -1,    -1,    63,    -1,    -1,    66,    67,
      -1,    69,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    90,    -1,    -1,    93,    94,    -1,    96,    97,
      -1,    -1,    -1,    -1,   102,    -1,   104,   105,   106,   107,
     108,   109,    -1,    -1,   112,    -1,    -1,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    19,   132,    21,    22,    23,    24,    -1,
      -1,    -1,   140,    -1,    30,    31,    32,    33,    34,    35,
      36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    -1,    58,    59,    60,    -1,    -1,    63,    -1,    -1,
      66,    67,    -1,    69,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    90,    -1,    -1,    93,    94,    -1,
      96,    97,    -1,    -1,    -1,    -1,   102,    -1,   104,   105,
     106,   107,   108,   109,    -1,    -1,   112,    -1,    -1,     3,
       4,     5,     6,     7,     8,     9,    10,    11,    12,    -1,
      -1,    -1,    -1,    -1,    -1,    19,   132,    21,    22,    23,
      24,    -1,    -1,    -1,   140,    -1,    30,    31,    32,    33,
      34,    35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,
      -1,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    -1,    58,    59,    60,    -1,    -1,    63,
      -1,    -1,    66,    67,    -1,    69,    70,    71,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    90,    -1,    -1,    93,
      94,    -1,    96,    97,    -1,    99,    -1,    -1,   102,    -1,
     104,   105,   106,   107,   108,   109,    -1,    -1,   112,    -1,
      -1,    -1,    -1,    -1,    -1,     3,     4,     5,     6,     7,
       8,     9,    10,    11,    12,    -1,    -1,    -1,   132,   133,
     134,    19,    -1,    21,    22,    23,    24,    -1,    -1,    -1,
      -1,    -1,    30,    31,    32,    33,    34,    35,    36,    -1,
      -1,    39,    -1,    -1,    -1,    -1,    -1,    45,    -1,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    -1,
      58,    59,    60,    -1,    -1,    63,    -1,    -1,    66,    67,
      -1,    69,    70,    71,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    90,    -1,    -1,    93,    94,    -1,    96,    97,
      -1,    99,    -1,    -1,   102,    -1,   104,   105,   106,   107,
     108,   109,    -1,    -1,   112,    -1,    -1,    -1,    -1,    -1,
      -1,     3,     4,     5,     6,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,   132,   133,   134,    19,    -1,    21,
      22,    23,    24,    -1,    -1,    -1,    -1,    -1,    30,    31,
      32,    33,    34,    35,    36,    -1,    -1,    39,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    -1,    58,    59,    60,    -1,
      -1,    63,    -1,    -1,    66,    67,    -1,    69,    70,    71,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,    -1,
      -1,    93,    94,    -1,    96,    97,    -1,    99,   100,   101,
     102,    -1,   104,   105,   106,   107,   108,   109,    -1,    -1,
     112,    -1,    -1,    -1,    -1,    -1,    -1,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
     132,   133,   134,    19,    -1,    21,    22,    23,    24,    -1,
      -1,    -1,    -1,    -1,    30,    31,    32,    33,    34,    35,
      36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    -1,    58,    59,    60,    -1,    -1,    63,    -1,    -1,
      66,    67,    -1,    69,    70,    71,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    90,    -1,    -1,    93,    94,    -1,
      96,    97,    -1,    99,   100,   101,   102,    -1,   104,   105,
     106,   107,   108,   109,    -1,    -1,   112,    -1,    -1,    -1,
      -1,    -1,    -1,     3,     4,     5,     6,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,   132,   133,   134,    19,
      -1,    21,    22,    23,    24,    -1,    -1,    -1,    -1,    -1,
      30,    31,    32,    33,    34,    35,    36,    -1,    -1,    39,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    -1,    58,    59,
      60,    -1,    -1,    63,    -1,    -1,    66,    67,    -1,    69,
      70,    71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      90,    -1,    -1,    93,    94,    -1,    96,    97,    -1,    99,
     100,    -1,   102,    -1,   104,   105,   106,   107,   108,   109,
      -1,    -1,   112,    -1,    -1,    -1,    -1,    -1,    -1,     3,
       4,     5,     6,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,   132,   133,   134,    19,    -1,    21,    22,    23,
      24,    -1,    -1,    -1,    -1,    -1,    30,    31,    32,    33,
      34,    35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    -1,    58,    59,    60,    -1,    -1,    63,
      -1,    -1,    66,    67,    -1,    69,    70,    71,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    90,    -1,    -1,    93,
      94,    -1,    96,    97,    -1,    -1,   100,   101,   102,    -1,
     104,   105,   106,   107,   108,   109,    -1,    -1,   112,    -1,
      -1,    -1,    -1,    -1,    -1,     3,     4,     5,     6,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,   132,   133,
     134,    19,    -1,    21,    22,    23,    24,    -1,    -1,    -1,
      -1,    -1,    30,    31,    32,    33,    34,    35,    36,    -1,
      -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    -1,
      58,    59,    60,    -1,    -1,    63,    -1,    -1,    66,    67,
      -1,    69,    70,    71,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    90,    -1,    -1,    93,    94,    -1,    96,    97,
      -1,    99,   100,    -1,   102,    -1,   104,   105,   106,   107,
     108,   109,    -1,    -1,   112,    -1,    -1,    -1,    -1,    -1,
      -1,     3,     4,     5,     6,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,   132,   133,   134,    19,    -1,    21,
      22,    23,    24,    -1,    -1,    -1,    -1,    -1,    30,    31,
      32,    33,    34,    35,    36,    -1,    -1,    39,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    -1,    58,    59,    60,    -1,
      -1,    63,    -1,    -1,    66,    67,    -1,    69,    70,    71,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,    -1,
      -1,    93,    94,    -1,    96,    97,    -1,    -1,   100,    -1,
     102,    -1,   104,   105,   106,   107,   108,   109,    -1,    -1,
     112,    -1,    -1,    -1,    -1,    -1,    -1,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
     132,   133,   134,    19,    -1,    21,    22,    23,    24,    -1,
      -1,    -1,    -1,    -1,    30,    31,    32,    33,    34,    35,
      36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    -1,    58,    59,    60,    -1,    -1,    63,    -1,    -1,
      66,    67,    -1,    69,    70,    71,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    90,    -1,    -1,    93,    94,    -1,
      96,    97,    -1,    99,    -1,    -1,   102,    -1,   104,   105,
     106,   107,   108,   109,    -1,    -1,   112,    -1,    -1,    -1,
      -1,    -1,    -1,     3,     4,     5,     6,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,   132,   133,   134,    19,
      -1,    21,    22,    23,    24,    -1,    -1,    -1,    -1,    -1,
      30,    31,    32,    33,    34,    35,    36,    -1,    -1,    39,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    -1,    58,    59,
      60,    -1,    -1,    63,    -1,    -1,    66,    67,    -1,    69,
      70,    71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      90,    -1,    -1,    93,    94,    -1,    96,    97,    -1,    99,
      -1,    -1,   102,    -1,   104,   105,   106,   107,   108,   109,
      -1,    -1,   112,    -1,    -1,    -1,    -1,    -1,    -1,     3,
       4,     5,     6,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,   132,   133,   134,    19,    -1,    21,    22,    23,
      24,    -1,    -1,    -1,    -1,    -1,    30,    31,    32,    33,
      34,    35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    -1,    58,    59,    60,    -1,    -1,    63,
      -1,    -1,    66,    67,    -1,    69,    70,    71,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    90,    -1,    -1,    93,
      94,    -1,    96,    97,    -1,    99,    -1,    -1,   102,    -1,
     104,   105,   106,   107,   108,   109,    -1,    -1,   112,    -1,
      -1,    -1,    -1,    -1,    -1,     3,     4,     5,     6,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,   132,   133,
     134,    19,    -1,    21,    22,    23,    24,    -1,    -1,    -1,
      -1,    -1,    30,    31,    32,    33,    34,    35,    36,    -1,
      -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    -1,
      58,    59,    60,    -1,    -1,    63,    -1,    -1,    66,    67,
      -1,    69,    70,    71,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    90,    -1,    -1,    93,    94,    -1,    96,    97,
      -1,    99,    -1,    -1,   102,    -1,   104,   105,   106,   107,
     108,   109,    -1,    -1,   112,    -1,    -1,    -1,    -1,    -1,
      -1,     3,     4,     5,     6,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,   132,   133,   134,    19,    -1,    21,
      22,    23,    24,    -1,    -1,    -1,    -1,    -1,    30,    31,
      32,    33,    34,    35,    36,    -1,    -1,    39,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    -1,    58,    59,    60,    -1,
      -1,    63,    -1,    -1,    66,    67,    -1,    69,    70,    71,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,    -1,
      -1,    93,    94,    -1,    96,    97,    -1,    99,    -1,    -1,
     102,    -1,   104,   105,   106,   107,   108,   109,    -1,    -1,
     112,    -1,    -1,    -1,    -1,    -1,    -1,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
     132,   133,   134,    19,    -1,    21,    22,    23,    24,    -1,
      -1,    -1,    -1,    -1,    30,    31,    32,    33,    34,    35,
      36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    -1,    58,    59,    60,    -1,    -1,    63,    -1,    -1,
      66,    67,    -1,    69,    70,    71,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    90,    -1,    -1,    93,    94,    -1,
      96,    97,    -1,    -1,    -1,    -1,   102,    -1,   104,   105,
     106,   107,   108,   109,    -1,    -1,   112,    -1,    -1,    -1,
      -1,    -1,    -1,     3,     4,     5,     6,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,   132,   133,   134,    19,
      -1,    21,    22,    23,    24,    -1,    -1,    -1,    -1,    -1,
      30,    31,    32,    33,    34,    35,    36,    -1,    -1,    39,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    -1,    58,    59,
      60,    -1,    -1,    63,    -1,    -1,    66,    67,    -1,    69,
      70,    71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      90,    -1,    -1,    93,    94,    -1,    96,    97,    -1,    -1,
      -1,    -1,   102,    -1,   104,   105,   106,   107,   108,   109,
      -1,    -1,   112,    -1,    -1,    -1,    -1,    -1,    -1,     3,
       4,     5,     6,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,   132,   133,   134,    19,    -1,    21,    22,    23,
      24,    -1,    -1,    -1,    -1,    -1,    30,    31,    32,    33,
      34,    35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    -1,    58,    59,    60,    -1,    -1,    63,
      -1,    -1,    66,    67,    -1,    69,    70,    71,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    90,    -1,    -1,    93,
      94,    -1,    96,    97,    -1,    -1,    -1,    -1,   102,    -1,
     104,   105,   106,   107,   108,   109,    -1,    -1,   112,    -1,
      -1,    -1,    -1,    -1,    -1,     3,     4,     5,     6,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,   132,   133,
     134,    19,    -1,    21,    22,    23,    24,    -1,    -1,    -1,
      -1,    -1,    30,    31,    32,    33,    34,    35,    36,    -1,
      -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    -1,
      58,    59,    60,    -1,    -1,    63,    -1,    -1,    66,    67,
      -1,    69,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    87,
      -1,    -1,    90,    -1,    -1,    93,    94,    -1,    96,    97,
      -1,    -1,    -1,    -1,   102,    -1,   104,   105,   106,   107,
     108,   109,    -1,    -1,   112,    -1,    -1,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    19,   132,    21,    22,    23,    24,    -1,
      -1,    -1,    -1,    -1,    30,    31,    32,    33,    34,    35,
      36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    -1,    58,    59,    60,    -1,    -1,    63,    -1,    -1,
      66,    67,    -1,    69,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    90,    -1,    -1,    93,    94,    -1,
      96,    97,    -1,    99,    -1,    -1,   102,    -1,   104,   105,
     106,   107,   108,   109,    -1,    -1,   112,    -1,    -1,     3,
       4,     5,     6,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    19,   132,    21,    22,    23,
      24,    -1,    -1,    -1,    -1,    -1,    30,    31,    32,    33,
      34,    35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    -1,    58,    59,    60,    -1,    -1,    63,
      -1,    -1,    66,    67,    -1,    69,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    90,    -1,    -1,    93,
      94,    -1,    96,    97,    -1,    99,    -1,    -1,   102,    -1,
     104,   105,   106,   107,   108,   109,    -1,    -1,   112,    -1,
      -1,     3,     4,     5,     6,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    19,   132,    21,
      22,    23,    24,    -1,    -1,    -1,    -1,    -1,    30,    31,
      32,    33,    34,    35,    36,    -1,    -1,    39,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    -1,    58,    59,    60,    -1,
      -1,    63,    -1,    -1,    66,    67,    -1,    69,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,    -1,
      -1,    93,    94,    -1,    96,    97,    -1,    -1,    -1,    -1,
     102,    -1,   104,   105,   106,   107,   108,   109,    -1,    -1,
     112,    -1,    -1,     3,     4,     5,     6,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    19,
     132,    21,    22,    23,    24,    -1,    -1,    -1,    -1,    -1,
      30,    31,    32,    33,    34,    35,    36,    -1,    -1,    39,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    -1,    58,    59,
      60,    -1,    -1,    63,    -1,    -1,    66,    67,    -1,    69,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      90,    -1,    -1,    93,    94,    -1,    96,    97,    -1,    -1,
      -1,    -1,   102,    -1,   104,   105,   106,   107,   108,   109,
      -1,    -1,   112,    -1,    -1,     3,     4,     5,     6,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    19,   132,    21,    22,    23,    24,    -1,    -1,    -1,
      -1,    -1,    30,    31,    32,    33,    34,    35,    36,    -1,
      -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    -1,
      58,    59,    60,    -1,    -1,    63,    -1,    -1,    66,    67,
      -1,    69,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    90,    -1,    -1,    93,    94,    -1,    96,    97,
      -1,    -1,    -1,    -1,   102,    -1,   104,   105,   106,   107,
     108,   109,    -1,    -1,   112,    -1,    -1,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    19,   132,    21,    22,    23,    24,    -1,
      -1,    -1,    -1,    -1,    30,    31,    32,    33,    34,    35,
      36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    -1,    58,    59,    60,    -1,    -1,    63,    -1,    -1,
      66,    67,    -1,    69,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    90,    -1,    -1,    93,    94,    -1,
      96,    97,    -1,    51,    52,    -1,   102,    55,   104,   105,
     106,   107,   108,   109,    -1,    -1,   112,    -1,    -1,    -1,
      -1,    -1,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    -1,    -1,    81,    82,    -1,   132,    85,    86,    87,
      88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    99,   100,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   122,   123,   124,   125,   126,   127,
     128,   129,   130,   131,    -1,   133,   134,    51,    52,    -1,
      -1,    55,    -1,   141,   142,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    -1,    -1,    81,    82,    -1,
      -1,    85,    86,    87,    88,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    99,   100,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,    -1,   133,
     134,    51,    52,    -1,    -1,    55,    -1,   141,   142,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    -1,
      -1,    81,    82,    -1,    -1,    85,    86,    87,    88,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    99,
     100,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   122,   123,   124,   125,   126,   127,   128,   129,
     130,   131,    -1,   133,   134,    51,    52,    -1,    -1,    55,
      -1,   141,   142,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    -1,    -1,    81,    82,    -1,    -1,    85,
      86,    87,    88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    99,   100,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,    -1,   133,   134,    51,
      52,    -1,    -1,    55,    -1,   141,   142,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    -1,    -1,    81,
      82,    -1,    -1,    85,    86,    87,    88,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    99,   100,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     122,   123,   124,   125,   126,   127,   128,   129,   130,   131,
      -1,   133,   134,    51,    52,    -1,    -1,    55,    -1,   141,
     142,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    -1,    -1,    81,    82,    -1,    -1,    85,    86,    87,
      88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    99,   100,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   122,   123,   124,   125,   126,   127,
     128,   129,   130,   131,    -1,   133,   134,    51,    52,    -1,
      -1,    55,    -1,   141,   142,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    -1,    -1,    81,    82,    -1,
      -1,    85,    86,    87,    88,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    99,   100,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,    -1,   133,
     134,    51,    52,    -1,    -1,    55,    -1,   141,   142,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    -1,
      -1,    81,    82,    -1,    -1,    85,    86,    87,    88,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    99,
     100,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   122,   123,   124,   125,   126,   127,   128,   129,
     130,   131,    -1,   133,   134,    51,    52,    -1,    -1,    55,
      -1,   141,   142,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    -1,    -1,    81,    82,    -1,    -1,    85,
      86,    87,    88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    99,   100,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,    -1,   133,   134,    51,
      52,    -1,    -1,    55,    -1,   141,   142,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    -1,    -1,    81,
      82,    -1,    -1,    85,    86,    87,    88,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    99,   100,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     122,   123,   124,   125,   126,   127,   128,   129,   130,   131,
      -1,   133,   134,    51,    52,    -1,    -1,    55,    -1,   141,
     142,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    -1,    -1,    81,    82,    -1,    -1,    85,    86,    87,
      88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    99,   100,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   122,   123,   124,   125,   126,   127,
     128,   129,   130,   131,    -1,   133,   134,    51,    52,    -1,
      -1,    55,    -1,   141,   142,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    -1,    -1,    81,    82,    -1,
      -1,    85,    86,    87,    88,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    99,   100,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,    -1,   133,
     134,    51,    52,    -1,    -1,    55,    -1,   141,   142,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    -1,
      -1,    81,    82,    -1,    -1,    85,    86,    87,    88,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    99,
     100,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    -1,    87,    88,    -1,    -1,
      -1,    -1,   122,   123,   124,   125,   126,   127,   128,   129,
     130,   131,    -1,   133,   134,    -1,    -1,    -1,    -1,    -1,
      -1,   141,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,   146,    87,    88,    -1,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    -1,    -1,    87,    88,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   120,   140,
     122,   123,   124,   125,   126,   127,   128,   129,   130,   131,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   140,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    -1,    87,    88,    -1,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    -1,    -1,    87,    88,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,
     123,   124,   125,   126,   127,   128,   129,   130,   131,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   120,   140,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   140,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    -1,    87,    88,    -1,    -1,    -1,    92,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    -1,    -1,    87,    88,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    -1,    -1,    87,    88,    72,    73,    74,    75,    76,
      77,    78,    79,    -1,    81,    82,    -1,    -1,    -1,    -1,
      87,    88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   122,   123,   124,   125,   126,
     127,   128,   129,   130,   131,    72,    73,    74,    75,    76,
      77,    78,    -1,    -1,    81,    82,    -1,    -1,    -1,    -1,
      87,    88,    72,    73,    74,    75,    76,    77,    78,    -1,
      -1,    81,    82,    -1,    -1,    -1,    -1,    87,    88,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   122,   123,   124,   125,   126,
     127,   128,   129,   130,   131,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   122,   123,   124,   125,   126,   127,   128,   129,
     130,   131
};

  /* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
static const yytype_uint16 yystos[] =
{
       0,   148,   149,     0,     1,     3,     4,     5,     6,     7,
       8,     9,    10,    11,    12,    19,    21,    22,    23,    24,
      30,    31,    32,    33,    34,    35,    36,    39,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      58,    59,    60,    63,    66,    67,    69,    70,    71,    90,
      93,    94,    96,    97,    99,   102,   104,   105,   106,   107,
     108,   109,   112,   132,   133,   134,   150,   151,   152,   157,
     159,   161,   163,   164,   167,   168,   170,   171,   172,   174,
     175,   184,   198,   219,   240,   241,   251,   252,   253,   257,
     258,   259,   265,   266,   267,   269,   270,   271,   272,   273,
     274,   309,   322,   152,    21,    22,    30,    31,    32,    39,
      51,    55,    69,    87,    90,    93,   132,   176,   177,   198,
     219,   271,   274,   309,   177,     3,     4,     5,     6,     7,
       8,     9,    10,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,    45,
      46,    47,    48,    49,    50,    51,    52,    55,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    81,    82,    85,
      86,    87,    88,    99,   100,   122,   123,   124,   125,   126,
     127,   128,   129,   130,   131,   133,   134,   141,   142,   178,
     182,   183,   273,   303,   199,    90,   161,   162,   175,   219,
     271,   272,   274,   162,   205,   207,    69,    90,   168,   175,
     219,   224,   271,   274,    33,    34,    35,    36,    48,    49,
      50,    51,    55,   104,   178,   179,   180,   267,   113,   116,
     117,   144,   146,   162,   261,   262,   263,   315,   319,   320,
     321,    51,    99,   100,   101,   133,   167,   184,   190,   193,
     196,   253,   306,   308,   190,   190,   142,   187,   188,   191,
     192,   322,   187,   191,   142,   316,   320,   179,   153,   136,
     184,   219,   184,    55,     1,    93,   155,   156,   157,   169,
     170,   322,   200,   202,   185,   196,   306,   322,   184,   305,
     306,   322,    90,   140,   174,   219,   271,   274,   203,    53,
      54,    56,    63,   108,   178,   268,    62,    64,    65,   114,
     115,   254,   255,    63,   254,    63,   254,    63,   254,    61,
     254,    58,    59,   163,   184,   184,   315,   321,    40,    41,
      42,    43,    44,    37,    38,    28,   238,   119,   140,    93,
      99,   171,   119,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    87,    88,   120,   122,
     123,   124,   125,   126,   127,   128,   129,   130,   131,    89,
     103,   138,   145,   313,    89,   313,   314,    26,   136,   242,
     253,    91,    91,   187,   191,   242,   161,    51,    55,   176,
      58,    59,   123,   275,    89,   138,   313,   214,   304,   215,
      89,   145,   312,   154,   155,    55,    16,   220,   319,   119,
      89,   138,   313,    91,    91,   220,   162,   162,    55,    89,
     138,   313,    25,   108,   140,   264,   315,   113,   263,    20,
     245,   319,    57,   307,   184,   184,   184,    92,   140,   194,
     195,   322,   307,   194,   195,   189,   190,   196,   306,   322,
     190,   161,   315,   317,   161,   158,   136,   155,    89,   313,
      91,   157,   169,   143,   315,   321,   317,   157,   317,   139,
     195,   318,   321,   195,   318,   137,   318,    55,   171,   172,
     173,   140,    89,   138,   313,    51,    53,    54,    55,    56,
      69,    72,    93,    99,   100,   101,   126,   129,   142,   236,
     278,   279,   282,   283,   284,   285,   287,   288,   289,   290,
     292,   293,   294,   297,   298,   299,   300,   301,    63,   254,
     256,   260,   261,    62,   255,    63,    63,    63,    61,    72,
      72,   152,   162,   162,   162,   162,   157,   161,   161,   239,
      99,   163,   184,   196,   197,   169,   140,   174,   140,   159,
     160,   163,   175,   184,   186,   197,   219,   274,   184,   184,
     184,   184,   184,   184,   184,   184,   184,   184,   184,   184,
     184,   184,   184,   184,   184,   184,   184,   184,   184,   184,
     184,   184,   184,   184,    51,    52,    55,   182,   187,   310,
     311,   189,    51,    52,    55,   182,   187,   310,    51,    55,
     310,   244,   243,   160,   184,   186,   160,   186,    98,   165,
     212,   276,   211,    51,    55,   176,   310,   189,   310,   154,
     161,   216,   217,    15,    13,   247,   322,   155,    16,    51,
      55,   189,    51,    55,   155,    27,   221,   319,   221,    51,
      55,   189,    51,    55,   209,   181,   155,   245,   184,   196,
      15,   260,   184,   184,   316,    99,   184,   193,   306,   184,
     308,   143,   315,   195,   195,   317,   143,   179,   150,   137,
     186,   317,   157,   201,   306,   171,   173,    51,    55,   189,
      51,    55,    57,   119,   291,   287,   204,   184,   140,   302,
     322,    51,   140,   302,   140,   286,   184,   140,   286,    51,
     140,   286,    51,    63,   155,   261,   184,   184,    80,   124,
     230,   231,   322,   184,   195,   317,   173,   140,    44,   119,
      44,    89,   138,   313,   316,    91,    91,   187,   191,   139,
      91,    91,   188,   191,   188,   191,   230,   230,   166,   319,
     162,   154,   139,    15,   317,   142,   277,   287,   178,   184,
     197,   248,   322,    18,   223,   322,    17,   222,   223,    91,
      91,   139,    91,    91,   223,   206,   208,   139,   162,   179,
     137,    15,   195,   220,   260,   184,   194,   306,   137,   317,
     318,   139,    51,    99,   225,   292,   233,   316,    29,   111,
     237,    51,   279,   284,   301,   285,   290,   297,   299,   292,
     294,   299,    51,   292,   137,   227,   229,   232,   278,   280,
     281,   284,   292,   293,   295,   296,   299,   301,   154,    99,
     184,   173,   157,   184,    51,    55,   189,    51,    55,    57,
     121,   160,   186,   163,   186,   165,    91,   160,   186,   160,
     186,   165,   242,   238,   154,   155,   230,   213,   319,    15,
     287,   154,   319,   218,    92,   249,   322,   155,    14,   250,
     322,   162,    15,    91,    15,   155,   155,   221,   184,   155,
     195,   140,   289,   317,   140,   143,   144,   154,   155,   302,
     140,   286,   140,   286,   140,   286,   140,   286,   286,   233,
     233,    90,   219,   140,   302,   302,   140,   228,   219,   140,
     228,   140,   228,    15,   184,   139,   184,   184,   160,   186,
      15,   137,   155,   154,   317,    15,   277,    90,   175,   219,
     271,   274,   220,   155,   220,    15,    15,   210,   223,   245,
     246,   226,   140,    99,    51,   234,   235,   288,    15,   137,
     292,   299,   292,   292,   124,   124,    55,    89,   280,   284,
     140,   227,   228,   296,   299,   292,   295,   299,   292,   137,
      15,   154,    55,    89,   138,   313,   155,   155,   155,   292,
     292,   140,   289,   140,   316,   286,   140,   286,   286,   286,
      51,    55,   302,   140,   228,   140,   228,   140,   228,   140,
     228,   228,    15,    51,    55,   189,    51,    55,   247,   222,
      15,   140,   292,   140,   235,   292,   292,   299,   292,   292,
     139,   292,   286,   228,   140,   228,   228,   228,   292,   228
};

  /* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint16 yyr1[] =
{
       0,   147,   149,   148,   150,   151,   151,   151,   151,   152,
     153,   152,   154,   155,   156,   156,   156,   156,   158,   157,
     157,   157,   157,   157,   157,   157,   157,   157,   157,   157,
     157,   157,   157,   159,   159,   159,   159,   159,   159,   159,
     159,   160,   160,   160,   161,   161,   161,   161,   161,   161,
     162,   163,   163,   164,   164,   166,   165,   167,   167,   167,
     167,   167,   167,   167,   167,   167,   167,   167,   168,   168,
     169,   169,   170,   170,   170,   170,   170,   170,   170,   170,
     170,   170,   171,   171,   172,   172,   173,   173,   174,   174,
     174,   174,   174,   174,   174,   174,   175,   175,   175,   175,
     175,   175,   175,   175,   175,   176,   176,   177,   177,   177,
     178,   178,   178,   178,   178,   179,   179,   180,   181,   180,
     182,   182,   182,   182,   182,   182,   182,   182,   182,   182,
     182,   182,   182,   182,   182,   182,   182,   182,   182,   182,
     182,   182,   182,   182,   182,   182,   182,   182,   182,   182,
     183,   183,   183,   183,   183,   183,   183,   183,   183,   183,
     183,   183,   183,   183,   183,   183,   183,   183,   183,   183,
     183,   183,   183,   183,   183,   183,   183,   183,   183,   183,
     183,   183,   183,   183,   183,   183,   183,   183,   183,   183,
     184,   184,   184,   184,   184,   184,   184,   184,   184,   184,
     184,   184,   184,   184,   184,   184,   184,   184,   184,   184,
     184,   184,   184,   184,   184,   184,   184,   184,   184,   184,
     184,   184,   184,   184,   184,   184,   184,   184,   184,   184,
     184,   184,   184,   185,   185,   185,   185,   186,   186,   187,
     188,   188,   189,   189,   189,   189,   189,   190,   190,   190,
     190,   190,   192,   191,   193,   194,   194,   195,   195,   196,
     196,   196,   196,   197,   197,   197,   198,   198,   198,   198,
     198,   198,   198,   198,   198,   199,   198,   200,   201,   198,
     202,   198,   198,   198,   198,   198,   198,   198,   198,   198,
     198,   198,   198,   198,   203,   204,   198,   198,   198,   205,
     206,   198,   207,   208,   198,   198,   198,   209,   210,   198,
     211,   198,   212,   213,   198,   214,   198,   215,   216,   198,
     217,   218,   198,   198,   198,   198,   198,   219,   220,   220,
     220,   221,   221,   222,   222,   223,   223,   224,   224,   225,
     225,   225,   225,   225,   225,   225,   225,   226,   225,   227,
     227,   227,   227,   228,   228,   229,   229,   229,   229,   229,
     229,   229,   229,   229,   229,   229,   229,   229,   229,   229,
     230,   230,   232,   231,   231,   231,   233,   233,   234,   234,
     235,   235,   236,   236,   237,   237,   239,   238,   240,   240,
     240,   240,   241,   241,   241,   241,   241,   241,   241,   241,
     241,   243,   242,   244,   242,   245,   246,   246,   247,   247,
     248,   248,   248,   249,   249,   250,   250,   251,   251,   251,
     251,   252,   252,   253,   253,   253,   253,   254,   254,   255,
     256,   255,   255,   255,   257,   257,   258,   258,   259,   260,
     260,   261,   261,   262,   262,   263,   264,   263,   265,   265,
     266,   266,   267,   268,   268,   268,   268,   268,   268,   269,
     269,   270,   270,   270,   270,   271,   271,   271,   271,   271,
     272,   272,   273,   273,   273,   273,   273,   273,   273,   273,
     274,   274,   275,   276,   275,   277,   277,   278,   279,   279,
     280,   280,   281,   281,   282,   282,   283,   283,   284,   284,
     285,   285,   285,   285,   286,   286,   287,   287,   287,   287,
     287,   287,   287,   287,   287,   287,   287,   287,   287,   287,
     287,   288,   288,   288,   288,   288,   289,   289,   290,   291,
     290,   292,   292,   293,   294,   295,   296,   296,   297,   297,
     298,   298,   299,   299,   300,   300,   301,   302,   302,   303,
     304,   303,   305,   305,   306,   306,   307,   307,   308,   308,
     308,   308,   309,   309,   309,   310,   310,   310,   310,   311,
     311,   311,   312,   312,   313,   313,   314,   314,   315,   315,
     316,   316,   317,   318,   318,   318,   319,   319,   319,   320,
     321,   321,   322
};

  /* YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     0,     2,     2,     1,     1,     3,     2,     1,
       0,     5,     4,     2,     1,     1,     3,     2,     0,     4,
       2,     3,     3,     3,     3,     3,     4,     1,     3,     3,
       3,     3,     1,     3,     3,     6,     5,     5,     5,     5,
       3,     1,     3,     1,     1,     3,     3,     3,     2,     1,
       1,     1,     1,     1,     4,     0,     5,     2,     3,     4,
       5,     4,     5,     2,     2,     2,     2,     2,     1,     3,
       1,     3,     1,     2,     3,     5,     2,     4,     2,     4,
       1,     3,     1,     3,     2,     3,     1,     2,     1,     4,
       3,     3,     3,     3,     2,     1,     1,     4,     3,     3,
       3,     3,     2,     1,     1,     1,     1,     2,     1,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     4,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     3,     6,     5,     5,     5,     5,     4,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     4,     4,     2,
       2,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     2,     2,     3,     3,     3,     3,
       6,     6,     1,     1,     2,     4,     2,     1,     3,     3,
       1,     1,     1,     2,     2,     4,     2,     1,     2,     2,
       4,     1,     0,     2,     2,     2,     1,     1,     3,     1,
       2,     3,     4,     3,     4,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     4,     0,     0,     5,
       0,     3,     3,     3,     2,     3,     3,     1,     2,     4,
       3,     2,     1,     2,     0,     0,     5,     6,     6,     0,
       0,     7,     0,     0,     7,     5,     4,     0,     0,     9,
       0,     6,     0,     0,     8,     0,     5,     0,     0,     7,
       0,     0,     9,     1,     1,     1,     1,     1,     1,     1,
       2,     1,     1,     1,     5,     1,     2,     1,     1,     1,
       4,     6,     3,     5,     2,     4,     1,     0,     4,     4,
       2,     2,     1,     2,     0,     6,     8,     4,     6,     4,
       3,     6,     2,     4,     6,     2,     4,     2,     4,     1,
       1,     1,     0,     4,     1,     4,     1,     4,     1,     3,
       1,     1,     4,     1,     3,     3,     0,     5,     2,     4,
       5,     5,     2,     4,     4,     3,     3,     3,     2,     1,
       4,     0,     5,     0,     5,     5,     1,     1,     6,     1,
       1,     1,     1,     2,     1,     2,     1,     1,     1,     1,
       1,     1,     2,     1,     1,     2,     3,     1,     2,     1,
       0,     4,     1,     2,     2,     3,     2,     3,     1,     1,
       2,     1,     2,     1,     2,     1,     0,     4,     2,     3,
       1,     4,     2,     1,     1,     1,     1,     1,     2,     2,
       3,     1,     1,     2,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     0,     4,     3,     2,     2,     2,     1,
       2,     1,     1,     3,     1,     3,     1,     1,     2,     1,
       4,     2,     2,     1,     2,     0,     6,     8,     4,     6,
       4,     6,     2,     4,     6,     2,     4,     2,     4,     1,
       0,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       4,     1,     3,     2,     2,     2,     1,     3,     1,     3,
       1,     1,     2,     1,     1,     1,     2,     2,     1,     1,
       0,     4,     1,     2,     1,     3,     1,     2,     3,     3,
       3,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     1,
       0,     1,     2,     0,     1,     1,     1,     1,     1,     1,
       1,     2,     0
};


#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)
#define YYEMPTY         (-2)
#define YYEOF           0

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (p, YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Error token number */
#define YYTERROR        1
#define YYERRCODE       256



/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)

/* This macro is provided for backward compatibility. */
#ifndef YY_LOCATION_PRINT
# define YY_LOCATION_PRINT(File, Loc) ((void) 0)
#endif


# define YY_SYMBOL_PRINT(Title, Type, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Type, Value, p); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo, int yytype, YYSTYPE const * const yyvaluep, parser_state *p)
{
  FILE *yyoutput = yyo;
  YYUSE (yyoutput);
  YYUSE (p);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyo, yytoknum[yytype], *yyvaluep);
# endif
  YYUSE (yytype);
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo, int yytype, YYSTYPE const * const yyvaluep, parser_state *p)
{
  YYFPRINTF (yyo, "%s %s (",
             yytype < YYNTOKENS ? "token" : "nterm", yytname[yytype]);

  yy_symbol_value_print (yyo, yytype, yyvaluep, p);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yytype_int16 *yyssp, YYSTYPE *yyvsp, int yyrule, parser_state *p)
{
  unsigned long yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       yystos[yyssp[yyi + 1 - yynrhs]],
                       &yyvsp[(yyi + 1) - (yynrhs)]
                                              , p);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule, p); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
yystrlen (const char *yystr)
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            else
              goto append;

          append:
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return (YYSIZE_T) (yystpcpy (yyres, yystr) - yyres);
}
# endif

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return 1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return 2 if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYSIZE_T *yymsg_alloc, char **yymsg,
                yytype_int16 *yyssp, int yytoken)
{
  YYSIZE_T yysize0 = yytnamerr (YY_NULLPTR, yytname[yytoken]);
  YYSIZE_T yysize = yysize0;
  enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat. */
  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
  /* Number of reported tokens (one for the "unexpected", one per
     "expected"). */
  int yycount = 0;

  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yytoken != YYEMPTY)
    {
      int yyn = yypact[*yyssp];
      yyarg[yycount++] = yytname[yytoken];
      if (!yypact_value_is_default (yyn))
        {
          /* Start YYX at -YYN if negative to avoid negative indexes in
             YYCHECK.  In other words, skip the first -YYN actions for
             this state because they are default actions.  */
          int yyxbegin = yyn < 0 ? -yyn : 0;
          /* Stay within bounds of both yycheck and yytname.  */
          int yychecklim = YYLAST - yyn + 1;
          int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
          int yyx;

          for (yyx = yyxbegin; yyx < yyxend; ++yyx)
            if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR
                && !yytable_value_is_error (yytable[yyx + yyn]))
              {
                if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                  {
                    yycount = 1;
                    yysize = yysize0;
                    break;
                  }
                yyarg[yycount++] = yytname[yyx];
                {
                  YYSIZE_T yysize1 = yysize + yytnamerr (YY_NULLPTR, yytname[yyx]);
                  if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
                    yysize = yysize1;
                  else
                    return 2;
                }
              }
        }
    }

  switch (yycount)
    {
# define YYCASE_(N, S)                      \
      case N:                               \
        yyformat = S;                       \
      break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
# undef YYCASE_
    }

  {
    YYSIZE_T yysize1 = yysize + yystrlen (yyformat);
    if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
      yysize = yysize1;
    else
      return 2;
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return 1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yyarg[yyi++]);
          yyformat += 2;
        }
      else
        {
          yyp++;
          yyformat++;
        }
  }
  return 0;
}
#endif /* YYERROR_VERBOSE */

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep, parser_state *p)
{
  YYUSE (yyvaluep);
  YYUSE (p);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YYUSE (yytype);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}




/*----------.
| yyparse.  |
`----------*/

int
yyparse (parser_state *p)
{
/* The lookahead symbol.  */
int yychar;


/* The semantic value of the lookahead symbol.  */
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
YY_INITIAL_VALUE (static YYSTYPE yyval_default;)
YYSTYPE yylval YY_INITIAL_VALUE (= yyval_default);

    /* Number of syntax errors so far.  */
    int yynerrs;

    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       'yyss': related to states.
       'yyvs': related to semantic values.

       Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yyssp = yyss = yyssa;
  yyvsp = yyvs = yyvsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */
  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yynewstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  *yyssp = (yytype_int16) yystate;

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    goto yyexhaustedlab;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = (YYSIZE_T) (yyssp - yyss + 1);

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        YYSTYPE *yyvs1 = yyvs;
        yytype_int16 *yyss1 = yyss;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * sizeof (*yyssp),
                    &yyvs1, yysize * sizeof (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yytype_int16 *yyss1 = yyss;
        union yyalloc *yyptr =
          (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
        if (! yyptr)
          goto yyexhaustedlab;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
# undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
                  (unsigned long) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = yylex (&yylval, p);
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 1488 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      p->lstate = EXPR_BEG;
                      if (!p->locals) p->locals = cons(0,0);
                    }
#line 5522 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 3:
#line 1493 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      p->tree = new_scope(p, (yyvsp[0].nd));
                      NODE_LINENO(p->tree, (yyvsp[0].nd));
                    }
#line 5531 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 4:
#line 1500 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = (yyvsp[-1].nd);
                    }
#line 5539 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 5:
#line 1506 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_begin(p, 0);
                    }
#line 5547 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 6:
#line 1510 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_begin(p, (yyvsp[0].nd));
                      NODE_LINENO((yyval.nd), (yyvsp[0].nd));
                    }
#line 5556 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 7:
#line 1515 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = push((yyvsp[-2].nd), newline_node((yyvsp[0].nd)));
                    }
#line 5564 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 8:
#line 1519 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_begin(p, 0);
                    }
#line 5572 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 10:
#line 1526 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = local_switch(p);
                      nvars_block(p);
                    }
#line 5581 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 11:
#line 1531 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      yyerror(p, "BEGIN not supported");
                      local_resume(p, (yyvsp[-3].nd));
                      nvars_unnest(p);
                      (yyval.nd) = 0;
                    }
#line 5592 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 12:
#line 1543 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      if ((yyvsp[-2].nd)) {
                        (yyval.nd) = new_rescue(p, (yyvsp[-3].nd), (yyvsp[-2].nd), (yyvsp[-1].nd));
                        NODE_LINENO((yyval.nd), (yyvsp[-3].nd));
                      }
                      else if ((yyvsp[-1].nd)) {
                        yywarn(p, "else without rescue is useless");
                        (yyval.nd) = push((yyvsp[-3].nd), (yyvsp[-1].nd));
                      }
                      else {
                        (yyval.nd) = (yyvsp[-3].nd);
                      }
                      if ((yyvsp[0].nd)) {
                        if ((yyval.nd)) {
                          (yyval.nd) = new_ensure(p, (yyval.nd), (yyvsp[0].nd));
                        }
                        else {
                          (yyval.nd) = push((yyvsp[0].nd), new_nil(p));
                        }
                      }
                    }
#line 5618 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 13:
#line 1567 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = (yyvsp[-1].nd);
                    }
#line 5626 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 14:
#line 1573 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_begin(p, 0);
                    }
#line 5634 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 15:
#line 1577 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_begin(p, (yyvsp[0].nd));
                      NODE_LINENO((yyval.nd), (yyvsp[0].nd));
                    }
#line 5643 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 16:
#line 1582 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = push((yyvsp[-2].nd), newline_node((yyvsp[0].nd)));
                    }
#line 5651 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 17:
#line 1586 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_begin(p, (yyvsp[0].nd));
                    }
#line 5659 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 18:
#line 1591 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {p->lstate = EXPR_FNAME;}
#line 5665 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 19:
#line 1592 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_alias(p, (yyvsp[-2].id), (yyvsp[0].id));
                    }
#line 5673 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 20:
#line 1596 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = (yyvsp[0].nd);
                    }
#line 5681 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 21:
#line 1600 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_if(p, cond((yyvsp[0].nd)), (yyvsp[-2].nd), 0);
                    }
#line 5689 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 22:
#line 1604 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_unless(p, cond((yyvsp[0].nd)), (yyvsp[-2].nd), 0);
                    }
#line 5697 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 23:
#line 1608 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_while(p, cond((yyvsp[0].nd)), (yyvsp[-2].nd));
                    }
#line 5705 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 24:
#line 1612 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_until(p, cond((yyvsp[0].nd)), (yyvsp[-2].nd));
                    }
#line 5713 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 25:
#line 1616 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_mod_rescue(p, (yyvsp[-2].nd), (yyvsp[0].nd));
                    }
#line 5721 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 26:
#line 1620 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      yyerror(p, "END not supported");
                      (yyval.nd) = new_postexe(p, (yyvsp[-1].nd));
                    }
#line 5730 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 28:
#line 1626 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_masgn(p, (yyvsp[-2].nd), (yyvsp[0].nd));
                    }
#line 5738 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 29:
#line 1630 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_asgn(p, (yyvsp[-2].nd), new_array(p, (yyvsp[0].nd)));
                    }
#line 5746 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 30:
#line 1634 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_masgn(p, (yyvsp[-2].nd), (yyvsp[0].nd));
                    }
#line 5754 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 31:
#line 1638 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_masgn(p, (yyvsp[-2].nd), new_array(p, (yyvsp[0].nd)));
                    }
#line 5762 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 33:
#line 1645 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_asgn(p, (yyvsp[-2].nd), (yyvsp[0].nd));
                    }
#line 5770 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 34:
#line 1649 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_op_asgn(p, (yyvsp[-2].nd), (yyvsp[-1].id), (yyvsp[0].nd));
                    }
#line 5778 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 35:
#line 1653 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_op_asgn(p, new_call(p, (yyvsp[-5].nd), intern_lit("[]"), (yyvsp[-3].nd), '.'), (yyvsp[-1].id), (yyvsp[0].nd));
                    }
#line 5786 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 36:
#line 1657 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_op_asgn(p, new_call(p, (yyvsp[-4].nd), (yyvsp[-2].id), 0, (yyvsp[-3].num)), (yyvsp[-1].id), (yyvsp[0].nd));
                    }
#line 5794 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 37:
#line 1661 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_op_asgn(p, new_call(p, (yyvsp[-4].nd), (yyvsp[-2].id), 0, (yyvsp[-3].num)), (yyvsp[-1].id), (yyvsp[0].nd));
                    }
#line 5802 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 38:
#line 1665 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      yyerror(p, "constant re-assignment");
                      (yyval.nd) = 0;
                    }
#line 5811 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 39:
#line 1670 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_op_asgn(p, new_call(p, (yyvsp[-4].nd), (yyvsp[-2].id), 0, tCOLON2), (yyvsp[-1].id), (yyvsp[0].nd));
                    }
#line 5819 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 40:
#line 1674 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      backref_error(p, (yyvsp[-2].nd));
                      (yyval.nd) = new_begin(p, 0);
                    }
#line 5828 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 42:
#line 1682 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_mod_rescue(p, (yyvsp[-2].nd), (yyvsp[0].nd));
                    }
#line 5836 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 45:
#line 1691 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_and(p, (yyvsp[-2].nd), (yyvsp[0].nd));
                    }
#line 5844 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 46:
#line 1695 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_or(p, (yyvsp[-2].nd), (yyvsp[0].nd));
                    }
#line 5852 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 47:
#line 1699 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = call_uni_op(p, cond((yyvsp[0].nd)), "!");
                    }
#line 5860 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 48:
#line 1703 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = call_uni_op(p, cond((yyvsp[0].nd)), "!");
                    }
#line 5868 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 50:
#line 1710 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      if (!(yyvsp[0].nd)) (yyval.nd) = new_nil(p);
                      else {
                        (yyval.nd) = (yyvsp[0].nd);
                      }
                    }
#line 5879 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 54:
#line 1724 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_call(p, (yyvsp[-3].nd), (yyvsp[-1].id), (yyvsp[0].nd), (yyvsp[-2].num));
                    }
#line 5887 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 55:
#line 1730 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      local_nest(p);
                      nvars_nest(p);
                    }
#line 5896 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 56:
#line 1737 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_block(p, (yyvsp[-2].nd), (yyvsp[-1].nd));
                      local_unnest(p);
                      nvars_unnest(p);
                    }
#line 5906 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 57:
#line 1745 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_fcall(p, (yyvsp[-1].id), (yyvsp[0].nd));
                    }
#line 5914 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 58:
#line 1749 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      args_with_block(p, (yyvsp[-1].nd), (yyvsp[0].nd));
                      (yyval.nd) = new_fcall(p, (yyvsp[-2].id), (yyvsp[-1].nd));
                    }
#line 5923 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 59:
#line 1754 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_call(p, (yyvsp[-3].nd), (yyvsp[-1].id), (yyvsp[0].nd), (yyvsp[-2].num));
                    }
#line 5931 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 60:
#line 1758 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      args_with_block(p, (yyvsp[-1].nd), (yyvsp[0].nd));
                      (yyval.nd) = new_call(p, (yyvsp[-4].nd), (yyvsp[-2].id), (yyvsp[-1].nd), (yyvsp[-3].num));
                   }
#line 5940 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 61:
#line 1763 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_call(p, (yyvsp[-3].nd), (yyvsp[-1].id), (yyvsp[0].nd), tCOLON2);
                    }
#line 5948 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 62:
#line 1767 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      args_with_block(p, (yyvsp[-1].nd), (yyvsp[0].nd));
                      (yyval.nd) = new_call(p, (yyvsp[-4].nd), (yyvsp[-2].id), (yyvsp[-1].nd), tCOLON2);
                    }
#line 5957 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 63:
#line 1772 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_super(p, (yyvsp[0].nd));
                    }
#line 5965 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 64:
#line 1776 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_yield(p, (yyvsp[0].nd));
                    }
#line 5973 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 65:
#line 1780 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_return(p, ret_args(p, (yyvsp[0].nd)));
                    }
#line 5981 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 66:
#line 1784 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_break(p, ret_args(p, (yyvsp[0].nd)));
                    }
#line 5989 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 67:
#line 1788 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_next(p, ret_args(p, (yyvsp[0].nd)));
                    }
#line 5997 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 68:
#line 1794 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = (yyvsp[0].nd);
                    }
#line 6005 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 69:
#line 1798 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = (yyvsp[-1].nd);
                    }
#line 6013 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 71:
#line 1805 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = (yyvsp[-1].nd);
                    }
#line 6021 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 72:
#line 1811 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = list1((yyvsp[0].nd));
                    }
#line 6029 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 73:
#line 1815 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = list1(push((yyvsp[-1].nd),(yyvsp[0].nd)));
                    }
#line 6037 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 74:
#line 1819 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = list2((yyvsp[-2].nd), (yyvsp[0].nd));
                    }
#line 6045 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 75:
#line 1823 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = list3((yyvsp[-4].nd), (yyvsp[-2].nd), (yyvsp[0].nd));
                    }
#line 6053 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 76:
#line 1827 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = list2((yyvsp[-1].nd), new_nil(p));
                    }
#line 6061 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 77:
#line 1831 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = list3((yyvsp[-3].nd), new_nil(p), (yyvsp[0].nd));
                    }
#line 6069 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 78:
#line 1835 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = list2(0, (yyvsp[0].nd));
                    }
#line 6077 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 79:
#line 1839 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = list3(0, (yyvsp[-2].nd), (yyvsp[0].nd));
                    }
#line 6085 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 80:
#line 1843 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = list2(0, new_nil(p));
                    }
#line 6093 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 81:
#line 1847 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = list3(0, new_nil(p), (yyvsp[0].nd));
                    }
#line 6101 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 83:
#line 1854 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_masgn(p, (yyvsp[-1].nd), NULL);
                    }
#line 6109 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 84:
#line 1860 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = list1((yyvsp[-1].nd));
                    }
#line 6117 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 85:
#line 1864 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = push((yyvsp[-2].nd), (yyvsp[-1].nd));
                    }
#line 6125 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 86:
#line 1870 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = list1((yyvsp[0].nd));
                    }
#line 6133 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 87:
#line 1874 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = push((yyvsp[-1].nd), (yyvsp[0].nd));
                    }
#line 6141 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 88:
#line 1880 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      assignable(p, (yyvsp[0].nd));
                    }
#line 6149 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 89:
#line 1884 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_call(p, (yyvsp[-3].nd), intern_lit("[]"), (yyvsp[-1].nd), '.');
                    }
#line 6157 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 90:
#line 1888 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_call(p, (yyvsp[-2].nd), (yyvsp[0].id), 0, (yyvsp[-1].num));
                    }
#line 6165 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 91:
#line 1892 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_call(p, (yyvsp[-2].nd), (yyvsp[0].id), 0, tCOLON2);
                    }
#line 6173 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 92:
#line 1896 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_call(p, (yyvsp[-2].nd), (yyvsp[0].id), 0, (yyvsp[-1].num));
                    }
#line 6181 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 93:
#line 1900 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      if (p->in_def || p->in_single)
                        yyerror(p, "dynamic constant assignment");
                      (yyval.nd) = new_colon2(p, (yyvsp[-2].nd), (yyvsp[0].id));
                    }
#line 6191 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 94:
#line 1906 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      if (p->in_def || p->in_single)
                        yyerror(p, "dynamic constant assignment");
                      (yyval.nd) = new_colon3(p, (yyvsp[0].id));
                    }
#line 6201 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 95:
#line 1912 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      backref_error(p, (yyvsp[0].nd));
                      (yyval.nd) = 0;
                    }
#line 6210 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 96:
#line 1919 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      assignable(p, (yyvsp[0].nd));
                    }
#line 6218 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 97:
#line 1923 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_call(p, (yyvsp[-3].nd), intern_lit("[]"), (yyvsp[-1].nd), '.');
                    }
#line 6226 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 98:
#line 1927 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_call(p, (yyvsp[-2].nd), (yyvsp[0].id), 0, (yyvsp[-1].num));
                    }
#line 6234 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 99:
#line 1931 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_call(p, (yyvsp[-2].nd), (yyvsp[0].id), 0, tCOLON2);
                    }
#line 6242 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 100:
#line 1935 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_call(p, (yyvsp[-2].nd), (yyvsp[0].id), 0, (yyvsp[-1].num));
                    }
#line 6250 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 101:
#line 1939 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      if (p->in_def || p->in_single)
                        yyerror(p, "dynamic constant assignment");
                      (yyval.nd) = new_colon2(p, (yyvsp[-2].nd), (yyvsp[0].id));
                    }
#line 6260 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 102:
#line 1945 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      if (p->in_def || p->in_single)
                        yyerror(p, "dynamic constant assignment");
                      (yyval.nd) = new_colon3(p, (yyvsp[0].id));
                    }
#line 6270 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 103:
#line 1951 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      backref_error(p, (yyvsp[0].nd));
                      (yyval.nd) = 0;
                    }
#line 6279 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 104:
#line 1956 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      yyerror(p, "can't assign to numbered parameter");
                    }
#line 6287 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 105:
#line 1962 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      yyerror(p, "class/module name must be CONSTANT");
                    }
#line 6295 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 107:
#line 1969 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = cons((node*)1, nsym((yyvsp[0].id)));
                    }
#line 6303 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 108:
#line 1973 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = cons((node*)0, nsym((yyvsp[0].id)));
                    }
#line 6311 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 109:
#line 1977 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      void_expr_error(p, (yyvsp[-2].nd));
                      (yyval.nd) = cons((yyvsp[-2].nd), nsym((yyvsp[0].id)));
                    }
#line 6320 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 113:
#line 1987 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      p->lstate = EXPR_ENDFN;
                      (yyval.id) = (yyvsp[0].id);
                    }
#line 6329 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 114:
#line 1992 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      p->lstate = EXPR_ENDFN;
                      (yyval.id) = (yyvsp[0].id);
                    }
#line 6338 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 117:
#line 2003 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_undef(p, (yyvsp[0].id));
                    }
#line 6346 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 118:
#line 2006 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {p->lstate = EXPR_FNAME;}
#line 6352 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 119:
#line 2007 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = push((yyvsp[-3].nd), nsym((yyvsp[0].id)));
                    }
#line 6360 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 120:
#line 2012 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    { (yyval.id) = intern_lit("|");   }
#line 6366 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 121:
#line 2013 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    { (yyval.id) = intern_lit("^");   }
#line 6372 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 122:
#line 2014 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    { (yyval.id) = intern_lit("&");   }
#line 6378 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 123:
#line 2015 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    { (yyval.id) = intern_lit("<=>"); }
#line 6384 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 124:
#line 2016 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    { (yyval.id) = intern_lit("==");  }
#line 6390 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 125:
#line 2017 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    { (yyval.id) = intern_lit("==="); }
#line 6396 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 126:
#line 2018 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    { (yyval.id) = intern_lit("=~");  }
#line 6402 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 127:
#line 2019 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    { (yyval.id) = intern_lit("!~");  }
#line 6408 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 128:
#line 2020 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    { (yyval.id) = intern_lit(">");   }
#line 6414 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 129:
#line 2021 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    { (yyval.id) = intern_lit(">=");  }
#line 6420 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 130:
#line 2022 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    { (yyval.id) = intern_lit("<");   }
#line 6426 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 131:
#line 2023 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    { (yyval.id) = intern_lit("<=");  }
#line 6432 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 132:
#line 2024 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    { (yyval.id) = intern_lit("!=");  }
#line 6438 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 133:
#line 2025 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    { (yyval.id) = intern_lit("<<");  }
#line 6444 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 134:
#line 2026 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    { (yyval.id) = intern_lit(">>");  }
#line 6450 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 135:
#line 2027 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    { (yyval.id) = intern_lit("+");   }
#line 6456 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 136:
#line 2028 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    { (yyval.id) = intern_lit("-");   }
#line 6462 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 137:
#line 2029 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    { (yyval.id) = intern_lit("*");   }
#line 6468 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 138:
#line 2030 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    { (yyval.id) = intern_lit("*");   }
#line 6474 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 139:
#line 2031 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    { (yyval.id) = intern_lit("/");   }
#line 6480 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 140:
#line 2032 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    { (yyval.id) = intern_lit("%");   }
#line 6486 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 141:
#line 2033 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    { (yyval.id) = intern_lit("**");  }
#line 6492 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 142:
#line 2034 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    { (yyval.id) = intern_lit("**");  }
#line 6498 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 143:
#line 2035 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    { (yyval.id) = intern_lit("!");   }
#line 6504 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 144:
#line 2036 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    { (yyval.id) = intern_lit("~");   }
#line 6510 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 145:
#line 2037 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    { (yyval.id) = intern_lit("+@");  }
#line 6516 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 146:
#line 2038 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    { (yyval.id) = intern_lit("-@");  }
#line 6522 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 147:
#line 2039 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    { (yyval.id) = intern_lit("[]");  }
#line 6528 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 148:
#line 2040 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    { (yyval.id) = intern_lit("[]="); }
#line 6534 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 149:
#line 2041 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    { (yyval.id) = intern_lit("`");   }
#line 6540 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 190:
#line 2059 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_asgn(p, (yyvsp[-2].nd), (yyvsp[0].nd));
                    }
#line 6548 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 191:
#line 2063 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_op_asgn(p, (yyvsp[-2].nd), (yyvsp[-1].id), (yyvsp[0].nd));
                    }
#line 6556 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 192:
#line 2067 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_op_asgn(p, new_call(p, (yyvsp[-5].nd), intern_lit("[]"), (yyvsp[-3].nd), '.'), (yyvsp[-1].id), (yyvsp[0].nd));
                    }
#line 6564 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 193:
#line 2071 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_op_asgn(p, new_call(p, (yyvsp[-4].nd), (yyvsp[-2].id), 0, (yyvsp[-3].num)), (yyvsp[-1].id), (yyvsp[0].nd));
                    }
#line 6572 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 194:
#line 2075 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_op_asgn(p, new_call(p, (yyvsp[-4].nd), (yyvsp[-2].id), 0, (yyvsp[-3].num)), (yyvsp[-1].id), (yyvsp[0].nd));
                    }
#line 6580 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 195:
#line 2079 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_op_asgn(p, new_call(p, (yyvsp[-4].nd), (yyvsp[-2].id), 0, tCOLON2), (yyvsp[-1].id), (yyvsp[0].nd));
                    }
#line 6588 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 196:
#line 2083 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      yyerror(p, "constant re-assignment");
                      (yyval.nd) = new_begin(p, 0);
                    }
#line 6597 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 197:
#line 2088 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      yyerror(p, "constant re-assignment");
                      (yyval.nd) = new_begin(p, 0);
                    }
#line 6606 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 198:
#line 2093 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      backref_error(p, (yyvsp[-2].nd));
                      (yyval.nd) = new_begin(p, 0);
                    }
#line 6615 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 199:
#line 2098 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_dot2(p, (yyvsp[-2].nd), (yyvsp[0].nd));
                    }
#line 6623 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 200:
#line 2102 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_dot3(p, (yyvsp[-2].nd), (yyvsp[0].nd));
                    }
#line 6631 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 201:
#line 2106 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = call_bin_op(p, (yyvsp[-2].nd), "+", (yyvsp[0].nd));
                    }
#line 6639 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 202:
#line 2110 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = call_bin_op(p, (yyvsp[-2].nd), "-", (yyvsp[0].nd));
                    }
#line 6647 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 203:
#line 2114 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = call_bin_op(p, (yyvsp[-2].nd), "*", (yyvsp[0].nd));
                    }
#line 6655 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 204:
#line 2118 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = call_bin_op(p, (yyvsp[-2].nd), "/", (yyvsp[0].nd));
                    }
#line 6663 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 205:
#line 2122 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = call_bin_op(p, (yyvsp[-2].nd), "%", (yyvsp[0].nd));
                    }
#line 6671 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 206:
#line 2126 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = call_bin_op(p, (yyvsp[-2].nd), "**", (yyvsp[0].nd));
                    }
#line 6679 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 207:
#line 2130 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = call_uni_op(p, call_bin_op(p, (yyvsp[-2].nd), "**", (yyvsp[0].nd)), "-@");
                    }
#line 6687 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 208:
#line 2134 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = call_uni_op(p, call_bin_op(p, (yyvsp[-2].nd), "**", (yyvsp[0].nd)), "-@");
                    }
#line 6695 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 209:
#line 2138 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = call_uni_op(p, (yyvsp[0].nd), "+@");
                    }
#line 6703 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 210:
#line 2142 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = call_uni_op(p, (yyvsp[0].nd), "-@");
                    }
#line 6711 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 211:
#line 2146 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = call_bin_op(p, (yyvsp[-2].nd), "|", (yyvsp[0].nd));
                    }
#line 6719 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 212:
#line 2150 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = call_bin_op(p, (yyvsp[-2].nd), "^", (yyvsp[0].nd));
                    }
#line 6727 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 213:
#line 2154 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = call_bin_op(p, (yyvsp[-2].nd), "&", (yyvsp[0].nd));
                    }
#line 6735 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 214:
#line 2158 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = call_bin_op(p, (yyvsp[-2].nd), "<=>", (yyvsp[0].nd));
                    }
#line 6743 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 215:
#line 2162 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = call_bin_op(p, (yyvsp[-2].nd), ">", (yyvsp[0].nd));
                    }
#line 6751 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 216:
#line 2166 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = call_bin_op(p, (yyvsp[-2].nd), ">=", (yyvsp[0].nd));
                    }
#line 6759 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 217:
#line 2170 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = call_bin_op(p, (yyvsp[-2].nd), "<", (yyvsp[0].nd));
                    }
#line 6767 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 218:
#line 2174 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = call_bin_op(p, (yyvsp[-2].nd), "<=", (yyvsp[0].nd));
                    }
#line 6775 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 219:
#line 2178 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = call_bin_op(p, (yyvsp[-2].nd), "==", (yyvsp[0].nd));
                    }
#line 6783 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 220:
#line 2182 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = call_bin_op(p, (yyvsp[-2].nd), "===", (yyvsp[0].nd));
                    }
#line 6791 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 221:
#line 2186 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = call_bin_op(p, (yyvsp[-2].nd), "!=", (yyvsp[0].nd));
                    }
#line 6799 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 222:
#line 2190 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = call_bin_op(p, (yyvsp[-2].nd), "=~", (yyvsp[0].nd));
                    }
#line 6807 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 223:
#line 2194 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = call_bin_op(p, (yyvsp[-2].nd), "!~", (yyvsp[0].nd));
                    }
#line 6815 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 224:
#line 2198 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = call_uni_op(p, cond((yyvsp[0].nd)), "!");
                    }
#line 6823 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 225:
#line 2202 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = call_uni_op(p, cond((yyvsp[0].nd)), "~");
                    }
#line 6831 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 226:
#line 2206 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = call_bin_op(p, (yyvsp[-2].nd), "<<", (yyvsp[0].nd));
                    }
#line 6839 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 227:
#line 2210 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = call_bin_op(p, (yyvsp[-2].nd), ">>", (yyvsp[0].nd));
                    }
#line 6847 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 228:
#line 2214 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_and(p, (yyvsp[-2].nd), (yyvsp[0].nd));
                    }
#line 6855 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 229:
#line 2218 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_or(p, (yyvsp[-2].nd), (yyvsp[0].nd));
                    }
#line 6863 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 230:
#line 2222 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_if(p, cond((yyvsp[-5].nd)), (yyvsp[-3].nd), (yyvsp[0].nd));
                    }
#line 6871 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 231:
#line 2226 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_if(p, cond((yyvsp[-5].nd)), (yyvsp[-3].nd), (yyvsp[0].nd));
                    }
#line 6879 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 232:
#line 2230 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = (yyvsp[0].nd);
                    }
#line 6887 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 234:
#line 2237 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = (yyvsp[-1].nd);
                      NODE_LINENO((yyval.nd), (yyvsp[-1].nd));
                    }
#line 6896 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 235:
#line 2242 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = push((yyvsp[-3].nd), new_kw_hash(p, (yyvsp[-1].nd)));
                    }
#line 6904 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 236:
#line 2246 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = cons(new_kw_hash(p, (yyvsp[-1].nd)), 0);
                      NODE_LINENO((yyval.nd), (yyvsp[-1].nd));
                    }
#line 6913 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 237:
#line 2253 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = (yyvsp[0].nd);
                    }
#line 6921 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 238:
#line 2257 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      void_expr_error(p, (yyvsp[-2].nd));
                      void_expr_error(p, (yyvsp[0].nd));
                      (yyval.nd) = new_mod_rescue(p, (yyvsp[-2].nd), (yyvsp[0].nd));
                    }
#line 6931 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 239:
#line 2265 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = (yyvsp[-1].nd);
                    }
#line 6939 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 244:
#line 2277 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = cons((yyvsp[-1].nd),0);
                      NODE_LINENO((yyval.nd), (yyvsp[-1].nd));
                    }
#line 6948 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 245:
#line 2282 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = cons(push((yyvsp[-3].nd), new_kw_hash(p, (yyvsp[-1].nd))), 0);
                      NODE_LINENO((yyval.nd), (yyvsp[-3].nd));
                    }
#line 6957 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 246:
#line 2287 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = cons(list1(new_kw_hash(p, (yyvsp[-1].nd))), 0);
                      NODE_LINENO((yyval.nd), (yyvsp[-1].nd));
                    }
#line 6966 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 247:
#line 2294 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      void_expr_error(p, (yyvsp[0].nd));
                      (yyval.nd) = cons(list1((yyvsp[0].nd)), 0);
                      NODE_LINENO((yyval.nd), (yyvsp[0].nd));
                    }
#line 6976 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 248:
#line 2300 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = cons((yyvsp[-1].nd), (yyvsp[0].nd));
                      NODE_LINENO((yyval.nd), (yyvsp[-1].nd));
                    }
#line 6985 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 249:
#line 2305 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = cons(list1(new_kw_hash(p, (yyvsp[-1].nd))), (yyvsp[0].nd));
                      NODE_LINENO((yyval.nd), (yyvsp[-1].nd));
                    }
#line 6994 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 250:
#line 2310 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = cons(push((yyvsp[-3].nd), new_kw_hash(p, (yyvsp[-1].nd))), (yyvsp[0].nd));
                      NODE_LINENO((yyval.nd), (yyvsp[-3].nd));
                    }
#line 7003 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 251:
#line 2315 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = cons(0, (yyvsp[0].nd));
                      NODE_LINENO((yyval.nd), (yyvsp[0].nd));
                    }
#line 7012 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 252:
#line 2321 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.stack) = p->cmdarg_stack;
                      CMDARG_PUSH(1);
                    }
#line 7021 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 253:
#line 2326 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      p->cmdarg_stack = (yyvsp[-1].stack);
                      (yyval.nd) = (yyvsp[0].nd);
                    }
#line 7030 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 254:
#line 2333 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_block_arg(p, (yyvsp[0].nd));
                    }
#line 7038 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 255:
#line 2339 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = (yyvsp[0].nd);
                    }
#line 7046 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 256:
#line 2343 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = 0;
                    }
#line 7054 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 259:
#line 2353 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      void_expr_error(p, (yyvsp[0].nd));
                      (yyval.nd) = cons((yyvsp[0].nd), 0);
                      NODE_LINENO((yyval.nd), (yyvsp[0].nd));
                    }
#line 7064 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 260:
#line 2359 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      void_expr_error(p, (yyvsp[0].nd));
                      (yyval.nd) = cons(new_splat(p, (yyvsp[0].nd)), 0);
                      NODE_LINENO((yyval.nd), (yyvsp[0].nd));
                    }
#line 7074 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 261:
#line 2365 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      void_expr_error(p, (yyvsp[0].nd));
                      (yyval.nd) = push((yyvsp[-2].nd), (yyvsp[0].nd));
                    }
#line 7083 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 262:
#line 2370 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      void_expr_error(p, (yyvsp[0].nd));
                      (yyval.nd) = push((yyvsp[-3].nd), new_splat(p, (yyvsp[0].nd)));
                    }
#line 7092 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 263:
#line 2377 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      void_expr_error(p, (yyvsp[0].nd));
                      (yyval.nd) = push((yyvsp[-2].nd), (yyvsp[0].nd));
                    }
#line 7101 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 264:
#line 2382 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      void_expr_error(p, (yyvsp[0].nd));
                      (yyval.nd) = push((yyvsp[-3].nd), new_splat(p, (yyvsp[0].nd)));
                    }
#line 7110 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 265:
#line 2387 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      void_expr_error(p, (yyvsp[0].nd));
                      (yyval.nd) = list1(new_splat(p, (yyvsp[0].nd)));
                    }
#line 7119 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 273:
#line 2401 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_nvar(p, (yyvsp[0].num));
                    }
#line 7127 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 274:
#line 2405 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_fcall(p, (yyvsp[0].id), 0);
                    }
#line 7135 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 275:
#line 2409 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.stack) = p->cmdarg_stack;
                      p->cmdarg_stack = 0;
                    }
#line 7144 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 276:
#line 2415 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      p->cmdarg_stack = (yyvsp[-2].stack);
                      (yyval.nd) = (yyvsp[-1].nd);
                    }
#line 7153 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 277:
#line 2420 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.stack) = p->cmdarg_stack;
                      p->cmdarg_stack = 0;
                    }
#line 7162 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 278:
#line 2424 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {p->lstate = EXPR_ENDARG;}
#line 7168 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 279:
#line 2425 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      p->cmdarg_stack = (yyvsp[-3].stack);
                      (yyval.nd) = (yyvsp[-2].nd);
                    }
#line 7177 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 280:
#line 2429 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {p->lstate = EXPR_ENDARG;}
#line 7183 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 281:
#line 2430 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_nil(p);
                    }
#line 7191 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 282:
#line 2434 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = (yyvsp[-1].nd);
                    }
#line 7199 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 283:
#line 2438 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_colon2(p, (yyvsp[-2].nd), (yyvsp[0].id));
                    }
#line 7207 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 284:
#line 2442 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_colon3(p, (yyvsp[0].id));
                    }
#line 7215 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 285:
#line 2446 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_array(p, (yyvsp[-1].nd));
                      NODE_LINENO((yyval.nd), (yyvsp[-1].nd));
                    }
#line 7224 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 286:
#line 2451 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_hash(p, (yyvsp[-1].nd));
                      NODE_LINENO((yyval.nd), (yyvsp[-1].nd));
                    }
#line 7233 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 287:
#line 2456 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_return(p, 0);
                    }
#line 7241 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 288:
#line 2460 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_yield(p, (yyvsp[0].nd));
                    }
#line 7249 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 289:
#line 2464 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = call_uni_op(p, cond((yyvsp[-1].nd)), "!");
                    }
#line 7257 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 290:
#line 2468 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = call_uni_op(p, new_nil(p), "!");
                    }
#line 7265 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 291:
#line 2472 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_fcall(p, (yyvsp[-1].id), cons(0, (yyvsp[0].nd)));
                    }
#line 7273 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 293:
#line 2477 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      call_with_block(p, (yyvsp[-1].nd), (yyvsp[0].nd));
                      (yyval.nd) = (yyvsp[-1].nd);
                    }
#line 7282 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 294:
#line 2482 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      local_nest(p);
                      (yyval.num) = p->lpar_beg;
                      p->lpar_beg = ++p->paren_nest;
                    }
#line 7292 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 295:
#line 2488 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.stack) = p->cmdarg_stack;
                      p->cmdarg_stack = 0;
                    }
#line 7301 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 296:
#line 2493 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      p->lpar_beg = (yyvsp[-3].num);
                      (yyval.nd) = new_lambda(p, (yyvsp[-2].nd), (yyvsp[0].nd));
                      local_unnest(p);
                      p->cmdarg_stack = (yyvsp[-1].stack);
                      CMDARG_LEXPOP();
                    }
#line 7313 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 297:
#line 2504 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_if(p, cond((yyvsp[-4].nd)), (yyvsp[-2].nd), (yyvsp[-1].nd));
                      SET_LINENO((yyval.nd), (yyvsp[-5].num));
                    }
#line 7322 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 298:
#line 2512 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_unless(p, cond((yyvsp[-4].nd)), (yyvsp[-2].nd), (yyvsp[-1].nd));
                      SET_LINENO((yyval.nd), (yyvsp[-5].num));
                    }
#line 7331 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 299:
#line 2516 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {COND_PUSH(1);}
#line 7337 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 300:
#line 2516 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {COND_POP();}
#line 7343 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 301:
#line 2519 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_while(p, cond((yyvsp[-4].nd)), (yyvsp[-1].nd));
                      SET_LINENO((yyval.nd), (yyvsp[-6].num));
                    }
#line 7352 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 302:
#line 2523 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {COND_PUSH(1);}
#line 7358 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 303:
#line 2523 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {COND_POP();}
#line 7364 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 304:
#line 2526 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_until(p, cond((yyvsp[-4].nd)), (yyvsp[-1].nd));
                      SET_LINENO((yyval.nd), (yyvsp[-6].num));
                    }
#line 7373 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 305:
#line 2533 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_case(p, (yyvsp[-3].nd), (yyvsp[-1].nd));
                    }
#line 7381 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 306:
#line 2537 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_case(p, 0, (yyvsp[-1].nd));
                    }
#line 7389 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 307:
#line 2541 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {COND_PUSH(1);}
#line 7395 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 308:
#line 2543 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {COND_POP();}
#line 7401 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 309:
#line 2546 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_for(p, (yyvsp[-7].nd), (yyvsp[-4].nd), (yyvsp[-1].nd));
                      SET_LINENO((yyval.nd), (yyvsp[-8].num));
                    }
#line 7410 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 310:
#line 2552 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      if (p->in_def || p->in_single)
                        yyerror(p, "class definition in method body");
                      (yyval.nd) = local_switch(p);
                      nvars_block(p);
                    }
#line 7421 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 311:
#line 2560 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_class(p, (yyvsp[-4].nd), (yyvsp[-3].nd), (yyvsp[-1].nd));
                      SET_LINENO((yyval.nd), (yyvsp[-5].num));
                      local_resume(p, (yyvsp[-2].nd));
                      nvars_unnest(p);
                    }
#line 7432 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 312:
#line 2568 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.num) = p->in_def;
                      p->in_def = 0;
                    }
#line 7441 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 313:
#line 2573 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = cons(local_switch(p), nint(p->in_single));
                      nvars_block(p);
                      p->in_single = 0;
                    }
#line 7451 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 314:
#line 2580 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_sclass(p, (yyvsp[-5].nd), (yyvsp[-1].nd));
                      SET_LINENO((yyval.nd), (yyvsp[-7].num));
                      local_resume(p, (yyvsp[-2].nd)->car);
                      nvars_unnest(p);
                      p->in_def = (yyvsp[-4].num);
                      p->in_single = intn((yyvsp[-2].nd)->cdr);
                    }
#line 7464 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 315:
#line 2590 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      if (p->in_def || p->in_single)
                        yyerror(p, "module definition in method body");
                      (yyval.nd) = local_switch(p);
                      nvars_block(p);
                    }
#line 7475 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 316:
#line 2598 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_module(p, (yyvsp[-3].nd), (yyvsp[-1].nd));
                      SET_LINENO((yyval.nd), (yyvsp[-4].num));
                      local_resume(p, (yyvsp[-2].nd));
                      nvars_unnest(p);
                    }
#line 7486 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 317:
#line 2605 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.stack) = p->cmdarg_stack;
                      p->cmdarg_stack = 0;
                    }
#line 7495 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 318:
#line 2609 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      p->in_def++;
                      (yyval.nd) = local_switch(p);
                      nvars_block(p);
                    }
#line 7505 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 319:
#line 2617 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_def(p, (yyvsp[-5].id), (yyvsp[-2].nd), (yyvsp[-1].nd));
                      SET_LINENO((yyval.nd), (yyvsp[-6].num));
                      local_resume(p, (yyvsp[-3].nd));
                      nvars_unnest(p);
                      p->in_def--;
                      p->cmdarg_stack = (yyvsp[-4].stack);
                    }
#line 7518 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 320:
#line 2626 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      p->lstate = EXPR_FNAME;
                      (yyval.stack) = p->cmdarg_stack;
                      p->cmdarg_stack = 0;
                    }
#line 7528 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 321:
#line 2632 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      p->in_single++;
                      p->lstate = EXPR_ENDFN; /* force for args */
                      (yyval.nd) = local_switch(p);
                      nvars_block(p);
                    }
#line 7539 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 322:
#line 2641 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_sdef(p, (yyvsp[-7].nd), (yyvsp[-4].id), (yyvsp[-2].nd), (yyvsp[-1].nd));
                      SET_LINENO((yyval.nd), (yyvsp[-8].num));
                      local_resume(p, (yyvsp[-3].nd));
                      nvars_unnest(p);
                      p->in_single--;
                      p->cmdarg_stack = (yyvsp[-5].stack);
                    }
#line 7552 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 323:
#line 2650 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_break(p, 0);
                    }
#line 7560 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 324:
#line 2654 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_next(p, 0);
                    }
#line 7568 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 325:
#line 2658 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_redo(p);
                    }
#line 7576 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 326:
#line 2662 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_retry(p);
                    }
#line 7584 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 327:
#line 2668 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = (yyvsp[0].nd);
                      if (!(yyval.nd)) (yyval.nd) = new_nil(p);
                    }
#line 7593 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 334:
#line 2687 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_if(p, cond((yyvsp[-3].nd)), (yyvsp[-1].nd), (yyvsp[0].nd));
                    }
#line 7601 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 336:
#line 2694 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = (yyvsp[0].nd);
                    }
#line 7609 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 337:
#line 2700 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = list1(list1((yyvsp[0].nd)));
                    }
#line 7617 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 339:
#line 2707 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = list3((yyvsp[0].nd),0,0);
                    }
#line 7625 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 340:
#line 2711 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = list3((yyvsp[-3].nd), new_arg(p, (yyvsp[0].id)), 0);
                    }
#line 7633 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 341:
#line 2715 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = list3((yyvsp[-5].nd), new_arg(p, (yyvsp[-2].id)), (yyvsp[0].nd));
                    }
#line 7641 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 342:
#line 2719 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      local_add_f(p, 0);
                      (yyval.nd) = list3((yyvsp[-2].nd), (node*)-1, 0);
                    }
#line 7650 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 343:
#line 2724 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = list3((yyvsp[-4].nd), (node*)-1, (yyvsp[0].nd));
                    }
#line 7658 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 344:
#line 2728 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = list3(0, new_arg(p, (yyvsp[0].id)), 0);
                    }
#line 7666 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 345:
#line 2732 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = list3(0, new_arg(p, (yyvsp[-2].id)), (yyvsp[0].nd));
                    }
#line 7674 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 346:
#line 2736 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      local_add_f(p, 0);
                      (yyval.nd) = list3(0, (node*)-1, 0);
                    }
#line 7683 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 347:
#line 2741 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      local_add_f(p, 0);
                    }
#line 7691 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 348:
#line 2745 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = list3(0, (node*)-1, (yyvsp[0].nd));
                    }
#line 7699 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 349:
#line 2751 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_args_tail(p, (yyvsp[-3].nd), (yyvsp[-1].nd), (yyvsp[0].id));
                    }
#line 7707 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 350:
#line 2755 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_args_tail(p, (yyvsp[-1].nd), 0, (yyvsp[0].id));
                    }
#line 7715 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 351:
#line 2759 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_args_tail(p, 0, (yyvsp[-1].nd), (yyvsp[0].id));
                    }
#line 7723 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 352:
#line 2763 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_args_tail(p, 0, 0, (yyvsp[0].id));
                    }
#line 7731 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 353:
#line 2769 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = (yyvsp[0].nd);
                    }
#line 7739 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 354:
#line 2773 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_args_tail(p, 0, 0, 0);
                    }
#line 7747 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 355:
#line 2779 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_args(p, (yyvsp[-5].nd), (yyvsp[-3].nd), (yyvsp[-1].id), 0, (yyvsp[0].nd));
                    }
#line 7755 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 356:
#line 2783 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_args(p, (yyvsp[-7].nd), (yyvsp[-5].nd), (yyvsp[-3].id), (yyvsp[-1].nd), (yyvsp[0].nd));
                    }
#line 7763 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 357:
#line 2787 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_args(p, (yyvsp[-3].nd), (yyvsp[-1].nd), 0, 0, (yyvsp[0].nd));
                    }
#line 7771 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 358:
#line 2791 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_args(p, (yyvsp[-5].nd), (yyvsp[-3].nd), 0, (yyvsp[-1].nd), (yyvsp[0].nd));
                    }
#line 7779 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 359:
#line 2795 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_args(p, (yyvsp[-3].nd), 0, (yyvsp[-1].id), 0, (yyvsp[0].nd));
                    }
#line 7787 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 360:
#line 2799 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_args(p, (yyvsp[-2].nd), 0, 0, 0, (yyvsp[0].nd));
                    }
#line 7795 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 361:
#line 2803 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_args(p, (yyvsp[-5].nd), 0, (yyvsp[-3].id), (yyvsp[-1].nd), (yyvsp[0].nd));
                    }
#line 7803 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 362:
#line 2807 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_args(p, (yyvsp[-1].nd), 0, 0, 0, (yyvsp[0].nd));
                    }
#line 7811 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 363:
#line 2811 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_args(p, 0, (yyvsp[-3].nd), (yyvsp[-1].id), 0, (yyvsp[0].nd));
                    }
#line 7819 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 364:
#line 2815 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_args(p, 0, (yyvsp[-5].nd), (yyvsp[-3].id), (yyvsp[-1].nd), (yyvsp[0].nd));
                    }
#line 7827 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 365:
#line 2819 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_args(p, 0, (yyvsp[-1].nd), 0, 0, (yyvsp[0].nd));
                    }
#line 7835 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 366:
#line 2823 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_args(p, 0, (yyvsp[-3].nd), 0, (yyvsp[-1].nd), (yyvsp[0].nd));
                    }
#line 7843 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 367:
#line 2827 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_args(p, 0, 0, (yyvsp[-1].id), 0, (yyvsp[0].nd));
                    }
#line 7851 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 368:
#line 2831 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_args(p, 0, 0, (yyvsp[-3].id), (yyvsp[-1].nd), (yyvsp[0].nd));
                    }
#line 7859 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 369:
#line 2835 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_args(p, 0, 0, 0, 0, (yyvsp[0].nd));
                    }
#line 7867 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 370:
#line 2841 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      local_add_blk(p, 0);
                      (yyval.nd) = 0;
                    }
#line 7876 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 371:
#line 2846 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      p->cmd_start = TRUE;
                      (yyval.nd) = (yyvsp[0].nd);
                    }
#line 7885 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 372:
#line 2852 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {local_add_blk(p, 0);}
#line 7891 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 373:
#line 2853 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = 0;
                    }
#line 7899 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 374:
#line 2857 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      local_add_blk(p, 0);
                      (yyval.nd) = 0;
                    }
#line 7908 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 375:
#line 2862 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = (yyvsp[-2].nd);
                    }
#line 7916 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 376:
#line 2869 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = 0;
                    }
#line 7924 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 377:
#line 2873 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = 0;
                    }
#line 7932 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 380:
#line 2883 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      local_add_f(p, (yyvsp[0].id));
                      new_bv(p, (yyvsp[0].id));
                    }
#line 7941 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 382:
#line 2891 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = (yyvsp[-2].nd);
                    }
#line 7949 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 383:
#line 2895 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = (yyvsp[0].nd);
                    }
#line 7957 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 384:
#line 2901 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = (yyvsp[-1].nd);
                    }
#line 7965 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 385:
#line 2905 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = (yyvsp[-1].nd);
                    }
#line 7973 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 386:
#line 2911 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      local_nest(p);
                      nvars_nest(p);
                    }
#line 7982 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 387:
#line 2918 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_block(p,(yyvsp[-2].nd),(yyvsp[-1].nd));
                      local_unnest(p);
                      nvars_unnest(p);
                    }
#line 7992 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 388:
#line 2926 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      if ((yyvsp[-1].nd)->car == (node*)NODE_YIELD) {
                        yyerror(p, "block given to yield");
                      }
                      else {
                        call_with_block(p, (yyvsp[-1].nd), (yyvsp[0].nd));
                      }
                      (yyval.nd) = (yyvsp[-1].nd);
                    }
#line 8006 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 389:
#line 2936 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_call(p, (yyvsp[-3].nd), (yyvsp[-1].id), (yyvsp[0].nd), (yyvsp[-2].num));
                    }
#line 8014 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 390:
#line 2940 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_call(p, (yyvsp[-4].nd), (yyvsp[-2].id), (yyvsp[-1].nd), (yyvsp[-3].num));
                      call_with_block(p, (yyval.nd), (yyvsp[0].nd));
                    }
#line 8023 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 391:
#line 2945 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_call(p, (yyvsp[-4].nd), (yyvsp[-2].id), (yyvsp[-1].nd), (yyvsp[-3].num));
                      call_with_block(p, (yyval.nd), (yyvsp[0].nd));
                    }
#line 8032 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 392:
#line 2952 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_fcall(p, (yyvsp[-1].id), (yyvsp[0].nd));
                    }
#line 8040 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 393:
#line 2956 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_call(p, (yyvsp[-3].nd), (yyvsp[-1].id), (yyvsp[0].nd), (yyvsp[-2].num));
                    }
#line 8048 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 394:
#line 2960 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_call(p, (yyvsp[-3].nd), (yyvsp[-1].id), (yyvsp[0].nd), tCOLON2);
                    }
#line 8056 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 395:
#line 2964 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_call(p, (yyvsp[-2].nd), (yyvsp[0].id), 0, tCOLON2);
                    }
#line 8064 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 396:
#line 2968 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_call(p, (yyvsp[-2].nd), intern_lit("call"), (yyvsp[0].nd), (yyvsp[-1].num));
                    }
#line 8072 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 397:
#line 2972 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_call(p, (yyvsp[-2].nd), intern_lit("call"), (yyvsp[0].nd), tCOLON2);
                    }
#line 8080 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 398:
#line 2976 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_super(p, (yyvsp[0].nd));
                    }
#line 8088 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 399:
#line 2980 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_zsuper(p);
                    }
#line 8096 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 400:
#line 2984 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_call(p, (yyvsp[-3].nd), intern_lit("[]"), (yyvsp[-1].nd), '.');
                    }
#line 8104 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 401:
#line 2990 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      local_nest(p);
                      nvars_nest(p);
                      (yyval.num) = p->lineno;
                    }
#line 8114 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 402:
#line 2997 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_block(p,(yyvsp[-2].nd),(yyvsp[-1].nd));
                      SET_LINENO((yyval.nd), (yyvsp[-3].num));
                      local_unnest(p);
                      nvars_unnest(p);
                    }
#line 8125 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 403:
#line 3004 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      local_nest(p);
                      nvars_nest(p);
                      (yyval.num) = p->lineno;
                    }
#line 8135 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 404:
#line 3011 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_block(p,(yyvsp[-2].nd),(yyvsp[-1].nd));
                      SET_LINENO((yyval.nd), (yyvsp[-3].num));
                      local_unnest(p);
                      nvars_unnest(p);
                    }
#line 8146 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 405:
#line 3022 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = cons(cons((yyvsp[-3].nd), (yyvsp[-1].nd)), (yyvsp[0].nd));
                    }
#line 8154 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 406:
#line 3028 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      if ((yyvsp[0].nd)) {
                        (yyval.nd) = cons(cons(0, (yyvsp[0].nd)), 0);
                      }
                      else {
                        (yyval.nd) = 0;
                      }
                    }
#line 8167 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 408:
#line 3042 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = list1(list3((yyvsp[-4].nd), (yyvsp[-3].nd), (yyvsp[-1].nd)));
                      if ((yyvsp[0].nd)) (yyval.nd) = append((yyval.nd), (yyvsp[0].nd));
                    }
#line 8176 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 410:
#line 3050 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                        (yyval.nd) = list1((yyvsp[0].nd));
                    }
#line 8184 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 413:
#line 3058 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = (yyvsp[0].nd);
                    }
#line 8192 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 415:
#line 3065 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = (yyvsp[0].nd);
                    }
#line 8200 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 422:
#line 3079 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = concat_string(p, (yyvsp[-1].nd), (yyvsp[0].nd));
                    }
#line 8208 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 425:
#line 3087 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = (yyvsp[0].nd);
                    }
#line 8216 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 426:
#line 3091 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_dstr(p, push((yyvsp[-1].nd), (yyvsp[0].nd)));
                    }
#line 8224 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 428:
#line 3098 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = append((yyvsp[-1].nd), (yyvsp[0].nd));
                    }
#line 8232 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 429:
#line 3104 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = list1((yyvsp[0].nd));
                    }
#line 8240 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 430:
#line 3108 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = p->lex_strterm;
                      p->lex_strterm = NULL;
                    }
#line 8249 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 431:
#line 3114 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      p->lex_strterm = (yyvsp[-2].nd);
                      (yyval.nd) = list2((yyvsp[-3].nd), (yyvsp[-1].nd));
                    }
#line 8258 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 432:
#line 3119 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = list1(new_literal_delim(p));
                    }
#line 8266 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 433:
#line 3123 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = list1(new_literal_delim(p));
                    }
#line 8274 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 434:
#line 3129 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                        (yyval.nd) = (yyvsp[0].nd);
                    }
#line 8282 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 435:
#line 3133 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_dxstr(p, push((yyvsp[-1].nd), (yyvsp[0].nd)));
                    }
#line 8290 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 436:
#line 3139 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                        (yyval.nd) = (yyvsp[0].nd);
                    }
#line 8298 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 437:
#line 3143 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_dregx(p, (yyvsp[-1].nd), (yyvsp[0].nd));
                    }
#line 8306 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 441:
#line 3156 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      parser_heredoc_info * inf = parsing_heredoc_inf(p);
                      inf->doc = push(inf->doc, new_str(p, "", 0));
                      heredoc_end(p);
                    }
#line 8316 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 442:
#line 3162 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      heredoc_end(p);
                    }
#line 8324 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 445:
#line 3172 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      parser_heredoc_info * inf = parsing_heredoc_inf(p);
                      inf->doc = push(inf->doc, (yyvsp[0].nd));
                      heredoc_treat_nextline(p);
                    }
#line 8334 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 446:
#line 3178 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = p->lex_strterm;
                      p->lex_strterm = NULL;
                    }
#line 8343 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 447:
#line 3184 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      parser_heredoc_info * inf = parsing_heredoc_inf(p);
                      p->lex_strterm = (yyvsp[-2].nd);
                      inf->doc = push(push(inf->doc, (yyvsp[-3].nd)), (yyvsp[-1].nd));
                    }
#line 8353 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 448:
#line 3192 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_words(p, list1((yyvsp[0].nd)));
                    }
#line 8361 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 449:
#line 3196 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_words(p, push((yyvsp[-1].nd), (yyvsp[0].nd)));
                    }
#line 8369 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 450:
#line 3203 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      p->lstate = EXPR_ENDARG;
                      (yyval.nd) = new_sym(p, (yyvsp[0].id));
                    }
#line 8378 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 451:
#line 3208 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      p->lstate = EXPR_ENDARG;
                      (yyval.nd) = new_dsym(p, new_dstr(p, push((yyvsp[-1].nd), (yyvsp[0].nd))));
                    }
#line 8387 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 452:
#line 3215 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.id) = (yyvsp[0].id);
                    }
#line 8395 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 457:
#line 3225 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.id) = new_strsym(p, (yyvsp[0].nd));
                    }
#line 8403 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 458:
#line 3229 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.id) = new_strsym(p, (yyvsp[0].nd));
                    }
#line 8411 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 459:
#line 3235 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_symbols(p, list1((yyvsp[0].nd)));
                    }
#line 8419 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 460:
#line 3239 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_symbols(p, push((yyvsp[-1].nd), (yyvsp[0].nd)));
                    }
#line 8427 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 463:
#line 3247 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = negate_lit(p, (yyvsp[0].nd));
                    }
#line 8435 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 464:
#line 3251 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = negate_lit(p, (yyvsp[0].nd));
                    }
#line 8443 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 465:
#line 3257 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_lvar(p, (yyvsp[0].id));
                    }
#line 8451 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 466:
#line 3261 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_ivar(p, (yyvsp[0].id));
                    }
#line 8459 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 467:
#line 3265 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_gvar(p, (yyvsp[0].id));
                    }
#line 8467 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 468:
#line 3269 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_cvar(p, (yyvsp[0].id));
                    }
#line 8475 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 469:
#line 3273 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_const(p, (yyvsp[0].id));
                    }
#line 8483 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 470:
#line 3279 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      assignable(p, (yyvsp[0].nd));
                    }
#line 8491 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 471:
#line 3283 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      yyerror(p, "can't assign to numbered parameter");
                    }
#line 8499 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 472:
#line 3289 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = var_reference(p, (yyvsp[0].nd));
                    }
#line 8507 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 473:
#line 3293 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_nil(p);
                    }
#line 8515 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 474:
#line 3297 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_self(p);
                    }
#line 8523 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 475:
#line 3301 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_true(p);
                    }
#line 8531 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 476:
#line 3305 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_false(p);
                    }
#line 8539 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 477:
#line 3309 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      const char *fn = mrb_sym_name_len(p->mrb, p->filename_sym, NULL);
                      if (!fn) {
                        fn = "(null)";
                      }
                      (yyval.nd) = new_str(p, fn, strlen(fn));
                    }
#line 8551 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 478:
#line 3317 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      char buf[16];

                      dump_int(p->lineno, buf);
                      (yyval.nd) = new_int(p, buf, 10, 0);
                    }
#line 8562 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 479:
#line 3324 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
#ifdef MRB_UTF8_STRING
                      const char *enc = "UTF-8";
#else
                      const char *enc = "ASCII-8BIT";
#endif
                      (yyval.nd) = new_str(p, enc, strlen(enc));
                    }
#line 8575 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 482:
#line 3339 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = 0;
                    }
#line 8583 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 483:
#line 3343 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      p->lstate = EXPR_BEG;
                      p->cmd_start = TRUE;
                    }
#line 8592 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 484:
#line 3348 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = (yyvsp[-1].nd);
                    }
#line 8600 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 485:
#line 3359 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = (yyvsp[-1].nd);
                      p->lstate = EXPR_BEG;
                      p->cmd_start = TRUE;
                    }
#line 8610 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 486:
#line 3365 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = (yyvsp[-1].nd);
                    }
#line 8618 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 487:
#line 3371 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      local_nest(p);
                    }
#line 8626 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 488:
#line 3377 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      void_expr_error(p, (yyvsp[0].nd));
                      (yyval.nd) = new_kw_arg(p, (yyvsp[-1].id), cons((yyvsp[0].nd), locals_node(p)));
                      local_unnest(p);
                    }
#line 8636 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 489:
#line 3383 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_kw_arg(p, (yyvsp[0].id), 0);
                      local_unnest(p);
                    }
#line 8645 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 490:
#line 3390 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_kw_arg(p, (yyvsp[-1].id), cons((yyvsp[0].nd), locals_node(p)));
                      local_unnest(p);
                    }
#line 8654 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 491:
#line 3395 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_kw_arg(p, (yyvsp[0].id), 0);
                      local_unnest(p);
                    }
#line 8663 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 492:
#line 3402 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = list1((yyvsp[0].nd));
                    }
#line 8671 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 493:
#line 3406 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = push((yyvsp[-2].nd), (yyvsp[0].nd));
                    }
#line 8679 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 494:
#line 3412 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = list1((yyvsp[0].nd));
                    }
#line 8687 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 495:
#line 3416 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = push((yyvsp[-2].nd), (yyvsp[0].nd));
                    }
#line 8695 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 498:
#line 3426 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = cons((node*)NODE_KW_REST_ARGS, nsym((yyvsp[0].id)));
                    }
#line 8703 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 499:
#line 3430 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = cons((node*)NODE_KW_REST_ARGS, 0);
                    }
#line 8711 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 500:
#line 3436 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_args_tail(p, (yyvsp[-3].nd), (yyvsp[-1].nd), (yyvsp[0].id));
                    }
#line 8719 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 501:
#line 3440 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_args_tail(p, (yyvsp[-1].nd), 0, (yyvsp[0].id));
                    }
#line 8727 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 502:
#line 3444 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_args_tail(p, 0, (yyvsp[-1].nd), (yyvsp[0].id));
                    }
#line 8735 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 503:
#line 3448 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_args_tail(p, 0, 0, (yyvsp[0].id));
                    }
#line 8743 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 504:
#line 3454 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = (yyvsp[0].nd);
                    }
#line 8751 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 505:
#line 3458 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_args_tail(p, 0, 0, 0);
                    }
#line 8759 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 506:
#line 3464 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_args(p, (yyvsp[-5].nd), (yyvsp[-3].nd), (yyvsp[-1].id), 0, (yyvsp[0].nd));
                    }
#line 8767 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 507:
#line 3468 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_args(p, (yyvsp[-7].nd), (yyvsp[-5].nd), (yyvsp[-3].id), (yyvsp[-1].nd), (yyvsp[0].nd));
                    }
#line 8775 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 508:
#line 3472 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_args(p, (yyvsp[-3].nd), (yyvsp[-1].nd), 0, 0, (yyvsp[0].nd));
                    }
#line 8783 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 509:
#line 3476 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_args(p, (yyvsp[-5].nd), (yyvsp[-3].nd), 0, (yyvsp[-1].nd), (yyvsp[0].nd));
                    }
#line 8791 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 510:
#line 3480 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_args(p, (yyvsp[-3].nd), 0, (yyvsp[-1].id), 0, (yyvsp[0].nd));
                    }
#line 8799 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 511:
#line 3484 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_args(p, (yyvsp[-5].nd), 0, (yyvsp[-3].id), (yyvsp[-1].nd), (yyvsp[0].nd));
                    }
#line 8807 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 512:
#line 3488 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_args(p, (yyvsp[-1].nd), 0, 0, 0, (yyvsp[0].nd));
                    }
#line 8815 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 513:
#line 3492 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_args(p, 0, (yyvsp[-3].nd), (yyvsp[-1].id), 0, (yyvsp[0].nd));
                    }
#line 8823 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 514:
#line 3496 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_args(p, 0, (yyvsp[-5].nd), (yyvsp[-3].id), (yyvsp[-1].nd), (yyvsp[0].nd));
                    }
#line 8831 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 515:
#line 3500 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_args(p, 0, (yyvsp[-1].nd), 0, 0, (yyvsp[0].nd));
                    }
#line 8839 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 516:
#line 3504 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_args(p, 0, (yyvsp[-3].nd), 0, (yyvsp[-1].nd), (yyvsp[0].nd));
                    }
#line 8847 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 517:
#line 3508 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_args(p, 0, 0, (yyvsp[-1].id), 0, (yyvsp[0].nd));
                    }
#line 8855 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 518:
#line 3512 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_args(p, 0, 0, (yyvsp[-3].id), (yyvsp[-1].nd), (yyvsp[0].nd));
                    }
#line 8863 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 519:
#line 3516 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_args(p, 0, 0, 0, 0, (yyvsp[0].nd));
                    }
#line 8871 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 520:
#line 3520 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      local_add_f(p, mrb_intern_lit(p->mrb, "&"));
                      (yyval.nd) = new_args(p, 0, 0, 0, 0, 0);
                    }
#line 8880 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 521:
#line 3527 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      yyerror(p, "formal argument cannot be a constant");
                      (yyval.nd) = 0;
                    }
#line 8889 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 522:
#line 3532 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      yyerror(p, "formal argument cannot be an instance variable");
                      (yyval.nd) = 0;
                    }
#line 8898 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 523:
#line 3537 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      yyerror(p, "formal argument cannot be a global variable");
                      (yyval.nd) = 0;
                    }
#line 8907 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 524:
#line 3542 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      yyerror(p, "formal argument cannot be a class variable");
                      (yyval.nd) = 0;
                    }
#line 8916 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 525:
#line 3547 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      yyerror(p, "formal argument cannot be a numbered parameter");
                      (yyval.nd) = 0;
                    }
#line 8925 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 526:
#line 3554 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.id) = 0;
                    }
#line 8933 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 527:
#line 3558 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      local_add_f(p, (yyvsp[0].id));
                      (yyval.id) = (yyvsp[0].id);
                    }
#line 8942 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 528:
#line 3565 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_arg(p, (yyvsp[0].id));
                    }
#line 8950 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 529:
#line 3569 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = local_switch(p);
                    }
#line 8958 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 530:
#line 3573 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = new_masgn_param(p, (yyvsp[-1].nd), p->locals->car);
                      local_resume(p, (yyvsp[-2].nd));
                      local_add_f(p, 0);
                    }
#line 8968 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 531:
#line 3581 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = list1((yyvsp[0].nd));
                    }
#line 8976 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 532:
#line 3585 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = push((yyvsp[-2].nd), (yyvsp[0].nd));
                    }
#line 8984 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 533:
#line 3591 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      local_add_f(p, (yyvsp[-1].id));
                      local_nest(p);
                      (yyval.id) = (yyvsp[-1].id);
                    }
#line 8994 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 534:
#line 3599 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      void_expr_error(p, (yyvsp[0].nd));
                      (yyval.nd) = cons(nsym((yyvsp[-1].id)), cons((yyvsp[0].nd), locals_node(p)));
                      local_unnest(p);
                    }
#line 9004 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 535:
#line 3607 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      void_expr_error(p, (yyvsp[0].nd));
                      (yyval.nd) = cons(nsym((yyvsp[-1].id)), cons((yyvsp[0].nd), locals_node(p)));
                      local_unnest(p);
                    }
#line 9014 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 536:
#line 3615 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = list1((yyvsp[0].nd));
                    }
#line 9022 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 537:
#line 3619 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = push((yyvsp[-2].nd), (yyvsp[0].nd));
                    }
#line 9030 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 538:
#line 3625 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = list1((yyvsp[0].nd));
                    }
#line 9038 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 539:
#line 3629 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = push((yyvsp[-2].nd), (yyvsp[0].nd));
                    }
#line 9046 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 542:
#line 3639 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      local_add_f(p, (yyvsp[0].id));
                      (yyval.id) = (yyvsp[0].id);
                    }
#line 9055 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 543:
#line 3644 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      local_add_f(p, mrb_intern_lit(p->mrb, "*"));
                      (yyval.id) = -1;
                    }
#line 9064 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 546:
#line 3655 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.id) = (yyvsp[0].id);
                    }
#line 9072 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 547:
#line 3661 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.id) = (yyvsp[0].id);
                    }
#line 9080 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 548:
#line 3665 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.id) = 0;
                    }
#line 9088 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 549:
#line 3671 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = (yyvsp[0].nd);
                      if (!(yyval.nd)) (yyval.nd) = new_nil(p);
                    }
#line 9097 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 550:
#line 3675 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {p->lstate = EXPR_BEG;}
#line 9103 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 551:
#line 3676 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      if ((yyvsp[-1].nd) == 0) {
                        yyerror(p, "can't define singleton method for ().");
                      }
                      else {
                        switch ((enum node_type)intn((yyvsp[-1].nd)->car)) {
                        case NODE_STR:
                        case NODE_DSTR:
                        case NODE_XSTR:
                        case NODE_DXSTR:
                        case NODE_DREGX:
                        case NODE_MATCH:
                        case NODE_FLOAT:
                        case NODE_ARRAY:
                        case NODE_HEREDOC:
                          yyerror(p, "can't define singleton method for literals");
                        default:
                          break;
                        }
                      }
                      (yyval.nd) = (yyvsp[-1].nd);
                    }
#line 9130 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 553:
#line 3702 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = (yyvsp[-1].nd);
                    }
#line 9138 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 554:
#line 3708 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = list1((yyvsp[0].nd));
                      NODE_LINENO((yyval.nd), (yyvsp[0].nd));
                    }
#line 9147 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 555:
#line 3713 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = push((yyvsp[-2].nd), (yyvsp[0].nd));
                    }
#line 9155 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 558:
#line 3723 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      void_expr_error(p, (yyvsp[-2].nd));
                      void_expr_error(p, (yyvsp[0].nd));
                      (yyval.nd) = cons((yyvsp[-2].nd), (yyvsp[0].nd));
                    }
#line 9165 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 559:
#line 3729 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      void_expr_error(p, (yyvsp[0].nd));
                      (yyval.nd) = cons(new_sym(p, (yyvsp[-2].id)), (yyvsp[0].nd));
                    }
#line 9174 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 560:
#line 3734 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      void_expr_error(p, (yyvsp[0].nd));
                      if ((yyvsp[-2].nd)->car == (node*)NODE_DSTR) {
                        (yyval.nd) = cons(new_dsym(p, (yyvsp[-2].nd)), (yyvsp[0].nd));
                      }
                      else {
                        (yyval.nd) = cons(new_sym(p, new_strsym(p, (yyvsp[-2].nd))), (yyvsp[0].nd));
                      }
                    }
#line 9188 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 561:
#line 3744 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      void_expr_error(p, (yyvsp[0].nd));
                      (yyval.nd) = cons(cons((node*)NODE_KW_REST_ARGS, 0), (yyvsp[0].nd));
                    }
#line 9197 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 574:
#line 3771 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.num) = '.';
                    }
#line 9205 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 575:
#line 3775 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.num) = 0;
                    }
#line 9213 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 577:
#line 3782 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.num) = tCOLON2;
                    }
#line 9221 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 586:
#line 3803 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {yyerrok;}
#line 9227 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 589:
#line 3809 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      p->lineno++;
                      p->column = 0;
                    }
#line 9236 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;

  case 592:
#line 3820 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1652  */
    {
                      (yyval.nd) = 0;
                    }
#line 9244 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
    break;


#line 9248 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-build/host/mrbgems/mruby-compiler/core/y.tab.c" /* yacc.c:1652  */
      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYEMPTY : YYTRANSLATE (yychar);

  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (p, YY_("syntax error"));
#else
# define YYSYNTAX_ERROR yysyntax_error (&yymsg_alloc, &yymsg, \
                                        yyssp, yytoken)
      {
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = YYSYNTAX_ERROR;
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == 1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = (char *) YYSTACK_ALLOC (yymsg_alloc);
            if (!yymsg)
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = 2;
              }
            else
              {
                yysyntax_error_status = YYSYNTAX_ERROR;
                yymsgp = yymsg;
              }
          }
        yyerror (p, yymsgp);
        if (yysyntax_error_status == 2)
          goto yyexhaustedlab;
      }
# undef YYSYNTAX_ERROR
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, p);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYTERROR;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  yystos[yystate], yyvsp, p);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;


#if !defined yyoverflow || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (p, YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif


/*-----------------------------------------------------.
| yyreturn -- parsing is finished, return the result.  |
`-----------------------------------------------------*/
yyreturn:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, p);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  yystos[*yyssp], yyvsp, p);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  return yyresult;
}
#line 3824 "/home/horimoto/Work/free-software/groonga.clean/vendor/mruby-source/mrbgems/mruby-compiler/core/parse.y" /* yacc.c:1918  */

#define pylval  (*((YYSTYPE*)(p->ylval)))

static void
yyerror(parser_state *p, const char *s)
{
  char* c;
  size_t n;

  if (! p->capture_errors) {
#ifndef MRB_DISABLE_STDIO
    if (p->filename_sym) {
      const char *filename = mrb_sym_name_len(p->mrb, p->filename_sym, NULL);
      fprintf(stderr, "%s:%d:%d: %s\n", filename, p->lineno, p->column, s);
    }
    else {
      fprintf(stderr, "line %d:%d: %s\n", p->lineno, p->column, s);
    }
#endif
  }
  else if (p->nerr < sizeof(p->error_buffer) / sizeof(p->error_buffer[0])) {
    n = strlen(s);
    c = (char *)parser_palloc(p, n + 1);
    memcpy(c, s, n + 1);
    p->error_buffer[p->nerr].message = c;
    p->error_buffer[p->nerr].lineno = p->lineno;
    p->error_buffer[p->nerr].column = p->column;
  }
  p->nerr++;
}

static void
yyerror_c(parser_state *p, const char *msg, char c)
{
  char buf[256];

  strncpy(buf, msg, sizeof(buf) - 2);
  buf[sizeof(buf) - 2] = '\0';
  strncat(buf, &c, 1);
  yyerror(p, buf);
}

static void
yywarn(parser_state *p, const char *s)
{
  char* c;
  size_t n;

  if (! p->capture_errors) {
#ifndef MRB_DISABLE_STDIO
    if (p->filename_sym) {
      const char *filename = mrb_sym_name_len(p->mrb, p->filename_sym, NULL);
      fprintf(stderr, "%s:%d:%d: warning: %s\n", filename, p->lineno, p->column, s);
    }
    else {
      fprintf(stderr, "line %d:%d: warning: %s\n", p->lineno, p->column, s);
    }
#endif
  }
  else if (p->nwarn < sizeof(p->warn_buffer) / sizeof(p->warn_buffer[0])) {
    n = strlen(s);
    c = (char *)parser_palloc(p, n + 1);
    memcpy(c, s, n + 1);
    p->warn_buffer[p->nwarn].message = c;
    p->warn_buffer[p->nwarn].lineno = p->lineno;
    p->warn_buffer[p->nwarn].column = p->column;
  }
  p->nwarn++;
}

static void
yywarning(parser_state *p, const char *s)
{
  yywarn(p, s);
}

static void
yywarning_s(parser_state *p, const char *msg, const char *s)
{
  char buf[256];

  strncpy(buf, msg, sizeof(buf) - 1);
  buf[sizeof(buf) - 1] = '\0';
  strncat(buf, ": ", sizeof(buf) - strlen(buf) - 1);
  strncat(buf, s, sizeof(buf) - strlen(buf) - 1);
  yywarning(p, buf);
}

static void
backref_error(parser_state *p, node *n)
{
  int c;

  c = intn(n->car);

  if (c == NODE_NTH_REF) {
    yyerror_c(p, "can't set variable $", (char)intn(n->cdr)+'0');
  }
  else if (c == NODE_BACK_REF) {
    yyerror_c(p, "can't set variable $", (char)intn(n->cdr));
  }
  else {
    mrb_bug(p->mrb, "Internal error in backref_error() : n=>car == %d", c);
  }
}

static void
void_expr_error(parser_state *p, node *n)
{
  int c;

  if (n == NULL) return;
  c = intn(n->car);
  switch (c) {
  case NODE_BREAK:
  case NODE_RETURN:
  case NODE_NEXT:
  case NODE_REDO:
  case NODE_RETRY:
    yyerror(p, "void value expression");
    break;
  case NODE_AND:
  case NODE_OR:
    if (n->cdr) {
      void_expr_error(p, n->cdr->car);
      void_expr_error(p, n->cdr->cdr);
    }
    break;
  case NODE_BEGIN:
    if (n->cdr) {
      while (n->cdr) {
        n = n->cdr;
      }
      void_expr_error(p, n->car);
    }
    break;
  default:
    break;
  }
}

static void pushback(parser_state *p, int c);
static mrb_bool peeks(parser_state *p, const char *s);
static mrb_bool skips(parser_state *p, const char *s);

static inline int
nextc(parser_state *p)
{
  int c;

  if (p->pb) {
    node *tmp;

    c = intn(p->pb->car);
    tmp = p->pb;
    p->pb = p->pb->cdr;
    cons_free(tmp);
  }
  else {
#ifndef MRB_DISABLE_STDIO
    if (p->f) {
      if (feof(p->f)) goto eof;
      c = fgetc(p->f);
      if (c == EOF) goto eof;
    }
    else
#endif
      if (!p->s || p->s >= p->send) {
        goto eof;
      }
      else {
        c = (unsigned char)*p->s++;
      }
  }
  if (c >= 0) {
    p->column++;
  }
  if (c == '\r') {
    const int lf = nextc(p);
    if (lf == '\n') {
      return '\n';
    }
    pushback(p, lf);
  }
  return c;

  eof:
  if (!p->cxt) return -1;
  else {
    if (p->cxt->partial_hook(p) < 0)
      return -1;                /* end of program(s) */
    return -2;                  /* end of a file in the program files */
  }
}

static void
pushback(parser_state *p, int c)
{
  if (c >= 0) {
    p->column--;
  }
  p->pb = cons(nint(c), p->pb);
}

static void
skip(parser_state *p, char term)
{
  int c;

  for (;;) {
    c = nextc(p);
    if (c < 0) break;
    if (c == term) break;
  }
}

static int
peekc_n(parser_state *p, int n)
{
  node *list = 0;
  int c0;

  do {
    c0 = nextc(p);
    if (c0 == -1) return c0;    /* do not skip partial EOF */
    if (c0 >= 0) --p->column;
    list = push(list, nint(c0));
  } while(n--);
  if (p->pb) {
    p->pb = append((node*)list, p->pb);
  }
  else {
    p->pb = list;
  }
  return c0;
}

static mrb_bool
peek_n(parser_state *p, int c, int n)
{
  return peekc_n(p, n) == c && c >= 0;
}
#define peek(p,c) peek_n((p), (c), 0)

static mrb_bool
peeks(parser_state *p, const char *s)
{
  size_t len = strlen(s);

#ifndef MRB_DISABLE_STDIO
  if (p->f) {
    int n = 0;
    while (*s) {
      if (!peek_n(p, *s++, n++)) return FALSE;
    }
    return TRUE;
  }
  else
#endif
    if (p->s && p->s + len <= p->send) {
      if (memcmp(p->s, s, len) == 0) return TRUE;
    }
  return FALSE;
}

static mrb_bool
skips(parser_state *p, const char *s)
{
  int c;

  for (;;) {
    /* skip until first char */
    for (;;) {
      c = nextc(p);
      if (c < 0) return FALSE;
      if (c == '\n') {
        p->lineno++;
        p->column = 0;
      }
      if (c == *s) break;
    }
    s++;
    if (peeks(p, s)) {
      size_t len = strlen(s);

      while (len--) {
        if (nextc(p) == '\n') {
          p->lineno++;
          p->column = 0;
        }
      }
      return TRUE;
    }
    else{
      s--;
    }
  }
  return FALSE;
}


static int
newtok(parser_state *p)
{
  if (p->tokbuf != p->buf) {
    mrb_free(p->mrb, p->tokbuf);
    p->tokbuf = p->buf;
    p->tsiz = MRB_PARSER_TOKBUF_SIZE;
  }
  p->tidx = 0;
  return p->column - 1;
}

static void
tokadd(parser_state *p, int32_t c)
{
  char utf8[4];
  int i, len;

  /* mrb_assert(-0x10FFFF <= c && c <= 0xFF); */
  if (c >= 0) {
    /* Single byte from source or non-Unicode escape */
    utf8[0] = (char)c;
    len = 1;
  }
  else {
    /* Unicode character */
    c = -c;
    if (c < 0x80) {
      utf8[0] = (char)c;
      len = 1;
    }
    else if (c < 0x800) {
      utf8[0] = (char)(0xC0 | (c >> 6));
      utf8[1] = (char)(0x80 | (c & 0x3F));
      len = 2;
    }
    else if (c < 0x10000) {
      utf8[0] = (char)(0xE0 |  (c >> 12)        );
      utf8[1] = (char)(0x80 | ((c >>  6) & 0x3F));
      utf8[2] = (char)(0x80 | ( c        & 0x3F));
      len = 3;
    }
    else {
      utf8[0] = (char)(0xF0 |  (c >> 18)        );
      utf8[1] = (char)(0x80 | ((c >> 12) & 0x3F));
      utf8[2] = (char)(0x80 | ((c >>  6) & 0x3F));
      utf8[3] = (char)(0x80 | ( c        & 0x3F));
      len = 4;
    }
  }
  if (p->tidx+len >= p->tsiz) {
    if (p->tsiz >= MRB_PARSER_TOKBUF_MAX) {
      p->tidx += len;
      return;
    }
    p->tsiz *= 2;
    if (p->tokbuf == p->buf) {
      p->tokbuf = (char*)mrb_malloc(p->mrb, p->tsiz);
      memcpy(p->tokbuf, p->buf, MRB_PARSER_TOKBUF_SIZE);
    }
    else {
      p->tokbuf = (char*)mrb_realloc(p->mrb, p->tokbuf, p->tsiz);
    }
  }
  for (i = 0; i < len; i++) {
    p->tokbuf[p->tidx++] = utf8[i];
  }
}

static int
toklast(parser_state *p)
{
  return p->tokbuf[p->tidx-1];
}

static void
tokfix(parser_state *p)
{
  if (p->tidx >= MRB_PARSER_TOKBUF_MAX) {
    p->tidx = MRB_PARSER_TOKBUF_MAX-1;
    yyerror(p, "string too long (truncated)");
  }
  p->tokbuf[p->tidx] = '\0';
}

static const char*
tok(parser_state *p)
{
  return p->tokbuf;
}

static int
toklen(parser_state *p)
{
  return p->tidx;
}

#define IS_ARG() (p->lstate == EXPR_ARG || p->lstate == EXPR_CMDARG)
#define IS_END() (p->lstate == EXPR_END || p->lstate == EXPR_ENDARG || p->lstate == EXPR_ENDFN)
#define IS_BEG() (p->lstate == EXPR_BEG || p->lstate == EXPR_MID || p->lstate == EXPR_VALUE || p->lstate == EXPR_CLASS)
#define IS_SPCARG(c) (IS_ARG() && space_seen && !ISSPACE(c))
#define IS_LABEL_POSSIBLE() ((p->lstate == EXPR_BEG && !cmd_state) || IS_ARG())
#define IS_LABEL_SUFFIX(n) (peek_n(p, ':',(n)) && !peek_n(p, ':', (n)+1))

static int32_t
scan_oct(const int *start, int len, int *retlen)
{
  const int *s = start;
  int32_t retval = 0;

  /* mrb_assert(len <= 3) */
  while (len-- && *s >= '0' && *s <= '7') {
    retval <<= 3;
    retval |= *s++ - '0';
  }
  *retlen = (int)(s - start);

  return retval;
}

static int32_t
scan_hex(parser_state *p, const int *start, int len, int *retlen)
{
  static const char hexdigit[] = "0123456789abcdef0123456789ABCDEF";
  const int *s = start;
  uint32_t retval = 0;
  char *tmp;

  /* mrb_assert(len <= 8) */
  while (len-- && *s && (tmp = (char*)strchr(hexdigit, *s))) {
    retval <<= 4;
    retval |= (tmp - hexdigit) & 15;
    s++;
  }
  *retlen = (int)(s - start);

  return (int32_t)retval;
}

static int32_t
read_escape_unicode(parser_state *p, int limit)
{
  int buf[9];
  int i;
  int32_t hex;

  /* Look for opening brace */
  i = 0;
  buf[0] = nextc(p);
  if (buf[0] < 0) {
  eof:
    yyerror(p, "invalid escape character syntax");
    return -1;
  }
  if (ISXDIGIT(buf[0])) {
    /* \uxxxx form */
    for (i=1; i<limit; i++) {
      buf[i] = nextc(p);
      if (buf[i] < 0) goto eof;
      if (!ISXDIGIT(buf[i])) {
        pushback(p, buf[i]);
        break;
      }
    }
  }
  else {
    pushback(p, buf[0]);
  }
  hex = scan_hex(p, buf, i, &i);
  if (i == 0 || hex > 0x10FFFF || (hex & 0xFFFFF800) == 0xD800) {
    yyerror(p, "invalid Unicode code point");
    return -1;
  }
  return hex;
}

/* Return negative to indicate Unicode code point */
static int32_t
read_escape(parser_state *p)
{
  int32_t c;

  switch (c = nextc(p)) {
  case '\\':/* Backslash */
    return c;

  case 'n':/* newline */
    return '\n';

  case 't':/* horizontal tab */
    return '\t';

  case 'r':/* carriage-return */
    return '\r';

  case 'f':/* form-feed */
    return '\f';

  case 'v':/* vertical tab */
    return '\13';

  case 'a':/* alarm(bell) */
    return '\007';

  case 'e':/* escape */
    return 033;

  case '0': case '1': case '2': case '3': /* octal constant */
  case '4': case '5': case '6': case '7':
  {
    int buf[3];
    int i;

    buf[0] = c;
    for (i=1; i<3; i++) {
      buf[i] = nextc(p);
      if (buf[i] < 0) goto eof;
      if (buf[i] < '0' || '7' < buf[i]) {
        pushback(p, buf[i]);
        break;
      }
    }
    c = scan_oct(buf, i, &i);
  }
  return c;

  case 'x':     /* hex constant */
  {
    int buf[2];
    int i;

    for (i=0; i<2; i++) {
      buf[i] = nextc(p);
      if (buf[i] < 0) goto eof;
      if (!ISXDIGIT(buf[i])) {
        pushback(p, buf[i]);
        break;
      }
    }
    if (i == 0) {
      yyerror(p, "invalid hex escape");
      return -1;
    }
    return scan_hex(p, buf, i, &i);
  }

  case 'u':     /* Unicode */
    if (peek(p, '{')) {
      /* \u{xxxxxxxx} form */
      nextc(p);
      c = read_escape_unicode(p, 8);
      if (c < 0) return 0;
      if (nextc(p) != '}') goto eof;
    }
    else {
      c = read_escape_unicode(p, 4);
      if (c < 0) return 0;
    }
  return -c;

  case 'b':/* backspace */
    return '\010';

  case 's':/* space */
    return ' ';

  case 'M':
    if ((c = nextc(p)) != '-') {
      yyerror(p, "Invalid escape character syntax");
      pushback(p, c);
      return '\0';
    }
    if ((c = nextc(p)) == '\\') {
      return read_escape(p) | 0x80;
    }
    else if (c < 0) goto eof;
    else {
      return ((c & 0xff) | 0x80);
    }

  case 'C':
    if ((c = nextc(p)) != '-') {
      yyerror(p, "Invalid escape character syntax");
      pushback(p, c);
      return '\0';
    }
  case 'c':
    if ((c = nextc(p))== '\\') {
      c = read_escape(p);
    }
    else if (c == '?')
      return 0177;
    else if (c < 0) goto eof;
    return c & 0x9f;

    eof:
  case -1:
  case -2:                      /* end of a file */
    yyerror(p, "Invalid escape character syntax");
    return '\0';

  default:
    return c;
  }
}

static int
parse_string(parser_state *p)
{
  int c;
  string_type type = (string_type)(intptr_t)p->lex_strterm->car;
  int nest_level = intn(p->lex_strterm->cdr->car);
  int beg = intn(p->lex_strterm->cdr->cdr->car);
  int end = intn(p->lex_strterm->cdr->cdr->cdr);
  parser_heredoc_info *hinf = (type & STR_FUNC_HEREDOC) ? parsing_heredoc_inf(p) : NULL;

  if (beg == 0) beg = -3;       /* should never happen */
  if (end == 0) end = -3;
  newtok(p);
  while ((c = nextc(p)) != end || nest_level != 0) {
    if (hinf && (c == '\n' || c < 0)) {
      mrb_bool line_head;
      tokadd(p, '\n');
      tokfix(p);
      p->lineno++;
      p->column = 0;
      line_head = hinf->line_head;
      hinf->line_head = TRUE;
      if (line_head) {
        /* check whether end of heredoc */
        const char *s = tok(p);
        int len = toklen(p);
        if (hinf->allow_indent) {
          while (ISSPACE(*s) && len > 0) {
            ++s;
            --len;
          }
        }
        if ((len-1 == hinf->term_len) && (strncmp(s, hinf->term, len-1) == 0)) {
          return tHEREDOC_END;
        }
      }
      if (c < 0) {
        char buf[256];
        const char s1[] = "can't find heredoc delimiter \"";
        const char s2[] = "\" anywhere before EOF";

        if (sizeof(s1)+sizeof(s2)+strlen(hinf->term)+1 >= sizeof(buf)) {
          yyerror(p, "can't find heredoc delimiter anywhere before EOF");
        } else {
          strcpy(buf, s1);
          strcat(buf, hinf->term);
          strcat(buf, s2);
          yyerror(p, buf);
        }
        return 0;
      }
      pylval.nd = new_str(p, tok(p), toklen(p));
      return tHD_STRING_MID;
    }
    if (c < 0) {
      yyerror(p, "unterminated string meets end of file");
      return 0;
    }
    else if (c == beg) {
      nest_level++;
      p->lex_strterm->cdr->car = nint(nest_level);
    }
    else if (c == end) {
      nest_level--;
      p->lex_strterm->cdr->car = nint(nest_level);
    }
    else if (c == '\\') {
      c = nextc(p);
      if (type & STR_FUNC_EXPAND) {
        if (c == end || c == beg) {
          tokadd(p, c);
        }
        else if (c == '\n') {
          p->lineno++;
          p->column = 0;
          if (type & STR_FUNC_ARRAY) {
            tokadd(p, '\n');
          }
        }
        else if (type & STR_FUNC_REGEXP) {
          tokadd(p, '\\');
          tokadd(p, c);
        }
        else if (c == 'u' && peek(p, '{')) {
          /* \u{xxxx xxxx xxxx} form */
          nextc(p);
          while (1) {
            do c = nextc(p); while (ISSPACE(c));
            if (c == '}') break;
            pushback(p, c);
            c = read_escape_unicode(p, 8);
            if (c < 0) break;
            tokadd(p, -c);
          }
          if (hinf)
            hinf->line_head = FALSE;
        }
        else {
          pushback(p, c);
          tokadd(p, read_escape(p));
          if (hinf)
            hinf->line_head = FALSE;
        }
      }
      else {
        if (c != beg && c != end) {
          if (c == '\n') {
            p->lineno++;
            p->column = 0;
          }
          if (!(c == '\\' || ((type & STR_FUNC_ARRAY) && ISSPACE(c)))) {
            tokadd(p, '\\');
          }
        }
        tokadd(p, c);
      }
      continue;
    }
    else if ((c == '#') && (type & STR_FUNC_EXPAND)) {
      c = nextc(p);
      if (c == '{') {
        tokfix(p);
        p->lstate = EXPR_BEG;
        p->cmd_start = TRUE;
        pylval.nd = new_str(p, tok(p), toklen(p));
        if (hinf) {
          hinf->line_head = FALSE;
          return tHD_STRING_PART;
        }
        return tSTRING_PART;
      }
      tokadd(p, '#');
      pushback(p, c);
      continue;
    }
    if ((type & STR_FUNC_ARRAY) && ISSPACE(c)) {
      if (toklen(p) == 0) {
        do {
          if (c == '\n') {
            p->lineno++;
            p->column = 0;
            heredoc_treat_nextline(p);
            if (p->parsing_heredoc != NULL) {
              return tHD_LITERAL_DELIM;
            }
          }
          c = nextc(p);
        } while (ISSPACE(c));
        pushback(p, c);
        return tLITERAL_DELIM;
      }
      else {
        pushback(p, c);
        tokfix(p);
        pylval.nd = new_str(p, tok(p), toklen(p));
        return tSTRING_MID;
      }
    }
    if (c == '\n') {
      p->lineno++;
      p->column = 0;
    }
    tokadd(p, c);
  }

  tokfix(p);
  p->lstate = EXPR_ENDARG;
  end_strterm(p);

  if (type & STR_FUNC_XQUOTE) {
    pylval.nd = new_xstr(p, tok(p), toklen(p));
    return tXSTRING;
  }

  if (type & STR_FUNC_REGEXP) {
    int f = 0;
    int re_opt;
    char *s = strndup(tok(p), toklen(p));
    char flags[3];
    char *flag = flags;
    char enc = '\0';
    char *encp;
    char *dup;

    newtok(p);
    while (re_opt = nextc(p), re_opt >= 0 && ISALPHA(re_opt)) {
      switch (re_opt) {
      case 'i': f |= 1; break;
      case 'x': f |= 2; break;
      case 'm': f |= 4; break;
      case 'u': f |= 16; break;
      case 'n': f |= 32; break;
      case 'o': break;
      default: tokadd(p, re_opt); break;
      }
    }
    pushback(p, re_opt);
    if (toklen(p)) {
      char msg[128];

      strcpy(msg, "unknown regexp option");
      tokfix(p);
      if (toklen(p) > 1) {
        strcat(msg, "s");
      }
      strcat(msg, " - ");
      strncat(msg, tok(p), sizeof(msg) - strlen(msg) - 1);
      yyerror(p, msg);
    }
    if (f != 0) {
      if (f & 1) *flag++ = 'i';
      if (f & 2) *flag++ = 'x';
      if (f & 4) *flag++ = 'm';
      if (f & 16) enc = 'u';
      if (f & 32) enc = 'n';
    }
    if (flag > flags) {
      dup = strndup(flags, (size_t)(flag - flags));
    }
    else {
      dup = NULL;
    }
    if (enc) {
      encp = strndup(&enc, 1);
    }
    else {
      encp = NULL;
    }
    pylval.nd = new_regx(p, s, dup, encp);

    return tREGEXP;
  }
  pylval.nd = new_str(p, tok(p), toklen(p));

  return tSTRING;
}

static int
number_literal_suffix(parser_state *p)
{
  int c, result = 0;
  node *list = 0;
  int column = p->column;
  int mask = NUM_SUFFIX_R|NUM_SUFFIX_I;

  while ((c = nextc(p)) != -1) {
    list = push(list, (node*)(intptr_t)c);

    if ((mask & NUM_SUFFIX_I) && c == 'i') {
      result |= (mask & NUM_SUFFIX_I);
      mask &= ~NUM_SUFFIX_I;
      /* r after i, rational of complex is disallowed */
      mask &= ~NUM_SUFFIX_R;
      continue;
    }
    if ((mask & NUM_SUFFIX_R) && c == 'r') {
      result |= (mask & NUM_SUFFIX_R);
      mask &= ~NUM_SUFFIX_R;
      continue;
    }
    if (!ISASCII(c) || ISALPHA(c) || c == '_') {
      p->column = column;
      if (p->pb) {
        p->pb = append((node*)list, p->pb);
      }
      else {
        p->pb = list;
      }
      return 0;
    }
    pushback(p, c);
    break;
  }
  return result;
}

static int
heredoc_identifier(parser_state *p)
{
  int c;
  int type = str_heredoc;
  mrb_bool indent = FALSE;
  mrb_bool quote = FALSE;
  node *newnode;
  parser_heredoc_info *info;

  c = nextc(p);
  if (ISSPACE(c) || c == '=') {
    pushback(p, c);
    return 0;
  }
  if (c == '-') {
    indent = TRUE;
    c = nextc(p);
  }
  if (c == '\'' || c == '"') {
    int term = c;
    if (c == '\'')
      quote = TRUE;
    newtok(p);
    while ((c = nextc(p)) >= 0 && c != term) {
      if (c == '\n') {
        c = -1;
        break;
      }
      tokadd(p, c);
    }
    if (c < 0) {
      yyerror(p, "unterminated here document identifier");
      return 0;
    }
  }
  else {
    if (c < 0) {
      return 0;                 /* missing here document identifier */
    }
    if (! identchar(c)) {
      pushback(p, c);
      if (indent) pushback(p, '-');
      return 0;
    }
    newtok(p);
    do {
      tokadd(p, c);
    } while ((c = nextc(p)) >= 0 && identchar(c));
    pushback(p, c);
  }
  tokfix(p);
  newnode = new_heredoc(p);
  info = (parser_heredoc_info*)newnode->cdr;
  info->term = strndup(tok(p), toklen(p));
  info->term_len = toklen(p);
  if (! quote)
    type |= STR_FUNC_EXPAND;
  info->type = (string_type)type;
  info->allow_indent = indent;
  info->line_head = TRUE;
  info->doc = NULL;
  p->heredocs_from_nextline = push(p->heredocs_from_nextline, newnode);
  p->lstate = EXPR_END;

  pylval.nd = newnode;
  return tHEREDOC_BEG;
}

static int
arg_ambiguous(parser_state *p)
{
  yywarning(p, "ambiguous first argument; put parentheses or even spaces");
  return 1;
}

#include "lex.def"

static int
parser_yylex(parser_state *p)
{
  int32_t c;
  int space_seen = 0;
  int cmd_state;
  enum mrb_lex_state_enum last_state;
  int token_column;

  if (p->lex_strterm) {
    if (is_strterm_type(p, STR_FUNC_HEREDOC)) {
      if (p->parsing_heredoc != NULL)
        return parse_string(p);
    }
    else
      return parse_string(p);
  }
  cmd_state = p->cmd_start;
  p->cmd_start = FALSE;
  retry:
  last_state = p->lstate;
  switch (c = nextc(p)) {
  case '\004':  /* ^D */
  case '\032':  /* ^Z */
  case '\0':    /* NUL */
  case -1:      /* end of script. */
    if (p->heredocs_from_nextline)
      goto maybe_heredoc;
    return 0;

  /* white spaces */
  case ' ': case '\t': case '\f': case '\r':
  case '\13':   /* '\v' */
    space_seen = 1;
    goto retry;

  case '#':     /* it's a comment */
    skip(p, '\n');
    /* fall through */
  case -2:      /* end of a file */
  case '\n':
  maybe_heredoc:
    heredoc_treat_nextline(p);
    p->column = 0;
    switch (p->lstate) {
    case EXPR_BEG:
    case EXPR_FNAME:
    case EXPR_DOT:
    case EXPR_CLASS:
    case EXPR_VALUE:
      p->lineno++;
      if (p->parsing_heredoc != NULL) {
        if (p->lex_strterm) {
          return parse_string(p);
        }
      }
      goto retry;
    default:
      break;
    }
    if (p->parsing_heredoc != NULL) {
      return '\n';
    }
    while ((c = nextc(p))) {
      switch (c) {
      case ' ': case '\t': case '\f': case '\r':
      case '\13': /* '\v' */
        space_seen = 1;
        break;
      case '#': /* comment as a whitespace */
        pushback(p, '#');
        p->lineno++;
        goto retry;
      case '.':
        if (!peek(p, '.')) {
          pushback(p, '.');
          p->lineno++;
          goto retry;
        }
        pushback(p, c);
        goto normal_newline;
      case '&':
        if (peek(p, '.')) {
          pushback(p, '&');
          p->lineno++;
          goto retry;
        }
        pushback(p, c);
        goto normal_newline;
      case -1:                  /* EOF */
      case -2:                  /* end of a file */
        goto normal_newline;
      default:
        pushback(p, c);
        goto normal_newline;
      }
    }
  normal_newline:
    p->cmd_start = TRUE;
    p->lstate = EXPR_BEG;
    return '\n';

  case '*':
    if ((c = nextc(p)) == '*') {
      if ((c = nextc(p)) == '=') {
        pylval.id = intern_lit("**");
        p->lstate = EXPR_BEG;
        return tOP_ASGN;
      }
      pushback(p, c);
      if (IS_SPCARG(c)) {
        yywarning(p, "'**' interpreted as argument prefix");
        c = tDSTAR;
      }
      else if (IS_BEG()) {
        c = tDSTAR;
      }
      else {
        c = tPOW; /* "**", "argument prefix" */
      }
    }
    else {
      if (c == '=') {
        pylval.id = intern_lit("*");
        p->lstate = EXPR_BEG;
        return tOP_ASGN;
      }
      pushback(p, c);
      if (IS_SPCARG(c)) {
        yywarning(p, "'*' interpreted as argument prefix");
        c = tSTAR;
      }
      else if (IS_BEG()) {
        c = tSTAR;
      }
      else {
        c = '*';
      }
    }
    if (p->lstate == EXPR_FNAME || p->lstate == EXPR_DOT) {
      p->lstate = EXPR_ARG;
    }
    else {
      p->lstate = EXPR_BEG;
    }
    return c;

  case '!':
    c = nextc(p);
    if (p->lstate == EXPR_FNAME || p->lstate == EXPR_DOT) {
      p->lstate = EXPR_ARG;
      if (c == '@') {
        return '!';
      }
    }
    else {
      p->lstate = EXPR_BEG;
    }
    if (c == '=') {
      return tNEQ;
    }
    if (c == '~') {
      return tNMATCH;
    }
    pushback(p, c);
    return '!';

  case '=':
    if (p->column == 1) {
      static const char begin[] = "begin";
      static const char end[] = "\n=end";
      if (peeks(p, begin)) {
        c = peekc_n(p, sizeof(begin)-1);
        if (c < 0 || ISSPACE(c)) {
          do {
            if (!skips(p, end)) {
              yyerror(p, "embedded document meets end of file");
              return 0;
            }
            c = nextc(p);
          } while (!(c < 0 || ISSPACE(c)));
          if (c != '\n') skip(p, '\n');
          p->lineno++;
          p->column = 0;
          goto retry;
        }
      }
    }
    if (p->lstate == EXPR_FNAME || p->lstate == EXPR_DOT) {
      p->lstate = EXPR_ARG;
    }
    else {
      p->lstate = EXPR_BEG;
    }
    if ((c = nextc(p)) == '=') {
      if ((c = nextc(p)) == '=') {
        return tEQQ;
      }
      pushback(p, c);
      return tEQ;
    }
    if (c == '~') {
      return tMATCH;
    }
    else if (c == '>') {
      return tASSOC;
    }
    pushback(p, c);
    return '=';

  case '<':
    c = nextc(p);
    if (c == '<' &&
        p->lstate != EXPR_DOT &&
        p->lstate != EXPR_CLASS &&
        !IS_END() &&
        (!IS_ARG() || space_seen)) {
      int token = heredoc_identifier(p);
      if (token)
        return token;
    }
    if (p->lstate == EXPR_FNAME || p->lstate == EXPR_DOT) {
      p->lstate = EXPR_ARG;
    }
    else {
      p->lstate = EXPR_BEG;
      if (p->lstate == EXPR_CLASS) {
        p->cmd_start = TRUE;
      }
    }
    if (c == '=') {
      if ((c = nextc(p)) == '>') {
        return tCMP;
      }
      pushback(p, c);
      return tLEQ;
    }
    if (c == '<') {
      if ((c = nextc(p)) == '=') {
        pylval.id = intern_lit("<<");
        p->lstate = EXPR_BEG;
        return tOP_ASGN;
      }
      pushback(p, c);
      return tLSHFT;
    }
    pushback(p, c);
    return '<';

  case '>':
    if (p->lstate == EXPR_FNAME || p->lstate == EXPR_DOT) {
      p->lstate = EXPR_ARG;
    }
    else {
      p->lstate = EXPR_BEG;
    }
    if ((c = nextc(p)) == '=') {
      return tGEQ;
    }
    if (c == '>') {
      if ((c = nextc(p)) == '=') {
        pylval.id = intern_lit(">>");
        p->lstate = EXPR_BEG;
        return tOP_ASGN;
      }
      pushback(p, c);
      return tRSHFT;
    }
    pushback(p, c);
    return '>';

  case '"':
    p->lex_strterm = new_strterm(p, str_dquote, '"', 0);
    return tSTRING_BEG;

  case '\'':
    p->lex_strterm = new_strterm(p, str_squote, '\'', 0);
    return parse_string(p);

  case '`':
    if (p->lstate == EXPR_FNAME) {
      p->lstate = EXPR_ENDFN;
      return '`';
    }
    if (p->lstate == EXPR_DOT) {
      if (cmd_state)
        p->lstate = EXPR_CMDARG;
      else
        p->lstate = EXPR_ARG;
      return '`';
    }
    p->lex_strterm = new_strterm(p, str_xquote, '`', 0);
    return tXSTRING_BEG;

  case '?':
    if (IS_END()) {
      p->lstate = EXPR_VALUE;
      return '?';
    }
    c = nextc(p);
    if (c < 0) {
      yyerror(p, "incomplete character syntax");
      return 0;
    }
    if (ISSPACE(c)) {
      if (!IS_ARG()) {
        int c2;
        switch (c) {
        case ' ':
          c2 = 's';
          break;
        case '\n':
          c2 = 'n';
          break;
        case '\t':
          c2 = 't';
          break;
        case '\v':
          c2 = 'v';
          break;
        case '\r':
          c2 = 'r';
          break;
        case '\f':
          c2 = 'f';
          break;
        default:
          c2 = 0;
          break;
        }
        if (c2) {
          char buf[256];
          char cc[] = { (char)c2, '\0' };

          strcpy(buf, "invalid character syntax; use ?\\");
          strncat(buf, cc, 2);
          yyerror(p, buf);
        }
      }
      ternary:
      pushback(p, c);
      p->lstate = EXPR_VALUE;
      return '?';
    }
    newtok(p);
    /* need support UTF-8 if configured */
    if ((ISALNUM(c) || c == '_')) {
      int c2 = nextc(p);
      pushback(p, c2);
      if ((ISALNUM(c2) || c2 == '_')) {
        goto ternary;
      }
    }
    if (c == '\\') {
      c = read_escape(p);
      tokadd(p, c);
    }
    else {
      tokadd(p, c);
    }
    tokfix(p);
    pylval.nd = new_str(p, tok(p), toklen(p));
    p->lstate = EXPR_ENDARG;
    return tCHAR;

  case '&':
    if ((c = nextc(p)) == '&') {
      p->lstate = EXPR_BEG;
      if ((c = nextc(p)) == '=') {
        pylval.id = intern_lit("&&");
        p->lstate = EXPR_BEG;
        return tOP_ASGN;
      }
      pushback(p, c);
      return tANDOP;
    }
    else if (c == '.') {
      p->lstate = EXPR_DOT;
      return tANDDOT;
    }
    else if (c == '=') {
      pylval.id = intern_lit("&");
      p->lstate = EXPR_BEG;
      return tOP_ASGN;
    }
    pushback(p, c);
    if (IS_SPCARG(c)) {
      yywarning(p, "'&' interpreted as argument prefix");
      c = tAMPER;
    }
    else if (IS_BEG()) {
      c = tAMPER;
    }
    else {
      c = '&';
    }
    if (p->lstate == EXPR_FNAME || p->lstate == EXPR_DOT) {
      p->lstate = EXPR_ARG;
    }
    else {
      p->lstate = EXPR_BEG;
    }
    return c;

  case '|':
    if ((c = nextc(p)) == '|') {
      p->lstate = EXPR_BEG;
      if ((c = nextc(p)) == '=') {
        pylval.id = intern_lit("||");
        p->lstate = EXPR_BEG;
        return tOP_ASGN;
      }
      pushback(p, c);
      return tOROP;
    }
    if (c == '=') {
      pylval.id = intern_lit("|");
      p->lstate = EXPR_BEG;
      return tOP_ASGN;
    }
    if (p->lstate == EXPR_FNAME || p->lstate == EXPR_DOT) {
      p->lstate = EXPR_ARG;
    }
    else {
      p->lstate = EXPR_BEG;
    }
    pushback(p, c);
    return '|';

  case '+':
    c = nextc(p);
    if (p->lstate == EXPR_FNAME || p->lstate == EXPR_DOT) {
      p->lstate = EXPR_ARG;
      if (c == '@') {
        return tUPLUS;
      }
      pushback(p, c);
      return '+';
    }
    if (c == '=') {
      pylval.id = intern_lit("+");
      p->lstate = EXPR_BEG;
      return tOP_ASGN;
    }
    if (IS_BEG() || (IS_SPCARG(c) && arg_ambiguous(p))) {
      p->lstate = EXPR_BEG;
      pushback(p, c);
      if (c >= 0 && ISDIGIT(c)) {
        c = '+';
        goto start_num;
      }
      return tUPLUS;
    }
    p->lstate = EXPR_BEG;
    pushback(p, c);
    return '+';

  case '-':
    c = nextc(p);
    if (p->lstate == EXPR_FNAME || p->lstate == EXPR_DOT) {
      p->lstate = EXPR_ARG;
      if (c == '@') {
        return tUMINUS;
      }
      pushback(p, c);
      return '-';
    }
    if (c == '=') {
      pylval.id = intern_lit("-");
      p->lstate = EXPR_BEG;
      return tOP_ASGN;
    }
    if (c == '>') {
      p->lstate = EXPR_ENDFN;
      return tLAMBDA;
    }
    if (IS_BEG() || (IS_SPCARG(c) && arg_ambiguous(p))) {
      p->lstate = EXPR_BEG;
      pushback(p, c);
      if (c >= 0 && ISDIGIT(c)) {
        return tUMINUS_NUM;
      }
      return tUMINUS;
    }
    p->lstate = EXPR_BEG;
    pushback(p, c);
    return '-';

  case '.':
    p->lstate = EXPR_BEG;
    if ((c = nextc(p)) == '.') {
      if ((c = nextc(p)) == '.') {
        return tDOT3;
      }
      pushback(p, c);
      return tDOT2;
    }
    pushback(p, c);
    if (c >= 0 && ISDIGIT(c)) {
      yyerror(p, "no .<digit> floating literal anymore; put 0 before dot");
    }
    p->lstate = EXPR_DOT;
    return '.';

    start_num:
  case '0': case '1': case '2': case '3': case '4':
  case '5': case '6': case '7': case '8': case '9':
  {
    int is_float, seen_point, seen_e, nondigit;
    int suffix = 0;

    is_float = seen_point = seen_e = nondigit = 0;
    p->lstate = EXPR_ENDARG;
    newtok(p);
    if (c == '-' || c == '+') {
      tokadd(p, c);
      c = nextc(p);
    }
    if (c == '0') {
#define no_digits() do {yyerror(p,"numeric literal without digits"); return 0;} while (0)
      int start = toklen(p);
      c = nextc(p);
      if (c == 'x' || c == 'X') {
        /* hexadecimal */
        c = nextc(p);
        if (c >= 0 && ISXDIGIT(c)) {
          do {
            if (c == '_') {
              if (nondigit) break;
              nondigit = c;
              continue;
            }
            if (!ISXDIGIT(c)) break;
            nondigit = 0;
            tokadd(p, tolower(c));
          } while ((c = nextc(p)) >= 0);
        }
        pushback(p, c);
        tokfix(p);
        if (toklen(p) == start) {
          no_digits();
        }
        else if (nondigit) goto trailing_uc;
        suffix = number_literal_suffix(p);
        pylval.nd = new_int(p, tok(p), 16, suffix);
        return tINTEGER;
      }
      if (c == 'b' || c == 'B') {
        /* binary */
        c = nextc(p);
        if (c == '0' || c == '1') {
          do {
            if (c == '_') {
              if (nondigit) break;
              nondigit = c;
              continue;
            }
            if (c != '0' && c != '1') break;
            nondigit = 0;
            tokadd(p, c);
          } while ((c = nextc(p)) >= 0);
        }
        pushback(p, c);
        tokfix(p);
        if (toklen(p) == start) {
          no_digits();
        }
        else if (nondigit) goto trailing_uc;
        suffix = number_literal_suffix(p);
        pylval.nd = new_int(p, tok(p), 2, suffix);
        return tINTEGER;
      }
      if (c == 'd' || c == 'D') {
        /* decimal */
        c = nextc(p);
        if (c >= 0 && ISDIGIT(c)) {
          do {
            if (c == '_') {
              if (nondigit) break;
              nondigit = c;
              continue;
            }
            if (!ISDIGIT(c)) break;
            nondigit = 0;
            tokadd(p, c);
          } while ((c = nextc(p)) >= 0);
        }
        pushback(p, c);
        tokfix(p);
        if (toklen(p) == start) {
          no_digits();
        }
        else if (nondigit) goto trailing_uc;
        suffix = number_literal_suffix(p);
        pylval.nd = new_int(p, tok(p), 10, suffix);
        return tINTEGER;
      }
      if (c == '_') {
        /* 0_0 */
        goto octal_number;
      }
      if (c == 'o' || c == 'O') {
        /* prefixed octal */
        c = nextc(p);
        if (c < 0 || c == '_' || !ISDIGIT(c)) {
          no_digits();
        }
      }
      if (c >= '0' && c <= '7') {
        /* octal */
        octal_number:
        do {
          if (c == '_') {
            if (nondigit) break;
            nondigit = c;
            continue;
          }
          if (c < '0' || c > '9') break;
          if (c > '7') goto invalid_octal;
          nondigit = 0;
          tokadd(p, c);
        } while ((c = nextc(p)) >= 0);

        if (toklen(p) > start) {
          pushback(p, c);
          tokfix(p);
          if (nondigit) goto trailing_uc;
          suffix = number_literal_suffix(p);
          pylval.nd = new_int(p, tok(p), 8, suffix);
          return tINTEGER;
        }
        if (nondigit) {
          pushback(p, c);
          goto trailing_uc;
        }
      }
      if (c > '7' && c <= '9') {
        invalid_octal:
        yyerror(p, "Invalid octal digit");
      }
      else if (c == '.' || c == 'e' || c == 'E') {
        tokadd(p, '0');
      }
      else {
        pushback(p, c);
        suffix = number_literal_suffix(p);
        pylval.nd = new_int(p, "0", 10, suffix);
        return tINTEGER;
      }
    }

    for (;;) {
      switch (c) {
      case '0': case '1': case '2': case '3': case '4':
      case '5': case '6': case '7': case '8': case '9':
        nondigit = 0;
        tokadd(p, c);
        break;

      case '.':
        if (nondigit) goto trailing_uc;
        if (seen_point || seen_e) {
          goto decode_num;
        }
        else {
          int c0 = nextc(p);
          if (c0 < 0 || !ISDIGIT(c0)) {
            pushback(p, c0);
            goto decode_num;
          }
          c = c0;
        }
        tokadd(p, '.');
        tokadd(p, c);
        is_float++;
        seen_point++;
        nondigit = 0;
        break;

      case 'e':
      case 'E':
        if (nondigit) {
          pushback(p, c);
          c = nondigit;
          goto decode_num;
        }
        if (seen_e) {
          goto decode_num;
        }
        tokadd(p, c);
        seen_e++;
        is_float++;
        nondigit = c;
        c = nextc(p);
        if (c != '-' && c != '+') continue;
        tokadd(p, c);
        nondigit = c;
        break;

      case '_':       /* '_' in number just ignored */
        if (nondigit) goto decode_num;
        nondigit = c;
        break;

      default:
        goto decode_num;
      }
      c = nextc(p);
    }

    decode_num:
    pushback(p, c);
    if (nondigit) {
      trailing_uc:
      yyerror_c(p, "trailing non digit in number: ", (char)nondigit);
    }
    tokfix(p);
    if (is_float) {
#ifdef MRB_WITHOUT_FLOAT
      yywarning_s(p, "floating point numbers are not supported", tok(p));
      pylval.nd = new_int(p, "0", 10, 0);
      return tINTEGER;
#else
      double d;
      char *endp;

      errno = 0;
      d = mrb_float_read(tok(p), &endp);
      if (d == 0 && endp == tok(p)) {
        yywarning_s(p, "corrupted float value", tok(p));
      }
      else if (errno == ERANGE) {
        yywarning_s(p, "float out of range", tok(p));
        errno = 0;
      }
      suffix = number_literal_suffix(p);
      pylval.nd = new_float(p, tok(p), suffix);
      return tFLOAT;
#endif
    }
    suffix = number_literal_suffix(p);
    pylval.nd = new_int(p, tok(p), 10, suffix);
    return tINTEGER;
  }

  case ')':
  case ']':
    p->paren_nest--;
    /* fall through */
  case '}':
    COND_LEXPOP();
    CMDARG_LEXPOP();
    if (c == ')')
      p->lstate = EXPR_ENDFN;
    else
      p->lstate = EXPR_END;
    return c;

  case ':':
    c = nextc(p);
    if (c == ':') {
      if (IS_BEG() || p->lstate == EXPR_CLASS || IS_SPCARG(-1)) {
        p->lstate = EXPR_BEG;
        return tCOLON3;
      }
      p->lstate = EXPR_DOT;
      return tCOLON2;
    }
    if (!space_seen && IS_END()) {
      pushback(p, c);
      p->lstate = EXPR_BEG;
      return tLABEL_TAG;
    }
    if (!ISSPACE(c) || IS_BEG()) {
      pushback(p, c);
      p->lstate = EXPR_FNAME;
      return tSYMBEG;
    }
    pushback(p, c);
    p->lstate = EXPR_BEG;
    return ':';

  case '/':
    if (IS_BEG()) {
      p->lex_strterm = new_strterm(p, str_regexp, '/', 0);
      return tREGEXP_BEG;
    }
    if ((c = nextc(p)) == '=') {
      pylval.id = intern_lit("/");
      p->lstate = EXPR_BEG;
      return tOP_ASGN;
    }
    pushback(p, c);
    if (IS_SPCARG(c)) {
      p->lex_strterm = new_strterm(p, str_regexp, '/', 0);
      return tREGEXP_BEG;
    }
    if (p->lstate == EXPR_FNAME || p->lstate == EXPR_DOT) {
      p->lstate = EXPR_ARG;
    }
    else {
      p->lstate = EXPR_BEG;
    }
    return '/';

  case '^':
    if ((c = nextc(p)) == '=') {
      pylval.id = intern_lit("^");
      p->lstate = EXPR_BEG;
      return tOP_ASGN;
    }
    if (p->lstate == EXPR_FNAME || p->lstate == EXPR_DOT) {
      p->lstate = EXPR_ARG;
    }
    else {
      p->lstate = EXPR_BEG;
    }
    pushback(p, c);
    return '^';

  case ';':
    p->lstate = EXPR_BEG;
    return ';';

  case ',':
    p->lstate = EXPR_BEG;
    return ',';

  case '~':
    if (p->lstate == EXPR_FNAME || p->lstate == EXPR_DOT) {
      if ((c = nextc(p)) != '@') {
        pushback(p, c);
      }
      p->lstate = EXPR_ARG;
    }
    else {
      p->lstate = EXPR_BEG;
    }
    return '~';

  case '(':
    if (IS_BEG()) {
      c = tLPAREN;
    }
    else if (IS_SPCARG(-1)) {
      c = tLPAREN_ARG;
    }
    else if (p->lstate == EXPR_END && space_seen) {
      c = tLPAREN_ARG;
    }
    p->paren_nest++;
    COND_PUSH(0);
    CMDARG_PUSH(0);
    p->lstate = EXPR_BEG;
    return c;

  case '[':
    p->paren_nest++;
    if (p->lstate == EXPR_FNAME || p->lstate == EXPR_DOT) {
      p->lstate = EXPR_ARG;
      if ((c = nextc(p)) == ']') {
        if ((c = nextc(p)) == '=') {
          return tASET;
        }
        pushback(p, c);
        return tAREF;
      }
      pushback(p, c);
      return '[';
    }
    else if (IS_BEG()) {
      c = tLBRACK;
    }
    else if (IS_ARG() && space_seen) {
      c = tLBRACK;
    }
    p->lstate = EXPR_BEG;
    COND_PUSH(0);
    CMDARG_PUSH(0);
    return c;

  case '{':
    if (p->lpar_beg && p->lpar_beg == p->paren_nest) {
      p->lstate = EXPR_BEG;
      p->lpar_beg = 0;
      p->paren_nest--;
      COND_PUSH(0);
      CMDARG_PUSH(0);
      return tLAMBEG;
    }
    if (IS_ARG() || p->lstate == EXPR_END || p->lstate == EXPR_ENDFN)
      c = '{';          /* block (primary) */
    else if (p->lstate == EXPR_ENDARG)
      c = tLBRACE_ARG;  /* block (expr) */
    else
      c = tLBRACE;      /* hash */
    COND_PUSH(0);
    CMDARG_PUSH(0);
    p->lstate = EXPR_BEG;
    return c;

  case '\\':
    c = nextc(p);
    if (c == '\n') {
      p->lineno++;
      p->column = 0;
      space_seen = 1;
      goto retry; /* skip \\n */
    }
    pushback(p, c);
    return '\\';

  case '%':
    if (IS_BEG()) {
      int term;
      int paren;

      c = nextc(p);
      quotation:
      if (c < 0 || !ISALNUM(c)) {
        term = c;
        c = 'Q';
      }
      else {
        term = nextc(p);
        if (ISALNUM(term)) {
          yyerror(p, "unknown type of %string");
          return 0;
        }
      }
      if (c < 0 || term < 0) {
        yyerror(p, "unterminated quoted string meets end of file");
        return 0;
      }
      paren = term;
      if (term == '(') term = ')';
      else if (term == '[') term = ']';
      else if (term == '{') term = '}';
      else if (term == '<') term = '>';
      else paren = 0;

      switch (c) {
      case 'Q':
        p->lex_strterm = new_strterm(p, str_dquote, term, paren);
        return tSTRING_BEG;

      case 'q':
        p->lex_strterm = new_strterm(p, str_squote, term, paren);
        return parse_string(p);

      case 'W':
        p->lex_strterm = new_strterm(p, str_dword, term, paren);
        return tWORDS_BEG;

      case 'w':
        p->lex_strterm = new_strterm(p, str_sword, term, paren);
        return tWORDS_BEG;

      case 'x':
        p->lex_strterm = new_strterm(p, str_xquote, term, paren);
        return tXSTRING_BEG;

      case 'r':
        p->lex_strterm = new_strterm(p, str_regexp, term, paren);
        return tREGEXP_BEG;

      case 's':
        p->lex_strterm = new_strterm(p, str_ssym, term, paren);
        return tSYMBEG;

      case 'I':
        p->lex_strterm = new_strterm(p, str_dsymbols, term, paren);
        return tSYMBOLS_BEG;

      case 'i':
        p->lex_strterm = new_strterm(p, str_ssymbols, term, paren);
        return tSYMBOLS_BEG;

      default:
        yyerror(p, "unknown type of %string");
        return 0;
      }
    }
    if ((c = nextc(p)) == '=') {
      pylval.id = intern_lit("%");
      p->lstate = EXPR_BEG;
      return tOP_ASGN;
    }
    if (IS_SPCARG(c)) {
      goto quotation;
    }
    if (p->lstate == EXPR_FNAME || p->lstate == EXPR_DOT) {
      p->lstate = EXPR_ARG;
    }
    else {
      p->lstate = EXPR_BEG;
    }
    pushback(p, c);
    return '%';

  case '$':
    p->lstate = EXPR_END;
    token_column = newtok(p);
    c = nextc(p);
    if (c < 0) {
      yyerror(p, "incomplete global variable syntax");
      return 0;
    }
    switch (c) {
    case '_':     /* $_: last read line string */
      c = nextc(p);
      if (c >= 0 && identchar(c)) { /* if there is more after _ it is a variable */
        tokadd(p, '$');
        tokadd(p, c);
        break;
      }
      pushback(p, c);
      c = '_';
      /* fall through */
    case '~':     /* $~: match-data */
    case '*':     /* $*: argv */
    case '$':     /* $$: pid */
    case '?':     /* $?: last status */
    case '!':     /* $!: error string */
    case '@':     /* $@: error position */
    case '/':     /* $/: input record separator */
    case '\\':    /* $\: output record separator */
    case ';':     /* $;: field separator */
    case ',':     /* $,: output field separator */
    case '.':     /* $.: last read line number */
    case '=':     /* $=: ignorecase */
    case ':':     /* $:: load path */
    case '<':     /* $<: reading filename */
    case '>':     /* $>: default output handle */
    case '\"':    /* $": already loaded files */
      tokadd(p, '$');
      tokadd(p, c);
      tokfix(p);
      pylval.id = intern(tok(p), toklen(p));
      return tGVAR;

    case '-':
      tokadd(p, '$');
      tokadd(p, c);
      c = nextc(p);
      pushback(p, c);
      gvar:
      tokfix(p);
      pylval.id = intern(tok(p), toklen(p));
      return tGVAR;

    case '&':     /* $&: last match */
    case '`':     /* $`: string before last match */
    case '\'':    /* $': string after last match */
    case '+':     /* $+: string matches last pattern */
      if (last_state == EXPR_FNAME) {
        tokadd(p, '$');
        tokadd(p, c);
        goto gvar;
      }
      pylval.nd = new_back_ref(p, c);
      return tBACK_REF;

    case '1': case '2': case '3':
    case '4': case '5': case '6':
    case '7': case '8': case '9':
      do {
        tokadd(p, c);
        c = nextc(p);
      } while (c >= 0 && ISDIGIT(c));
      pushback(p, c);
      if (last_state == EXPR_FNAME) goto gvar;
      tokfix(p);
      {
        unsigned long n = strtoul(tok(p), NULL, 10);
        if (n > INT_MAX) {
          yyerror(p, "capture group index must be <= " MRB_STRINGIZE(INT_MAX));
          return 0;
        }
        pylval.nd = new_nth_ref(p, (int)n);
      }
      return tNTH_REF;

    default:
      if (!identchar(c)) {
        pushback(p,  c);
        return '$';
      }
      /* fall through */
    case '0':
      tokadd(p, '$');
    }
    break;

    case '@':
      c = nextc(p);
      token_column = newtok(p);
      tokadd(p, '@');
      if (c == '@') {
        tokadd(p, '@');
        c = nextc(p);
      }
      if (c < 0) {
        if (p->tidx == 1) {
          yyerror(p, "incomplete instance variable syntax");
        }
        else {
          yyerror(p, "incomplete class variable syntax");
        }
        return 0;
      }
      else if (ISDIGIT(c)) {
        if (p->tidx == 1) {
          yyerror_c(p, "wrong instance variable name: @", c);
        }
        else {
          yyerror_c(p, "wrong class variable name: @@", c);
        }
        return 0;
      }
      if (!identchar(c)) {
        pushback(p, c);
        return '@';
      }
      break;

    case '_':
      token_column = newtok(p);
      break;

    default:
      if (!identchar(c)) {
        char buf[36];
        const char s[] = "Invalid char in expression: 0x";
        const char hexdigits[] = "0123456789ABCDEF";

        strcpy(buf, s);
        buf[sizeof(s)-1] = hexdigits[(c & 0xf0) >> 4];
        buf[sizeof(s)]   = hexdigits[(c & 0x0f)];
        buf[sizeof(s)+1] = 0;
        yyerror(p, buf);
        goto retry;
      }

      token_column = newtok(p);
      break;
  }

  do {
    tokadd(p, c);
    c = nextc(p);
    if (c < 0) break;
  } while (identchar(c));
  if (token_column == 0 && toklen(p) == 7 && (c < 0 || c == '\n') &&
      strncmp(tok(p), "__END__", toklen(p)) == 0)
    return -1;

  switch (tok(p)[0]) {
  case '@': case '$':
    pushback(p, c);
    break;
  default:
    if ((c == '!' || c == '?') && !peek(p, '=')) {
      tokadd(p, c);
    }
    else {
      pushback(p, c);
    }
  }
  tokfix(p);
  {
    int result = 0;

    switch (tok(p)[0]) {
    case '$':
      p->lstate = EXPR_END;
      result = tGVAR;
      break;
    case '@':
      p->lstate = EXPR_END;
      if (tok(p)[1] == '@')
        result = tCVAR;
      else
        result = tIVAR;
      break;

    case '_':
      if (toklen(p) == 2 && ISDIGIT(tok(p)[1]) && p->nvars) {
        int n = tok(p)[1] - '0';
        int nvar;

        if (n > 0) {
          node *nvars = p->nvars->cdr;

          while (nvars) {
            nvar = intn(nvars->car);
            if (nvar == -2) break; /* top of the scope */
            if (nvar > 0) {
              yywarning(p, "numbered parameter used in outer block");
              break;
            }
            nvars->car = nint(-1);
            nvars = nvars->cdr;
          }
          nvar = intn(p->nvars->car);
          if (nvar == -1) {
            yywarning(p, "numbered parameter used in inner block");
          }
          if (nvar >= -1) {
            pylval.num = n;
            p->lstate = EXPR_END;
            return tNUMPARAM;
          }
          else {
            yywarning(p, "identifier for numbered parameter; consider another name");
          }
        }
      }
      /* fall through */
    default:
      if (toklast(p) == '!' || toklast(p) == '?') {
        result = tFID;
      }
      else {
        if (p->lstate == EXPR_FNAME) {
          if ((c = nextc(p)) == '=' && !peek(p, '~') && !peek(p, '>') &&
              (!peek(p, '=') || (peek_n(p, '>', 1)))) {
            result = tIDENTIFIER;
            tokadd(p, c);
            tokfix(p);
          }
          else {
            pushback(p, c);
          }
          if ((c = nextc(p)) == '=' && !peek(p, '~') && !peek(p, '>') &&
              (!peek(p, '=') || (peek_n(p, '>', 1)))) {
            result = tIDENTIFIER;
            tokadd(p, c);
            tokfix(p);
          }
          else {
            pushback(p, c);
          }
        }
        if (result == 0 && ISUPPER(tok(p)[0])) {
          result = tCONSTANT;
        }
        else {
          result = tIDENTIFIER;
        }
      }

      if (IS_LABEL_POSSIBLE()) {
        if (IS_LABEL_SUFFIX(0)) {
          p->lstate = EXPR_END;
          tokfix(p);
          pylval.id = intern(tok(p), toklen(p));
          return tIDENTIFIER;
        }
      }
      if (p->lstate != EXPR_DOT) {
        const struct kwtable *kw;

        /* See if it is a reserved word.  */
        kw = mrb_reserved_word(tok(p), toklen(p));
        if (kw) {
          enum mrb_lex_state_enum state = p->lstate;
          pylval.num = p->lineno;
          p->lstate = kw->state;
          if (state == EXPR_FNAME) {
            pylval.id = intern_cstr(kw->name);
            return kw->id[0];
          }
          if (p->lstate == EXPR_BEG) {
            p->cmd_start = TRUE;
          }
          if (kw->id[0] == keyword_do) {
            if (p->lpar_beg && p->lpar_beg == p->paren_nest) {
              p->lpar_beg = 0;
              p->paren_nest--;
              return keyword_do_LAMBDA;
            }
            if (COND_P()) return keyword_do_cond;
            if (CMDARG_P() && state != EXPR_CMDARG)
              return keyword_do_block;
            if (state == EXPR_ENDARG || state == EXPR_BEG)
              return keyword_do_block;
            return keyword_do;
          }
          if (state == EXPR_BEG || state == EXPR_VALUE)
            return kw->id[0];
          else {
            if (kw->id[0] != kw->id[1])
              p->lstate = EXPR_BEG;
            return kw->id[1];
          }
        }
      }

      if (IS_BEG() || p->lstate == EXPR_DOT || IS_ARG()) {
        if (cmd_state) {
          p->lstate = EXPR_CMDARG;
        }
        else {
          p->lstate = EXPR_ARG;
        }
      }
      else if (p->lstate == EXPR_FNAME) {
        p->lstate = EXPR_ENDFN;
      }
      else {
        p->lstate = EXPR_END;
      }
    }
    {
      mrb_sym ident = intern(tok(p), toklen(p));

      pylval.id = ident;
      if (last_state != EXPR_DOT && ISLOWER(tok(p)[0]) && local_var_p(p, ident)) {
        p->lstate = EXPR_END;
      }
    }
    return result;
  }
}

static int
yylex(void *lval, parser_state *p)
{
  p->ylval = lval;
  return parser_yylex(p);
}

static void
parser_init_cxt(parser_state *p, mrbc_context *cxt)
{
  if (!cxt) return;
  if (cxt->filename) mrb_parser_set_filename(p, cxt->filename);
  if (cxt->lineno) p->lineno = cxt->lineno;
  if (cxt->syms) {
    int i;

    p->locals = cons(0,0);
    for (i=0; i<cxt->slen; i++) {
      local_add_f(p, cxt->syms[i]);
    }
  }
  p->capture_errors = cxt->capture_errors;
  p->no_optimize = cxt->no_optimize;
  p->on_eval = cxt->on_eval;
  if (cxt->partial_hook) {
    p->cxt = cxt;
  }
}

static void
parser_update_cxt(parser_state *p, mrbc_context *cxt)
{
  node *n, *n0;
  int i = 0;

  if (!cxt) return;
  if (intn(p->tree->car) != NODE_SCOPE) return;
  n0 = n = p->tree->cdr->car;
  while (n) {
    i++;
    n = n->cdr;
  }
  cxt->syms = (mrb_sym *)mrb_realloc(p->mrb, cxt->syms, i*sizeof(mrb_sym));
  cxt->slen = i;
  for (i=0, n=n0; n; i++,n=n->cdr) {
    cxt->syms[i] = sym(n->car);
  }
}

void mrb_codedump_all(mrb_state*, struct RProc*);
void mrb_parser_dump(mrb_state *mrb, node *tree, int offset);

MRB_API void
mrb_parser_parse(parser_state *p, mrbc_context *c)
{
  struct mrb_jmpbuf buf1;
  p->jmp = &buf1;

  MRB_TRY(p->jmp) {
    int n = 1;

    p->cmd_start = TRUE;
    p->in_def = p->in_single = 0;
    p->nerr = p->nwarn = 0;
    p->lex_strterm = NULL;

    parser_init_cxt(p, c);

    if (p->mrb->jmp) {
      n = yyparse(p);
    }
    else {
      struct mrb_jmpbuf buf2;

      p->mrb->jmp = &buf2;
      MRB_TRY(p->mrb->jmp) {
        n = yyparse(p);
      }
      MRB_CATCH(p->mrb->jmp) {
        p->nerr++;
      }
      MRB_END_EXC(p->mrb->jmp);
      p->mrb->jmp = 0;
    }
    if (n != 0 || p->nerr > 0) {
      p->tree = 0;
      return;
    }
    if (!p->tree) {
      p->tree = new_nil(p);
    }
    parser_update_cxt(p, c);
    if (c && c->dump_result) {
      mrb_parser_dump(p->mrb, p->tree, 0);
    }
  }
  MRB_CATCH(p->jmp) {
    yyerror(p, "memory allocation error");
    p->nerr++;
    p->tree = 0;
    return;
  }
  MRB_END_EXC(p->jmp);
}

MRB_API parser_state*
mrb_parser_new(mrb_state *mrb)
{
  mrb_pool *pool;
  parser_state *p;
  static const parser_state parser_state_zero = { 0 };

  pool = mrb_pool_open(mrb);
  if (!pool) return NULL;
  p = (parser_state *)mrb_pool_alloc(pool, sizeof(parser_state));
  if (!p) return NULL;

  *p = parser_state_zero;
  p->mrb = mrb;
  p->pool = pool;

  p->s = p->send = NULL;
#ifndef MRB_DISABLE_STDIO
  p->f = NULL;
#endif

  p->cmd_start = TRUE;
  p->in_def = p->in_single = 0;

  p->capture_errors = FALSE;
  p->lineno = 1;
  p->column = 0;
#if defined(PARSER_TEST) || defined(PARSER_DEBUG)
  yydebug = 1;
#endif
  p->tsiz = MRB_PARSER_TOKBUF_SIZE;
  p->tokbuf = p->buf;

  p->lex_strterm = NULL;
  p->all_heredocs = p->parsing_heredoc = NULL;
  p->lex_strterm_before_heredoc = NULL;

  p->current_filename_index = -1;
  p->filename_table = NULL;
  p->filename_table_length = 0;

  return p;
}

MRB_API void
mrb_parser_free(parser_state *p) {
  if (p->tokbuf != p->buf) {
    mrb_free(p->mrb, p->tokbuf);
  }
  mrb_pool_close(p->pool);
}

MRB_API mrbc_context*
mrbc_context_new(mrb_state *mrb)
{
  return (mrbc_context *)mrb_calloc(mrb, 1, sizeof(mrbc_context));
}

MRB_API void
mrbc_context_free(mrb_state *mrb, mrbc_context *cxt)
{
  mrb_free(mrb, cxt->filename);
  mrb_free(mrb, cxt->syms);
  mrb_free(mrb, cxt);
}

MRB_API const char*
mrbc_filename(mrb_state *mrb, mrbc_context *c, const char *s)
{
  if (s) {
    size_t len = strlen(s);
    char *p = (char *)mrb_malloc(mrb, len + 1);

    memcpy(p, s, len + 1);
    if (c->filename) {
      mrb_free(mrb, c->filename);
    }
    c->filename = p;
  }
  return c->filename;
}

MRB_API void
mrbc_partial_hook(mrb_state *mrb, mrbc_context *c, int (*func)(struct mrb_parser_state*), void *data)
{
  c->partial_hook = func;
  c->partial_data = data;
}

MRB_API void
mrb_parser_set_filename(struct mrb_parser_state *p, const char *f)
{
  mrb_sym sym;
  size_t i;
  mrb_sym* new_table;

  sym = mrb_intern_cstr(p->mrb, f);
  p->filename_sym = sym;
  p->lineno = (p->filename_table_length > 0)? 0 : 1;

  for (i = 0; i < p->filename_table_length; ++i) {
    if (p->filename_table[i] == sym) {
      p->current_filename_index = (int)i;
      return;
    }
  }

  if (p->filename_table_length == UINT16_MAX) {
    yyerror(p, "too many files to compile");
    return;
  }
  p->current_filename_index = p->filename_table_length++;

  new_table = (mrb_sym*)parser_palloc(p, sizeof(mrb_sym) * p->filename_table_length);
  if (p->filename_table) {
    memmove(new_table, p->filename_table, sizeof(mrb_sym) * p->current_filename_index);
  }
  p->filename_table = new_table;
  p->filename_table[p->filename_table_length - 1] = sym;
}

MRB_API mrb_sym
mrb_parser_get_filename(struct mrb_parser_state* p, uint16_t idx) {
  if (idx >= p->filename_table_length) return 0;
  else {
    return p->filename_table[idx];
  }
}

#ifndef MRB_DISABLE_STDIO
MRB_API parser_state*
mrb_parse_file(mrb_state *mrb, FILE *f, mrbc_context *c)
{
  parser_state *p;

  p = mrb_parser_new(mrb);
  if (!p) return NULL;
  p->s = p->send = NULL;
  p->f = f;

  mrb_parser_parse(p, c);
  return p;
}
#endif

MRB_API parser_state*
mrb_parse_nstring(mrb_state *mrb, const char *s, size_t len, mrbc_context *c)
{
  parser_state *p;

  p = mrb_parser_new(mrb);
  if (!p) return NULL;
  p->s = s;
  p->send = s + len;

  mrb_parser_parse(p, c);
  return p;
}

MRB_API parser_state*
mrb_parse_string(mrb_state *mrb, const char *s, mrbc_context *c)
{
  return mrb_parse_nstring(mrb, s, strlen(s), c);
}

MRB_API mrb_value
mrb_load_exec(mrb_state *mrb, struct mrb_parser_state *p, mrbc_context *c)
{
  struct RClass *target = mrb->object_class;
  struct RProc *proc;
  mrb_value v;
  unsigned int keep = 0;

  if (!p) {
    return mrb_undef_value();
  }
  if (!p->tree || p->nerr) {
    if (c) c->parser_nerr = p->nerr;
    if (p->capture_errors) {
      char buf[256];

      strcpy(buf, "line ");
      dump_int(p->error_buffer[0].lineno, buf+5);
      strcat(buf, ": ");
      strncat(buf, p->error_buffer[0].message, sizeof(buf) - strlen(buf) - 1);
      mrb->exc = mrb_obj_ptr(mrb_exc_new(mrb, E_SYNTAX_ERROR, buf, strlen(buf)));
      mrb_parser_free(p);
      return mrb_undef_value();
    }
    else {
      if (mrb->exc == NULL) {
        mrb->exc = mrb_obj_ptr(mrb_exc_new_str_lit(mrb, E_SYNTAX_ERROR, "syntax error"));
      }
      mrb_parser_free(p);
      return mrb_undef_value();
    }
  }
  proc = mrb_generate_code(mrb, p);
  mrb_parser_free(p);
  if (proc == NULL) {
    if (mrb->exc == NULL) {
      mrb->exc = mrb_obj_ptr(mrb_exc_new_str_lit(mrb, E_SCRIPT_ERROR, "codegen error"));
    }
    return mrb_undef_value();
  }
  if (c) {
    if (c->dump_result) mrb_codedump_all(mrb, proc);
    if (c->no_exec) return mrb_obj_value(proc);
    if (c->target_class) {
      target = c->target_class;
    }
    if (c->keep_lv) {
      keep = c->slen + 1;
    }
    else {
      c->keep_lv = TRUE;
    }
  }
  MRB_PROC_SET_TARGET_CLASS(proc, target);
  if (mrb->c->ci) {
    mrb->c->ci->target_class = target;
  }
  v = mrb_top_run(mrb, proc, mrb_top_self(mrb), keep);
  if (mrb->exc) return mrb_nil_value();
  return v;
}

#ifndef MRB_DISABLE_STDIO
MRB_API mrb_value
mrb_load_file_cxt(mrb_state *mrb, FILE *f, mrbc_context *c)
{
  return mrb_load_exec(mrb, mrb_parse_file(mrb, f, c), c);
}

MRB_API mrb_value
mrb_load_file(mrb_state *mrb, FILE *f)
{
  return mrb_load_file_cxt(mrb, f, NULL);
}
#endif

MRB_API mrb_value
mrb_load_nstring_cxt(mrb_state *mrb, const char *s, size_t len, mrbc_context *c)
{
  return mrb_load_exec(mrb, mrb_parse_nstring(mrb, s, len, c), c);
}

MRB_API mrb_value
mrb_load_nstring(mrb_state *mrb, const char *s, size_t len)
{
  return mrb_load_nstring_cxt(mrb, s, len, NULL);
}

MRB_API mrb_value
mrb_load_string_cxt(mrb_state *mrb, const char *s, mrbc_context *c)
{
  return mrb_load_nstring_cxt(mrb, s, strlen(s), c);
}

MRB_API mrb_value
mrb_load_string(mrb_state *mrb, const char *s)
{
  return mrb_load_string_cxt(mrb, s, NULL);
}

#ifndef MRB_DISABLE_STDIO

static void
dump_prefix(node *tree, int offset)
{
  printf("%05d ", tree->lineno);
  while (offset--) {
    putc(' ', stdout);
    putc(' ', stdout);
  }
}

static void
dump_recur(mrb_state *mrb, node *tree, int offset)
{
  while (tree) {
    mrb_parser_dump(mrb, tree->car, offset);
    tree = tree->cdr;
  }
}

static void
dump_args(mrb_state *mrb, node *n, int offset)
{
  if (n->car) {
    dump_prefix(n, offset+1);
    printf("mandatory args:\n");
    dump_recur(mrb, n->car, offset+2);
  }
  n = n->cdr;
  if (n->car) {
    dump_prefix(n, offset+1);
    printf("optional args:\n");
    {
      node *n2 = n->car;

      while (n2) {
        dump_prefix(n2, offset+2);
        printf("%s=\n", mrb_sym_name(mrb, sym(n2->car->car)));
        mrb_parser_dump(mrb, n2->car->cdr, offset+3);
        n2 = n2->cdr;
      }
    }
  }
  n = n->cdr;
  if (n->car) {
    dump_prefix(n, offset+1);
    printf("rest=*%s\n", mrb_sym_name(mrb, sym(n->car)));
  }
  n = n->cdr;
  if (n->car) {
    dump_prefix(n, offset+1);
    printf("post mandatory args:\n");
    dump_recur(mrb, n->car, offset+2);
  }

  n = n->cdr;
  if (n) {
    mrb_assert(intn(n->car) == NODE_ARGS_TAIL);
    mrb_parser_dump(mrb, n, offset);
  }
}

/*
 * This function restores the GC arena on return.
 * For this reason, if a process that further generates an object is
 * performed at the caller, the string pointer returned as the return
 * value may become invalid.
 */
static const char*
str_dump(mrb_state *mrb, const char *str, int len)
{
  mrb_int ai = mrb_gc_arena_save(mrb);
  mrb_value s;
# if INT_MAX > MRB_INT_MAX / 4
  /* check maximum length with "\xNN" charactor */
  if (len > MRB_INT_MAX / 4) {
    len = MRB_INT_MAX / 4;
  }
# endif
  s = mrb_str_new(mrb, str, (mrb_int)len);
  s = mrb_str_dump(mrb, s);
  mrb_gc_arena_restore(mrb, ai);
  return RSTRING_PTR(s);
}
#endif

void
mrb_parser_dump(mrb_state *mrb, node *tree, int offset)
{
#ifndef MRB_DISABLE_STDIO
  int nodetype;

  if (!tree) return;
  again:
  dump_prefix(tree, offset);
  nodetype = intn(tree->car);
  tree = tree->cdr;
  switch (nodetype) {
  case NODE_BEGIN:
    printf("NODE_BEGIN:\n");
    dump_recur(mrb, tree, offset+1);
    break;

  case NODE_RESCUE:
    printf("NODE_RESCUE:\n");
    if (tree->car) {
      dump_prefix(tree, offset+1);
      printf("body:\n");
      mrb_parser_dump(mrb, tree->car, offset+2);
    }
    tree = tree->cdr;
    if (tree->car) {
      node *n2 = tree->car;

      dump_prefix(n2, offset+1);
      printf("rescue:\n");
      while (n2) {
        node *n3 = n2->car;
        if (n3->car) {
          dump_prefix(n2, offset+2);
          printf("handle classes:\n");
          dump_recur(mrb, n3->car, offset+3);
        }
        if (n3->cdr->car) {
          dump_prefix(n3, offset+2);
          printf("exc_var:\n");
          mrb_parser_dump(mrb, n3->cdr->car, offset+3);
        }
        if (n3->cdr->cdr->car) {
          dump_prefix(n3, offset+2);
          printf("rescue body:\n");
          mrb_parser_dump(mrb, n3->cdr->cdr->car, offset+3);
        }
        n2 = n2->cdr;
      }
    }
    tree = tree->cdr;
    if (tree->car) {
      dump_prefix(tree, offset+1);
      printf("else:\n");
      mrb_parser_dump(mrb, tree->car, offset+2);
    }
    break;

  case NODE_ENSURE:
    printf("NODE_ENSURE:\n");
    dump_prefix(tree, offset+1);
    printf("body:\n");
    mrb_parser_dump(mrb, tree->car, offset+2);
    dump_prefix(tree, offset+1);
    printf("ensure:\n");
    mrb_parser_dump(mrb, tree->cdr->cdr, offset+2);
    break;

  case NODE_LAMBDA:
    printf("NODE_LAMBDA:\n");
    dump_prefix(tree, offset);
    goto block;

  case NODE_BLOCK:
    block:
    printf("NODE_BLOCK:\n");
    tree = tree->cdr;
    if (tree->car) {
      dump_args(mrb, tree->car, offset+1);
    }
    dump_prefix(tree, offset+1);
    printf("body:\n");
    mrb_parser_dump(mrb, tree->cdr->car, offset+2);
    break;

  case NODE_IF:
    printf("NODE_IF:\n");
    dump_prefix(tree, offset+1);
    printf("cond:\n");
    mrb_parser_dump(mrb, tree->car, offset+2);
    dump_prefix(tree, offset+1);
    printf("then:\n");
    mrb_parser_dump(mrb, tree->cdr->car, offset+2);
    if (tree->cdr->cdr->car) {
      dump_prefix(tree, offset+1);
      printf("else:\n");
      mrb_parser_dump(mrb, tree->cdr->cdr->car, offset+2);
    }
    break;

  case NODE_AND:
    printf("NODE_AND:\n");
    mrb_parser_dump(mrb, tree->car, offset+1);
    mrb_parser_dump(mrb, tree->cdr, offset+1);
    break;

  case NODE_OR:
    printf("NODE_OR:\n");
    mrb_parser_dump(mrb, tree->car, offset+1);
    mrb_parser_dump(mrb, tree->cdr, offset+1);
    break;

  case NODE_CASE:
    printf("NODE_CASE:\n");
    if (tree->car) {
      mrb_parser_dump(mrb, tree->car, offset+1);
    }
    tree = tree->cdr;
    while (tree) {
      dump_prefix(tree, offset+1);
      printf("case:\n");
      dump_recur(mrb, tree->car->car, offset+2);
      dump_prefix(tree, offset+1);
      printf("body:\n");
      mrb_parser_dump(mrb, tree->car->cdr, offset+2);
      tree = tree->cdr;
    }
    break;

  case NODE_WHILE:
    printf("NODE_WHILE:\n");
    dump_prefix(tree, offset+1);
    printf("cond:\n");
    mrb_parser_dump(mrb, tree->car, offset+2);
    dump_prefix(tree, offset+1);
    printf("body:\n");
    mrb_parser_dump(mrb, tree->cdr, offset+2);
    break;

  case NODE_UNTIL:
    printf("NODE_UNTIL:\n");
    dump_prefix(tree, offset+1);
    printf("cond:\n");
    mrb_parser_dump(mrb, tree->car, offset+2);
    dump_prefix(tree, offset+1);
    printf("body:\n");
    mrb_parser_dump(mrb, tree->cdr, offset+2);
    break;

  case NODE_FOR:
    printf("NODE_FOR:\n");
    dump_prefix(tree, offset+1);
    printf("var:\n");
    {
      node *n2 = tree->car;

      if (n2->car) {
        dump_prefix(n2, offset+2);
        printf("pre:\n");
        dump_recur(mrb, n2->car, offset+3);
      }
      n2 = n2->cdr;
      if (n2) {
        if (n2->car) {
          dump_prefix(n2, offset+2);
          printf("rest:\n");
          mrb_parser_dump(mrb, n2->car, offset+3);
        }
        n2 = n2->cdr;
        if (n2) {
          if (n2->car) {
            dump_prefix(n2, offset+2);
            printf("post:\n");
            dump_recur(mrb, n2->car, offset+3);
          }
        }
      }
    }
    tree = tree->cdr;
    dump_prefix(tree, offset+1);
    printf("in:\n");
    mrb_parser_dump(mrb, tree->car, offset+2);
    tree = tree->cdr;
    dump_prefix(tree, offset+1);
    printf("do:\n");
    mrb_parser_dump(mrb, tree->car, offset+2);
    break;

  case NODE_SCOPE:
    printf("NODE_SCOPE:\n");
    {
      node *n2 = tree->car;
      mrb_bool first_lval = TRUE;

      if (n2 && (n2->car || n2->cdr)) {
        dump_prefix(n2, offset+1);
        printf("local variables:\n");
        dump_prefix(n2, offset+2);
        while (n2) {
          if (n2->car) {
            if (!first_lval) printf(", ");
            printf("%s", mrb_sym_name(mrb, sym(n2->car)));
            first_lval = FALSE;
          }
          n2 = n2->cdr;
        }
        printf("\n");
      }
    }
    tree = tree->cdr;
    offset++;
    goto again;

  case NODE_FCALL:
  case NODE_CALL:
  case NODE_SCALL:
    switch (nodetype) {
    case NODE_FCALL:
      printf("NODE_FCALL:\n"); break;
    case NODE_CALL:
      printf("NODE_CALL(.):\n"); break;
    case NODE_SCALL:
      printf("NODE_SCALL(&.):\n"); break;
    default:
      break;
    }
    mrb_parser_dump(mrb, tree->car, offset+1);
    dump_prefix(tree, offset+1);
    printf("method='%s' (%d)\n",
        mrb_sym_dump(mrb, sym(tree->cdr->car)),
        intn(tree->cdr->car));
    tree = tree->cdr->cdr->car;
    if (tree) {
      dump_prefix(tree, offset+1);
      printf("args:\n");
      dump_recur(mrb, tree->car, offset+2);
      if (tree->cdr) {
        dump_prefix(tree, offset+1);
        printf("block:\n");
        mrb_parser_dump(mrb, tree->cdr, offset+2);
      }
    }
    break;

  case NODE_DOT2:
    printf("NODE_DOT2:\n");
    mrb_parser_dump(mrb, tree->car, offset+1);
    mrb_parser_dump(mrb, tree->cdr, offset+1);
    break;

  case NODE_DOT3:
    printf("NODE_DOT3:\n");
    mrb_parser_dump(mrb, tree->car, offset+1);
    mrb_parser_dump(mrb, tree->cdr, offset+1);
    break;

  case NODE_COLON2:
    printf("NODE_COLON2:\n");
    mrb_parser_dump(mrb, tree->car, offset+1);
    dump_prefix(tree, offset+1);
    printf("::%s\n", mrb_sym_name(mrb, sym(tree->cdr)));
    break;

  case NODE_COLON3:
    printf("NODE_COLON3: ::%s\n", mrb_sym_name(mrb, sym(tree)));
    break;

  case NODE_ARRAY:
    printf("NODE_ARRAY:\n");
    dump_recur(mrb, tree, offset+1);
    break;

  case NODE_HASH:
    printf("NODE_HASH:\n");
    while (tree) {
      dump_prefix(tree, offset+1);
      printf("key:\n");
      mrb_parser_dump(mrb, tree->car->car, offset+2);
      dump_prefix(tree, offset+1);
      printf("value:\n");
      mrb_parser_dump(mrb, tree->car->cdr, offset+2);
      tree = tree->cdr;
    }
    break;

  case NODE_KW_HASH:
    printf("NODE_KW_HASH:\n");
    while (tree) {
      dump_prefix(tree, offset+1);
      printf("key:\n");
      mrb_parser_dump(mrb, tree->car->car, offset+2);
      dump_prefix(tree, offset+1);
      printf("value:\n");
      mrb_parser_dump(mrb, tree->car->cdr, offset+2);
      tree = tree->cdr;
    }
    break;

  case NODE_SPLAT:
    printf("NODE_SPLAT:\n");
    mrb_parser_dump(mrb, tree, offset+1);
    break;

  case NODE_ASGN:
    printf("NODE_ASGN:\n");
    dump_prefix(tree, offset+1);
    printf("lhs:\n");
    mrb_parser_dump(mrb, tree->car, offset+2);
    dump_prefix(tree, offset+1);
    printf("rhs:\n");
    mrb_parser_dump(mrb, tree->cdr, offset+2);
    break;

  case NODE_MASGN:
    printf("NODE_MASGN:\n");
    dump_prefix(tree, offset+1);
    printf("mlhs:\n");
    {
      node *n2 = tree->car;

      if (n2->car) {
        dump_prefix(tree, offset+2);
        printf("pre:\n");
        dump_recur(mrb, n2->car, offset+3);
      }
      n2 = n2->cdr;
      if (n2) {
        if (n2->car) {
          dump_prefix(n2, offset+2);
          printf("rest:\n");
          if (n2->car == (node*)-1) {
            dump_prefix(n2, offset+2);
            printf("(empty)\n");
          }
          else {
            mrb_parser_dump(mrb, n2->car, offset+3);
          }
        }
        n2 = n2->cdr;
        if (n2) {
          if (n2->car) {
            dump_prefix(n2, offset+2);
            printf("post:\n");
            dump_recur(mrb, n2->car, offset+3);
          }
        }
      }
    }
    dump_prefix(tree, offset+1);
    printf("rhs:\n");
    mrb_parser_dump(mrb, tree->cdr, offset+2);
    break;

  case NODE_OP_ASGN:
    printf("NODE_OP_ASGN:\n");
    dump_prefix(tree, offset+1);
    printf("lhs:\n");
    mrb_parser_dump(mrb, tree->car, offset+2);
    tree = tree->cdr;
    dump_prefix(tree, offset+1);
    printf("op='%s' (%d)\n", mrb_sym_name(mrb, sym(tree->car)), intn(tree->car));
    tree = tree->cdr;
    mrb_parser_dump(mrb, tree->car, offset+1);
    break;

  case NODE_SUPER:
    printf("NODE_SUPER:\n");
    if (tree) {
      dump_prefix(tree, offset+1);
      printf("args:\n");
      dump_recur(mrb, tree->car, offset+2);
      if (tree->cdr) {
        dump_prefix(tree, offset+1);
        printf("block:\n");
        mrb_parser_dump(mrb, tree->cdr, offset+2);
      }
    }
    break;

  case NODE_ZSUPER:
    printf("NODE_ZSUPER\n");
    break;

  case NODE_RETURN:
    printf("NODE_RETURN:\n");
    mrb_parser_dump(mrb, tree, offset+1);
    break;

  case NODE_YIELD:
    printf("NODE_YIELD:\n");
    dump_recur(mrb, tree, offset+1);
    break;

  case NODE_BREAK:
    printf("NODE_BREAK:\n");
    mrb_parser_dump(mrb, tree, offset+1);
    break;

  case NODE_NEXT:
    printf("NODE_NEXT:\n");
    mrb_parser_dump(mrb, tree, offset+1);
    break;

  case NODE_REDO:
    printf("NODE_REDO\n");
    break;

  case NODE_RETRY:
    printf("NODE_RETRY\n");
    break;

  case NODE_LVAR:
    printf("NODE_LVAR %s\n", mrb_sym_name(mrb, sym(tree)));
    break;

  case NODE_GVAR:
    printf("NODE_GVAR %s\n", mrb_sym_name(mrb, sym(tree)));
    break;

  case NODE_IVAR:
    printf("NODE_IVAR %s\n", mrb_sym_name(mrb, sym(tree)));
    break;

  case NODE_CVAR:
    printf("NODE_CVAR %s\n", mrb_sym_name(mrb, sym(tree)));
    break;

  case NODE_NVAR:
    printf("NODE_NVAR %d\n", intn(tree));
    break;

  case NODE_CONST:
    printf("NODE_CONST %s\n", mrb_sym_name(mrb, sym(tree)));
    break;

  case NODE_MATCH:
    printf("NODE_MATCH:\n");
    dump_prefix(tree, offset + 1);
    printf("lhs:\n");
    mrb_parser_dump(mrb, tree->car, offset + 2);
    dump_prefix(tree, offset + 1);
    printf("rhs:\n");
    mrb_parser_dump(mrb, tree->cdr, offset + 2);
    break;

  case NODE_BACK_REF:
    printf("NODE_BACK_REF: $%c\n", intn(tree));
    break;

  case NODE_NTH_REF:
    printf("NODE_NTH_REF: $%d\n", intn(tree));
    break;

  case NODE_ARG:
    printf("NODE_ARG %s\n", mrb_sym_name(mrb, sym(tree)));
    break;

  case NODE_BLOCK_ARG:
    printf("NODE_BLOCK_ARG:\n");
    mrb_parser_dump(mrb, tree, offset+1);
    break;

  case NODE_INT:
    printf("NODE_INT %s base %d\n", (char*)tree->car, intn(tree->cdr->car));
    break;

  case NODE_FLOAT:
    printf("NODE_FLOAT %s\n", (char*)tree);
    break;

  case NODE_NEGATE:
    printf("NODE_NEGATE:\n");
    mrb_parser_dump(mrb, tree, offset+1);
    break;

  case NODE_STR:
    printf("NODE_STR %s len %d\n", str_dump(mrb, (char*)tree->car, intn(tree->cdr)), intn(tree->cdr));
    break;

  case NODE_DSTR:
    printf("NODE_DSTR:\n");
    dump_recur(mrb, tree, offset+1);
    break;

  case NODE_XSTR:
    printf("NODE_XSTR %s len %d\n", str_dump(mrb, (char*)tree->car, intn(tree->cdr)), intn(tree->cdr));
    break;

  case NODE_DXSTR:
    printf("NODE_DXSTR:\n");
    dump_recur(mrb, tree, offset+1);
    break;

  case NODE_REGX:
    printf("NODE_REGX /%s/%s\n", (char*)tree->car, (char*)tree->cdr);
    break;

  case NODE_DREGX:
    printf("NODE_DREGX:\n");
    dump_recur(mrb, tree->car, offset+1);
    dump_prefix(tree, offset);
    printf("tail: %s\n", (char*)tree->cdr->cdr->car);
    if (tree->cdr->cdr->cdr->car) {
      dump_prefix(tree, offset);
      printf("opt: %s\n", (char*)tree->cdr->cdr->cdr->car);
    }
    if (tree->cdr->cdr->cdr->cdr) {
      dump_prefix(tree, offset);
      printf("enc: %s\n", (char*)tree->cdr->cdr->cdr->cdr);
    }
    break;

  case NODE_SYM:
    printf("NODE_SYM :%s (%d)\n", mrb_sym_dump(mrb, sym(tree)),
           intn(tree));
    break;

  case NODE_DSYM:
    printf("NODE_DSYM:\n");
    mrb_parser_dump(mrb, tree, offset+1);
    break;

  case NODE_WORDS:
    printf("NODE_WORDS:\n");
    dump_recur(mrb, tree, offset+1);
    break;

  case NODE_SYMBOLS:
    printf("NODE_SYMBOLS:\n");
    dump_recur(mrb, tree, offset+1);
    break;

  case NODE_LITERAL_DELIM:
    printf("NODE_LITERAL_DELIM\n");
    break;

  case NODE_SELF:
    printf("NODE_SELF\n");
    break;

  case NODE_NIL:
    printf("NODE_NIL\n");
    break;

  case NODE_TRUE:
    printf("NODE_TRUE\n");
    break;

  case NODE_FALSE:
    printf("NODE_FALSE\n");
    break;

  case NODE_ALIAS:
    printf("NODE_ALIAS %s %s:\n",
        mrb_sym_dump(mrb, sym(tree->car)),
        mrb_sym_dump(mrb, sym(tree->cdr)));
    break;

  case NODE_UNDEF:
    printf("NODE_UNDEF");
    {
      node *t = tree;
      while (t) {
        printf(" %s", mrb_sym_dump(mrb, sym(t->car)));
        t = t->cdr;
      }
    }
    printf(":\n");
    break;

  case NODE_CLASS:
    printf("NODE_CLASS:\n");
    if (tree->car->car == (node*)0) {
      dump_prefix(tree, offset+1);
      printf(":%s\n", mrb_sym_name(mrb, sym(tree->car->cdr)));
    }
    else if (tree->car->car == (node*)1) {
      dump_prefix(tree, offset+1);
      printf("::%s\n", mrb_sym_name(mrb, sym(tree->car->cdr)));
    }
    else {
      mrb_parser_dump(mrb, tree->car->car, offset+1);
      dump_prefix(tree, offset+1);
      printf("::%s\n", mrb_sym_name(mrb, sym(tree->car->cdr)));
    }
    if (tree->cdr->car) {
      dump_prefix(tree, offset+1);
      printf("super:\n");
      mrb_parser_dump(mrb, tree->cdr->car, offset+2);
    }
    dump_prefix(tree, offset+1);
    printf("body:\n");
    mrb_parser_dump(mrb, tree->cdr->cdr->car->cdr, offset+2);
    break;

  case NODE_MODULE:
    printf("NODE_MODULE:\n");
    if (tree->car->car == (node*)0) {
      dump_prefix(tree, offset+1);
      printf(":%s\n", mrb_sym_name(mrb, sym(tree->car->cdr)));
    }
    else if (tree->car->car == (node*)1) {
      dump_prefix(tree, offset+1);
      printf("::%s\n", mrb_sym_name(mrb, sym(tree->car->cdr)));
    }
    else {
      mrb_parser_dump(mrb, tree->car->car, offset+1);
      dump_prefix(tree, offset+1);
      printf("::%s\n", mrb_sym_name(mrb, sym(tree->car->cdr)));
    }
    dump_prefix(tree, offset+1);
    printf("body:\n");
    mrb_parser_dump(mrb, tree->cdr->car->cdr, offset+2);
    break;

  case NODE_SCLASS:
    printf("NODE_SCLASS:\n");
    mrb_parser_dump(mrb, tree->car, offset+1);
    dump_prefix(tree, offset+1);
    printf("body:\n");
    mrb_parser_dump(mrb, tree->cdr->car->cdr, offset+2);
    break;

  case NODE_DEF:
    printf("NODE_DEF:\n");
    dump_prefix(tree, offset+1);
    printf("%s\n", mrb_sym_dump(mrb, sym(tree->car)));
    tree = tree->cdr;
    {
      node *n2 = tree->car;
      mrb_bool first_lval = TRUE;

      if (n2 && (n2->car || n2->cdr)) {
        dump_prefix(n2, offset+1);
        printf("local variables:\n");
        dump_prefix(n2, offset+2);
        while (n2) {
          if (n2->car) {
            if (!first_lval) printf(", ");
            printf("%s", mrb_sym_name(mrb, sym(n2->car)));
            first_lval = FALSE;
          }
          n2 = n2->cdr;
        }
        printf("\n");
      }
    }
    tree = tree->cdr;
    if (tree->car) {
      dump_args(mrb, tree->car, offset);
    }
    mrb_parser_dump(mrb, tree->cdr->car, offset+1);
    break;

  case NODE_SDEF:
    printf("NODE_SDEF:\n");
    mrb_parser_dump(mrb, tree->car, offset+1);
    tree = tree->cdr;
    dump_prefix(tree, offset+1);
    printf(":%s\n", mrb_sym_dump(mrb, sym(tree->car)));
    tree = tree->cdr->cdr;
    if (tree->car) {
      dump_args(mrb, tree->car, offset+1);
    }
    tree = tree->cdr;
    mrb_parser_dump(mrb, tree->car, offset+1);
    break;

  case NODE_POSTEXE:
    printf("NODE_POSTEXE:\n");
    mrb_parser_dump(mrb, tree, offset+1);
    break;

  case NODE_HEREDOC:
    printf("NODE_HEREDOC (<<%s):\n", ((parser_heredoc_info*)tree)->term);
    dump_recur(mrb, ((parser_heredoc_info*)tree)->doc, offset+1);
    break;

  case NODE_ARGS_TAIL:
    printf("NODE_ARGS_TAIL:\n");
    {
      node *kws = tree->car;

      while (kws) {
        mrb_parser_dump(mrb, kws->car, offset+1);
        kws = kws->cdr;
      }
    }
    tree = tree->cdr;
    if (tree->car) {
      mrb_assert(intn(tree->car->car) == NODE_KW_REST_ARGS);
      mrb_parser_dump(mrb, tree->car, offset+1);
    }
    tree = tree->cdr;
    if (tree->car) {
      dump_prefix(tree, offset+1);
      printf("block='%s'\n", mrb_sym_name(mrb, sym(tree->car)));
    }
    break;

  case NODE_KW_ARG:
    printf("NODE_KW_ARG %s:\n", mrb_sym_name(mrb, sym(tree->car)));
    mrb_parser_dump(mrb, tree->cdr->car, offset + 1);
    break;

  case NODE_KW_REST_ARGS:
    printf("NODE_KW_REST_ARGS %s\n", mrb_sym_name(mrb, sym(tree)));
    break;

  default:
    printf("node type: %d (0x%x)\n", nodetype, (unsigned)nodetype);
    break;
  }
#endif
}
