/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/
#line 4 "../../groonga/lib/grn_ecmascript.lemon"

#ifdef assert
#  undef assert
#endif
#define assert GRN_ASSERT

  static void
  array_literal_add_element(efs_info *efsi)
  {
    grn_ctx *ctx = efsi->ctx;
    grn_expr *e = (grn_expr *)(efsi->e);
    grn_expr_code *code = &(e->codes[e->codes_curr - 1]);
    if (code->op != GRN_OP_PUSH) {
      if (!efsi->array_literal) {
        efsi->array_literal = grn_obj_open(ctx, GRN_VECTOR, 0, GRN_ID_NIL);
      }
      ERR(GRN_FUNCTION_NOT_IMPLEMENTED,
          "complex expression in array literal isn't supported yet: <%.*s>",
          (int)(efsi->str_end - efsi->str), efsi->str);
    }
    if (ctx->rc == GRN_SUCCESS) {
      grn_obj *element = code->value;
      if (!efsi->array_literal) {
        efsi->array_literal = grn_obj_open(ctx,
                                           GRN_VECTOR,
                                           0,
                                           element->header.domain);
        if (!efsi->array_literal) {
          ERR(GRN_NO_MEMORY_AVAILABLE,
              "couldn't create vector for parsing array literal: <%.*s>",
              (int)(efsi->str_end - efsi->str), efsi->str);
        }
      }
      if (efsi->array_literal) {
        grn_vector_add_element_float(ctx,
                                     efsi->array_literal,
                                     GRN_TEXT_VALUE(element),
                                     GRN_TEXT_LEN(element),
                                     0,
                                     element->header.domain);
        if (ctx->rc == GRN_SUCCESS) {
          grn_expr_dfi_pop(e);
          e->codes_curr -= 1;
        }
      }
    }
  }
#line 77 "../../groonga/lib/grn_ecmascript.c"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    grn_expr_parserTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is grn_expr_parserTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    grn_expr_parserARG_SDECL     A static variable declaration for the %extra_argument
**    grn_expr_parserARG_PDECL     A parameter declaration for the %extra_argument
**    grn_expr_parserARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    grn_expr_parserARG_STORE     Code to store %extra_argument into yypParser
**    grn_expr_parserARG_FETCH     Code to extract %extra_argument from yypParser
**    grn_expr_parserCTX_*         As grn_expr_parserARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned char
#define YYNOCODE 114
#define YYACTIONTYPE unsigned short int
#define grn_expr_parserTOKENTYPE  int 
typedef union {
  int yyinit;
  grn_expr_parserTOKENTYPE yy0;
  void * yy217;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define grn_expr_parserARG_SDECL  efs_info *efsi ;
#define grn_expr_parserARG_PDECL , efs_info *efsi 
#define grn_expr_parserARG_PARAM ,efsi 
#define grn_expr_parserARG_FETCH  efs_info *efsi =yypParser->efsi ;
#define grn_expr_parserARG_STORE yypParser->efsi =efsi ;
#define grn_expr_parserCTX_SDECL
#define grn_expr_parserCTX_PDECL
#define grn_expr_parserCTX_PARAM
#define grn_expr_parserCTX_FETCH
#define grn_expr_parserCTX_STORE
#define YYNSTATE             148
#define YYNRULE              134
#define YYNRULE_WITH_ACTION  92
#define YYNTOKEN             77
#define YY_MAX_SHIFT         147
#define YY_MIN_SHIFTREDUCE   230
#define YY_MAX_SHIFTREDUCE   363
#define YY_ERROR_ACTION      364
#define YY_ACCEPT_ACTION     365
#define YY_NO_ACTION         366
#define YY_MIN_REDUCE        367
#define YY_MAX_REDUCE        500
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (1671)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   367,    3,   73,  117,  117,  139,  371,  327,    2,  370,
 /*    10 */    55,   84,  132,    1,  134,   72,  365,   80,  114,   83,
 /*    20 */   376,   80,   76,  114,  114,   91,  129,  128,  142,  141,
 /*    30 */   140,  123,   88,  105,  119,  106,  106,  106,   91,   76,
 /*    40 */   376,  376,   76,   76,  327,   75,  112,   85,   84,  147,
 /*    50 */     9,   28,   72,  436,  484,   67,   66,   54,   53,   52,
 /*    60 */    70,   69,   68,   65,   64,   62,   61,   60,  352,  353,
 /*    70 */   354,  355,  356,    6,  130,   25,  112,  136,   76,  130,
 /*    80 */   130,   91,  129,  128,  142,  141,  140,  123,   88,  105,
 /*    90 */   119,  106,  106,  106,   91,   76,   79,  462,   76,   76,
 /*   100 */    79,  117,  117,  139,  456,  136,  327,    2,  359,   55,
 /*   110 */    84,  132,    1,  374,   72,   79,  121,  495,  139,   79,
 /*   120 */    76,  121,  121,   91,  129,  128,  142,  141,  140,  123,
 /*   130 */    88,  105,  119,  106,  106,  106,   91,   76,   30,   29,
 /*   140 */    76,   76,    7,  304,   63,   78,  350,   74,   71,   59,
 /*   150 */    58,  308,   77,  373,   67,   66,   57,   56,   21,   70,
 /*   160 */    69,   68,   65,   64,   62,   61,   60,  352,  353,  354,
 /*   170 */   355,  356,    6,   51,   50,   49,   48,   47,   46,   45,
 /*   180 */    44,   43,   42,   41,   40,   39,   38,   37,   36,   67,
 /*   190 */    66,  316,   35,   34,   70,   69,   68,   65,   64,   62,
 /*   200 */    61,   60,  352,  353,  354,  355,  356,    6,  113,   27,
 /*   210 */   317,   76,  455,  455,   91,  129,  128,  142,  141,  140,
 /*   220 */   123,   88,  105,  119,  106,  106,  106,   91,   76,  349,
 /*   230 */   372,   76,   76,  238,   23,   27,   27,  369,  450,   76,
 /*   240 */   455,  455,   91,  129,  128,  142,  141,  140,  123,   88,
 /*   250 */   105,  119,  106,  106,  106,   91,   76,  461,  368,   76,
 /*   260 */    76,  297,  298,  496,  321,  133,  452,  307,  135,  320,
 /*   270 */    31,  360,   22,    4,   76,  447,  447,   91,  129,  128,
 /*   280 */   142,  141,  140,  123,   88,  105,  119,  106,  106,  106,
 /*   290 */    91,   76,  300,   33,   76,   76,   32,  366,   24,  366,
 /*   300 */   116,   76,  439,  439,   91,  129,  128,  142,  141,  140,
 /*   310 */   123,   88,  105,  119,  106,  106,  106,   91,   76,  366,
 /*   320 */   121,   76,   76,  118,   76,  121,  121,   91,  129,  128,
 /*   330 */   142,  141,  140,  123,   88,  105,  119,  106,  106,  106,
 /*   340 */    91,   76,  366,  366,   76,   76,  366,  124,  366,  366,
 /*   350 */   366,   76,  124,  124,   91,  129,  128,  142,  141,  140,
 /*   360 */   123,   88,  105,  119,  106,  106,  106,   91,   76,  130,
 /*   370 */   366,   76,   76,   76,  130,  130,   91,  129,  128,  142,
 /*   380 */   141,  140,  123,   88,  105,  119,  106,  106,  106,   91,
 /*   390 */    76,  366,  366,   76,   76,    7,  366,   63,  366,  350,
 /*   400 */    74,   76,  389,  389,   91,  129,  128,  142,  141,  140,
 /*   410 */   123,   88,  105,  119,  106,  106,  106,   91,   76,  366,
 /*   420 */   366,   76,   76,  366,   76,  388,  388,   91,  129,  128,
 /*   430 */   142,  141,  140,  123,   88,  105,  119,  106,  106,  106,
 /*   440 */    91,   76,   67,   66,   76,   76,  460,   70,   69,   68,
 /*   450 */    65,   64,   62,   61,   60,  352,  353,  131,  355,  356,
 /*   460 */     6,    7,   27,   63,  366,  350,   74,   76,  387,  387,
 /*   470 */    91,  129,  128,  142,  141,  140,  123,   88,  105,  119,
 /*   480 */   106,  106,  106,   91,   76,  366,  366,   76,   76,  366,
 /*   490 */    76,  386,  386,   91,  129,  128,  142,  141,  140,  123,
 /*   500 */    88,  105,  119,  106,  106,  106,   91,   76,   67,   66,
 /*   510 */    76,   76,  366,   70,   69,   68,   65,   64,   62,   61,
 /*   520 */    60,  352,  353,  354,  355,  356,    6,   76,  385,  385,
 /*   530 */    91,  129,  128,  142,  141,  140,  123,   88,  105,  119,
 /*   540 */   106,  106,  106,   91,   76,  366,  366,   76,   76,  366,
 /*   550 */    76,  384,  384,   91,  129,  128,  142,  141,  140,  123,
 /*   560 */    88,  105,  119,  106,  106,  106,   91,   76,  366,  366,
 /*   570 */    76,   76,   76,  383,  383,   91,  129,  128,  142,  141,
 /*   580 */   140,  123,   88,  105,  119,  106,  106,  106,   91,   76,
 /*   590 */   366,  366,   76,   76,   76,  382,  382,   91,  129,  128,
 /*   600 */   142,  141,  140,  123,   88,  105,  119,  106,  106,  106,
 /*   610 */    91,   76,  366,  366,   76,   76,   76,  381,  381,   91,
 /*   620 */   129,  128,  142,  141,  140,  123,   88,  105,  119,  106,
 /*   630 */   106,  106,   91,   76,  366,  366,   76,   76,   76,  380,
 /*   640 */   380,   91,  129,  128,  142,  141,  140,  123,   88,  105,
 /*   650 */   119,  106,  106,  106,   91,   76,  366,  366,   76,   76,
 /*   660 */    76,  379,  379,   91,  129,  128,  142,  141,  140,  123,
 /*   670 */    88,  105,  119,  106,  106,  106,   91,   76,  366,  366,
 /*   680 */    76,   76,   76,  448,  448,   91,  129,  128,  142,  141,
 /*   690 */   140,  123,   88,  105,  119,  106,  106,  106,   91,   76,
 /*   700 */   366,  366,   76,   76,   76,  443,  443,   91,  129,  128,
 /*   710 */   142,  141,  140,  123,   88,  105,  119,  106,  106,  106,
 /*   720 */    91,   76,  366,  366,   76,   76,   76,  440,  440,   91,
 /*   730 */   129,  128,  142,  141,  140,  123,   88,  105,  119,  106,
 /*   740 */   106,  106,   91,   76,  366,  366,   76,   76,   76,  390,
 /*   750 */   390,   91,  129,  128,  142,  141,  140,  123,   88,  105,
 /*   760 */   119,  106,  106,  106,   91,   76,  366,  366,   76,   76,
 /*   770 */    76,  146,  146,   91,  129,  128,  142,  141,  140,  123,
 /*   780 */    88,  105,  119,  106,  106,  106,   91,   76,  366,  366,
 /*   790 */    76,   76,   76,  378,  378,   91,  129,  128,  142,  141,
 /*   800 */   140,  123,   88,  105,  119,  106,  106,  106,   91,   76,
 /*   810 */   366,  366,   76,   76,   76,  377,  377,   91,  129,  128,
 /*   820 */   142,  141,  140,  123,   88,  105,  119,  106,  106,  106,
 /*   830 */    91,   76,  366,   76,   76,   76,  125,  366,  115,  142,
 /*   840 */   141,  140,  123,   88,  105,  119,  106,  106,  106,  125,
 /*   850 */    76,  366,  366,   76,   76,   76,  366,    5,  125,  366,
 /*   860 */   366,  137,  141,  140,  123,   88,  105,  119,  106,  106,
 /*   870 */   106,  125,   76,  366,  366,   76,   76,   76,  366,  366,
 /*   880 */   125,  366,  366,  145,  141,  140,  123,   88,  105,  119,
 /*   890 */   106,  106,  106,  125,   76,  366,  366,   76,   76,   76,
 /*   900 */   366,  366,  125,  366,  366,  366,  144,  140,  123,   88,
 /*   910 */   105,  119,  106,  106,  106,  125,   76,  366,   76,   76,
 /*   920 */    76,  125,    8,  366,  138,  366,  143,  123,   88,  105,
 /*   930 */   119,  106,  106,  106,  125,   76,  366,  366,   76,   76,
 /*   940 */   366,  366,  366,  366,   26,   20,   19,   18,   17,   16,
 /*   950 */    15,   14,   13,   12,   11,   10,   76,  366,  366,  125,
 /*   960 */   366,  366,  366,  366,  366,  127,   88,  105,  119,  106,
 /*   970 */   106,  106,  125,   76,  366,  366,   76,   76,  366,  366,
 /*   980 */   366,  366,   76,  366,  366,  125,  366,  366,  297,  298,
 /*   990 */   366,  366,   89,  105,  119,  106,  106,  106,  125,   76,
 /*  1000 */   366,   76,   76,   76,  125,  366,  366,  366,  366,  366,
 /*  1010 */   366,   90,  105,  119,  106,  106,  106,  125,   76,  366,
 /*  1020 */   366,   76,   76,  366,  366,   87,   86,   82,   81,  327,
 /*  1030 */    75,  328,   85,   84,  147,    9,  459,   72,  366,   87,
 /*  1040 */    86,   82,   81,  327,   75,  366,   85,   84,  147,    9,
 /*  1050 */    76,   72,  366,  125,  366,  366,  366,  366,  366,  366,
 /*  1060 */   366,   92,  119,  106,  106,  106,  125,   76,  366,  366,
 /*  1070 */    76,   76,  366,   76,  366,  366,  125,  366,  366,  366,
 /*  1080 */   366,  366,  366,  366,   93,  119,  106,  106,  106,  125,
 /*  1090 */    76,  366,  366,   76,   76,  366,   76,  366,  366,  125,
 /*  1100 */   366,  366,  366,  366,  366,  366,  366,   94,  119,  106,
 /*  1110 */   106,  106,  125,   76,  366,   76,   76,   76,  125,    7,
 /*  1120 */   366,  366,  366,  350,   74,  366,   95,  119,  106,  106,
 /*  1130 */   106,  125,   76,  366,   76,   76,   76,  125,  366,  366,
 /*  1140 */   366,  366,  366,  366,  366,   96,  119,  106,  106,  106,
 /*  1150 */   125,   76,  366,  366,   76,   76,   76,  366,  366,  125,
 /*  1160 */   366,  366,  366,  366,  366,  366,  366,   97,  119,  106,
 /*  1170 */   106,  106,  125,   76,  366,   76,   76,   76,  125,  352,
 /*  1180 */   353,  354,  355,  356,    6,  366,   98,  119,  106,  106,
 /*  1190 */   106,  125,   76,  366,   76,   76,   76,  125,  366,  366,
 /*  1200 */   366,  366,  366,  366,  366,   99,  119,  106,  106,  106,
 /*  1210 */   125,   76,  366,   76,   76,   76,  125,  366,  366,  366,
 /*  1220 */   366,  366,  366,  366,  100,  119,  106,  106,  106,  125,
 /*  1230 */    76,  366,   76,   76,   76,  125,  366,  366,  366,  366,
 /*  1240 */   366,  366,  366,  101,  119,  106,  106,  106,  125,   76,
 /*  1250 */   366,  366,   76,   76,   76,  366,  366,  125,  366,  366,
 /*  1260 */   366,  366,  366,  366,  366,  102,  119,  106,  106,  106,
 /*  1270 */   125,   76,  366,   76,   76,   76,  125,  366,  366,  366,
 /*  1280 */   366,  366,  366,  366,  103,  119,  106,  106,  106,  125,
 /*  1290 */    76,  366,   76,   76,   76,  125,  366,  366,  366,  366,
 /*  1300 */   366,  366,  366,  104,  119,  106,  106,  106,  125,   76,
 /*  1310 */   366,   76,   76,   76,  125,  366,  366,  366,  366,  366,
 /*  1320 */   366,  366,  107,  119,  106,  106,  106,  125,   76,  366,
 /*  1330 */    76,   76,   76,  125,  366,  366,  366,  366,  366,  366,
 /*  1340 */   366,  109,  119,  106,  106,  106,  125,   76,  366,  366,
 /*  1350 */    76,   76,   76,  366,  366,  125,  366,  366,  366,  366,
 /*  1360 */   366,  366,  366,  111,  119,  106,  106,  106,  125,   76,
 /*  1370 */   366,   76,   76,   76,  125,  366,  366,  366,  366,  366,
 /*  1380 */   366,  366,  366,  120,  106,  106,  106,  125,   76,  366,
 /*  1390 */    76,   76,   76,  125,  366,  366,  366,  366,  366,  366,
 /*  1400 */   366,  366,  122,  106,  106,  106,  125,   76,  366,   76,
 /*  1410 */    76,   76,  125,  366,  366,  366,  372,   76,  366,  366,
 /*  1420 */   125,  126,  106,  106,  106,  125,   76,  366,  366,   76,
 /*  1430 */    76,  430,  430,  125,   76,  366,   76,   76,   76,  125,
 /*  1440 */   366,  366,  366,  366,  366,  366,  366,  366,  366,  108,
 /*  1450 */   108,  108,  125,   76,  366,  366,   76,   76,   76,  366,
 /*  1460 */   366,  125,  366,  366,  366,  366,  366,  366,  366,  366,
 /*  1470 */   366,  110,  110,  110,  125,   76,  366,   76,   76,   76,
 /*  1480 */   125,  366,  366,  366,  366,  366,  366,   76,  366,  366,
 /*  1490 */   125,  422,  422,  125,   76,  366,   76,   76,   76,  125,
 /*  1500 */   366,  421,  421,  125,   76,  366,   76,   76,   76,  125,
 /*  1510 */   433,  433,  125,   76,  366,   76,   76,   76,  125,  366,
 /*  1520 */   432,  432,  125,   76,  366,  366,   76,   76,  366,  431,
 /*  1530 */   431,  125,   76,  366,   76,   76,   76,  125,  366,  366,
 /*  1540 */   366,  366,   76,  366,  366,  125,  366,  366,  430,  430,
 /*  1550 */   125,   76,  366,  366,   76,   76,  429,  429,  125,   76,
 /*  1560 */   366,  366,   76,   76,   76,  366,  366,  125,  366,  366,
 /*  1570 */   366,  366,   76,  366,  366,  125,  366,  366,  428,  428,
 /*  1580 */   125,   76,  366,  366,   76,   76,  427,  427,  125,   76,
 /*  1590 */   366,   76,   76,   76,  125,  366,  366,  366,  366,  366,
 /*  1600 */    76,  366,  366,  125,  366,  426,  426,  125,   76,  366,
 /*  1610 */   366,   76,   76,  366,  425,  425,  125,   76,  366,   76,
 /*  1620 */    76,   76,  125,  366,  366,  366,  366,   76,  366,  366,
 /*  1630 */   125,  366,  366,  424,  424,  125,   76,  366,  366,   76,
 /*  1640 */    76,  423,  423,  125,   76,  366,  366,   76,   76,   76,
 /*  1650 */   366,  366,  125,  366,  366,  366,  366,  366,  366,  366,
 /*  1660 */   366,  366,  366,  420,  420,  125,   76,  366,  366,   76,
 /*  1670 */    76,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    83,    1,    2,  107,  108,  109,   83,    7,    8,   83,
 /*    10 */    10,   11,   12,   13,   12,   15,   78,   79,   80,   11,
 /*    20 */    84,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*    30 */    92,   93,   94,   95,   96,   97,   98,   99,  100,  101,
 /*    40 */   104,  105,  104,  105,    7,    8,   82,   10,   11,   12,
 /*    50 */    13,    5,   15,  102,  103,   55,   56,   52,   53,   54,
 /*    60 */    60,   61,   62,   63,   64,   65,   66,   67,   68,   69,
 /*    70 */    70,   71,   72,   73,   80,   29,  112,  113,   84,   85,
 /*    80 */    86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*    90 */    96,   97,   98,   99,  100,  101,   79,    0,  104,  105,
 /*   100 */    83,  107,  108,  109,  112,  113,    7,    8,   70,   10,
 /*   110 */    11,   12,   13,   83,   15,   79,   80,  108,  109,   83,
 /*   120 */    84,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*   130 */    94,   95,   96,   97,   98,   99,  100,  101,    3,    4,
 /*   140 */   104,  105,    8,   14,   10,   16,   12,   13,   57,   58,
 /*   150 */    59,    9,   55,   83,   55,   56,   55,   56,   16,   60,
 /*   160 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   170 */    71,   72,   73,   36,   37,   38,   39,   40,   41,   42,
 /*   180 */    43,   44,   45,   46,   47,   48,   49,   50,   51,   55,
 /*   190 */    56,   57,   34,   35,   60,   61,   62,   63,   64,   65,
 /*   200 */    66,   67,   68,   69,   70,   71,   72,   73,   81,   16,
 /*   210 */    76,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*   220 */    93,   94,   95,   96,   97,   98,   99,  100,  101,    9,
 /*   230 */    83,  104,  105,   14,   16,   16,   16,   83,  111,   84,
 /*   240 */    85,   86,   87,   88,   89,   90,   91,   92,   93,   94,
 /*   250 */    95,   96,   97,   98,   99,  100,  101,    0,   83,  104,
 /*   260 */   105,   61,   62,   30,   70,   41,  111,   74,   57,   68,
 /*   270 */    31,   12,   30,   16,   84,   85,   86,   87,   88,   89,
 /*   280 */    90,   91,   92,   93,   94,   95,   96,   97,   98,   99,
 /*   290 */   100,  101,   74,   33,  104,  105,   32,  114,   30,  114,
 /*   300 */   110,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*   310 */    93,   94,   95,   96,   97,   98,   99,  100,  101,  114,
 /*   320 */    80,  104,  105,  106,   84,   85,   86,   87,   88,   89,
 /*   330 */    90,   91,   92,   93,   94,   95,   96,   97,   98,   99,
 /*   340 */   100,  101,  114,  114,  104,  105,  114,   80,  114,  114,
 /*   350 */   114,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*   360 */    93,   94,   95,   96,   97,   98,   99,  100,  101,   80,
 /*   370 */   114,  104,  105,   84,   85,   86,   87,   88,   89,   90,
 /*   380 */    91,   92,   93,   94,   95,   96,   97,   98,   99,  100,
 /*   390 */   101,  114,  114,  104,  105,    8,  114,   10,  114,   12,
 /*   400 */    13,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*   410 */    93,   94,   95,   96,   97,   98,   99,  100,  101,  114,
 /*   420 */   114,  104,  105,  114,   84,   85,   86,   87,   88,   89,
 /*   430 */    90,   91,   92,   93,   94,   95,   96,   97,   98,   99,
 /*   440 */   100,  101,   55,   56,  104,  105,    0,   60,   61,   62,
 /*   450 */    63,   64,   65,   66,   67,   68,   69,   70,   71,   72,
 /*   460 */    73,    8,   16,   10,  114,   12,   13,   84,   85,   86,
 /*   470 */    87,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*   480 */    97,   98,   99,  100,  101,  114,  114,  104,  105,  114,
 /*   490 */    84,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*   500 */    94,   95,   96,   97,   98,   99,  100,  101,   55,   56,
 /*   510 */   104,  105,  114,   60,   61,   62,   63,   64,   65,   66,
 /*   520 */    67,   68,   69,   70,   71,   72,   73,   84,   85,   86,
 /*   530 */    87,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*   540 */    97,   98,   99,  100,  101,  114,  114,  104,  105,  114,
 /*   550 */    84,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*   560 */    94,   95,   96,   97,   98,   99,  100,  101,  114,  114,
 /*   570 */   104,  105,   84,   85,   86,   87,   88,   89,   90,   91,
 /*   580 */    92,   93,   94,   95,   96,   97,   98,   99,  100,  101,
 /*   590 */   114,  114,  104,  105,   84,   85,   86,   87,   88,   89,
 /*   600 */    90,   91,   92,   93,   94,   95,   96,   97,   98,   99,
 /*   610 */   100,  101,  114,  114,  104,  105,   84,   85,   86,   87,
 /*   620 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*   630 */    98,   99,  100,  101,  114,  114,  104,  105,   84,   85,
 /*   640 */    86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*   650 */    96,   97,   98,   99,  100,  101,  114,  114,  104,  105,
 /*   660 */    84,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*   670 */    94,   95,   96,   97,   98,   99,  100,  101,  114,  114,
 /*   680 */   104,  105,   84,   85,   86,   87,   88,   89,   90,   91,
 /*   690 */    92,   93,   94,   95,   96,   97,   98,   99,  100,  101,
 /*   700 */   114,  114,  104,  105,   84,   85,   86,   87,   88,   89,
 /*   710 */    90,   91,   92,   93,   94,   95,   96,   97,   98,   99,
 /*   720 */   100,  101,  114,  114,  104,  105,   84,   85,   86,   87,
 /*   730 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*   740 */    98,   99,  100,  101,  114,  114,  104,  105,   84,   85,
 /*   750 */    86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*   760 */    96,   97,   98,   99,  100,  101,  114,  114,  104,  105,
 /*   770 */    84,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*   780 */    94,   95,   96,   97,   98,   99,  100,  101,  114,  114,
 /*   790 */   104,  105,   84,   85,   86,   87,   88,   89,   90,   91,
 /*   800 */    92,   93,   94,   95,   96,   97,   98,   99,  100,  101,
 /*   810 */   114,  114,  104,  105,   84,   85,   86,   87,   88,   89,
 /*   820 */    90,   91,   92,   93,   94,   95,   96,   97,   98,   99,
 /*   830 */   100,  101,  114,   84,  104,  105,   87,  114,   89,   90,
 /*   840 */    91,   92,   93,   94,   95,   96,   97,   98,   99,  100,
 /*   850 */   101,  114,  114,  104,  105,   84,  114,    8,   87,  114,
 /*   860 */   114,   90,   91,   92,   93,   94,   95,   96,   97,   98,
 /*   870 */    99,  100,  101,  114,  114,  104,  105,   84,  114,  114,
 /*   880 */    87,  114,  114,   90,   91,   92,   93,   94,   95,   96,
 /*   890 */    97,   98,   99,  100,  101,  114,  114,  104,  105,   84,
 /*   900 */   114,  114,   87,  114,  114,  114,   91,   92,   93,   94,
 /*   910 */    95,   96,   97,   98,   99,  100,  101,  114,   84,  104,
 /*   920 */   105,   87,   73,  114,   75,  114,   92,   93,   94,   95,
 /*   930 */    96,   97,   98,   99,  100,  101,  114,  114,  104,  105,
 /*   940 */   114,  114,  114,  114,   17,   18,   19,   20,   21,   22,
 /*   950 */    23,   24,   25,   26,   27,   28,   84,  114,  114,   87,
 /*   960 */   114,  114,  114,  114,  114,   93,   94,   95,   96,   97,
 /*   970 */    98,   99,  100,  101,  114,  114,  104,  105,  114,  114,
 /*   980 */   114,  114,   84,  114,  114,   87,  114,  114,   61,   62,
 /*   990 */   114,  114,   94,   95,   96,   97,   98,   99,  100,  101,
 /*  1000 */   114,   84,  104,  105,   87,  114,  114,  114,  114,  114,
 /*  1010 */   114,   94,   95,   96,   97,   98,   99,  100,  101,  114,
 /*  1020 */   114,  104,  105,  114,  114,    3,    4,    5,    6,    7,
 /*  1030 */     8,    9,   10,   11,   12,   13,    0,   15,  114,    3,
 /*  1040 */     4,    5,    6,    7,    8,  114,   10,   11,   12,   13,
 /*  1050 */    84,   15,  114,   87,  114,  114,  114,  114,  114,  114,
 /*  1060 */   114,   95,   96,   97,   98,   99,  100,  101,  114,  114,
 /*  1070 */   104,  105,  114,   84,  114,  114,   87,  114,  114,  114,
 /*  1080 */   114,  114,  114,  114,   95,   96,   97,   98,   99,  100,
 /*  1090 */   101,  114,  114,  104,  105,  114,   84,  114,  114,   87,
 /*  1100 */   114,  114,  114,  114,  114,  114,  114,   95,   96,   97,
 /*  1110 */    98,   99,  100,  101,  114,   84,  104,  105,   87,    8,
 /*  1120 */   114,  114,  114,   12,   13,  114,   95,   96,   97,   98,
 /*  1130 */    99,  100,  101,  114,   84,  104,  105,   87,  114,  114,
 /*  1140 */   114,  114,  114,  114,  114,   95,   96,   97,   98,   99,
 /*  1150 */   100,  101,  114,  114,  104,  105,   84,  114,  114,   87,
 /*  1160 */   114,  114,  114,  114,  114,  114,  114,   95,   96,   97,
 /*  1170 */    98,   99,  100,  101,  114,   84,  104,  105,   87,   68,
 /*  1180 */    69,   70,   71,   72,   73,  114,   95,   96,   97,   98,
 /*  1190 */    99,  100,  101,  114,   84,  104,  105,   87,  114,  114,
 /*  1200 */   114,  114,  114,  114,  114,   95,   96,   97,   98,   99,
 /*  1210 */   100,  101,  114,   84,  104,  105,   87,  114,  114,  114,
 /*  1220 */   114,  114,  114,  114,   95,   96,   97,   98,   99,  100,
 /*  1230 */   101,  114,   84,  104,  105,   87,  114,  114,  114,  114,
 /*  1240 */   114,  114,  114,   95,   96,   97,   98,   99,  100,  101,
 /*  1250 */   114,  114,  104,  105,   84,  114,  114,   87,  114,  114,
 /*  1260 */   114,  114,  114,  114,  114,   95,   96,   97,   98,   99,
 /*  1270 */   100,  101,  114,   84,  104,  105,   87,  114,  114,  114,
 /*  1280 */   114,  114,  114,  114,   95,   96,   97,   98,   99,  100,
 /*  1290 */   101,  114,   84,  104,  105,   87,  114,  114,  114,  114,
 /*  1300 */   114,  114,  114,   95,   96,   97,   98,   99,  100,  101,
 /*  1310 */   114,   84,  104,  105,   87,  114,  114,  114,  114,  114,
 /*  1320 */   114,  114,   95,   96,   97,   98,   99,  100,  101,  114,
 /*  1330 */    84,  104,  105,   87,  114,  114,  114,  114,  114,  114,
 /*  1340 */   114,   95,   96,   97,   98,   99,  100,  101,  114,  114,
 /*  1350 */   104,  105,   84,  114,  114,   87,  114,  114,  114,  114,
 /*  1360 */   114,  114,  114,   95,   96,   97,   98,   99,  100,  101,
 /*  1370 */   114,   84,  104,  105,   87,  114,  114,  114,  114,  114,
 /*  1380 */   114,  114,  114,   96,   97,   98,   99,  100,  101,  114,
 /*  1390 */    84,  104,  105,   87,  114,  114,  114,  114,  114,  114,
 /*  1400 */   114,  114,   96,   97,   98,   99,  100,  101,  114,   84,
 /*  1410 */   104,  105,   87,  114,  114,  114,   83,   84,  114,  114,
 /*  1420 */    87,   96,   97,   98,   99,  100,  101,  114,  114,  104,
 /*  1430 */   105,   98,   99,  100,  101,  114,   84,  104,  105,   87,
 /*  1440 */   114,  114,  114,  114,  114,  114,  114,  114,  114,   97,
 /*  1450 */    98,   99,  100,  101,  114,  114,  104,  105,   84,  114,
 /*  1460 */   114,   87,  114,  114,  114,  114,  114,  114,  114,  114,
 /*  1470 */   114,   97,   98,   99,  100,  101,  114,   84,  104,  105,
 /*  1480 */    87,  114,  114,  114,  114,  114,  114,   84,  114,  114,
 /*  1490 */    87,   98,   99,  100,  101,  114,   84,  104,  105,   87,
 /*  1500 */   114,   98,   99,  100,  101,  114,   84,  104,  105,   87,
 /*  1510 */    98,   99,  100,  101,  114,   84,  104,  105,   87,  114,
 /*  1520 */    98,   99,  100,  101,  114,  114,  104,  105,  114,   98,
 /*  1530 */    99,  100,  101,  114,   84,  104,  105,   87,  114,  114,
 /*  1540 */   114,  114,   84,  114,  114,   87,  114,  114,   98,   99,
 /*  1550 */   100,  101,  114,  114,  104,  105,   98,   99,  100,  101,
 /*  1560 */   114,  114,  104,  105,   84,  114,  114,   87,  114,  114,
 /*  1570 */   114,  114,   84,  114,  114,   87,  114,  114,   98,   99,
 /*  1580 */   100,  101,  114,  114,  104,  105,   98,   99,  100,  101,
 /*  1590 */   114,   84,  104,  105,   87,  114,  114,  114,  114,  114,
 /*  1600 */    84,  114,  114,   87,  114,   98,   99,  100,  101,  114,
 /*  1610 */   114,  104,  105,  114,   98,   99,  100,  101,  114,   84,
 /*  1620 */   104,  105,   87,  114,  114,  114,  114,   84,  114,  114,
 /*  1630 */    87,  114,  114,   98,   99,  100,  101,  114,  114,  104,
 /*  1640 */   105,   98,   99,  100,  101,  114,  114,  104,  105,   84,
 /*  1650 */   114,  114,   87,  114,  114,  114,  114,  114,  114,  114,
 /*  1660 */   114,  114,  114,   98,   99,  100,  101,  114,  114,  104,
 /*  1670 */   105,   77,   77,   77,   77,   77,   77,   77,   77,   77,
 /*  1680 */    77,   77,   77,   77,   77,   77,   77,   77,   77,   77,
 /*  1690 */    77,   77,   77,   77,   77,   77,   77,   77,   77,   77,
 /*  1700 */    77,   77,   77,   77,   77,   77,   77,   77,   77,   77,
 /*  1710 */    77,   77,   77,   77,   77,   77,   77,   77,   77,   77,
 /*  1720 */    77,   77,   77,   77,   77,   77,   77,   77,   77,   77,
 /*  1730 */    77,   77,   77,   77,   77,   77,   77,   77,   77,   77,
 /*  1740 */    77,   77,   77,   77,   77,   77,   77,   77,
};
#define YY_SHIFT_COUNT    (147)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1111)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */     0,  387,   99,  134,  134,  453,  453,  453,  453,  453,
 /*    10 */   453,  453,  453,  453,  453,  453,  453,  453,  453,  453,
 /*    20 */   453,  453,  453,  453,  453,  453,  453,  453,  453,  453,
 /*    30 */   453,  453,  453,  453,  453,  453,  453,  453,  453,  453,
 /*    40 */   453,  453,  453,  453,  453,  453,  453,  453,  453,  453,
 /*    50 */   453,  453,  453,  453,  453,   99,  453,  453,  453,  453,
 /*    60 */   453,  453,  453,  453,  453,  453,  453,  453,  453,  453,
 /*    70 */   453,  453, 1111,    2,   38,   37,  849,    2,   38, 1022,
 /*    80 */  1036,   37,   37,   37,   37,   37,   37,   37,  137,  137,
 /*    90 */   137,  927,    5,    5,    5,    5,    5,    5,    5,    5,
 /*   100 */     5,    5,    5,    5,    5,    5,   91,    5,   91,    5,
 /*   110 */    91,    5,   97,  257,  446,  135,  142,  129,  218,  101,
 /*   120 */   101,  220,  101,  158,  193,  200,  101,  158,  135,   46,
 /*   130 */   219,  233,    8,  194,  224,  201,  211,  239,  259,  242,
 /*   140 */   260,  264,  239,  260,  264,  239,  268,    8,
};
#define YY_REDUCE_COUNT (87)
#define YY_REDUCE_MIN   (-104)
#define YY_REDUCE_MAX   (1565)
static const short yy_reduce_ofst[] = {
 /*     0 */   -62,   -6,   36,  127,  155,  190,  217,  240,  267,  289,
 /*    10 */   317,  340,  383,  406,  443,  466,  488,  510,  532,  554,
 /*    20 */   576,  598,  620,  642,  664,  686,  708,  730,  749,  771,
 /*    30 */   793,  815,  834,  872,  898,  917,  966,  989, 1012, 1031,
 /*    40 */  1050, 1072, 1091, 1110, 1129, 1148, 1170, 1189, 1208, 1227,
 /*    50 */  1246, 1268, 1287, 1306, 1325, 1333, 1352, 1374, 1393, 1403,
 /*    60 */  1412, 1422, 1431, 1450, 1458, 1480, 1488, 1507, 1516, 1535,
 /*    70 */  1543, 1565,  -64,  -36, -104,   17,  -49,   -8,    9,  -83,
 /*    80 */   -83,  -77,  -74,   30,   70,  147,  154,  175,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   364,  442,  364,  449,  451,  446,  438,  364,  364,  364,
 /*    10 */   364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
 /*    20 */   364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
 /*    30 */   364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
 /*    40 */   364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
 /*    50 */   364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
 /*    60 */   364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
 /*    70 */   364,  364,  364,  498,  442,  364,  482,  364,  364,  364,
 /*    80 */   364,  364,  364,  364,  364,  364,  364,  364,  474,  398,
 /*    90 */   397,  480,  414,  413,  412,  411,  410,  409,  408,  407,
 /*   100 */   406,  405,  404,  403,  402,  475,  477,  401,  419,  400,
 /*   110 */   418,  399,  364,  364,  364,  391,  364,  364,  364,  476,
 /*   120 */   417,  364,  416,  473,  364,  480,  415,  396,  469,  468,
 /*   130 */   364,  491,  487,  364,  364,  364,  500,  393,  364,  364,
 /*   140 */   472,  471,  470,  395,  394,  392,  364,  364,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  grn_expr_parserARG_SDECL                /* A place to hold %extra_argument */
  grn_expr_parserCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void grn_expr_parserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "START_OUTPUT_COLUMNS",
  /*    2 */ "START_ADJUSTER",
  /*    3 */ "LOGICAL_AND",
  /*    4 */ "LOGICAL_AND_NOT",
  /*    5 */ "LOGICAL_OR",
  /*    6 */ "NEGATIVE",
  /*    7 */ "QSTRING",
  /*    8 */ "PARENL",
  /*    9 */ "PARENR",
  /*   10 */ "ADJUST",
  /*   11 */ "RELATIVE_OP",
  /*   12 */ "IDENTIFIER",
  /*   13 */ "BRACEL",
  /*   14 */ "BRACER",
  /*   15 */ "EVAL",
  /*   16 */ "COMMA",
  /*   17 */ "ASSIGN",
  /*   18 */ "STAR_ASSIGN",
  /*   19 */ "SLASH_ASSIGN",
  /*   20 */ "MOD_ASSIGN",
  /*   21 */ "PLUS_ASSIGN",
  /*   22 */ "MINUS_ASSIGN",
  /*   23 */ "SHIFTL_ASSIGN",
  /*   24 */ "SHIFTR_ASSIGN",
  /*   25 */ "SHIFTRR_ASSIGN",
  /*   26 */ "AND_ASSIGN",
  /*   27 */ "XOR_ASSIGN",
  /*   28 */ "OR_ASSIGN",
  /*   29 */ "QUESTION",
  /*   30 */ "COLON",
  /*   31 */ "BITWISE_OR",
  /*   32 */ "BITWISE_XOR",
  /*   33 */ "BITWISE_AND",
  /*   34 */ "EQUAL",
  /*   35 */ "NOT_EQUAL",
  /*   36 */ "LESS",
  /*   37 */ "GREATER",
  /*   38 */ "LESS_EQUAL",
  /*   39 */ "GREATER_EQUAL",
  /*   40 */ "IN",
  /*   41 */ "MATCH",
  /*   42 */ "NEAR",
  /*   43 */ "NEAR2",
  /*   44 */ "NEAR_PHRASE",
  /*   45 */ "SIMILAR",
  /*   46 */ "TERM_EXTRACT",
  /*   47 */ "QUORUM",
  /*   48 */ "LCP",
  /*   49 */ "PREFIX",
  /*   50 */ "SUFFIX",
  /*   51 */ "REGEXP",
  /*   52 */ "SHIFTL",
  /*   53 */ "SHIFTR",
  /*   54 */ "SHIFTRR",
  /*   55 */ "PLUS",
  /*   56 */ "MINUS",
  /*   57 */ "STAR",
  /*   58 */ "SLASH",
  /*   59 */ "MOD",
  /*   60 */ "DELETE",
  /*   61 */ "INCR",
  /*   62 */ "DECR",
  /*   63 */ "NOT",
  /*   64 */ "BITWISE_NOT",
  /*   65 */ "EXACT",
  /*   66 */ "PARTIAL",
  /*   67 */ "UNSPLIT",
  /*   68 */ "DECIMAL",
  /*   69 */ "HEX_INTEGER",
  /*   70 */ "STRING",
  /*   71 */ "BOOLEAN",
  /*   72 */ "NULL",
  /*   73 */ "BRACKETL",
  /*   74 */ "BRACKETR",
  /*   75 */ "DOT",
  /*   76 */ "NONEXISTENT_COLUMN",
  /*   77 */ "suppress_unused_variable_warning",
  /*   78 */ "input",
  /*   79 */ "query",
  /*   80 */ "expression",
  /*   81 */ "output_columns",
  /*   82 */ "adjuster",
  /*   83 */ "query_element",
  /*   84 */ "primary_expression",
  /*   85 */ "assignment_expression",
  /*   86 */ "conditional_expression",
  /*   87 */ "lefthand_side_expression",
  /*   88 */ "logical_or_expression",
  /*   89 */ "logical_and_expression",
  /*   90 */ "bitwise_or_expression",
  /*   91 */ "bitwise_xor_expression",
  /*   92 */ "bitwise_and_expression",
  /*   93 */ "equality_expression",
  /*   94 */ "relational_expression",
  /*   95 */ "shift_expression",
  /*   96 */ "additive_expression",
  /*   97 */ "multiplicative_expression",
  /*   98 */ "unary_expression",
  /*   99 */ "postfix_expression",
  /*  100 */ "call_expression",
  /*  101 */ "member_expression",
  /*  102 */ "arguments",
  /*  103 */ "member_expression_part",
  /*  104 */ "object_literal",
  /*  105 */ "array_literal",
  /*  106 */ "element_list",
  /*  107 */ "property_name_and_value_list",
  /*  108 */ "property_name_and_value",
  /*  109 */ "property_name",
  /*  110 */ "argument_list",
  /*  111 */ "output_column",
  /*  112 */ "adjust_expression",
  /*  113 */ "adjust_match_expression",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "query ::= query query_element",
 /*   1 */ "query ::= query LOGICAL_AND query_element",
 /*   2 */ "query ::= query LOGICAL_AND_NOT query_element",
 /*   3 */ "query ::= query LOGICAL_OR query_element",
 /*   4 */ "query ::= query NEGATIVE query_element",
 /*   5 */ "query_element ::= ADJUST query_element",
 /*   6 */ "query_element ::= RELATIVE_OP query_element",
 /*   7 */ "query_element ::= IDENTIFIER RELATIVE_OP query_element",
 /*   8 */ "query_element ::= BRACEL expression BRACER",
 /*   9 */ "query_element ::= EVAL primary_expression",
 /*  10 */ "expression ::= expression COMMA assignment_expression",
 /*  11 */ "assignment_expression ::= lefthand_side_expression ASSIGN assignment_expression",
 /*  12 */ "assignment_expression ::= lefthand_side_expression STAR_ASSIGN assignment_expression",
 /*  13 */ "assignment_expression ::= lefthand_side_expression SLASH_ASSIGN assignment_expression",
 /*  14 */ "assignment_expression ::= lefthand_side_expression MOD_ASSIGN assignment_expression",
 /*  15 */ "assignment_expression ::= lefthand_side_expression PLUS_ASSIGN assignment_expression",
 /*  16 */ "assignment_expression ::= lefthand_side_expression MINUS_ASSIGN assignment_expression",
 /*  17 */ "assignment_expression ::= lefthand_side_expression SHIFTL_ASSIGN assignment_expression",
 /*  18 */ "assignment_expression ::= lefthand_side_expression SHIFTR_ASSIGN assignment_expression",
 /*  19 */ "assignment_expression ::= lefthand_side_expression SHIFTRR_ASSIGN assignment_expression",
 /*  20 */ "assignment_expression ::= lefthand_side_expression AND_ASSIGN assignment_expression",
 /*  21 */ "assignment_expression ::= lefthand_side_expression XOR_ASSIGN assignment_expression",
 /*  22 */ "assignment_expression ::= lefthand_side_expression OR_ASSIGN assignment_expression",
 /*  23 */ "conditional_expression ::= logical_or_expression QUESTION assignment_expression COLON assignment_expression",
 /*  24 */ "logical_or_expression ::= logical_or_expression LOGICAL_OR logical_and_expression",
 /*  25 */ "logical_and_expression ::= logical_and_expression LOGICAL_AND bitwise_or_expression",
 /*  26 */ "logical_and_expression ::= logical_and_expression LOGICAL_AND_NOT bitwise_or_expression",
 /*  27 */ "bitwise_or_expression ::= bitwise_or_expression BITWISE_OR bitwise_xor_expression",
 /*  28 */ "bitwise_xor_expression ::= bitwise_xor_expression BITWISE_XOR bitwise_and_expression",
 /*  29 */ "bitwise_and_expression ::= bitwise_and_expression BITWISE_AND equality_expression",
 /*  30 */ "equality_expression ::= equality_expression EQUAL relational_expression",
 /*  31 */ "equality_expression ::= equality_expression NOT_EQUAL relational_expression",
 /*  32 */ "relational_expression ::= relational_expression LESS shift_expression",
 /*  33 */ "relational_expression ::= relational_expression GREATER shift_expression",
 /*  34 */ "relational_expression ::= relational_expression LESS_EQUAL shift_expression",
 /*  35 */ "relational_expression ::= relational_expression GREATER_EQUAL shift_expression",
 /*  36 */ "relational_expression ::= relational_expression IN shift_expression",
 /*  37 */ "relational_expression ::= relational_expression MATCH shift_expression",
 /*  38 */ "relational_expression ::= relational_expression NEAR shift_expression",
 /*  39 */ "relational_expression ::= relational_expression NEAR2 shift_expression",
 /*  40 */ "relational_expression ::= relational_expression NEAR_PHRASE shift_expression",
 /*  41 */ "relational_expression ::= relational_expression SIMILAR shift_expression",
 /*  42 */ "relational_expression ::= relational_expression TERM_EXTRACT shift_expression",
 /*  43 */ "relational_expression ::= relational_expression QUORUM shift_expression",
 /*  44 */ "relational_expression ::= relational_expression LCP shift_expression",
 /*  45 */ "relational_expression ::= relational_expression PREFIX shift_expression",
 /*  46 */ "relational_expression ::= relational_expression SUFFIX shift_expression",
 /*  47 */ "relational_expression ::= relational_expression REGEXP shift_expression",
 /*  48 */ "shift_expression ::= shift_expression SHIFTL additive_expression",
 /*  49 */ "shift_expression ::= shift_expression SHIFTR additive_expression",
 /*  50 */ "shift_expression ::= shift_expression SHIFTRR additive_expression",
 /*  51 */ "additive_expression ::= additive_expression PLUS multiplicative_expression",
 /*  52 */ "additive_expression ::= additive_expression MINUS multiplicative_expression",
 /*  53 */ "multiplicative_expression ::= multiplicative_expression STAR unary_expression",
 /*  54 */ "multiplicative_expression ::= multiplicative_expression SLASH unary_expression",
 /*  55 */ "multiplicative_expression ::= multiplicative_expression MOD unary_expression",
 /*  56 */ "unary_expression ::= DELETE unary_expression",
 /*  57 */ "unary_expression ::= INCR unary_expression",
 /*  58 */ "unary_expression ::= DECR unary_expression",
 /*  59 */ "unary_expression ::= PLUS unary_expression",
 /*  60 */ "unary_expression ::= MINUS unary_expression",
 /*  61 */ "unary_expression ::= NOT unary_expression",
 /*  62 */ "unary_expression ::= BITWISE_NOT unary_expression",
 /*  63 */ "unary_expression ::= ADJUST unary_expression",
 /*  64 */ "unary_expression ::= EXACT unary_expression",
 /*  65 */ "unary_expression ::= PARTIAL unary_expression",
 /*  66 */ "unary_expression ::= UNSPLIT unary_expression",
 /*  67 */ "postfix_expression ::= lefthand_side_expression INCR",
 /*  68 */ "postfix_expression ::= lefthand_side_expression DECR",
 /*  69 */ "call_expression ::= member_expression arguments",
 /*  70 */ "array_literal ::= BRACKETL element_list BRACKETR",
 /*  71 */ "element_list ::=",
 /*  72 */ "element_list ::= assignment_expression",
 /*  73 */ "element_list ::= element_list COMMA assignment_expression",
 /*  74 */ "object_literal ::= BRACEL property_name_and_value_list BRACER",
 /*  75 */ "property_name_and_value_list ::=",
 /*  76 */ "property_name_and_value ::= property_name COLON assignment_expression",
 /*  77 */ "member_expression_part ::= BRACKETL expression BRACKETR",
 /*  78 */ "arguments ::= PARENL argument_list PARENR",
 /*  79 */ "argument_list ::=",
 /*  80 */ "argument_list ::= assignment_expression",
 /*  81 */ "argument_list ::= argument_list COMMA assignment_expression",
 /*  82 */ "output_columns ::=",
 /*  83 */ "output_columns ::= output_column",
 /*  84 */ "output_columns ::= output_columns COMMA",
 /*  85 */ "output_columns ::= output_columns COMMA output_column",
 /*  86 */ "output_column ::= STAR",
 /*  87 */ "output_column ::= NONEXISTENT_COLUMN",
 /*  88 */ "output_column ::= assignment_expression",
 /*  89 */ "adjuster ::= adjuster PLUS adjust_expression",
 /*  90 */ "adjust_expression ::= adjust_match_expression STAR DECIMAL",
 /*  91 */ "adjust_match_expression ::= IDENTIFIER MATCH STRING",
 /*  92 */ "input ::= query",
 /*  93 */ "input ::= expression",
 /*  94 */ "input ::= START_OUTPUT_COLUMNS output_columns",
 /*  95 */ "input ::= START_ADJUSTER adjuster",
 /*  96 */ "query ::= query_element",
 /*  97 */ "query_element ::= QSTRING",
 /*  98 */ "query_element ::= PARENL query PARENR",
 /*  99 */ "expression ::= assignment_expression",
 /* 100 */ "assignment_expression ::= conditional_expression",
 /* 101 */ "conditional_expression ::= logical_or_expression",
 /* 102 */ "logical_or_expression ::= logical_and_expression",
 /* 103 */ "logical_and_expression ::= bitwise_or_expression",
 /* 104 */ "bitwise_or_expression ::= bitwise_xor_expression",
 /* 105 */ "bitwise_xor_expression ::= bitwise_and_expression",
 /* 106 */ "bitwise_and_expression ::= equality_expression",
 /* 107 */ "equality_expression ::= relational_expression",
 /* 108 */ "relational_expression ::= shift_expression",
 /* 109 */ "shift_expression ::= additive_expression",
 /* 110 */ "additive_expression ::= multiplicative_expression",
 /* 111 */ "multiplicative_expression ::= unary_expression",
 /* 112 */ "unary_expression ::= postfix_expression",
 /* 113 */ "postfix_expression ::= lefthand_side_expression",
 /* 114 */ "lefthand_side_expression ::= call_expression",
 /* 115 */ "lefthand_side_expression ::= member_expression",
 /* 116 */ "member_expression ::= primary_expression",
 /* 117 */ "member_expression ::= member_expression member_expression_part",
 /* 118 */ "primary_expression ::= object_literal",
 /* 119 */ "primary_expression ::= PARENL expression PARENR",
 /* 120 */ "primary_expression ::= IDENTIFIER",
 /* 121 */ "primary_expression ::= array_literal",
 /* 122 */ "primary_expression ::= DECIMAL",
 /* 123 */ "primary_expression ::= HEX_INTEGER",
 /* 124 */ "primary_expression ::= STRING",
 /* 125 */ "primary_expression ::= BOOLEAN",
 /* 126 */ "primary_expression ::= NULL",
 /* 127 */ "property_name_and_value_list ::= property_name_and_value",
 /* 128 */ "property_name_and_value_list ::= property_name_and_value_list COMMA property_name_and_value",
 /* 129 */ "property_name ::= STRING",
 /* 130 */ "member_expression_part ::= DOT IDENTIFIER",
 /* 131 */ "adjuster ::=",
 /* 132 */ "adjuster ::= adjust_expression",
 /* 133 */ "adjust_expression ::= adjust_match_expression",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to grn_expr_parserAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void grn_expr_parserInit(void *yypRawParser grn_expr_parserCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  grn_expr_parserCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef grn_expr_parser_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to grn_expr_parser and grn_expr_parserFree.
*/
void *grn_expr_parserAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) grn_expr_parserCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    grn_expr_parserCTX_STORE
    grn_expr_parserInit(yypParser grn_expr_parserCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* grn_expr_parser_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  grn_expr_parserARG_FETCH
  grn_expr_parserCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
    case 77: /* suppress_unused_variable_warning */
{
#line 56 "../../groonga/lib/grn_ecmascript.lemon"

  (void)efsi;

#line 1130 "../../groonga/lib/grn_ecmascript.c"
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void grn_expr_parserFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef grn_expr_parser_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void grn_expr_parserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  grn_expr_parserFinalize(p);
  (*freeProc)(p);
}
#endif /* grn_expr_parser_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int grn_expr_parserStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int grn_expr_parserCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    assert( i<=YY_ACTTAB_COUNT );
    assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD );
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    assert( i<(int)YY_NLOOKAHEAD );
    if( yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      assert( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0]) );
      iFallback = yyFallback[iLookAhead];
      if( iFallback!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        assert( j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) );
        if( yy_lookahead[j]==YYWILDCARD && iLookAhead>0 ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      assert( i>=0 && i<sizeof(yy_action)/sizeof(yy_action[0]) );
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   grn_expr_parserARG_FETCH
   grn_expr_parserCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   grn_expr_parserARG_STORE /* Suppress warning about unused %extra_argument var */
   grn_expr_parserCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  grn_expr_parserTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* For rule J, yyRuleInfoLhs[J] contains the symbol on the left-hand side
** of that rule */
static const YYCODETYPE yyRuleInfoLhs[] = {
    79,  /* (0) query ::= query query_element */
    79,  /* (1) query ::= query LOGICAL_AND query_element */
    79,  /* (2) query ::= query LOGICAL_AND_NOT query_element */
    79,  /* (3) query ::= query LOGICAL_OR query_element */
    79,  /* (4) query ::= query NEGATIVE query_element */
    83,  /* (5) query_element ::= ADJUST query_element */
    83,  /* (6) query_element ::= RELATIVE_OP query_element */
    83,  /* (7) query_element ::= IDENTIFIER RELATIVE_OP query_element */
    83,  /* (8) query_element ::= BRACEL expression BRACER */
    83,  /* (9) query_element ::= EVAL primary_expression */
    80,  /* (10) expression ::= expression COMMA assignment_expression */
    85,  /* (11) assignment_expression ::= lefthand_side_expression ASSIGN assignment_expression */
    85,  /* (12) assignment_expression ::= lefthand_side_expression STAR_ASSIGN assignment_expression */
    85,  /* (13) assignment_expression ::= lefthand_side_expression SLASH_ASSIGN assignment_expression */
    85,  /* (14) assignment_expression ::= lefthand_side_expression MOD_ASSIGN assignment_expression */
    85,  /* (15) assignment_expression ::= lefthand_side_expression PLUS_ASSIGN assignment_expression */
    85,  /* (16) assignment_expression ::= lefthand_side_expression MINUS_ASSIGN assignment_expression */
    85,  /* (17) assignment_expression ::= lefthand_side_expression SHIFTL_ASSIGN assignment_expression */
    85,  /* (18) assignment_expression ::= lefthand_side_expression SHIFTR_ASSIGN assignment_expression */
    85,  /* (19) assignment_expression ::= lefthand_side_expression SHIFTRR_ASSIGN assignment_expression */
    85,  /* (20) assignment_expression ::= lefthand_side_expression AND_ASSIGN assignment_expression */
    85,  /* (21) assignment_expression ::= lefthand_side_expression XOR_ASSIGN assignment_expression */
    85,  /* (22) assignment_expression ::= lefthand_side_expression OR_ASSIGN assignment_expression */
    86,  /* (23) conditional_expression ::= logical_or_expression QUESTION assignment_expression COLON assignment_expression */
    88,  /* (24) logical_or_expression ::= logical_or_expression LOGICAL_OR logical_and_expression */
    89,  /* (25) logical_and_expression ::= logical_and_expression LOGICAL_AND bitwise_or_expression */
    89,  /* (26) logical_and_expression ::= logical_and_expression LOGICAL_AND_NOT bitwise_or_expression */
    90,  /* (27) bitwise_or_expression ::= bitwise_or_expression BITWISE_OR bitwise_xor_expression */
    91,  /* (28) bitwise_xor_expression ::= bitwise_xor_expression BITWISE_XOR bitwise_and_expression */
    92,  /* (29) bitwise_and_expression ::= bitwise_and_expression BITWISE_AND equality_expression */
    93,  /* (30) equality_expression ::= equality_expression EQUAL relational_expression */
    93,  /* (31) equality_expression ::= equality_expression NOT_EQUAL relational_expression */
    94,  /* (32) relational_expression ::= relational_expression LESS shift_expression */
    94,  /* (33) relational_expression ::= relational_expression GREATER shift_expression */
    94,  /* (34) relational_expression ::= relational_expression LESS_EQUAL shift_expression */
    94,  /* (35) relational_expression ::= relational_expression GREATER_EQUAL shift_expression */
    94,  /* (36) relational_expression ::= relational_expression IN shift_expression */
    94,  /* (37) relational_expression ::= relational_expression MATCH shift_expression */
    94,  /* (38) relational_expression ::= relational_expression NEAR shift_expression */
    94,  /* (39) relational_expression ::= relational_expression NEAR2 shift_expression */
    94,  /* (40) relational_expression ::= relational_expression NEAR_PHRASE shift_expression */
    94,  /* (41) relational_expression ::= relational_expression SIMILAR shift_expression */
    94,  /* (42) relational_expression ::= relational_expression TERM_EXTRACT shift_expression */
    94,  /* (43) relational_expression ::= relational_expression QUORUM shift_expression */
    94,  /* (44) relational_expression ::= relational_expression LCP shift_expression */
    94,  /* (45) relational_expression ::= relational_expression PREFIX shift_expression */
    94,  /* (46) relational_expression ::= relational_expression SUFFIX shift_expression */
    94,  /* (47) relational_expression ::= relational_expression REGEXP shift_expression */
    95,  /* (48) shift_expression ::= shift_expression SHIFTL additive_expression */
    95,  /* (49) shift_expression ::= shift_expression SHIFTR additive_expression */
    95,  /* (50) shift_expression ::= shift_expression SHIFTRR additive_expression */
    96,  /* (51) additive_expression ::= additive_expression PLUS multiplicative_expression */
    96,  /* (52) additive_expression ::= additive_expression MINUS multiplicative_expression */
    97,  /* (53) multiplicative_expression ::= multiplicative_expression STAR unary_expression */
    97,  /* (54) multiplicative_expression ::= multiplicative_expression SLASH unary_expression */
    97,  /* (55) multiplicative_expression ::= multiplicative_expression MOD unary_expression */
    98,  /* (56) unary_expression ::= DELETE unary_expression */
    98,  /* (57) unary_expression ::= INCR unary_expression */
    98,  /* (58) unary_expression ::= DECR unary_expression */
    98,  /* (59) unary_expression ::= PLUS unary_expression */
    98,  /* (60) unary_expression ::= MINUS unary_expression */
    98,  /* (61) unary_expression ::= NOT unary_expression */
    98,  /* (62) unary_expression ::= BITWISE_NOT unary_expression */
    98,  /* (63) unary_expression ::= ADJUST unary_expression */
    98,  /* (64) unary_expression ::= EXACT unary_expression */
    98,  /* (65) unary_expression ::= PARTIAL unary_expression */
    98,  /* (66) unary_expression ::= UNSPLIT unary_expression */
    99,  /* (67) postfix_expression ::= lefthand_side_expression INCR */
    99,  /* (68) postfix_expression ::= lefthand_side_expression DECR */
   100,  /* (69) call_expression ::= member_expression arguments */
   105,  /* (70) array_literal ::= BRACKETL element_list BRACKETR */
   106,  /* (71) element_list ::= */
   106,  /* (72) element_list ::= assignment_expression */
   106,  /* (73) element_list ::= element_list COMMA assignment_expression */
   104,  /* (74) object_literal ::= BRACEL property_name_and_value_list BRACER */
   107,  /* (75) property_name_and_value_list ::= */
   108,  /* (76) property_name_and_value ::= property_name COLON assignment_expression */
   103,  /* (77) member_expression_part ::= BRACKETL expression BRACKETR */
   102,  /* (78) arguments ::= PARENL argument_list PARENR */
   110,  /* (79) argument_list ::= */
   110,  /* (80) argument_list ::= assignment_expression */
   110,  /* (81) argument_list ::= argument_list COMMA assignment_expression */
    81,  /* (82) output_columns ::= */
    81,  /* (83) output_columns ::= output_column */
    81,  /* (84) output_columns ::= output_columns COMMA */
    81,  /* (85) output_columns ::= output_columns COMMA output_column */
   111,  /* (86) output_column ::= STAR */
   111,  /* (87) output_column ::= NONEXISTENT_COLUMN */
   111,  /* (88) output_column ::= assignment_expression */
    82,  /* (89) adjuster ::= adjuster PLUS adjust_expression */
   112,  /* (90) adjust_expression ::= adjust_match_expression STAR DECIMAL */
   113,  /* (91) adjust_match_expression ::= IDENTIFIER MATCH STRING */
    78,  /* (92) input ::= query */
    78,  /* (93) input ::= expression */
    78,  /* (94) input ::= START_OUTPUT_COLUMNS output_columns */
    78,  /* (95) input ::= START_ADJUSTER adjuster */
    79,  /* (96) query ::= query_element */
    83,  /* (97) query_element ::= QSTRING */
    83,  /* (98) query_element ::= PARENL query PARENR */
    80,  /* (99) expression ::= assignment_expression */
    85,  /* (100) assignment_expression ::= conditional_expression */
    86,  /* (101) conditional_expression ::= logical_or_expression */
    88,  /* (102) logical_or_expression ::= logical_and_expression */
    89,  /* (103) logical_and_expression ::= bitwise_or_expression */
    90,  /* (104) bitwise_or_expression ::= bitwise_xor_expression */
    91,  /* (105) bitwise_xor_expression ::= bitwise_and_expression */
    92,  /* (106) bitwise_and_expression ::= equality_expression */
    93,  /* (107) equality_expression ::= relational_expression */
    94,  /* (108) relational_expression ::= shift_expression */
    95,  /* (109) shift_expression ::= additive_expression */
    96,  /* (110) additive_expression ::= multiplicative_expression */
    97,  /* (111) multiplicative_expression ::= unary_expression */
    98,  /* (112) unary_expression ::= postfix_expression */
    99,  /* (113) postfix_expression ::= lefthand_side_expression */
    87,  /* (114) lefthand_side_expression ::= call_expression */
    87,  /* (115) lefthand_side_expression ::= member_expression */
   101,  /* (116) member_expression ::= primary_expression */
   101,  /* (117) member_expression ::= member_expression member_expression_part */
    84,  /* (118) primary_expression ::= object_literal */
    84,  /* (119) primary_expression ::= PARENL expression PARENR */
    84,  /* (120) primary_expression ::= IDENTIFIER */
    84,  /* (121) primary_expression ::= array_literal */
    84,  /* (122) primary_expression ::= DECIMAL */
    84,  /* (123) primary_expression ::= HEX_INTEGER */
    84,  /* (124) primary_expression ::= STRING */
    84,  /* (125) primary_expression ::= BOOLEAN */
    84,  /* (126) primary_expression ::= NULL */
   107,  /* (127) property_name_and_value_list ::= property_name_and_value */
   107,  /* (128) property_name_and_value_list ::= property_name_and_value_list COMMA property_name_and_value */
   109,  /* (129) property_name ::= STRING */
   103,  /* (130) member_expression_part ::= DOT IDENTIFIER */
    82,  /* (131) adjuster ::= */
    82,  /* (132) adjuster ::= adjust_expression */
   112,  /* (133) adjust_expression ::= adjust_match_expression */
};

/* For rule J, yyRuleInfoNRhs[J] contains the negative of the number
** of symbols on the right-hand side of that rule. */
static const signed char yyRuleInfoNRhs[] = {
   -2,  /* (0) query ::= query query_element */
   -3,  /* (1) query ::= query LOGICAL_AND query_element */
   -3,  /* (2) query ::= query LOGICAL_AND_NOT query_element */
   -3,  /* (3) query ::= query LOGICAL_OR query_element */
   -3,  /* (4) query ::= query NEGATIVE query_element */
   -2,  /* (5) query_element ::= ADJUST query_element */
   -2,  /* (6) query_element ::= RELATIVE_OP query_element */
   -3,  /* (7) query_element ::= IDENTIFIER RELATIVE_OP query_element */
   -3,  /* (8) query_element ::= BRACEL expression BRACER */
   -2,  /* (9) query_element ::= EVAL primary_expression */
   -3,  /* (10) expression ::= expression COMMA assignment_expression */
   -3,  /* (11) assignment_expression ::= lefthand_side_expression ASSIGN assignment_expression */
   -3,  /* (12) assignment_expression ::= lefthand_side_expression STAR_ASSIGN assignment_expression */
   -3,  /* (13) assignment_expression ::= lefthand_side_expression SLASH_ASSIGN assignment_expression */
   -3,  /* (14) assignment_expression ::= lefthand_side_expression MOD_ASSIGN assignment_expression */
   -3,  /* (15) assignment_expression ::= lefthand_side_expression PLUS_ASSIGN assignment_expression */
   -3,  /* (16) assignment_expression ::= lefthand_side_expression MINUS_ASSIGN assignment_expression */
   -3,  /* (17) assignment_expression ::= lefthand_side_expression SHIFTL_ASSIGN assignment_expression */
   -3,  /* (18) assignment_expression ::= lefthand_side_expression SHIFTR_ASSIGN assignment_expression */
   -3,  /* (19) assignment_expression ::= lefthand_side_expression SHIFTRR_ASSIGN assignment_expression */
   -3,  /* (20) assignment_expression ::= lefthand_side_expression AND_ASSIGN assignment_expression */
   -3,  /* (21) assignment_expression ::= lefthand_side_expression XOR_ASSIGN assignment_expression */
   -3,  /* (22) assignment_expression ::= lefthand_side_expression OR_ASSIGN assignment_expression */
   -5,  /* (23) conditional_expression ::= logical_or_expression QUESTION assignment_expression COLON assignment_expression */
   -3,  /* (24) logical_or_expression ::= logical_or_expression LOGICAL_OR logical_and_expression */
   -3,  /* (25) logical_and_expression ::= logical_and_expression LOGICAL_AND bitwise_or_expression */
   -3,  /* (26) logical_and_expression ::= logical_and_expression LOGICAL_AND_NOT bitwise_or_expression */
   -3,  /* (27) bitwise_or_expression ::= bitwise_or_expression BITWISE_OR bitwise_xor_expression */
   -3,  /* (28) bitwise_xor_expression ::= bitwise_xor_expression BITWISE_XOR bitwise_and_expression */
   -3,  /* (29) bitwise_and_expression ::= bitwise_and_expression BITWISE_AND equality_expression */
   -3,  /* (30) equality_expression ::= equality_expression EQUAL relational_expression */
   -3,  /* (31) equality_expression ::= equality_expression NOT_EQUAL relational_expression */
   -3,  /* (32) relational_expression ::= relational_expression LESS shift_expression */
   -3,  /* (33) relational_expression ::= relational_expression GREATER shift_expression */
   -3,  /* (34) relational_expression ::= relational_expression LESS_EQUAL shift_expression */
   -3,  /* (35) relational_expression ::= relational_expression GREATER_EQUAL shift_expression */
   -3,  /* (36) relational_expression ::= relational_expression IN shift_expression */
   -3,  /* (37) relational_expression ::= relational_expression MATCH shift_expression */
   -3,  /* (38) relational_expression ::= relational_expression NEAR shift_expression */
   -3,  /* (39) relational_expression ::= relational_expression NEAR2 shift_expression */
   -3,  /* (40) relational_expression ::= relational_expression NEAR_PHRASE shift_expression */
   -3,  /* (41) relational_expression ::= relational_expression SIMILAR shift_expression */
   -3,  /* (42) relational_expression ::= relational_expression TERM_EXTRACT shift_expression */
   -3,  /* (43) relational_expression ::= relational_expression QUORUM shift_expression */
   -3,  /* (44) relational_expression ::= relational_expression LCP shift_expression */
   -3,  /* (45) relational_expression ::= relational_expression PREFIX shift_expression */
   -3,  /* (46) relational_expression ::= relational_expression SUFFIX shift_expression */
   -3,  /* (47) relational_expression ::= relational_expression REGEXP shift_expression */
   -3,  /* (48) shift_expression ::= shift_expression SHIFTL additive_expression */
   -3,  /* (49) shift_expression ::= shift_expression SHIFTR additive_expression */
   -3,  /* (50) shift_expression ::= shift_expression SHIFTRR additive_expression */
   -3,  /* (51) additive_expression ::= additive_expression PLUS multiplicative_expression */
   -3,  /* (52) additive_expression ::= additive_expression MINUS multiplicative_expression */
   -3,  /* (53) multiplicative_expression ::= multiplicative_expression STAR unary_expression */
   -3,  /* (54) multiplicative_expression ::= multiplicative_expression SLASH unary_expression */
   -3,  /* (55) multiplicative_expression ::= multiplicative_expression MOD unary_expression */
   -2,  /* (56) unary_expression ::= DELETE unary_expression */
   -2,  /* (57) unary_expression ::= INCR unary_expression */
   -2,  /* (58) unary_expression ::= DECR unary_expression */
   -2,  /* (59) unary_expression ::= PLUS unary_expression */
   -2,  /* (60) unary_expression ::= MINUS unary_expression */
   -2,  /* (61) unary_expression ::= NOT unary_expression */
   -2,  /* (62) unary_expression ::= BITWISE_NOT unary_expression */
   -2,  /* (63) unary_expression ::= ADJUST unary_expression */
   -2,  /* (64) unary_expression ::= EXACT unary_expression */
   -2,  /* (65) unary_expression ::= PARTIAL unary_expression */
   -2,  /* (66) unary_expression ::= UNSPLIT unary_expression */
   -2,  /* (67) postfix_expression ::= lefthand_side_expression INCR */
   -2,  /* (68) postfix_expression ::= lefthand_side_expression DECR */
   -2,  /* (69) call_expression ::= member_expression arguments */
   -3,  /* (70) array_literal ::= BRACKETL element_list BRACKETR */
    0,  /* (71) element_list ::= */
   -1,  /* (72) element_list ::= assignment_expression */
   -3,  /* (73) element_list ::= element_list COMMA assignment_expression */
   -3,  /* (74) object_literal ::= BRACEL property_name_and_value_list BRACER */
    0,  /* (75) property_name_and_value_list ::= */
   -3,  /* (76) property_name_and_value ::= property_name COLON assignment_expression */
   -3,  /* (77) member_expression_part ::= BRACKETL expression BRACKETR */
   -3,  /* (78) arguments ::= PARENL argument_list PARENR */
    0,  /* (79) argument_list ::= */
   -1,  /* (80) argument_list ::= assignment_expression */
   -3,  /* (81) argument_list ::= argument_list COMMA assignment_expression */
    0,  /* (82) output_columns ::= */
   -1,  /* (83) output_columns ::= output_column */
   -2,  /* (84) output_columns ::= output_columns COMMA */
   -3,  /* (85) output_columns ::= output_columns COMMA output_column */
   -1,  /* (86) output_column ::= STAR */
   -1,  /* (87) output_column ::= NONEXISTENT_COLUMN */
   -1,  /* (88) output_column ::= assignment_expression */
   -3,  /* (89) adjuster ::= adjuster PLUS adjust_expression */
   -3,  /* (90) adjust_expression ::= adjust_match_expression STAR DECIMAL */
   -3,  /* (91) adjust_match_expression ::= IDENTIFIER MATCH STRING */
   -1,  /* (92) input ::= query */
   -1,  /* (93) input ::= expression */
   -2,  /* (94) input ::= START_OUTPUT_COLUMNS output_columns */
   -2,  /* (95) input ::= START_ADJUSTER adjuster */
   -1,  /* (96) query ::= query_element */
   -1,  /* (97) query_element ::= QSTRING */
   -3,  /* (98) query_element ::= PARENL query PARENR */
   -1,  /* (99) expression ::= assignment_expression */
   -1,  /* (100) assignment_expression ::= conditional_expression */
   -1,  /* (101) conditional_expression ::= logical_or_expression */
   -1,  /* (102) logical_or_expression ::= logical_and_expression */
   -1,  /* (103) logical_and_expression ::= bitwise_or_expression */
   -1,  /* (104) bitwise_or_expression ::= bitwise_xor_expression */
   -1,  /* (105) bitwise_xor_expression ::= bitwise_and_expression */
   -1,  /* (106) bitwise_and_expression ::= equality_expression */
   -1,  /* (107) equality_expression ::= relational_expression */
   -1,  /* (108) relational_expression ::= shift_expression */
   -1,  /* (109) shift_expression ::= additive_expression */
   -1,  /* (110) additive_expression ::= multiplicative_expression */
   -1,  /* (111) multiplicative_expression ::= unary_expression */
   -1,  /* (112) unary_expression ::= postfix_expression */
   -1,  /* (113) postfix_expression ::= lefthand_side_expression */
   -1,  /* (114) lefthand_side_expression ::= call_expression */
   -1,  /* (115) lefthand_side_expression ::= member_expression */
   -1,  /* (116) member_expression ::= primary_expression */
   -2,  /* (117) member_expression ::= member_expression member_expression_part */
   -1,  /* (118) primary_expression ::= object_literal */
   -3,  /* (119) primary_expression ::= PARENL expression PARENR */
   -1,  /* (120) primary_expression ::= IDENTIFIER */
   -1,  /* (121) primary_expression ::= array_literal */
   -1,  /* (122) primary_expression ::= DECIMAL */
   -1,  /* (123) primary_expression ::= HEX_INTEGER */
   -1,  /* (124) primary_expression ::= STRING */
   -1,  /* (125) primary_expression ::= BOOLEAN */
   -1,  /* (126) primary_expression ::= NULL */
   -1,  /* (127) property_name_and_value_list ::= property_name_and_value */
   -3,  /* (128) property_name_and_value_list ::= property_name_and_value_list COMMA property_name_and_value */
   -1,  /* (129) property_name ::= STRING */
   -2,  /* (130) member_expression_part ::= DOT IDENTIFIER */
    0,  /* (131) adjuster ::= */
   -1,  /* (132) adjuster ::= adjust_expression */
   -1,  /* (133) adjust_expression ::= adjust_match_expression */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  grn_expr_parserTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  grn_expr_parserCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  grn_expr_parserARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfoNRhs[yyruleno];
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s]%s, pop back to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno],
        yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action",
        yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s]%s.\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno],
        yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action");
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfoNRhs[yyruleno]==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* query ::= query query_element */
#line 97 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, grn_int32_value_at(&efsi->op_stack, -1), 2);
}
#line 1786 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 1: /* query ::= query LOGICAL_AND query_element */
      case 25: /* logical_and_expression ::= logical_and_expression LOGICAL_AND bitwise_or_expression */ yytestcase(yyruleno==25);
#line 100 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_AND, 2);
}
#line 1794 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 2: /* query ::= query LOGICAL_AND_NOT query_element */
      case 26: /* logical_and_expression ::= logical_and_expression LOGICAL_AND_NOT bitwise_or_expression */ yytestcase(yyruleno==26);
#line 103 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_AND_NOT, 2);
}
#line 1802 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 3: /* query ::= query LOGICAL_OR query_element */
      case 24: /* logical_or_expression ::= logical_or_expression LOGICAL_OR logical_and_expression */ yytestcase(yyruleno==24);
#line 106 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_OR, 2);
}
#line 1810 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 4: /* query ::= query NEGATIVE query_element */
#line 109 "../../groonga/lib/grn_ecmascript.lemon"
{
  int weight;
  GRN_INT32_POP(&efsi->weight_stack, weight);
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_ADJUST, 2);
}
#line 1819 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 5: /* query_element ::= ADJUST query_element */
#line 118 "../../groonga/lib/grn_ecmascript.lemon"
{
  int weight;
  GRN_INT32_POP(&efsi->weight_stack, weight);
}
#line 1827 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 6: /* query_element ::= RELATIVE_OP query_element */
#line 122 "../../groonga/lib/grn_ecmascript.lemon"
{
  int mode;
  GRN_INT32_POP(&efsi->mode_stack, mode);
}
#line 1835 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 7: /* query_element ::= IDENTIFIER RELATIVE_OP query_element */
#line 126 "../../groonga/lib/grn_ecmascript.lemon"
{
  int mode;
  grn_obj *c;
  GRN_PTR_POP(&efsi->column_stack, c);
  GRN_INT32_POP(&efsi->mode_stack, mode);
  switch (mode) {
  case GRN_OP_NEAR :
  case GRN_OP_NEAR2 :
  case GRN_OP_NEAR_PHRASE :
    {
      int max_interval;
      GRN_INT32_POP(&efsi->max_interval_stack, max_interval);
    }
    break;
  case GRN_OP_SIMILAR :
    {
      int similarity_threshold;
      GRN_INT32_POP(&efsi->similarity_threshold_stack, similarity_threshold);
    }
    break;
  case GRN_OP_QUORUM :
    {
      int quorum_threshold;
      GRN_INT32_POP(&efsi->quorum_threshold_stack, quorum_threshold);
    }
    break;
  default :
    break;
  }
}
#line 1869 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 8: /* query_element ::= BRACEL expression BRACER */
      case 9: /* query_element ::= EVAL primary_expression */ yytestcase(yyruleno==9);
#line 156 "../../groonga/lib/grn_ecmascript.lemon"
{
  efsi->flags = efsi->default_flags;
}
#line 1877 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 10: /* expression ::= expression COMMA assignment_expression */
#line 164 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_COMMA, 2);
}
#line 1884 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 11: /* assignment_expression ::= lefthand_side_expression ASSIGN assignment_expression */
#line 169 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_ASSIGN, 2);
}
#line 1891 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 12: /* assignment_expression ::= lefthand_side_expression STAR_ASSIGN assignment_expression */
#line 172 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_STAR_ASSIGN, 2);
}
#line 1898 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 13: /* assignment_expression ::= lefthand_side_expression SLASH_ASSIGN assignment_expression */
#line 175 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SLASH_ASSIGN, 2);
}
#line 1905 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 14: /* assignment_expression ::= lefthand_side_expression MOD_ASSIGN assignment_expression */
#line 178 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MOD_ASSIGN, 2);
}
#line 1912 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 15: /* assignment_expression ::= lefthand_side_expression PLUS_ASSIGN assignment_expression */
#line 181 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PLUS_ASSIGN, 2);
}
#line 1919 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 16: /* assignment_expression ::= lefthand_side_expression MINUS_ASSIGN assignment_expression */
#line 184 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MINUS_ASSIGN, 2);
}
#line 1926 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 17: /* assignment_expression ::= lefthand_side_expression SHIFTL_ASSIGN assignment_expression */
#line 187 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTL_ASSIGN, 2);
}
#line 1933 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 18: /* assignment_expression ::= lefthand_side_expression SHIFTR_ASSIGN assignment_expression */
#line 190 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTR_ASSIGN, 2);
}
#line 1940 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 19: /* assignment_expression ::= lefthand_side_expression SHIFTRR_ASSIGN assignment_expression */
#line 193 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTRR_ASSIGN, 2);
}
#line 1947 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 20: /* assignment_expression ::= lefthand_side_expression AND_ASSIGN assignment_expression */
#line 196 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_AND_ASSIGN, 2);
}
#line 1954 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 21: /* assignment_expression ::= lefthand_side_expression XOR_ASSIGN assignment_expression */
#line 199 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_XOR_ASSIGN, 2);
}
#line 1961 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 22: /* assignment_expression ::= lefthand_side_expression OR_ASSIGN assignment_expression */
#line 202 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_OR_ASSIGN, 2);
}
#line 1968 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 23: /* conditional_expression ::= logical_or_expression QUESTION assignment_expression COLON assignment_expression */
#line 207 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr *e = (grn_expr *)efsi->e;
  e->codes[yymsp[-3].minor.yy0].nargs = yymsp[-1].minor.yy0 - yymsp[-3].minor.yy0;
  e->codes[yymsp[-1].minor.yy0].nargs = e->codes_curr - yymsp[-1].minor.yy0 - 1;
}
#line 1977 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 27: /* bitwise_or_expression ::= bitwise_or_expression BITWISE_OR bitwise_xor_expression */
#line 227 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_OR, 2);
}
#line 1984 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 28: /* bitwise_xor_expression ::= bitwise_xor_expression BITWISE_XOR bitwise_and_expression */
#line 232 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_XOR, 2);
}
#line 1991 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 29: /* bitwise_and_expression ::= bitwise_and_expression BITWISE_AND equality_expression */
#line 237 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_AND, 2);
}
#line 1998 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 30: /* equality_expression ::= equality_expression EQUAL relational_expression */
#line 242 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_EQUAL, 2);
}
#line 2005 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 31: /* equality_expression ::= equality_expression NOT_EQUAL relational_expression */
#line 245 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NOT_EQUAL, 2);
}
#line 2012 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 32: /* relational_expression ::= relational_expression LESS shift_expression */
#line 250 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_LESS, 2);
}
#line 2019 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 33: /* relational_expression ::= relational_expression GREATER shift_expression */
#line 253 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_GREATER, 2);
}
#line 2026 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 34: /* relational_expression ::= relational_expression LESS_EQUAL shift_expression */
#line 256 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_LESS_EQUAL, 2);
}
#line 2033 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 35: /* relational_expression ::= relational_expression GREATER_EQUAL shift_expression */
#line 259 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_GREATER_EQUAL, 2);
}
#line 2040 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 36: /* relational_expression ::= relational_expression IN shift_expression */
#line 262 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_IN, 2);
}
#line 2047 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 37: /* relational_expression ::= relational_expression MATCH shift_expression */
      case 91: /* adjust_match_expression ::= IDENTIFIER MATCH STRING */ yytestcase(yyruleno==91);
#line 265 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MATCH, 2);
}
#line 2055 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 38: /* relational_expression ::= relational_expression NEAR shift_expression */
#line 268 "../../groonga/lib/grn_ecmascript.lemon"
{
  {
    int max_interval;
    GRN_INT32_POP(&efsi->max_interval_stack, max_interval);
    grn_expr_append_const_int(efsi->ctx, efsi->e, max_interval,
                              GRN_OP_PUSH, 1);
  }
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NEAR, 3);
}
#line 2068 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 39: /* relational_expression ::= relational_expression NEAR2 shift_expression */
#line 277 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NEAR2, 2);
}
#line 2075 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 40: /* relational_expression ::= relational_expression NEAR_PHRASE shift_expression */
#line 280 "../../groonga/lib/grn_ecmascript.lemon"
{
  {
    int max_interval;
    GRN_INT32_POP(&efsi->max_interval_stack, max_interval);
    grn_expr_append_const_int(efsi->ctx, efsi->e, max_interval,
                              GRN_OP_PUSH, 1);
  }
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NEAR_PHRASE, 3);
}
#line 2088 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 41: /* relational_expression ::= relational_expression SIMILAR shift_expression */
#line 289 "../../groonga/lib/grn_ecmascript.lemon"
{
  {
    int similarity_threshold;
    GRN_INT32_POP(&efsi->similarity_threshold_stack, similarity_threshold);
    grn_expr_append_const_int(efsi->ctx, efsi->e, similarity_threshold,
                              GRN_OP_PUSH, 1);
  }
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SIMILAR, 3);
}
#line 2101 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 42: /* relational_expression ::= relational_expression TERM_EXTRACT shift_expression */
#line 298 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_TERM_EXTRACT, 2);
}
#line 2108 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 43: /* relational_expression ::= relational_expression QUORUM shift_expression */
#line 301 "../../groonga/lib/grn_ecmascript.lemon"
{
  {
    int quorum_threshold;
    GRN_INT32_POP(&efsi->quorum_threshold_stack, quorum_threshold);
    grn_expr_append_const_int(efsi->ctx, efsi->e, quorum_threshold,
                              GRN_OP_PUSH, 1);
  }
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_QUORUM, 3);
}
#line 2121 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 44: /* relational_expression ::= relational_expression LCP shift_expression */
#line 310 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_LCP, 2);
}
#line 2128 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 45: /* relational_expression ::= relational_expression PREFIX shift_expression */
#line 313 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PREFIX, 2);
}
#line 2135 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 46: /* relational_expression ::= relational_expression SUFFIX shift_expression */
#line 316 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SUFFIX, 2);
}
#line 2142 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 47: /* relational_expression ::= relational_expression REGEXP shift_expression */
#line 319 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_REGEXP, 2);
}
#line 2149 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 48: /* shift_expression ::= shift_expression SHIFTL additive_expression */
#line 324 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTL, 2);
}
#line 2156 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 49: /* shift_expression ::= shift_expression SHIFTR additive_expression */
#line 327 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTR, 2);
}
#line 2163 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 50: /* shift_expression ::= shift_expression SHIFTRR additive_expression */
#line 330 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTRR, 2);
}
#line 2170 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 51: /* additive_expression ::= additive_expression PLUS multiplicative_expression */
      case 89: /* adjuster ::= adjuster PLUS adjust_expression */ yytestcase(yyruleno==89);
#line 335 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PLUS, 2);
}
#line 2178 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 52: /* additive_expression ::= additive_expression MINUS multiplicative_expression */
#line 338 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MINUS, 2);
}
#line 2185 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 53: /* multiplicative_expression ::= multiplicative_expression STAR unary_expression */
      case 90: /* adjust_expression ::= adjust_match_expression STAR DECIMAL */ yytestcase(yyruleno==90);
#line 343 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_STAR, 2);
}
#line 2193 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 54: /* multiplicative_expression ::= multiplicative_expression SLASH unary_expression */
#line 346 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SLASH, 2);
}
#line 2200 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 55: /* multiplicative_expression ::= multiplicative_expression MOD unary_expression */
#line 349 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MOD, 2);
}
#line 2207 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 56: /* unary_expression ::= DELETE unary_expression */
#line 354 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_DELETE, 1);
}
#line 2214 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 57: /* unary_expression ::= INCR unary_expression */
#line 357 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  dfi_ = grn_expr_dfi_pop(e);
  const_p = CONSTP(dfi_->code->value);
  grn_expr_dfi_put(ctx, e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be incremented: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_INCR, 1);
  }
}
#line 2235 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 58: /* unary_expression ::= DECR unary_expression */
#line 374 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  dfi_ = grn_expr_dfi_pop(e);
  const_p = CONSTP(dfi_->code->value);
  grn_expr_dfi_put(ctx, e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be decremented: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_DECR, 1);
  }
}
#line 2256 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 59: /* unary_expression ::= PLUS unary_expression */
#line 391 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PLUS, 1);
}
#line 2263 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 60: /* unary_expression ::= MINUS unary_expression */
#line 394 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MINUS, 1);
}
#line 2270 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 61: /* unary_expression ::= NOT unary_expression */
#line 397 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NOT, 1);
}
#line 2277 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 62: /* unary_expression ::= BITWISE_NOT unary_expression */
#line 400 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_NOT, 1);
}
#line 2284 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 63: /* unary_expression ::= ADJUST unary_expression */
#line 403 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_ADJUST, 1);
}
#line 2291 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 64: /* unary_expression ::= EXACT unary_expression */
#line 406 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_EXACT, 1);
}
#line 2298 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 65: /* unary_expression ::= PARTIAL unary_expression */
#line 409 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PARTIAL, 1);
}
#line 2305 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 66: /* unary_expression ::= UNSPLIT unary_expression */
#line 412 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_UNSPLIT, 1);
}
#line 2312 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 67: /* postfix_expression ::= lefthand_side_expression INCR */
#line 417 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  dfi_ = grn_expr_dfi_pop(e);
  const_p = CONSTP(dfi_->code->value);
  grn_expr_dfi_put(ctx, e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be incremented: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_INCR_POST, 1);
  }
}
#line 2333 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 68: /* postfix_expression ::= lefthand_side_expression DECR */
#line 434 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  dfi_ = grn_expr_dfi_pop(e);
  const_p = CONSTP(dfi_->code->value);
  grn_expr_dfi_put(ctx, e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be decremented: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_DECR_POST, 1);
  }
}
#line 2354 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 69: /* call_expression ::= member_expression arguments */
#line 455 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_CALL, yymsp[0].minor.yy0);
}
#line 2361 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 70: /* array_literal ::= BRACKETL element_list BRACKETR */
#line 472 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  if (efsi->array_literal) {
    grn_expr_take_obj(ctx, efsi->e, efsi->array_literal);
    grn_expr_append_obj(ctx, efsi->e, efsi->array_literal,
                        GRN_OP_PUSH, 1);
    efsi->array_literal = NULL;
  }
}
#line 2374 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 71: /* element_list ::= */
#line 482 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;

  efsi->array_literal = grn_obj_open(ctx, GRN_VECTOR, 0, GRN_ID_NIL);
  if (!efsi->array_literal) {
    ERR(GRN_NO_MEMORY_AVAILABLE,
        "couldn't create vector for parsing array literal: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  }
}
#line 2388 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 72: /* element_list ::= assignment_expression */
      case 73: /* element_list ::= element_list COMMA assignment_expression */ yytestcase(yyruleno==73);
#line 493 "../../groonga/lib/grn_ecmascript.lemon"
{
  array_literal_add_element(efsi);
}
#line 2396 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 74: /* object_literal ::= BRACEL property_name_and_value_list BRACER */
#line 501 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr_take_obj(ctx, efsi->e, (grn_obj *)(efsi->object_literal));
  grn_expr_append_obj(ctx, efsi->e, (grn_obj *)(efsi->object_literal),
                      GRN_OP_PUSH, 1);
  efsi->object_literal = NULL;
}
#line 2407 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 75: /* property_name_and_value_list ::= */
#line 509 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;

  efsi->object_literal =
    grn_hash_create(ctx, NULL, GRN_TABLE_MAX_KEY_SIZE, sizeof(grn_obj),
                    GRN_OBJ_KEY_VAR_SIZE|GRN_OBJ_TEMPORARY|GRN_HASH_TINY);
  if (!efsi->object_literal) {
    ERR(GRN_NO_MEMORY_AVAILABLE,
        "couldn't create hash table for parsing object literal: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  }
}
#line 2423 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 76: /* property_name_and_value ::= property_name COLON assignment_expression */
#line 524 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_obj *property = e->codes[e->codes_curr - 3].value;
  grn_obj *value = e->codes[e->codes_curr - 1].value;

  if (!efsi->object_literal) {
     efsi->object_literal =
       grn_hash_create(ctx, NULL, GRN_TABLE_MAX_KEY_SIZE, sizeof(grn_obj),
                       GRN_OBJ_KEY_VAR_SIZE|GRN_OBJ_TEMPORARY|GRN_HASH_TINY);
  }

  if (!efsi->object_literal) {
    ERR(GRN_NO_MEMORY_AVAILABLE,
        "couldn't create hash table for parsing object literal: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_obj *buf;
    int added;
    if (grn_hash_add(ctx, (grn_hash *)efsi->object_literal,
                     GRN_TEXT_VALUE(property), GRN_TEXT_LEN(property),
                     (void **)&buf, &added)) {
      if (added) {
        switch (value->header.type) {
        case GRN_TABLE_HASH_KEY :
        case GRN_COLUMN_FIX_SIZE :
        case GRN_COLUMN_VAR_SIZE :
        case GRN_COLUMN_INDEX :
          GRN_OBJ_INIT(buf, GRN_PTR, 0, GRN_ID_NIL);
          GRN_PTR_SET(ctx, buf, value);
          break;
        case GRN_VECTOR :
          GRN_OBJ_INIT(buf, value->header.type, 0, value->header.domain);
          grn_vector_copy(ctx, value, buf);
          break;
        default :
          GRN_OBJ_INIT(buf, value->header.type, 0, value->header.domain);
          GRN_TEXT_PUT(ctx, buf, GRN_TEXT_VALUE(value), GRN_TEXT_LEN(value));
          break;
        }
        grn_expr_dfi_pop(e);
        e->codes_curr -= 3;
      } else {
        ERR(GRN_INVALID_ARGUMENT,
            "duplicated property name: <%.*s>",
            (int)GRN_TEXT_LEN(property),
            GRN_TEXT_VALUE(property));
      }
    } else {
      ERR(GRN_NO_MEMORY_AVAILABLE,
          "failed to add a property to object literal: <%.*s>",
          (int)GRN_TEXT_LEN(property),
          GRN_TEXT_VALUE(property));
    }
  }
}
#line 2483 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 77: /* member_expression_part ::= BRACKETL expression BRACKETR */
#line 583 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_GET_MEMBER, 2);
}
#line 2490 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 78: /* arguments ::= PARENL argument_list PARENR */
#line 588 "../../groonga/lib/grn_ecmascript.lemon"
{ yymsp[-2].minor.yy0 = yymsp[-1].minor.yy0; }
#line 2495 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 79: /* argument_list ::= */
#line 589 "../../groonga/lib/grn_ecmascript.lemon"
{ yymsp[1].minor.yy0 = 0; }
#line 2500 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 80: /* argument_list ::= assignment_expression */
#line 590 "../../groonga/lib/grn_ecmascript.lemon"
{ yymsp[0].minor.yy0 = 1; }
#line 2505 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 81: /* argument_list ::= argument_list COMMA assignment_expression */
#line 591 "../../groonga/lib/grn_ecmascript.lemon"
{ yylhsminor.yy0 = yymsp[-2].minor.yy0 + 1; }
#line 2510 "../../groonga/lib/grn_ecmascript.c"
  yymsp[-2].minor.yy0 = yylhsminor.yy0;
        break;
      case 82: /* output_columns ::= */
#line 593 "../../groonga/lib/grn_ecmascript.lemon"
{
  yymsp[1].minor.yy0 = 0;
}
#line 2518 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 83: /* output_columns ::= output_column */
#line 596 "../../groonga/lib/grn_ecmascript.lemon"
{
  yylhsminor.yy0 = yymsp[0].minor.yy0;
}
#line 2525 "../../groonga/lib/grn_ecmascript.c"
  yymsp[0].minor.yy0 = yylhsminor.yy0;
        break;
      case 84: /* output_columns ::= output_columns COMMA */
#line 601 "../../groonga/lib/grn_ecmascript.lemon"
{
  yylhsminor.yy0 = yymsp[-1].minor.yy0;
}
#line 2533 "../../groonga/lib/grn_ecmascript.c"
  yymsp[-1].minor.yy0 = yylhsminor.yy0;
        break;
      case 85: /* output_columns ::= output_columns COMMA output_column */
#line 606 "../../groonga/lib/grn_ecmascript.lemon"
{
  if (yymsp[-2].minor.yy0 == 0) {
    yylhsminor.yy0 = yymsp[0].minor.yy0;
  } else if (yymsp[0].minor.yy0 == 0) {
    yylhsminor.yy0 = yymsp[-2].minor.yy0;
  } else {
    if (yymsp[0].minor.yy0 == 1) {
      grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_COMMA, 2);
    }
    yylhsminor.yy0 = 1;
  }
}
#line 2550 "../../groonga/lib/grn_ecmascript.c"
  yymsp[-2].minor.yy0 = yylhsminor.yy0;
        break;
      case 86: /* output_column ::= STAR */
#line 619 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_obj *expr = efsi->e;
  grn_obj *variable = grn_expr_get_var_by_offset(ctx, expr, 0);
  if (variable) {
    grn_id table_id = GRN_OBJ_GET_DOMAIN(variable);
    grn_obj *table = grn_ctx_at(ctx, table_id);
    grn_obj columns_buffer;
    int n_columns;
    grn_obj **columns;

    GRN_PTR_INIT(&columns_buffer, GRN_OBJ_VECTOR, GRN_ID_NIL);
    grn_obj_columns(ctx, table, "*", strlen("*"), &columns_buffer);
    n_columns = GRN_BULK_VSIZE(&columns_buffer) / sizeof(grn_obj *);
    columns = (grn_obj **)GRN_BULK_HEAD(&columns_buffer);

    if (n_columns == 0) {
      /* do nothing */
    } else if (n_columns == 1) {
      grn_obj *column = columns[0];
      grn_expr_append_const(ctx, expr, column, GRN_OP_GET_VALUE, 1);
      grn_expr_take_obj(ctx, expr, column);
    } else {
      grn_expr *e = (grn_expr *)expr;
      grn_bool have_column;
      int i;

      have_column = (e->codes_curr > 0);
      for (i = 0; i < n_columns; i++) {
        grn_obj *column = columns[i];
        grn_expr_append_const(ctx, expr, column, GRN_OP_GET_VALUE, 1);
        if (have_column || i > 0) {
          grn_expr_append_op(ctx, expr, GRN_OP_COMMA, 2);
        }
        grn_expr_take_obj(ctx, expr, column);
      }
    }

    if (grn_enable_reference_count) {
      grn_obj_unlink(ctx, table);
    }
    GRN_OBJ_FIN(ctx, &columns_buffer);

    yymsp[0].minor.yy0 = n_columns;
  } else {
    /* TODO: report error */
    yymsp[0].minor.yy0 = 0;
  }
}
#line 2604 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 87: /* output_column ::= NONEXISTENT_COLUMN */
#line 668 "../../groonga/lib/grn_ecmascript.lemon"
{
  yymsp[0].minor.yy0 = 0;
}
#line 2611 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 88: /* output_column ::= assignment_expression */
#line 671 "../../groonga/lib/grn_ecmascript.lemon"
{
  yymsp[0].minor.yy0 = 1;
}
#line 2618 "../../groonga/lib/grn_ecmascript.c"
        break;
      default:
      /* (92) input ::= query */ yytestcase(yyruleno==92);
      /* (93) input ::= expression */ yytestcase(yyruleno==93);
      /* (94) input ::= START_OUTPUT_COLUMNS output_columns */ yytestcase(yyruleno==94);
      /* (95) input ::= START_ADJUSTER adjuster */ yytestcase(yyruleno==95);
      /* (96) query ::= query_element (OPTIMIZED OUT) */ assert(yyruleno!=96);
      /* (97) query_element ::= QSTRING */ yytestcase(yyruleno==97);
      /* (98) query_element ::= PARENL query PARENR */ yytestcase(yyruleno==98);
      /* (99) expression ::= assignment_expression (OPTIMIZED OUT) */ assert(yyruleno!=99);
      /* (100) assignment_expression ::= conditional_expression (OPTIMIZED OUT) */ assert(yyruleno!=100);
      /* (101) conditional_expression ::= logical_or_expression */ yytestcase(yyruleno==101);
      /* (102) logical_or_expression ::= logical_and_expression */ yytestcase(yyruleno==102);
      /* (103) logical_and_expression ::= bitwise_or_expression */ yytestcase(yyruleno==103);
      /* (104) bitwise_or_expression ::= bitwise_xor_expression */ yytestcase(yyruleno==104);
      /* (105) bitwise_xor_expression ::= bitwise_and_expression */ yytestcase(yyruleno==105);
      /* (106) bitwise_and_expression ::= equality_expression */ yytestcase(yyruleno==106);
      /* (107) equality_expression ::= relational_expression */ yytestcase(yyruleno==107);
      /* (108) relational_expression ::= shift_expression */ yytestcase(yyruleno==108);
      /* (109) shift_expression ::= additive_expression */ yytestcase(yyruleno==109);
      /* (110) additive_expression ::= multiplicative_expression */ yytestcase(yyruleno==110);
      /* (111) multiplicative_expression ::= unary_expression (OPTIMIZED OUT) */ assert(yyruleno!=111);
      /* (112) unary_expression ::= postfix_expression (OPTIMIZED OUT) */ assert(yyruleno!=112);
      /* (113) postfix_expression ::= lefthand_side_expression */ yytestcase(yyruleno==113);
      /* (114) lefthand_side_expression ::= call_expression (OPTIMIZED OUT) */ assert(yyruleno!=114);
      /* (115) lefthand_side_expression ::= member_expression */ yytestcase(yyruleno==115);
      /* (116) member_expression ::= primary_expression (OPTIMIZED OUT) */ assert(yyruleno!=116);
      /* (117) member_expression ::= member_expression member_expression_part */ yytestcase(yyruleno==117);
      /* (118) primary_expression ::= object_literal (OPTIMIZED OUT) */ assert(yyruleno!=118);
      /* (119) primary_expression ::= PARENL expression PARENR */ yytestcase(yyruleno==119);
      /* (120) primary_expression ::= IDENTIFIER */ yytestcase(yyruleno==120);
      /* (121) primary_expression ::= array_literal (OPTIMIZED OUT) */ assert(yyruleno!=121);
      /* (122) primary_expression ::= DECIMAL */ yytestcase(yyruleno==122);
      /* (123) primary_expression ::= HEX_INTEGER */ yytestcase(yyruleno==123);
      /* (124) primary_expression ::= STRING */ yytestcase(yyruleno==124);
      /* (125) primary_expression ::= BOOLEAN */ yytestcase(yyruleno==125);
      /* (126) primary_expression ::= NULL */ yytestcase(yyruleno==126);
      /* (127) property_name_and_value_list ::= property_name_and_value (OPTIMIZED OUT) */ assert(yyruleno!=127);
      /* (128) property_name_and_value_list ::= property_name_and_value_list COMMA property_name_and_value */ yytestcase(yyruleno==128);
      /* (129) property_name ::= STRING */ yytestcase(yyruleno==129);
      /* (130) member_expression_part ::= DOT IDENTIFIER */ yytestcase(yyruleno==130);
      /* (131) adjuster ::= */ yytestcase(yyruleno==131);
      /* (132) adjuster ::= adjust_expression (OPTIMIZED OUT) */ assert(yyruleno!=132);
      /* (133) adjust_expression ::= adjust_match_expression */ yytestcase(yyruleno==133);
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfoLhs)/sizeof(yyRuleInfoLhs[0]) );
  yygoto = yyRuleInfoLhs[yyruleno];
  yysize = yyRuleInfoNRhs[yyruleno];
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  grn_expr_parserARG_FETCH
  grn_expr_parserCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  grn_expr_parserARG_STORE /* Suppress warning about unused %extra_argument variable */
  grn_expr_parserCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  grn_expr_parserTOKENTYPE yyminor         /* The minor type of the error token */
){
  grn_expr_parserARG_FETCH
  grn_expr_parserCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/
#line 62 "../../groonga/lib/grn_ecmascript.lemon"

  {
    grn_ctx *ctx = efsi->ctx;
    grn_obj message;
    GRN_TEXT_INIT(&message, 0);
    GRN_TEXT_PUT(ctx, &message, efsi->str, efsi->cur - efsi->str);
    GRN_TEXT_PUTC(ctx, &message, '|');
    if (efsi->cur < efsi->str_end) {
      GRN_TEXT_PUTC(ctx, &message, efsi->cur[0]);
      GRN_TEXT_PUTC(ctx, &message, '|');
      GRN_TEXT_PUT(ctx, &message,
                   efsi->cur + 1, efsi->str_end - (efsi->cur + 1));
    } else {
      GRN_TEXT_PUTC(ctx, &message, '|');
    }
    if (ctx->rc == GRN_SUCCESS) {
      ERR(GRN_SYNTAX_ERROR, "Syntax error: <%.*s>",
          (int)GRN_TEXT_LEN(&message), GRN_TEXT_VALUE(&message));
    } else {
      char errbuf[GRN_CTX_MSGSIZE];
      grn_strcpy(errbuf, GRN_CTX_MSGSIZE, ctx->errbuf);
      ERR(ctx->rc, "Syntax error: <%.*s>: %s",
          (int)GRN_TEXT_LEN(&message), GRN_TEXT_VALUE(&message),
          errbuf);
    }
    GRN_OBJ_FIN(ctx, &message);
  }
#line 2750 "../../groonga/lib/grn_ecmascript.c"
/************ End %syntax_error code ******************************************/
  grn_expr_parserARG_STORE /* Suppress warning about unused %extra_argument variable */
  grn_expr_parserCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  grn_expr_parserARG_FETCH
  grn_expr_parserCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  grn_expr_parserARG_STORE /* Suppress warning about unused %extra_argument variable */
  grn_expr_parserCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "grn_expr_parserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void grn_expr_parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  grn_expr_parserTOKENTYPE yyminor       /* The value for the token */
  grn_expr_parserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  grn_expr_parserCTX_FETCH
  grn_expr_parserARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor grn_expr_parserCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int grn_expr_parserFallback(int iToken){
#ifdef YYFALLBACK
  assert( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) );
  return yyFallback[iToken];
#else
  (void)iToken;
  return 0;
#endif
}
