/**
* Copyright 2005-2007 ECMWF
* 
* Licensed under the GNU Lesser General Public License which
* incorporates the terms and conditions of version 3 of the GNU
* General Public License.
* See LICENSE and gpl-3.0.txt for details.
*/

/*
 * C Implementation: grib_get
 *
 * Description:
 *
 *
 * Author: Enrico Fucile <enrico.fucile@ecmwf.int>
 *
 *
 */

#include <stdio.h>
#include <unistd.h>
#include "grib_api_internal.h"


void usage( char*);

int main(int argc, char *argv[])
{
  FILE *f=NULL;
  char* infname=NULL;
  int ret=0;
  grib_context* gc;
  grib_handle* h;
  FILE* of=NULL;
  const void* buffer=NULL;
  size_t size=0;
  char* ofname=NULL;

  if ( argc < 3 ) usage(argv[0]);

  infname=argv[1];
  ofname=argv[2];

  f = fopen(infname,"r");
  if(!f) {
    perror(infname);
    exit(1);
  }

  gc = grib_context_get_default();
  h=grib_handle_new(gc);
  if (!h) {
    printf("Error: unable to create handle\n");
    exit(1);
  }

  GRIB_CHECK(grib_load_from_text_file(h,f),infname);

  if(fclose(f)) {
    perror(infname);
    exit(1);
  }

  of = fopen(ofname,"w");
  if(!of) {
     perror(ofname);
     exit(1);
  }

  grib_get_message(h,&buffer,&size);

  if(fwrite(buffer,1,size,of) != size) {
    perror(ofname);
    exit(1);
  }

  if(fclose(of)) {
    perror(ofname);
    exit(1);
  }

  return ret;

}

void usage(char* progname) {
  printf("\nUsage: %s dump_file outfile.grib\n",progname);
  exit(1);
}
