#include "grib_api.h"

void usage(char* prog) {
  printf("usage: %s infile\n",prog);
  exit(1);
}

int main(int argc,char* argv[]) {
  
  grib_index* index=NULL;
  grib_handle* h=NULL;
  char* infile=NULL;
  char* outfile=NULL;
  long *step,*level,*paramId,*number;
  int i,j,k,l;
  size_t stepSize,levelSize,paramIdSize,numberSize;
  long ostep,olevel,oparamId,onumber;
  int ret=0,count=0;

  if (argc != 2) usage(argv[0]);
  infile=argv[1];
  outfile=argv[2];

  printf("indexing...\n");
  index=grib_index_new_from_file(0,infile,"paramId,level,number,step",&ret);
  if (ret) {printf("error: %s\n",grib_get_error_message(ret)); exit(ret);}
  printf("end indexing...\n");

  GRIB_CHECK(grib_index_get_size(index,"step",&stepSize),0);
  step=malloc(sizeof(long)*stepSize);
  if (!step) exit(1);
  GRIB_CHECK(grib_index_get_long(index,"step",step,&stepSize),0);
  printf("stepSize=%ld\n",(long)stepSize);
  for (i=0;i<stepSize;i++) printf("%ld ",step[i]);
  printf("\n");

  GRIB_CHECK(grib_index_get_size(index,"level",&levelSize),0);
  level=malloc(sizeof(long)*levelSize);
  if (!level) exit(1);
  GRIB_CHECK(grib_index_get_long(index,"level",level,&levelSize),0);
  printf("levelSize=%ld\n",(long)levelSize);
  for (i=0;i<levelSize;i++) printf("%ld ",level[i]);
  printf("\n");

  GRIB_CHECK(grib_index_get_size(index,"number",&numberSize),0);
  number=malloc(sizeof(long)*numberSize);
  if (!number) exit(1);
  GRIB_CHECK(grib_index_get_long(index,"number",number,&numberSize),0);
  printf("numberSize=%ld\n",(long)numberSize);
  for (i=0;i<numberSize;i++) printf("%ld ",number[i]);
  printf("\n");

  GRIB_CHECK(grib_index_get_size(index,"paramId",&paramIdSize),0);
  paramId=malloc(sizeof(long)*paramIdSize);
  if (!paramId) exit(1);
  GRIB_CHECK(grib_index_get_long(index,"paramId",paramId,&paramIdSize),0);
  printf("paramIdSize=%ld\n",(long)paramIdSize);
  for (i=0;i<paramIdSize;i++) printf("%ld ",paramId[i]);
  printf("\n");

  count=0;
  for (i=0;i<paramIdSize;i++) {
    grib_index_select_long(index,"paramId",paramId[i]);

    for (l=0;l<levelSize;l++) {
      grib_index_select_long(index,"level",level[l]);

      for (j=0;j<numberSize;j++) {
        grib_index_select_long(index,"number",number[j]);

        for (k=0;k<stepSize;k++) {
          grib_index_select_long(index,"step",step[k]);

         while ((h=grib_handle_new_from_index(index,&ret))!=NULL){
		   count++;
           if (ret) {printf("error: %d\n",ret); exit(ret);}
		   grib_get_long(h,"paramId",&oparamId);
		   grib_get_long(h,"level",&olevel);
		   grib_get_long(h,"number",&onumber);
		   grib_get_long(h,"step",&ostep);
		   printf("paramId=%ld ",oparamId);
		   printf("level=%ld ",olevel);
		   printf("number=%ld ",onumber);
		   printf("step=%ld \n",ostep);
		 }
         if (ret!=GRIB_END_OF_INDEX) {printf("error: %s\n",grib_get_error_message(ret)); exit(ret);}
	    } 
	  }
	}
  }
  printf("  %d messages selected\n",count);

  return 0;
}

