/*
 * Grdc - GTK+/Gnome Remote Desktop Client
 * Copyright (C) 2009 - Vic Lee 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA.
 */
 

#ifndef __GRDCAPPLETMENUITEM_H__
#define __GRDCAPPLETMENUITEM_H__

G_BEGIN_DECLS

#define GRDC_TYPE_APPLET_MENU_ITEM            (grdc_applet_menu_item_get_type ())
#define GRDC_APPLET_MENU_ITEM(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRDC_TYPE_APPLET_MENU_ITEM, GrdcAppletMenuItem))
#define GRDC_APPLET_MENU_ITEM_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GRDC_TYPE_APPLET_MENU_ITEM, GrdcAppletMenuItemClass))
#define GRDC_IS_APPLET_MENU_ITEM(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRDC_TYPE_APPLET_MENU_ITEM))
#define GRDC_IS_APPLET_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GRDC_TYPE_APPLET_MENU_ITEM))
#define GRDC_APPLET_MENU_ITEM_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GRDC_TYPE_APPLET_MENU_ITEM, GrdcAppletMenuItemClass))

typedef enum
{
    GRDC_APPLET_MENU_ITEM_FILE,
    GRDC_APPLET_MENU_ITEM_QUICK
} GrdcAppletMenuItemType;

typedef struct _GrdcAppletMenuItem
{
    GtkMenuItem menu_item;

    GrdcAppletMenuItemType item_type;
    gchar *filename;
    gchar *name;
    gchar *group;
    gchar *protocol;
} GrdcAppletMenuItem;

typedef struct _GrdcAppletMenuItemClass
{
    GtkMenuItemClass parent_class;
} GrdcAppletMenuItemClass;

GType grdc_applet_menu_item_get_type (void) G_GNUC_CONST;

GtkWidget* grdc_applet_menu_item_new (GrdcAppletMenuItemType item_type, const gchar *filename);
gint grdc_applet_menu_item_compare (gconstpointer a, gconstpointer b, gpointer user_data);

G_END_DECLS

#endif  /* __GRDCAPPLETMENUITEM_H__  */

