:
# DO NOT EDIT THIS FILE
#
# Modified to create "error.log"
##########################################################################
umask 002
cd /tmp

# GMAKE must be set outside this script, by CMD/GISGEN

: ${GMAKE?}
$GMAKE -sh
eval `$GMAKE -sh` || exit 1
: ${GISBASE?} ${SRC?} ${CMD?}

# added 5/2000 MN
errorlog=error.log
rm -f $SRC/../$errorlog     # remove old log

# Start a new error log file:
echo "GRASS GIS compilation log"  > $SRC/../$errorlog
echo "-------------------------" >> $SRC/../$errorlog
STARTTIME=`date`
echo "Start of compilation: $STARTTIME" >> $SRC/../$errorlog
echo "Errors:" >> $SRC/../$errorlog

echo '####################################################################'
echo "GISGEN                             " `date`
echo " GISBASE = $GISBASE"
echo " SRC     = $SRC"
echo " CMD     = $CMD"
echo " HEADER  = $HEADER"


list=lists/GRASS
if test -r $CMD/lists/optional
then
    list="$list lists/optional"
fi
if test -r $CMD/lists/local
then
    list="$list lists/local"
fi
if test "$ARCH" = ""
then
    next_step=$CMD/next_step/next_step
else
    echo " ARCH    = $ARCH"
    next_step=$CMD/next_step/$ARCH
    if test -r $CMD/lists/$ARCH
    then
	list="$list lists/$ARCH"
    fi
fi
echo ""

if test ! -d $GISBASE
then
    echo "GISGEN failure: $GISBASE - directory doesn't exist"
    exit 1
fi

# Make sure GISBASE sub-directories exist
for i in \
    bin \
    man man/help man/man1 man/man2 man/man3 man/man4 man/man5 \
    etc etc/paint etc/paint/driver etc/paint/driver.sh etc/paint/driver.uninst \
    etc/sites etc/dig_drivers etc/imagery \
    etc/bin etc/bin/inter etc/bin/cmd \
    txt txt/COMBINE txt/DIGIT txt/DIGIT2 txt/WEIGHT txt/MONITOR \
    lib include locale \
    driver locks dev
do
    if test ! -d $GISBASE/$i
    then
	mkdir $GISBASE/$i || exit 1
	echo $GISBASE/$i created
    fi
done
chmod 0777 $GISBASE/locks

cd $CMD

# create fifo files for graphics drivers
sh $SRC/scripts/shells/create_fifos.sh $GISBASE


if test "$1" = "-all"
then
    shift
    rm -f $next_step
elif test "$1" = "-skip"
then
    shift
    skip=yes
fi
# determine where to start and what's left to do
case $# in
0)
    tmp1=/tmp/GISGEN1.$$
    tmp2=/tmp/GISGEN2.$$
    tmp3=/tmp/GISGEN3.$$
    rm -f $tmp1
	touch $tmp1
	for i in $list
	do
		grep -v '^#' $i >> $tmp1
	done
    echo DONE >> $tmp1

    if test -r $next_step
    then
	STEP=`cat $next_step`
    else
	STEP=`awk '{print $0;exit}' $tmp1`
    fi
    echo first step: $STEP

    rm -f $tmp2
    rm -f $tmp3
    echo "a == 1 { print \$0 ; next }" > $tmp3
    echo "\$0 == \"$STEP\" { a = 1; print \$0 }" >> $tmp3
    awk -f $tmp3 $tmp1 > $tmp2
    rm -f $tmp3 $tmp1

    STEPS=`cat $tmp2`
    rm -f $tmp2
    if test "$STEPS" = ""
    then
	echo ""
	echo "GISGEN failure: $STEP - not found in $list"
	exit 1
    fi

    set $STEPS
    ;;
*)
    single=1
    ;;
esac

if test "$skip" = yes
then
    echo "Skipped"
    shift
fi


for i
do
    cd $SRC/..
    echo ""
    echo GISGEN: $i - `date`
    echo ""
    bailout=0
    if test "$single" != 1
    then
	echo $i > $next_step
    fi

    case $i in
    DONE)
	echo DONE generating GRASS GIS binary code
	ENDTIME=`date`
	echo "End of compilation:   $ENDTIME" >> $SRC/../$errorlog
	echo DONE generating GRASS GIS binary code >> $SRC/../$errorlog
	exit 0
	;;

    *)
	$GMAKE -v $i
	errorlevel=$?
	case $errorlevel in
	0) ;;
	1) bailout=1 ;;  # module not found, no source code found
	*) bailout=2 ;;  # compile error
	esac
	;;
    esac

    case $bailout in
    1)
	echo GISGEN failure at STEP: $i
  # commented 5/2000: we want to proceed!
  #	exit 1
	echo "Module source code not installed: $i (ignored)" >> $errorlog
	;;
    2)
	echo GISGEN failure at STEP: $i
  # commented 5/2000: we want to proceed!
  #	exit 1
	echo "Compilation error in module: $i (ignored)" >> $errorlog
	;;
    *) ;;
    esac

done
