// -*- c++ -*-
//------------------------------------------------------------------------------
// $Id: PrefWindow.h,v 1.6 2005/01/17 04:19:46 vlg Exp $
//------------------------------------------------------------------------------
//                            PrefWindow.h
//------------------------------------------------------------------------------
//  Copyright (c) 2004 by Vladislav Grinchenko
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//------------------------------------------------------------------------------
//
// Date   : Sun May 30 21:09:23 EDT 2004
//
//------------------------------------------------------------------------------
#ifndef PREF_WINDOW_H
#define PREF_WINDOW_H

#include <gtkmm/main.h>

#include "Granule-main.h"
#include "Config.h"
#include "MyPropertyBox.h"
#include "GeneralPref.h"
#include "SchedulingPrefs.h"
#include "SoundPrefs.h"
#include "GeometryPrefs.h"

class PrefWindow : public MyPropertyBox
{
public:
    PrefWindow (Gtk::Window& parent_);
    ~PrefWindow();
    
    bool run ();

    virtual void apply_impl ();
    virtual void close_impl ();

    void changed_cb ();
    void ok_cb      ();
    void apply_cb   ();
    void cancel_cb  ();

private:
    void stop ();

private:
	GeneralPref     m_general_pref;
	SchedulingPrefs m_scheduling_pref;
	SoundPrefs      m_sound_pref;
	GeometryPrefs   m_geometry_pref;

	bool m_ignore_callbacks;
	bool m_changed;
};

inline
PrefWindow::
~PrefWindow()
{
    trace_with_mask("PrefWindow::~PrefWindow",GUITRACE);
}

inline void
PrefWindow::
stop ()
{
    trace_with_mask("PrefWindow::stop",GUITRACE);
    hide ();
    Gtk::Main::quit ();
}

inline void 
PrefWindow::
changed_cb ()
{
    trace_with_mask("PrefWindow::changed_cb",GUITRACE);

	m_changed = true;
	DL ((GRAPP,"m_changed set to true\n"));

	if (!m_ignore_callbacks) {
		changed ();				// Enable <Apply> button
	}
}

inline void 
PrefWindow::
close_impl ()
{
    trace_with_mask("PrefWindow::close_impl",GUITRACE);
    stop ();
}

#endif /* PREF_WINDOW_H */
