// -*- c++ -*-
//------------------------------------------------------------------------------
//                               MyPropertyBox.h
//------------------------------------------------------------------------------
// $Id: MyPropertyBox.h,v 1.2 2004/10/29 03:16:23 vlg Exp $
//------------------------------------------------------------------------------
//  Copyright (c) 2004 by Vladislav Grinchenko
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version
//  2 of the License, or (at your option) any later version.
//------------------------------------------------------------------------------
#ifndef MY_PROPERTY_BOX_H
#define MY_PROPERTY_BOX_H

#include <gtkmm/dialog.h>
#include <gtkmm/notebook.h>

#include "Granule-main.h"

/*******************************************************************************
 Class 
*******************************************************************************/
class MyPropertyBox : public Gtk::Dialog
{
public:
	MyPropertyBox (const std::string& title_);
	~MyPropertyBox ();

	/** 
	 * When a setting has changed, application code needs to invoke 
	 * this function to make Ok button sensitive.
	 */
	void changed ();

	/**
	 * Append a new page
	 *
	 * @param child_ Widget to add to the new page
	 * @param tab_ Name of the page
	 */
	gint append_page (Gtk::Widget& child_, const std::string& tab_);

	/**
	 * Called in response to pressing Apply button if any changes
	 * were reported prior by the derived class.
	 */
	virtual void apply_impl () = 0;

	/**
	 * Called in response to pressing Close button.
	 */
	virtual void close_impl () = 0;

protected:
	Gtk::Notebook*  m_notebook;
	Gtk::Button*    m_close_button;
	Gtk::Button*    m_apply_button;

private:
	void on_apply_clicked ();
	void on_close_clicked ();

private:
	bool m_property_changed;	// Reflects <Apply> button status only.
};

inline
MyPropertyBox::
~MyPropertyBox ()
{
	trace_with_mask("MyPropertyBox::~MyPropertyBox",GUITRACE);
}


#endif /* MY_PROPERTY_BOX_H */
