// -*- c++ -*-
//------------------------------------------------------------------------------
//                               MyPropertyBox.cpp
//------------------------------------------------------------------------------
// $Id: MyPropertyBox.cpp,v 1.4 2005/01/17 04:19:46 vlg Exp $
//------------------------------------------------------------------------------
//  Copyright (c) 2002-2004 by Vladislav Grinchenko
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version
//  2 of the License, or (at your option) any later version.
//------------------------------------------------------------------------------
// Date: Sun May 30 10:16:48 EDT 2004
//------------------------------------------------------------------------------

#include "MyPropertyBox.h"

/*******************************************************************************
 Class member functions
*******************************************************************************/

MyPropertyBox::
MyPropertyBox (const std::string& title_) :
	m_notebook (manage (new Gtk::Notebook)),
	m_property_changed (false)
{
	trace_with_mask("MyPropertyBox::MyPropertyBox",GUITRACE);

	set_size_request (-1,-1);
	set_title (title_.c_str ());

	m_close_button = manage (new Gtk::Button ("Close"));
	get_action_area ()->pack_start (*m_close_button);
	m_close_button->signal_clicked ().connect (
		sigc::mem_fun (*this, &MyPropertyBox::on_close_clicked));
	m_close_button->show ();

	m_apply_button = manage (new Gtk::Button ("Apply"));
	get_action_area ()->pack_start (*m_apply_button);
	m_apply_button->signal_clicked ().connect (
		sigc::mem_fun (*this, &MyPropertyBox::on_apply_clicked));
	m_apply_button->set_sensitive (false);
	m_apply_button->show ();

	get_vbox ()->pack_start (*m_notebook);
	m_notebook->set_show_border (true);
	m_notebook->show ();
}

gint
MyPropertyBox::
append_page (Gtk::Widget& child_, const std::string& tab_label_)
{
	trace_with_mask("MyPropertyBox::append_page",GUITRACE);
	m_notebook->pages ().push_back (
		Gtk::Notebook_Helpers::TabElem (child_, tab_label_));
	return 0;
}

/**
 * Make Apply button sensitive and remember that something 
 * has changed.
 */
void
MyPropertyBox::
changed ()
{
	trace_with_mask("MyPropertyBox::changed",GUITRACE);

	m_apply_button->set_sensitive (true);
	m_property_changed = true;
}

void
MyPropertyBox::
on_apply_clicked ()
{
	trace_with_mask("MyPropertyBox::on_apply_clicked",GUITRACE);

	if (m_property_changed) {
		apply_impl ();
		m_property_changed = false;
	}
	m_apply_button->set_sensitive (false);
}

void
MyPropertyBox::
on_close_clicked ()
{
	trace_with_mask("MyPropertyBox::on_close_clicked",GUITRACE);
	close_impl ();
	m_apply_button->set_sensitive (false);
}
