/*

    Data automatically generated from recode output:

        'recode -lf "CP1251" 2>/dev/null'


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

*/

#ifndef cp1251_h
#define cp1251_h

#define cet_cs_name_cp1251 "CP1251"

const char *cet_cs_alias_cp1251[] = 
{
	"CP1251", "1251", "ms-cyrl", "windows-1251", "WIN-CP1251",
	NULL
};

#define cet_ucs4_ofs_cp1251 128
#define cet_ucs4_cnt_cp1251 128

const int cet_ucs4_map_cp1251[cet_ucs4_cnt_cp1251] =
{
	0x0402, 0x0403, 0x201a, 0x0453, 0x201e, 0x2026, 0x2020, 0x2021, 
	0x20ac, 0x2030, 0x0409, 0x2039, 0x040a, 0x040c, 0x040b, 0x040f, 
	0x0452, 0x2018, 0x2019, 0x201c, 0x201d, 0x2022, 0x2013, 0x2014, 
	    -1, 0x2122, 0x0459, 0x203a, 0x045a, 0x045c, 0x045b, 0x045f, 
	0x00a0, 0x040e, 0x045e, 0x0408, 0x00a4, 0x0490, 0x00a6, 0x00a7, 
	0x0401, 0x00a9, 0x0404, 0x00ab, 0x00ac, 0x00ad, 0x00ae, 0x0407, 
	0x00b0, 0x00b1, 0x0406, 0x0456, 0x0491, 0x00b5, 0x00b6, 0x00b7, 
	0x0451, 0x2116, 0x0454, 0x00bb, 0x0458, 0x0405, 0x0455, 0x0457, 
	0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0416, 0x0417, 
	0x0418, 0x0419, 0x041a, 0x041b, 0x041c, 0x041d, 0x041e, 0x041f, 
	0x0420, 0x0421, 0x0422, 0x0423, 0x0424, 0x0425, 0x0426, 0x0427, 
	0x0428, 0x0429, 0x042a, 0x042b, 0x042c, 0x042d, 0x042e, 0x042f, 
	0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0436, 0x0437, 
	0x0438, 0x0439, 0x043a, 0x043b, 0x043c, 0x043d, 0x043e, 0x043f, 
	0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447, 
	0x0448, 0x0449, 0x044a, 0x044b, 0x044c, 0x044d, 0x044e, 0x044f
};

#define cet_ucs4_to_cp1251_ct 112

const cet_ucs4_link_t cet_ucs4_to_cp1251_links[cet_ucs4_to_cp1251_ct] =
{
	 {0x0401, 0xa8} /* capital letter io */,
	 {0x0402, 0x80} /* capital letter dje (serbocroatian) */,
	 {0x0403, 0x81} /* capital letter gje (macedonian) */,
	 {0x0404, 0xaa} /* capital letter ukrainian ie */,
	 {0x0405, 0xbd} /* capital letter dze (macedonian) */,
	 {0x0406, 0xb2} /* capital letter byelorussian-ukrainian i */,
	 {0x0407, 0xaf} /* capital letter yi (ukrainian) */,
	 {0x0408, 0xa3} /* capital letter je */,
	 {0x0409, 0x8a} /* capital letter lje */,
	 {0x040a, 0x8c} /* capital letter nje */,
	 {0x040b, 0x8e} /* capital letter tshe (serbocroatian) */,
	 {0x040c, 0x8d} /* capital letter kje (macedonian) */,
	 {0x040e, 0xa1} /* capital letter short u (byelorussian) */,
	 {0x040f, 0x8f} /* capital letter dzhe */,
	 {0x0410, 0xc0} /* capital letter a */,
	 {0x0411, 0xc1} /* capital letter be */,
	 {0x0412, 0xc2} /* capital letter ve */,
	 {0x0413, 0xc3} /* capital letter ghe */,
	 {0x0414, 0xc4} /* capital letter de */,
	 {0x0415, 0xc5} /* capital letter ie */,
	 {0x0416, 0xc6} /* capital letter zhe */,
	 {0x0417, 0xc7} /* capital letter ze */,
	 {0x0418, 0xc8} /* capital letter i */,
	 {0x0419, 0xc9} /* capital letter short i */,
	 {0x041a, 0xca} /* capital letter ka */,
	 {0x041b, 0xcb} /* capital letter el */,
	 {0x041c, 0xcc} /* capital letter em */,
	 {0x041d, 0xcd} /* capital letter en */,
	 {0x041e, 0xce} /* capital letter o */,
	 {0x041f, 0xcf} /* capital letter pe */,
	 {0x0420, 0xd0} /* capital letter er */,
	 {0x0421, 0xd1} /* capital letter es */,
	 {0x0422, 0xd2} /* capital letter te */,
	 {0x0423, 0xd3} /* capital letter u */,
	 {0x0424, 0xd4} /* capital letter ef */,
	 {0x0425, 0xd5} /* capital letter ha */,
	 {0x0426, 0xd6} /* capital letter tse */,
	 {0x0427, 0xd7} /* capital letter che */,
	 {0x0428, 0xd8} /* capital letter sha */,
	 {0x0429, 0xd9} /* capital letter shcha */,
	 {0x042a, 0xda} /* capital letter hard sign */,
	 {0x042b, 0xdb} /* capital letter yeru */,
	 {0x042c, 0xdc} /* capital letter soft sign */,
	 {0x042d, 0xdd} /* capital letter e */,
	 {0x042e, 0xde} /* capital letter yu */,
	 {0x042f, 0xdf} /* capital letter ya */,
	 {0x0430, 0xe0} /* small letter a */,
	 {0x0431, 0xe1} /* small letter be */,
	 {0x0432, 0xe2} /* small letter ve */,
	 {0x0433, 0xe3} /* small letter ghe */,
	 {0x0434, 0xe4} /* small letter de */,
	 {0x0435, 0xe5} /* small letter ie */,
	 {0x0436, 0xe6} /* small letter zhe */,
	 {0x0437, 0xe7} /* small letter ze */,
	 {0x0438, 0xe8} /* small letter i */,
	 {0x0439, 0xe9} /* small letter short i */,
	 {0x043a, 0xea} /* small letter ka */,
	 {0x043b, 0xeb} /* small letter el */,
	 {0x043c, 0xec} /* small letter em */,
	 {0x043d, 0xed} /* small letter en */,
	 {0x043e, 0xee} /* small letter o */,
	 {0x043f, 0xef} /* small letter pe */,
	 {0x0440, 0xf0} /* small letter er */,
	 {0x0441, 0xf1} /* small letter es */,
	 {0x0442, 0xf2} /* small letter te */,
	 {0x0443, 0xf3} /* small letter u */,
	 {0x0444, 0xf4} /* small letter ef */,
	 {0x0445, 0xf5} /* small letter ha */,
	 {0x0446, 0xf6} /* small letter tse */,
	 {0x0447, 0xf7} /* small letter che */,
	 {0x0448, 0xf8} /* small letter sha */,
	 {0x0449, 0xf9} /* small letter shcha */,
	 {0x044a, 0xfa} /* small letter hard sign */,
	 {0x044b, 0xfb} /* small letter yeru */,
	 {0x044c, 0xfc} /* small letter soft sign */,
	 {0x044d, 0xfd} /* small letter e */,
	 {0x044e, 0xfe} /* small letter yu */,
	 {0x044f, 0xff} /* small letter ya */,
	 {0x0451, 0xb8} /* small letter io */,
	 {0x0452, 0x90} /* small letter dje (serbocroatian) */,
	 {0x0453, 0x83} /* small letter gje (macedonian) */,
	 {0x0454, 0xba} /* small letter ukrainian ie */,
	 {0x0455, 0xbe} /* small letter dze (macedonian) */,
	 {0x0456, 0xb3} /* small letter byelorussian-ukrainian i */,
	 {0x0457, 0xbf} /* small letter yi (ukrainian) */,
	 {0x0458, 0xbc} /* small letter je */,
	 {0x0459, 0x9a} /* small letter lje */,
	 {0x045a, 0x9c} /* small letter nje */,
	 {0x045b, 0x9e} /* small letter tshe (serbocroatian) */,
	 {0x045c, 0x9d} /* small letter kje (macedonian) */,
	 {0x045e, 0xa2} /* small letter short u (byelorussian) */,
	 {0x045f, 0x9f} /* small letter dzhe */,
	 {0x0490, 0xa5} /* capital letter ghe with upturn */,
	 {0x0491, 0xb4} /* small letter ghe with upturn */,
	 {0x2013, 0x96} /* dash */,
	 {0x2014, 0x97} /* dash */,
	 {0x2018, 0x91} /* single quotation mark */,
	 {0x2019, 0x92} /* single quotation mark */,
	 {0x201a, 0x82} /* low-9 quotation mark */,
	 {0x201c, 0x93} /* double quotation mark */,
	 {0x201d, 0x94} /* double quotation mark */,
	 {0x201e, 0x84} /* low-9 quotation mark */,
	 {0x2020, 0x86} /* dagger */,
	 {0x2021, 0x87} /* dagger */,
	 {0x2022, 0x95} /* puce */,
	 {0x2026, 0x85} /* horizontal ellipsis */,
	 {0x2030, 0x89} /* mille sign */,
	 {0x2039, 0x8b} /* left-pointing angle quotation mark */,
	 {0x203a, 0x9b} /* right-pointing angle quotation mark */,
	 {0x20ac, 0x88} /* euro */,
	 {0x2116, 0xb9} /* sign */,
	 {0x2122, 0x99} /* mark sign */
};

/* Extra table was generated from bestfit1251.txt located at
   ftp.unicode.org:/Public/MAPPINGS/VENDORS/MICSFT/WindowsBestFit/ */
  
const cet_ucs4_link_t cet_ucs4_to_cp1251_extra[] = 
{
	{0x2195, 0xa6} /* up down arrow */,
	{0x21a8, 0xa6} /* up down arrow with base */,
	{0x2219, 0x95} /* bullet operator */,
	{0x2302, 0xa6} /* house */,
	{0x2502, 0xa6} /* box drawings light vertical */,
	{0x2510, 0xac} /* box drawings light down and left */,
	{0x2551, 0xa6} /* box drawings double vertical */,
	{0x2553, 0xe3} /* box drawings down double and right single */,
	{0x2554, 0xe3} /* box drawings double down and right */,
	{0x2555, 0xac} /* box drawings down single and left double */,
	{0x2556, 0xac} /* box drawings down double and left single */,
	{0x2557, 0xac} /* box drawings double down and left */,
	{0x255e, 0xa6} /* box drawings vertical single and right double */,
	{0x255f, 0xa6} /* box drawings vertical double and right single */,
	{0x2560, 0xa6} /* box drawings double vertical and right */,
	{0x2561, 0xa6} /* box drawings vertical single and left double */,
	{0x2562, 0xa6} /* box drawings vertical double and left single */,
	{0x2563, 0xa6} /* box drawings double vertical and left */,
	{0x2567, 0xa6} /* box drawings up single and horizontal double */,
	{0x2568, 0xa6} /* box drawings up double and horizontal single */,
	{0x2569, 0xa6} /* box drawings double up and horizontal */,
	{0x258c, 0xa6} /* left half block */,
	{0x2590, 0xa6} /* right half block */,
	{0x25a0, 0xa6} /* black square */,
	{0x25bc, 0xa1} /* black down-pointing triangle */,
	{0x25d8, 0x95} /* inverse bullet */,
	{0x2660, 0xa6} /* black spade suit */,
	{0x2663, 0xa6} /* black club suit */,
	{0x2665, 0xa6} /* black heart suit */,
	{0x2666, 0xa6} /* black diamond suit */
};

#define cet_ucs4_to_cp1251_extra_ct sizeof(cet_ucs4_to_cp1251_extra) / sizeof(cet_ucs4_to_cp1251_extra[0])

cet_cs_vec_t cet_cs_vec_cp1251 =	/* defined in cet.h */
{	
	cet_cs_name_cp1251,		/* name of character set	*/
	cet_cs_alias_cp1251,		/* alias table			*/

	NULL,				/* ... to UCS-4 converter (multi-byte) */
	NULL,				/* UCS-4 to ... converter (multi-byte) */

	cet_ucs4_map_cp1251,		/* char to UCS-4 value table	*/
	cet_ucs4_ofs_cp1251,		/* first non standard character	*/
	cet_ucs4_cnt_cp1251,		/* number of values in table	*/

	cet_ucs4_to_cp1251_links,	/* UCS-4 to char links		*/
	cet_ucs4_to_cp1251_ct,		/* number of links		*/

	cet_ucs4_to_cp1251_extra,	/* hand made UCS-4 links	*/
	cet_ucs4_to_cp1251_extra_ct,	/* number of extra links	*/

	NULL	/* for internal use */
};


/*
const int cp1251_ucs4_full_map[] =
{
	0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007, 
	0x0008, 0x0009, 0x000a, 0x000b, 0x000c, 0x000d, 0x000e, 0x000f, 
	0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017, 
	0x0018, 0x0019, 0x001a, 0x001b, 0x001c, 0x001d, 0x001e, 0x001f, 
	0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 
	0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 
	0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 
	0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 
	0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 
	0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 
	0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 
	0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f, 
	0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 
	0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 
	0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 
	0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e, 0x007f, 
	0x0402, 0x0403, 0x201a, 0x0453, 0x201e, 0x2026, 0x2020, 0x2021, 
	0x20ac, 0x2030, 0x0409, 0x2039, 0x040a, 0x040c, 0x040b, 0x040f, 
	0x0452, 0x2018, 0x2019, 0x201c, 0x201d, 0x2022, 0x2013, 0x2014, 
	    -1, 0x2122, 0x0459, 0x203a, 0x045a, 0x045c, 0x045b, 0x045f, 
	0x00a0, 0x040e, 0x045e, 0x0408, 0x00a4, 0x0490, 0x00a6, 0x00a7, 
	0x0401, 0x00a9, 0x0404, 0x00ab, 0x00ac, 0x00ad, 0x00ae, 0x0407, 
	0x00b0, 0x00b1, 0x0406, 0x0456, 0x0491, 0x00b5, 0x00b6, 0x00b7, 
	0x0451, 0x2116, 0x0454, 0x00bb, 0x0458, 0x0405, 0x0455, 0x0457, 
	0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0416, 0x0417, 
	0x0418, 0x0419, 0x041a, 0x041b, 0x041c, 0x041d, 0x041e, 0x041f, 
	0x0420, 0x0421, 0x0422, 0x0423, 0x0424, 0x0425, 0x0426, 0x0427, 
	0x0428, 0x0429, 0x042a, 0x042b, 0x042c, 0x042d, 0x042e, 0x042f, 
	0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0436, 0x0437, 
	0x0438, 0x0439, 0x043a, 0x043b, 0x043c, 0x043d, 0x043e, 0x043f, 
	0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447, 
	0x0448, 0x0449, 0x044a, 0x044b, 0x044c, 0x044d, 0x044e, 0x044f
};
*/

#endif
