/*
 * GProFTPD - A GTK+ frontend for the ProFTPD standalone server.
 * Copyright (C) 2001, 2002, 2003, 2004, 2005 Magnus-swe <magnus-swe@telia.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#include "../config.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include "import_functions.h"
#include "import_window.h"
#include "support.h"

#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

#define GLADE_HOOKUP_OBJECT_NO_REF(component,widget,name) \
  g_object_set_data (G_OBJECT (component), name, widget)

GtkWidget*
create_import_window (void)
{
  GtkWidget *import_window;
  GtkWidget *import_vbox;
  GtkWidget *import_label0;
  GtkWidget *import_scrolledwindow;
  GtkWidget *import_treeview;
  GtkWidget *label4;
  GtkWidget *import_hbox1;
  GtkWidget *import_label1;
  GtkWidget *import_home_dir_entry;
  GtkWidget *import_hbox3;
  GtkWidget *import_label2;
  GtkWidget *import_namebased_checkbutton;
  GtkWidget *import_hbox2;
  GtkWidget *import_label3;
  GtkWidget *import_upload_entry;
  GtkWidget *import_upload_checkbutton;
  GtkWidget *import_label4;
  GtkWidget *import_hbuttonbox;
  GtkWidget *import_button;
  GtkWidget *alignment1;
  GtkWidget *hbox2;
  GtkWidget *image1;
  GtkWidget *label2;
  GtkWidget *import_cancel_button;
  GtkWidget *alignment2;
  GtkWidget *hbox3;
  GtkWidget *image2;
  GtkWidget *label3;
  GtkTooltips *tooltips;

  tooltips = gtk_tooltips_new ();

  import_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_size_request (import_window, 560, 350);
  gtk_window_set_title (GTK_WINDOW (import_window), _("Select any users you want to import"));
  gtk_window_set_position (GTK_WINDOW (import_window), GTK_WIN_POS_CENTER);

  import_vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (import_vbox);
  gtk_container_add (GTK_CONTAINER (import_window), import_vbox);

  import_label0 = gtk_label_new (_("Import users to the currently selected server."));
  gtk_widget_show (import_label0);
  gtk_box_pack_start (GTK_BOX (import_vbox), import_label0, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (import_label0), GTK_JUSTIFY_LEFT);
  gtk_misc_set_padding (GTK_MISC (import_label0), 0, 5);

  import_scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (import_scrolledwindow);
  gtk_box_pack_start (GTK_BOX (import_vbox), import_scrolledwindow, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (import_scrolledwindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  import_treeview = gtk_tree_view_new ();
  gtk_widget_show (import_treeview);
  gtk_container_add (GTK_CONTAINER (import_scrolledwindow), import_treeview);
  gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (import_treeview), TRUE);

  label4 = gtk_label_new (_("All selected users will be imported with the following settings:"));
  gtk_widget_show (label4);
  gtk_box_pack_start (GTK_BOX (import_vbox), label4, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label4), GTK_JUSTIFY_LEFT);

  import_hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (import_hbox1);
  gtk_box_pack_start (GTK_BOX (import_vbox), import_hbox1, FALSE, FALSE, 0);

  import_label1 = gtk_label_new (_("The users will have this root directory:"));
  gtk_widget_show (import_label1);
  gtk_box_pack_start (GTK_BOX (import_hbox1), import_label1, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (import_label1), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (import_label1), 0.02, 0.5);
  gtk_misc_set_padding (GTK_MISC (import_label1), 5, 10);

  import_home_dir_entry = gtk_entry_new ();
  gtk_widget_show (import_home_dir_entry);
  gtk_box_pack_start (GTK_BOX (import_hbox1), import_home_dir_entry, TRUE, TRUE, 20);
  gtk_entry_set_text (GTK_ENTRY (import_home_dir_entry), "/home/ftp");

  import_hbox3 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (import_hbox3);
  gtk_box_pack_start (GTK_BOX (import_vbox), import_hbox3, FALSE, FALSE, 0);

  import_label2 = gtk_label_new (_("They will have username based directories under the root directory:"));
  gtk_widget_show (import_label2);
  gtk_box_pack_start (GTK_BOX (import_hbox3), import_label2, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (import_label2), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (import_label2), 0.02, 0.5);
  gtk_misc_set_padding (GTK_MISC (import_label2), 5, 7);

  import_namebased_checkbutton = gtk_check_button_new_with_mnemonic ("");
  gtk_widget_show (import_namebased_checkbutton);
  gtk_box_pack_start (GTK_BOX (import_hbox3), import_namebased_checkbutton, FALSE, FALSE, 0);

  import_hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (import_hbox2);
  gtk_box_pack_start (GTK_BOX (import_vbox), import_hbox2, FALSE, FALSE, 0);

  import_label3 = gtk_label_new (_("Add an upload directory under the root directory:"));
  gtk_widget_show (import_label3);
  gtk_box_pack_start (GTK_BOX (import_hbox2), import_label3, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (import_label3), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (import_label3), 0.02, 0.5);
  gtk_misc_set_padding (GTK_MISC (import_label3), 5, 3);

  import_upload_entry = gtk_entry_new ();
  gtk_widget_show (import_upload_entry);
  gtk_box_pack_start (GTK_BOX (import_hbox2), import_upload_entry, TRUE, TRUE, 0);
  gtk_tooltips_set_tip (tooltips, import_upload_entry, _("If you delete all text here and check the checkbutton then users will be able to upload directly in the root directory"), NULL);
  gtk_entry_set_text (GTK_ENTRY (import_upload_entry), "upload");

  import_upload_checkbutton = gtk_check_button_new_with_mnemonic ("");
  gtk_widget_show (import_upload_checkbutton);
  gtk_box_pack_start (GTK_BOX (import_hbox2), import_upload_checkbutton, FALSE, FALSE, 13);

  import_label4 = gtk_label_new ("");
  gtk_widget_show (import_label4);
  gtk_box_pack_start (GTK_BOX (import_vbox), import_label4, FALSE, FALSE, 0);
  gtk_widget_set_size_request (import_label4, -1, 16);
  gtk_label_set_justify (GTK_LABEL (import_label4), GTK_JUSTIFY_LEFT);

  import_hbuttonbox = gtk_hbutton_box_new ();
  gtk_widget_show (import_hbuttonbox);
  gtk_box_pack_start (GTK_BOX (import_vbox), import_hbuttonbox, FALSE, FALSE, 0);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (import_hbuttonbox), GTK_BUTTONBOX_SPREAD);

  import_button = gtk_button_new ();
  gtk_widget_show (import_button);
  gtk_container_add (GTK_CONTAINER (import_hbuttonbox), import_button);
  GTK_WIDGET_SET_FLAGS (import_button, GTK_CAN_DEFAULT);

  alignment1 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment1);
  gtk_container_add (GTK_CONTAINER (import_button), alignment1);

  hbox2 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox2);
  gtk_container_add (GTK_CONTAINER (alignment1), hbox2);

  image1 = gtk_image_new_from_stock ("gtk-yes", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image1);
  gtk_box_pack_start (GTK_BOX (hbox2), image1, FALSE, FALSE, 0);

  label2 = gtk_label_new_with_mnemonic (_("Import"));
  gtk_widget_show (label2);
  gtk_box_pack_start (GTK_BOX (hbox2), label2, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label2), GTK_JUSTIFY_LEFT);

  import_cancel_button = gtk_button_new ();
  gtk_widget_show (import_cancel_button);
  gtk_container_add (GTK_CONTAINER (import_hbuttonbox), import_cancel_button);
  GTK_WIDGET_SET_FLAGS (import_cancel_button, GTK_CAN_DEFAULT);

  alignment2 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment2);
  gtk_container_add (GTK_CONTAINER (import_cancel_button), alignment2);

  hbox3 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox3);
  gtk_container_add (GTK_CONTAINER (alignment2), hbox3);

  image2 = gtk_image_new_from_stock ("gtk-cancel", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image2);
  gtk_box_pack_start (GTK_BOX (hbox3), image2, FALSE, FALSE, 0);

  label3 = gtk_label_new_with_mnemonic (_("Cancel"));
  gtk_widget_show (label3);
  gtk_box_pack_start (GTK_BOX (hbox3), label3, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label3), GTK_JUSTIFY_LEFT);

  g_signal_connect ((gpointer) import_window, "map",
                    G_CALLBACK (on_import_window_map),
                    NULL);
  g_signal_connect ((gpointer) import_namebased_checkbutton, "toggled",
                    G_CALLBACK (on_import_namebased_checkbutton_toggled),
                    NULL);
  g_signal_connect ((gpointer) import_upload_checkbutton, "toggled",
                    G_CALLBACK (on_import_upload_checkbutton_toggled),
                    NULL);
  g_signal_connect ((gpointer) import_button, "clicked",
                    G_CALLBACK (on_import_button_clicked),
                    NULL);
  g_signal_connect_swapped ((gpointer) import_cancel_button, "clicked",
                            G_CALLBACK (gtk_widget_destroy),
                            GTK_OBJECT (import_window));

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (import_window, import_window, "import_window");
  GLADE_HOOKUP_OBJECT (import_window, import_vbox, "import_vbox");
  GLADE_HOOKUP_OBJECT (import_window, import_label0, "import_label0");
  GLADE_HOOKUP_OBJECT (import_window, import_scrolledwindow, "import_scrolledwindow");
  GLADE_HOOKUP_OBJECT (import_window, import_treeview, "import_treeview");
  GLADE_HOOKUP_OBJECT (import_window, label4, "label4");
  GLADE_HOOKUP_OBJECT (import_window, import_hbox1, "import_hbox1");
  GLADE_HOOKUP_OBJECT (import_window, import_label1, "import_label1");
  GLADE_HOOKUP_OBJECT (import_window, import_home_dir_entry, "import_home_dir_entry");
  GLADE_HOOKUP_OBJECT (import_window, import_hbox3, "import_hbox3");
  GLADE_HOOKUP_OBJECT (import_window, import_label2, "import_label2");
  GLADE_HOOKUP_OBJECT (import_window, import_namebased_checkbutton, "import_namebased_checkbutton");
  GLADE_HOOKUP_OBJECT (import_window, import_hbox2, "import_hbox2");
  GLADE_HOOKUP_OBJECT (import_window, import_label3, "import_label3");
  GLADE_HOOKUP_OBJECT (import_window, import_upload_entry, "import_upload_entry");
  GLADE_HOOKUP_OBJECT (import_window, import_upload_checkbutton, "import_upload_checkbutton");
  GLADE_HOOKUP_OBJECT (import_window, import_label4, "import_label4");
  GLADE_HOOKUP_OBJECT (import_window, import_hbuttonbox, "import_hbuttonbox");
  GLADE_HOOKUP_OBJECT (import_window, import_button, "import_button");
  GLADE_HOOKUP_OBJECT (import_window, alignment1, "alignment1");
  GLADE_HOOKUP_OBJECT (import_window, hbox2, "hbox2");
  GLADE_HOOKUP_OBJECT (import_window, image1, "image1");
  GLADE_HOOKUP_OBJECT (import_window, label2, "label2");
  GLADE_HOOKUP_OBJECT (import_window, import_cancel_button, "import_cancel_button");
  GLADE_HOOKUP_OBJECT (import_window, alignment2, "alignment2");
  GLADE_HOOKUP_OBJECT (import_window, hbox3, "hbox3");
  GLADE_HOOKUP_OBJECT (import_window, image2, "image2");
  GLADE_HOOKUP_OBJECT (import_window, label3, "label3");
  GLADE_HOOKUP_OBJECT_NO_REF (import_window, tooltips, "tooltips");

  return import_window;
}

