/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*

  satlog.h: Logger terminal for Gnome Predict.

  Copyright (C)  2001-2005  Alexandru Csete.

  Authors:  Alexandru Csete <csete@users.sourceforge.net>

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/

#ifndef SATLOG_H
#define SATLOG_H

/* When to write LOG message to message window */
typedef enum {
	SAT_LOG_NONE     = 1 << 0,     /* a somehow stupid option but... */
	SAT_LOG_ERROR    = 1 << 1,     /* ERROR messages -> ABORT PROGRAM */
	SAT_LOG_CRITICAL = 1 << 2,     /* Critical, but try to continue */
	SAT_LOG_WARNING  = 1 << 3,     /* A harmless warning */
	SAT_LOG_MESSAGE  = 1 << 4,     /* A message like "you should update your TLE" */
	SAT_LOG_INFO     = 1 << 5,     /* fx. response to a user query */
	SAT_LOG_DEBUG    = 1 << 6      /* Blow the message-window with all we've got! */
} sat_log_level_t;


/* main API functions */
void satlog_init  (void);
void satlog_log   (sat_log_level_t, const gchar *);
void satlog_show  (void);
void satlog_hide  (void);

#endif
