/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
  satconfig-rig.c:  RIG module for the configuration druid.

  Copyright (C)  2001-2005  Alexandru Csete

  Authors: Alexandru Csete <csete@users.sourceforge.net>

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

/* leave file empty if we don't have hamlib */
#if defined (HAVE_HAMLIB)

#include <gnome.h>
#include <gconf/gconf.h>
#include <gconf/gconf-client.h>

#include "hamlib-widgets.h"
#include "riglist-util.h"
#include "satconfig-rig.h"
#include <hamlib/rig.h>


extern GdkColor logobg; /* defined in satconfig.c */
extern GConfClient *client;  /* main.c */
static guint rigid;
static gint  defrig = -1;     /* default rig in configuration */
static GtkWidget *page,*swin,*rigclist;
static GtkWidget *frame,*table,*hbox,*speedw;
static GtkWidget *idlabel,*mfglabel,*mlabel,*drlabel;
static GtkWidget *port;

/* Private function prototypes */
static void satconfig_rig_select_row_cb (GtkWidget *, gint, gint, GdkEventButton *, gpointer);

const gchar *rportinfo = N_("Specify the device your radio is connected to, "\
			    "or the hostname if you wish to connect to rpc.rigd "\
			    "which is running on a remote machine.");


GtkWidget *satconfig_rig_create (/*GtkWidget *druid*/)
{
	/* This function creates a GnomeDruidPageStandard containing
	   all necessary widgets for configuring the radios. This
	   function should only be called from the main configuration
	   druid function.
	*/

	GSList *riglist = NULL;
	GtkWidget *label;
	GdkImlibImage *logo;
	gchar *fname;

	/* get list of drivers */
	riglist = riglist_get_list ();

	/* create a columned list */
	rigclist = hamlib_riglist_widget_new (riglist);
	gtk_signal_connect (GTK_OBJECT (rigclist), "select-row",
			    GTK_SIGNAL_FUNC (satconfig_rig_select_row_cb),
			    NULL);

	/* don't need it anymore */
/*	g_slist_free (riglist); */
	
	/* pack the clist into a scrolled window */
	swin = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (swin),
					GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	gtk_container_add (GTK_CONTAINER (swin), rigclist);


	/* create druid page */
	page = gnome_druid_page_standard_new_with_vals (_("Default Radio"), 
							NULL);
	gnome_druid_page_standard_set_bg_color (GNOME_DRUID_PAGE_STANDARD (page),
						&logobg);
	gnome_druid_page_standard_set_logo_bg_color (GNOME_DRUID_PAGE_STANDARD (page),
						     &logobg);

	/* add logo */
	fname = g_strconcat (PACKAGE_PIXMAPS_DIR, G_DIR_SEPARATOR_S,
			     "icons", G_DIR_SEPARATOR_S, "ic910.png",
			     NULL);
	logo = gdk_imlib_load_image (fname);
	g_free (fname);
	gnome_druid_page_standard_set_logo (GNOME_DRUID_PAGE_STANDARD (page), logo);
	gdk_imlib_destroy_image (logo);

	gtk_container_set_border_width (GTK_CONTAINER (GNOME_DRUID_PAGE_STANDARD (page)->vbox), 5);

	/* Status stuff */
	table = gtk_table_new (8, 2, FALSE);
	gtk_table_set_col_spacings (GTK_TABLE (table), 10);
	gtk_table_set_row_spacings (GTK_TABLE (table), 0);

	/* table contents */
	label = gtk_label_new (_("Hamlib ID:"));
	gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
	gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 0, 1);
	idlabel = gtk_label_new (NULL);
	gtk_misc_set_alignment (GTK_MISC (idlabel), 0.0, 0.5);
	gtk_table_attach_defaults (GTK_TABLE (table), idlabel, 1, 2, 0, 1);
	label = gtk_label_new (_("Manufacturer:"));
	gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
	gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 1, 2);
	mfglabel = gtk_label_new (NULL);
	gtk_misc_set_alignment (GTK_MISC (mfglabel), 0.0, 0.5);
	gtk_table_attach_defaults (GTK_TABLE (table), mfglabel, 1, 2, 1, 2);
	label = gtk_label_new (_("Model:"));
	gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
	gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 2, 3);
	mlabel = gtk_label_new (NULL);
	gtk_misc_set_alignment (GTK_MISC (mlabel), 0.0, 0.5);
	gtk_table_attach_defaults (GTK_TABLE (table), mlabel, 1, 2, 2, 3);
	label = gtk_label_new (_("Driver Status:"));
	gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
	gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 3, 4);
	drlabel = gtk_label_new (NULL);
	gtk_misc_set_alignment (GTK_MISC (drlabel), 0.0, 0.5);
	gtk_table_attach_defaults (GTK_TABLE (table), drlabel, 1, 2, 3, 4);

	/* update labels... */
	satconfig_rig_select_row_cb (rigclist, 0, 0, NULL, NULL);

	label = gtk_label_new (_("Port:"));
	gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
	gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 4, 5);

	/* port entry */
	port = gtk_entry_new ();
	gtk_widget_set (port, "width", 50, NULL);
	gtk_entry_set_text (GTK_ENTRY (port), "/dev/ttyS0");
	gtk_table_attach_defaults (GTK_TABLE (table), port, 1, 2, 4, 5);

	/* speed selector */
	label = gtk_label_new (_("Serial Speed:"));
	gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
	gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 5, 6);
	speedw = gtk_option_menu_new ();
	gtk_option_menu_set_menu (GTK_OPTION_MENU (speedw), hamlib_widgets_create_serial_rate_menu ());
	gtk_option_menu_set_history (GTK_OPTION_MENU (speedw), 0);
	gtk_table_attach_defaults (GTK_TABLE (table), speedw, 1, 2, 5, 6);

	/* port info label */
	label = gtk_label_new (rportinfo);
	gtk_label_set_line_wrap (GTK_LABEL (label), TRUE);
	gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 2, 6, 8);

	/* frame */
	frame = gtk_frame_new (_("Selected Radio"));
	gtk_frame_set_label_align (GTK_FRAME (frame), 0.5, 0.5);
	gtk_container_add (GTK_CONTAINER (frame), table);

	/* horizontal box */
	hbox = gtk_hbox_new (FALSE, 10);
	gtk_box_pack_start_defaults (GTK_BOX (hbox), swin);
	gtk_box_pack_end_defaults (GTK_BOX (hbox), frame);

	/* add contents to druid page */
	gtk_box_pack_start_defaults (GTK_BOX (GNOME_DRUID_PAGE_STANDARD (page)->vbox), hbox);

	/* Check whether we already have a rig configuration. If so, read it. */
	if (gconf_client_dir_exists (client, SAT_CONFIG_RIG_DIR, NULL)) {
		gchar *key;
		guint  i;

		/* get pointer to default rig */
		key = g_strconcat (SAT_CONFIG_RIG_DIR, "/default", NULL);
		defrig = gconf_client_get_int (client, key, NULL);
		g_free (key);

		/* get rigid */
		key = g_strdup_printf ("%s/rig%d_id", SAT_CONFIG_RIG_DIR, defrig);
		rigid = gconf_client_get_int (client, key, NULL);
		g_free (key);

		/* loop through the clist to find a matching rigid */
		for (i=0; i < GTK_CLIST (rigclist)->rows; i++) {
			
			if (rigid == GPOINTER_TO_UINT (gtk_clist_get_row_data (GTK_CLIST (rigclist), i))) {

				/* Bingo! Select row */
				gtk_clist_select_row (GTK_CLIST (rigclist), i, 0);

				/* Stop iteration */
				i = GTK_CLIST (rigclist)->rows;
			}

		}
	}

	return page;
}



static void
satconfig_rig_select_row_cb (GtkWidget *clist, gint row, gint column,
			      GdkEventButton *button, gpointer data)
{
	/* This function is called when the user selects a new radio
	   from the list.
	*/
	gchar *buff[50];

	rigid = GPOINTER_TO_UINT (gtk_clist_get_row_data (GTK_CLIST (clist), row));
	if (gtk_clist_get_text (GTK_CLIST (clist), row, 0, buff))
		gtk_label_set_text (GTK_LABEL (idlabel), *buff);
	if (gtk_clist_get_text (GTK_CLIST (clist), row, 1, buff))
		gtk_label_set_text (GTK_LABEL (mfglabel), *buff);
	if (gtk_clist_get_text (GTK_CLIST (clist), row, 2, buff))
		gtk_label_set_text (GTK_LABEL (mlabel), *buff);
	if (gtk_clist_get_text (GTK_CLIST (clist), row, 3, buff))
		gtk_label_set_text (GTK_LABEL (drlabel), *buff);
}



gint satconfig_rig_cancel ()
{
	/* This function should be called by the main config druid
	   cancel callback. The function returns 0 if everything was
	   all right or 1 if an error has occured.
	*/
 
	
	return 0;
}


gint satconfig_rig_finish ()
{
	/* This function should be called by the main config druid
	   finish callback function. The function returns 0 if
	   everything was all right or 1 if an error has occured.
	*/
	gboolean ok = TRUE;
	GtkWidget *activemenu;
	guint speed;
	gchar *key;


	if (defrig == -1) {
		defrig = 0;
	}

	/* pointer to default */
	key = g_strdup_printf ("%s/default", SAT_CONFIG_RIG_DIR);
	ok = ok && gconf_client_set_int (client, key, defrig, NULL);
	g_free (key);

	/* RIG id */
	key = g_strdup_printf ("%s/rig%d_id", SAT_CONFIG_RIG_DIR, defrig);
	ok = ok && gconf_client_set_int (client, key, rigid, NULL);
	g_free (key);

	/* Manufacturer */
	key = g_strdup_printf ("%s/rig%d_brand", SAT_CONFIG_RIG_DIR, defrig);
	ok = ok && gconf_client_set_string (client, key, GTK_LABEL (mfglabel)->label, NULL);
	g_free (key);

	/* Model */
	key = g_strdup_printf ("%s/rig%d_model", SAT_CONFIG_RIG_DIR, defrig);
	ok = ok && gconf_client_set_string (client, key, GTK_LABEL (mlabel)->label, NULL);
	g_free (key);

	/* port */
	key = g_strdup_printf ("%s/rig%d_port", SAT_CONFIG_RIG_DIR, defrig);
	ok = ok && gconf_client_set_string (client, key, gtk_entry_get_text (GTK_ENTRY (port)), NULL);
	g_free (key);

	/* serial speed */
	key = g_strdup_printf ("%s/rig%d_speed", SAT_CONFIG_RIG_DIR, defrig);
	activemenu = gtk_menu_get_active (GTK_MENU (gtk_option_menu_get_menu (GTK_OPTION_MENU (speedw))));
	speed = GPOINTER_TO_UINT (gtk_object_get_data (GTK_OBJECT (activemenu), "speed"));
	ok = ok && gconf_client_set_int (client, key, speed, NULL);
	g_free (key);

	return (gint) !ok;  /* shoot me again, please! */
}


#endif  /* HAVE_HAMLIB */
