/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
  defaults.h:  Defaults and initial values.

  Copyright (C)  2001-2005  Alexandru Csete.

  Authors:   Alexandru Csete <csete@users.sourceforge.net>

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/

#ifndef DEFAULTS_H
#define DEFAULTS_H


#ifndef PI
#define PI 3.141592654
#endif

/* Max. number of satellites */
#define SAT_MAX 500


/* Default timer intervals in msec */
#define ENGINE_DEF_TIMER        100     /* tracking routines */
#define SUN_DEF_TIMER           1600    /* Sun updates */
#define MOON_DEF_TIMER          1400    /* Moon updates */
#define CLOCK_DEF_TIMER         1000    /* Clock updates */

/* GConf paths */
#define SUN_TIMER_PATH          "/apps/gpredict/sun/timer"  /* path to update interval for sun */
#define MOON_TIMER_PATH         "/apps/gpredict/moon/timer" /* path to update interval for moon */
#define CLOCK_TIMER_PATH        "/apps/gpredict/clock/timer"  /* path to update interval for clock */
#define ENGINE_TIMER_PATH       "/apps/gpredict/engine/timer"          /* path to update interval for tracking engine */
#define SATLOG_VISIBLE_PATH     "/apps/gpredict/satlog/visible"    /* path to message box visibility */
#define SATLOG_LOGLEVEL_PATH    "/apps/gpredict/satlog/loglevel"   /* path to logging level for message box */
#define QTH_FILE_PATH           "/gpredict/qth/qthfile"            /* path to QTH file */
#define TLE_FILE_PATH           "/gpredict/tle/tlefile"            /* path to TLE file */

#define AOS_SIMPLE_NUM_PATH     "/apps/gpredict/predict/number_of_passes"     /* number of passes to predict */
#define AOS_SIMPLE_SAVE_PATH    "/apps/gpredict/predict/simple_savedir"       /* where to save simple predict data */
#define AOS_DETAIL_RES_PATH     "/apps/gpredict/predict/detailed_resolution"  /* time resolution in sec for det. predict */
#define AOS_DETAIL_MASK_PATH    "/apps/gpredict/predict/detailed_mask"        /* what do users want to have shown */
#define AOS_DETAIL_SAVE_PATH    "/apps/gpredict/predict/detailed_savedir"     /* where to save detailed predict data */
#define AOS_MIN_ELEV_PATH       "/apps/gpredict/predict/min_elev"             /* minimum elevation */

#define AOS_SIMPLE_DEF_NUM  15     /* Default number of upcomming passes to predict */
#define AOS_DETAIL_DEF_RES  60     /* Default time resolution [sec] */
#define AOS_DETAIL_DEF_MASK 255    /* just show everything! */

/* Frequently used time format strings */
#define TFORM_UNIX              "%a %b %d %H:%M:%S UTC %Y"
#define TFORM_SATLIST           "%Y/%m/%d %H:%M:%S"
#define TFORM_AOS               " %a %b %d %Y %H:%M:%S "


/* RIG specific defaults */
#define RIG_DEF_PORT           "/dev/ttyS1"


/* These constants are used by the numerical
   code from predict.
*/
#define DEG2RAD                 1.74532925199e-02
#define TP                      6.283185307179586
#define PT                      1.570796326794897
#define S1                      0.397818675
#define C1                      0.91746406
#define R0                      6378.135
#define FF                      3.35289186924e-03
#define KM                      1.609344


#endif
