/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
  callbacks.c: Some misc. GUI callbacks for Gnome Predict.

  Copyright (C)  2001-2005   Alexandru Csete.

  Authors: Alexandru Csete <csete@users.sourceforge.net>

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/

#ifndef CALLBACKS_H
#define CALLBACKS_H

gint a_callback (GtkWidget *button, gpointer data);
gint not_finished (GtkWidget *, gpointer);
/* force server to reload tle file */
void server_reload_tle (GtkWidget *button, gpointer data);
/* Stop tracking */
void timer_stop_callback (GtkWidget *widget, gpointer data);
/* Resume tracking */
void timer_start_callback (GtkWidget *widget, gpointer data);
/* create a standard aboutbox */
void about_callback (GtkWidget *widget, gpointer data);
/* Server info button/menuitem pressed */
void server_info_callback (void);
/* Print main Satellite list */
void print_main_satlist (GtkWidget *widget, gpointer data);

#endif
