# tests/test_away.py
#
#

__copyright__ = 'this file is in the public domain'

from gozerbot.bot import Bot
from gozerbot.generic import stringinlist, waitforqueue
from gozerbot.plugins import plugins
import unittest, time, Queue

plugins.reload('gozerplugs.plugs', 'away')
queue = Queue.Queue()

class test_away(unittest.TestCase):
    b = Bot('me', 'testbot')
    b.userhosts['test'] = 'test@test'
    
    def setUp(self):
        self.b.send = self.sendoverload

    def sendoverload(self, txt):
        queue.put(txt)

    def test_away1(self):
        result = self.b.test('away-enable')
        self.assert_(stringinlist('enabled', result))

    def test_away2(self):
        self.b.fakein(':test!test@test PRIVMSG #test :re')
        self.b.fakein(':test!test@test PRIVMSG #test :&')
        result = waitforqueue(queue, 2)
        self.assert_(stringinlist('ltrs', result))

    def test_away3(self):
        self.b.fakein(':test!test@test PRIVMSG #test :&')
        time.sleep(1)
        self.b.fakein(':test!test@test PRIVMSG #test :re')
        result = waitforqueue(queue, 2)
        self.assert_(stringinlist('welcome', result))

    def test_away4(self):
        self.b.fakein(':test!test@test PRIVMSG #test :re')
        time.sleep(1)
        self.b.fakein(':test!test@test PRIVMSG #test :\001&\001')
        result = waitforqueue(queue, 2)
        self.assert_(stringinlist('ltrs', result))

    def test_away5(self):
        self.b.fakein(':test!test@test PRIVMSG #test :&')
        time.sleep(1)
        self.b.fakein(':test!test@test PRIVMSG #test :back')
        result = waitforqueue(queue, 2)
        self.assert_(stringinlist('welcome', result))

    def test_awaydisable(self):
        result = self.b.test('away-disable')
        self.assert_(stringinlist("disabled", result))
