# go-kit instrumentation example

An HTTP server using go-kit and instrumentation. The server has a
`/users/{id:[0-9]+}` endpoint. The server generates span information to
`stdout`.

These instructions expect you have
[docker-compose](https://docs.docker.com/compose/) installed.

Bring up the `kit-server` and `kit-client` services to run the
example:

```sh
docker-compose up --detach kit-server kit-client
```

The `kit-client` service sends just one HTTP request to `kit-server`
and then exits. View the span generated by `kit-server` in the logs:

```sh
docker-compose logs kit-server
```

Shut down the services when you are finished with the example:

```sh
docker-compose down
```
