// Code generated by smithy-go-codegen DO NOT EDIT.

package securityhub

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/securityhub/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates a configuration policy. Only the Security Hub delegated administrator
// can invoke this operation from the home Region.
func (c *Client) UpdateConfigurationPolicy(ctx context.Context, params *UpdateConfigurationPolicyInput, optFns ...func(*Options)) (*UpdateConfigurationPolicyOutput, error) {
	if params == nil {
		params = &UpdateConfigurationPolicyInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateConfigurationPolicy", params, optFns, c.addOperationUpdateConfigurationPolicyMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateConfigurationPolicyOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateConfigurationPolicyInput struct {

	// The Amazon Resource Name (ARN) or universally unique identifier (UUID) of the
	// configuration policy.
	//
	// This member is required.
	Identifier *string

	// An object that defines how Security Hub is configured. It includes whether
	// Security Hub is enabled or disabled, a list of enabled security standards, a
	// list of enabled or disabled security controls, and a list of custom parameter
	// values for specified controls. If you provide a list of security controls that
	// are enabled in the configuration policy, Security Hub disables all other
	// controls (including newly released controls). If you provide a list of security
	// controls that are disabled in the configuration policy, Security Hub enables all
	// other controls (including newly released controls). When updating a
	// configuration policy, provide a complete list of standards that you want to
	// enable and a complete list of controls that you want to enable or disable. The
	// updated configuration replaces the current configuration.
	ConfigurationPolicy types.Policy

	// The description of the configuration policy.
	Description *string

	// The name of the configuration policy. Alphanumeric characters and the following
	// ASCII characters are permitted: -, ., !, *, / .
	Name *string

	// The reason for updating the configuration policy.
	UpdatedReason *string

	noSmithyDocumentSerde
}

type UpdateConfigurationPolicyOutput struct {

	// The ARN of the configuration policy.
	Arn *string

	// An object that defines how Security Hub is configured. It includes whether
	// Security Hub is enabled or disabled, a list of enabled security standards, a
	// list of enabled or disabled security controls, and a list of custom parameter
	// values for specified controls. If the request included a list of security
	// controls that are enabled in the configuration policy, Security Hub disables all
	// other controls (including newly released controls). If the request included a
	// list of security controls that are disabled in the configuration policy,
	// Security Hub enables all other controls (including newly released controls).
	ConfigurationPolicy types.Policy

	// The date and time, in UTC and ISO 8601 format, that the configuration policy
	// was created.
	CreatedAt *time.Time

	// The description of the configuration policy.
	Description *string

	// The UUID of the configuration policy.
	Id *string

	// The name of the configuration policy.
	Name *string

	// The date and time, in UTC and ISO 8601 format, that the configuration policy
	// was last updated.
	UpdatedAt *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateConfigurationPolicyMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateConfigurationPolicy{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateConfigurationPolicy{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateConfigurationPolicy"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateConfigurationPolicyValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateConfigurationPolicy(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateConfigurationPolicy(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateConfigurationPolicy",
	}
}
