// Code generated by smithy-go-codegen DO NOT EDIT.

package evidently

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/evidently/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of audience segments that you have created in your account in
// this Region.
func (c *Client) ListSegments(ctx context.Context, params *ListSegmentsInput, optFns ...func(*Options)) (*ListSegmentsOutput, error) {
	if params == nil {
		params = &ListSegmentsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListSegments", params, optFns, c.addOperationListSegmentsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListSegmentsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListSegmentsInput struct {

	// The maximum number of results to include in the response. If you omit this, the
	// default of 50 is used.
	MaxResults *int32

	// The token to use when requesting the next set of results. You received this
	// token from a previous ListSegments operation.
	NextToken *string

	noSmithyDocumentSerde
}

type ListSegmentsOutput struct {

	// The token to use in a subsequent ListSegments operation to return the next set
	// of results.
	NextToken *string

	// An array of structures that contain information about the segments in this
	// Region.
	Segments []types.Segment

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListSegmentsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListSegments{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListSegments{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListSegments"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListSegments(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListSegmentsAPIClient is a client that implements the ListSegments operation.
type ListSegmentsAPIClient interface {
	ListSegments(context.Context, *ListSegmentsInput, ...func(*Options)) (*ListSegmentsOutput, error)
}

var _ ListSegmentsAPIClient = (*Client)(nil)

// ListSegmentsPaginatorOptions is the paginator options for ListSegments
type ListSegmentsPaginatorOptions struct {
	// The maximum number of results to include in the response. If you omit this, the
	// default of 50 is used.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListSegmentsPaginator is a paginator for ListSegments
type ListSegmentsPaginator struct {
	options   ListSegmentsPaginatorOptions
	client    ListSegmentsAPIClient
	params    *ListSegmentsInput
	nextToken *string
	firstPage bool
}

// NewListSegmentsPaginator returns a new ListSegmentsPaginator
func NewListSegmentsPaginator(client ListSegmentsAPIClient, params *ListSegmentsInput, optFns ...func(*ListSegmentsPaginatorOptions)) *ListSegmentsPaginator {
	if params == nil {
		params = &ListSegmentsInput{}
	}

	options := ListSegmentsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListSegmentsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListSegmentsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListSegments page.
func (p *ListSegmentsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListSegmentsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListSegments(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListSegments(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListSegments",
	}
}
