// Code generated by smithy-go-codegen DO NOT EDIT.

package configservice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/configservice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of conformance pack compliance scores. A compliance score is the
// percentage of the number of compliant rule-resource combinations in a
// conformance pack compared to the number of total possible rule-resource
// combinations in the conformance pack. This metric provides you with a high-level
// view of the compliance state of your conformance packs. You can use it to
// identify, investigate, and understand the level of compliance in your
// conformance packs. Conformance packs with no evaluation results will have a
// compliance score of INSUFFICIENT_DATA .
func (c *Client) ListConformancePackComplianceScores(ctx context.Context, params *ListConformancePackComplianceScoresInput, optFns ...func(*Options)) (*ListConformancePackComplianceScoresOutput, error) {
	if params == nil {
		params = &ListConformancePackComplianceScoresInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListConformancePackComplianceScores", params, optFns, c.addOperationListConformancePackComplianceScoresMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListConformancePackComplianceScoresOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListConformancePackComplianceScoresInput struct {

	// Filters the results based on the ConformancePackComplianceScoresFilters .
	Filters *types.ConformancePackComplianceScoresFilters

	// The maximum number of conformance pack compliance scores returned on each page.
	Limit int32

	// The nextToken string in a prior request that you can use to get the paginated
	// response for the next set of conformance pack compliance scores.
	NextToken *string

	// Sorts your conformance pack compliance scores in either ascending or descending
	// order, depending on SortOrder . By default, conformance pack compliance scores
	// are sorted in alphabetical order by name of the conformance pack. Enter SCORE ,
	// to sort conformance pack compliance scores by the numerical value of the
	// compliance score.
	SortBy types.SortBy

	// Determines the order in which conformance pack compliance scores are sorted.
	// Either in ascending or descending order. By default, conformance pack compliance
	// scores are sorted in alphabetical order by name of the conformance pack.
	// Conformance pack compliance scores are sorted in reverse alphabetical order if
	// you enter DESCENDING . You can sort conformance pack compliance scores by the
	// numerical value of the compliance score by entering SCORE in the SortBy action.
	// When compliance scores are sorted by SCORE , conformance packs with a compliance
	// score of INSUFFICIENT_DATA will be last when sorting by ascending order and
	// first when sorting by descending order.
	SortOrder types.SortOrder

	noSmithyDocumentSerde
}

type ListConformancePackComplianceScoresOutput struct {

	// A list of ConformancePackComplianceScore objects.
	//
	// This member is required.
	ConformancePackComplianceScores []types.ConformancePackComplianceScore

	// The nextToken string that you can use to get the next page of results in a
	// paginated response.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListConformancePackComplianceScoresMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListConformancePackComplianceScores{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListConformancePackComplianceScores{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListConformancePackComplianceScores"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListConformancePackComplianceScoresValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListConformancePackComplianceScores(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListConformancePackComplianceScoresAPIClient is a client that implements the
// ListConformancePackComplianceScores operation.
type ListConformancePackComplianceScoresAPIClient interface {
	ListConformancePackComplianceScores(context.Context, *ListConformancePackComplianceScoresInput, ...func(*Options)) (*ListConformancePackComplianceScoresOutput, error)
}

var _ ListConformancePackComplianceScoresAPIClient = (*Client)(nil)

// ListConformancePackComplianceScoresPaginatorOptions is the paginator options
// for ListConformancePackComplianceScores
type ListConformancePackComplianceScoresPaginatorOptions struct {
	// The maximum number of conformance pack compliance scores returned on each page.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListConformancePackComplianceScoresPaginator is a paginator for
// ListConformancePackComplianceScores
type ListConformancePackComplianceScoresPaginator struct {
	options   ListConformancePackComplianceScoresPaginatorOptions
	client    ListConformancePackComplianceScoresAPIClient
	params    *ListConformancePackComplianceScoresInput
	nextToken *string
	firstPage bool
}

// NewListConformancePackComplianceScoresPaginator returns a new
// ListConformancePackComplianceScoresPaginator
func NewListConformancePackComplianceScoresPaginator(client ListConformancePackComplianceScoresAPIClient, params *ListConformancePackComplianceScoresInput, optFns ...func(*ListConformancePackComplianceScoresPaginatorOptions)) *ListConformancePackComplianceScoresPaginator {
	if params == nil {
		params = &ListConformancePackComplianceScoresInput{}
	}

	options := ListConformancePackComplianceScoresPaginatorOptions{}
	if params.Limit != 0 {
		options.Limit = params.Limit
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListConformancePackComplianceScoresPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListConformancePackComplianceScoresPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListConformancePackComplianceScores page.
func (p *ListConformancePackComplianceScoresPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListConformancePackComplianceScoresOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	params.Limit = p.options.Limit

	result, err := p.client.ListConformancePackComplianceScores(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListConformancePackComplianceScores(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListConformancePackComplianceScores",
	}
}
