// Code generated by smithy-go-codegen DO NOT EDIT.

package configservice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/configservice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns the count of compliant and noncompliant conformance packs across all
// Amazon Web Services accounts and Amazon Web Services Regions in an aggregator.
// You can filter based on Amazon Web Services account ID or Amazon Web Services
// Region. The results can return an empty result page, but if you have a
// nextToken, the results are displayed on the next page.
func (c *Client) GetAggregateConformancePackComplianceSummary(ctx context.Context, params *GetAggregateConformancePackComplianceSummaryInput, optFns ...func(*Options)) (*GetAggregateConformancePackComplianceSummaryOutput, error) {
	if params == nil {
		params = &GetAggregateConformancePackComplianceSummaryInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetAggregateConformancePackComplianceSummary", params, optFns, c.addOperationGetAggregateConformancePackComplianceSummaryMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetAggregateConformancePackComplianceSummaryOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetAggregateConformancePackComplianceSummaryInput struct {

	// The name of the configuration aggregator.
	//
	// This member is required.
	ConfigurationAggregatorName *string

	// Filters the results based on the
	// AggregateConformancePackComplianceSummaryFilters object.
	Filters *types.AggregateConformancePackComplianceSummaryFilters

	// Groups the result based on Amazon Web Services account ID or Amazon Web
	// Services Region.
	GroupByKey types.AggregateConformancePackComplianceSummaryGroupKey

	// The maximum number of results returned on each page. The default is maximum. If
	// you specify 0, Config uses the default.
	Limit int32

	// The nextToken string returned on a previous page that you use to get the next
	// page of results in a paginated response.
	NextToken *string

	noSmithyDocumentSerde
}

type GetAggregateConformancePackComplianceSummaryOutput struct {

	// Returns a list of AggregateConformancePackComplianceSummary object.
	AggregateConformancePackComplianceSummaries []types.AggregateConformancePackComplianceSummary

	// Groups the result based on Amazon Web Services account ID or Amazon Web
	// Services Region.
	GroupByKey *string

	// The nextToken string returned on a previous page that you use to get the next
	// page of results in a paginated response.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetAggregateConformancePackComplianceSummaryMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetAggregateConformancePackComplianceSummary{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetAggregateConformancePackComplianceSummary{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetAggregateConformancePackComplianceSummary"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetAggregateConformancePackComplianceSummaryValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetAggregateConformancePackComplianceSummary(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// GetAggregateConformancePackComplianceSummaryAPIClient is a client that
// implements the GetAggregateConformancePackComplianceSummary operation.
type GetAggregateConformancePackComplianceSummaryAPIClient interface {
	GetAggregateConformancePackComplianceSummary(context.Context, *GetAggregateConformancePackComplianceSummaryInput, ...func(*Options)) (*GetAggregateConformancePackComplianceSummaryOutput, error)
}

var _ GetAggregateConformancePackComplianceSummaryAPIClient = (*Client)(nil)

// GetAggregateConformancePackComplianceSummaryPaginatorOptions is the paginator
// options for GetAggregateConformancePackComplianceSummary
type GetAggregateConformancePackComplianceSummaryPaginatorOptions struct {
	// The maximum number of results returned on each page. The default is maximum. If
	// you specify 0, Config uses the default.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetAggregateConformancePackComplianceSummaryPaginator is a paginator for
// GetAggregateConformancePackComplianceSummary
type GetAggregateConformancePackComplianceSummaryPaginator struct {
	options   GetAggregateConformancePackComplianceSummaryPaginatorOptions
	client    GetAggregateConformancePackComplianceSummaryAPIClient
	params    *GetAggregateConformancePackComplianceSummaryInput
	nextToken *string
	firstPage bool
}

// NewGetAggregateConformancePackComplianceSummaryPaginator returns a new
// GetAggregateConformancePackComplianceSummaryPaginator
func NewGetAggregateConformancePackComplianceSummaryPaginator(client GetAggregateConformancePackComplianceSummaryAPIClient, params *GetAggregateConformancePackComplianceSummaryInput, optFns ...func(*GetAggregateConformancePackComplianceSummaryPaginatorOptions)) *GetAggregateConformancePackComplianceSummaryPaginator {
	if params == nil {
		params = &GetAggregateConformancePackComplianceSummaryInput{}
	}

	options := GetAggregateConformancePackComplianceSummaryPaginatorOptions{}
	if params.Limit != 0 {
		options.Limit = params.Limit
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetAggregateConformancePackComplianceSummaryPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetAggregateConformancePackComplianceSummaryPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetAggregateConformancePackComplianceSummary page.
func (p *GetAggregateConformancePackComplianceSummaryPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetAggregateConformancePackComplianceSummaryOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	params.Limit = p.options.Limit

	result, err := p.client.GetAggregateConformancePackComplianceSummary(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opGetAggregateConformancePackComplianceSummary(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetAggregateConformancePackComplianceSummary",
	}
}
