// Code generated by smithy-go-codegen DO NOT EDIT.

package comprehend

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/comprehend/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Starts an asynchronous entity detection job for a collection of documents. Use
// the operation to track the status of a job. This API can be used for either
// standard entity detection or custom entity recognition. In order to be used for
// custom entity recognition, the optional EntityRecognizerArn must be used in
// order to provide access to the recognizer being used to detect the custom
// entity.
func (c *Client) StartEntitiesDetectionJob(ctx context.Context, params *StartEntitiesDetectionJobInput, optFns ...func(*Options)) (*StartEntitiesDetectionJobOutput, error) {
	if params == nil {
		params = &StartEntitiesDetectionJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartEntitiesDetectionJob", params, optFns, c.addOperationStartEntitiesDetectionJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartEntitiesDetectionJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartEntitiesDetectionJobInput struct {

	// The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend
	// read access to your input data. For more information, see Role-based permissions (https://docs.aws.amazon.com/comprehend/latest/dg/security_iam_id-based-policy-examples.html#auth-role-permissions)
	// .
	//
	// This member is required.
	DataAccessRoleArn *string

	// Specifies the format and location of the input data for the job.
	//
	// This member is required.
	InputDataConfig *types.InputDataConfig

	// The language of the input documents. All documents must be in the same
	// language. You can specify any of the languages supported by Amazon Comprehend.
	// If custom entities recognition is used, this parameter is ignored and the
	// language used for training the model is used instead.
	//
	// This member is required.
	LanguageCode types.LanguageCode

	// Specifies where to send the output files.
	//
	// This member is required.
	OutputDataConfig *types.OutputDataConfig

	// A unique identifier for the request. If you don't set the client request token,
	// Amazon Comprehend generates one.
	ClientRequestToken *string

	// The Amazon Resource Name (ARN) that identifies the specific entity recognizer
	// to be used by the StartEntitiesDetectionJob . This ARN is optional and is only
	// used for a custom entity recognition job.
	EntityRecognizerArn *string

	// The Amazon Resource Number (ARN) of the flywheel associated with the model to
	// use.
	FlywheelArn *string

	// The identifier of the job.
	JobName *string

	// Tags to associate with the entities detection job. A tag is a key-value pair
	// that adds metadata to a resource used by Amazon Comprehend. For example, a tag
	// with "Sales" as the key might be added to a resource to indicate its use by the
	// sales department.
	Tags []types.Tag

	// ID for the Amazon Web Services Key Management Service (KMS) key that Amazon
	// Comprehend uses to encrypt data on the storage volume attached to the ML compute
	// instance(s) that process the analysis job. The VolumeKmsKeyId can be either of
	// the following formats:
	//   - KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//   - Amazon Resource Name (ARN) of a KMS Key:
	//   "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string

	// Configuration parameters for an optional private Virtual Private Cloud (VPC)
	// containing the resources you are using for your entity detection job. For more
	// information, see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html)
	// .
	VpcConfig *types.VpcConfig

	noSmithyDocumentSerde
}

type StartEntitiesDetectionJobOutput struct {

	// The ARN of the custom entity recognition model.
	EntityRecognizerArn *string

	// The Amazon Resource Name (ARN) of the entities detection job. It is a unique,
	// fully qualified identifier for the job. It includes the Amazon Web Services
	// account, Amazon Web Services Region, and the job ID. The format of the ARN is as
	// follows: arn::comprehend:::entities-detection-job/ The following is an example
	// job ARN:
	// arn:aws:comprehend:us-west-2:111122223333:entities-detection-job/1234abcd12ab34cd56ef1234567890ab
	JobArn *string

	// The identifier generated for the job. To get the status of job, use this
	// identifier with the operation.
	JobId *string

	// The status of the job.
	//   - SUBMITTED - The job has been received and is queued for processing.
	//   - IN_PROGRESS - Amazon Comprehend is processing the job.
	//   - COMPLETED - The job was successfully completed and the output is available.
	//   - FAILED - The job did not complete. To get details, use the operation.
	//   - STOP_REQUESTED - Amazon Comprehend has received a stop request for the job
	//   and is processing the request.
	//   - STOPPED - The job was successfully stopped without completing.
	JobStatus types.JobStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartEntitiesDetectionJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpStartEntitiesDetectionJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpStartEntitiesDetectionJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartEntitiesDetectionJob"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addIdempotencyToken_opStartEntitiesDetectionJobMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpStartEntitiesDetectionJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartEntitiesDetectionJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpStartEntitiesDetectionJob struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpStartEntitiesDetectionJob) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpStartEntitiesDetectionJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*StartEntitiesDetectionJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *StartEntitiesDetectionJobInput ")
	}

	if input.ClientRequestToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientRequestToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opStartEntitiesDetectionJobMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpStartEntitiesDetectionJob{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opStartEntitiesDetectionJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartEntitiesDetectionJob",
	}
}
