// Code generated by smithy-go-codegen DO NOT EDIT.

package codepipeline

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/codepipeline/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns information about an action type created for an external provider,
// where the action is to be used by customers of the external provider. The action
// can be created with any supported integration model.
func (c *Client) GetActionType(ctx context.Context, params *GetActionTypeInput, optFns ...func(*Options)) (*GetActionTypeOutput, error) {
	if params == nil {
		params = &GetActionTypeInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetActionType", params, optFns, c.addOperationGetActionTypeMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetActionTypeOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetActionTypeInput struct {

	// Defines what kind of action can be taken in the stage. The following are the
	// valid values:
	//   - Source
	//   - Build
	//   - Test
	//   - Deploy
	//   - Approval
	//   - Invoke
	//
	// This member is required.
	Category types.ActionCategory

	// The creator of an action type that was created with any supported integration
	// model. There are two valid values: AWS and ThirdParty .
	//
	// This member is required.
	Owner *string

	// The provider of the action type being called. The provider name is specified
	// when the action type is created.
	//
	// This member is required.
	Provider *string

	// A string that describes the action type version.
	//
	// This member is required.
	Version *string

	noSmithyDocumentSerde
}

type GetActionTypeOutput struct {

	// The action type information for the requested action type, such as the action
	// type ID.
	ActionType *types.ActionTypeDeclaration

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetActionTypeMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetActionType{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetActionType{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetActionType"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetActionTypeValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetActionType(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetActionType(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetActionType",
	}
}
