// Code generated by smithy-go-codegen DO NOT EDIT.

package pinpointsmsvoicev2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoicev2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Describes the current Amazon Pinpoint monthly spend limits for sending voice and
// text messages. When you establish an Amazon Web Services account, the account
// has initial monthly spend limit in a given Region. For more information on
// increasing your monthly spend limit, see  Requesting increases to your monthly
// SMS spending quota for Amazon Pinpoint
// (https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-awssupport-spend-threshold.html)
// in the Amazon Pinpoint User Guide.
func (c *Client) DescribeSpendLimits(ctx context.Context, params *DescribeSpendLimitsInput, optFns ...func(*Options)) (*DescribeSpendLimitsOutput, error) {
	if params == nil {
		params = &DescribeSpendLimitsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeSpendLimits", params, optFns, c.addOperationDescribeSpendLimitsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeSpendLimitsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeSpendLimitsInput struct {

	// The maximum number of results to return per each request.
	MaxResults *int32

	// The token to be used for the next set of paginated results. You don't need to
	// supply a value for this field in the initial request.
	NextToken *string

	noSmithyDocumentSerde
}

type DescribeSpendLimitsOutput struct {

	// The token to be used for the next set of paginated results. If this field is
	// empty then there are no more results.
	NextToken *string

	// An array of SpendLimit objects that contain the details for the requested spend
	// limits.
	SpendLimits []types.SpendLimit

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeSpendLimitsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpDescribeSpendLimits{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpDescribeSpendLimits{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeSpendLimits(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeSpendLimitsAPIClient is a client that implements the DescribeSpendLimits
// operation.
type DescribeSpendLimitsAPIClient interface {
	DescribeSpendLimits(context.Context, *DescribeSpendLimitsInput, ...func(*Options)) (*DescribeSpendLimitsOutput, error)
}

var _ DescribeSpendLimitsAPIClient = (*Client)(nil)

// DescribeSpendLimitsPaginatorOptions is the paginator options for
// DescribeSpendLimits
type DescribeSpendLimitsPaginatorOptions struct {
	// The maximum number of results to return per each request.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeSpendLimitsPaginator is a paginator for DescribeSpendLimits
type DescribeSpendLimitsPaginator struct {
	options   DescribeSpendLimitsPaginatorOptions
	client    DescribeSpendLimitsAPIClient
	params    *DescribeSpendLimitsInput
	nextToken *string
	firstPage bool
}

// NewDescribeSpendLimitsPaginator returns a new DescribeSpendLimitsPaginator
func NewDescribeSpendLimitsPaginator(client DescribeSpendLimitsAPIClient, params *DescribeSpendLimitsInput, optFns ...func(*DescribeSpendLimitsPaginatorOptions)) *DescribeSpendLimitsPaginator {
	if params == nil {
		params = &DescribeSpendLimitsInput{}
	}

	options := DescribeSpendLimitsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeSpendLimitsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeSpendLimitsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeSpendLimits page.
func (p *DescribeSpendLimitsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeSpendLimitsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.DescribeSpendLimits(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opDescribeSpendLimits(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "sms-voice",
		OperationName: "DescribeSpendLimits",
	}
}
