// Code generated by smithy-go-codegen DO NOT EDIT.

package mediatailor

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/mediatailor/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates a channel. For information about MediaTailor channels, see Working with
// channels
// (https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html)
// in the MediaTailor User Guide.
func (c *Client) UpdateChannel(ctx context.Context, params *UpdateChannelInput, optFns ...func(*Options)) (*UpdateChannelOutput, error) {
	if params == nil {
		params = &UpdateChannelInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateChannel", params, optFns, c.addOperationUpdateChannelMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateChannelOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateChannelInput struct {

	// The name of the channel.
	//
	// This member is required.
	ChannelName *string

	// The channel's output properties.
	//
	// This member is required.
	Outputs []types.RequestOutputItem

	// The slate used to fill gaps between programs in the schedule. You must configure
	// filler slate if your channel uses the LINEARPlaybackMode. MediaTailor doesn't
	// support filler slate for channels using the LOOPPlaybackMode.
	FillerSlate *types.SlateSource

	noSmithyDocumentSerde
}

type UpdateChannelOutput struct {

	// The Amazon Resource Name (ARN) associated with the channel.
	Arn *string

	// The name of the channel.
	ChannelName *string

	// Returns the state whether the channel is running or not.
	ChannelState types.ChannelState

	// The timestamp of when the channel was created.
	CreationTime *time.Time

	// The slate used to fill gaps between programs in the schedule. You must configure
	// filler slate if your channel uses the LINEARPlaybackMode. MediaTailor doesn't
	// support filler slate for channels using the LOOPPlaybackMode.
	FillerSlate *types.SlateSource

	// The timestamp that indicates when the channel was last modified.
	LastModifiedTime *time.Time

	// The channel's output properties.
	Outputs []types.ResponseOutputItem

	// The type of playback mode for this channel. LINEAR - Programs play back-to-back
	// only once. LOOP - Programs play back-to-back in an endless loop. When the last
	// program in the schedule plays, playback loops back to the first program in the
	// schedule.
	PlaybackMode *string

	// The tags to assign to the channel. Tags are key-value pairs that you can
	// associate with Amazon resources to help with organization, access control, and
	// cost tracking. For more information, see Tagging AWS Elemental MediaTailor
	// Resources (https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html).
	Tags map[string]string

	// The tier associated with this Channel.
	Tier *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateChannelMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateChannel{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateChannel{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateChannelValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateChannel(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateChannel(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "mediatailor",
		OperationName: "UpdateChannel",
	}
}
