/*******************************************************************************
*                         Goggles Music Manager                                *
********************************************************************************
*           Copyright (C) 2007-2011 by Sander Jansen. All Rights Reserved      *
*                               ---                                            *
* This program is free software: you can redistribute it and/or modify         *
* it under the terms of the GNU General Public License as published by         *
* the Free Software Foundation, either version 3 of the License, or            *
* (at your option) any later version.                                          *
*                                                                              *
* This program is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                *
* GNU General Public License for more details.                                 *
*                                                                              *
* You should have received a copy of the GNU General Public License            *
* along with this program.  If not, see http://www.gnu.org/licenses.           *
********************************************************************************/

#include "gmdefs.h"
#include "GMFetch.h"
#include "GMPlayerManager.h"

#include "ap_buffer.h"
#include "ap_http.h"
using namespace ap;

GMFetch * GMFetch::fetch = NULL;

GMFetch::GMFetch() : gui(FXApp::instance()) {
  }


FXint GMFetch::run() {
  GMFetchResponse * response = new GMFetchResponse;
  response->url = url;
  HttpClient client;

  // HEAD request don't always work...
  if (client.basic("GET",url) && client.status.code==200) {
    response->content_type = client.getHeader("content-type");
    if (response->content_type.find("audio/mpegurl")!=-1 ||
        response->content_type.find("audio/x-mpegurl")!=-1 ||
        response->content_type.find("application/pls+xml")!=-1 ||
        response->content_type.find("audio/x-scpls")!=-1) {
      response->data=client.body();
      }
    gui.message(GMPlayerManager::instance(),FXSEL(SEL_COMMAND,GMPlayerManager::ID_DOWNLOAD_COMPLETE),&response,sizeof(GMFetchResponse*));
    }
  else {
    errormsg="Failed to retrieve";
    gui.message(GMPlayerManager::instance(),FXSEL(SEL_COMMAND,GMPlayerManager::ID_DOWNLOAD_COMPLETE));
    }
  return 0;
  }

void GMFetch::init() {
  }

void GMFetch::exit() {
  if (fetch) {

    if (fetch->running())
      fetch->join();

    delete fetch;
    fetch=NULL;
    }
  }


void GMFetch::download(const FXString & url) {
  if (fetch==NULL) {
    fetch = new GMFetch();
    }
  else {
    if (fetch->running())
      fetch->join();
    }
  fetch->url = url;
  fetch->start();
  }

void GMFetch::cancel_and_wait(){
  if (fetch && fetch->running() ) {
    fetch->join();
    }
  }

FXbool GMFetch::busy(){
  if (fetch && fetch->running() )
    return true;
  else
    return false;
  }
