/*
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License version 3 as published by the Free Software Foundation;
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */
 
 
#include <string.h>
#include <glib/gstdio.h>
#include <gtk/gtk.h>
#include <gio/gio.h>

#include "launcher-util.h"

#include <libgnome/gnome-desktop-item.h>

static void
_normalize (char *str)
{
	size_t len;
	int i;

	len = strlen(str);

	for (i = 0; i < len; i++) 
  {
		switch (str[i]) 
    {
			case ' ':
				str[i] = '-';
        break;
			default:
				break;
		}
	}

}

void           
launcher_util_create_favorite (const gchar *item_file)
{
  GError *error = NULL;
  GnomeDesktopItem *item = NULL;
  GnomeDesktopItem *fav = NULL;
  gchar *appdir, *filename, *favfile;

  item = gnome_desktop_item_new_from_file (item_file,
                                         GNOME_DESKTOP_ITEM_LOAD_ONLY_IF_EXISTS,
                                           NULL);
  if (item == NULL)
    return;

  fav = gnome_desktop_item_copy (item);
  gnome_desktop_item_set_string (fav, 
                                 GNOME_DESKTOP_ITEM_CATEGORIES,
                                 "Favorites");

  appdir = g_strdup_printf ("file://%s/.local/share/applications", g_get_home_dir ());
  filename = g_strdup_printf ("%s-favorite-%ld.desktop",
                              gnome_desktop_item_get_localestring (item, 
                                                      GNOME_DESKTOP_ITEM_NAME),
                              time (NULL));
  _normalize (filename);
  favfile = g_build_filename (appdir, filename, NULL);
                               
  gnome_desktop_item_save (fav, favfile, TRUE, &error);

  if (error)
  {
    g_warning ("Unable to create favorite: %s", error->message);
    g_error_free (error);
  }

  g_free (appdir);
  g_free (filename);
  g_free (favfile);

  gnome_desktop_item_unref (item);
  gnome_desktop_item_unref (fav);
}

void  
launcher_util_new_shortcut (const gchar *name,
                            const gchar *category,
                            const gchar *exec,
                            const gchar *icon)
{
  GError *error = NULL;
  GnomeDesktopItem *item = NULL;
  gchar *appdir, *filename, *favfile, *catname;

  item = gnome_desktop_item_new ();

  catname = g_strdup (category);
  _normalize (catname);

  gnome_desktop_item_set_string (item, 
                                 GNOME_DESKTOP_ITEM_NAME,
                                 name); 
  gnome_desktop_item_set_string (item, 
                                 GNOME_DESKTOP_ITEM_CATEGORIES,
                                 catname);
  gnome_desktop_item_set_string (item, 
                                 GNOME_DESKTOP_ITEM_EXEC,
                                 exec);
  gnome_desktop_item_set_string (item, 
                                 GNOME_DESKTOP_ITEM_ICON,
                                 icon);
  gnome_desktop_item_set_string (item, 
                                 GNOME_DESKTOP_ITEM_TYPE,
                                 "Application");
  gnome_desktop_item_set_string (item, 
                                 GNOME_DESKTOP_ITEM_VERSION,
                                 "1.0");

  appdir = g_strdup_printf ("file://%s/.local/share/applications", 
                            g_get_home_dir ());
  filename = g_strdup_printf ("%s-favorite-%ld.desktop",
                              name,
                              time (NULL));
  _normalize (filename);

  favfile = g_build_filename (appdir, filename, NULL);
                               
  gnome_desktop_item_save (item, favfile, TRUE, &error);
  g_print ("filename: %s", filename);

  if (error)
  {
    g_warning ("Unable to create favorite: %s", error->message);
    g_error_free (error);
  }

  g_free (appdir);
  g_free (filename);
  g_free (favfile);
  g_free (catname);

  gnome_desktop_item_unref (item);
}

