/*
   yahoo_wrapper.c: higher level wrapper to libyahoo functions


   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

/* READ ME FIRST:
   All the process_*  and handle_yahoo_message functions should use
   PRINTF_MESSAGE only to print any message to screen. This will
   ensure proper insertion of message into readline buffer.
*/


#include <assert.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <guile/gh.h>
#include <readline/readline.h>

#include <glib.h>
#include <yahoo2.h>
#include <yahoo2_callbacks.h>

#include "gnuyahoo.h"
#include "interpreter.h"
#include "yahoo-wrapper.h"
#include "messenger.h"
#include "gy-utils.h"
#include "extension.h"
#include <config.h>


GHashTable *gy_buddy_list = NULL;
static char current_target_buddy[USERNAME_LENGTH];


void 
set_current_target_buddy (char *current_target_buddy_value)
{
  if (current_target_buddy_value)
    strcpy (current_target_buddy, current_target_buddy_value);
  else
    current_target_buddy[0] = 0;
}

char *
get_current_target_buddy (void)
{
  return current_target_buddy;
}

void 
send_message (char *to, char *message)
{
  /* hook evaluation */
  set_current_target_buddy (to);	// AUTO-INSERT-MODE
  
  set_hook_return (0);
  scm_run_hook (get_message_send_hook (),
		gh_list (gh_str02scm (to),
			 gh_str02scm (message),
			 SCM_UNDEFINED));
  
  if (get_hook_return () == 1)
    return;
  
  yahoo_send_im ((get_gnuyahoo_session ())->session_id, NULL, to, message);
}

/* this function is primarily for scm-procedure. using this function
for other purposes is not justified 
*/
void 
send_message_no_hook (char *to, char *message)
{
  
  // dont set current_target_buddy from inside this call. otherwise
  // it will confuse "session (AUTU-INSERT-MODE). 
  // set_current_target_buddy (to); // AUTO-INSERT-MODE
  
  yahoo_send_im ((get_gnuyahoo_session ())->session_id, NULL, to, message);
}


///////////////////////////////////////////////////////////////////////////////////////////
void 
gy_key_destroy (gpointer key)
{
  return;
}

void 
gy_value_destroy (gpointer data)
{
  return;
}

void
build_gy_buddy_table (const void *data)
{
  struct yahoo_buddy *buddy = (struct yahoo_buddy *) data;
  struct gy_buddy *gyb = NULL;
  
  gyb = (gy_buddy *) malloc (sizeof (gy_buddy));
  gyb->group = strdup (buddy->group);
  gyb->id = strdup (buddy->id);
  gyb->real_name = (buddy->real_name) ? strdup (buddy->real_name) : NULL;
  gyb->status = YAHOO_STATUS_OFFLINE;
  gyb->status_msg = NULL;
  
  g_hash_table_insert (gy_buddy_list, gyb->id, gyb);
}

void 
build_gy_buddy_list ()
{
  YList *buds;
  gy_buddy_list = g_hash_table_new (g_str_hash, g_str_equal);
  buds = (get_gnuyahoo_session ())->buddy_list;
  for(; buds; buds = buds->next) 
    build_gy_buddy_table (buds->data);
}



void
show_buddy (gpointer data)
{
  static char *current_group = NULL;
  struct yahoo_buddy *buddy = (struct yahoo_buddy *) data;
  gy_buddy *gyb = NULL;
  
  if (!current_group || strcmp (current_group, buddy->group))
    {
      current_group = buddy->group;
      printf ("[%s]\n", current_group);
    }
  
  gyb = g_hash_table_lookup (gy_buddy_list, buddy->id);
  if (!gyb)
    {
      /* Sometimes libyahoo2 buddy_list and gy_buddy_list doesn't
	 synchronize in realtime. */
      // printf ("Error: No %s found in gy_buddy_list\n", buddy->id);
      return;
    }
  
  if (get_who_state () &&
      gyb->status != YAHOO_STATUS_AVAILABLE &&
      gyb->status == YAHOO_STATUS_OFFLINE)
    {
      return;
    }

  printf (" %c %s",
	  ((gyb->status == YAHOO_STATUS_AVAILABLE) ? '*' : ' '),
	  gyb->id);
  
  if (gyb->status == YAHOO_STATUS_CUSTOM)
    {
      printf (" (%s)", gyb->status_msg);
    }
  else
    {
      if (gyb->status != YAHOO_STATUS_OFFLINE &&
	  gyb->status != YAHOO_STATUS_AVAILABLE)
	{
	  printf (" (%s)", yahoo_status_code (gyb->status));
	}
    }
  printf ("\n");
}

void
show_ignore (gpointer data)
{
  struct yahoo_buddy *buddy = (struct yahoo_buddy *) data;
  printf ("%s\n", buddy->id);
}


void 
display_buddy_list ()
{
  YList *buds = (get_gnuyahoo_session ())->buddy_list;
  for(; buds; buds = buds->next) 
    show_buddy (buds->data);
}

void 
display_ignore_list ()
{
  YList *igns = (get_gnuyahoo_session ())->ignore_list;
  for(; igns; igns = igns->next) 
    show_ignore (igns->data);
}

GHashTable *
get_gy_buddy_list ()
{
  return gy_buddy_list;
}
