/*
        PageLayoutPanel.m

	PageLayoutPanel Panel

	Copyright (C) 2003 Fabien VALLON
	Additional copyrights here

	Authors: Fabien VALLON <fabien@tuxfamily.org>
	Date:	20 Oct 2003

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License as
	published by the Free Software Foundation; either version 2 of
	the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

	See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public
	License along with this program; if not, write to:

		Free Software Foundation, Inc.
		59 Temple Place - Suite 330
		Boston, MA  02111-1307, USA
*/


#include "PageLayoutPanel.h"



#include <Foundation/NSNotification.h>
#include <Foundation/NSString.h>


#include <AppKit/NSBox.h>
#include <AppKit/NSImage.h>
#include <AppKit/NSImageView.h>
#include <AppKit/NSMatrix.h>
#include <AppKit/NSNibLoading.h>
#include <AppKit/NSPopUpButton.h>
#include <AppKit/NSTextField.h>




//Uses for unitsPopUp tag (settingsAction:)
#define INCHES      0
#define CENTIMETERS 1 
#define POINTS      2
#define PICAS       3

//Uses for styleMatrix tag (settingsAction:)
#define PORTRAIT    0
#define LANDSCAPE   1

#define _SAVE_PANEL_X_PAD	5
#define _SAVE_PANEL_Y_PAD	4


@interface PageLayoutPanel (Private)
-(void) _saveAndApply;
-(void) _updateCell;
-(void) _displayButton;
@end

@implementation PageLayoutPanel (Private)

-(void) _saveAndApply
{
  printf("TODO\n");
  
}

-(void) _updateCell
{
  printf("_updateCell\n");
}



-(void) _displayButton
{
  printf("DisplayButon\n");
  //   [displayButton setFrame: NSMakeRect(0,0,0,0)];
}

@end



@implementation PageLayoutPanel

-(id) init
{
  if ( ! [NSBundle loadNibNamed:@"PageLayoutPanel" owner:self] )
    printf("Cannot load gorm file");
  else
    printf("PageLayoutPanel load\n");
  //  NSLog(@"window %@ \n",window);
  return window;
}  

-(void) awakeFromNib
{
  printf("Todo ==> awakeFromNib\n");
  // ????? Gorm Bug ???
  [paperPopUp setEnabled:YES];
  [printPopUp setEnabled:YES];
  [unitsPopUp setEnabled:YES];
  [widthField setDelegate: self];
  [heightField setDelegate: self];



  paperSize = [NSDictionary dictionaryWithObjectsAndKeys:
			      [NSDictionary dictionaryWithObjectsAndKeys:@"612",@"w",@"792",@"h",nil],@"Letter",
			    [NSDictionary dictionaryWithObjectsAndKeys:@"612",@"w",@"792",@"h",nil],@"LetterSmall",
			    [NSDictionary dictionaryWithObjectsAndKeys:@"792",@"w",@"1224",@"h",nil],@"Tabloid",
			    [NSDictionary dictionaryWithObjectsAndKeys:@"1224",@"w",@"792",@"h",nil],@"Ledger",
			    [NSDictionary dictionaryWithObjectsAndKeys:@"612",@"w",@"1008",@"h",nil],@"Legal",
			    [NSDictionary dictionaryWithObjectsAndKeys:@"396",@"w",@"612",@"h",nil],@"Statement",
			    [NSDictionary dictionaryWithObjectsAndKeys:@"540",@"w",@"720",@"h",nil],@"Executive",
			    [NSDictionary dictionaryWithObjectsAndKeys:@"842",@"w",@"1190",@"h",nil],@"A3",
			    [NSDictionary dictionaryWithObjectsAndKeys:@"595",@"w",@"842",@"h",nil],@"A4",
			    [NSDictionary dictionaryWithObjectsAndKeys:@"595",@"w",@"842",@"h",nil],@"A4 Small",
			    [NSDictionary dictionaryWithObjectsAndKeys:@"420",@"w",@"595",@"h",nil],@"A5",
			    [NSDictionary dictionaryWithObjectsAndKeys:@"729",@"w",@"1032",@"h",nil],@"B4",
			    [NSDictionary dictionaryWithObjectsAndKeys:@"516",@"w",@"729",@"h",nil],@"B5",
			    [NSDictionary dictionaryWithObjectsAndKeys:@"612",@"w",@"936",@"h",nil],@"Folio",
			    [NSDictionary dictionaryWithObjectsAndKeys:@"610",@"w",@"780",@"h",nil],@"Quatro",
			    [NSDictionary dictionaryWithObjectsAndKeys:@"720",@"w",@"1008",@"h",nil],@"10x14",
			    nil];
  [paperSize retain];
  
  //Paper Size PopUp
  {
    int i;
    //REMOVE Other
    [paperPopUp removeAllItems];
    NSArray *titles = [[paperSize allKeys] sortedArrayUsingSelector: @selector(caseInsensitiveCompare:)];

    for (i = 0; i < [titles count]; i++) 
      {	
	[paperPopUp insertItemWithTitle:[titles objectAtIndex:i]  atIndex:i];
      }
    
    [paperPopUp insertItemWithTitle:_(@"Other") atIndex: [paperPopUp numberOfItems]];
    //Bork
    [paperPopUp selectItemAtIndex: 2];
    NSDictionary *sizeDict = [paperSize objectForKey: [[paperPopUp selectedItem] title]];
    [widthField setStringValue:[sizeDict objectForKey:@"w"]];
    [heightField setStringValue:[sizeDict objectForKey:@"h"]];    
    [unitsPopUp selectItemAtIndex: 2];
  }

  //styleMatrix images
  {
    [[styleMatrix cellAtRow:0 column:PORTRAIT] setEnabled: NO];
    [[styleMatrix cellAtRow:0 column:LANDSCAPE] setEnabled: YES];
    _portrait = YES;
  }

  NSLog(@"topView %@\n",topView);
  [topView setAutoresizingMask: NSViewWidthSizable|NSViewHeightSizable];
  [topView setAutoresizesSubviews: YES];
  
  
  //Create Bottom View 
  {
    printf("_bottomView\n");
    NSRect rectBottomView = NSMakeRect (0, 0,[window frame].size.width,64);
    _bottomView = [[NSView alloc] initWithFrame: rectBottomView];
    [_bottomView setBounds:  rectBottomView];
    printf("_bottomView\n");

    NSRect rectCancelButton = NSMakeRect (148, 6, 71, 27);
    NSButton *_cancelButton = [[NSButton alloc] initWithFrame: rectCancelButton]; 
    [_cancelButton setBordered: YES];
    [_cancelButton setButtonType: NSMomentaryPushButton];
    [_cancelButton setTitle:  @"Cancel"];
    [_cancelButton setImagePosition: NSNoImage]; 
    [_cancelButton setTarget: self];
    [_cancelButton setAction: @selector(okCancelAction:)];
    [_cancelButton setTag: 0];
    [_bottomView addSubview: _cancelButton];
    [_cancelButton release];
    
    NSRect rectOkButton = NSMakeRect (228, 6, 71, 27);
    NSButton *_okButton = [[NSButton alloc] initWithFrame: rectOkButton]; 
    [_okButton setBordered: YES];
    [_okButton setButtonType: NSMomentaryPushButton];
    [_okButton setTitle:  @"OK"];
    [_okButton setImagePosition: NSImageRight]; 
    [_okButton setImage: [NSImage imageNamed: @"common_ret"]];
    [_okButton setAlternateImage: [NSImage imageNamed: @"common_retH"]];
    [_okButton setTarget: self];
    [_okButton setAction: @selector(okCancelAction:)];
    [_okButton setEnabled: YES];
    [_okButton setTag: NSOKButton];
    [_bottomView addSubview: _okButton];
    //     [lastKeyView setNextKeyView: _okButton];
    //     [self setDefaultButtonCell: [_okButton cell]];
    [_okButton release];
    
    [[window contentView] addSubview: _bottomView];
    [_bottomView release];


    printf("End _bottomView\n");

  }

}



-(void) dealloc
{
  [paperSize dealloc];
  [super dealloc];
}


- (void) setAccessoryView: (NSView*)aView
{
  NSRect accessoryViewFrame, bottomFrame;
  NSRect tmpRect;
  NSSize contentSize, contentMinSize;
  float addedHeight, accessoryWidth;
  
  if (aView == _accessoryView)
    return;
  
  /* The following code is very tricky.  Please think and test a lot
     before changing it. */

  /* Remove old accessory view if any */
  if (_accessoryView != nil)
    {
      /* Remove accessory view */
      accessoryViewFrame = [_accessoryView frame];
      [_accessoryView removeFromSuperview];


      /* Resize the panel to the height without the accessory view. 
	 This must be done with the special care of not resizing 
	 the heights of the other views. */
      addedHeight = accessoryViewFrame.size.height + (_SAVE_PANEL_Y_PAD * 2);
      contentSize = [[self contentView] frame].size;
      contentSize.height -= addedHeight;
      // Resize without modifying topView and bottomView height.
      [topView setAutoresizingMask: NSViewWidthSizable | NSViewMinYMargin];
      [self setContentSize: contentSize];
      [topView setAutoresizingMask: NSViewWidthSizable|NSViewHeightSizable];
    }
  
  /* Resize the panel to its original size.  This resizes freely the
     heights of the views.  NB: minSize *must* come first */
  [self setMinSize: [topView frame].size];
  [self setContentSize: [topView frame].size];
  
  /* Set the new accessory view */
  _accessoryView = aView;
  
  /* If there is a new accessory view, plug it in */
  if (_accessoryView != nil)
    {
      /* Make sure the new accessory view behaves  - its height must be fixed
       * and its position relative to the bottom of the superview must not
       * change	- so its position rlative to the top must be changable. */
      [_accessoryView setAutoresizingMask: NSViewMaxYMargin
	| ([_accessoryView autoresizingMask] 
	& ~(NSViewHeightSizable | NSViewMinYMargin))];  
      
      /* Compute size taken by the new accessory view */
      accessoryViewFrame = [_accessoryView frame];
      addedHeight = accessoryViewFrame.size.height + (_SAVE_PANEL_Y_PAD * 2);
      accessoryWidth = accessoryViewFrame.size.width + (_SAVE_PANEL_X_PAD * 2);

      /* Resize content size accordingly */
      contentSize = [topView frame].size;
      contentSize.height += addedHeight;
      if (accessoryWidth > contentSize.width)
	{
	  contentSize.width = accessoryWidth;
	}
      
      /* Set new content size without resizing heights of topView, bottomView */
      // Our views should resize horizontally if needed, but not vertically
      [topView setAutoresizingMask: NSViewWidthSizable | NSViewMinYMargin];
      [self setContentSize: contentSize];
      // Restore the original autoresizing masks
      [topView setAutoresizingMask: NSViewWidthSizable|NSViewHeightSizable];

      /* Compute new min size */
      contentMinSize = [topView frame].size;
      contentMinSize.height += addedHeight;
      // width is more delicate
      tmpRect = NSMakeRect (0, 0, contentMinSize.width, contentMinSize.height);
      tmpRect = [NSWindow contentRectForFrameRect: tmpRect 
			  styleMask: [self styleMask]];
      if (accessoryWidth > tmpRect.size.width)
	{
	  contentMinSize.width += accessoryWidth - tmpRect.size.width;
	}
      // Set new min size
      [self setMinSize: contentMinSize];

      /*
       * Pack the Views
       */

      /* BottomView is ready */
      //bottomFrame = [_bottomView frame];
      bottomFrame = NSMakeRect(0,0,[self frame].size.width,30);
      
      /* AccessoryView */
      accessoryViewFrame.origin.x 
	= (contentSize.width - accessoryViewFrame.size.width) / 2;
      accessoryViewFrame.origin.y =  NSMaxY (bottomFrame) + _SAVE_PANEL_Y_PAD;
      [_accessoryView setFrameOrigin: accessoryViewFrame.origin];

      /* Add the accessory view */
      [[self contentView] addSubview: _accessoryView];
    }
}

- (NSView*) accessoryView
{
  return _accessoryView;
}

/***********************************************/
/************** Internals Actions methods ******/
/***********************************************/

- (void) okCancelAction: (id)sender
{
  int tag = [sender tag];
  printf("Tag okCancelAction %i",tag);
  if (tag == 1) 
    [self close];
  else
    [self _saveAndApply];
}


- (void) settingsAction: (id)sender
{

  //printPopUp : Do nothing / scaleField
  if ( (  sender == printPopUp ) || ( sender == scaleField ) )
    return;


  if ( sender == styleMatrix )
    {
      int tag = [[sender selectedCell] tag];
      printf("tag %i\n",tag);

      switch(tag) 
	{
	case PORTRAIT : 
	  if (! _portrait ) 
	    {
	      NSString *tmp  = [[NSString alloc] initWithString : [widthField stringValue]];
	      [widthField setStringValue:[heightField stringValue]];
	      [heightField setStringValue:tmp];
	      [[styleMatrix cellAtRow:0 column:PORTRAIT] setEnabled: NO];
	      [[styleMatrix cellAtRow:0 column:LANDSCAPE] setEnabled: YES];
	      _portrait = YES;
	    }
	  break;
	case LANDSCAPE :
	  if ( _portrait ) 
	    {
	      NSString *tmp  = [[NSString alloc] initWithString : [widthField stringValue]];
	      [widthField setStringValue:[heightField stringValue]];
	      [heightField setStringValue:tmp];
	      [[styleMatrix cellAtRow:0 column:LANDSCAPE] setEnabled: NO];
	      [[styleMatrix cellAtRow:0 column:PORTRAIT] setEnabled: YES];
	      _portrait = NO;

	    }
	}
    }
  else if ( sender == unitsPopUp ) 
    {
      float value;
      int tag = [sender indexOfItem: [sender selectedItem]];
      
      // conversion http://dx.sheridan.com/advisor/converter.html
      switch (tag) 
	{
	case INCHES : 
	  value = 0.01;
	  break;
	case CENTIMETERS:
	  value = 0.35;
	  break;
	case POINTS :
	  //itself
	  value = 1;
	  break;
	case PICAS:
	  value = 0.08;
	  break;
	default:
	  printf("Ouch Default settingsAction: PageLayoutPanel \n");
	  return;
	}
      //TODO : use Formater to be sure to have numbers
      NSDictionary *sizeDict = [paperSize objectForKey: [[paperPopUp selectedItem] title]];

      [widthField setStringValue:[NSString stringWithFormat:@"%f", ( [[sizeDict objectForKey:@"w"] floatValue] * value ) ]];
      [heightField setStringValue:[NSString stringWithFormat:@"%f", ( [[sizeDict objectForKey:@"h"] floatValue] * value ) ]];
    }
  
  else if ( sender == paperPopUp ) 
    {
      int tag = [sender indexOfItem: [sender selectedItem]];
      printf("tag %i paperSize count %i\n",tag,[paperSize count]);
      //case tag == Other
      if ( tag == ( [paperSize count]  )  )
	{
	  printf ("nextResponder => widthfield\n");
	  //nextResponder => widthfield
	  return;	  
	}
      NSDictionary *sizeDict = [paperSize objectForKey: [[sender selectedItem] title]];

      [widthField setStringValue:[sizeDict objectForKey:@"w"]];
      [heightField setStringValue:[sizeDict objectForKey:@"h"]];
      return;
    }
  if ( ( sender != widthField ) && ( sender != heightField ) ) 
    [self _updateCell];
  
  [self _displayButton];
}


//TextFields Delegate
- (void)controlTextDidChange:(NSNotification *)aNotification
{
  [paperPopUp selectItemAtIndex:([paperPopUp numberOfItems] - 1)];
}

@end

