/* -*- c++ -*- */
/*
 * Copyright 2003,2004 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef INCLUDED_GR_OSCOPE_SINK_C_H
#define INCLUDED_GR_OSCOPE_SINK_C_H

#include <gr_oscope_sink_x.h>

class gr_oscope_sink_c;
typedef boost::shared_ptr<gr_oscope_sink_x> gr_oscope_sink_c_sptr;

gr_oscope_sink_c_sptr gr_make_oscope_sink_c (double sampling_rate, int file_descriptor);


/*!
 * \brief Building block for python oscilloscope module.
 * \ingroup sink
 *
 * Accepts 1 to 8 gr_complex streams.
 */
class gr_oscope_sink_c : public gr_oscope_sink_x
{
private:
  friend gr_oscope_sink_c_sptr
  gr_make_oscope_sink_c (double sampling_rate, int file_descriptor);

  gr_oscope_sink_c (double sampling_rate, int file_descriptor);

  int			 d_fd;
  float			*d_tmp;

public:
  ~gr_oscope_sink_c ();

  int work (int noutput_items,
	    gr_vector_const_void_star &input_items,
	    gr_vector_void_star &output_items);
};

#endif /* INCLUDED_GR_OSCOPE_SINK_C_H */
