/*
     This file is part of GNUnet
     (C) 2004, 2005 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.

*/

#ifndef STATS_FUNCTIONS_H
#define STATS_FUNCTIONS_H

#include <GNUnet/gnunet_util.h>

typedef struct {
  char * statName;
  long long value;
  long long lvalue;
  cron_t delta;
} StatPair;

/**
 * Callback function to obtain the latest stats
 * data for this stat display.
 */
typedef int (*UpdateData)(const void * closure,
			  gfloat ** data);


typedef struct SE_ {
  char * paneName;
  char * frameName;
  UpdateData getData;
  void * get_closure;
  unsigned int count;
  int fill; /* YES / NO */
} StatEntry;

extern StatEntry stats[];

extern int UPDATE_INTERVAL;

void init_functions(void);

void done_functions(void);

#endif
