/*
     This file is part of GNUnet.
     (C) 2005 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/plugins/fs/search.h
 * @brief code for searching with gnunet-gtk
 * @author Christian Grothoff
 */

#ifndef GTK_SEARCH_H
#define GTK_SEARCH_H

#include <GNUnet/gnunet_ecrs_lib.h>

/**
 * Add an entry to the search tree.
 *
 * @param model the search model
 * @param pos the position to add the entry
 * @param uri the URI to add
 * @param meta metadata describing the URI
 */
void addEntryToSearchTree(GtkTreeStore * model,
			  GtkTreeIter * pos,
			  const struct ECRS_URI * uri,
			  const struct ECRS_MetaData * meta);

/**
 * Add the given result to the model (search result
 * list).
 * @param info the information to add to the model
 * @param uri the search URI
 * @param path the tree path that selects where to add
 *        the information, NULL for top-level
 */
void displaySearchResult(const ECRS_FileInfo * info,
			 const struct ECRS_URI * uri,
			 GtkTreeRowReference * row);

/**
 * Helper for download.
 */
GtkWidget * getAnonymityButtonFromTM(GtkTreeModel * model);

int openTabForSearch(void * unused,
		     const struct ECRS_URI * uri,
		     unsigned int anonymityLevel,
		     unsigned int resultCount,
		     const ECRS_FileInfo * results);

void fs_search_start(void);

void fs_search_stop(void);

#endif
