//
// ldap_asn.cxx
//
// Code automatically generated by asnparse.
//

#ifdef __GNUC__
#pragma implementation "ldap_asn.h"
#endif

#include <ptlib.h>
#include "ldap_asn.h"

#define new PNEW


//
// UnbindRequest
//

LDAP_UnbindRequest::LDAP_UnbindRequest(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Null(tag, tagClass)
{
}


PObject * LDAP_UnbindRequest::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_UnbindRequest::Class()), PInvalidCast);
#endif
  return new LDAP_UnbindRequest(*this);
}


//
// SearchResponse
//

LDAP_SearchResponse::LDAP_SearchResponse(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 2, FALSE
#ifndef PASN_NOPRINTON
      , "entry=4 "
        "resultCode "
#endif
    )
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
LDAP_SearchResponse::operator LDAP_SearchResponse_entry &() const
#else
LDAP_SearchResponse::operator LDAP_SearchResponse_entry &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_SearchResponse_entry::Class()), PInvalidCast);
#endif
  return *(LDAP_SearchResponse_entry *)choice;
}


LDAP_SearchResponse::operator const LDAP_SearchResponse_entry &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_SearchResponse_entry::Class()), PInvalidCast);
#endif
  return *(LDAP_SearchResponse_entry *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
LDAP_SearchResponse::operator LDAP_LDAPResult &() const
#else
LDAP_SearchResponse::operator LDAP_LDAPResult &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_LDAPResult::Class()), PInvalidCast);
#endif
  return *(LDAP_LDAPResult *)choice;
}


LDAP_SearchResponse::operator const LDAP_LDAPResult &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_LDAPResult::Class()), PInvalidCast);
#endif
  return *(LDAP_LDAPResult *)choice;
}


BOOL LDAP_SearchResponse::CreateObject()
{
  switch (tag) {
    case e_entry :
      choice = new LDAP_SearchResponse_entry();
      return TRUE;
    case e_resultCode :
      choice = new LDAP_LDAPResult(5, ApplicationTagClass);
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * LDAP_SearchResponse::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_SearchResponse::Class()), PInvalidCast);
#endif
  return new LDAP_SearchResponse(*this);
}


//
// MessageID
//

LDAP_MessageID::LDAP_MessageID(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Integer(tag, tagClass)
{
  SetConstraints(PASN_Object::FixedConstraint, 0, 65535);
}


LDAP_MessageID & LDAP_MessageID::operator=(int v)
{
  SetValue(v);
  return *this;
}


LDAP_MessageID & LDAP_MessageID::operator=(unsigned v)
{
  SetValue(v);
  return *this;
}


PObject * LDAP_MessageID::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_MessageID::Class()), PInvalidCast);
#endif
  return new LDAP_MessageID(*this);
}


//
// Filter
//

LDAP_Filter::LDAP_Filter(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 9, FALSE
#ifndef PASN_NOPRINTON
      , "and "
        "or "
        "equalityMatch=3 "
        "substrings "
        "greaterOrEqual "
        "lessOrEqual "
        "present "
        "approxMatch "
#endif
    )
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
LDAP_Filter::operator LDAP_ArrayOf_Filter &() const
#else
LDAP_Filter::operator LDAP_ArrayOf_Filter &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_ArrayOf_Filter::Class()), PInvalidCast);
#endif
  return *(LDAP_ArrayOf_Filter *)choice;
}


LDAP_Filter::operator const LDAP_ArrayOf_Filter &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_ArrayOf_Filter::Class()), PInvalidCast);
#endif
  return *(LDAP_ArrayOf_Filter *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
LDAP_Filter::operator LDAP_AttributeValueAssertion &() const
#else
LDAP_Filter::operator LDAP_AttributeValueAssertion &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_AttributeValueAssertion::Class()), PInvalidCast);
#endif
  return *(LDAP_AttributeValueAssertion *)choice;
}


LDAP_Filter::operator const LDAP_AttributeValueAssertion &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_AttributeValueAssertion::Class()), PInvalidCast);
#endif
  return *(LDAP_AttributeValueAssertion *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
LDAP_Filter::operator LDAP_SubstringFilter &() const
#else
LDAP_Filter::operator LDAP_SubstringFilter &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_SubstringFilter::Class()), PInvalidCast);
#endif
  return *(LDAP_SubstringFilter *)choice;
}


LDAP_Filter::operator const LDAP_SubstringFilter &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_SubstringFilter::Class()), PInvalidCast);
#endif
  return *(LDAP_SubstringFilter *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
LDAP_Filter::operator LDAP_AttributeType &() const
#else
LDAP_Filter::operator LDAP_AttributeType &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_AttributeType::Class()), PInvalidCast);
#endif
  return *(LDAP_AttributeType *)choice;
}


LDAP_Filter::operator const LDAP_AttributeType &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_AttributeType::Class()), PInvalidCast);
#endif
  return *(LDAP_AttributeType *)choice;
}


BOOL LDAP_Filter::CreateObject()
{
  switch (tag) {
    case e_and :
    case e_or :
      choice = new LDAP_ArrayOf_Filter();
      return TRUE;
    case e_equalityMatch :
    case e_greaterOrEqual :
    case e_lessOrEqual :
    case e_approxMatch :
      choice = new LDAP_AttributeValueAssertion(3, ContextSpecificTagClass);
      return TRUE;
    case e_substrings :
      choice = new LDAP_SubstringFilter(4, ContextSpecificTagClass);
      return TRUE;
    case e_present :
      choice = new LDAP_AttributeType(7, ContextSpecificTagClass);
      return TRUE;
  }

  choice = new LDAP_Filter(tag, tagClass);
  if (((PASN_Choice*)choice)->CreateObject())
    return TRUE;
  delete choice;

  choice = NULL;
  return FALSE;
}


PObject * LDAP_Filter::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_Filter::Class()), PInvalidCast);
#endif
  return new LDAP_Filter(*this);
}


//
// AttributeValue
//

LDAP_AttributeValue::LDAP_AttributeValue(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_OctetString(tag, tagClass)
{
}


LDAP_AttributeValue & LDAP_AttributeValue::operator=(const char * v)
{
  SetValue(v);
  return *this;
}


LDAP_AttributeValue & LDAP_AttributeValue::operator=(const PString & v)
{
  SetValue(v);
  return *this;
}


LDAP_AttributeValue & LDAP_AttributeValue::operator=(const PBYTEArray & v)
{
  SetValue(v);
  return *this;
}


PObject * LDAP_AttributeValue::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_AttributeValue::Class()), PInvalidCast);
#endif
  return new LDAP_AttributeValue(*this);
}


//
// LDAPString
//

LDAP_LDAPString::LDAP_LDAPString(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_OctetString(tag, tagClass)
{
}


LDAP_LDAPString & LDAP_LDAPString::operator=(const char * v)
{
  SetValue(v);
  return *this;
}


LDAP_LDAPString & LDAP_LDAPString::operator=(const PString & v)
{
  SetValue(v);
  return *this;
}


LDAP_LDAPString & LDAP_LDAPString::operator=(const PBYTEArray & v)
{
  SetValue(v);
  return *this;
}


PObject * LDAP_LDAPString::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_LDAPString::Class()), PInvalidCast);
#endif
  return new LDAP_LDAPString(*this);
}


//
// LDAPMessage_protocolOp
//

LDAP_LDAPMessage_protocolOp::LDAP_LDAPMessage_protocolOp(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 16, FALSE
#ifndef PASN_NOPRINTON
      , "searchRequest=3 "
        "modifyRequest=6 "
        "modifyResponse "
        "addRequest "
        "addResponse "
        "delRequest "
        "delResponse "
        "modifyRDNRequest "
        "modifyRDNResponse "
        "compareDNRequest "
        "compareDNResponse "
        "bindRequest=0 "
        "bindResponse "
        "abandonRequest=16 "
        "unbindRequest=2 "
#endif
    )
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
LDAP_LDAPMessage_protocolOp::operator LDAP_SearchRequest &() const
#else
LDAP_LDAPMessage_protocolOp::operator LDAP_SearchRequest &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_SearchRequest::Class()), PInvalidCast);
#endif
  return *(LDAP_SearchRequest *)choice;
}


LDAP_LDAPMessage_protocolOp::operator const LDAP_SearchRequest &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_SearchRequest::Class()), PInvalidCast);
#endif
  return *(LDAP_SearchRequest *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
LDAP_LDAPMessage_protocolOp::operator LDAP_SearchResponse &() const
#else
LDAP_LDAPMessage_protocolOp::operator LDAP_SearchResponse &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_SearchResponse::Class()), PInvalidCast);
#endif
  return *(LDAP_SearchResponse *)choice;
}


LDAP_LDAPMessage_protocolOp::operator const LDAP_SearchResponse &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_SearchResponse::Class()), PInvalidCast);
#endif
  return *(LDAP_SearchResponse *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
LDAP_LDAPMessage_protocolOp::operator LDAP_ModifyRequest &() const
#else
LDAP_LDAPMessage_protocolOp::operator LDAP_ModifyRequest &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_ModifyRequest::Class()), PInvalidCast);
#endif
  return *(LDAP_ModifyRequest *)choice;
}


LDAP_LDAPMessage_protocolOp::operator const LDAP_ModifyRequest &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_ModifyRequest::Class()), PInvalidCast);
#endif
  return *(LDAP_ModifyRequest *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
LDAP_LDAPMessage_protocolOp::operator LDAP_ModifyResponse &() const
#else
LDAP_LDAPMessage_protocolOp::operator LDAP_ModifyResponse &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_ModifyResponse::Class()), PInvalidCast);
#endif
  return *(LDAP_ModifyResponse *)choice;
}


LDAP_LDAPMessage_protocolOp::operator const LDAP_ModifyResponse &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_ModifyResponse::Class()), PInvalidCast);
#endif
  return *(LDAP_ModifyResponse *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
LDAP_LDAPMessage_protocolOp::operator LDAP_AddRequest &() const
#else
LDAP_LDAPMessage_protocolOp::operator LDAP_AddRequest &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_AddRequest::Class()), PInvalidCast);
#endif
  return *(LDAP_AddRequest *)choice;
}


LDAP_LDAPMessage_protocolOp::operator const LDAP_AddRequest &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_AddRequest::Class()), PInvalidCast);
#endif
  return *(LDAP_AddRequest *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
LDAP_LDAPMessage_protocolOp::operator LDAP_AddResponse &() const
#else
LDAP_LDAPMessage_protocolOp::operator LDAP_AddResponse &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_AddResponse::Class()), PInvalidCast);
#endif
  return *(LDAP_AddResponse *)choice;
}


LDAP_LDAPMessage_protocolOp::operator const LDAP_AddResponse &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_AddResponse::Class()), PInvalidCast);
#endif
  return *(LDAP_AddResponse *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
LDAP_LDAPMessage_protocolOp::operator LDAP_DelRequest &() const
#else
LDAP_LDAPMessage_protocolOp::operator LDAP_DelRequest &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_DelRequest::Class()), PInvalidCast);
#endif
  return *(LDAP_DelRequest *)choice;
}


LDAP_LDAPMessage_protocolOp::operator const LDAP_DelRequest &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_DelRequest::Class()), PInvalidCast);
#endif
  return *(LDAP_DelRequest *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
LDAP_LDAPMessage_protocolOp::operator LDAP_DelResponse &() const
#else
LDAP_LDAPMessage_protocolOp::operator LDAP_DelResponse &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_DelResponse::Class()), PInvalidCast);
#endif
  return *(LDAP_DelResponse *)choice;
}


LDAP_LDAPMessage_protocolOp::operator const LDAP_DelResponse &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_DelResponse::Class()), PInvalidCast);
#endif
  return *(LDAP_DelResponse *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
LDAP_LDAPMessage_protocolOp::operator LDAP_ModifyRDNRequest &() const
#else
LDAP_LDAPMessage_protocolOp::operator LDAP_ModifyRDNRequest &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_ModifyRDNRequest::Class()), PInvalidCast);
#endif
  return *(LDAP_ModifyRDNRequest *)choice;
}


LDAP_LDAPMessage_protocolOp::operator const LDAP_ModifyRDNRequest &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_ModifyRDNRequest::Class()), PInvalidCast);
#endif
  return *(LDAP_ModifyRDNRequest *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
LDAP_LDAPMessage_protocolOp::operator LDAP_ModifyRDNResponse &() const
#else
LDAP_LDAPMessage_protocolOp::operator LDAP_ModifyRDNResponse &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_ModifyRDNResponse::Class()), PInvalidCast);
#endif
  return *(LDAP_ModifyRDNResponse *)choice;
}


LDAP_LDAPMessage_protocolOp::operator const LDAP_ModifyRDNResponse &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_ModifyRDNResponse::Class()), PInvalidCast);
#endif
  return *(LDAP_ModifyRDNResponse *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
LDAP_LDAPMessage_protocolOp::operator LDAP_CompareRequest &() const
#else
LDAP_LDAPMessage_protocolOp::operator LDAP_CompareRequest &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_CompareRequest::Class()), PInvalidCast);
#endif
  return *(LDAP_CompareRequest *)choice;
}


LDAP_LDAPMessage_protocolOp::operator const LDAP_CompareRequest &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_CompareRequest::Class()), PInvalidCast);
#endif
  return *(LDAP_CompareRequest *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
LDAP_LDAPMessage_protocolOp::operator LDAP_CompareResponse &() const
#else
LDAP_LDAPMessage_protocolOp::operator LDAP_CompareResponse &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_CompareResponse::Class()), PInvalidCast);
#endif
  return *(LDAP_CompareResponse *)choice;
}


LDAP_LDAPMessage_protocolOp::operator const LDAP_CompareResponse &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_CompareResponse::Class()), PInvalidCast);
#endif
  return *(LDAP_CompareResponse *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
LDAP_LDAPMessage_protocolOp::operator LDAP_BindRequest &() const
#else
LDAP_LDAPMessage_protocolOp::operator LDAP_BindRequest &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_BindRequest::Class()), PInvalidCast);
#endif
  return *(LDAP_BindRequest *)choice;
}


LDAP_LDAPMessage_protocolOp::operator const LDAP_BindRequest &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_BindRequest::Class()), PInvalidCast);
#endif
  return *(LDAP_BindRequest *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
LDAP_LDAPMessage_protocolOp::operator LDAP_BindResponse &() const
#else
LDAP_LDAPMessage_protocolOp::operator LDAP_BindResponse &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_BindResponse::Class()), PInvalidCast);
#endif
  return *(LDAP_BindResponse *)choice;
}


LDAP_LDAPMessage_protocolOp::operator const LDAP_BindResponse &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_BindResponse::Class()), PInvalidCast);
#endif
  return *(LDAP_BindResponse *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
LDAP_LDAPMessage_protocolOp::operator LDAP_AbandonRequest &() const
#else
LDAP_LDAPMessage_protocolOp::operator LDAP_AbandonRequest &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_AbandonRequest::Class()), PInvalidCast);
#endif
  return *(LDAP_AbandonRequest *)choice;
}


LDAP_LDAPMessage_protocolOp::operator const LDAP_AbandonRequest &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_AbandonRequest::Class()), PInvalidCast);
#endif
  return *(LDAP_AbandonRequest *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
LDAP_LDAPMessage_protocolOp::operator LDAP_UnbindRequest &() const
#else
LDAP_LDAPMessage_protocolOp::operator LDAP_UnbindRequest &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_UnbindRequest::Class()), PInvalidCast);
#endif
  return *(LDAP_UnbindRequest *)choice;
}


LDAP_LDAPMessage_protocolOp::operator const LDAP_UnbindRequest &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_UnbindRequest::Class()), PInvalidCast);
#endif
  return *(LDAP_UnbindRequest *)choice;
}


BOOL LDAP_LDAPMessage_protocolOp::CreateObject()
{
  switch (tag) {
    case e_searchRequest :
      choice = new LDAP_SearchRequest();
      return TRUE;
    case e_modifyRequest :
      choice = new LDAP_ModifyRequest();
      return TRUE;
    case e_modifyResponse :
      choice = new LDAP_ModifyResponse();
      return TRUE;
    case e_addRequest :
      choice = new LDAP_AddRequest();
      return TRUE;
    case e_addResponse :
      choice = new LDAP_AddResponse();
      return TRUE;
    case e_delRequest :
      choice = new LDAP_DelRequest();
      return TRUE;
    case e_delResponse :
      choice = new LDAP_DelResponse();
      return TRUE;
    case e_modifyRDNRequest :
      choice = new LDAP_ModifyRDNRequest();
      return TRUE;
    case e_modifyRDNResponse :
      choice = new LDAP_ModifyRDNResponse();
      return TRUE;
    case e_compareDNRequest :
      choice = new LDAP_CompareRequest();
      return TRUE;
    case e_compareDNResponse :
      choice = new LDAP_CompareResponse();
      return TRUE;
    case e_bindRequest :
      choice = new LDAP_BindRequest();
      return TRUE;
    case e_bindResponse :
      choice = new LDAP_BindResponse();
      return TRUE;
    case e_abandonRequest :
      choice = new LDAP_AbandonRequest();
      return TRUE;
    case e_unbindRequest :
      choice = new LDAP_UnbindRequest();
      return TRUE;
  }

  choice = new LDAP_SearchResponse(tag, tagClass);
  if (((PASN_Choice*)choice)->CreateObject())
    return TRUE;
  delete choice;

  choice = NULL;
  return FALSE;
}


PObject * LDAP_LDAPMessage_protocolOp::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_LDAPMessage_protocolOp::Class()), PInvalidCast);
#endif
  return new LDAP_LDAPMessage_protocolOp(*this);
}


//
// BindRequest_authentication
//

LDAP_BindRequest_authentication::LDAP_BindRequest_authentication(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 3, FALSE
#ifndef PASN_NOPRINTON
      , "simple "
        "krbv42LDAP "
        "krbv42DSA "
#endif
    )
{
}


BOOL LDAP_BindRequest_authentication::CreateObject()
{
  switch (tag) {
    case e_simple :
    case e_krbv42LDAP :
    case e_krbv42DSA :
      choice = new PASN_OctetString(0, ContextSpecificTagClass);
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * LDAP_BindRequest_authentication::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_BindRequest_authentication::Class()), PInvalidCast);
#endif
  return new LDAP_BindRequest_authentication(*this);
}


//
// SearchRequest_scope
//

LDAP_SearchRequest_scope::LDAP_SearchRequest_scope(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Enumeration(tag, tagClass, 2, FALSE
#ifndef PASN_NOPRINTON
      , "baseObject "
        "singleLevel "
        "wholeSubtree "
#endif
    )
{
}


LDAP_SearchRequest_scope & LDAP_SearchRequest_scope::operator=(unsigned v)
{
  SetValue(v);
  return *this;
}


PObject * LDAP_SearchRequest_scope::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_SearchRequest_scope::Class()), PInvalidCast);
#endif
  return new LDAP_SearchRequest_scope(*this);
}


//
// SearchRequest_derefAliases
//

LDAP_SearchRequest_derefAliases::LDAP_SearchRequest_derefAliases(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Enumeration(tag, tagClass, 3, FALSE
#ifndef PASN_NOPRINTON
      , "neverDerefAliases "
        "derefInSearching "
        "derefFindingBaseObj "
        "alwaysDerefAliases "
#endif
    )
{
}


LDAP_SearchRequest_derefAliases & LDAP_SearchRequest_derefAliases::operator=(unsigned v)
{
  SetValue(v);
  return *this;
}


PObject * LDAP_SearchRequest_derefAliases::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_SearchRequest_derefAliases::Class()), PInvalidCast);
#endif
  return new LDAP_SearchRequest_derefAliases(*this);
}


//
// ArrayOf_AttributeType
//

LDAP_ArrayOf_AttributeType::LDAP_ArrayOf_AttributeType(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Array(tag, tagClass)
{
}


PASN_Object * LDAP_ArrayOf_AttributeType::CreateObject() const
{
  return new LDAP_AttributeType;
}


LDAP_AttributeType & LDAP_ArrayOf_AttributeType::operator[](PINDEX i) const
{
  return (LDAP_AttributeType &)array[i];
}


PObject * LDAP_ArrayOf_AttributeType::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_ArrayOf_AttributeType::Class()), PInvalidCast);
#endif
  return new LDAP_ArrayOf_AttributeType(*this);
}


//
// ModifyRequest_modifications
//

LDAP_ModifyRequest_modifications::LDAP_ModifyRequest_modifications(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Array(tag, tagClass)
{
}


PASN_Object * LDAP_ModifyRequest_modifications::CreateObject() const
{
  return new LDAP_ModifyRequest_modifications_subtype;
}


LDAP_ModifyRequest_modifications_subtype & LDAP_ModifyRequest_modifications::operator[](PINDEX i) const
{
  return (LDAP_ModifyRequest_modifications_subtype &)array[i];
}


PObject * LDAP_ModifyRequest_modifications::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_ModifyRequest_modifications::Class()), PInvalidCast);
#endif
  return new LDAP_ModifyRequest_modifications(*this);
}


//
// AddRequest_attrs
//

LDAP_AddRequest_attrs::LDAP_AddRequest_attrs(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Array(tag, tagClass)
{
}


PASN_Object * LDAP_AddRequest_attrs::CreateObject() const
{
  return new LDAP_AddRequest_attrs_subtype;
}


LDAP_AddRequest_attrs_subtype & LDAP_AddRequest_attrs::operator[](PINDEX i) const
{
  return (LDAP_AddRequest_attrs_subtype &)array[i];
}


PObject * LDAP_AddRequest_attrs::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_AddRequest_attrs::Class()), PInvalidCast);
#endif
  return new LDAP_AddRequest_attrs(*this);
}


//
// ArrayOf_Filter
//

LDAP_ArrayOf_Filter::LDAP_ArrayOf_Filter(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Array(tag, tagClass)
{
}


PASN_Object * LDAP_ArrayOf_Filter::CreateObject() const
{
  return new LDAP_Filter;
}


LDAP_Filter & LDAP_ArrayOf_Filter::operator[](PINDEX i) const
{
  return (LDAP_Filter &)array[i];
}


PObject * LDAP_ArrayOf_Filter::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_ArrayOf_Filter::Class()), PInvalidCast);
#endif
  return new LDAP_ArrayOf_Filter(*this);
}


//
// LDAPResult_resultCode
//

LDAP_LDAPResult_resultCode::LDAP_LDAPResult_resultCode(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Enumeration(tag, tagClass, 80, FALSE
#ifndef PASN_NOPRINTON
      , "success "
        "operationsError "
        "protocolError "
        "timeLimitExceeded "
        "sizeLimitExceeded "
        "compareFalse "
        "compareTrue "
        "authMethodNotSupported "
        "strongAuthRequired "
        "noSuchAttribute=16 "
        "undefinedAttributeType "
        "inappropriateMatching "
        "constraintViolation "
        "attributeOrValueExists "
        "invalidAttributeSyntax "
        "noSuchObject=32 "
        "aliasProblem "
        "invalidDNSyntax "
        "isLeaf "
        "aliasDereferencingProblem "
        "inappropriateAuthentication=48 "
        "invalidCredentials "
        "insufficientAccessRights "
        "busy "
        "unavailable "
        "unwillingToPerform "
        "loopDetect "
        "namingViolation=64 "
        "objectClassViolation "
        "notAllowedOnNonLeaf "
        "notAllowedOnRDN "
        "entryAlreadyExists "
        "objectClassModsProhibited "
        "other=80 "
#endif
    )
{
}


LDAP_LDAPResult_resultCode & LDAP_LDAPResult_resultCode::operator=(unsigned v)
{
  SetValue(v);
  return *this;
}


PObject * LDAP_LDAPResult_resultCode::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_LDAPResult_resultCode::Class()), PInvalidCast);
#endif
  return new LDAP_LDAPResult_resultCode(*this);
}


//
// SubstringFilter_value
//

LDAP_SubstringFilter_value::LDAP_SubstringFilter_value(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Array(tag, tagClass)
{
}


PASN_Object * LDAP_SubstringFilter_value::CreateObject() const
{
  return new LDAP_SubstringFilter_value_subtype;
}


LDAP_SubstringFilter_value_subtype & LDAP_SubstringFilter_value::operator[](PINDEX i) const
{
  return (LDAP_SubstringFilter_value_subtype &)array[i];
}


PObject * LDAP_SubstringFilter_value::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_SubstringFilter_value::Class()), PInvalidCast);
#endif
  return new LDAP_SubstringFilter_value(*this);
}


//
// SearchResponse_entry_attributes
//

LDAP_SearchResponse_entry_attributes::LDAP_SearchResponse_entry_attributes(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Array(tag, tagClass)
{
}


PASN_Object * LDAP_SearchResponse_entry_attributes::CreateObject() const
{
  return new LDAP_SearchResponse_entry_attributes_subtype;
}


LDAP_SearchResponse_entry_attributes_subtype & LDAP_SearchResponse_entry_attributes::operator[](PINDEX i) const
{
  return (LDAP_SearchResponse_entry_attributes_subtype &)array[i];
}


PObject * LDAP_SearchResponse_entry_attributes::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_SearchResponse_entry_attributes::Class()), PInvalidCast);
#endif
  return new LDAP_SearchResponse_entry_attributes(*this);
}


//
// SubstringFilter_value_subtype
//

LDAP_SubstringFilter_value_subtype::LDAP_SubstringFilter_value_subtype(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 3, FALSE
#ifndef PASN_NOPRINTON
      , "initial "
        "any "
        "final "
#endif
    )
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
LDAP_SubstringFilter_value_subtype::operator LDAP_LDAPString &() const
#else
LDAP_SubstringFilter_value_subtype::operator LDAP_LDAPString &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_LDAPString::Class()), PInvalidCast);
#endif
  return *(LDAP_LDAPString *)choice;
}


LDAP_SubstringFilter_value_subtype::operator const LDAP_LDAPString &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PAssertNULL(choice)->IsDescendant(LDAP_LDAPString::Class()), PInvalidCast);
#endif
  return *(LDAP_LDAPString *)choice;
}


BOOL LDAP_SubstringFilter_value_subtype::CreateObject()
{
  switch (tag) {
    case e_initial :
    case e_any :
    case e_final :
      choice = new LDAP_LDAPString(0, ContextSpecificTagClass);
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * LDAP_SubstringFilter_value_subtype::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_SubstringFilter_value_subtype::Class()), PInvalidCast);
#endif
  return new LDAP_SubstringFilter_value_subtype(*this);
}


//
// ModifyRequest_modifications_subtype_operation
//

LDAP_ModifyRequest_modifications_subtype_operation::LDAP_ModifyRequest_modifications_subtype_operation(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Enumeration(tag, tagClass, 2, FALSE
#ifndef PASN_NOPRINTON
      , "add "
        "delete "
        "replace "
#endif
    )
{
}


LDAP_ModifyRequest_modifications_subtype_operation & LDAP_ModifyRequest_modifications_subtype_operation::operator=(unsigned v)
{
  SetValue(v);
  return *this;
}


PObject * LDAP_ModifyRequest_modifications_subtype_operation::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_ModifyRequest_modifications_subtype_operation::Class()), PInvalidCast);
#endif
  return new LDAP_ModifyRequest_modifications_subtype_operation(*this);
}


//
// ArrayOf_AttributeValue
//

LDAP_ArrayOf_AttributeValue::LDAP_ArrayOf_AttributeValue(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Array(tag, tagClass)
{
}


PASN_Object * LDAP_ArrayOf_AttributeValue::CreateObject() const
{
  return new LDAP_AttributeValue;
}


LDAP_AttributeValue & LDAP_ArrayOf_AttributeValue::operator[](PINDEX i) const
{
  return (LDAP_AttributeValue &)array[i];
}


PObject * LDAP_ArrayOf_AttributeValue::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_ArrayOf_AttributeValue::Class()), PInvalidCast);
#endif
  return new LDAP_ArrayOf_AttributeValue(*this);
}


//
// LDAPMessage
//

LDAP_LDAPMessage::LDAP_LDAPMessage(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, FALSE, 0)
{
}


#ifndef PASN_NOPRINTON
void LDAP_LDAPMessage::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+12) << "messageID = " << setprecision(indent) << m_messageID << '\n';
  strm << setw(indent+13) << "protocolOp = " << setprecision(indent) << m_protocolOp << '\n';
  strm << setw(indent-1) << "}";
}
#endif


PObject::Comparison LDAP_LDAPMessage::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsDescendant(LDAP_LDAPMessage::Class()), PInvalidCast);
#endif
  const LDAP_LDAPMessage & other = (const LDAP_LDAPMessage &)obj;

  Comparison result;

  if ((result = m_messageID.Compare(other.m_messageID)) != EqualTo)
    return result;
  if ((result = m_protocolOp.Compare(other.m_protocolOp)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX LDAP_LDAPMessage::GetDataLength() const
{
  PINDEX length = 0;
  length += m_messageID.GetObjectLength();
  length += m_protocolOp.GetObjectLength();
  return length;
}


BOOL LDAP_LDAPMessage::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_messageID.Decode(strm))
    return FALSE;
  if (!m_protocolOp.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void LDAP_LDAPMessage::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_messageID.Encode(strm);
  m_protocolOp.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * LDAP_LDAPMessage::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_LDAPMessage::Class()), PInvalidCast);
#endif
  return new LDAP_LDAPMessage(*this);
}


//
// AbandonRequest
//

LDAP_AbandonRequest::LDAP_AbandonRequest(unsigned tag, PASN_Object::TagClass tagClass)
  : LDAP_MessageID(tag, tagClass)
{
}


LDAP_AbandonRequest & LDAP_AbandonRequest::operator=(int v)
{
  SetValue(v);
  return *this;
}


LDAP_AbandonRequest & LDAP_AbandonRequest::operator=(unsigned v)
{
  SetValue(v);
  return *this;
}


PObject * LDAP_AbandonRequest::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_AbandonRequest::Class()), PInvalidCast);
#endif
  return new LDAP_AbandonRequest(*this);
}


//
// LDAPDN
//

LDAP_LDAPDN::LDAP_LDAPDN(unsigned tag, PASN_Object::TagClass tagClass)
  : LDAP_LDAPString(tag, tagClass)
{
}


LDAP_LDAPDN & LDAP_LDAPDN::operator=(const char * v)
{
  SetValue(v);
  return *this;
}


LDAP_LDAPDN & LDAP_LDAPDN::operator=(const PString & v)
{
  SetValue(v);
  return *this;
}


LDAP_LDAPDN & LDAP_LDAPDN::operator=(const PBYTEArray & v)
{
  SetValue(v);
  return *this;
}


PObject * LDAP_LDAPDN::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_LDAPDN::Class()), PInvalidCast);
#endif
  return new LDAP_LDAPDN(*this);
}


//
// RelativeLDAPDN
//

LDAP_RelativeLDAPDN::LDAP_RelativeLDAPDN(unsigned tag, PASN_Object::TagClass tagClass)
  : LDAP_LDAPString(tag, tagClass)
{
}


LDAP_RelativeLDAPDN & LDAP_RelativeLDAPDN::operator=(const char * v)
{
  SetValue(v);
  return *this;
}


LDAP_RelativeLDAPDN & LDAP_RelativeLDAPDN::operator=(const PString & v)
{
  SetValue(v);
  return *this;
}


LDAP_RelativeLDAPDN & LDAP_RelativeLDAPDN::operator=(const PBYTEArray & v)
{
  SetValue(v);
  return *this;
}


PObject * LDAP_RelativeLDAPDN::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_RelativeLDAPDN::Class()), PInvalidCast);
#endif
  return new LDAP_RelativeLDAPDN(*this);
}


//
// LDAPResult
//

LDAP_LDAPResult::LDAP_LDAPResult(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, FALSE, 0)
{
}


#ifndef PASN_NOPRINTON
void LDAP_LDAPResult::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+13) << "resultCode = " << setprecision(indent) << m_resultCode << '\n';
  strm << setw(indent+12) << "matchedDN = " << setprecision(indent) << m_matchedDN << '\n';
  strm << setw(indent+15) << "errorMessage = " << setprecision(indent) << m_errorMessage << '\n';
  strm << setw(indent-1) << "}";
}
#endif


PObject::Comparison LDAP_LDAPResult::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsDescendant(LDAP_LDAPResult::Class()), PInvalidCast);
#endif
  const LDAP_LDAPResult & other = (const LDAP_LDAPResult &)obj;

  Comparison result;

  if ((result = m_resultCode.Compare(other.m_resultCode)) != EqualTo)
    return result;
  if ((result = m_matchedDN.Compare(other.m_matchedDN)) != EqualTo)
    return result;
  if ((result = m_errorMessage.Compare(other.m_errorMessage)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX LDAP_LDAPResult::GetDataLength() const
{
  PINDEX length = 0;
  length += m_resultCode.GetObjectLength();
  length += m_matchedDN.GetObjectLength();
  length += m_errorMessage.GetObjectLength();
  return length;
}


BOOL LDAP_LDAPResult::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_resultCode.Decode(strm))
    return FALSE;
  if (!m_matchedDN.Decode(strm))
    return FALSE;
  if (!m_errorMessage.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void LDAP_LDAPResult::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_resultCode.Encode(strm);
  m_matchedDN.Encode(strm);
  m_errorMessage.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * LDAP_LDAPResult::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_LDAPResult::Class()), PInvalidCast);
#endif
  return new LDAP_LDAPResult(*this);
}


//
// AttributeType
//

LDAP_AttributeType::LDAP_AttributeType(unsigned tag, PASN_Object::TagClass tagClass)
  : LDAP_LDAPString(tag, tagClass)
{
}


LDAP_AttributeType & LDAP_AttributeType::operator=(const char * v)
{
  SetValue(v);
  return *this;
}


LDAP_AttributeType & LDAP_AttributeType::operator=(const PString & v)
{
  SetValue(v);
  return *this;
}


LDAP_AttributeType & LDAP_AttributeType::operator=(const PBYTEArray & v)
{
  SetValue(v);
  return *this;
}


PObject * LDAP_AttributeType::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_AttributeType::Class()), PInvalidCast);
#endif
  return new LDAP_AttributeType(*this);
}


//
// AttributeValueAssertion
//

LDAP_AttributeValueAssertion::LDAP_AttributeValueAssertion(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, FALSE, 0)
{
}


#ifndef PASN_NOPRINTON
void LDAP_AttributeValueAssertion::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+16) << "attributeType = " << setprecision(indent) << m_attributeType << '\n';
  strm << setw(indent+17) << "attributeValue = " << setprecision(indent) << m_attributeValue << '\n';
  strm << setw(indent-1) << "}";
}
#endif


PObject::Comparison LDAP_AttributeValueAssertion::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsDescendant(LDAP_AttributeValueAssertion::Class()), PInvalidCast);
#endif
  const LDAP_AttributeValueAssertion & other = (const LDAP_AttributeValueAssertion &)obj;

  Comparison result;

  if ((result = m_attributeType.Compare(other.m_attributeType)) != EqualTo)
    return result;
  if ((result = m_attributeValue.Compare(other.m_attributeValue)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX LDAP_AttributeValueAssertion::GetDataLength() const
{
  PINDEX length = 0;
  length += m_attributeType.GetObjectLength();
  length += m_attributeValue.GetObjectLength();
  return length;
}


BOOL LDAP_AttributeValueAssertion::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_attributeType.Decode(strm))
    return FALSE;
  if (!m_attributeValue.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void LDAP_AttributeValueAssertion::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_attributeType.Encode(strm);
  m_attributeValue.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * LDAP_AttributeValueAssertion::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_AttributeValueAssertion::Class()), PInvalidCast);
#endif
  return new LDAP_AttributeValueAssertion(*this);
}


//
// SubstringFilter
//

LDAP_SubstringFilter::LDAP_SubstringFilter(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, FALSE, 0)
{
}


#ifndef PASN_NOPRINTON
void LDAP_SubstringFilter::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+7) << "type = " << setprecision(indent) << m_type << '\n';
  strm << setw(indent+8) << "value = " << setprecision(indent) << m_value << '\n';
  strm << setw(indent-1) << "}";
}
#endif


PObject::Comparison LDAP_SubstringFilter::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsDescendant(LDAP_SubstringFilter::Class()), PInvalidCast);
#endif
  const LDAP_SubstringFilter & other = (const LDAP_SubstringFilter &)obj;

  Comparison result;

  if ((result = m_type.Compare(other.m_type)) != EqualTo)
    return result;
  if ((result = m_value.Compare(other.m_value)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX LDAP_SubstringFilter::GetDataLength() const
{
  PINDEX length = 0;
  length += m_type.GetObjectLength();
  length += m_value.GetObjectLength();
  return length;
}


BOOL LDAP_SubstringFilter::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_type.Decode(strm))
    return FALSE;
  if (!m_value.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void LDAP_SubstringFilter::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_type.Encode(strm);
  m_value.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * LDAP_SubstringFilter::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_SubstringFilter::Class()), PInvalidCast);
#endif
  return new LDAP_SubstringFilter(*this);
}


//
// SearchResponse_entry
//

LDAP_SearchResponse_entry::LDAP_SearchResponse_entry(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, FALSE, 0)
{
}


#ifndef PASN_NOPRINTON
void LDAP_SearchResponse_entry::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+13) << "objectName = " << setprecision(indent) << m_objectName << '\n';
  strm << setw(indent+13) << "attributes = " << setprecision(indent) << m_attributes << '\n';
  strm << setw(indent-1) << "}";
}
#endif


PObject::Comparison LDAP_SearchResponse_entry::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsDescendant(LDAP_SearchResponse_entry::Class()), PInvalidCast);
#endif
  const LDAP_SearchResponse_entry & other = (const LDAP_SearchResponse_entry &)obj;

  Comparison result;

  if ((result = m_objectName.Compare(other.m_objectName)) != EqualTo)
    return result;
  if ((result = m_attributes.Compare(other.m_attributes)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX LDAP_SearchResponse_entry::GetDataLength() const
{
  PINDEX length = 0;
  length += m_objectName.GetObjectLength();
  length += m_attributes.GetObjectLength();
  return length;
}


BOOL LDAP_SearchResponse_entry::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_objectName.Decode(strm))
    return FALSE;
  if (!m_attributes.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void LDAP_SearchResponse_entry::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_objectName.Encode(strm);
  m_attributes.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * LDAP_SearchResponse_entry::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_SearchResponse_entry::Class()), PInvalidCast);
#endif
  return new LDAP_SearchResponse_entry(*this);
}


//
// AddRequest_attrs_subtype
//

LDAP_AddRequest_attrs_subtype::LDAP_AddRequest_attrs_subtype(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, FALSE, 0)
{
}


#ifndef PASN_NOPRINTON
void LDAP_AddRequest_attrs_subtype::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+7) << "type = " << setprecision(indent) << m_type << '\n';
  strm << setw(indent+9) << "values = " << setprecision(indent) << m_values << '\n';
  strm << setw(indent-1) << "}";
}
#endif


PObject::Comparison LDAP_AddRequest_attrs_subtype::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsDescendant(LDAP_AddRequest_attrs_subtype::Class()), PInvalidCast);
#endif
  const LDAP_AddRequest_attrs_subtype & other = (const LDAP_AddRequest_attrs_subtype &)obj;

  Comparison result;

  if ((result = m_type.Compare(other.m_type)) != EqualTo)
    return result;
  if ((result = m_values.Compare(other.m_values)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX LDAP_AddRequest_attrs_subtype::GetDataLength() const
{
  PINDEX length = 0;
  length += m_type.GetObjectLength();
  length += m_values.GetObjectLength();
  return length;
}


BOOL LDAP_AddRequest_attrs_subtype::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_type.Decode(strm))
    return FALSE;
  if (!m_values.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void LDAP_AddRequest_attrs_subtype::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_type.Encode(strm);
  m_values.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * LDAP_AddRequest_attrs_subtype::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_AddRequest_attrs_subtype::Class()), PInvalidCast);
#endif
  return new LDAP_AddRequest_attrs_subtype(*this);
}


//
// SearchResponse_entry_attributes_subtype
//

LDAP_SearchResponse_entry_attributes_subtype::LDAP_SearchResponse_entry_attributes_subtype(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, FALSE, 0)
{
}


#ifndef PASN_NOPRINTON
void LDAP_SearchResponse_entry_attributes_subtype::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+7) << "type = " << setprecision(indent) << m_type << '\n';
  strm << setw(indent+9) << "values = " << setprecision(indent) << m_values << '\n';
  strm << setw(indent-1) << "}";
}
#endif


PObject::Comparison LDAP_SearchResponse_entry_attributes_subtype::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsDescendant(LDAP_SearchResponse_entry_attributes_subtype::Class()), PInvalidCast);
#endif
  const LDAP_SearchResponse_entry_attributes_subtype & other = (const LDAP_SearchResponse_entry_attributes_subtype &)obj;

  Comparison result;

  if ((result = m_type.Compare(other.m_type)) != EqualTo)
    return result;
  if ((result = m_values.Compare(other.m_values)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX LDAP_SearchResponse_entry_attributes_subtype::GetDataLength() const
{
  PINDEX length = 0;
  length += m_type.GetObjectLength();
  length += m_values.GetObjectLength();
  return length;
}


BOOL LDAP_SearchResponse_entry_attributes_subtype::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_type.Decode(strm))
    return FALSE;
  if (!m_values.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void LDAP_SearchResponse_entry_attributes_subtype::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_type.Encode(strm);
  m_values.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * LDAP_SearchResponse_entry_attributes_subtype::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_SearchResponse_entry_attributes_subtype::Class()), PInvalidCast);
#endif
  return new LDAP_SearchResponse_entry_attributes_subtype(*this);
}


//
// ModifyRequest_modifications_subtype_modification
//

LDAP_ModifyRequest_modifications_subtype_modification::LDAP_ModifyRequest_modifications_subtype_modification(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, FALSE, 0)
{
}


#ifndef PASN_NOPRINTON
void LDAP_ModifyRequest_modifications_subtype_modification::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+7) << "type = " << setprecision(indent) << m_type << '\n';
  strm << setw(indent+9) << "values = " << setprecision(indent) << m_values << '\n';
  strm << setw(indent-1) << "}";
}
#endif


PObject::Comparison LDAP_ModifyRequest_modifications_subtype_modification::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsDescendant(LDAP_ModifyRequest_modifications_subtype_modification::Class()), PInvalidCast);
#endif
  const LDAP_ModifyRequest_modifications_subtype_modification & other = (const LDAP_ModifyRequest_modifications_subtype_modification &)obj;

  Comparison result;

  if ((result = m_type.Compare(other.m_type)) != EqualTo)
    return result;
  if ((result = m_values.Compare(other.m_values)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX LDAP_ModifyRequest_modifications_subtype_modification::GetDataLength() const
{
  PINDEX length = 0;
  length += m_type.GetObjectLength();
  length += m_values.GetObjectLength();
  return length;
}


BOOL LDAP_ModifyRequest_modifications_subtype_modification::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_type.Decode(strm))
    return FALSE;
  if (!m_values.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void LDAP_ModifyRequest_modifications_subtype_modification::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_type.Encode(strm);
  m_values.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * LDAP_ModifyRequest_modifications_subtype_modification::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_ModifyRequest_modifications_subtype_modification::Class()), PInvalidCast);
#endif
  return new LDAP_ModifyRequest_modifications_subtype_modification(*this);
}


//
// BindRequest
//

LDAP_BindRequest::LDAP_BindRequest(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, FALSE, 0)
{
  m_version.SetConstraints(PASN_Object::FixedConstraint, 1, 127);
}


#ifndef PASN_NOPRINTON
void LDAP_BindRequest::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+10) << "version = " << setprecision(indent) << m_version << '\n';
  strm << setw(indent+7) << "name = " << setprecision(indent) << m_name << '\n';
  strm << setw(indent+17) << "authentication = " << setprecision(indent) << m_authentication << '\n';
  strm << setw(indent-1) << "}";
}
#endif


PObject::Comparison LDAP_BindRequest::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsDescendant(LDAP_BindRequest::Class()), PInvalidCast);
#endif
  const LDAP_BindRequest & other = (const LDAP_BindRequest &)obj;

  Comparison result;

  if ((result = m_version.Compare(other.m_version)) != EqualTo)
    return result;
  if ((result = m_name.Compare(other.m_name)) != EqualTo)
    return result;
  if ((result = m_authentication.Compare(other.m_authentication)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX LDAP_BindRequest::GetDataLength() const
{
  PINDEX length = 0;
  length += m_version.GetObjectLength();
  length += m_name.GetObjectLength();
  length += m_authentication.GetObjectLength();
  return length;
}


BOOL LDAP_BindRequest::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_version.Decode(strm))
    return FALSE;
  if (!m_name.Decode(strm))
    return FALSE;
  if (!m_authentication.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void LDAP_BindRequest::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_version.Encode(strm);
  m_name.Encode(strm);
  m_authentication.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * LDAP_BindRequest::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_BindRequest::Class()), PInvalidCast);
#endif
  return new LDAP_BindRequest(*this);
}


//
// BindResponse
//

LDAP_BindResponse::LDAP_BindResponse(unsigned tag, PASN_Object::TagClass tagClass)
  : LDAP_LDAPResult(tag, tagClass)
{
}


PObject * LDAP_BindResponse::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_BindResponse::Class()), PInvalidCast);
#endif
  return new LDAP_BindResponse(*this);
}


//
// SearchRequest
//

LDAP_SearchRequest::LDAP_SearchRequest(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, FALSE, 0)
{
  m_sizeLimit.SetConstraints(PASN_Object::FixedConstraint, 0, 65535);
  m_timeLimit.SetConstraints(PASN_Object::FixedConstraint, 0, 65535);
}


#ifndef PASN_NOPRINTON
void LDAP_SearchRequest::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+13) << "baseObject = " << setprecision(indent) << m_baseObject << '\n';
  strm << setw(indent+8) << "scope = " << setprecision(indent) << m_scope << '\n';
  strm << setw(indent+15) << "derefAliases = " << setprecision(indent) << m_derefAliases << '\n';
  strm << setw(indent+12) << "sizeLimit = " << setprecision(indent) << m_sizeLimit << '\n';
  strm << setw(indent+12) << "timeLimit = " << setprecision(indent) << m_timeLimit << '\n';
  strm << setw(indent+12) << "attrsOnly = " << setprecision(indent) << m_attrsOnly << '\n';
  strm << setw(indent+9) << "filter = " << setprecision(indent) << m_filter << '\n';
  strm << setw(indent+13) << "attributes = " << setprecision(indent) << m_attributes << '\n';
  strm << setw(indent-1) << "}";
}
#endif


PObject::Comparison LDAP_SearchRequest::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsDescendant(LDAP_SearchRequest::Class()), PInvalidCast);
#endif
  const LDAP_SearchRequest & other = (const LDAP_SearchRequest &)obj;

  Comparison result;

  if ((result = m_baseObject.Compare(other.m_baseObject)) != EqualTo)
    return result;
  if ((result = m_scope.Compare(other.m_scope)) != EqualTo)
    return result;
  if ((result = m_derefAliases.Compare(other.m_derefAliases)) != EqualTo)
    return result;
  if ((result = m_sizeLimit.Compare(other.m_sizeLimit)) != EqualTo)
    return result;
  if ((result = m_timeLimit.Compare(other.m_timeLimit)) != EqualTo)
    return result;
  if ((result = m_attrsOnly.Compare(other.m_attrsOnly)) != EqualTo)
    return result;
  if ((result = m_filter.Compare(other.m_filter)) != EqualTo)
    return result;
  if ((result = m_attributes.Compare(other.m_attributes)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX LDAP_SearchRequest::GetDataLength() const
{
  PINDEX length = 0;
  length += m_baseObject.GetObjectLength();
  length += m_scope.GetObjectLength();
  length += m_derefAliases.GetObjectLength();
  length += m_sizeLimit.GetObjectLength();
  length += m_timeLimit.GetObjectLength();
  length += m_attrsOnly.GetObjectLength();
  length += m_filter.GetObjectLength();
  length += m_attributes.GetObjectLength();
  return length;
}


BOOL LDAP_SearchRequest::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_baseObject.Decode(strm))
    return FALSE;
  if (!m_scope.Decode(strm))
    return FALSE;
  if (!m_derefAliases.Decode(strm))
    return FALSE;
  if (!m_sizeLimit.Decode(strm))
    return FALSE;
  if (!m_timeLimit.Decode(strm))
    return FALSE;
  if (!m_attrsOnly.Decode(strm))
    return FALSE;
  if (!m_filter.Decode(strm))
    return FALSE;
  if (!m_attributes.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void LDAP_SearchRequest::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_baseObject.Encode(strm);
  m_scope.Encode(strm);
  m_derefAliases.Encode(strm);
  m_sizeLimit.Encode(strm);
  m_timeLimit.Encode(strm);
  m_attrsOnly.Encode(strm);
  m_filter.Encode(strm);
  m_attributes.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * LDAP_SearchRequest::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_SearchRequest::Class()), PInvalidCast);
#endif
  return new LDAP_SearchRequest(*this);
}


//
// ModifyRequest
//

LDAP_ModifyRequest::LDAP_ModifyRequest(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, FALSE, 0)
{
}


#ifndef PASN_NOPRINTON
void LDAP_ModifyRequest::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+9) << "object = " << setprecision(indent) << m_object << '\n';
  strm << setw(indent+16) << "modifications = " << setprecision(indent) << m_modifications << '\n';
  strm << setw(indent-1) << "}";
}
#endif


PObject::Comparison LDAP_ModifyRequest::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsDescendant(LDAP_ModifyRequest::Class()), PInvalidCast);
#endif
  const LDAP_ModifyRequest & other = (const LDAP_ModifyRequest &)obj;

  Comparison result;

  if ((result = m_object.Compare(other.m_object)) != EqualTo)
    return result;
  if ((result = m_modifications.Compare(other.m_modifications)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX LDAP_ModifyRequest::GetDataLength() const
{
  PINDEX length = 0;
  length += m_object.GetObjectLength();
  length += m_modifications.GetObjectLength();
  return length;
}


BOOL LDAP_ModifyRequest::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_object.Decode(strm))
    return FALSE;
  if (!m_modifications.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void LDAP_ModifyRequest::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_object.Encode(strm);
  m_modifications.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * LDAP_ModifyRequest::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_ModifyRequest::Class()), PInvalidCast);
#endif
  return new LDAP_ModifyRequest(*this);
}


//
// ModifyResponse
//

LDAP_ModifyResponse::LDAP_ModifyResponse(unsigned tag, PASN_Object::TagClass tagClass)
  : LDAP_LDAPResult(tag, tagClass)
{
}


PObject * LDAP_ModifyResponse::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_ModifyResponse::Class()), PInvalidCast);
#endif
  return new LDAP_ModifyResponse(*this);
}


//
// AddRequest
//

LDAP_AddRequest::LDAP_AddRequest(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, FALSE, 0)
{
}


#ifndef PASN_NOPRINTON
void LDAP_AddRequest::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+8) << "entry = " << setprecision(indent) << m_entry << '\n';
  strm << setw(indent+8) << "attrs = " << setprecision(indent) << m_attrs << '\n';
  strm << setw(indent-1) << "}";
}
#endif


PObject::Comparison LDAP_AddRequest::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsDescendant(LDAP_AddRequest::Class()), PInvalidCast);
#endif
  const LDAP_AddRequest & other = (const LDAP_AddRequest &)obj;

  Comparison result;

  if ((result = m_entry.Compare(other.m_entry)) != EqualTo)
    return result;
  if ((result = m_attrs.Compare(other.m_attrs)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX LDAP_AddRequest::GetDataLength() const
{
  PINDEX length = 0;
  length += m_entry.GetObjectLength();
  length += m_attrs.GetObjectLength();
  return length;
}


BOOL LDAP_AddRequest::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_entry.Decode(strm))
    return FALSE;
  if (!m_attrs.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void LDAP_AddRequest::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_entry.Encode(strm);
  m_attrs.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * LDAP_AddRequest::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_AddRequest::Class()), PInvalidCast);
#endif
  return new LDAP_AddRequest(*this);
}


//
// AddResponse
//

LDAP_AddResponse::LDAP_AddResponse(unsigned tag, PASN_Object::TagClass tagClass)
  : LDAP_LDAPResult(tag, tagClass)
{
}


PObject * LDAP_AddResponse::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_AddResponse::Class()), PInvalidCast);
#endif
  return new LDAP_AddResponse(*this);
}


//
// DelRequest
//

LDAP_DelRequest::LDAP_DelRequest(unsigned tag, PASN_Object::TagClass tagClass)
  : LDAP_LDAPDN(tag, tagClass)
{
}


LDAP_DelRequest & LDAP_DelRequest::operator=(const char * v)
{
  SetValue(v);
  return *this;
}


LDAP_DelRequest & LDAP_DelRequest::operator=(const PString & v)
{
  SetValue(v);
  return *this;
}


LDAP_DelRequest & LDAP_DelRequest::operator=(const PBYTEArray & v)
{
  SetValue(v);
  return *this;
}


PObject * LDAP_DelRequest::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_DelRequest::Class()), PInvalidCast);
#endif
  return new LDAP_DelRequest(*this);
}


//
// DelResponse
//

LDAP_DelResponse::LDAP_DelResponse(unsigned tag, PASN_Object::TagClass tagClass)
  : LDAP_LDAPResult(tag, tagClass)
{
}


PObject * LDAP_DelResponse::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_DelResponse::Class()), PInvalidCast);
#endif
  return new LDAP_DelResponse(*this);
}


//
// ModifyRDNRequest
//

LDAP_ModifyRDNRequest::LDAP_ModifyRDNRequest(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, FALSE, 0)
{
}


#ifndef PASN_NOPRINTON
void LDAP_ModifyRDNRequest::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+8) << "entry = " << setprecision(indent) << m_entry << '\n';
  strm << setw(indent+9) << "newrdn = " << setprecision(indent) << m_newrdn << '\n';
  strm << setw(indent-1) << "}";
}
#endif


PObject::Comparison LDAP_ModifyRDNRequest::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsDescendant(LDAP_ModifyRDNRequest::Class()), PInvalidCast);
#endif
  const LDAP_ModifyRDNRequest & other = (const LDAP_ModifyRDNRequest &)obj;

  Comparison result;

  if ((result = m_entry.Compare(other.m_entry)) != EqualTo)
    return result;
  if ((result = m_newrdn.Compare(other.m_newrdn)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX LDAP_ModifyRDNRequest::GetDataLength() const
{
  PINDEX length = 0;
  length += m_entry.GetObjectLength();
  length += m_newrdn.GetObjectLength();
  return length;
}


BOOL LDAP_ModifyRDNRequest::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_entry.Decode(strm))
    return FALSE;
  if (!m_newrdn.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void LDAP_ModifyRDNRequest::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_entry.Encode(strm);
  m_newrdn.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * LDAP_ModifyRDNRequest::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_ModifyRDNRequest::Class()), PInvalidCast);
#endif
  return new LDAP_ModifyRDNRequest(*this);
}


//
// ModifyRDNResponse
//

LDAP_ModifyRDNResponse::LDAP_ModifyRDNResponse(unsigned tag, PASN_Object::TagClass tagClass)
  : LDAP_LDAPResult(tag, tagClass)
{
}


PObject * LDAP_ModifyRDNResponse::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_ModifyRDNResponse::Class()), PInvalidCast);
#endif
  return new LDAP_ModifyRDNResponse(*this);
}


//
// CompareRequest
//

LDAP_CompareRequest::LDAP_CompareRequest(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, FALSE, 0)
{
}


#ifndef PASN_NOPRINTON
void LDAP_CompareRequest::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+8) << "entry = " << setprecision(indent) << m_entry << '\n';
  strm << setw(indent+6) << "ava = " << setprecision(indent) << m_ava << '\n';
  strm << setw(indent-1) << "}";
}
#endif


PObject::Comparison LDAP_CompareRequest::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsDescendant(LDAP_CompareRequest::Class()), PInvalidCast);
#endif
  const LDAP_CompareRequest & other = (const LDAP_CompareRequest &)obj;

  Comparison result;

  if ((result = m_entry.Compare(other.m_entry)) != EqualTo)
    return result;
  if ((result = m_ava.Compare(other.m_ava)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX LDAP_CompareRequest::GetDataLength() const
{
  PINDEX length = 0;
  length += m_entry.GetObjectLength();
  length += m_ava.GetObjectLength();
  return length;
}


BOOL LDAP_CompareRequest::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_entry.Decode(strm))
    return FALSE;
  if (!m_ava.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void LDAP_CompareRequest::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_entry.Encode(strm);
  m_ava.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * LDAP_CompareRequest::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_CompareRequest::Class()), PInvalidCast);
#endif
  return new LDAP_CompareRequest(*this);
}


//
// CompareResponse
//

LDAP_CompareResponse::LDAP_CompareResponse(unsigned tag, PASN_Object::TagClass tagClass)
  : LDAP_LDAPResult(tag, tagClass)
{
}


PObject * LDAP_CompareResponse::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_CompareResponse::Class()), PInvalidCast);
#endif
  return new LDAP_CompareResponse(*this);
}


//
// ModifyRequest_modifications_subtype
//

LDAP_ModifyRequest_modifications_subtype::LDAP_ModifyRequest_modifications_subtype(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, FALSE, 0)
{
}


#ifndef PASN_NOPRINTON
void LDAP_ModifyRequest_modifications_subtype::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+12) << "operation = " << setprecision(indent) << m_operation << '\n';
  strm << setw(indent+15) << "modification = " << setprecision(indent) << m_modification << '\n';
  strm << setw(indent-1) << "}";
}
#endif


PObject::Comparison LDAP_ModifyRequest_modifications_subtype::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsDescendant(LDAP_ModifyRequest_modifications_subtype::Class()), PInvalidCast);
#endif
  const LDAP_ModifyRequest_modifications_subtype & other = (const LDAP_ModifyRequest_modifications_subtype &)obj;

  Comparison result;

  if ((result = m_operation.Compare(other.m_operation)) != EqualTo)
    return result;
  if ((result = m_modification.Compare(other.m_modification)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX LDAP_ModifyRequest_modifications_subtype::GetDataLength() const
{
  PINDEX length = 0;
  length += m_operation.GetObjectLength();
  length += m_modification.GetObjectLength();
  return length;
}


BOOL LDAP_ModifyRequest_modifications_subtype::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_operation.Decode(strm))
    return FALSE;
  if (!m_modification.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void LDAP_ModifyRequest_modifications_subtype::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_operation.Encode(strm);
  m_modification.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * LDAP_ModifyRequest_modifications_subtype::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(LDAP_ModifyRequest_modifications_subtype::Class()), PInvalidCast);
#endif
  return new LDAP_ModifyRequest_modifications_subtype(*this);
}



// End of ldap_asn.cxx
