// Copyright (C) 2001 Nils Bokermann <Nils.Bokermann@mediaWays.net>
//
// PURPOSE OF THIS FILE: Implement the ldap_add functions
//
// - Automatic Version Information via RCS:
//   $Id: add.cxx,v 1.1 2001/12/17 16:36:17 nilsb Exp $
//   $Source: /cvsroot/openh323gk/openh323gk/ldap/src/add.cxx,v $
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "ldapapi.h"
#include <ldap-int.h>

#ifndef lint
// mark object with version info
static const char vcid[] = "@(#) $Id: add.cxx,v 1.1 2001/12/17 16:36:17 nilsb Exp $";
static const char vcHid[] = __LDAP_OPENH323_H;
#endif

int ldap_add_ext (LDAP *ld, LDAP_CONST char *dn, LDAPMod **attrs, LDAPControl **serverctrls,
		  LDAPControl **clientctrls, int *msgidp) {
  LDAP_LDAPMessage msg;
  
  *msgidp=++(ld->msg_id);
  msg.m_messageID=*msgidp;
  msg.m_protocolOp=LDAP_LDAPMessage_protocolOp(LDAP_LDAPMessage_protocolOp::e_addRequest);
  LDAP_AddRequest &add=msg.m_protocolOp;
  add.m_entry=dn;

  LDAP_AddRequest_attrs &addattr=add.m_attrs;

  LDAPMod **mod=attrs;

  for(unsigned int number=0;NULL!=*mod;number++) {
    if(addattr.GetSize()<=number)
      addattr.SetSize(number+1);
    if((*mod)->mod_op & LDAP_MOD_BVALUES) { // mod_bvalue 
      addattr[number].m_type=(*mod)->mod_type;
      for(unsigned int attribute=0;NULL!=(*mod)->mod_bvalues[attribute];attribute++){
	if(addattr[number].m_values.GetSize()<=attribute)
	  addattr[number].m_values.SetSize(attribute+1);
	addattr[number].m_values[attribute].SetValue(PASN_OctetString((*mod)->mod_bvalues[attribute]->bv_val,
								      (*mod)->mod_bvalues[attribute]->bv_len));
      }
    } else {
      addattr[number].m_type=(*mod)->mod_type;
      for(unsigned int attribute=0;NULL!=(*mod)->mod_values[attribute];attribute++){
	if(addattr[number].m_values.GetSize()<=attribute)
	  addattr[number].m_values.SetSize(attribute+1);
	addattr[number].m_values[attribute]=(*mod)->mod_values[attribute];
      }
    }
    mod++;
  }

  PBER_Stream encoding_stream;
  msg.Encode(encoding_stream) ;
  if(encoding_stream.Write(*(ld->socket))) {
    return LDAP_SUCCESS;
  }
  ld->ld_errno=LDAP_UNAVAILABLE;
  return ld->ld_errno;
}


int ldap_add_ext_s (LDAP *ld, LDAP_CONST char *dn, LDAPMod **attrs,
		    LDAPControl **serverctrls, LDAPControl **clientctrls) {
  int msgid;
  int rv;
  LDAPMessage *result;
  if(-1==(rv=ldap_add_ext(ld, dn, attrs, serverctrls, clientctrls, &msgid))) {
    ld->ld_error=-1;
    return rv;
  }
  
  if (-1==ldap_result(ld, msgid, 1, NULL, &result)) {
    return(ld->ld_errno);
  }
    
  rv = ldap_result2error(ld, result, 0);
  ldap_msgfree(result);
  return rv;
}

int ldap_add (LDAP *ld, LDAP_CONST char *dn, LDAPMod **attrs) {
  int msgid;
  int rv;
  if(LDAP_SUCCESS!=(rv=ldap_add_ext(ld, dn, attrs, NULL, NULL, &msgid))) {
    ld->ld_errno=rv;
    return -1;
  }
  return msgid;
}

int ldap_add_s (LDAP *ld, LDAP_CONST char *dn, LDAPMod **attrs) {
  int msgid;
  LDAPMessage *result;
  if(-1==(msgid=ldap_add(ld,dn,attrs))) {
    return ld->ld_errno;
  }
  if (-1==ldap_result(ld, msgid, 1, NULL, &result)) {
    return(ld->ld_errno);
  }
    
  msgid = ldap_result2error(ld, result, 0);
  ldap_msgfree(result);
  return msgid;
}

  
//
// End of add.cxx
//
