#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# GRSources.py
#
# DESCRIPTION:
# Class
#
# NOTES:
#


from gnue.common.definitions.GObjects import *
from gnue.common.datasources import GDataSource
from gnue.common.datasources.GConditions import GCondition
from gnue.common.apps import GDebug
import GRExceptions

class GRSources (GObj):
  def __init__(self, parent):
    GObj.__init__(self, parent, type='GRSources')


  #
  # Prepare for running
  #
  # TODO: please go bye-bye
  def prepare(self, parameters, sortoptions):

    self._parameters = parameters
    self._sortoptions = sortoptions

    # Connect to databases
    self._datasourceDictionary = {}


  def getDataSource(self, source):
    return self.getParent ()._datasourceDictionary[string.lower(source)]


class GRDataSource (GDataSource.GDataSource):
  def __init__(self, parent):
    GDataSource.GDataSource.__init__(self, parent, 'GRDataSource')
    self._toplevelParent = 'GRReport'
    self.master = None


class GRConditions(GCondition):
  def __init__(self, parent):
    GCondition.__init__(self, parent, 'GRConditions')

